/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.TimeLineView;
import com.android.traceview.TraceAction;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadData
implements TimeLineView.Row {
    private int mId;
    private String mName;
    private boolean mIsEmpty;
    private Call mRootCall;
    private ArrayList<Call> mStack = new ArrayList();
    private HashMap<MethodData, Integer> mStackMethods = new HashMap();
    boolean mHaveGlobalTime;
    long mGlobalStartTime;
    long mGlobalEndTime;
    boolean mHaveThreadTime;
    long mThreadStartTime;
    long mThreadEndTime;
    long mThreadCurrentTime;

    ThreadData(int n, String string, MethodData methodData) {
        this.mId = n;
        this.mName = String.format("[%d] %s", n, string);
        this.mIsEmpty = true;
        this.mRootCall = new Call(this, methodData, null);
        this.mRootCall.setName(this.mName);
        this.mStack.add(this.mRootCall);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public Call getRootCall() {
        return this.mRootCall;
    }

    public boolean isEmpty() {
        return this.mIsEmpty;
    }

    Call enter(MethodData methodData, ArrayList<TraceAction> arrayList) {
        Integer n;
        if (this.mIsEmpty) {
            this.mIsEmpty = false;
            if (arrayList != null) {
                arrayList.add(new TraceAction(0, this.mRootCall));
            }
        }
        Call call = this.top();
        Call call2 = new Call(this, methodData, call);
        this.mStack.add(call2);
        if (arrayList != null) {
            arrayList.add(new TraceAction(0, call2));
        }
        if ((n = this.mStackMethods.get(methodData)) == null) {
            n = 0;
        } else if (n > 0) {
            call2.setRecursive(true);
        }
        this.mStackMethods.put(methodData, n + 1);
        return call2;
    }

    Call exit(MethodData methodData, ArrayList<TraceAction> arrayList) {
        Integer n;
        Call call = this.top();
        if (call.mCaller == null) {
            return null;
        }
        if (call.getMethodData() != methodData) {
            String string = "Method exit (" + methodData.getName() + ") does not match current method (" + call.getMethodData().getName() + ")";
            throw new RuntimeException(string);
        }
        this.mStack.remove(this.mStack.size() - 1);
        if (arrayList != null) {
            arrayList.add(new TraceAction(1, call));
        }
        if ((n = this.mStackMethods.get(methodData)) != null) {
            if (n == 1) {
                this.mStackMethods.remove(methodData);
            } else {
                this.mStackMethods.put(methodData, n - 1);
            }
        }
        return call;
    }

    Call top() {
        return this.mStack.get(this.mStack.size() - 1);
    }

    void endTrace(ArrayList<TraceAction> arrayList) {
        for (int i = this.mStack.size() - 1; i >= 1; --i) {
            Call call = this.mStack.get(i);
            call.mGlobalEndTime = this.mGlobalEndTime;
            call.mThreadEndTime = this.mThreadEndTime;
            if (arrayList == null) continue;
            arrayList.add(new TraceAction(2, call));
        }
        this.mStack.clear();
        this.mStackMethods.clear();
    }

    void updateRootCallTimeBounds() {
        if (!this.mIsEmpty) {
            this.mRootCall.mGlobalStartTime = this.mGlobalStartTime;
            this.mRootCall.mGlobalEndTime = this.mGlobalEndTime;
            this.mRootCall.mThreadStartTime = this.mThreadStartTime;
            this.mRootCall.mThreadEndTime = this.mThreadEndTime;
        }
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public int getId() {
        return this.mId;
    }

    public long getCpuTime() {
        return this.mRootCall.mInclusiveCpuTime;
    }

    public long getRealTime() {
        return this.mRootCall.mInclusiveRealTime;
    }
}

