/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import java.text.DecimalFormat;

public class TraceUnits {
    private TimeScale mTimeScale = TimeScale.MicroSeconds;
    private double mScale = 1.0;
    DecimalFormat mFormatter = new DecimalFormat();

    public double getScaledValue(long l) {
        return (double)l * this.mScale;
    }

    public double getScaledValue(double d) {
        return d * this.mScale;
    }

    public String valueOf(long l) {
        return this.valueOf((double)l);
    }

    public String valueOf(double d) {
        double d2 = d * this.mScale;
        String string = (double)((int)d2) == d2 ? "###,###" : "###,###.###";
        this.mFormatter.applyPattern(string);
        return this.mFormatter.format(d2);
    }

    public String labelledString(double d) {
        String string = this.label();
        String string2 = this.valueOf(d);
        return String.format("%s: %s", string, string2);
    }

    public String labelledString(long l) {
        return this.labelledString((double)l);
    }

    public String label() {
        if (this.mScale == 1.0) {
            return "usec";
        }
        if (this.mScale == 0.001) {
            return "msec";
        }
        if (this.mScale == 1.0E-6) {
            return "sec";
        }
        return null;
    }

    public void setTimeScale(TimeScale timeScale) {
        this.mTimeScale = timeScale;
        switch (timeScale) {
            case Seconds: {
                this.mScale = 1.0E-6;
                break;
            }
            case MilliSeconds: {
                this.mScale = 0.001;
                break;
            }
            case MicroSeconds: {
                this.mScale = 1.0;
            }
        }
    }

    public TimeScale getTimeScale() {
        return this.mTimeScale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeScale {
        Seconds,
        MilliSeconds,
        MicroSeconds;

    }
}

