/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.io.File;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugBridge {
    private static AndroidDebugBridge sDebugBridge;

    private static String getAdbLocation() {
        String string = System.getProperty("com.android.uiautomator.bindir");
        if (string == null) {
            return null;
        }
        File file = new File(string).getParentFile();
        File file2 = new File(file, "platform-tools");
        File file3 = new File(file2, SdkConstants.FN_ADB);
        if (file3.exists()) {
            return file3.getAbsolutePath();
        }
        file3 = new File(string, SdkConstants.FN_ADB);
        if (file3.exists()) {
            return file3.getAbsolutePath();
        }
        return null;
    }

    public static void init() {
        String string = DebugBridge.getAdbLocation();
        if (string != null) {
            AndroidDebugBridge.init((boolean)false);
            sDebugBridge = AndroidDebugBridge.createBridge((String)string, (boolean)false);
        }
    }

    public static void terminate() {
        if (sDebugBridge != null) {
            sDebugBridge = null;
            AndroidDebugBridge.terminate();
        }
    }

    public static boolean isInitialized() {
        return sDebugBridge != null;
    }

    public static List<IDevice> getDevices() {
        return Arrays.asList(sDebugBridge.getDevices());
    }
}

