/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenDialog
extends Dialog {
    private static final int FIXED_TEXT_FIELD_WIDTH = 300;
    private static final int DEFAULT_LAYOUT_SPACING = 10;
    private Text mScreenshotText;
    private Text mXmlText;
    private boolean mFileChanged = false;
    private Button mOkButton;
    private static File sScreenshotFile;
    private static File sXmlDumpFile;

    public OpenDialog(Shell shell) {
        super(shell);
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group.setText("Screenshot");
        this.mScreenshotText = new Text((Composite)group, 2056);
        if (sScreenshotFile != null) {
            this.mScreenshotText.setText(sScreenshotFile.getAbsolutePath());
        }
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.minimumWidth = 300;
        gridData.widthHint = 300;
        this.mScreenshotText.setLayoutData((Object)gridData);
        Button button = new Button((Composite)group, 0);
        button.setText("...");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenDialog.this.handleOpenScreenshotFile();
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group2.setText("UI XML Dump");
        group2.setLayout((Layout)new GridLayout(2, false));
        this.mXmlText = new Text((Composite)group2, 2056);
        this.mXmlText.setEditable(false);
        if (sXmlDumpFile != null) {
            this.mXmlText.setText(sXmlDumpFile.getAbsolutePath());
        }
        GridData gridData2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData2.minimumWidth = 300;
        gridData2.widthHint = 300;
        this.mXmlText.setLayoutData((Object)gridData2);
        Button button2 = new Button((Composite)group2, 0);
        button2.setText("...");
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OpenDialog.this.handleOpenXmlDumpFile();
            }
        });
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.mOkButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtonState();
    }

    protected Point getInitialSize() {
        return new Point(368, 233);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Open UI Dump Files");
    }

    private void handleOpenScreenshotFile() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Open Screenshot File");
        File file = sScreenshotFile;
        if (file == null && sXmlDumpFile != null && sXmlDumpFile.isFile()) {
            file = sXmlDumpFile.getParentFile();
        }
        if (file != null) {
            if (file.isFile()) {
                fileDialog.setFileName(file.getAbsolutePath());
            } else if (file.isDirectory()) {
                fileDialog.setFilterPath(file.getAbsolutePath());
            }
        }
        String[] stringArray = new String[]{"*.png"};
        fileDialog.setFilterExtensions(stringArray);
        String string = fileDialog.open();
        if (string != null) {
            sScreenshotFile = new File(string);
            this.mScreenshotText.setText(string);
            this.mFileChanged = true;
        }
        this.updateButtonState();
    }

    private void handleOpenXmlDumpFile() {
        String string;
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Open UI Dump XML File");
        File file = sXmlDumpFile;
        if (file == null && sScreenshotFile != null && sScreenshotFile.isFile()) {
            file = sScreenshotFile.getParentFile();
        }
        if (file != null) {
            if (file.isFile()) {
                fileDialog.setFileName(file.getAbsolutePath());
            } else if (file.isDirectory()) {
                fileDialog.setFilterPath(file.getAbsolutePath());
            }
        }
        if ((string = this.mXmlText.getText()).isEmpty() && sScreenshotFile != null && sScreenshotFile.isFile()) {
            string = sScreenshotFile.getParentFile().getAbsolutePath();
        }
        String[] stringArray = new String[]{"*.uix"};
        fileDialog.setFilterExtensions(stringArray);
        String string2 = fileDialog.open();
        if (string2 != null) {
            sXmlDumpFile = new File(string2);
            this.mXmlText.setText(string2);
            this.mFileChanged = true;
        }
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.mOkButton.setEnabled(sXmlDumpFile != null && sXmlDumpFile.isFile());
    }

    public boolean hasFileChanged() {
        return this.mFileChanged;
    }

    public File getScreenshotFile() {
        return sScreenshotFile;
    }

    public File getXmlDumpFile() {
        return sXmlDumpFile;
    }
}

