/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator;

import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.UiHierarchyXmlLoader;
import com.android.uiautomator.tree.UiNode;
import java.io.File;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiAutomatorModel {
    private BasicTreeNode mRootNode;
    private BasicTreeNode mSelectedNode;
    private Rectangle mCurrentDrawingRect;
    private List<Rectangle> mNafNodes;
    private boolean mExploreMode = true;
    private boolean mShowNafNodes = false;

    public UiAutomatorModel(File file) {
        UiHierarchyXmlLoader uiHierarchyXmlLoader = new UiHierarchyXmlLoader();
        BasicTreeNode basicTreeNode = uiHierarchyXmlLoader.parseXml(file.getAbsolutePath());
        if (basicTreeNode == null) {
            System.err.println("null rootnode after parsing.");
            throw new IllegalArgumentException("Invalid ui automator hierarchy file.");
        }
        this.mNafNodes = uiHierarchyXmlLoader.getNafNodes();
        if (this.mRootNode != null) {
            this.mRootNode.clearAllChildren();
        }
        this.mRootNode = basicTreeNode;
        this.mExploreMode = true;
    }

    public BasicTreeNode getXmlRootNode() {
        return this.mRootNode;
    }

    public BasicTreeNode getSelectedNode() {
        return this.mSelectedNode;
    }

    public void setSelectedNode(BasicTreeNode basicTreeNode) {
        this.mSelectedNode = basicTreeNode;
        if (this.mSelectedNode instanceof UiNode) {
            UiNode uiNode = (UiNode)this.mSelectedNode;
            this.mCurrentDrawingRect = new Rectangle(uiNode.x, uiNode.y, uiNode.width, uiNode.height);
        } else {
            this.mCurrentDrawingRect = null;
        }
    }

    public Rectangle getCurrentDrawingRect() {
        return this.mCurrentDrawingRect;
    }

    public BasicTreeNode updateSelectionForCoordinates(int n, int n2) {
        MinAreaFindNodeListener minAreaFindNodeListener;
        boolean bl;
        BasicTreeNode basicTreeNode = null;
        if (this.mRootNode != null && (bl = this.mRootNode.findLeafMostNodesAtPoint(n, n2, minAreaFindNodeListener = new MinAreaFindNodeListener())) && minAreaFindNodeListener.mNode != null && !minAreaFindNodeListener.mNode.equals(this.mSelectedNode)) {
            basicTreeNode = minAreaFindNodeListener.mNode;
        }
        return basicTreeNode;
    }

    public boolean isExploreMode() {
        return this.mExploreMode;
    }

    public void toggleExploreMode() {
        this.mExploreMode = !this.mExploreMode;
    }

    public void setExploreMode(boolean bl) {
        this.mExploreMode = bl;
    }

    public List<Rectangle> getNafNodes() {
        return this.mNafNodes;
    }

    public void toggleShowNaf() {
        this.mShowNafNodes = !this.mShowNafNodes;
    }

    public boolean shouldShowNafNodes() {
        return this.mShowNafNodes;
    }

    private static class MinAreaFindNodeListener
    implements BasicTreeNode.IFindNodeListener {
        BasicTreeNode mNode = null;

        private MinAreaFindNodeListener() {
        }

        public void onFoundNode(BasicTreeNode basicTreeNode) {
            if (this.mNode == null) {
                this.mNode = basicTreeNode;
            } else if (basicTreeNode.height * basicTreeNode.width < this.mNode.height * this.mNode.width) {
                this.mNode = basicTreeNode;
            }
        }
    }
}

