/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.actions;

import com.android.uiautomator.OpenDialog;
import com.android.uiautomator.UiAutomatorModel;
import com.android.uiautomator.UiAutomatorViewer;
import com.android.uiautomator.actions.ImageHelper;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class OpenFilesAction
extends Action {
    private UiAutomatorViewer mViewer;

    public OpenFilesAction(UiAutomatorViewer uiAutomatorViewer) {
        super("&Open");
        this.mViewer = uiAutomatorViewer;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageHelper.loadImageDescriptorFromResource("images/open-folder.png");
    }

    public void run() {
        UiAutomatorModel uiAutomatorModel;
        OpenDialog openDialog = new OpenDialog(Display.getDefault().getActiveShell());
        if (openDialog.open() != 0) {
            return;
        }
        try {
            uiAutomatorModel = new UiAutomatorModel(openDialog.getXmlDumpFile());
        }
        catch (Exception exception) {
            return;
        }
        Image image = null;
        File file = openDialog.getScreenshotFile();
        if (file != null) {
            try {
                ImageData[] imageDataArray = new ImageLoader().load(file.getAbsolutePath());
                if (imageDataArray.length < 1) {
                    throw new RuntimeException("Unable to load image: " + file.getAbsolutePath());
                }
                image = new Image((Device)Display.getDefault(), imageDataArray[0]);
            }
            catch (Exception exception) {
                return;
            }
        }
        this.mViewer.setModel(uiAutomatorModel, openDialog.getXmlDumpFile(), image);
    }
}

