/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.tree;

import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.RootWindowNode;
import com.android.uiautomator.tree.UiNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiHierarchyXmlLoader {
    private BasicTreeNode mRootNode;
    private List<Rectangle> mNafNodes;

    public BasicTreeNode parseXml(String string) {
        this.mRootNode = null;
        this.mNafNodes = new ArrayList<Rectangle>();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        DefaultHandler defaultHandler = new DefaultHandler(){
            BasicTreeNode mParentNode;
            BasicTreeNode mWorkingNode;

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                boolean bl = false;
                this.mParentNode = this.mWorkingNode;
                if ("hierarchy".equals(string3)) {
                    int n = 0;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        if (!"rotation".equals(attributes.getQName(i))) continue;
                        try {
                            n = Integer.parseInt(attributes.getValue(i));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.mWorkingNode = new RootWindowNode(attributes.getValue("windowName"), n);
                    bl = true;
                } else if ("node".equals(string3)) {
                    UiNode uiNode = new UiNode();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        uiNode.addAtrribute(attributes.getQName(i), attributes.getValue(i));
                    }
                    this.mWorkingNode = uiNode;
                    bl = true;
                    String string4 = uiNode.getAttribute("NAF");
                    if ("true".equals(string4)) {
                        UiHierarchyXmlLoader.this.mNafNodes.add(new Rectangle(uiNode.x, uiNode.y, uiNode.width, uiNode.height));
                    }
                }
                if (bl) {
                    if (UiHierarchyXmlLoader.this.mRootNode == null) {
                        UiHierarchyXmlLoader.this.mRootNode = this.mWorkingNode;
                    }
                    if (this.mParentNode != null) {
                        this.mParentNode.addChild(this.mWorkingNode);
                    }
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if (this.mParentNode != null) {
                    this.mWorkingNode = this.mParentNode;
                    this.mParentNode = this.mParentNode.getParent();
                }
            }
        };
        try {
            sAXParser.parse(new File(string), defaultHandler);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return this.mRootNode;
    }

    public List<Rectangle> getNafNodes() {
        return Collections.unmodifiableList(this.mNafNodes);
    }
}

