/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.TimeInterpolator;

public abstract class Keyframe
implements Cloneable {
    public float mFraction;
    public Class mValueType;
    public TimeInterpolator mInterpolator = null;
    public boolean mHasValue = false;

    public static Keyframe ofInt(float fraction2, int value) {
        return new IntKeyframe(fraction2, value);
    }

    public static Keyframe ofInt(float fraction2) {
        return new IntKeyframe(fraction2);
    }

    public static Keyframe ofFloat(float fraction2, float value) {
        return new FloatKeyframe(fraction2, value);
    }

    public static Keyframe ofFloat(float fraction2) {
        return new FloatKeyframe(fraction2);
    }

    public static Keyframe ofObject(float fraction2, Object value) {
        return new ObjectKeyframe(fraction2, value);
    }

    public static Keyframe ofObject(float fraction2) {
        return new ObjectKeyframe(fraction2, null);
    }

    public boolean hasValue() {
        return this.mHasValue;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public float getFraction() {
        return this.mFraction;
    }

    public void setFraction(float fraction2) {
        this.mFraction = fraction2;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    public Class getType() {
        return this.mValueType;
    }

    public abstract Keyframe clone();

    public static class FloatKeyframe
    extends Keyframe {
        public float mValue;

        public FloatKeyframe(float fraction2, float value) {
            this.mFraction = fraction2;
            this.mValue = value;
            this.mValueType = Float.TYPE;
            this.mHasValue = true;
        }

        public FloatKeyframe(float fraction2) {
            this.mFraction = fraction2;
            this.mValueType = Float.TYPE;
        }

        public float getFloatValue() {
            return this.mValue;
        }

        public Object getValue() {
            return Float.valueOf(this.mValue);
        }

        public void setValue(Object value) {
            if (value != null && value.getClass() == Float.class) {
                this.mValue = ((Float)value).floatValue();
                this.mHasValue = true;
            }
        }

        public FloatKeyframe clone() {
            FloatKeyframe kfClone = new FloatKeyframe(this.getFraction(), this.mValue);
            kfClone.setInterpolator(this.getInterpolator());
            return kfClone;
        }
    }

    public static class IntKeyframe
    extends Keyframe {
        public int mValue;

        public IntKeyframe(float fraction2, int value) {
            this.mFraction = fraction2;
            this.mValue = value;
            this.mValueType = Integer.TYPE;
            this.mHasValue = true;
        }

        public IntKeyframe(float fraction2) {
            this.mFraction = fraction2;
            this.mValueType = Integer.TYPE;
        }

        public int getIntValue() {
            return this.mValue;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object value) {
            if (value != null && value.getClass() == Integer.class) {
                this.mValue = (Integer)value;
                this.mHasValue = true;
            }
        }

        public IntKeyframe clone() {
            IntKeyframe kfClone = new IntKeyframe(this.getFraction(), this.mValue);
            kfClone.setInterpolator(this.getInterpolator());
            return kfClone;
        }
    }

    public static class ObjectKeyframe
    extends Keyframe {
        public Object mValue;

        public ObjectKeyframe(float fraction2, Object value) {
            this.mFraction = fraction2;
            this.mValue = value;
            this.mHasValue = value != null;
            this.mValueType = this.mHasValue ? value.getClass() : Object.class;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object value) {
            this.mValue = value;
            this.mHasValue = value != null;
        }

        public ObjectKeyframe clone() {
            ObjectKeyframe kfClone = new ObjectKeyframe(this.getFraction(), this.mValue);
            kfClone.setInterpolator(this.getInterpolator());
            return kfClone;
        }
    }
}

