/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.IBackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.IBackupManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public abstract class BackupAgent
extends ContextWrapper {
    public static final String TAG = "BackupAgent";
    public static final boolean DEBUG = false;
    public final IBinder mBinder = new BackupServiceBinder(null).asBinder();

    public BackupAgent() {
        super(null);
    }

    public void onCreate() {
    }

    public void onDestroy() {
    }

    public abstract void onBackup(ParcelFileDescriptor var1, BackupDataOutput var2, ParcelFileDescriptor var3) throws IOException;

    public abstract void onRestore(BackupDataInput var1, int var2, ParcelFileDescriptor var3) throws IOException;

    public IBinder onBind() {
        return this.mBinder;
    }

    public void attach(Context context) {
        this.attachBaseContext(context);
    }

    public static class 1 {
    }

    public class BackupServiceBinder
    extends IBackupAgent.Stub {
        public static final String TAG = "BackupServiceBinder";

        public BackupServiceBinder() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doBackup(ParcelFileDescriptor oldState, ParcelFileDescriptor data, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            BackupDataOutput output = new BackupDataOutput(data.getFileDescriptor());
            try {
                try {
                    BackupAgent.this.onBackup(oldState, output, newState);
                }
                catch (IOException ex) {
                    Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                    throw new RuntimeException(ex);
                }
                catch (RuntimeException ex) {
                    Log.d(TAG, "onBackup (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                    throw ex;
                }
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                    throw throwable;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            try {}
            catch (RemoteException e) {}
            callbackBinder.opComplete(token);
            return;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doRestore(ParcelFileDescriptor data, int appVersionCode, ParcelFileDescriptor newState, int token, IBackupManager callbackBinder) throws RemoteException {
            long ident = Binder.clearCallingIdentity();
            BackupDataInput input = new BackupDataInput(data.getFileDescriptor());
            try {
                try {
                    BackupAgent.this.onRestore(input, appVersionCode, newState);
                }
                catch (IOException ex) {
                    Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                    throw new RuntimeException(ex);
                }
                catch (RuntimeException ex) {
                    Log.d(TAG, "onRestore (" + BackupAgent.this.getClass().getName() + ") threw", ex);
                    throw ex;
                }
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                Binder.restoreCallingIdentity(ident);
                try {
                    callbackBinder.opComplete(token);
                    throw throwable;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            try {}
            catch (RemoteException e) {}
            callbackBinder.opComplete(token);
            return;
        }

        public /* synthetic */ BackupServiceBinder(1 x1) {
            this();
        }
    }
}

