/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;

public abstract class AsyncQueryHandler
extends Handler {
    public static final String TAG = "AsyncQuery";
    public static final boolean localLOGV = false;
    public static final int EVENT_ARG_QUERY = 1;
    public static final int EVENT_ARG_INSERT = 2;
    public static final int EVENT_ARG_UPDATE = 3;
    public static final int EVENT_ARG_DELETE = 4;
    public final WeakReference<ContentResolver> mResolver;
    public static Looper sLooper = null;
    public Handler mWorkerThreadHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncQueryHandler(ContentResolver cr) {
        this.mResolver = new WeakReference<ContentResolver>(cr);
        Class<AsyncQueryHandler> clazz = AsyncQueryHandler.class;
        synchronized (AsyncQueryHandler.class) {
            if (sLooper == null) {
                HandlerThread thread = new HandlerThread("AsyncQueryWorker");
                thread.start();
                sLooper = thread.getLooper();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mWorkerThreadHandler = this.createHandler(sLooper);
            return;
        }
    }

    public Handler createHandler(Looper looper) {
        return new WorkerHandler(looper);
    }

    public void startQuery(int token, Object cookie, Uri uri, String[] projection, String selection, String[] selectionArgs, String orderBy) {
        Message msg = this.mWorkerThreadHandler.obtainMessage(token);
        msg.arg1 = 1;
        WorkerArgs args = new WorkerArgs();
        args.handler = this;
        args.uri = uri;
        args.projection = projection;
        args.selection = selection;
        args.selectionArgs = selectionArgs;
        args.orderBy = orderBy;
        args.cookie = cookie;
        msg.obj = args;
        this.mWorkerThreadHandler.sendMessage(msg);
    }

    public void cancelOperation(int token) {
        this.mWorkerThreadHandler.removeMessages(token);
    }

    public void startInsert(int token, Object cookie, Uri uri, ContentValues initialValues) {
        Message msg = this.mWorkerThreadHandler.obtainMessage(token);
        msg.arg1 = 2;
        WorkerArgs args = new WorkerArgs();
        args.handler = this;
        args.uri = uri;
        args.cookie = cookie;
        args.values = initialValues;
        msg.obj = args;
        this.mWorkerThreadHandler.sendMessage(msg);
    }

    public void startUpdate(int token, Object cookie, Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        Message msg = this.mWorkerThreadHandler.obtainMessage(token);
        msg.arg1 = 3;
        WorkerArgs args = new WorkerArgs();
        args.handler = this;
        args.uri = uri;
        args.cookie = cookie;
        args.values = values;
        args.selection = selection;
        args.selectionArgs = selectionArgs;
        msg.obj = args;
        this.mWorkerThreadHandler.sendMessage(msg);
    }

    public void startDelete(int token, Object cookie, Uri uri, String selection, String[] selectionArgs) {
        Message msg = this.mWorkerThreadHandler.obtainMessage(token);
        msg.arg1 = 4;
        WorkerArgs args = new WorkerArgs();
        args.handler = this;
        args.uri = uri;
        args.cookie = cookie;
        args.selection = selection;
        args.selectionArgs = selectionArgs;
        msg.obj = args;
        this.mWorkerThreadHandler.sendMessage(msg);
    }

    public void onQueryComplete(int token, Object cookie, Cursor cursor) {
    }

    public void onInsertComplete(int token, Object cookie, Uri uri) {
    }

    public void onUpdateComplete(int token, Object cookie, int result) {
    }

    public void onDeleteComplete(int token, Object cookie, int result) {
    }

    public void handleMessage(Message msg) {
        WorkerArgs args = (WorkerArgs)msg.obj;
        int token = msg.what;
        int event = msg.arg1;
        switch (event) {
            case 1: {
                this.onQueryComplete(token, args.cookie, (Cursor)args.result);
                break;
            }
            case 2: {
                this.onInsertComplete(token, args.cookie, (Uri)args.result);
                break;
            }
            case 3: {
                this.onUpdateComplete(token, args.cookie, (Integer)args.result);
                break;
            }
            case 4: {
                this.onDeleteComplete(token, args.cookie, (Integer)args.result);
            }
        }
    }

    public class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            ContentResolver resolver = (ContentResolver)AsyncQueryHandler.this.mResolver.get();
            if (resolver == null) {
                return;
            }
            WorkerArgs args = (WorkerArgs)msg.obj;
            int token = msg.what;
            int event = msg.arg1;
            switch (event) {
                case 1: {
                    Cursor cursor;
                    try {
                        cursor = resolver.query(args.uri, args.projection, args.selection, args.selectionArgs, args.orderBy);
                        if (cursor != null) {
                            cursor.getCount();
                        }
                    }
                    catch (Exception e) {
                        Log.w(AsyncQueryHandler.TAG, "Exception thrown during handling EVENT_ARG_QUERY", e);
                        cursor = null;
                    }
                    args.result = cursor;
                    break;
                }
                case 2: {
                    args.result = resolver.insert(args.uri, args.values);
                    break;
                }
                case 3: {
                    args.result = resolver.update(args.uri, args.values, args.selection, args.selectionArgs);
                    break;
                }
                case 4: {
                    args.result = resolver.delete(args.uri, args.selection, args.selectionArgs);
                }
            }
            Message reply = args.handler.obtainMessage(token);
            reply.obj = args;
            reply.arg1 = msg.arg1;
            reply.sendToTarget();
        }
    }

    public static class WorkerArgs {
        public Uri uri;
        public Handler handler;
        public String[] projection;
        public String selection;
        public String[] selectionArgs;
        public String orderBy;
        public Object result;
        public Object cookie;
        public ContentValues values;
    }
}

