/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Context;
import android.content.Loader;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.SystemClock;
import android.util.TimeUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncTaskLoader<D>
extends Loader<D> {
    public static final String TAG = "AsyncTaskLoader";
    public static final boolean DEBUG = false;
    public volatile LoadTask mTask;
    public volatile LoadTask mCancellingTask;
    public long mUpdateThrottle;
    public long mLastLoadCompleteTime = -10000L;
    public Handler mHandler;

    public AsyncTaskLoader(Context context) {
        super(context);
    }

    public void setUpdateThrottle(long delayMS) {
        this.mUpdateThrottle = delayMS;
        if (delayMS != 0L) {
            this.mHandler = new Handler();
        }
    }

    @Override
    public void onForceLoad() {
        super.onForceLoad();
        this.cancelLoad();
        this.mTask = new LoadTask();
        this.executePendingTask();
    }

    public boolean cancelLoad() {
        if (this.mTask != null) {
            if (this.mCancellingTask != null) {
                if (this.mTask.waiting) {
                    this.mTask.waiting = false;
                    this.mHandler.removeCallbacks(this.mTask);
                }
                this.mTask = null;
                return false;
            }
            if (this.mTask.waiting) {
                this.mTask.waiting = false;
                this.mHandler.removeCallbacks(this.mTask);
                this.mTask = null;
                return false;
            }
            boolean cancelled = this.mTask.cancel(false);
            if (cancelled) {
                this.mCancellingTask = this.mTask;
            }
            this.mTask = null;
            return cancelled;
        }
        return false;
    }

    public void onCanceled(D data) {
    }

    public void executePendingTask() {
        if (this.mCancellingTask == null && this.mTask != null) {
            long now;
            if (this.mTask.waiting) {
                this.mTask.waiting = false;
                this.mHandler.removeCallbacks(this.mTask);
            }
            if (this.mUpdateThrottle > 0L && (now = SystemClock.uptimeMillis()) < this.mLastLoadCompleteTime + this.mUpdateThrottle) {
                this.mTask.waiting = true;
                this.mHandler.postAtTime(this.mTask, this.mLastLoadCompleteTime + this.mUpdateThrottle);
                return;
            }
            this.mTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
        }
    }

    public void dispatchOnCancelled(LoadTask task, D data) {
        this.onCanceled(data);
        if (this.mCancellingTask == task) {
            this.mLastLoadCompleteTime = SystemClock.uptimeMillis();
            this.mCancellingTask = null;
            this.executePendingTask();
        }
    }

    public void dispatchOnLoadComplete(LoadTask task, D data) {
        if (this.mTask != task) {
            this.dispatchOnCancelled(task, data);
        } else if (this.isAbandoned()) {
            this.onCanceled(data);
        } else {
            this.mLastLoadCompleteTime = SystemClock.uptimeMillis();
            this.mTask = null;
            this.deliverResult(data);
        }
    }

    public abstract D loadInBackground();

    public D onLoadInBackground() {
        return this.loadInBackground();
    }

    public void waitForLoader() {
        LoadTask task = this.mTask;
        if (task != null) {
            try {
                task.done.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        if (this.mTask != null) {
            writer.print(prefix);
            writer.print("mTask=");
            writer.print(this.mTask);
            writer.print(" waiting=");
            writer.println(this.mTask.waiting);
        }
        if (this.mCancellingTask != null) {
            writer.print(prefix);
            writer.print("mCancellingTask=");
            writer.print(this.mCancellingTask);
            writer.print(" waiting=");
            writer.println(this.mCancellingTask.waiting);
        }
        if (this.mUpdateThrottle != 0L) {
            writer.print(prefix);
            writer.print("mUpdateThrottle=");
            TimeUtils.formatDuration(this.mUpdateThrottle, writer);
            writer.print(" mLastLoadCompleteTime=");
            TimeUtils.formatDuration(this.mLastLoadCompleteTime, SystemClock.uptimeMillis(), writer);
            writer.println();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LoadTask
    extends AsyncTask<Void, Void, D>
    implements Runnable {
        public D result;
        public boolean waiting;
        public CountDownLatch done = new CountDownLatch(1);

        public D doInBackground(Void ... params) {
            this.result = AsyncTaskLoader.this.onLoadInBackground();
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPostExecute(D data) {
            try {
                AsyncTaskLoader.this.dispatchOnLoadComplete(this, data);
                Object var3_2 = null;
                this.done.countDown();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.done.countDown();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCancelled() {
            try {
                AsyncTaskLoader.this.dispatchOnCancelled(this, this.result);
                Object var2_1 = null;
                this.done.countDown();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.done.countDown();
                throw throwable;
            }
        }

        @Override
        public void run() {
            this.waiting = false;
            AsyncTaskLoader.this.executePendingTask();
        }
    }
}

