/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;

public class SurfaceTexture {
    public EventHandler mEventHandler;
    public OnFrameAvailableListener mOnFrameAvailableListener;
    public int mSurfaceTexture;

    public SurfaceTexture(int texName) {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(looper) : null);
        this.nativeInit(texName, new WeakReference<SurfaceTexture>(this));
    }

    public void setOnFrameAvailableListener(OnFrameAvailableListener l) {
        this.mOnFrameAvailableListener = l;
    }

    public void updateTexImage() {
        this.nativeUpdateTexImage();
    }

    public void getTransformMatrix(float[] mtx) {
        if (mtx.length != 16) {
            throw new IllegalArgumentException();
        }
        this.nativeGetTransformMatrix(mtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.nativeFinalize();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public static void postEventFromNative(Object selfRef) {
        WeakReference weakSelf = (WeakReference)selfRef;
        SurfaceTexture st = (SurfaceTexture)weakSelf.get();
        if (st == null) {
            return;
        }
        if (st.mEventHandler != null) {
            Message m = st.mEventHandler.obtainMessage();
            st.mEventHandler.sendMessage(m);
        }
    }

    public void nativeInit(int n, Object object) {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeInit(ILjava/lang/Object;)V", true, this);
    }

    public void nativeFinalize() {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeFinalize()V", true, this);
    }

    public void nativeGetTransformMatrix(float[] fArray) {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeGetTransformMatrix([F)V", true, this);
    }

    public void nativeUpdateTexImage() {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeUpdateTexImage()V", true, this);
    }

    public static void nativeClassInit() {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeClassInit()V", true, null);
    }

    static {
        SurfaceTexture.nativeClassInit();
    }

    public class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (SurfaceTexture.this.mOnFrameAvailableListener != null) {
                SurfaceTexture.this.mOnFrameAvailableListener.onFrameAvailable(SurfaceTexture.this);
            }
        }
    }

    public static class OutOfResourcesException
    extends Exception {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }

    public static interface OnFrameAvailableListener {
        public void onFrameAvailable(SurfaceTexture var1);
    }
}

