/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.ProxyProperties;
import android.os.Binder;
import android.os.RemoteException;
import java.net.InetAddress;

public class ConnectivityManager {
    public static final String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_IS_FAILOVER = "isFailover";
    public static final String EXTRA_OTHER_NETWORK_INFO = "otherNetwork";
    public static final String EXTRA_NO_CONNECTIVITY = "noConnectivity";
    public static final String EXTRA_REASON = "reason";
    public static final String EXTRA_EXTRA_INFO = "extraInfo";
    public static final String EXTRA_INET_CONDITION = "inetCondition";
    public static final String ACTION_BACKGROUND_DATA_SETTING_CHANGED = "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED";
    public static final String INET_CONDITION_ACTION = "android.net.conn.INET_CONDITION_ACTION";
    public static final String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";
    public static final String EXTRA_AVAILABLE_TETHER = "availableArray";
    public static final String EXTRA_ACTIVE_TETHER = "activeArray";
    public static final String EXTRA_ERRORED_TETHER = "erroredArray";
    public static final int TYPE_MOBILE = 0;
    public static final int TYPE_WIFI = 1;
    public static final int TYPE_MOBILE_MMS = 2;
    public static final int TYPE_MOBILE_SUPL = 3;
    public static final int TYPE_MOBILE_DUN = 4;
    public static final int TYPE_MOBILE_HIPRI = 5;
    public static final int TYPE_WIMAX = 6;
    public static final int TYPE_BLUETOOTH = 7;
    public static final int TYPE_DUMMY = 8;
    public static final int TYPE_ETHERNET = 9;
    public static final int MAX_RADIO_TYPE = 8;
    public static final int MAX_NETWORK_TYPE = 8;
    public static final int DEFAULT_NETWORK_PREFERENCE = 1;
    public IConnectivityManager mService;
    public static final int TETHER_ERROR_NO_ERROR = 0;
    public static final int TETHER_ERROR_UNKNOWN_IFACE = 1;
    public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2;
    public static final int TETHER_ERROR_UNSUPPORTED = 3;
    public static final int TETHER_ERROR_UNAVAIL_IFACE = 4;
    public static final int TETHER_ERROR_MASTER_ERROR = 5;
    public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6;
    public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7;
    public static final int TETHER_ERROR_ENABLE_NAT_ERROR = 8;
    public static final int TETHER_ERROR_DISABLE_NAT_ERROR = 9;
    public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10;

    public static boolean isNetworkTypeValid(int networkType) {
        return networkType >= 0 && networkType <= 8;
    }

    public void setNetworkPreference(int preference) {
        try {
            this.mService.setNetworkPreference(preference);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getNetworkPreference() {
        try {
            return this.mService.getNetworkPreference();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public NetworkInfo getActiveNetworkInfo() {
        try {
            return this.mService.getActiveNetworkInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkInfo getNetworkInfo(int networkType) {
        try {
            return this.mService.getNetworkInfo(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NetworkInfo[] getAllNetworkInfo() {
        try {
            return this.mService.getAllNetworkInfo();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public LinkProperties getActiveLinkProperties() {
        try {
            return this.mService.getActiveLinkProperties();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public LinkProperties getLinkProperties(int networkType) {
        try {
            return this.mService.getLinkProperties(networkType);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean setRadios(boolean turnOn) {
        try {
            return this.mService.setRadios(turnOn);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setRadio(int networkType, boolean turnOn) {
        try {
            return this.mService.setRadio(networkType, turnOn);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public int startUsingNetworkFeature(int networkType, String feature) {
        try {
            return this.mService.startUsingNetworkFeature(networkType, feature, new Binder());
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int stopUsingNetworkFeature(int networkType, String feature) {
        try {
            return this.mService.stopUsingNetworkFeature(networkType, feature);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public boolean requestRouteToHost(int networkType, int hostAddress) {
        InetAddress inetAddress = NetworkUtils.intToInetAddress(hostAddress);
        if (inetAddress == null) {
            return false;
        }
        return this.requestRouteToHostAddress(networkType, inetAddress);
    }

    public boolean requestRouteToHostAddress(int networkType, InetAddress hostAddress) {
        byte[] address = hostAddress.getAddress();
        try {
            return this.mService.requestRouteToHostAddress(networkType, address);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean getBackgroundDataSetting() {
        try {
            return this.mService.getBackgroundDataSetting();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setBackgroundDataSetting(boolean allowBackgroundData) {
        try {
            this.mService.setBackgroundDataSetting(allowBackgroundData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean getMobileDataEnabled() {
        try {
            return this.mService.getMobileDataEnabled();
        }
        catch (RemoteException e) {
            return true;
        }
    }

    public void setMobileDataEnabled(boolean enabled) {
        try {
            this.mService.setMobileDataEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ConnectivityManager() {
    }

    public ConnectivityManager(IConnectivityManager service) {
        if (service == null) {
            throw new IllegalArgumentException("ConnectivityManager() cannot be constructed with null service");
        }
        this.mService = service;
    }

    public String[] getTetherableIfaces() {
        try {
            return this.mService.getTetherableIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetheredIfaces() {
        try {
            return this.mService.getTetheredIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetheringErroredIfaces() {
        try {
            return this.mService.getTetheringErroredIfaces();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public int tether(String iface) {
        try {
            return this.mService.tether(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public int untether(String iface) {
        try {
            return this.mService.untether(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public boolean isTetheringSupported() {
        try {
            return this.mService.isTetheringSupported();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public String[] getTetherableUsbRegexs() {
        try {
            return this.mService.getTetherableUsbRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetherableWifiRegexs() {
        try {
            return this.mService.getTetherableWifiRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public String[] getTetherableBluetoothRegexs() {
        try {
            return this.mService.getTetherableBluetoothRegexs();
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public int getLastTetherError(String iface) {
        try {
            return this.mService.getLastTetherError(iface);
        }
        catch (RemoteException e) {
            return 2;
        }
    }

    public boolean requestNetworkTransitionWakelock(String forWhom) {
        try {
            this.mService.requestNetworkTransitionWakelock(forWhom);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void reportInetCondition(int networkType, int percentage) {
        try {
            this.mService.reportInetCondition(networkType, percentage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setGlobalProxy(ProxyProperties p) {
        try {
            this.mService.setGlobalProxy(p);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ProxyProperties getGlobalProxy() {
        try {
            return this.mService.getGlobalProxy();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ProxyProperties getProxy() {
        try {
            return this.mService.getProxy();
        }
        catch (RemoteException e) {
            return null;
        }
    }
}

