/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.ProxyProperties;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkProperties
implements Parcelable {
    public String mIfaceName;
    public Collection<LinkAddress> mLinkAddresses;
    public Collection<InetAddress> mDnses;
    public InetAddress mGateway;
    public ProxyProperties mHttpProxy;
    public static final Parcelable.Creator<LinkProperties> CREATOR = new Parcelable.Creator<LinkProperties>(){

        @Override
        public LinkProperties createFromParcel(Parcel in) {
            int i;
            LinkProperties netProp = new LinkProperties();
            String iface = in.readString();
            if (iface != null) {
                try {
                    netProp.setInterfaceName(iface);
                }
                catch (Exception e) {
                    return null;
                }
            }
            int addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addLinkAddress((LinkAddress)in.readParcelable(null));
            }
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                try {
                    netProp.addDns(InetAddress.getByAddress(in.createByteArray()));
                    continue;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if (in.readByte() == 1) {
                try {
                    netProp.setGateway(InetAddress.getByAddress(in.createByteArray()));
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if (in.readByte() == 1) {
                netProp.setHttpProxy((ProxyProperties)in.readParcelable(null));
            }
            return netProp;
        }

        public LinkProperties[] newArray(int size) {
            return new LinkProperties[size];
        }
    };

    public LinkProperties() {
        this.clear();
    }

    public LinkProperties(LinkProperties source) {
        if (source != null) {
            this.mIfaceName = source.getInterfaceName();
            this.mLinkAddresses = source.getLinkAddresses();
            this.mDnses = source.getDnses();
            this.mGateway = source.getGateway();
            this.mHttpProxy = new ProxyProperties(source.getHttpProxy());
        }
    }

    public void setInterfaceName(String iface) {
        this.mIfaceName = iface;
    }

    public String getInterfaceName() {
        return this.mIfaceName;
    }

    public Collection<InetAddress> getAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        return Collections.unmodifiableCollection(addresses);
    }

    public void addLinkAddress(LinkAddress address) {
        this.mLinkAddresses.add(address);
    }

    public Collection<LinkAddress> getLinkAddresses() {
        return Collections.unmodifiableCollection(this.mLinkAddresses);
    }

    public void addDns(InetAddress dns) {
        this.mDnses.add(dns);
    }

    public Collection<InetAddress> getDnses() {
        return Collections.unmodifiableCollection(this.mDnses);
    }

    public void setGateway(InetAddress gateway) {
        this.mGateway = gateway;
    }

    public InetAddress getGateway() {
        return this.mGateway;
    }

    public void setHttpProxy(ProxyProperties proxy) {
        this.mHttpProxy = proxy;
    }

    public ProxyProperties getHttpProxy() {
        return this.mHttpProxy;
    }

    public void clear() {
        this.mIfaceName = null;
        this.mLinkAddresses = new ArrayList<LinkAddress>();
        this.mDnses = new ArrayList<InetAddress>();
        this.mGateway = null;
        this.mHttpProxy = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String ifaceName = this.mIfaceName == null ? "" : "InterfaceName: " + this.mIfaceName + " ";
        String linkAddresses = "LinkAddresses: [";
        for (LinkAddress addr : this.mLinkAddresses) {
            linkAddresses = linkAddresses + addr.toString();
        }
        linkAddresses = linkAddresses + "] ";
        String dns = "DnsAddresses: [";
        for (InetAddress addr : this.mDnses) {
            dns = dns + addr.getHostAddress() + ",";
        }
        dns = dns + "] ";
        String proxy = this.mHttpProxy == null ? "" : "HttpProxy: " + this.mHttpProxy.toString() + " ";
        String gateway = this.mGateway == null ? "" : "Gateway: " + this.mGateway.getHostAddress() + " ";
        return ifaceName + linkAddresses + gateway + dns + proxy;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getInterfaceName());
        dest.writeInt(this.mLinkAddresses.size());
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            dest.writeParcelable(linkAddress, flags);
        }
        dest.writeInt(this.mDnses.size());
        for (InetAddress d : this.mDnses) {
            dest.writeByteArray(d.getAddress());
        }
        if (this.mGateway != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mGateway.getAddress());
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mHttpProxy != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable(this.mHttpProxy, flags);
        } else {
            dest.writeByte((byte)0);
        }
    }
}

