/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.MemoryFile;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;

public class ParcelFileDescriptor
implements Parcelable {
    public final FileDescriptor mFileDescriptor;
    public boolean mClosed;
    public final ParcelFileDescriptor mParcelDescriptor;
    public static final int MODE_WORLD_READABLE = 1;
    public static final int MODE_WORLD_WRITEABLE = 2;
    public static final int MODE_READ_ONLY = 0x10000000;
    public static final int MODE_WRITE_ONLY = 0x20000000;
    public static final int MODE_READ_WRITE = 0x30000000;
    public static final int MODE_CREATE = 0x8000000;
    public static final int MODE_TRUNCATE = 0x4000000;
    public static final int MODE_APPEND = 0x2000000;
    public static final Parcelable.Creator<ParcelFileDescriptor> CREATOR = new Parcelable.Creator<ParcelFileDescriptor>(){

        @Override
        public ParcelFileDescriptor createFromParcel(Parcel in) {
            return in.readFileDescriptor();
        }

        public ParcelFileDescriptor[] newArray(int size) {
            return new ParcelFileDescriptor[size];
        }
    };

    public static ParcelFileDescriptor open(File file, int mode) throws FileNotFoundException {
        String path = file.getPath();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(path);
            if ((mode & 0x20000000) != 0) {
                security.checkWrite(path);
            }
        }
        if ((mode & 0x30000000) == 0) {
            throw new IllegalArgumentException("Must specify MODE_READ_ONLY, MODE_WRITE_ONLY, or MODE_READ_WRITE");
        }
        FileDescriptor fd = Parcel.openFileDescriptor(path, mode);
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    public static ParcelFileDescriptor fromSocket(Socket socket) {
        FileDescriptor fd = ParcelFileDescriptor.getFileDescriptorFromSocket(socket);
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    public static FileDescriptor getFileDescriptorFromSocket(Socket socket) {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.ParcelFileDescriptor#getFileDescriptorFromSocket(Ljava/net/Socket;)Ljava/io/FileDescriptor;", true, null);
    }

    public static ParcelFileDescriptor[] createPipe() throws IOException {
        FileDescriptor[] fds = new FileDescriptor[2];
        int res = ParcelFileDescriptor.createPipeNative(fds);
        if (res == 0) {
            ParcelFileDescriptor[] pfds = new ParcelFileDescriptor[]{new ParcelFileDescriptor(fds[0]), new ParcelFileDescriptor(fds[1])};
            return pfds;
        }
        throw new IOException("Unable to create pipe: errno=" + -res);
    }

    public static int createPipeNative(FileDescriptor[] fileDescriptorArray) {
        return OverrideMethod.invokeI("android.os.ParcelFileDescriptor#createPipeNative([Ljava/io/FileDescriptor;)I", true, null);
    }

    @Deprecated
    public static ParcelFileDescriptor fromData(byte[] data, String name) throws IOException {
        if (data == null) {
            return null;
        }
        MemoryFile file = new MemoryFile(name, data.length);
        if (data.length > 0) {
            file.writeBytes(data, 0, 0, data.length);
        }
        file.deactivate();
        FileDescriptor fd = file.getFileDescriptor();
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    public long getStatSize() {
        return OverrideMethod.invokeL("android.os.ParcelFileDescriptor#getStatSize()J", true, this);
    }

    public long seekTo(long l) {
        return OverrideMethod.invokeL("android.os.ParcelFileDescriptor#seekTo(J)J", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ParcelFileDescriptor parcelFileDescriptor = this;
        synchronized (parcelFileDescriptor) {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
        }
        if (this.mParcelDescriptor != null) {
            this.mParcelDescriptor.close();
        } else {
            Parcel.closeFileDescriptor(this.mFileDescriptor);
        }
    }

    public String toString() {
        return "{ParcelFileDescriptor: " + this.mFileDescriptor + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (!this.mClosed) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public ParcelFileDescriptor(ParcelFileDescriptor descriptor) {
        this.mParcelDescriptor = descriptor;
        this.mFileDescriptor = this.mParcelDescriptor.mFileDescriptor;
    }

    public ParcelFileDescriptor(FileDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor must not be null");
        }
        this.mFileDescriptor = descriptor;
        this.mParcelDescriptor = null;
    }

    public int describeContents() {
        return 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeFileDescriptor(this.mFileDescriptor);
        if ((flags & 1) != 0 && !this.mClosed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class AutoCloseOutputStream
    extends FileOutputStream {
        public final ParcelFileDescriptor mFd;

        public AutoCloseOutputStream(ParcelFileDescriptor fd) {
            super(fd.getFileDescriptor());
            this.mFd = fd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.mFd.close();
            }
            finally {
                super.close();
            }
        }
    }

    public static class AutoCloseInputStream
    extends FileInputStream {
        public final ParcelFileDescriptor mFd;

        public AutoCloseInputStream(ParcelFileDescriptor fd) {
            super(fd.getFileDescriptor());
            this.mFd = fd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.mFd.close();
            }
            finally {
                super.close();
            }
        }
    }
}

