/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class ProgramRaster
extends BaseObj {
    public boolean mPointSmooth = false;
    public boolean mLineSmooth = false;
    public boolean mPointSprite = false;
    public float mLineWidth = 1.0f;
    public CullMode mCullMode = CullMode.BACK;

    public ProgramRaster(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public void setLineWidth(float w) {
        this.mRS.validate();
        this.mLineWidth = w;
        this.mRS.nProgramRasterSetLineWidth(this.getID(), w);
    }

    public void setCullMode(CullMode m) {
        this.mRS.validate();
        this.mCullMode = m;
        this.mRS.nProgramRasterSetCullMode(this.getID(), m.mID);
    }

    public static ProgramRaster CULL_BACK(RenderScript rs) {
        if (rs.mProgramRaster_CULL_BACK == null) {
            Builder builder = new Builder(rs);
            builder.setCullMode(CullMode.BACK);
            rs.mProgramRaster_CULL_BACK = builder.create();
        }
        return rs.mProgramRaster_CULL_BACK;
    }

    public static ProgramRaster CULL_FRONT(RenderScript rs) {
        if (rs.mProgramRaster_CULL_FRONT == null) {
            Builder builder = new Builder(rs);
            builder.setCullMode(CullMode.FRONT);
            rs.mProgramRaster_CULL_FRONT = builder.create();
        }
        return rs.mProgramRaster_CULL_FRONT;
    }

    public static ProgramRaster CULL_NONE(RenderScript rs) {
        if (rs.mProgramRaster_CULL_NONE == null) {
            Builder builder = new Builder(rs);
            builder.setCullMode(CullMode.NONE);
            rs.mProgramRaster_CULL_NONE = builder.create();
        }
        return rs.mProgramRaster_CULL_NONE;
    }

    public static class Builder {
        public RenderScript mRS;
        public boolean mPointSprite;
        public boolean mPointSmooth;
        public boolean mLineSmooth;
        public CullMode mCullMode;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mPointSmooth = false;
            this.mLineSmooth = false;
            this.mPointSprite = false;
            this.mCullMode = CullMode.BACK;
        }

        public Builder setPointSpriteEnabled(boolean enable) {
            this.mPointSprite = enable;
            return this;
        }

        public Builder setCullMode(CullMode m) {
            this.mCullMode = m;
            return this;
        }

        public static synchronized ProgramRaster internalCreate(RenderScript rs, Builder b) {
            int id2 = rs.nProgramRasterCreate(b.mPointSmooth, b.mLineSmooth, b.mPointSprite);
            ProgramRaster pr = new ProgramRaster(id2, rs);
            pr.setCullMode(b.mCullMode);
            return pr;
        }

        public ProgramRaster create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CullMode {
        BACK(0),
        FRONT(1),
        NONE(2);

        public int mID;

        public CullMode(int id2) {
            this.mID = id2;
        }
    }
}

