/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.TabStopSpan;
import com.android.internal.util.ArrayUtils;

public class StaticLayout
extends Layout {
    public static final char FIRST_CJK = '\u2e80';
    public int mLineCount;
    public int mTopPadding;
    public int mBottomPadding;
    public int mColumns;
    public int mEllipsizedWidth;
    public static final int COLUMNS_NORMAL = 3;
    public static final int COLUMNS_ELLIPSIZE = 5;
    public static final int START = 0;
    public static final int DIR = 0;
    public static final int TAB = 0;
    public static final int TOP = 1;
    public static final int DESCENT = 2;
    public static final int ELLIPSIS_START = 3;
    public static final int ELLIPSIS_COUNT = 4;
    public int[] mLines;
    public Layout.Directions[] mLineDirections;
    public int mMaximumVisibleLineCount = 0;
    public static final int START_MASK = 0x1FFFFFFF;
    public static final int DIR_SHIFT = 30;
    public static final int TAB_MASK = 0x20000000;
    public static final int TAB_INCREMENT = 20;
    public MeasuredText mMeasured;
    public Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();

    public StaticLayout(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, 0, source.length(), paint, width, align, spacingmult, spacingadd, includepad);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, bufstart, bufend, paint, outerwidth, align, spacingmult, spacingadd, includepad, null, 0);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        super(ellipsize == null ? source : (source instanceof Spanned ? new Layout.SpannedEllipsizer(source) : new Layout.Ellipsizer(source)), paint, outerwidth, align, spacingmult, spacingadd);
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mColumns = 5;
        } else {
            this.mColumns = 3;
            this.mEllipsizedWidth = outerwidth;
        }
        this.mLines = new int[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mLineDirections = new Layout.Directions[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mMeasured = MeasuredText.obtain();
        this.generate(source, bufstart, bufend, paint, outerwidth, align, spacingmult, spacingadd, includepad, includepad, ellipsizedWidth, ellipsize);
        this.mMeasured = MeasuredText.recycle(this.mMeasured);
        this.mFontMetricsInt = null;
    }

    public StaticLayout(boolean ellipsize) {
        super(null, null, 0, null, 0.0f, 0.0f);
        this.mColumns = 5;
        this.mLines = new int[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mLineDirections = new Layout.Directions[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mMeasured = MeasuredText.obtain();
    }

    public void generate(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, boolean trackpad, float ellipsizedWidth, TextUtils.TruncateAt ellipsize) {
        this.mLineCount = 0;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        Paint.FontMetricsInt fm = this.mFontMetricsInt;
        int[] choosehtv = null;
        MeasuredText measured = this.mMeasured;
        Spanned spanned = null;
        if (source instanceof Spanned) {
            spanned = (Spanned)source;
        }
        int DEFAULT_DIR = 1;
        int paraStart = bufstart;
        while (paraStart <= bufend) {
            int spanStart;
            int paraEnd = TextUtils.indexOf(source, '\n', paraStart, bufend);
            paraEnd = paraEnd < 0 ? bufend : ++paraEnd;
            int paraLen = paraEnd - paraStart;
            int firstWidthLineLimit = this.mLineCount + 1;
            int firstwidth = outerwidth;
            int restwidth = outerwidth;
            LineHeightSpan[] chooseht = null;
            if (spanned != null) {
                int i;
                LeadingMarginSpan[] sp = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (i = 0; i < sp.length; ++i) {
                    LeadingMarginSpan lms = sp[i];
                    firstwidth -= sp[i].getLeadingMargin(true);
                    restwidth -= sp[i].getLeadingMargin(false);
                    if (!(lms instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 lms2 = (LeadingMarginSpan.LeadingMarginSpan2)lms;
                    int lmsFirstLine = this.getLineForOffset(spanned.getSpanStart(lms2));
                    firstWidthLineLimit = lmsFirstLine + lms2.getLeadingMarginLineCount();
                }
                chooseht = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (chooseht.length != 0) {
                    if (choosehtv == null || choosehtv.length < chooseht.length) {
                        choosehtv = new int[ArrayUtils.idealIntArraySize(chooseht.length)];
                    }
                    for (i = 0; i < chooseht.length; ++i) {
                        int o = spanned.getSpanStart(chooseht[i]);
                        choosehtv[i] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                    }
                }
            }
            measured.setPara(source, paraStart, paraEnd, 2);
            char[] chs = measured.mChars;
            float[] widths = measured.mWidths;
            byte[] chdirs = measured.mLevels;
            int dir = measured.mDir;
            boolean easy = measured.mEasy;
            CharSequence sub = source;
            int width = firstwidth;
            float w = 0.0f;
            int here = paraStart;
            int ok = paraStart;
            float okwidth = w;
            int okascent = 0;
            int okdescent = 0;
            int oktop = 0;
            int okbottom = 0;
            int fit = paraStart;
            float fitwidth = w;
            int fitascent = 0;
            int fitdescent = 0;
            int fittop = 0;
            int fitbottom = 0;
            boolean hasTabOrEmoji = false;
            boolean hasTab = false;
            Layout.TabStops tabStops = null;
            int spanEnd = spanStart = paraStart;
            while (spanStart < paraEnd) {
                if (spanStart == spanEnd) {
                    spanEnd = spanned == null ? paraEnd : spanned.nextSpanTransition(spanStart, paraEnd, MetricAffectingSpan.class);
                    int spanLen = spanEnd - spanStart;
                    if (spanned == null) {
                        measured.addStyleRun(paint, spanLen, fm);
                    } else {
                        MetricAffectingSpan[] spans = spanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                        measured.addStyleRun(paint, spans, spanLen, fm);
                    }
                }
                int nextSpanStart = spanEnd;
                int startInPara = spanStart - paraStart;
                int endInPara = spanEnd - paraStart;
                int fmtop = fm.top;
                int fmbottom = fm.bottom;
                int fmascent = fm.ascent;
                int fmdescent = fm.descent;
                for (int j = spanStart; j < spanEnd; ++j) {
                    char c = chs[j - paraStart];
                    float before = w;
                    if (c != '\n') {
                        if (c == '\t') {
                            if (!hasTab) {
                                Object[] spans;
                                hasTab = true;
                                hasTabOrEmoji = true;
                                if (spanned != null && (spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).length > 0) {
                                    tabStops = new Layout.TabStops(20, spans);
                                }
                            }
                            w = tabStops != null ? tabStops.nextTab(w) : Layout.TabStops.nextDefaultStop(w, 20);
                        } else if (c >= '\ud800' && c <= '\udfff' && j + 1 < spanEnd) {
                            int emoji = Character.codePointAt(chs, j - paraStart);
                            if (emoji >= MIN_EMOJI && emoji <= MAX_EMOJI) {
                                Bitmap bm = EMOJI_FACTORY.getBitmapFromAndroidPua(emoji);
                                if (bm != null) {
                                    TextPaint whichPaint = spanned == null ? paint : this.mWorkPaint;
                                    float wid = (float)bm.getWidth() * -whichPaint.ascent() / (float)bm.getHeight();
                                    w += wid;
                                    hasTabOrEmoji = true;
                                    ++j;
                                } else {
                                    w += widths[j - paraStart];
                                }
                            } else {
                                w += widths[j - paraStart];
                            }
                        } else {
                            w += widths[j - paraStart];
                        }
                    }
                    if (w <= (float)width) {
                        fitwidth = w;
                        fit = j + 1;
                        if (fmtop < fittop) {
                            fittop = fmtop;
                        }
                        if (fmascent < fitascent) {
                            fitascent = fmascent;
                        }
                        if (fmdescent > fitdescent) {
                            fitdescent = fmdescent;
                        }
                        if (fmbottom > fitbottom) {
                            fitbottom = fmbottom;
                        }
                        if (c != ' ' && c != '\t' && (c != '.' && c != ',' && c != ':' && c != ';' || j - 1 >= here && Character.isDigit(chs[j - 1 - paraStart]) || j + 1 < spanEnd && Character.isDigit(chs[j + 1 - paraStart])) && (c != '/' && c != '-' || j + 1 < spanEnd && Character.isDigit(chs[j + 1 - paraStart])) && (c < '\u2e80' || !StaticLayout.isIdeographic(c, true) || j + 1 >= spanEnd || !StaticLayout.isIdeographic(chs[j + 1 - paraStart], false))) continue;
                        okwidth = w;
                        ok = j + 1;
                        if (fittop < oktop) {
                            oktop = fittop;
                        }
                        if (fitascent < okascent) {
                            okascent = fitascent;
                        }
                        if (fitdescent > okdescent) {
                            okdescent = fitdescent;
                        }
                        if (fitbottom <= okbottom) continue;
                        okbottom = fitbottom;
                        continue;
                    }
                    if (ok != here) {
                        while (ok < spanEnd && chs[ok - paraStart] == ' ') {
                            ++ok;
                        }
                        v = this.out(source, here, ok, okascent, okdescent, oktop, okbottom, v, spacingmult, spacingadd, chooseht, choosehtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, ok == bufend, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, okwidth, paint);
                        here = ok;
                    } else if (fit != here) {
                        v = this.out(source, here, fit, fitascent, fitdescent, fittop, fitbottom, v, spacingmult, spacingadd, chooseht, choosehtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, fit == bufend, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, fitwidth, paint);
                        here = fit;
                    } else {
                        v = this.out(source, here, here + 1, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, chooseht, choosehtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, here + 1 == bufend, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, widths[here - paraStart], paint);
                        ++here;
                    }
                    j = here < spanStart ? (nextSpanStart = here) : here - 1;
                    ok = fit = here;
                    w = 0.0f;
                    fitbottom = 0;
                    fittop = 0;
                    fitdescent = 0;
                    fitascent = 0;
                    okbottom = 0;
                    oktop = 0;
                    okdescent = 0;
                    okascent = 0;
                    if (--firstWidthLineLimit > 0) continue;
                    width = restwidth;
                }
                spanStart = nextSpanStart;
            }
            if (paraEnd != here) {
                if (!(fittop | fitbottom | fitdescent | fitascent)) {
                    paint.getFontMetricsInt(fm);
                    fittop = fm.top;
                    fitbottom = fm.bottom;
                    fitascent = fm.ascent;
                    fitdescent = fm.descent;
                }
                v = this.out(source, here, paraEnd, fitascent, fitdescent, fittop, fitbottom, v, spacingmult, spacingadd, chooseht, choosehtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, paraEnd == bufend, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, w, paint);
            }
            paraStart = paraEnd;
            if (paraEnd == bufend) break;
            paraStart = paraEnd;
        }
        if (bufend == bufstart || source.charAt(bufend - 1) == '\n') {
            paint.getFontMetricsInt(fm);
            v = this.out(source, bufend, bufend, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, null, null, fm, false, needMultiply, bufend, null, DEFAULT_DIR, true, true, includepad, trackpad, null, null, bufstart, ellipsize, ellipsizedWidth, 0.0f, paint);
        }
    }

    public static boolean isIdeographic(char c, boolean includeNonStarters) {
        if (c >= '\u2e80' && c <= '\u2fff') {
            return true;
        }
        if (c == '\u3000') {
            return true;
        }
        if (c >= '\u3040' && c <= '\u309f') {
            if (!includeNonStarters) {
                switch (c) {
                    case '\u3041': 
                    case '\u3043': 
                    case '\u3045': 
                    case '\u3047': 
                    case '\u3049': 
                    case '\u3063': 
                    case '\u3083': 
                    case '\u3085': 
                    case '\u3087': 
                    case '\u308e': 
                    case '\u3095': 
                    case '\u3096': 
                    case '\u309b': 
                    case '\u309c': 
                    case '\u309d': 
                    case '\u309e': {
                        return false;
                    }
                }
            }
            return true;
        }
        if (c >= '\u30a0' && c <= '\u30ff') {
            if (!includeNonStarters) {
                switch (c) {
                    case '\u30a0': 
                    case '\u30a1': 
                    case '\u30a3': 
                    case '\u30a5': 
                    case '\u30a7': 
                    case '\u30a9': 
                    case '\u30c3': 
                    case '\u30e3': 
                    case '\u30e5': 
                    case '\u30e7': 
                    case '\u30ee': 
                    case '\u30f5': 
                    case '\u30f6': 
                    case '\u30fb': 
                    case '\u30fc': 
                    case '\u30fd': 
                    case '\u30fe': {
                        return false;
                    }
                }
            }
            return true;
        }
        if (c >= '\u3400' && c <= '\u4db5') {
            return true;
        }
        if (c >= '\u4e00' && c <= '\u9fbb') {
            return true;
        }
        if (c >= '\uf900' && c <= '\ufad9') {
            return true;
        }
        if (c >= '\ua000' && c <= '\ua48f') {
            return true;
        }
        if (c >= '\ua490' && c <= '\ua4cf') {
            return true;
        }
        if (c >= '\ufe62' && c <= '\ufe66') {
            return true;
        }
        return c >= '\uff10' && c <= '\uff19';
    }

    public int out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, LineHeightSpan[] chooseht, int[] choosehtv, Paint.FontMetricsInt fm, boolean hasTabOrEmoji, boolean needMultiply, int pstart, byte[] chdirs, int dir, boolean easy, boolean last, boolean includepad, boolean trackpad, char[] chs, float[] widths, int widstart, TextUtils.TruncateAt ellipsize, float ellipsiswidth, float textwidth, TextPaint paint) {
        double ex;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int[] lines = this.mLines;
        if (want >= lines.length) {
            int nlen = ArrayUtils.idealIntArraySize(want + 1);
            int[] grow = new int[nlen];
            System.arraycopy(lines, 0, grow, 0, lines.length);
            this.mLines = grow;
            lines = grow;
            Layout.Directions[] grow2 = new Layout.Directions[nlen];
            System.arraycopy(this.mLineDirections, 0, grow2, 0, this.mLineDirections.length);
            this.mLineDirections = grow2;
        }
        if (chooseht != null) {
            fm.ascent = above;
            fm.descent = below;
            fm.top = top;
            fm.bottom = bottom;
            for (int i = 0; i < chooseht.length; ++i) {
                if (chooseht[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)chooseht[i]).chooseHeight(text, start, end, choosehtv[i], v, fm, paint);
                    continue;
                }
                chooseht[i].chooseHeight(text, start, end, choosehtv[i], v, fm);
            }
            above = fm.ascent;
            below = fm.descent;
            top = fm.top;
            bottom = fm.bottom;
        }
        if (j == 0) {
            if (trackpad) {
                this.mTopPadding = top - above;
            }
            if (includepad) {
                above = top;
            }
        }
        if (last) {
            if (trackpad) {
                this.mBottomPadding = bottom - below;
            }
            if (includepad) {
                below = bottom;
            }
        }
        int extra = needMultiply ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        lines[off + 0] = start;
        lines[off + 1] = v;
        lines[off + 2] = below + extra;
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        if (hasTabOrEmoji) {
            int n = off + 0;
            lines[n] = lines[n] | 0x20000000;
        }
        int n = off + 0;
        lines[n] = lines[n] | dir << 30;
        Layout.Directions linedirs = DIRS_ALL_LEFT_TO_RIGHT;
        this.mLineDirections[j] = easy ? linedirs : AndroidBidi.directions(dir, chdirs, start - widstart, chs, start - widstart, end - start);
        if (ellipsize != null && (ellipsize != TextUtils.TruncateAt.MARQUEE || j != 0)) {
            this.calculateEllipsis(start, end, widths, widstart, ellipsiswidth, ellipsize, j, textwidth, paint);
        }
        ++this.mLineCount;
        return v;
    }

    public void calculateEllipsis(int linestart, int lineend, float[] widths, int widstart, float avail, TextUtils.TruncateAt where, int line, float textwidth, TextPaint paint) {
        int ellipsisCount;
        int ellipsisStart;
        if (textwidth <= avail) {
            this.mLines[this.mColumns * line + 3] = 0;
            this.mLines[this.mColumns * line + 4] = 0;
            return;
        }
        float ellipsiswid = paint.measureText("\u2026");
        int len = lineend - linestart;
        if (where == TextUtils.TruncateAt.START) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = len; i >= 0 && !((w = widths[i - 1 + linestart - widstart]) + sum + ellipsiswid > avail); --i) {
                sum += w;
            }
            ellipsisStart = 0;
            ellipsisCount = i;
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = 0; i < len && !((w = widths[i + linestart - widstart]) + sum + ellipsiswid > avail); ++i) {
                sum += w;
            }
            ellipsisStart = i;
            ellipsisCount = len - i;
        } else {
            float w;
            float w2;
            float lsum = 0.0f;
            float rsum = 0.0f;
            int left = 0;
            int right = len;
            float ravail = (avail - ellipsiswid) / 2.0f;
            for (right = len; right >= 0 && !((w2 = widths[right - 1 + linestart - widstart]) + rsum > ravail); --right) {
                rsum += w2;
            }
            float lavail = avail - ellipsiswid - rsum;
            for (left = 0; left < right && !((w = widths[left + linestart - widstart]) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        }
        this.mLines[this.mColumns * line + 3] = ellipsisStart;
        this.mLines[this.mColumns * line + 4] = ellipsisCount;
    }

    public int getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    public int getLineCount() {
        return this.mLineCount;
    }

    public int getLineTop(int line) {
        int top = this.mLines[this.mColumns * line + 1];
        if (this.mMaximumVisibleLineCount > 0 && line >= this.mMaximumVisibleLineCount && line != this.mLineCount) {
            top += this.getBottomPadding();
        }
        return top;
    }

    public int getLineDescent(int line) {
        int descent = this.mLines[this.mColumns * line + 2];
        if (this.mMaximumVisibleLineCount > 0 && line >= this.mMaximumVisibleLineCount - 1 && line != this.mLineCount) {
            descent += this.getBottomPadding();
        }
        return descent;
    }

    public int getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    public int getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    public boolean getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    public Layout.Directions getLineDirections(int line) {
        return this.mLineDirections[line];
    }

    public int getTopPadding() {
        return this.mTopPadding;
    }

    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    public int getEllipsisCount(int line) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 4];
    }

    public int getEllipsisStart(int line) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 3];
    }

    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    public void setMaximumVisibleLineCount(int lineCount) {
        this.mMaximumVisibleLineCount = lineCount;
    }
}

