/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.BaseMovementMethod;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.MotionEvent;
import android.widget.TextView;

public class ScrollingMovementMethod
extends BaseMovementMethod
implements MovementMethod {
    public static ScrollingMovementMethod sInstance;

    public int getTopLine(TextView widget) {
        return widget.getLayout().getLineForVertical(widget.getScrollY());
    }

    public int getBottomLine(TextView widget) {
        return widget.getLayout().getLineForVertical(widget.getScrollY() + this.getInnerHeight(widget));
    }

    public int getInnerWidth(TextView widget) {
        return widget.getWidth() - widget.getTotalPaddingLeft() - widget.getTotalPaddingRight();
    }

    public int getInnerHeight(TextView widget) {
        return widget.getHeight() - widget.getTotalPaddingTop() - widget.getTotalPaddingBottom();
    }

    public int getCharacterWidth(TextView widget) {
        return (int)Math.ceil(widget.getPaint().getFontSpacing());
    }

    public int getScrollBoundsLeft(TextView widget) {
        int bottomLine;
        Layout layout2 = widget.getLayout();
        int topLine = this.getTopLine(widget);
        if (topLine > (bottomLine = this.getBottomLine(widget))) {
            return 0;
        }
        int left = Integer.MAX_VALUE;
        for (int line = topLine; line <= bottomLine; ++line) {
            int lineLeft = (int)Math.floor(layout2.getLineLeft(line));
            if (lineLeft >= left) continue;
            left = lineLeft;
        }
        return left;
    }

    public int getScrollBoundsRight(TextView widget) {
        int bottomLine;
        Layout layout2 = widget.getLayout();
        int topLine = this.getTopLine(widget);
        if (topLine > (bottomLine = this.getBottomLine(widget))) {
            return 0;
        }
        int right = Integer.MIN_VALUE;
        for (int line = topLine; line <= bottomLine; ++line) {
            int lineRight = (int)Math.ceil(layout2.getLineRight(line));
            if (lineRight <= right) continue;
            right = lineRight;
        }
        return right;
    }

    public boolean left(TextView widget, Spannable buffer) {
        int minScrollX = this.getScrollBoundsLeft(widget);
        int scrollX = widget.getScrollX();
        if (scrollX > minScrollX) {
            scrollX = Math.max(scrollX - this.getCharacterWidth(widget), minScrollX);
            widget.scrollTo(scrollX, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean right(TextView widget, Spannable buffer) {
        int maxScrollX = this.getScrollBoundsRight(widget) - this.getInnerWidth(widget);
        int scrollX = widget.getScrollX();
        if (scrollX < maxScrollX) {
            scrollX = Math.min(scrollX + this.getCharacterWidth(widget), maxScrollX);
            widget.scrollTo(scrollX, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean up(TextView widget, Spannable buffer) {
        int top;
        int topLine;
        Layout layout2 = widget.getLayout();
        if (layout2.getLineTop(topLine = layout2.getLineForVertical(top = widget.getScrollY())) == top) {
            --topLine;
        }
        if (topLine >= 0) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(topLine));
            return true;
        }
        return false;
    }

    public boolean down(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int innerHeight = this.getInnerHeight(widget);
        int bottom = widget.getScrollY() + innerHeight;
        int bottomLine = layout2.getLineForVertical(bottom);
        if (layout2.getLineTop(bottomLine + 1) < bottom + 1) {
            ++bottomLine;
        }
        if (bottomLine <= layout2.getLineCount() - 1) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(bottomLine + 1) - innerHeight);
            return true;
        }
        return false;
    }

    public boolean pageUp(TextView widget, Spannable buffer) {
        int top;
        Layout layout2 = widget.getLayout();
        int topLine = layout2.getLineForVertical(top = widget.getScrollY() - this.getInnerHeight(widget));
        if (topLine >= 0) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(topLine));
            return true;
        }
        return false;
    }

    public boolean pageDown(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int innerHeight = this.getInnerHeight(widget);
        int bottom = widget.getScrollY() + innerHeight + innerHeight;
        int bottomLine = layout2.getLineForVertical(bottom);
        if (bottomLine <= layout2.getLineCount() - 1) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(bottomLine + 1) - innerHeight);
            return true;
        }
        return false;
    }

    public boolean top(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (this.getTopLine(widget) >= 0) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(0));
            return true;
        }
        return false;
    }

    public boolean bottom(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int lineCount = layout2.getLineCount();
        if (this.getBottomLine(widget) <= lineCount - 1) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(lineCount) - this.getInnerHeight(widget));
            return true;
        }
        return false;
    }

    public boolean lineStart(TextView widget, Spannable buffer) {
        int minScrollX = this.getScrollBoundsLeft(widget);
        int scrollX = widget.getScrollX();
        if (scrollX > minScrollX) {
            widget.scrollTo(minScrollX, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean lineEnd(TextView widget, Spannable buffer) {
        int maxScrollX = this.getScrollBoundsRight(widget) - this.getInnerWidth(widget);
        int scrollX = widget.getScrollX();
        if (scrollX < maxScrollX) {
            widget.scrollTo(maxScrollX, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean home(TextView widget, Spannable buffer) {
        return this.top(widget, buffer);
    }

    public boolean end(TextView widget, Spannable buffer) {
        return this.bottom(widget, buffer);
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        return Touch.onTouchEvent(widget, buffer, event);
    }

    public void onTakeFocus(TextView widget, Spannable text, int dir) {
        Layout layout2 = widget.getLayout();
        if (layout2 != null && (dir & 2) != 0) {
            widget.scrollTo(widget.getScrollX(), layout2.getLineTop(0));
        }
        if (layout2 != null && (dir & 1) != 0) {
            int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
            int line = layout2.getLineCount() - 1;
            widget.scrollTo(widget.getScrollX(), layout2.getLineTop(line + 1) - (widget.getHeight() - padding));
        }
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ScrollingMovementMethod();
        }
        return sInstance;
    }
}

