/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.DisplayMetrics;
import com.android.tools.layoutlib.create.OverrideMethod;

public class Display {
    public static final int DEFAULT_DISPLAY = 0;
    public int mDisplay;
    public int mPixelFormat;
    public float mRefreshRate;
    public float mDensity;
    public float mDpiX;
    public float mDpiY;
    public static final Object mStaticInit = new Object();
    public static boolean mInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display(int display) {
        Object object = mStaticInit;
        synchronized (object) {
            if (!mInitialized) {
                Display.nativeClassInit();
                mInitialized = true;
            }
        }
        this.mDisplay = display;
        this.init(display);
    }

    public int getDisplayId() {
        return this.mDisplay;
    }

    public static int getDisplayCount() {
        return OverrideMethod.invokeI("android.view.Display#getDisplayCount()I", true, null);
    }

    public int getWidth() {
        return OverrideMethod.invokeI("android.view.Display#getWidth()I", true, this);
    }

    public int getHeight() {
        return OverrideMethod.invokeI("android.view.Display#getHeight()I", true, this);
    }

    public int getRotation() {
        return this.getOrientation();
    }

    @Deprecated
    public int getOrientation() {
        return OverrideMethod.invokeI("android.view.Display#getOrientation()I", true, this);
    }

    public int getPixelFormat() {
        return this.mPixelFormat;
    }

    public float getRefreshRate() {
        return this.mRefreshRate;
    }

    public void getMetrics(DisplayMetrics outMetrics) {
        outMetrics.widthPixels = this.getWidth();
        outMetrics.heightPixels = this.getHeight();
        outMetrics.density = this.mDensity;
        outMetrics.densityDpi = (int)(this.mDensity * 160.0f + 0.5f);
        outMetrics.scaledDensity = outMetrics.density;
        outMetrics.xdpi = this.mDpiX;
        outMetrics.ydpi = this.mDpiY;
    }

    public static int unmapDisplaySize(int n) {
        return OverrideMethod.invokeI("android.view.Display#unmapDisplaySize(I)I", true, null);
    }

    public static void nativeClassInit() {
        OverrideMethod.invokeV("android.view.Display#nativeClassInit()V", true, null);
    }

    public void init(int n) {
        OverrideMethod.invokeV("android.view.Display#init(I)V", true, this);
    }

    public static Display createMetricsBasedDisplay(int displayId, DisplayMetrics metrics) {
        return new CompatibleDisplay(displayId, metrics, null);
    }

    public static class 1 {
    }

    public static class CompatibleDisplay
    extends Display {
        public final DisplayMetrics mMetrics;

        public CompatibleDisplay(int displayId, DisplayMetrics metrics) {
            super(displayId);
            this.mMetrics = metrics;
        }

        public int getWidth() {
            return this.mMetrics.widthPixels;
        }

        public int getHeight() {
            return this.mMetrics.heightPixels;
        }

        public /* synthetic */ CompatibleDisplay(int x0, DisplayMetrics x1, 1 x2) {
            this(x0, x1);
        }
    }
}

