/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.view.GLES20Canvas;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;

public class GLES20Layer
extends HardwareLayer {
    public int mLayer;
    public int mLayerWidth;
    public int mLayerHeight;
    public final GLES20Canvas mCanvas;
    public final Finalizer mFinalizer;

    public GLES20Layer(int width, int height, boolean isOpaque) {
        super(width, height, isOpaque);
        int[] layerInfo = new int[2];
        this.mLayer = GLES20Canvas.nCreateLayer(width, height, isOpaque, layerInfo);
        if (this.mLayer != 0) {
            this.mLayerWidth = layerInfo[0];
            this.mLayerHeight = layerInfo[1];
            this.mCanvas = new GLES20Canvas(this.mLayer, !isOpaque);
            this.mFinalizer = new Finalizer(this.mLayer);
        } else {
            this.mCanvas = null;
            this.mFinalizer = null;
        }
    }

    public int getLayer() {
        return this.mLayer;
    }

    public boolean isValid() {
        return this.mLayer != 0 && this.mLayerWidth > 0 && this.mLayerHeight > 0;
    }

    public void resize(int width, int height) {
        if (!this.isValid() || width <= 0 || height <= 0) {
            return;
        }
        this.mWidth = width;
        this.mHeight = height;
        if (width != this.mLayerWidth || height != this.mLayerHeight) {
            int[] layerInfo = new int[2];
            GLES20Canvas.nResizeLayer(this.mLayer, width, height, layerInfo);
            this.mLayerWidth = layerInfo[0];
            this.mLayerHeight = layerInfo[1];
        }
    }

    public HardwareCanvas getCanvas() {
        return this.mCanvas;
    }

    public void end(Canvas currentCanvas) {
        if (currentCanvas instanceof GLES20Canvas) {
            ((GLES20Canvas)currentCanvas).resume();
        }
    }

    public HardwareCanvas start(Canvas currentCanvas) {
        if (currentCanvas instanceof GLES20Canvas) {
            ((GLES20Canvas)currentCanvas).interrupt();
        }
        return this.getCanvas();
    }

    public void destroy() {
        this.mFinalizer.destroy();
        this.mLayer = 0;
    }

    public static class Finalizer {
        public int mLayerId;

        public Finalizer(int layerId) {
            this.mLayerId = layerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize() throws Throwable {
            try {
                if (this.mLayerId != 0) {
                    GLES20Canvas.nDestroyLayerDeferred(this.mLayerId);
                }
            }
            finally {
                super.finalize();
            }
        }

        public void destroy() {
            GLES20Canvas.nDestroyLayer(this.mLayerId);
            this.mLayerId = 0;
        }
    }
}

