/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.view.GLES20Canvas;
import java.util.HashSet;

public class GLES20RecordingCanvas
extends GLES20Canvas {
    public final HashSet<Bitmap> mBitmaps = new HashSet();

    public GLES20RecordingCanvas(boolean translucent) {
        super(true, translucent);
    }

    public void recordShaderBitmap(Paint paint) {
        Shader shader;
        if (paint != null && (shader = paint.getShader()) instanceof BitmapShader) {
            this.mBitmaps.add(((BitmapShader)shader).mBitmap);
        }
    }

    public void reset() {
        this.mBitmaps.clear();
        this.setupRenderer(true);
    }

    public void drawPatch(Bitmap bitmap, byte[] chunks, RectF dst, Paint paint) {
        super.drawPatch(bitmap, chunks, dst, paint);
        this.mBitmaps.add(bitmap);
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        super.drawBitmap(bitmap, left, top, paint);
        this.mBitmaps.add(bitmap);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        super.drawBitmap(bitmap, matrix, paint);
        this.mBitmaps.add(bitmap);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
        this.mBitmaps.add(bitmap);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
        this.mBitmaps.add(bitmap);
    }

    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        super.drawBitmapMesh(bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint);
        this.mBitmaps.add(bitmap);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        super.drawCircle(cx, cy, radius, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        super.drawLine(startX, startY, stopX, stopY, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        super.drawLines(pts, offset, count, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawLines(float[] pts, Paint paint) {
        super.drawLines(pts, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawOval(RectF oval, Paint paint) {
        super.drawOval(oval, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawPaint(Paint paint) {
        super.drawPaint(paint);
        this.recordShaderBitmap(paint);
    }

    public void drawPath(Path path, Paint paint) {
        super.drawPath(path, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawPoint(float x, float y, Paint paint) {
        super.drawPoint(x, y, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        super.drawPoints(pts, offset, count, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        super.drawPoints(pts, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        super.drawPosText(text, index, count, pos, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
        super.drawPosText(text, pos, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        super.drawRect(left, top, right, bottom, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawRect(Rect r, Paint paint) {
        super.drawRect(r, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawRect(RectF r, Paint paint) {
        super.drawRect(r, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        super.drawRoundRect(rect, rx, ry, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        super.drawText(text, index, count, x, y, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawText(String text, float x, float y, Paint paint) {
        super.drawText(text, x, y, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, index, count, path, hOffset, vOffset, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, path, hOffset, vOffset, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, int dir, Paint paint) {
        super.drawTextRun(text, index, count, contextIndex, contextCount, x, y, dir, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, int dir, Paint paint) {
        super.drawTextRun(text, start, end, contextStart, contextEnd, x, y, dir, paint);
        this.recordShaderBitmap(paint);
    }

    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        super.drawVertices(mode, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint);
        this.recordShaderBitmap(paint);
    }
}

