/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;

public class InputDevice
implements Parcelable {
    public int mId;
    public String mName;
    public int mSources;
    public int mKeyboardType;
    public MotionRange[] mMotionRanges = new MotionRange[9];
    public static final int SOURCE_CLASS_MASK = 255;
    public static final int SOURCE_CLASS_BUTTON = 1;
    public static final int SOURCE_CLASS_POINTER = 2;
    public static final int SOURCE_CLASS_TRACKBALL = 4;
    public static final int SOURCE_CLASS_POSITION = 8;
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_KEYBOARD = 257;
    public static final int SOURCE_DPAD = 513;
    public static final int SOURCE_TOUCHSCREEN = 4098;
    public static final int SOURCE_MOUSE = 8194;
    public static final int SOURCE_TRACKBALL = 65540;
    public static final int SOURCE_TOUCHPAD = 0x100008;
    public static final int SOURCE_ANY = -256;
    public static final int MOTION_RANGE_X = 0;
    public static final int MOTION_RANGE_Y = 1;
    public static final int MOTION_RANGE_PRESSURE = 2;
    public static final int MOTION_RANGE_SIZE = 3;
    public static final int MOTION_RANGE_TOUCH_MAJOR = 4;
    public static final int MOTION_RANGE_TOUCH_MINOR = 5;
    public static final int MOTION_RANGE_TOOL_MAJOR = 6;
    public static final int MOTION_RANGE_TOOL_MINOR = 7;
    public static final int MOTION_RANGE_ORIENTATION = 8;
    public static final int MOTION_RANGE_LAST = 8;
    public static final int KEYBOARD_TYPE_NONE = 0;
    public static final int KEYBOARD_TYPE_NON_ALPHABETIC = 1;
    public static final int KEYBOARD_TYPE_ALPHABETIC = 2;
    public static final Parcelable.Creator<InputDevice> CREATOR = new Parcelable.Creator<InputDevice>(){

        @Override
        public InputDevice createFromParcel(Parcel in) {
            InputDevice result = new InputDevice(null);
            result.readFromParcel(in);
            return result;
        }

        public InputDevice[] newArray(int size) {
            return new InputDevice[size];
        }
    };

    public InputDevice() {
    }

    public static InputDevice getDevice(int id2) {
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            return wm.getInputDevice(id2);
        }
        catch (RemoteException ex) {
            throw new RuntimeException("Could not get input device information from Window Manager.", ex);
        }
    }

    public static int[] getDeviceIds() {
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            return wm.getInputDeviceIds();
        }
        catch (RemoteException ex) {
            throw new RuntimeException("Could not get input device ids from Window Manager.", ex);
        }
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public int getSources() {
        return this.mSources;
    }

    public int getKeyboardType() {
        return this.mKeyboardType;
    }

    public KeyCharacterMap getKeyCharacterMap() {
        return KeyCharacterMap.load(this.mId);
    }

    public MotionRange getMotionRange(int rangeType) {
        if (rangeType < 0 || rangeType > 8) {
            throw new IllegalArgumentException("Requested range is out of bounds.");
        }
        return this.mMotionRanges[rangeType];
    }

    public void addMotionRange(int rangeType, float min, float max, float flat, float fuzz) {
        if (rangeType >= 0 && rangeType <= 8) {
            MotionRange range;
            this.mMotionRanges[rangeType] = range = new MotionRange(min, max, flat, fuzz, null);
        }
    }

    public void readFromParcel(Parcel in) {
        int rangeType;
        this.mId = in.readInt();
        this.mName = in.readString();
        this.mSources = in.readInt();
        this.mKeyboardType = in.readInt();
        while ((rangeType = in.readInt()) >= 0) {
            this.addMotionRange(rangeType, in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
        }
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mId);
        out.writeString(this.mName);
        out.writeInt(this.mSources);
        out.writeInt(this.mKeyboardType);
        for (int i = 0; i <= 8; ++i) {
            MotionRange range = this.mMotionRanges[i];
            if (range == null) continue;
            out.writeInt(i);
            out.writeFloat(range.mMin);
            out.writeFloat(range.mMax);
            out.writeFloat(range.mFlat);
            out.writeFloat(range.mFuzz);
        }
        out.writeInt(-1);
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder description = new StringBuilder();
        description.append("Input Device ").append(this.mId).append(": ").append(this.mName).append("\n");
        description.append("  Keyboard Type: ");
        switch (this.mKeyboardType) {
            case 0: {
                description.append("none");
                break;
            }
            case 1: {
                description.append("non-alphabetic");
                break;
            }
            case 2: {
                description.append("alphabetic");
            }
        }
        description.append("\n");
        description.append("  Sources:");
        this.appendSourceDescriptionIfApplicable(description, 257, "keyboard");
        this.appendSourceDescriptionIfApplicable(description, 513, "dpad");
        this.appendSourceDescriptionIfApplicable(description, 4098, "touchscreen");
        this.appendSourceDescriptionIfApplicable(description, 8194, "mouse");
        this.appendSourceDescriptionIfApplicable(description, 65540, "trackball");
        this.appendSourceDescriptionIfApplicable(description, 0x100008, "touchpad");
        description.append("\n");
        this.appendRangeDescriptionIfApplicable(description, 0, "x");
        this.appendRangeDescriptionIfApplicable(description, 1, "y");
        this.appendRangeDescriptionIfApplicable(description, 2, "pressure");
        this.appendRangeDescriptionIfApplicable(description, 3, "size");
        this.appendRangeDescriptionIfApplicable(description, 4, "touchMajor");
        this.appendRangeDescriptionIfApplicable(description, 5, "touchMinor");
        this.appendRangeDescriptionIfApplicable(description, 6, "toolMajor");
        this.appendRangeDescriptionIfApplicable(description, 7, "toolMinor");
        this.appendRangeDescriptionIfApplicable(description, 8, "orientation");
        return description.toString();
    }

    public void appendSourceDescriptionIfApplicable(StringBuilder description, int source, String sourceName) {
        if ((this.mSources & source) == source) {
            description.append(" ");
            description.append(sourceName);
        }
    }

    public void appendRangeDescriptionIfApplicable(StringBuilder description, int rangeType, String rangeName) {
        MotionRange range = this.mMotionRanges[rangeType];
        if (range != null) {
            description.append("  Range[").append(rangeName);
            description.append("]: min=").append(range.mMin);
            description.append(" max=").append(range.mMax);
            description.append(" flat=").append(range.mFlat);
            description.append(" fuzz=").append(range.mFuzz);
            description.append("\n");
        }
    }

    public /* synthetic */ InputDevice(1 x0) {
        this();
    }

    public static class MotionRange {
        public float mMin;
        public float mMax;
        public float mFlat;
        public float mFuzz;

        public MotionRange(float min, float max, float flat, float fuzz) {
            this.mMin = min;
            this.mMax = max;
            this.mFlat = flat;
            this.mFuzz = fuzz;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getRange() {
            return this.mMax - this.mMin;
        }

        public float getFlat() {
            return this.mFlat;
        }

        public float getFuzz() {
            return this.mFuzz;
        }

        public /* synthetic */ MotionRange(float x0, float x1, float x2, float x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }
}

