/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidRuntimeException;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.IWindowManager;
import android.view.KeyEvent;
import com.android.tools.layoutlib.create.OverrideMethod;

public class KeyCharacterMap {
    @Deprecated
    public static final int BUILT_IN_KEYBOARD = 0;
    public static final int VIRTUAL_KEYBOARD = -1;
    public static final int NUMERIC = 1;
    public static final int PREDICTIVE = 2;
    public static final int ALPHA = 3;
    public static final int FULL = 4;
    public static final int SPECIAL_FUNCTION = 5;
    public static final char HEX_INPUT = '\uef00';
    public static final char PICKER_DIALOG_INPUT = '\uef01';
    public static final int MODIFIER_BEHAVIOR_CHORDED = 0;
    public static final int MODIFIER_BEHAVIOR_CHORDED_OR_TOGGLED = 1;
    public static SparseArray<KeyCharacterMap> sInstances = new SparseArray();
    public final int mDeviceId;
    public int mPtr;
    public static SparseIntArray COMBINING = new SparseIntArray();
    public static SparseIntArray DEAD = new SparseIntArray();
    public static final int ACUTE = 0xB40000;
    public static final int GRAVE = 0x600000;
    public static final int CIRCUMFLEX = 0x5E0000;
    public static final int TILDE = 0x7E0000;
    public static final int UMLAUT = 0xA80000;
    public static final int COMBINING_ACCENT = Integer.MIN_VALUE;
    public static final int COMBINING_ACCENT_MASK = Integer.MAX_VALUE;

    public static int nativeLoad(int n) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeLoad(I)I", true, null);
    }

    public static void nativeDispose(int n) {
        OverrideMethod.invokeV("android.view.KeyCharacterMap#nativeDispose(I)V", true, null);
    }

    public static char nativeGetCharacter(int n, int n2, int n3) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetCharacter(III)C", true, null);
    }

    public static boolean nativeGetFallbackAction(int n, int n2, int n3, FallbackAction fallbackAction) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetFallbackAction(IIILandroid/view/KeyCharacterMap$FallbackAction;)Z", true, null) != 0;
    }

    public static char nativeGetNumber(int n, int n2) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetNumber(II)C", true, null);
    }

    public static char nativeGetMatch(int n, int n2, char[] cArray, int n3) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetMatch(II[CI)C", true, null);
    }

    public static char nativeGetDisplayLabel(int n, int n2) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetDisplayLabel(II)C", true, null);
    }

    public static int nativeGetKeyboardType(int n) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetKeyboardType(I)I", true, null);
    }

    public static KeyEvent[] nativeGetEvents(int n, int n2, char[] cArray) {
        return (KeyEvent[])OverrideMethod.invokeA("android.view.KeyCharacterMap#nativeGetEvents(II[C)[Landroid/view/KeyEvent;", true, null);
    }

    public KeyCharacterMap(int deviceId, int ptr) {
        this.mDeviceId = deviceId;
        this.mPtr = ptr;
    }

    public void finalize() throws Throwable {
        if (this.mPtr != 0) {
            KeyCharacterMap.nativeDispose(this.mPtr);
            this.mPtr = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyCharacterMap load(int deviceId) {
        SparseArray<KeyCharacterMap> sparseArray = sInstances;
        synchronized (sparseArray) {
            KeyCharacterMap map = sInstances.get(deviceId);
            if (map == null) {
                int ptr = KeyCharacterMap.nativeLoad(deviceId);
                map = new KeyCharacterMap(deviceId, ptr);
                sInstances.put(deviceId, map);
            }
            return map;
        }
    }

    public int get(int keyCode, int metaState) {
        char ch = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, metaState = KeyEvent.normalizeMetaState(metaState));
        int map = COMBINING.get(ch);
        if (map != 0) {
            return map;
        }
        return ch;
    }

    public boolean getFallbackAction(int keyCode, int metaState, FallbackAction outFallbackAction) {
        if (outFallbackAction == null) {
            throw new IllegalArgumentException("fallbackAction must not be null");
        }
        metaState = KeyEvent.normalizeMetaState(metaState);
        return KeyCharacterMap.nativeGetFallbackAction(this.mPtr, keyCode, metaState, outFallbackAction);
    }

    public char getNumber(int keyCode) {
        return KeyCharacterMap.nativeGetNumber(this.mPtr, keyCode);
    }

    public char getMatch(int keyCode, char[] chars) {
        return this.getMatch(keyCode, chars, 0);
    }

    public char getMatch(int keyCode, char[] chars, int metaState) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null.");
        }
        metaState = KeyEvent.normalizeMetaState(metaState);
        return KeyCharacterMap.nativeGetMatch(this.mPtr, keyCode, chars, metaState);
    }

    public char getDisplayLabel(int keyCode) {
        return KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode);
    }

    public static int getDeadChar(int accent, int c) {
        return DEAD.get(accent << 16 | c);
    }

    @Deprecated
    public boolean getKeyData(int keyCode, KeyData results) {
        if (results.meta.length < 4) {
            throw new IndexOutOfBoundsException("results.meta.length must be >= 4");
        }
        char displayLabel = KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode);
        if (displayLabel == '\u0000') {
            return false;
        }
        results.displayLabel = displayLabel;
        results.number = KeyCharacterMap.nativeGetNumber(this.mPtr, keyCode);
        results.meta[0] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 0);
        results.meta[1] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 1);
        results.meta[2] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 2);
        results.meta[3] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 3);
        return true;
    }

    public KeyEvent[] getEvents(char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null.");
        }
        return KeyCharacterMap.nativeGetEvents(this.mPtr, this.mDeviceId, chars);
    }

    public boolean isPrintingKey(int keyCode) {
        int type = Character.getType(KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode));
        switch (type) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return false;
            }
        }
        return true;
    }

    public int getKeyboardType() {
        return KeyCharacterMap.nativeGetKeyboardType(this.mPtr);
    }

    public int getModifierBehavior() {
        switch (this.getKeyboardType()) {
            case 4: 
            case 5: {
                return 0;
            }
        }
        return 1;
    }

    public static boolean deviceHasKey(int keyCode) {
        int[] codeArray = new int[]{keyCode};
        boolean[] ret = KeyCharacterMap.deviceHasKeys(codeArray);
        return ret[0];
    }

    public static boolean[] deviceHasKeys(int[] keyCodes) {
        boolean[] ret = new boolean[keyCodes.length];
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            wm.hasKeys(keyCodes, ret);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return ret;
    }

    static {
        COMBINING.put(768, -2147483552);
        COMBINING.put(769, -2147483468);
        COMBINING.put(770, -2147483554);
        COMBINING.put(771, -2147483522);
        COMBINING.put(776, -2147483480);
        DEAD.put(11796545, 193);
        DEAD.put(11796547, 262);
        DEAD.put(11796549, 201);
        DEAD.put(11796551, 500);
        DEAD.put(11796553, 205);
        DEAD.put(0xB4004B, 7728);
        DEAD.put(11796556, 313);
        DEAD.put(11796557, 7742);
        DEAD.put(11796558, 323);
        DEAD.put(11796559, 211);
        DEAD.put(11796560, 7764);
        DEAD.put(11796562, 340);
        DEAD.put(11796563, 346);
        DEAD.put(11796565, 218);
        DEAD.put(11796567, 7810);
        DEAD.put(11796569, 221);
        DEAD.put(11796570, 377);
        DEAD.put(11796577, 225);
        DEAD.put(11796579, 263);
        DEAD.put(11796581, 233);
        DEAD.put(11796583, 501);
        DEAD.put(11796585, 237);
        DEAD.put(11796587, 7729);
        DEAD.put(11796588, 314);
        DEAD.put(11796589, 7743);
        DEAD.put(11796590, 324);
        DEAD.put(11796591, 243);
        DEAD.put(11796592, 7765);
        DEAD.put(11796594, 341);
        DEAD.put(11796595, 347);
        DEAD.put(11796597, 250);
        DEAD.put(11796599, 7811);
        DEAD.put(11796601, 253);
        DEAD.put(11796602, 378);
        DEAD.put(6160449, 194);
        DEAD.put(6160451, 264);
        DEAD.put(6160453, 202);
        DEAD.put(6160455, 284);
        DEAD.put(6160456, 292);
        DEAD.put(6160457, 206);
        DEAD.put(6160458, 308);
        DEAD.put(6160463, 212);
        DEAD.put(6160467, 348);
        DEAD.put(0x5E0055, 219);
        DEAD.put(6160471, 372);
        DEAD.put(6160473, 374);
        DEAD.put(6160474, 7824);
        DEAD.put(6160481, 226);
        DEAD.put(6160483, 265);
        DEAD.put(6160485, 234);
        DEAD.put(6160487, 285);
        DEAD.put(6160488, 293);
        DEAD.put(6160489, 238);
        DEAD.put(6160490, 309);
        DEAD.put(6160495, 244);
        DEAD.put(6160499, 349);
        DEAD.put(6160501, 251);
        DEAD.put(6160503, 373);
        DEAD.put(6160505, 375);
        DEAD.put(6160506, 7825);
        DEAD.put(6291521, 192);
        DEAD.put(6291525, 200);
        DEAD.put(6291529, 204);
        DEAD.put(6291534, 504);
        DEAD.put(6291535, 210);
        DEAD.put(0x600055, 217);
        DEAD.put(6291543, 7808);
        DEAD.put(6291545, 7922);
        DEAD.put(0x600061, 224);
        DEAD.put(0x600065, 232);
        DEAD.put(0x600069, 236);
        DEAD.put(0x60006E, 505);
        DEAD.put(0x60006F, 242);
        DEAD.put(6291573, 249);
        DEAD.put(0x600077, 7809);
        DEAD.put(6291577, 7923);
        DEAD.put(8257601, 195);
        DEAD.put(8257605, 7868);
        DEAD.put(8257609, 296);
        DEAD.put(8257614, 209);
        DEAD.put(8257615, 213);
        DEAD.put(8257621, 360);
        DEAD.put(8257622, 7804);
        DEAD.put(8257625, 7928);
        DEAD.put(8257633, 227);
        DEAD.put(8257637, 7869);
        DEAD.put(8257641, 297);
        DEAD.put(8257646, 241);
        DEAD.put(8257647, 245);
        DEAD.put(8257653, 361);
        DEAD.put(8257654, 7805);
        DEAD.put(8257657, 7929);
        DEAD.put(11010113, 196);
        DEAD.put(11010117, 203);
        DEAD.put(11010120, 7718);
        DEAD.put(11010121, 207);
        DEAD.put(11010127, 214);
        DEAD.put(11010133, 220);
        DEAD.put(11010135, 7812);
        DEAD.put(11010136, 7820);
        DEAD.put(11010137, 376);
        DEAD.put(11010145, 228);
        DEAD.put(11010149, 235);
        DEAD.put(11010152, 7719);
        DEAD.put(11010153, 239);
        DEAD.put(11010159, 246);
        DEAD.put(11010164, 7831);
        DEAD.put(11010165, 252);
        DEAD.put(11010167, 7813);
        DEAD.put(11010168, 7821);
        DEAD.put(11010169, 255);
    }

    public static class FallbackAction {
        public int keyCode;
        public int metaState;
    }

    public static class UnavailableException
    extends AndroidRuntimeException {
        public UnavailableException(String msg) {
            super(msg);
        }
    }

    @Deprecated
    public static class KeyData {
        public static final int META_LENGTH = 4;
        public char displayLabel;
        public char number;
        public char[] meta = new char[4];
    }
}

