/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ClipData;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Interpolator;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.util.SparseArray;
import android.view.AbsSavedState;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.Display;
import android.view.DisplayList;
import android.view.DragEvent;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.Surface;
import android.view.TouchDelegate;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRoot;
import android.view.ViewTreeObserver;
import android.view.View_Delegate;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityEventSource;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.ScrollBarDrawable;
import com.android.internal.R;
import com.android.internal.util.Predicate;
import com.android.internal.view.menu.MenuBuilder;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements Drawable.Callback,
KeyEvent.Callback,
AccessibilityEventSource {
    public static final boolean DBG = false;
    public static final String VIEW_LOG_TAG = "View";
    public static final int NO_ID = -1;
    public static final int NOT_FOCUSABLE = 0;
    public static final int FOCUSABLE = 1;
    public static final int FOCUSABLE_MASK = 1;
    public static final int FITS_SYSTEM_WINDOWS = 2;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    public static final int VISIBILITY_MASK = 12;
    public static final int[] VISIBILITY_FLAGS = new int[]{0, 4, 8};
    public static final int ENABLED = 0;
    public static final int DISABLED = 32;
    public static final int ENABLED_MASK = 32;
    public static final int WILL_NOT_DRAW = 128;
    public static final int DRAW_MASK = 128;
    public static final int SCROLLBARS_NONE = 0;
    public static final int SCROLLBARS_HORIZONTAL = 256;
    public static final int SCROLLBARS_VERTICAL = 512;
    public static final int SCROLLBARS_MASK = 768;
    public static final int FILTER_TOUCHES_WHEN_OBSCURED = 1024;
    public static final int FADING_EDGE_NONE = 0;
    public static final int FADING_EDGE_HORIZONTAL = 4096;
    public static final int FADING_EDGE_VERTICAL = 8192;
    public static final int FADING_EDGE_MASK = 12288;
    public static final int CLICKABLE = 16384;
    public static final int DRAWING_CACHE_ENABLED = 32768;
    public static final int SAVE_DISABLED = 65536;
    public static final int SAVE_DISABLED_MASK = 65536;
    public static final int WILL_NOT_CACHE_DRAWING = 131072;
    public static final int FOCUSABLE_IN_TOUCH_MODE = 262144;
    public static final int DRAWING_CACHE_QUALITY_LOW = 524288;
    public static final int DRAWING_CACHE_QUALITY_HIGH = 0x100000;
    public static final int DRAWING_CACHE_QUALITY_AUTO = 0;
    public static final int[] DRAWING_CACHE_QUALITY_FLAGS = new int[]{0, 524288, 0x100000};
    public static final int DRAWING_CACHE_QUALITY_MASK = 0x180000;
    public static final int LONG_CLICKABLE = 0x200000;
    public static final int DUPLICATE_PARENT_STATE = 0x400000;
    public static final int SCROLLBARS_INSIDE_OVERLAY = 0;
    public static final int SCROLLBARS_INSIDE_INSET = 0x1000000;
    public static final int SCROLLBARS_OUTSIDE_OVERLAY = 0x2000000;
    public static final int SCROLLBARS_OUTSIDE_INSET = 0x3000000;
    public static final int SCROLLBARS_INSET_MASK = 0x1000000;
    public static final int SCROLLBARS_OUTSIDE_MASK = 0x2000000;
    public static final int SCROLLBARS_STYLE_MASK = 0x3000000;
    public static final int KEEP_SCREEN_ON = 0x4000000;
    public static final int SOUND_EFFECTS_ENABLED = 0x8000000;
    public static final int HAPTIC_FEEDBACK_ENABLED = 0x10000000;
    public static final int PARENT_SAVE_DISABLED = 0x20000000;
    public static final int PARENT_SAVE_DISABLED_MASK = 0x20000000;
    public static final int FOCUSABLES_ALL = 0;
    public static final int FOCUSABLES_TOUCH_MODE = 1;
    public static final int FOCUS_BACKWARD = 1;
    public static final int FOCUS_FORWARD = 2;
    public static final int FOCUS_LEFT = 17;
    public static final int FOCUS_UP = 33;
    public static final int FOCUS_RIGHT = 66;
    public static final int FOCUS_DOWN = 130;
    public static final int MEASURED_SIZE_MASK = 0xFFFFFF;
    public static final int MEASURED_STATE_MASK = -16777216;
    public static final int MEASURED_HEIGHT_STATE_SHIFT = 16;
    public static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    public static final int[] EMPTY_STATE_SET;
    public static final int[] ENABLED_STATE_SET;
    public static final int[] FOCUSED_STATE_SET;
    public static final int[] SELECTED_STATE_SET;
    public static final int[] PRESSED_STATE_SET;
    public static final int[] WINDOW_FOCUSED_STATE_SET;
    public static final int[] ENABLED_FOCUSED_STATE_SET;
    public static final int[] ENABLED_SELECTED_STATE_SET;
    public static final int[] ENABLED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] FOCUSED_SELECTED_STATE_SET;
    public static final int[] FOCUSED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] ENABLED_FOCUSED_SELECTED_STATE_SET;
    public static final int[] ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_SELECTED_STATE_SET;
    public static final int[] PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_FOCUSED_STATE_SET;
    public static final int[] PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_FOCUSED_SELECTED_STATE_SET;
    public static final int[] PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_ENABLED_STATE_SET;
    public static final int[] PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_ENABLED_SELECTED_STATE_SET;
    public static final int[] PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_ENABLED_FOCUSED_STATE_SET;
    public static final int[] PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET;
    public static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET;
    public static final int[] PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET;
    public static final int[][] VIEW_STATE_SETS;
    public static final int VIEW_STATE_WINDOW_FOCUSED = 1;
    public static final int VIEW_STATE_SELECTED = 2;
    public static final int VIEW_STATE_FOCUSED = 4;
    public static final int VIEW_STATE_ENABLED = 8;
    public static final int VIEW_STATE_PRESSED = 16;
    public static final int VIEW_STATE_ACTIVATED = 32;
    public static final int VIEW_STATE_ACCELERATED = 64;
    public static final int[] VIEW_STATE_IDS;
    public static final int[] LAST_STATE_SET;
    public static final int[] FIRST_STATE_SET;
    public static final int[] MIDDLE_STATE_SET;
    public static final int[] SINGLE_STATE_SET;
    public static final int[] PRESSED_LAST_STATE_SET;
    public static final int[] PRESSED_FIRST_STATE_SET;
    public static final int[] PRESSED_MIDDLE_STATE_SET;
    public static final int[] PRESSED_SINGLE_STATE_SET;
    public static final ThreadLocal<Rect> sThreadLocal;
    public static WeakHashMap<View, SparseArray<Object>> sTags;
    public static final Object sTagsLock;
    public Animation mCurrentAnimation = null;
    @ViewDebug.ExportedProperty(category="measurement")
    public int mMeasuredWidth;
    @ViewDebug.ExportedProperty(category="measurement")
    public int mMeasuredHeight;
    public boolean mRecreateDisplayList = false;
    @ViewDebug.ExportedProperty(resolveId=true)
    public int mID = -1;
    public Object mTag;
    public static final int WANTS_FOCUS = 1;
    public static final int FOCUSED = 2;
    public static final int SELECTED = 4;
    public static final int IS_ROOT_NAMESPACE = 8;
    public static final int HAS_BOUNDS = 16;
    public static final int DRAWN = 32;
    public static final int DRAW_ANIMATION = 64;
    public static final int SKIP_DRAW = 128;
    public static final int ONLY_DRAWS_BACKGROUND = 256;
    public static final int REQUEST_TRANSPARENT_REGIONS = 512;
    public static final int DRAWABLE_STATE_DIRTY = 1024;
    public static final int MEASURED_DIMENSION_SET = 2048;
    public static final int FORCE_LAYOUT = 4096;
    public static final int LAYOUT_REQUIRED = 8192;
    public static final int PRESSED = 16384;
    public static final int DRAWING_CACHE_VALID = 32768;
    public static final int ANIMATION_STARTED = 65536;
    public static final int SAVE_STATE_CALLED = 131072;
    public static final int ALPHA_SET = 262144;
    public static final int SCROLL_CONTAINER = 524288;
    public static final int SCROLL_CONTAINER_ADDED = 0x100000;
    public static final int DIRTY = 0x200000;
    public static final int DIRTY_OPAQUE = 0x400000;
    public static final int DIRTY_MASK = 0x600000;
    public static final int OPAQUE_BACKGROUND = 0x800000;
    public static final int OPAQUE_SCROLLBARS = 0x1000000;
    public static final int OPAQUE_MASK = 0x1800000;
    public static final int PREPRESSED = 0x2000000;
    public static final int CANCEL_NEXT_UP_EVENT = 0x4000000;
    public static final int AWAKEN_SCROLL_BARS_ON_ATTACH = 0x8000000;
    public static final int PIVOT_EXPLICITLY_SET = 0x20000000;
    public static final int ACTIVATED = 0x40000000;
    public static final int INVALIDATED = Integer.MIN_VALUE;
    public static final int OVER_SCROLL_ALWAYS = 0;
    public static final int OVER_SCROLL_IF_CONTENT_SCROLLS = 1;
    public static final int OVER_SCROLL_NEVER = 2;
    public static final int STATUS_BAR_VISIBLE = 0;
    public static final int STATUS_BAR_HIDDEN = 1;
    public static final int STATUS_BAR_DISABLE_EXPAND = 65536;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_ICONS = 131072;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_ALERTS = 262144;
    public static final int STATUS_BAR_DISABLE_NOTIFICATION_TICKER = 524288;
    public static final int STATUS_BAR_DISABLE_SYSTEM_INFO = 0x100000;
    public static final int STATUS_BAR_DISABLE_NAVIGATION = 0x200000;
    public static final int STATUS_BAR_DISABLE_BACK = 0x400000;
    public static final int STATUS_BAR_DISABLE_CLOCK = 0x800000;
    public static final int PUBLIC_STATUS_BAR_VISIBILITY_MASK = 1;
    public int mOverScrollMode;
    public ViewParent mParent;
    public AttachInfo mAttachInfo;
    @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=4096, equals=4096, name="FORCE_LAYOUT"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="LAYOUT_REQUIRED"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="DRAWING_CACHE_INVALID", outputIf=false), @ViewDebug.FlagToString(mask=32, equals=32, name="DRAWN", outputIf=true), @ViewDebug.FlagToString(mask=32, equals=32, name="NOT_DRAWN", outputIf=false), @ViewDebug.FlagToString(mask=0x600000, equals=0x400000, name="DIRTY_OPAQUE"), @ViewDebug.FlagToString(mask=0x600000, equals=0x200000, name="DIRTY")})
    public int mPrivateFlags;
    @ViewDebug.ExportedProperty
    public int mSystemUiVisibility;
    public int mWindowAttachCount;
    public ViewGroup.LayoutParams mLayoutParams;
    @ViewDebug.ExportedProperty
    public int mViewFlags;
    public final Matrix mMatrix = new Matrix();
    public Matrix mInverseMatrix;
    public boolean mMatrixDirty = false;
    public boolean mInverseMatrixDirty = true;
    public boolean mMatrixIsIdentity = true;
    public Camera mCamera = null;
    public Matrix matrix3D = null;
    public int mPrevWidth = -1;
    public int mPrevHeight = -1;
    public boolean mLastIsOpaque;
    public static final float NONZERO_EPSILON = 0.001f;
    @ViewDebug.ExportedProperty
    public float mRotationY = 0.0f;
    @ViewDebug.ExportedProperty
    public float mRotationX = 0.0f;
    @ViewDebug.ExportedProperty
    public float mRotation = 0.0f;
    @ViewDebug.ExportedProperty
    public float mTranslationX = 0.0f;
    @ViewDebug.ExportedProperty
    public float mTranslationY = 0.0f;
    @ViewDebug.ExportedProperty
    public float mScaleX = 1.0f;
    @ViewDebug.ExportedProperty
    public float mScaleY = 1.0f;
    @ViewDebug.ExportedProperty
    public float mPivotX = 0.0f;
    @ViewDebug.ExportedProperty
    public float mPivotY = 0.0f;
    @ViewDebug.ExportedProperty
    public float mAlpha = 1.0f;
    @ViewDebug.ExportedProperty(category="layout")
    public int mLeft;
    @ViewDebug.ExportedProperty(category="layout")
    public int mRight;
    @ViewDebug.ExportedProperty(category="layout")
    public int mTop;
    @ViewDebug.ExportedProperty(category="layout")
    public int mBottom;
    @ViewDebug.ExportedProperty(category="scrolling")
    public int mScrollX;
    @ViewDebug.ExportedProperty(category="scrolling")
    public int mScrollY;
    @ViewDebug.ExportedProperty(category="padding")
    public int mPaddingLeft;
    @ViewDebug.ExportedProperty(category="padding")
    public int mPaddingRight;
    @ViewDebug.ExportedProperty(category="padding")
    public int mPaddingTop;
    @ViewDebug.ExportedProperty(category="padding")
    public int mPaddingBottom;
    public CharSequence mContentDescription;
    @ViewDebug.ExportedProperty(category="padding")
    public int mUserPaddingRight;
    @ViewDebug.ExportedProperty(category="padding")
    public int mUserPaddingBottom;
    @ViewDebug.ExportedProperty(category="padding")
    public int mUserPaddingLeft;
    public int mOldWidthMeasureSpec = Integer.MIN_VALUE;
    public int mOldHeightMeasureSpec = Integer.MIN_VALUE;
    public Resources mResources = null;
    public Drawable mBGDrawable;
    public int mBackgroundResource;
    public boolean mBackgroundSizeChanged;
    public OnFocusChangeListener mOnFocusChangeListener;
    public ArrayList<OnLayoutChangeListener> mOnLayoutChangeListeners;
    public OnClickListener mOnClickListener;
    public OnLongClickListener mOnLongClickListener;
    public OnCreateContextMenuListener mOnCreateContextMenuListener;
    public OnKeyListener mOnKeyListener;
    public OnTouchListener mOnTouchListener;
    public OnDragListener mOnDragListener;
    public OnSystemUiVisibilityChangeListener mOnSystemUiVisibilityChangeListener;
    public Context mContext;
    public ScrollabilityCache mScrollCache;
    public int[] mDrawableState = null;
    public Bitmap mDrawingCache;
    public Bitmap mUnscaledDrawingCache;
    public DisplayList mDisplayList;
    public HardwareLayer mHardwareLayer;
    public int mNextFocusLeftId = -1;
    public int mNextFocusRightId = -1;
    public int mNextFocusUpId = -1;
    public int mNextFocusDownId = -1;
    public int mNextFocusForwardId = -1;
    public CheckForLongPress mPendingCheckForLongPress;
    public CheckForTap mPendingCheckForTap = null;
    public PerformClick mPerformClick;
    public UnsetPressedState mUnsetPressedState;
    public boolean mHasPerformedLongPress;
    @ViewDebug.ExportedProperty(category="measurement")
    public int mMinHeight;
    @ViewDebug.ExportedProperty(category="measurement")
    public int mMinWidth;
    public TouchDelegate mTouchDelegate = null;
    public int mDrawingCacheBackgroundColor = 0;
    public ViewTreeObserver mFloatingTreeObserver;
    public int mTouchSlop;
    public boolean mCanAcceptDrop;
    public static final int DRAG_FLAG_GLOBAL = 1;
    public int mVerticalScrollbarPosition;
    public static final int SCROLLBAR_POSITION_DEFAULT = 0;
    public static final int SCROLLBAR_POSITION_LEFT = 1;
    public static final int SCROLLBAR_POSITION_RIGHT = 2;
    public static final int LAYER_TYPE_NONE = 0;
    public static final int LAYER_TYPE_SOFTWARE = 1;
    public static final int LAYER_TYPE_HARDWARE = 2;
    @ViewDebug.ExportedProperty(category="drawing", mapping={@ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=1, to="SOFTWARE"), @ViewDebug.IntToString(from=2, to="HARDWARE")})
    public int mLayerType = 0;
    public Paint mLayerPaint;
    public Rect mLocalDirtyRect;

    public View(Context context) {
        this.mContext = context;
        this.mResources = context != null ? context.getResources() : null;
        this.mViewFlags = 0x18000000;
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.setOverScrollMode(1);
    }

    public View(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public View(Context context, AttributeSet attrs, int defStyle) {
        this(context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyle, 0);
        Drawable background = null;
        int leftPadding = -1;
        int topPadding = -1;
        int rightPadding = -1;
        int bottomPadding = -1;
        int padding = -1;
        int viewFlagValues = 0;
        int viewFlagMasks = 0;
        boolean setScrollContainer = false;
        int x = 0;
        int y = 0;
        float tx = 0.0f;
        float ty = 0.0f;
        float rotation = 0.0f;
        float rotationX = 0.0f;
        float rotationY = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        boolean transformSet = false;
        int scrollbarStyle = 0;
        int overScrollMode = this.mOverScrollMode;
        int N = a.getIndexCount();
        block51: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 12: {
                    background = a.getDrawable(attr2);
                    continue block51;
                }
                case 13: {
                    padding = a.getDimensionPixelSize(attr2, -1);
                    continue block51;
                }
                case 14: {
                    leftPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block51;
                }
                case 15: {
                    topPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block51;
                }
                case 16: {
                    rightPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block51;
                }
                case 17: {
                    bottomPadding = a.getDimensionPixelSize(attr2, -1);
                    continue block51;
                }
                case 10: {
                    x = a.getDimensionPixelOffset(attr2, 0);
                    continue block51;
                }
                case 11: {
                    y = a.getDimensionPixelOffset(attr2, 0);
                    continue block51;
                }
                case 47: {
                    this.setAlpha(a.getFloat(attr2, 1.0f));
                    continue block51;
                }
                case 48: {
                    this.setPivotX(a.getDimensionPixelOffset(attr2, 0));
                    continue block51;
                }
                case 49: {
                    this.setPivotY(a.getDimensionPixelOffset(attr2, 0));
                    continue block51;
                }
                case 50: {
                    tx = a.getDimensionPixelOffset(attr2, 0);
                    transformSet = true;
                    continue block51;
                }
                case 51: {
                    ty = a.getDimensionPixelOffset(attr2, 0);
                    transformSet = true;
                    continue block51;
                }
                case 54: {
                    rotation = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block51;
                }
                case 55: {
                    rotationX = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block51;
                }
                case 56: {
                    rotationY = a.getFloat(attr2, 0.0f);
                    transformSet = true;
                    continue block51;
                }
                case 52: {
                    sx = a.getFloat(attr2, 1.0f);
                    transformSet = true;
                    continue block51;
                }
                case 53: {
                    sy = a.getFloat(attr2, 1.0f);
                    transformSet = true;
                    continue block51;
                }
                case 8: {
                    this.mID = a.getResourceId(attr2, -1);
                    continue block51;
                }
                case 9: {
                    this.mTag = a.getText(attr2);
                    continue block51;
                }
                case 21: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 2;
                    viewFlagMasks |= 2;
                    continue block51;
                }
                case 18: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 1;
                    viewFlagMasks |= 1;
                    continue block51;
                }
                case 19: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 0x40001;
                    viewFlagMasks |= 0x40001;
                    continue block51;
                }
                case 29: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 0x4000;
                    viewFlagMasks |= 0x4000;
                    continue block51;
                }
                case 30: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 0x200000;
                    viewFlagMasks |= 0x200000;
                    continue block51;
                }
                case 31: {
                    if (a.getBoolean(attr2, true)) continue block51;
                    viewFlagValues |= 0x10000;
                    viewFlagMasks |= 0x10000;
                    continue block51;
                }
                case 33: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 0x400000;
                    viewFlagMasks |= 0x400000;
                    continue block51;
                }
                case 20: {
                    int visibility = a.getInt(attr2, 0);
                    if (visibility == 0) continue block51;
                    viewFlagValues |= VISIBILITY_FLAGS[visibility];
                    viewFlagMasks |= 0xC;
                    continue block51;
                }
                case 32: {
                    int cacheQuality = a.getInt(attr2, 0);
                    if (cacheQuality == 0) continue block51;
                    viewFlagValues |= DRAWING_CACHE_QUALITY_FLAGS[cacheQuality];
                    viewFlagMasks |= 0x180000;
                    continue block51;
                }
                case 41: {
                    this.mContentDescription = a.getString(attr2);
                    continue block51;
                }
                case 36: {
                    if (a.getBoolean(attr2, true)) continue block51;
                    viewFlagValues &= 0xF7FFFFFF;
                    viewFlagMasks |= 0x8000000;
                    continue block51;
                }
                case 39: {
                    if (a.getBoolean(attr2, true)) continue block51;
                    viewFlagValues &= 0xEFFFFFFF;
                    viewFlagMasks |= 0x10000000;
                    continue block51;
                }
                case 22: {
                    int scrollbars = a.getInt(attr2, 0);
                    if (scrollbars == 0) continue block51;
                    viewFlagValues |= scrollbars;
                    viewFlagMasks |= 0x300;
                    this.initializeScrollbars(a);
                    continue block51;
                }
                case 23: {
                    int fadingEdge = a.getInt(attr2, 0);
                    if (fadingEdge == 0) continue block51;
                    viewFlagValues |= fadingEdge;
                    viewFlagMasks |= 0x3000;
                    this.initializeFadingEdge(a);
                    continue block51;
                }
                case 7: {
                    scrollbarStyle = a.getInt(attr2, 0);
                    if (scrollbarStyle == 0) continue block51;
                    viewFlagValues |= scrollbarStyle & 0x3000000;
                    viewFlagMasks |= 0x3000000;
                    continue block51;
                }
                case 38: {
                    setScrollContainer = true;
                    if (!a.getBoolean(attr2, false)) continue block51;
                    this.setScrollContainer(true);
                    continue block51;
                }
                case 37: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 0x4000000;
                    viewFlagMasks |= 0x4000000;
                    continue block51;
                }
                case 46: {
                    if (!a.getBoolean(attr2, false)) continue block51;
                    viewFlagValues |= 0x400;
                    viewFlagMasks |= 0x400;
                    continue block51;
                }
                case 25: {
                    this.mNextFocusLeftId = a.getResourceId(attr2, -1);
                    continue block51;
                }
                case 26: {
                    this.mNextFocusRightId = a.getResourceId(attr2, -1);
                    continue block51;
                }
                case 27: {
                    this.mNextFocusUpId = a.getResourceId(attr2, -1);
                    continue block51;
                }
                case 28: {
                    this.mNextFocusDownId = a.getResourceId(attr2, -1);
                    continue block51;
                }
                case 58: {
                    this.mNextFocusForwardId = a.getResourceId(attr2, -1);
                    continue block51;
                }
                case 34: {
                    this.mMinWidth = a.getDimensionPixelSize(attr2, 0);
                    continue block51;
                }
                case 35: {
                    this.mMinHeight = a.getDimensionPixelSize(attr2, 0);
                    continue block51;
                }
                case 40: {
                    if (context.isRestricted()) {
                        throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                    }
                    final String handlerName = a.getString(attr2);
                    if (handlerName == null) continue block51;
                    this.setOnClickListener(new OnClickListener(){
                        public Method mHandler;

                        public void onClick(View v) {
                            if (this.mHandler == null) {
                                try {
                                    this.mHandler = View.this.getContext().getClass().getMethod(handlerName, View.class);
                                }
                                catch (NoSuchMethodException e) {
                                    int id2 = View.this.getId();
                                    String idText = id2 == -1 ? "" : " with id '" + View.this.getContext().getResources().getResourceEntryName(id2) + "'";
                                    throw new IllegalStateException("Could not find a method " + handlerName + "(View) in the activity " + View.this.getContext().getClass() + " for onClick handler" + " on view " + View.this.getClass() + idText, e);
                                }
                            }
                            try {
                                this.mHandler.invoke((Object)View.this.getContext(), View.this);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalStateException("Could not execute non public method of the activity", e);
                            }
                            catch (InvocationTargetException e) {
                                throw new IllegalStateException("Could not execute method of the activity", e);
                            }
                        }
                    });
                    continue block51;
                }
                case 45: {
                    overScrollMode = a.getInt(attr2, 1);
                    continue block51;
                }
                case 57: {
                    this.mVerticalScrollbarPosition = a.getInt(attr2, 0);
                    continue block51;
                }
                case 59: {
                    this.setLayerType(a.getInt(attr2, 0), null);
                }
            }
        }
        this.setOverScrollMode(overScrollMode);
        if (background != null) {
            this.setBackgroundDrawable(background);
        }
        if (padding >= 0) {
            leftPadding = padding;
            topPadding = padding;
            rightPadding = padding;
            bottomPadding = padding;
        }
        this.setPadding(leftPadding >= 0 ? leftPadding : this.mPaddingLeft, topPadding >= 0 ? topPadding : this.mPaddingTop, rightPadding >= 0 ? rightPadding : this.mPaddingRight, bottomPadding >= 0 ? bottomPadding : this.mPaddingBottom);
        if (viewFlagMasks != 0) {
            this.setFlags(viewFlagValues, viewFlagMasks);
        }
        if (scrollbarStyle != 0) {
            this.recomputePadding();
        }
        if (x != 0 || y != 0) {
            this.scrollTo(x, y);
        }
        if (transformSet) {
            this.setTranslationX(tx);
            this.setTranslationY(ty);
            this.setRotation(rotation);
            this.setRotationX(rotationX);
            this.setRotationY(rotationY);
            this.setScaleX(sx);
            this.setScaleY(sy);
        }
        if (!setScrollContainer && (viewFlagValues & 0x200) != 0) {
            this.setScrollContainer(true);
        }
        this.computeOpaqueFlags();
        a.recycle();
    }

    public View() {
    }

    public void initializeFadingEdge(TypedArray a) {
        this.initScrollCache();
        this.mScrollCache.fadingEdgeLength = a.getDimensionPixelSize(24, ViewConfiguration.get(this.mContext).getScaledFadingEdgeLength());
    }

    public int getVerticalFadingEdgeLength() {
        ScrollabilityCache cache;
        if (this.isVerticalFadingEdgeEnabled() && (cache = this.mScrollCache) != null) {
            return cache.fadingEdgeLength;
        }
        return 0;
    }

    public void setFadingEdgeLength(int length) {
        this.initScrollCache();
        this.mScrollCache.fadingEdgeLength = length;
    }

    public int getHorizontalFadingEdgeLength() {
        ScrollabilityCache cache;
        if (this.isHorizontalFadingEdgeEnabled() && (cache = this.mScrollCache) != null) {
            return cache.fadingEdgeLength;
        }
        return 0;
    }

    public int getVerticalScrollbarWidth() {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBarDrawable scrollBar = cache.scrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(true);
                if (size <= 0) {
                    size = cache.scrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    public int getHorizontalScrollbarHeight() {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            ScrollBarDrawable scrollBar = cache.scrollBar;
            if (scrollBar != null) {
                int size = scrollBar.getSize(false);
                if (size <= 0) {
                    size = cache.scrollBarSize;
                }
                return size;
            }
            return 0;
        }
        return 0;
    }

    public void initializeScrollbars(TypedArray a) {
        boolean alwaysDraw;
        boolean fadeScrollbars;
        this.initScrollCache();
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        if (scrollabilityCache.scrollBar == null) {
            scrollabilityCache.scrollBar = new ScrollBarDrawable();
        }
        if (!(fadeScrollbars = a.getBoolean(44, true))) {
            scrollabilityCache.state = 1;
        }
        scrollabilityCache.fadeScrollBars = fadeScrollbars;
        scrollabilityCache.scrollBarFadeDuration = a.getInt(42, ViewConfiguration.getScrollBarFadeDuration());
        scrollabilityCache.scrollBarDefaultDelayBeforeFade = a.getInt(43, ViewConfiguration.getScrollDefaultDelay());
        scrollabilityCache.scrollBarSize = a.getDimensionPixelSize(0, ViewConfiguration.get(this.mContext).getScaledScrollBarSize());
        Drawable track = a.getDrawable(3);
        scrollabilityCache.scrollBar.setHorizontalTrackDrawable(track);
        Drawable thumb = a.getDrawable(1);
        if (thumb != null) {
            scrollabilityCache.scrollBar.setHorizontalThumbDrawable(thumb);
        }
        if (alwaysDraw = a.getBoolean(5, false)) {
            scrollabilityCache.scrollBar.setAlwaysDrawHorizontalTrack(true);
        }
        track = a.getDrawable(4);
        scrollabilityCache.scrollBar.setVerticalTrackDrawable(track);
        thumb = a.getDrawable(2);
        if (thumb != null) {
            scrollabilityCache.scrollBar.setVerticalThumbDrawable(thumb);
        }
        if (alwaysDraw = a.getBoolean(6, false)) {
            scrollabilityCache.scrollBar.setAlwaysDrawVerticalTrack(true);
        }
        this.recomputePadding();
    }

    public void initScrollCache() {
        if (this.mScrollCache == null) {
            this.mScrollCache = new ScrollabilityCache(ViewConfiguration.get(this.mContext), this);
        }
    }

    public void setVerticalScrollbarPosition(int position) {
        if (this.mVerticalScrollbarPosition != position) {
            this.mVerticalScrollbarPosition = position;
            this.computeOpaqueFlags();
            this.recomputePadding();
        }
    }

    public int getVerticalScrollbarPosition() {
        return this.mVerticalScrollbarPosition;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener l) {
        this.mOnFocusChangeListener = l;
    }

    public void addOnLayoutChangeListener(OnLayoutChangeListener listener) {
        if (this.mOnLayoutChangeListeners == null) {
            this.mOnLayoutChangeListeners = new ArrayList();
        }
        this.mOnLayoutChangeListeners.add(listener);
    }

    public void removeOnLayoutChangeListener(OnLayoutChangeListener listener) {
        if (this.mOnLayoutChangeListeners == null) {
            return;
        }
        this.mOnLayoutChangeListeners.remove(listener);
    }

    public OnFocusChangeListener getOnFocusChangeListener() {
        return this.mOnFocusChangeListener;
    }

    public void setOnClickListener(OnClickListener l) {
        if (!this.isClickable()) {
            this.setClickable(true);
        }
        this.mOnClickListener = l;
    }

    public void setOnLongClickListener(OnLongClickListener l) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnLongClickListener = l;
    }

    public void setOnCreateContextMenuListener(OnCreateContextMenuListener l) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnCreateContextMenuListener = l;
    }

    public boolean performClick() {
        this.sendAccessibilityEvent(1);
        if (this.mOnClickListener != null) {
            this.playSoundEffect(0);
            this.mOnClickListener.onClick(this);
            return true;
        }
        return false;
    }

    public boolean performLongClick() {
        this.sendAccessibilityEvent(2);
        boolean handled = false;
        if (this.mOnLongClickListener != null) {
            handled = this.mOnLongClickListener.onLongClick(this);
        }
        if (!handled) {
            handled = this.showContextMenu();
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    public boolean showContextMenu() {
        return this.getParent().showContextMenuForChild(this);
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        return this.getParent().startActionModeForChild(this, callback);
    }

    public void setOnKeyListener(OnKeyListener l) {
        this.mOnKeyListener = l;
    }

    public void setOnTouchListener(OnTouchListener l) {
        this.mOnTouchListener = l;
    }

    public void setOnDragListener(OnDragListener l) {
        this.mOnDragListener = l;
    }

    public void handleFocusGainInternal(int direction, Rect previouslyFocusedRect) {
        if ((this.mPrivateFlags & 2) == 0) {
            this.mPrivateFlags |= 2;
            if (this.mParent != null) {
                this.mParent.requestChildFocus(this, this);
            }
            this.onFocusChanged(true, direction, previouslyFocusedRect);
            this.refreshDrawableState();
        }
    }

    public boolean requestRectangleOnScreen(Rect rectangle) {
        return this.requestRectangleOnScreen(rectangle, false);
    }

    public boolean requestRectangleOnScreen(Rect rectangle, boolean immediate) {
        View child = this;
        ViewParent parent = this.mParent;
        boolean scrolled = false;
        while (parent != null) {
            scrolled |= parent.requestChildRectangleOnScreen(child, rectangle, immediate);
            rectangle.offset(child.getLeft(), child.getTop());
            rectangle.offset(-child.getScrollX(), -child.getScrollY());
            if (!(parent instanceof View)) break;
            child = (View)((Object)parent);
            parent = child.getParent();
        }
        return scrolled;
    }

    public void clearFocus() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            if (this.mParent != null) {
                this.mParent.clearChildFocus(this);
            }
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
        }
    }

    public void clearFocusForRemoval() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
        }
    }

    public void unFocus() {
        if ((this.mPrivateFlags & 2) != 0) {
            this.mPrivateFlags &= 0xFFFFFFFD;
            this.onFocusChanged(false, 0, null);
            this.refreshDrawableState();
        }
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean hasFocus() {
        return (this.mPrivateFlags & 2) != 0;
    }

    public boolean hasFocusable() {
        return (this.mViewFlags & 0xC) == 0 && this.isFocusable();
    }

    public void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (gainFocus) {
            this.sendAccessibilityEvent(8);
        }
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (!gainFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            if (imm != null && this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus) {
                imm.focusOut(this);
            }
            this.onFocusLost();
        } else if (imm != null && this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus) {
            imm.focusIn(this);
        }
        this.invalidate(true);
        if (this.mOnFocusChangeListener != null) {
            this.mOnFocusChangeListener.onFocusChange(this, gainFocus);
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mKeyDispatchState.reset(this);
        }
    }

    @Override
    public void sendAccessibilityEvent(int eventType) {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            this.sendAccessibilityEventUnchecked(AccessibilityEvent.obtain(eventType));
        }
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (!this.isShown()) {
            return;
        }
        event.setClassName(this.getClass().getName());
        event.setPackageName(this.getContext().getPackageName());
        event.setEnabled(this.isEnabled());
        event.setContentDescription(this.mContentDescription);
        if (event.getEventType() == 8 && this.mAttachInfo != null) {
            ArrayList<View> focusablesTempList = this.mAttachInfo.mFocusablesTempList;
            this.getRootView().addFocusables(focusablesTempList, 2, 0);
            event.setItemCount(focusablesTempList.size());
            event.setCurrentItemIndex(focusablesTempList.indexOf(this));
            focusablesTempList.clear();
        }
        this.dispatchPopulateAccessibilityEvent(event);
        AccessibilityManager.getInstance(this.mContext).sendAccessibilityEvent(event);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return false;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
    }

    public void onFocusLost() {
        this.resetPressedState();
    }

    public void resetPressedState() {
        if ((this.mViewFlags & 0x20) == 32) {
            return;
        }
        if (this.isPressed()) {
            this.setPressed(false);
            if (!this.mHasPerformedLongPress) {
                this.removeLongPressCallback();
            }
        }
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean isFocused() {
        return (this.mPrivateFlags & 2) != 0;
    }

    public View findFocus() {
        return (this.mPrivateFlags & 2) != 0 ? this : null;
    }

    public void setScrollContainer(boolean isScrollContainer) {
        if (isScrollContainer) {
            if (this.mAttachInfo != null && (this.mPrivateFlags & 0x100000) == 0) {
                this.mAttachInfo.mScrollContainers.add(this);
                this.mPrivateFlags |= 0x100000;
            }
            this.mPrivateFlags |= 0x80000;
        } else {
            if ((this.mPrivateFlags & 0x100000) != 0) {
                this.mAttachInfo.mScrollContainers.remove(this);
            }
            this.mPrivateFlags &= 0xFFE7FFFF;
        }
    }

    public int getDrawingCacheQuality() {
        return this.mViewFlags & 0x180000;
    }

    public void setDrawingCacheQuality(int quality) {
        this.setFlags(quality, 0x180000);
    }

    public boolean getKeepScreenOn() {
        return (this.mViewFlags & 0x4000000) != 0;
    }

    public void setKeepScreenOn(boolean keepScreenOn) {
        this.setFlags(keepScreenOn ? 0x4000000 : 0, 0x4000000);
    }

    public int getNextFocusLeftId() {
        return this.mNextFocusLeftId;
    }

    public void setNextFocusLeftId(int nextFocusLeftId) {
        this.mNextFocusLeftId = nextFocusLeftId;
    }

    public int getNextFocusRightId() {
        return this.mNextFocusRightId;
    }

    public void setNextFocusRightId(int nextFocusRightId) {
        this.mNextFocusRightId = nextFocusRightId;
    }

    public int getNextFocusUpId() {
        return this.mNextFocusUpId;
    }

    public void setNextFocusUpId(int nextFocusUpId) {
        this.mNextFocusUpId = nextFocusUpId;
    }

    public int getNextFocusDownId() {
        return this.mNextFocusDownId;
    }

    public void setNextFocusDownId(int nextFocusDownId) {
        this.mNextFocusDownId = nextFocusDownId;
    }

    public int getNextFocusForwardId() {
        return this.mNextFocusForwardId;
    }

    public void setNextFocusForwardId(int nextFocusForwardId) {
        this.mNextFocusForwardId = nextFocusForwardId;
    }

    public boolean isShown() {
        ViewParent parent;
        View current = this;
        do {
            if ((current.mViewFlags & 0xC) != 0) {
                return false;
            }
            parent = current.mParent;
            if (parent == null) {
                return false;
            }
            if (parent instanceof View) continue;
            return true;
        } while ((current = (View)((Object)parent)) != null);
        return false;
    }

    public boolean fitSystemWindows(Rect insets) {
        if ((this.mViewFlags & 2) == 2) {
            this.mPaddingLeft = insets.left;
            this.mPaddingTop = insets.top;
            this.mPaddingRight = insets.right;
            this.mPaddingBottom = insets.bottom;
            this.requestLayout();
            return true;
        }
        return false;
    }

    public boolean isFitsSystemWindowsFlagSet() {
        return (this.mViewFlags & 2) == 2;
    }

    @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=0, to="VISIBLE"), @ViewDebug.IntToString(from=4, to="INVISIBLE"), @ViewDebug.IntToString(from=8, to="GONE")})
    public int getVisibility() {
        return this.mViewFlags & 0xC;
    }

    @RemotableViewMethod
    public void setVisibility(int visibility) {
        this.setFlags(visibility, 12);
        if (this.mBGDrawable != null) {
            this.mBGDrawable.setVisible(visibility == 0, false);
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isEnabled() {
        return (this.mViewFlags & 0x20) == 0;
    }

    @RemotableViewMethod
    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        this.setFlags(enabled ? 0 : 32, 32);
        this.refreshDrawableState();
        this.invalidate(true);
    }

    public void setFocusable(boolean focusable) {
        if (!focusable) {
            this.setFlags(0, 262144);
        }
        this.setFlags(focusable ? 1 : 0, 1);
    }

    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        this.setFlags(focusableInTouchMode ? 262144 : 0, 262144);
        if (focusableInTouchMode) {
            this.setFlags(1, 1);
        }
    }

    public void setSoundEffectsEnabled(boolean soundEffectsEnabled) {
        this.setFlags(soundEffectsEnabled ? 0x8000000 : 0, 0x8000000);
    }

    @ViewDebug.ExportedProperty
    public boolean isSoundEffectsEnabled() {
        return 0x8000000 == (this.mViewFlags & 0x8000000);
    }

    public void setHapticFeedbackEnabled(boolean hapticFeedbackEnabled) {
        this.setFlags(hapticFeedbackEnabled ? 0x10000000 : 0, 0x10000000);
    }

    @ViewDebug.ExportedProperty
    public boolean isHapticFeedbackEnabled() {
        return 0x10000000 == (this.mViewFlags & 0x10000000);
    }

    public void setWillNotDraw(boolean willNotDraw) {
        this.setFlags(willNotDraw ? 128 : 0, 128);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean willNotDraw() {
        return (this.mViewFlags & 0x80) == 128;
    }

    public void setWillNotCacheDrawing(boolean willNotCacheDrawing) {
        this.setFlags(willNotCacheDrawing ? 131072 : 0, 131072);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean willNotCacheDrawing() {
        return (this.mViewFlags & 0x20000) == 131072;
    }

    @ViewDebug.ExportedProperty
    public boolean isClickable() {
        return (this.mViewFlags & 0x4000) == 16384;
    }

    public void setClickable(boolean clickable) {
        this.setFlags(clickable ? 16384 : 0, 16384);
    }

    public boolean isLongClickable() {
        return (this.mViewFlags & 0x200000) == 0x200000;
    }

    public void setLongClickable(boolean longClickable) {
        this.setFlags(longClickable ? 0x200000 : 0, 0x200000);
    }

    public void setPressed(boolean pressed) {
        this.mPrivateFlags = pressed ? (this.mPrivateFlags |= 0x4000) : (this.mPrivateFlags &= 0xFFFFBFFF);
        this.refreshDrawableState();
        this.dispatchSetPressed(pressed);
    }

    public void dispatchSetPressed(boolean pressed) {
    }

    public boolean isPressed() {
        return (this.mPrivateFlags & 0x4000) == 16384;
    }

    public boolean isSaveEnabled() {
        return (this.mViewFlags & 0x10000) != 65536;
    }

    public void setSaveEnabled(boolean enabled) {
        this.setFlags(enabled ? 0 : 65536, 65536);
    }

    @ViewDebug.ExportedProperty
    public boolean getFilterTouchesWhenObscured() {
        return (this.mViewFlags & 0x400) != 0;
    }

    public void setFilterTouchesWhenObscured(boolean enabled) {
        this.setFlags(enabled ? 0 : 1024, 1024);
    }

    public boolean isSaveFromParentEnabled() {
        return (this.mViewFlags & 0x20000000) != 0x20000000;
    }

    public void setSaveFromParentEnabled(boolean enabled) {
        this.setFlags(enabled ? 0 : 0x20000000, 0x20000000);
    }

    @ViewDebug.ExportedProperty(category="focus")
    public boolean isFocusable() {
        return 1 == (this.mViewFlags & 1);
    }

    @ViewDebug.ExportedProperty
    public boolean isFocusableInTouchMode() {
        return 262144 == (this.mViewFlags & 0x40000);
    }

    public View focusSearch(int direction) {
        if (this.mParent != null) {
            return this.mParent.focusSearch(this, direction);
        }
        return null;
    }

    public boolean dispatchUnhandledMove(View focused, int direction) {
        return false;
    }

    public View findUserSetNextFocus(View root, int direction) {
        switch (direction) {
            case 17: {
                if (this.mNextFocusLeftId == -1) {
                    return null;
                }
                return View.findViewShouldExist(root, this.mNextFocusLeftId);
            }
            case 66: {
                if (this.mNextFocusRightId == -1) {
                    return null;
                }
                return View.findViewShouldExist(root, this.mNextFocusRightId);
            }
            case 33: {
                if (this.mNextFocusUpId == -1) {
                    return null;
                }
                return View.findViewShouldExist(root, this.mNextFocusUpId);
            }
            case 130: {
                if (this.mNextFocusDownId == -1) {
                    return null;
                }
                return View.findViewShouldExist(root, this.mNextFocusDownId);
            }
            case 2: {
                if (this.mNextFocusForwardId == -1) {
                    return null;
                }
                return View.findViewShouldExist(root, this.mNextFocusForwardId);
            }
            case 1: {
                final int id2 = this.mID;
                return root.findViewByPredicate(new Predicate<View>(){

                    @Override
                    public boolean apply(View t) {
                        return t.mNextFocusForwardId == id2;
                    }
                });
            }
        }
        return null;
    }

    public static View findViewShouldExist(View root, int childViewId) {
        View result = root.findViewById(childViewId);
        if (result == null) {
            Log.w(VIEW_LOG_TAG, "couldn't find next focus view specified by user for id " + childViewId);
        }
        return result;
    }

    public ArrayList<View> getFocusables(int direction) {
        ArrayList<View> result = new ArrayList<View>(24);
        this.addFocusables(result, direction);
        return result;
    }

    public void addFocusables(ArrayList<View> views, int direction) {
        this.addFocusables(views, direction, 1);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (!this.isFocusable()) {
            return;
        }
        if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
            return;
        }
        if (views != null) {
            views.add(this);
        }
    }

    public ArrayList<View> getTouchables() {
        ArrayList<View> result = new ArrayList<View>();
        this.addTouchables(result);
        return result;
    }

    public void addTouchables(ArrayList<View> views) {
        int viewFlags = this.mViewFlags;
        if (((viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000) && (viewFlags & 0x20) == 0) {
            views.add(this);
        }
    }

    public boolean requestFocus() {
        return this.requestFocus(130);
    }

    public boolean requestFocus(int direction) {
        return this.requestFocus(direction, null);
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if ((this.mViewFlags & 1) != 1 || (this.mViewFlags & 0xC) != 0) {
            return false;
        }
        if (this.isInTouchMode() && 262144 != (this.mViewFlags & 0x40000)) {
            return false;
        }
        if (this.hasAncestorThatBlocksDescendantFocus()) {
            return false;
        }
        this.handleFocusGainInternal(direction, previouslyFocusedRect);
        return true;
    }

    public ViewRoot getViewRoot() {
        View root = this.getRootView();
        return root != null ? (ViewRoot)root.getParent() : null;
    }

    public boolean requestFocusFromTouch() {
        ViewRoot viewRoot;
        if (this.isInTouchMode() && (viewRoot = this.getViewRoot()) != null) {
            viewRoot.ensureTouchMode(false);
        }
        return this.requestFocus(130);
    }

    public boolean hasAncestorThatBlocksDescendantFocus() {
        ViewParent ancestor = this.mParent;
        while (ancestor instanceof ViewGroup) {
            ViewGroup vgAncestor = (ViewGroup)ancestor;
            if (vgAncestor.getDescendantFocusability() == 393216) {
                return true;
            }
            ancestor = vgAncestor.getParent();
        }
        return false;
    }

    public void dispatchStartTemporaryDetach() {
        this.onStartTemporaryDetach();
    }

    public void onStartTemporaryDetach() {
        this.removeUnsetPressCallback();
        this.mPrivateFlags |= 0x4000000;
    }

    public void dispatchFinishTemporaryDetach() {
        this.onFinishTemporaryDetach();
    }

    public void onFinishTemporaryDetach() {
    }

    public static void captureViewInfo(String subTag, View v) {
        if (v == null || SystemProperties.getInt("debug.captureview", 0) == 0) {
            return;
        }
        ViewDebug.dumpCapturedView(subTag, v);
    }

    public KeyEvent.DispatcherState getKeyDispatcherState() {
        return this.mAttachInfo != null ? this.mAttachInfo.mKeyDispatchState : null;
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        return this.onKeyPreIme(event.getKeyCode(), event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mOnKeyListener != null && (this.mViewFlags & 0x20) == 0 && this.mOnKeyListener.onKey(this, event.getKeyCode(), event)) {
            return true;
        }
        return event.dispatch(this, this.mAttachInfo != null ? this.mAttachInfo.mKeyDispatchState : null, this);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (!this.onFilterTouchEventForSecurity(event)) {
            return false;
        }
        if (this.mOnTouchListener != null && (this.mViewFlags & 0x20) == 0 && this.mOnTouchListener.onTouch(this, event)) {
            return true;
        }
        return this.onTouchEvent(event);
    }

    public boolean onFilterTouchEventForSecurity(MotionEvent event) {
        return (this.mViewFlags & 0x400) == 0 || (event.getFlags() & 1) == 0;
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        return this.onTrackballEvent(event);
    }

    public void dispatchWindowFocusChanged(boolean hasFocus) {
        this.onWindowFocusChanged(hasFocus);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (!hasWindowFocus) {
            if (this.isPressed()) {
                this.setPressed(false);
            }
            if (imm != null && (this.mPrivateFlags & 2) != 0) {
                imm.focusOut(this);
            }
            this.removeLongPressCallback();
            this.removeTapCallback();
            this.onFocusLost();
        } else if (imm != null && (this.mPrivateFlags & 2) != 0) {
            imm.focusIn(this);
        }
        this.refreshDrawableState();
    }

    public boolean hasWindowFocus() {
        return this.mAttachInfo != null && this.mAttachInfo.mHasWindowFocus;
    }

    public void dispatchVisibilityChanged(View changedView, int visibility) {
        this.onVisibilityChanged(changedView, visibility);
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        if (visibility == 0) {
            if (this.mAttachInfo != null) {
                this.initialAwakenScrollBars();
            } else {
                this.mPrivateFlags |= 0x8000000;
            }
        }
    }

    public void dispatchDisplayHint(int hint) {
        this.onDisplayHint(hint);
    }

    public void onDisplayHint(int hint) {
    }

    public void dispatchWindowVisibilityChanged(int visibility) {
        this.onWindowVisibilityChanged(visibility);
    }

    public void onWindowVisibilityChanged(int visibility) {
        if (visibility == 0) {
            this.initialAwakenScrollBars();
        }
    }

    public int getWindowVisibility() {
        return this.mAttachInfo != null ? this.mAttachInfo.mWindowVisibility : 8;
    }

    public void getWindowVisibleDisplayFrame(Rect outRect) {
        if (this.mAttachInfo != null) {
            try {
                this.mAttachInfo.mSession.getDisplayFrame(this.mAttachInfo.mWindow, outRect);
            }
            catch (RemoteException e) {
                return;
            }
            Rect insets = this.mAttachInfo.mVisibleInsets;
            outRect.left += insets.left;
            outRect.top += insets.top;
            outRect.right -= insets.right;
            outRect.bottom -= insets.bottom;
            return;
        }
        Display d = WindowManagerImpl.getDefault().getDefaultDisplay();
        outRect.set(0, 0, d.getWidth(), d.getHeight());
    }

    public void dispatchConfigurationChanged(Configuration newConfig) {
        this.onConfigurationChanged(newConfig);
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void dispatchCollectViewAttributes(int visibility) {
        this.performCollectViewAttributes(visibility);
    }

    public void performCollectViewAttributes(int visibility) {
        if ((visibility & 0xC) == 0 && this.mAttachInfo != null) {
            if ((this.mViewFlags & 0x4000000) == 0x4000000) {
                this.mAttachInfo.mKeepScreenOn = true;
            }
            this.mAttachInfo.mSystemUiVisibility |= this.mSystemUiVisibility;
            if (this.mOnSystemUiVisibilityChangeListener != null) {
                this.mAttachInfo.mHasSystemUiListeners = true;
            }
        }
    }

    public void needGlobalAttributesUpdate(boolean force) {
        AttachInfo ai = this.mAttachInfo;
        if (ai != null && (force || ai.mKeepScreenOn || ai.mSystemUiVisibility != 0 || ai.mHasSystemUiListeners)) {
            ai.mRecomputeGlobalAttributes = true;
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isInTouchMode() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mInTouchMode;
        }
        return ViewRoot.isInTouchMode();
    }

    @ViewDebug.CapturedViewProperty
    public Context getContext() {
        return this.mContext;
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean result = false;
        switch (keyCode) {
            case 23: 
            case 66: {
                if ((this.mViewFlags & 0x20) == 32) {
                    return true;
                }
                if ((this.mViewFlags & 0x4000) != 16384 && (this.mViewFlags & 0x200000) != 0x200000 || event.getRepeatCount() != 0) break;
                this.setPressed(true);
                if ((this.mViewFlags & 0x200000) == 0x200000) {
                    this.postCheckForLongClick(0);
                }
                return true;
            }
        }
        return result;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean result = false;
        switch (keyCode) {
            case 23: 
            case 66: {
                if ((this.mViewFlags & 0x20) == 32) {
                    return true;
                }
                if ((this.mViewFlags & 0x4000) != 16384 || !this.isPressed()) break;
                this.setPressed(false);
                if (this.mHasPerformedLongPress) break;
                this.removeLongPressCallback();
                result = this.performClick();
            }
        }
        return result;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return false;
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onCheckIsTextEditor() {
        return false;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return null;
    }

    public boolean checkInputConnectionProxy(View view) {
        return false;
    }

    public void createContextMenu(ContextMenu menu2) {
        ContextMenu.ContextMenuInfo menuInfo = this.getContextMenuInfo();
        ((MenuBuilder)((Object)menu2)).setCurrentMenuInfo(menuInfo);
        this.onCreateContextMenu(menu2);
        if (this.mOnCreateContextMenuListener != null) {
            this.mOnCreateContextMenuListener.onCreateContextMenu(menu2, this, menuInfo);
        }
        ((MenuBuilder)((Object)menu2)).setCurrentMenuInfo(null);
        if (this.mParent != null) {
            this.mParent.createContextMenu(menu2);
        }
    }

    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return null;
    }

    public void onCreateContextMenu(ContextMenu menu2) {
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x20) == 32) {
            return (viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000;
        }
        if (this.mTouchDelegate != null && this.mTouchDelegate.onTouchEvent(event)) {
            return true;
        }
        if ((viewFlags & 0x4000) == 16384 || (viewFlags & 0x200000) == 0x200000) {
            switch (event.getAction()) {
                case 1: {
                    boolean prepressed;
                    boolean bl = prepressed = (this.mPrivateFlags & 0x2000000) != 0;
                    if ((this.mPrivateFlags & 0x4000) == 0 && !prepressed) break;
                    boolean focusTaken = false;
                    if (this.isFocusable() && this.isFocusableInTouchMode() && !this.isFocused()) {
                        focusTaken = this.requestFocus();
                    }
                    if (prepressed) {
                        this.mPrivateFlags |= 0x4000;
                        this.refreshDrawableState();
                    }
                    if (!this.mHasPerformedLongPress) {
                        this.removeLongPressCallback();
                        if (!focusTaken) {
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick(null);
                            }
                            if (!this.post(this.mPerformClick)) {
                                this.performClick();
                            }
                        }
                    }
                    if (this.mUnsetPressedState == null) {
                        this.mUnsetPressedState = new UnsetPressedState(null);
                    }
                    if (prepressed) {
                        this.postDelayed(this.mUnsetPressedState, ViewConfiguration.getPressedStateDuration());
                    } else if (!this.post(this.mUnsetPressedState)) {
                        this.mUnsetPressedState.run();
                    }
                    this.removeTapCallback();
                    break;
                }
                case 0: {
                    if (this.mPendingCheckForTap == null) {
                        this.mPendingCheckForTap = new CheckForTap(null);
                    }
                    this.mPrivateFlags |= 0x2000000;
                    this.mHasPerformedLongPress = false;
                    this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    break;
                }
                case 3: {
                    this.mPrivateFlags &= 0xFFFFBFFF;
                    this.refreshDrawableState();
                    this.removeTapCallback();
                    break;
                }
                case 2: {
                    int x = (int)event.getX();
                    int y = (int)event.getY();
                    if (this.pointInView(x, y, this.mTouchSlop)) break;
                    this.removeTapCallback();
                    if ((this.mPrivateFlags & 0x4000) == 0) break;
                    this.removeLongPressCallback();
                    this.mPrivateFlags &= 0xFFFFBFFF;
                    this.refreshDrawableState();
                }
            }
            return true;
        }
        return false;
    }

    public void removeLongPressCallback() {
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
    }

    public void removePerformClickCallback() {
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
    }

    public void removeUnsetPressCallback() {
        if ((this.mPrivateFlags & 0x4000) != 0 && this.mUnsetPressedState != null) {
            this.setPressed(false);
            this.removeCallbacks(this.mUnsetPressedState);
        }
    }

    public void removeTapCallback() {
        if (this.mPendingCheckForTap != null) {
            this.mPrivateFlags &= 0xFDFFFFFF;
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    public void cancelLongPress() {
        this.removeLongPressCallback();
        this.removeTapCallback();
    }

    public void setTouchDelegate(TouchDelegate delegate) {
        this.mTouchDelegate = delegate;
    }

    public TouchDelegate getTouchDelegate() {
        return this.mTouchDelegate;
    }

    public void setFlags(int flags, int mask) {
        int old = this.mViewFlags;
        this.mViewFlags = this.mViewFlags & ~mask | flags & mask;
        int changed = this.mViewFlags ^ old;
        if (changed == 0) {
            return;
        }
        int privateFlags = this.mPrivateFlags;
        if ((changed & 1) != 0 && (privateFlags & 0x10) != 0) {
            if ((old & 1) == 1 && (privateFlags & 2) != 0) {
                this.clearFocus();
            } else if ((old & 1) == 0 && (privateFlags & 2) == 0 && this.mParent != null) {
                this.mParent.focusableViewAvailable(this);
            }
        }
        if ((flags & 0xC) == 0 && (changed & 0xC) != 0) {
            this.mPrivateFlags |= 0x20;
            this.needGlobalAttributesUpdate(true);
            if (this.mParent != null && this.mBottom > this.mTop && this.mRight > this.mLeft) {
                this.mParent.focusableViewAvailable(this);
            }
        }
        if ((changed & 8) != 0) {
            this.needGlobalAttributesUpdate(false);
            this.requestLayout();
            this.invalidate(true);
            if ((this.mViewFlags & 0xC) == 8) {
                if (this.hasFocus()) {
                    this.clearFocus();
                }
                this.destroyDrawingCache();
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 4) != 0) {
            this.needGlobalAttributesUpdate(false);
            this.invalidate(true);
            if ((this.mViewFlags & 0xC) == 4 && this.hasFocus() && this.getRootView() != this) {
                this.clearFocus();
            }
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mViewVisibilityChanged = true;
            }
        }
        if ((changed & 0xC) != 0) {
            if (this.mParent instanceof ViewGroup) {
                ((ViewGroup)this.mParent).onChildVisibilityChanged(this, flags & 0xC);
                ((View)((Object)this.mParent)).invalidate(true);
            }
            this.dispatchVisibilityChanged(this, flags & 0xC);
        }
        if ((changed & 0x20000) != 0) {
            this.destroyDrawingCache();
        }
        if ((changed & 0x8000) != 0) {
            this.destroyDrawingCache();
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.invalidateParentCaches();
        }
        if ((changed & 0x180000) != 0) {
            this.destroyDrawingCache();
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
        if ((changed & 0x80) != 0) {
            if ((this.mViewFlags & 0x80) != 0) {
                if (this.mBGDrawable != null) {
                    this.mPrivateFlags &= 0xFFFFFF7F;
                    this.mPrivateFlags |= 0x100;
                } else {
                    this.mPrivateFlags |= 0x80;
                }
            } else {
                this.mPrivateFlags &= 0xFFFFFF7F;
            }
            this.requestLayout();
            this.invalidate(true);
        }
        if ((changed & 0x4000000) != 0 && this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mParent.recomputeViewAttributes(this);
        }
    }

    public void bringToFront() {
        if (this.mParent != null) {
            this.mParent.bringChildToFront(this);
        }
    }

    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        this.mBackgroundSizeChanged = true;
        AttachInfo ai = this.mAttachInfo;
        if (ai != null) {
            ai.mViewScrollChanged = true;
        }
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
    }

    public void dispatchDraw(Canvas canvas) {
    }

    public ViewParent getParent() {
        return this.mParent;
    }

    public int getScrollX() {
        return this.mScrollX;
    }

    public int getScrollY() {
        return this.mScrollY;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getWidth() {
        return this.mRight - this.mLeft;
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getHeight() {
        return this.mBottom - this.mTop;
    }

    public void getDrawingRect(Rect outRect) {
        outRect.left = this.mScrollX;
        outRect.top = this.mScrollY;
        outRect.right = this.mScrollX + (this.mRight - this.mLeft);
        outRect.bottom = this.mScrollY + (this.mBottom - this.mTop);
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth & 0xFFFFFF;
    }

    public int getMeasuredWidthAndState() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight & 0xFFFFFF;
    }

    public int getMeasuredHeightAndState() {
        return this.mMeasuredHeight;
    }

    public int getMeasuredState() {
        return this.mMeasuredWidth & 0xFF000000 | this.mMeasuredHeight >> 16 & 0xFFFFFF00;
    }

    public Matrix getMatrix() {
        this.updateMatrix();
        return this.mMatrix;
    }

    public static boolean nonzero(float value) {
        return value < -0.001f || value > 0.001f;
    }

    public boolean hasIdentityMatrix() {
        this.updateMatrix();
        return this.mMatrixIsIdentity;
    }

    public void updateMatrix() {
        if (this.mMatrixDirty) {
            if ((this.mPrivateFlags & 0x20000000) == 0 && (this.mRight - this.mLeft != this.mPrevWidth || this.mBottom - this.mTop != this.mPrevHeight)) {
                this.mPrevWidth = this.mRight - this.mLeft;
                this.mPrevHeight = this.mBottom - this.mTop;
                this.mPivotX = (float)this.mPrevWidth / 2.0f;
                this.mPivotY = (float)this.mPrevHeight / 2.0f;
            }
            this.mMatrix.reset();
            if (!View.nonzero(this.mRotationX) && !View.nonzero(this.mRotationY)) {
                this.mMatrix.setTranslate(this.mTranslationX, this.mTranslationY);
                this.mMatrix.preRotate(this.mRotation, this.mPivotX, this.mPivotY);
                this.mMatrix.preScale(this.mScaleX, this.mScaleY, this.mPivotX, this.mPivotY);
            } else {
                if (this.mCamera == null) {
                    this.mCamera = new Camera();
                    this.matrix3D = new Matrix();
                }
                this.mCamera.save();
                this.mMatrix.preScale(this.mScaleX, this.mScaleY, this.mPivotX, this.mPivotY);
                this.mCamera.rotateX(this.mRotationX);
                this.mCamera.rotateY(this.mRotationY);
                this.mCamera.rotateZ(-this.mRotation);
                this.mCamera.getMatrix(this.matrix3D);
                this.matrix3D.preTranslate(-this.mPivotX, -this.mPivotY);
                this.matrix3D.postTranslate(this.mPivotX + this.mTranslationX, this.mPivotY + this.mTranslationY);
                this.mMatrix.postConcat(this.matrix3D);
                this.mCamera.restore();
            }
            this.mMatrixDirty = false;
            this.mMatrixIsIdentity = this.mMatrix.isIdentity();
            this.mInverseMatrixDirty = true;
        }
    }

    public Matrix getInverseMatrix() {
        this.updateMatrix();
        if (this.mInverseMatrixDirty) {
            if (this.mInverseMatrix == null) {
                this.mInverseMatrix = new Matrix();
            }
            this.mMatrix.invert(this.mInverseMatrix);
            this.mInverseMatrixDirty = false;
        }
        return this.mInverseMatrix;
    }

    public float getRotation() {
        return this.mRotation;
    }

    public void setRotation(float rotation) {
        if (this.mRotation != rotation) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mRotation = rotation;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getRotationY() {
        return this.mRotationY;
    }

    public void setRotationY(float rotationY) {
        if (this.mRotationY != rotationY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mRotationY = rotationY;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getRotationX() {
        return this.mRotationX;
    }

    public void setRotationX(float rotationX) {
        if (this.mRotationX != rotationX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mRotationX = rotationX;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public void setScaleX(float scaleX) {
        if (this.mScaleX != scaleX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mScaleX = scaleX;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setScaleY(float scaleY) {
        if (this.mScaleY != scaleY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mScaleY = scaleY;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getPivotX() {
        return this.mPivotX;
    }

    public void setPivotX(float pivotX) {
        this.mPrivateFlags |= 0x20000000;
        if (this.mPivotX != pivotX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mPivotX = pivotX;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getPivotY() {
        return this.mPivotY;
    }

    public void setPivotY(float pivotY) {
        this.mPrivateFlags |= 0x20000000;
        if (this.mPivotY != pivotY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mPivotY = pivotY;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
        this.invalidateParentCaches();
        if (this.onSetAlpha((int)(alpha * 255.0f))) {
            this.mPrivateFlags |= 0x40000;
            this.invalidate(true);
        } else {
            this.mPrivateFlags &= 0xFFFBFFFF;
            this.invalidate(false);
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getTop() {
        return this.mTop;
    }

    public void setTop(int top) {
        if (top != this.mTop) {
            this.updateMatrix();
            if (this.mMatrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    int yLoc;
                    int minTop;
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    if (top < this.mTop) {
                        minTop = top;
                        yLoc = top - this.mTop;
                    } else {
                        minTop = this.mTop;
                        yLoc = 0;
                    }
                    r.set(0, yLoc, this.mRight - this.mLeft, this.mBottom - minTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(true);
            }
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mTop = top;
            this.onSizeChanged(width, this.mBottom - this.mTop, width, oldHeight);
            if (!this.mMatrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getBottom() {
        return this.mBottom;
    }

    public boolean isDirty() {
        return (this.mPrivateFlags & 0x600000) != 0;
    }

    public void setBottom(int bottom) {
        if (bottom != this.mBottom) {
            this.updateMatrix();
            if (this.mMatrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    int maxBottom = bottom < this.mBottom ? this.mBottom : bottom;
                    r.set(0, 0, this.mRight - this.mLeft, maxBottom - this.mTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(true);
            }
            int width = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mBottom = bottom;
            this.onSizeChanged(width, this.mBottom - this.mTop, width, oldHeight);
            if (!this.mMatrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getLeft() {
        return this.mLeft;
    }

    public void setLeft(int left) {
        if (left != this.mLeft) {
            this.updateMatrix();
            if (this.mMatrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    int xLoc;
                    int minLeft;
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    if (left < this.mLeft) {
                        minLeft = left;
                        xLoc = left - this.mLeft;
                    } else {
                        minLeft = this.mLeft;
                        xLoc = 0;
                    }
                    r.set(xLoc, 0, this.mRight - minLeft, this.mBottom - this.mTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(true);
            }
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mLeft = left;
            this.onSizeChanged(this.mRight - this.mLeft, height, oldWidth, height);
            if (!this.mMatrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.CapturedViewProperty
    public int getRight() {
        return this.mRight;
    }

    public void setRight(int right) {
        if (right != this.mRight) {
            this.updateMatrix();
            if (this.mMatrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    int maxRight = right < this.mRight ? this.mRight : right;
                    r.set(0, 0, maxRight - this.mLeft, this.mBottom - this.mTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(true);
            }
            int oldWidth = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            this.mRight = right;
            this.onSizeChanged(this.mRight - this.mLeft, height, oldWidth, height);
            if (!this.mMatrixIsIdentity) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mMatrixDirty = true;
                }
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
            }
            this.mBackgroundSizeChanged = true;
            this.invalidateParentIfNeeded();
        }
    }

    public float getX() {
        return (float)this.mLeft + this.mTranslationX;
    }

    public void setX(float x) {
        this.setTranslationX(x - (float)this.mLeft);
    }

    public float getY() {
        return (float)this.mTop + this.mTranslationY;
    }

    public void setY(float y) {
        this.setTranslationY(y - (float)this.mTop);
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public void setTranslationX(float translationX) {
        if (this.mTranslationX != translationX) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mTranslationX = translationX;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public void setTranslationY(float translationY) {
        if (this.mTranslationY != translationY) {
            this.invalidateParentCaches();
            this.invalidate(false);
            this.mTranslationY = translationY;
            this.mMatrixDirty = true;
            this.mPrivateFlags |= 0x20;
            this.invalidate(false);
        }
    }

    public void setFastTranslationX(float x) {
        this.mTranslationX = x;
        this.mMatrixDirty = true;
    }

    public void setFastTranslationY(float y) {
        this.mTranslationY = y;
        this.mMatrixDirty = true;
    }

    public void setFastX(float x) {
        this.mTranslationX = x - (float)this.mLeft;
        this.mMatrixDirty = true;
    }

    public void setFastY(float y) {
        this.mTranslationY = y - (float)this.mTop;
        this.mMatrixDirty = true;
    }

    public void setFastScaleX(float x) {
        this.mScaleX = x;
        this.mMatrixDirty = true;
    }

    public void setFastScaleY(float y) {
        this.mScaleY = y;
        this.mMatrixDirty = true;
    }

    public void setFastAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public void setFastRotationY(float y) {
        this.mRotationY = y;
        this.mMatrixDirty = true;
    }

    public void getHitRect(Rect outRect) {
        this.updateMatrix();
        if (this.mMatrixIsIdentity || this.mAttachInfo == null) {
            outRect.set(this.mLeft, this.mTop, this.mRight, this.mBottom);
        } else {
            RectF tmpRect = this.mAttachInfo.mTmpTransformRect;
            tmpRect.set(-this.mPivotX, -this.mPivotY, (float)this.getWidth() - this.mPivotX, (float)this.getHeight() - this.mPivotY);
            this.mMatrix.mapRect(tmpRect);
            outRect.set((int)tmpRect.left + this.mLeft, (int)tmpRect.top + this.mTop, (int)tmpRect.right + this.mLeft, (int)tmpRect.bottom + this.mTop);
        }
    }

    public boolean pointInView(float localX, float localY) {
        return localX >= 0.0f && localX < (float)(this.mRight - this.mLeft) && localY >= 0.0f && localY < (float)(this.mBottom - this.mTop);
    }

    public boolean pointInView(float localX, float localY, float slop) {
        return localX >= -slop && localY >= -slop && localX < (float)(this.mRight - this.mLeft) + slop && localY < (float)(this.mBottom - this.mTop) + slop;
    }

    public void getFocusedRect(Rect r) {
        this.getDrawingRect(r);
    }

    public boolean getGlobalVisibleRect(Rect r, Point globalOffset) {
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width > 0 && height > 0) {
            r.set(0, 0, width, height);
            if (globalOffset != null) {
                globalOffset.set(-this.mScrollX, -this.mScrollY);
            }
            return this.mParent == null || this.mParent.getChildVisibleRect(this, r, globalOffset);
        }
        return false;
    }

    public boolean getGlobalVisibleRect(Rect r) {
        return this.getGlobalVisibleRect(r, null);
    }

    public boolean getLocalVisibleRect(Rect r) {
        Point offset = new Point();
        if (this.getGlobalVisibleRect(r, offset)) {
            r.offset(-offset.x, -offset.y);
            return true;
        }
        return false;
    }

    public void offsetTopAndBottom(int offset) {
        if (offset != 0) {
            this.updateMatrix();
            if (this.mMatrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    int yLoc;
                    int maxBottom;
                    int minTop;
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    if (offset < 0) {
                        minTop = this.mTop + offset;
                        maxBottom = this.mBottom;
                        yLoc = offset;
                    } else {
                        minTop = this.mTop;
                        maxBottom = this.mBottom + offset;
                        yLoc = 0;
                    }
                    r.set(0, yLoc, this.mRight - this.mLeft, maxBottom - minTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(false);
            }
            this.mTop += offset;
            this.mBottom += offset;
            if (!this.mMatrixIsIdentity) {
                this.mPrivateFlags |= 0x20;
                this.invalidate(false);
            }
            this.invalidateParentIfNeeded();
        }
    }

    public void offsetLeftAndRight(int offset) {
        if (offset != 0) {
            this.updateMatrix();
            if (this.mMatrixIsIdentity) {
                ViewParent p = this.mParent;
                if (p != null && this.mAttachInfo != null) {
                    int maxRight;
                    int minLeft;
                    Rect r = this.mAttachInfo.mTmpInvalRect;
                    if (offset < 0) {
                        minLeft = this.mLeft + offset;
                        maxRight = this.mRight;
                    } else {
                        minLeft = this.mLeft;
                        maxRight = this.mRight + offset;
                    }
                    r.set(0, 0, maxRight - minLeft, this.mBottom - this.mTop);
                    p.invalidateChild(this, r);
                }
            } else {
                this.invalidate(false);
            }
            this.mLeft += offset;
            this.mRight += offset;
            if (!this.mMatrixIsIdentity) {
                this.mPrivateFlags |= 0x20;
                this.invalidate(false);
            }
            this.invalidateParentIfNeeded();
        }
    }

    @ViewDebug.ExportedProperty(deepExport=true, prefix="layout_")
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params == null) {
            throw new NullPointerException("params == null");
        }
        this.mLayoutParams = params;
        this.requestLayout();
    }

    public void scrollTo(int x, int y) {
        if (this.mScrollX != x || this.mScrollY != y) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = x;
            this.mScrollY = y;
            this.invalidateParentCaches();
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (!this.awakenScrollBars()) {
                this.invalidate(true);
            }
        }
    }

    public void scrollBy(int x, int y) {
        this.scrollTo(this.mScrollX + x, this.mScrollY + y);
    }

    public boolean awakenScrollBars() {
        return this.mScrollCache != null && this.awakenScrollBars(this.mScrollCache.scrollBarDefaultDelayBeforeFade, true);
    }

    public boolean initialAwakenScrollBars() {
        return this.mScrollCache != null && this.awakenScrollBars(this.mScrollCache.scrollBarDefaultDelayBeforeFade * 4, true);
    }

    public boolean awakenScrollBars(int startDelay) {
        return this.awakenScrollBars(startDelay, true);
    }

    public boolean awakenScrollBars(int startDelay, boolean invalidate) {
        ScrollabilityCache scrollCache = this.mScrollCache;
        if (scrollCache == null || !scrollCache.fadeScrollBars) {
            return false;
        }
        if (scrollCache.scrollBar == null) {
            scrollCache.scrollBar = new ScrollBarDrawable();
        }
        if (this.isHorizontalScrollBarEnabled() || this.isVerticalScrollBarEnabled()) {
            long fadeStartTime;
            if (invalidate) {
                this.invalidate(true);
            }
            if (scrollCache.state == 0) {
                int KEY_REPEAT_FIRST_DELAY = 750;
                startDelay = Math.max(750, startDelay);
            }
            scrollCache.fadeStartTime = fadeStartTime = AnimationUtils.currentAnimationTimeMillis() + (long)startDelay;
            scrollCache.state = 1;
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mHandler.removeCallbacks(scrollCache);
                this.mAttachInfo.mHandler.postAtTime(scrollCache, fadeStartTime);
            }
            return true;
        }
        return false;
    }

    public void invalidate(Rect dirty) {
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            ViewParent p = this.mParent;
            AttachInfo ai = this.mAttachInfo;
            if (p != null && ai != null) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                Rect r = ai.mTmpInvalRect;
                r.set(dirty.left - scrollX, dirty.top - scrollY, dirty.right - scrollX, dirty.bottom - scrollY);
                this.mParent.invalidateChild(this, r);
            }
        }
    }

    public void invalidate(int l, int t, int r, int b) {
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            this.mPrivateFlags &= 0xFFFF7FFF;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            ViewParent p = this.mParent;
            AttachInfo ai = this.mAttachInfo;
            if (p != null && ai != null && l < r && t < b) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                Rect tmpr = ai.mTmpInvalRect;
                tmpr.set(l - scrollX, t - scrollY, r - scrollX, b - scrollY);
                p.invalidateChild(this, tmpr);
            }
        }
    }

    public void invalidate() {
        this.invalidate(true);
    }

    public void invalidate(boolean invalidateCache) {
        if ((this.mPrivateFlags & 0x30) == 48 || invalidateCache && (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE || this.isOpaque() != this.mLastIsOpaque) {
            this.mLastIsOpaque = this.isOpaque();
            this.mPrivateFlags &= 0xFFFFFFDF;
            if (invalidateCache) {
                this.mPrivateFlags |= Integer.MIN_VALUE;
                this.mPrivateFlags &= 0xFFFF7FFF;
            }
            AttachInfo ai = this.mAttachInfo;
            ViewParent p = this.mParent;
            if (p != null && ai != null) {
                Rect r = ai.mTmpInvalRect;
                r.set(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                p.invalidateChild(this, r);
            }
        }
    }

    public void fastInvalidate() {
        if ((this.mPrivateFlags & 0x30) == 48 || (this.mPrivateFlags & 0x8000) == 32768 || (this.mPrivateFlags & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            if (this.mParent instanceof View) {
                ((View)((Object)this.mParent)).mPrivateFlags |= Integer.MIN_VALUE;
            }
            this.mPrivateFlags &= 0xFFFFFFDF;
            this.mPrivateFlags |= Integer.MIN_VALUE;
            this.mPrivateFlags &= 0xFFFF7FFF;
            if (this.mParent != null && this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerated) {
                this.mParent.invalidateChild(this, null);
            }
        }
    }

    public void invalidateParentCaches() {
        if (this.mParent instanceof View) {
            ((View)((Object)this.mParent)).mPrivateFlags |= Integer.MIN_VALUE;
        }
    }

    public void invalidateParentIfNeeded() {
        if (this.isHardwareAccelerated() && this.mParent instanceof View) {
            ((View)((Object)this.mParent)).invalidate(true);
        }
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isOpaque() {
        return (this.mPrivateFlags & 0x1800000) == 0x1800000 && this.mAlpha >= 0.9791667f;
    }

    public void computeOpaqueFlags() {
        this.mPrivateFlags = this.mBGDrawable != null && this.mBGDrawable.getOpacity() == -1 ? (this.mPrivateFlags |= 0x800000) : (this.mPrivateFlags &= 0xFF7FFFFF);
        int flags = this.mViewFlags;
        this.mPrivateFlags = (flags & 0x200) == 0 && (flags & 0x100) == 0 || (flags & 0x3000000) == 0 ? (this.mPrivateFlags |= 0x1000000) : (this.mPrivateFlags &= 0xFEFFFFFF);
    }

    public boolean hasOpaqueScrollbars() {
        return (this.mPrivateFlags & 0x1000000) == 0x1000000;
    }

    public Handler getHandler() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mHandler;
        }
        return null;
    }

    public boolean post(Runnable action) {
        if (this.mAttachInfo == null) {
            ViewRoot.getRunQueue().post(action);
            return true;
        }
        Handler handler = this.mAttachInfo.mHandler;
        return handler.post(action);
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        if (this.mAttachInfo == null) {
            ViewRoot.getRunQueue().postDelayed(action, delayMillis);
            return true;
        }
        Handler handler = this.mAttachInfo.mHandler;
        return handler.postDelayed(action, delayMillis);
    }

    public boolean removeCallbacks(Runnable action) {
        if (this.mAttachInfo == null) {
            ViewRoot.getRunQueue().removeCallbacks(action);
            return true;
        }
        Handler handler = this.mAttachInfo.mHandler;
        handler.removeCallbacks(action);
        return true;
    }

    public void postInvalidate() {
        this.postInvalidateDelayed(0L);
    }

    public void postInvalidate(int left, int top, int right, int bottom) {
        this.postInvalidateDelayed(0L, left, top, right, bottom);
    }

    public void postInvalidateDelayed(long delayMilliseconds) {
        if (this.mAttachInfo != null) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = this;
            this.mAttachInfo.mHandler.sendMessageDelayed(msg, delayMilliseconds);
        }
    }

    public void postInvalidateDelayed(long delayMilliseconds, int left, int top, int right, int bottom) {
        if (this.mAttachInfo != null) {
            AttachInfo.InvalidateInfo info = AttachInfo.InvalidateInfo.acquire();
            info.target = this;
            info.left = left;
            info.top = top;
            info.right = right;
            info.bottom = bottom;
            Message msg = Message.obtain();
            msg.what = 2;
            msg.obj = info;
            this.mAttachInfo.mHandler.sendMessageDelayed(msg, delayMilliseconds);
        }
    }

    public void computeScroll() {
    }

    public boolean isHorizontalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x1000) == 4096;
    }

    public void setHorizontalFadingEdgeEnabled(boolean horizontalFadingEdgeEnabled) {
        if (this.isHorizontalFadingEdgeEnabled() != horizontalFadingEdgeEnabled) {
            if (horizontalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x1000;
        }
    }

    public boolean isVerticalFadingEdgeEnabled() {
        return (this.mViewFlags & 0x2000) == 8192;
    }

    public void setVerticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
        if (this.isVerticalFadingEdgeEnabled() != verticalFadingEdgeEnabled) {
            if (verticalFadingEdgeEnabled) {
                this.initScrollCache();
            }
            this.mViewFlags ^= 0x2000;
        }
    }

    public float getTopFadingEdgeStrength() {
        return this.computeVerticalScrollOffset() > 0 ? 1.0f : 0.0f;
    }

    public float getBottomFadingEdgeStrength() {
        return this.computeVerticalScrollOffset() + this.computeVerticalScrollExtent() < this.computeVerticalScrollRange() ? 1.0f : 0.0f;
    }

    public float getLeftFadingEdgeStrength() {
        return this.computeHorizontalScrollOffset() > 0 ? 1.0f : 0.0f;
    }

    public float getRightFadingEdgeStrength() {
        return this.computeHorizontalScrollOffset() + this.computeHorizontalScrollExtent() < this.computeHorizontalScrollRange() ? 1.0f : 0.0f;
    }

    public boolean isHorizontalScrollBarEnabled() {
        return (this.mViewFlags & 0x100) == 256;
    }

    public void setHorizontalScrollBarEnabled(boolean horizontalScrollBarEnabled) {
        if (this.isHorizontalScrollBarEnabled() != horizontalScrollBarEnabled) {
            this.mViewFlags ^= 0x100;
            this.computeOpaqueFlags();
            this.recomputePadding();
        }
    }

    public boolean isVerticalScrollBarEnabled() {
        return (this.mViewFlags & 0x200) == 512;
    }

    public void setVerticalScrollBarEnabled(boolean verticalScrollBarEnabled) {
        if (this.isVerticalScrollBarEnabled() != verticalScrollBarEnabled) {
            this.mViewFlags ^= 0x200;
            this.computeOpaqueFlags();
            this.recomputePadding();
        }
    }

    public void recomputePadding() {
        this.setPadding(this.mUserPaddingLeft, this.mPaddingTop, this.mUserPaddingRight, this.mUserPaddingBottom);
    }

    public void setScrollbarFadingEnabled(boolean fadeScrollbars) {
        this.initScrollCache();
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        scrollabilityCache.fadeScrollBars = fadeScrollbars;
        scrollabilityCache.state = fadeScrollbars ? 0 : 1;
    }

    public boolean isScrollbarFadingEnabled() {
        return this.mScrollCache != null && this.mScrollCache.fadeScrollBars;
    }

    public void setScrollBarStyle(int style2) {
        if (style2 != (this.mViewFlags & 0x3000000)) {
            this.mViewFlags = this.mViewFlags & 0xFCFFFFFF | style2 & 0x3000000;
            this.computeOpaqueFlags();
            this.recomputePadding();
        }
    }

    public int getScrollBarStyle() {
        return this.mViewFlags & 0x3000000;
    }

    public int computeHorizontalScrollRange() {
        return this.getWidth();
    }

    public int computeHorizontalScrollOffset() {
        return this.mScrollX;
    }

    public int computeHorizontalScrollExtent() {
        return this.getWidth();
    }

    public int computeVerticalScrollRange() {
        return this.getHeight();
    }

    public int computeVerticalScrollOffset() {
        return this.mScrollY;
    }

    public int computeVerticalScrollExtent() {
        return this.getHeight();
    }

    public void onDrawScrollBars(Canvas canvas) {
        ScrollabilityCache cache = this.mScrollCache;
        if (cache != null) {
            boolean drawVerticalScrollBar;
            int state = cache.state;
            if (state == 0) {
                return;
            }
            boolean invalidate = false;
            if (state == 2) {
                float[] values;
                if (cache.interpolatorValues == null) {
                    cache.interpolatorValues = new float[1];
                }
                if (cache.scrollBarInterpolator.timeToValues(values = cache.interpolatorValues) == Interpolator.Result.FREEZE_END) {
                    cache.state = 0;
                } else {
                    cache.scrollBar.setAlpha(Math.round(values[0]));
                }
                invalidate = true;
            } else {
                cache.scrollBar.setAlpha(255);
            }
            int viewFlags = this.mViewFlags;
            boolean drawHorizontalScrollBar = (viewFlags & 0x100) == 256;
            boolean bl = drawVerticalScrollBar = (viewFlags & 0x200) == 512 && !this.isVerticalScrollBarHidden();
            if (drawVerticalScrollBar || drawHorizontalScrollBar) {
                int bottom;
                int right;
                int left;
                int top;
                int size;
                int inside;
                int width = this.mRight - this.mLeft;
                int height = this.mBottom - this.mTop;
                ScrollBarDrawable scrollBar = cache.scrollBar;
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                int n = inside = (viewFlags & 0x2000000) == 0 ? -1 : 0;
                if (drawHorizontalScrollBar) {
                    size = scrollBar.getSize(false);
                    if (size <= 0) {
                        size = cache.scrollBarSize;
                    }
                    scrollBar.setParameters(this.computeHorizontalScrollRange(), this.computeHorizontalScrollOffset(), this.computeHorizontalScrollExtent(), false);
                    int verticalScrollBarGap = drawVerticalScrollBar ? this.getVerticalScrollbarWidth() : 0;
                    top = scrollY + height - size - (this.mUserPaddingBottom & inside);
                    left = scrollX + (this.mPaddingLeft & inside);
                    right = scrollX + width - (this.mUserPaddingRight & inside) - verticalScrollBarGap;
                    bottom = top + size;
                    this.onDrawHorizontalScrollBar(canvas, scrollBar, left, top, right, bottom);
                    if (invalidate) {
                        this.invalidate(left, top, right, bottom);
                    }
                }
                if (drawVerticalScrollBar) {
                    size = scrollBar.getSize(true);
                    if (size <= 0) {
                        size = cache.scrollBarSize;
                    }
                    scrollBar.setParameters(this.computeVerticalScrollRange(), this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent(), true);
                    switch (this.mVerticalScrollbarPosition) {
                        default: {
                            left = scrollX + width - size - (this.mUserPaddingRight & inside);
                            break;
                        }
                        case 1: {
                            left = scrollX + (this.mUserPaddingLeft & inside);
                        }
                    }
                    top = scrollY + (this.mPaddingTop & inside);
                    right = left + size;
                    bottom = scrollY + height - (this.mUserPaddingBottom & inside);
                    this.onDrawVerticalScrollBar(canvas, scrollBar, left, top, right, bottom);
                    if (invalidate) {
                        this.invalidate(left, top, right, bottom);
                    }
                }
            }
        }
    }

    public boolean isVerticalScrollBarHidden() {
        return false;
    }

    public void onDrawHorizontalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    public void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        scrollBar.setBounds(l, t, r, b);
        scrollBar.draw(canvas);
    }

    public void onDraw(Canvas canvas) {
    }

    public void assignParent(ViewParent parent) {
        if (this.mParent == null) {
            this.mParent = parent;
        } else if (parent == null) {
            this.mParent = null;
        } else {
            throw new RuntimeException("view " + this + " being added, but" + " it already has a parent");
        }
    }

    public void onAttachedToWindow() {
        if ((this.mPrivateFlags & 0x200) != 0) {
            this.mParent.requestTransparentRegion(this);
        }
        if ((this.mPrivateFlags & 0x8000000) != 0) {
            this.initialAwakenScrollBars();
            this.mPrivateFlags &= 0xF7FFFFFF;
        }
        this.jumpDrawablesToCurrentState();
    }

    public void onDetachedFromWindow() {
        this.mPrivateFlags &= 0xFBFFFFFF;
        this.removeUnsetPressCallback();
        this.removeLongPressCallback();
        this.removePerformClickCallback();
        this.destroyDrawingCache();
        if (this.mHardwareLayer != null) {
            this.mHardwareLayer.destroy();
            this.mHardwareLayer = null;
        }
        if (this.mDisplayList != null) {
            this.mDisplayList.invalidate();
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mHandler.removeMessages(1, this);
            this.mAttachInfo.mHandler.removeMessages(2, this);
        }
        this.mCurrentAnimation = null;
    }

    public int getWindowAttachCount() {
        return this.mWindowAttachCount;
    }

    public IBinder getWindowToken() {
        return this.mAttachInfo != null ? this.mAttachInfo.mWindowToken : null;
    }

    public IBinder getApplicationWindowToken() {
        AttachInfo ai = this.mAttachInfo;
        if (ai != null) {
            IBinder appWindowToken = ai.mPanelParentWindowToken;
            if (appWindowToken == null) {
                appWindowToken = ai.mWindowToken;
            }
            return appWindowToken;
        }
        return null;
    }

    public IWindowSession getWindowSession() {
        return this.mAttachInfo != null ? this.mAttachInfo.mSession : null;
    }

    public void dispatchAttachedToWindow(AttachInfo info, int visibility) {
        this.mAttachInfo = info;
        ++this.mWindowAttachCount;
        this.mPrivateFlags |= 0x400;
        if (this.mFloatingTreeObserver != null) {
            info.mTreeObserver.merge(this.mFloatingTreeObserver);
            this.mFloatingTreeObserver = null;
        }
        if ((this.mPrivateFlags & 0x80000) != 0) {
            this.mAttachInfo.mScrollContainers.add(this);
            this.mPrivateFlags |= 0x100000;
        }
        this.performCollectViewAttributes(visibility);
        this.onAttachedToWindow();
        int vis = info.mWindowVisibility;
        if (vis != 8) {
            this.onWindowVisibilityChanged(vis);
        }
        if ((this.mPrivateFlags & 0x400) != 0) {
            this.refreshDrawableState();
        }
    }

    public void dispatchDetachedFromWindow() {
        int vis;
        AttachInfo info = this.mAttachInfo;
        if (info != null && (vis = info.mWindowVisibility) != 8) {
            this.onWindowVisibilityChanged(8);
        }
        this.onDetachedFromWindow();
        if ((this.mPrivateFlags & 0x100000) != 0) {
            this.mAttachInfo.mScrollContainers.remove(this);
            this.mPrivateFlags &= 0xFFEFFFFF;
        }
        this.mAttachInfo = null;
    }

    public void saveHierarchyState(SparseArray<Parcelable> container) {
        this.dispatchSaveInstanceState(container);
    }

    public void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        if (this.mID != -1 && (this.mViewFlags & 0x10000) == 0) {
            this.mPrivateFlags &= 0xFFFDFFFF;
            Parcelable state = this.onSaveInstanceState();
            if ((this.mPrivateFlags & 0x20000) == 0) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (state != null) {
                container.put(this.mID, state);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        this.mPrivateFlags |= 0x20000;
        return BaseSavedState.EMPTY_STATE;
    }

    public void restoreHierarchyState(SparseArray<Parcelable> container) {
        this.dispatchRestoreInstanceState(container);
    }

    public void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable state;
        if (this.mID != -1 && (state = container.get(this.mID)) != null) {
            this.mPrivateFlags &= 0xFFFDFFFF;
            this.onRestoreInstanceState(state);
            if ((this.mPrivateFlags & 0x20000) == 0) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        this.mPrivateFlags |= 0x20000;
        if (state != BaseSavedState.EMPTY_STATE && state != null) {
            throw new IllegalArgumentException("Wrong state class, expecting View State but received " + state.getClass().toString() + " instead. This usually happens " + "when two views of different type have the same id in the same hierarchy. " + "This view's id is " + ViewDebug.resolveId(this.mContext, this.getId()) + ". Make sure " + "other views do not use the same id.");
        }
    }

    public long getDrawingTime() {
        return this.mAttachInfo != null ? this.mAttachInfo.mDrawingTime : 0L;
    }

    public void setDuplicateParentStateEnabled(boolean enabled) {
        this.setFlags(enabled ? 0x400000 : 0, 0x400000);
    }

    public boolean isDuplicateParentStateEnabled() {
        return (this.mViewFlags & 0x400000) == 0x400000;
    }

    public void setLayerType(int layerType, Paint paint) {
        boolean layerDisabled;
        if (layerType < 0 || layerType > 2) {
            throw new IllegalArgumentException("Layer type can only be one of: LAYER_TYPE_NONE, LAYER_TYPE_SOFTWARE or LAYER_TYPE_HARDWARE");
        }
        if (layerType == this.mLayerType) {
            if (layerType != 0 && paint != this.mLayerPaint) {
                this.mLayerPaint = paint == null ? new Paint() : paint;
                this.invalidateParentCaches();
                this.invalidate(true);
            }
            return;
        }
        switch (this.mLayerType) {
            case 1: {
                if (this.mDrawingCache != null) {
                    this.mDrawingCache.recycle();
                    this.mDrawingCache = null;
                }
                if (this.mUnscaledDrawingCache == null) break;
                this.mUnscaledDrawingCache.recycle();
                this.mUnscaledDrawingCache = null;
                break;
            }
            case 2: {
                if (this.mHardwareLayer == null) break;
                this.mHardwareLayer.destroy();
                this.mHardwareLayer = null;
                break;
            }
        }
        this.mLayerType = layerType;
        boolean bl = layerDisabled = this.mLayerType == 0;
        this.mLayerPaint = layerDisabled ? null : (paint == null ? new Paint() : paint);
        this.mLocalDirtyRect = layerDisabled ? null : new Rect();
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    public int getLayerType() {
        return this.mLayerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwareLayer getHardwareLayer() {
        if (this.mAttachInfo == null || this.mAttachInfo.mHardwareRenderer == null) {
            return null;
        }
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        if (width == 0 || height == 0) {
            return null;
        }
        if ((this.mPrivateFlags & 0x8000) == 0 || this.mHardwareLayer == null) {
            if (this.mHardwareLayer == null) {
                this.mHardwareLayer = this.mAttachInfo.mHardwareRenderer.createHardwareLayer(width, height, this.isOpaque());
                this.mLocalDirtyRect.setEmpty();
            } else if (this.mHardwareLayer.getWidth() != width || this.mHardwareLayer.getHeight() != height) {
                this.mHardwareLayer.resize(width, height);
                this.mLocalDirtyRect.setEmpty();
            }
            Canvas currentCanvas = this.mAttachInfo.mHardwareCanvas;
            HardwareCanvas canvas = this.mHardwareLayer.start(currentCanvas);
            this.mAttachInfo.mHardwareCanvas = canvas;
            try {
                canvas.setViewport(width, height);
                canvas.onPreDraw(this.mLocalDirtyRect);
                this.mLocalDirtyRect.setEmpty();
                int restoreCount = canvas.save();
                this.computeScroll();
                canvas.translate(-this.mScrollX, -this.mScrollY);
                this.mPrivateFlags |= 0x8020;
                if ((this.mPrivateFlags & 0x80) == 128) {
                    this.mPrivateFlags &= 0xFF9FFFFF;
                    this.dispatchDraw(canvas);
                } else {
                    this.draw(canvas);
                }
                canvas.restoreToCount(restoreCount);
                Object var7_6 = null;
                canvas.onPostDraw();
                this.mHardwareLayer.end(currentCanvas);
                this.mAttachInfo.mHardwareCanvas = currentCanvas;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                canvas.onPostDraw();
                this.mHardwareLayer.end(currentCanvas);
                this.mAttachInfo.mHardwareCanvas = currentCanvas;
                throw throwable;
            }
        }
        return this.mHardwareLayer;
    }

    public void setDrawingCacheEnabled(boolean enabled) {
        this.setFlags(enabled ? 32768 : 0, 32768);
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public boolean isDrawingCacheEnabled() {
        return (this.mViewFlags & 0x8000) == 32768;
    }

    public void outputDirtyFlags(String indent, boolean clear, int clearMask) {
        Log.d(VIEW_LOG_TAG, indent + this + "             DIRTY(" + (this.mPrivateFlags & 0x600000) + ") DRAWN(" + (this.mPrivateFlags & 0x20) + ")" + " CACHE_VALID(" + (this.mPrivateFlags & 0x8000) + ") INVALIDATED(" + (this.mPrivateFlags & Integer.MIN_VALUE) + ")");
        if (clear) {
            this.mPrivateFlags &= clearMask;
        }
        if (this instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)this;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = parent.getChildAt(i);
                child.outputDirtyFlags(indent + "  ", clear, clearMask);
            }
        }
    }

    public void dispatchGetDisplayList() {
    }

    public boolean canHaveDisplayList() {
        return this.mAttachInfo != null && this.mAttachInfo.mHardwareRenderer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayList getDisplayList() {
        if (!this.canHaveDisplayList()) {
            return null;
        }
        if ((this.mPrivateFlags & 0x8000) == 0 || this.mDisplayList == null || !this.mDisplayList.isValid() || this.mRecreateDisplayList) {
            if (this.mDisplayList != null && this.mDisplayList.isValid() && !this.mRecreateDisplayList) {
                this.mPrivateFlags |= 0x8020;
                this.mPrivateFlags &= 0xFF9FFFFF;
                this.dispatchGetDisplayList();
                return this.mDisplayList;
            }
            this.mRecreateDisplayList = true;
            if (this.mDisplayList == null) {
                this.mDisplayList = this.mAttachInfo.mHardwareRenderer.createDisplayList(this);
                this.invalidateParentCaches();
            }
            HardwareCanvas canvas = this.mDisplayList.start();
            try {
                int width = this.mRight - this.mLeft;
                int height = this.mBottom - this.mTop;
                canvas.setViewport(width, height);
                canvas.onPreDraw(null);
                int restoreCount = canvas.save();
                this.computeScroll();
                canvas.translate(-this.mScrollX, -this.mScrollY);
                this.mPrivateFlags |= 0x8020;
                if ((this.mPrivateFlags & 0x80) == 128) {
                    this.mPrivateFlags &= 0xFF9FFFFF;
                    this.dispatchDraw(canvas);
                } else {
                    this.draw(canvas);
                }
                canvas.restoreToCount(restoreCount);
                Object var6_5 = null;
                canvas.onPostDraw();
                this.mDisplayList.end();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                canvas.onPostDraw();
                this.mDisplayList.end();
                throw throwable;
            }
        } else {
            this.mPrivateFlags |= 0x8020;
            this.mPrivateFlags &= 0xFF9FFFFF;
        }
        return this.mDisplayList;
    }

    public Bitmap getDrawingCache() {
        return this.getDrawingCache(false);
    }

    public Bitmap getDrawingCache(boolean autoScale) {
        if ((this.mViewFlags & 0x20000) == 131072) {
            return null;
        }
        if ((this.mViewFlags & 0x8000) == 32768) {
            this.buildDrawingCache(autoScale);
        }
        return autoScale ? this.mDrawingCache : this.mUnscaledDrawingCache;
    }

    public void destroyDrawingCache() {
        if (this.mDrawingCache != null) {
            this.mDrawingCache.recycle();
            this.mDrawingCache = null;
        }
        if (this.mUnscaledDrawingCache != null) {
            this.mUnscaledDrawingCache.recycle();
            this.mUnscaledDrawingCache = null;
        }
    }

    public void setDrawingCacheBackgroundColor(int color2) {
        if (color2 != this.mDrawingCacheBackgroundColor) {
            this.mDrawingCacheBackgroundColor = color2;
            this.mPrivateFlags &= 0xFFFF7FFF;
        }
    }

    public int getDrawingCacheBackgroundColor() {
        return this.mDrawingCacheBackgroundColor;
    }

    public void buildDrawingCache() {
        this.buildDrawingCache(false);
    }

    public void buildDrawingCache(boolean autoScale) {
        if ((this.mPrivateFlags & 0x8000) == 0 || (autoScale ? this.mDrawingCache == null : this.mUnscaledDrawingCache == null)) {
            Canvas canvas;
            Bitmap bitmap;
            boolean use32BitCache;
            int drawingCacheBackgroundColor;
            boolean scalingRequired;
            int width = this.mRight - this.mLeft;
            int height = this.mBottom - this.mTop;
            AttachInfo attachInfo = this.mAttachInfo;
            boolean bl = scalingRequired = attachInfo != null && attachInfo.mScalingRequired;
            if (autoScale && scalingRequired) {
                width = (int)((float)width * attachInfo.mApplicationScale + 0.5f);
                height = (int)((float)height * attachInfo.mApplicationScale + 0.5f);
            }
            boolean opaque = (drawingCacheBackgroundColor = this.mDrawingCacheBackgroundColor) != 0 || this.isOpaque();
            boolean bl2 = use32BitCache = attachInfo != null && attachInfo.mUse32BitDrawingCache;
            if (width <= 0 || height <= 0 || width * height * (opaque && !use32BitCache ? 2 : 4) > ViewConfiguration.get(this.mContext).getScaledMaximumDrawingCacheSize()) {
                this.destroyDrawingCache();
                return;
            }
            boolean clear = true;
            Bitmap bitmap2 = bitmap = autoScale ? this.mDrawingCache : this.mUnscaledDrawingCache;
            if (bitmap == null || bitmap.getWidth() != width || bitmap.getHeight() != height) {
                Bitmap.Config quality;
                if (!opaque) {
                    switch (this.mViewFlags & 0x180000) {
                        case 0: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        case 524288: {
                            quality = Bitmap.Config.ARGB_4444;
                            break;
                        }
                        case 0x100000: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                        default: {
                            quality = Bitmap.Config.ARGB_8888;
                            break;
                        }
                    }
                } else {
                    Bitmap.Config config = quality = use32BitCache ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                }
                if (bitmap != null) {
                    bitmap.recycle();
                }
                try {
                    bitmap = Bitmap.createBitmap(width, height, quality);
                    bitmap.setDensity(this.getResources().getDisplayMetrics().densityDpi);
                    if (autoScale) {
                        this.mDrawingCache = bitmap;
                    } else {
                        this.mUnscaledDrawingCache = bitmap;
                    }
                    if (opaque && use32BitCache) {
                        bitmap.setHasAlpha(false);
                    }
                }
                catch (OutOfMemoryError e) {
                    if (autoScale) {
                        this.mDrawingCache = null;
                    } else {
                        this.mUnscaledDrawingCache = null;
                    }
                    return;
                }
                boolean bl3 = clear = drawingCacheBackgroundColor != 0;
            }
            if (attachInfo != null) {
                canvas = attachInfo.mCanvas;
                if (canvas == null) {
                    canvas = new Canvas();
                }
                canvas.setBitmap(bitmap);
                attachInfo.mCanvas = null;
            } else {
                canvas = new Canvas(bitmap);
            }
            if (clear) {
                bitmap.eraseColor(drawingCacheBackgroundColor);
            }
            this.computeScroll();
            int restoreCount = canvas.save();
            if (autoScale && scalingRequired) {
                float scale = attachInfo.mApplicationScale;
                canvas.scale(scale, scale);
            }
            canvas.translate(-this.mScrollX, -this.mScrollY);
            this.mPrivateFlags |= 0x20;
            if (this.mAttachInfo == null || !this.mAttachInfo.mHardwareAccelerated || this.mLayerType != 0) {
                this.mPrivateFlags |= 0x8000;
            }
            if ((this.mPrivateFlags & 0x80) == 128) {
                this.mPrivateFlags &= 0xFF9FFFFF;
                this.dispatchDraw(canvas);
            } else {
                this.draw(canvas);
            }
            canvas.restoreToCount(restoreCount);
            if (attachInfo != null) {
                attachInfo.mCanvas = canvas;
            }
        }
    }

    public Bitmap createSnapshot(Bitmap.Config quality, int backgroundColor, boolean skipChildren) {
        Canvas canvas;
        int width = this.mRight - this.mLeft;
        int height = this.mBottom - this.mTop;
        AttachInfo attachInfo = this.mAttachInfo;
        float scale = attachInfo != null ? attachInfo.mApplicationScale : 1.0f;
        Bitmap bitmap = Bitmap.createBitmap((width = (int)((float)width * scale + 0.5f)) > 0 ? width : 1, (height = (int)((float)height * scale + 0.5f)) > 0 ? height : 1, quality);
        if (bitmap == null) {
            throw new OutOfMemoryError();
        }
        bitmap.setDensity(this.getResources().getDisplayMetrics().densityDpi);
        if (attachInfo != null) {
            canvas = attachInfo.mCanvas;
            if (canvas == null) {
                canvas = new Canvas();
            }
            canvas.setBitmap(bitmap);
            attachInfo.mCanvas = null;
        } else {
            canvas = new Canvas(bitmap);
        }
        if ((backgroundColor & 0xFF000000) != 0) {
            bitmap.eraseColor(backgroundColor);
        }
        this.computeScroll();
        int restoreCount = canvas.save();
        canvas.scale(scale, scale);
        canvas.translate(-this.mScrollX, -this.mScrollY);
        int flags = this.mPrivateFlags;
        this.mPrivateFlags &= 0xFF9FFFFF;
        if ((this.mPrivateFlags & 0x80) == 128) {
            this.dispatchDraw(canvas);
        } else {
            this.draw(canvas);
        }
        this.mPrivateFlags = flags;
        canvas.restoreToCount(restoreCount);
        if (attachInfo != null) {
            attachInfo.mCanvas = canvas;
        }
        return bitmap;
    }

    @LayoutlibDelegate
    public boolean isInEditMode() {
        return View_Delegate.isInEditMode(this);
    }

    public boolean isPaddingOffsetRequired() {
        return false;
    }

    public int getLeftPaddingOffset() {
        return 0;
    }

    public int getRightPaddingOffset() {
        return 0;
    }

    public int getTopPaddingOffset() {
        return 0;
    }

    public int getBottomPaddingOffset() {
        return 0;
    }

    public boolean isHardwareAccelerated() {
        return this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerated;
    }

    public void draw(Canvas canvas) {
        boolean verticalEdges;
        int viewFlags;
        Drawable background;
        int privateFlags = this.mPrivateFlags;
        boolean dirtyOpaque = (privateFlags & 0x600000) == 0x400000 && (this.mAttachInfo == null || !this.mAttachInfo.mIgnoreDirtyState);
        this.mPrivateFlags = privateFlags & 0xFF9FFFFF | 0x20;
        if (!dirtyOpaque && (background = this.mBGDrawable) != null) {
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            if (this.mBackgroundSizeChanged) {
                background.setBounds(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
                this.mBackgroundSizeChanged = false;
            }
            if ((scrollX | scrollY) == 0) {
                background.draw(canvas);
            } else {
                canvas.translate(scrollX, scrollY);
                background.draw(canvas);
                canvas.translate(-scrollX, -scrollY);
            }
        }
        boolean horizontalEdges = ((viewFlags = this.mViewFlags) & 0x1000) != 0;
        boolean bl = verticalEdges = (viewFlags & 0x2000) != 0;
        if (!verticalEdges && !horizontalEdges) {
            if (!dirtyOpaque) {
                this.onDraw(canvas);
            }
            this.dispatchDraw(canvas);
            this.onDrawScrollBars(canvas);
            return;
        }
        boolean drawTop = false;
        boolean drawBottom = false;
        boolean drawLeft = false;
        boolean drawRight = false;
        float topFadeStrength = 0.0f;
        float bottomFadeStrength = 0.0f;
        float leftFadeStrength = 0.0f;
        float rightFadeStrength = 0.0f;
        int paddingLeft = this.mPaddingLeft;
        int paddingTop = this.mPaddingTop;
        boolean offsetRequired = this.isPaddingOffsetRequired();
        if (offsetRequired) {
            paddingLeft += this.getLeftPaddingOffset();
            paddingTop += this.getTopPaddingOffset();
        }
        int left = this.mScrollX + paddingLeft;
        int right = left + this.mRight - this.mLeft - this.mPaddingRight - paddingLeft;
        int top = this.mScrollY + paddingTop;
        int bottom = top + this.mBottom - this.mTop - this.mPaddingBottom - paddingTop;
        if (offsetRequired) {
            right += this.getRightPaddingOffset();
            bottom += this.getBottomPaddingOffset();
        }
        ScrollabilityCache scrollabilityCache = this.mScrollCache;
        int length = scrollabilityCache.fadingEdgeLength;
        if (verticalEdges && top + length > bottom - length) {
            length = (bottom - top) / 2;
        }
        if (horizontalEdges && left + length > right - length) {
            length = (right - left) / 2;
        }
        if (verticalEdges) {
            topFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getTopFadingEdgeStrength()));
            drawTop = topFadeStrength > 0.0f;
            bottomFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getBottomFadingEdgeStrength()));
            boolean bl2 = drawBottom = bottomFadeStrength > 0.0f;
        }
        if (horizontalEdges) {
            leftFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getLeftFadingEdgeStrength()));
            drawLeft = leftFadeStrength > 0.0f;
            rightFadeStrength = Math.max(0.0f, Math.min(1.0f, this.getRightFadingEdgeStrength()));
            drawRight = rightFadeStrength > 0.0f;
        }
        int saveCount = canvas.getSaveCount();
        int solidColor = this.getSolidColor();
        if (solidColor == 0) {
            int flags = 4;
            if (drawTop) {
                canvas.saveLayer(left, top, right, top + length, null, 4);
            }
            if (drawBottom) {
                canvas.saveLayer(left, bottom - length, right, bottom, null, 4);
            }
            if (drawLeft) {
                canvas.saveLayer(left, top, left + length, bottom, null, 4);
            }
            if (drawRight) {
                canvas.saveLayer(right - length, top, right, bottom, null, 4);
            }
        } else {
            scrollabilityCache.setFadeColor(solidColor);
        }
        if (!dirtyOpaque) {
            this.onDraw(canvas);
        }
        this.dispatchDraw(canvas);
        Paint p = scrollabilityCache.paint;
        Matrix matrix = scrollabilityCache.matrix;
        Shader fade = scrollabilityCache.shader;
        float fadeHeight = scrollabilityCache.fadingEdgeLength;
        if (drawTop) {
            matrix.setScale(1.0f, fadeHeight * topFadeStrength);
            matrix.postTranslate(left, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, top, right, top + length, p);
        }
        if (drawBottom) {
            matrix.setScale(1.0f, fadeHeight * bottomFadeStrength);
            matrix.postRotate(180.0f);
            matrix.postTranslate(left, bottom);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, bottom - length, right, bottom, p);
        }
        if (drawLeft) {
            matrix.setScale(1.0f, fadeHeight * leftFadeStrength);
            matrix.postRotate(-90.0f);
            matrix.postTranslate(left, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(left, top, left + length, bottom, p);
        }
        if (drawRight) {
            matrix.setScale(1.0f, fadeHeight * rightFadeStrength);
            matrix.postRotate(90.0f);
            matrix.postTranslate(right, top);
            fade.setLocalMatrix(matrix);
            canvas.drawRect(right - length, top, right, bottom, p);
        }
        canvas.restoreToCount(saveCount);
        this.onDrawScrollBars(canvas);
    }

    public int getSolidColor() {
        return 0;
    }

    public static String printFlags(int flags) {
        String output = "";
        int numFlags = 0;
        if ((flags & 1) == 1) {
            output = output + "TAKES_FOCUS";
            ++numFlags;
        }
        switch (flags & 0xC) {
            case 4: {
                if (numFlags > 0) {
                    output = output + " ";
                }
                output = output + "INVISIBLE";
                break;
            }
            case 8: {
                if (numFlags > 0) {
                    output = output + " ";
                }
                output = output + "GONE";
                break;
            }
        }
        return output;
    }

    public static String printPrivateFlags(int privateFlags) {
        String output = "";
        int numFlags = 0;
        if ((privateFlags & 1) == 1) {
            output = output + "WANTS_FOCUS";
            ++numFlags;
        }
        if ((privateFlags & 2) == 2) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "FOCUSED";
            ++numFlags;
        }
        if ((privateFlags & 4) == 4) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "SELECTED";
            ++numFlags;
        }
        if ((privateFlags & 8) == 8) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "IS_ROOT_NAMESPACE";
            ++numFlags;
        }
        if ((privateFlags & 0x10) == 16) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "HAS_BOUNDS";
            ++numFlags;
        }
        if ((privateFlags & 0x20) == 32) {
            if (numFlags > 0) {
                output = output + " ";
            }
            output = output + "DRAWN";
        }
        return output;
    }

    public boolean isLayoutRequested() {
        return (this.mPrivateFlags & 0x1000) == 4096;
    }

    public void layout(int l, int t, int r, int b) {
        int oldL = this.mLeft;
        int oldT = this.mTop;
        int oldB = this.mBottom;
        int oldR = this.mRight;
        boolean changed = this.setFrame(l, t, r, b);
        if (changed || (this.mPrivateFlags & 0x2000) == 8192) {
            this.onLayout(changed, l, t, r, b);
            this.mPrivateFlags &= 0xFFFFDFFF;
            if (this.mOnLayoutChangeListeners != null) {
                ArrayList listenersCopy = (ArrayList)this.mOnLayoutChangeListeners.clone();
                int numListeners = listenersCopy.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((OnLayoutChangeListener)listenersCopy.get(i)).onLayoutChange(this, l, t, r, b, oldL, oldT, oldR, oldB);
                }
            }
        }
        this.mPrivateFlags &= 0xFFFFEFFF;
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = false;
        if (this.mLeft != left || this.mRight != right || this.mTop != top || this.mBottom != bottom) {
            changed = true;
            int drawn = this.mPrivateFlags & 0x20;
            this.invalidate(true);
            int oldWidth = this.mRight - this.mLeft;
            int oldHeight = this.mBottom - this.mTop;
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            this.mPrivateFlags |= 0x10;
            int newWidth = right - left;
            int newHeight = bottom - top;
            if (newWidth != oldWidth || newHeight != oldHeight) {
                if ((this.mPrivateFlags & 0x20000000) == 0) {
                    this.mMatrixDirty = true;
                }
                this.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
            }
            if ((this.mViewFlags & 0xC) == 0) {
                this.mPrivateFlags |= 0x20;
                this.invalidate(true);
                this.invalidateParentCaches();
            }
            this.mPrivateFlags |= drawn;
            this.mBackgroundSizeChanged = true;
        }
        return changed;
    }

    public void onFinishInflate() {
    }

    public Resources getResources() {
        return this.mResources;
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        }
    }

    @Override
    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        if (this.verifyDrawable(who) && what != null && this.mAttachInfo != null) {
            this.mAttachInfo.mHandler.postAtTime(what, who, when);
        }
    }

    @Override
    public void unscheduleDrawable(Drawable who, Runnable what) {
        if (this.verifyDrawable(who) && what != null && this.mAttachInfo != null) {
            this.mAttachInfo.mHandler.removeCallbacks(what, who);
        }
    }

    public void unscheduleDrawable(Drawable who) {
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mHandler.removeCallbacksAndMessages(who);
        }
    }

    public boolean verifyDrawable(Drawable who) {
        return who == this.mBGDrawable;
    }

    public void drawableStateChanged() {
        Drawable d = this.mBGDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    public void refreshDrawableState() {
        this.mPrivateFlags |= 0x400;
        this.drawableStateChanged();
        ViewParent parent = this.mParent;
        if (parent != null) {
            parent.childDrawableStateChanged(this);
        }
    }

    public int[] getDrawableState() {
        if (this.mDrawableState != null && (this.mPrivateFlags & 0x400) == 0) {
            return this.mDrawableState;
        }
        this.mDrawableState = this.onCreateDrawableState(0);
        this.mPrivateFlags &= 0xFFFFFBFF;
        return this.mDrawableState;
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] fullState;
        if ((this.mViewFlags & 0x400000) == 0x400000 && this.mParent instanceof View) {
            return ((View)((Object)this.mParent)).onCreateDrawableState(extraSpace);
        }
        int privateFlags = this.mPrivateFlags;
        int viewStateIndex = 0;
        if ((privateFlags & 0x4000) != 0) {
            viewStateIndex |= 0x10;
        }
        if ((this.mViewFlags & 0x20) == 0) {
            viewStateIndex |= 8;
        }
        if (this.isFocused()) {
            viewStateIndex |= 4;
        }
        if ((privateFlags & 4) != 0) {
            viewStateIndex |= 2;
        }
        if (this.hasWindowFocus()) {
            viewStateIndex |= 1;
        }
        if ((privateFlags & 0x40000000) != 0) {
            viewStateIndex |= 0x20;
        }
        if (this.mAttachInfo != null && this.mAttachInfo.mHardwareAccelerationRequested) {
            viewStateIndex |= 0x40;
        }
        int[] drawableState = VIEW_STATE_SETS[viewStateIndex];
        if (extraSpace == 0) {
            return drawableState;
        }
        if (drawableState != null) {
            fullState = new int[drawableState.length + extraSpace];
            System.arraycopy(drawableState, 0, fullState, 0, drawableState.length);
        } else {
            fullState = new int[extraSpace];
        }
        return fullState;
    }

    public static int[] mergeDrawableStates(int[] baseState, int[] additionalState) {
        int i;
        int N = baseState.length;
        for (i = N - 1; i >= 0 && baseState[i] == 0; --i) {
        }
        System.arraycopy(additionalState, 0, baseState, i + 1, additionalState.length);
        return baseState;
    }

    public void jumpDrawablesToCurrentState() {
        if (this.mBGDrawable != null) {
            this.mBGDrawable.jumpToCurrentState();
        }
    }

    @RemotableViewMethod
    public void setBackgroundColor(int color2) {
        if (this.mBGDrawable instanceof ColorDrawable) {
            ((ColorDrawable)this.mBGDrawable).setColor(color2);
        } else {
            this.setBackgroundDrawable(new ColorDrawable(color2));
        }
    }

    @RemotableViewMethod
    public void setBackgroundResource(int resid) {
        if (resid != 0 && resid == this.mBackgroundResource) {
            return;
        }
        Drawable d = null;
        if (resid != 0) {
            d = this.mResources.getDrawable(resid);
        }
        this.setBackgroundDrawable(d);
        this.mBackgroundResource = resid;
    }

    public void setBackgroundDrawable(Drawable d) {
        boolean requestLayout = false;
        this.mBackgroundResource = 0;
        if (this.mBGDrawable != null) {
            this.mBGDrawable.setCallback(null);
            this.unscheduleDrawable(this.mBGDrawable);
        }
        if (d != null) {
            Rect padding = sThreadLocal.get();
            if (padding == null) {
                padding = new Rect();
                sThreadLocal.set(padding);
            }
            if (d.getPadding(padding)) {
                this.setPadding(padding.left, padding.top, padding.right, padding.bottom);
            }
            if (this.mBGDrawable == null || this.mBGDrawable.getMinimumHeight() != d.getMinimumHeight() || this.mBGDrawable.getMinimumWidth() != d.getMinimumWidth()) {
                requestLayout = true;
            }
            d.setCallback(this);
            if (d.isStateful()) {
                d.setState(this.getDrawableState());
            }
            d.setVisible(this.getVisibility() == 0, false);
            this.mBGDrawable = d;
            if ((this.mPrivateFlags & 0x80) != 0) {
                this.mPrivateFlags &= 0xFFFFFF7F;
                this.mPrivateFlags |= 0x100;
                requestLayout = true;
            }
        } else {
            this.mBGDrawable = null;
            if ((this.mPrivateFlags & 0x100) != 0) {
                this.mPrivateFlags &= 0xFFFFFEFF;
                this.mPrivateFlags |= 0x80;
            }
            requestLayout = true;
        }
        this.computeOpaqueFlags();
        if (requestLayout) {
            this.requestLayout();
        }
        this.mBackgroundSizeChanged = true;
        this.invalidate(true);
    }

    public Drawable getBackground() {
        return this.mBGDrawable;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        boolean changed = false;
        this.mUserPaddingLeft = left;
        this.mUserPaddingRight = right;
        this.mUserPaddingBottom = bottom;
        int viewFlags = this.mViewFlags;
        if ((viewFlags & 0x300) != 0) {
            if ((viewFlags & 0x200) != 0) {
                int offset = (viewFlags & 0x1000000) == 0 ? 0 : this.getVerticalScrollbarWidth();
                switch (this.mVerticalScrollbarPosition) {
                    case 0: 
                    case 2: {
                        right += offset;
                        break;
                    }
                    case 1: {
                        left += offset;
                    }
                }
            }
            if ((viewFlags & 0x100) != 0) {
                bottom += (viewFlags & 0x1000000) == 0 ? 0 : this.getHorizontalScrollbarHeight();
            }
        }
        if (this.mPaddingLeft != left) {
            changed = true;
            this.mPaddingLeft = left;
        }
        if (this.mPaddingTop != top) {
            changed = true;
            this.mPaddingTop = top;
        }
        if (this.mPaddingRight != right) {
            changed = true;
            this.mPaddingRight = right;
        }
        if (this.mPaddingBottom != bottom) {
            changed = true;
            this.mPaddingBottom = bottom;
        }
        if (changed) {
            this.requestLayout();
        }
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public void setSelected(boolean selected) {
        if ((this.mPrivateFlags & 4) != 0 != selected) {
            this.mPrivateFlags = this.mPrivateFlags & 0xFFFFFFFB | (selected ? 4 : 0);
            if (!selected) {
                this.resetPressedState();
            }
            this.invalidate(true);
            this.refreshDrawableState();
            this.dispatchSetSelected(selected);
        }
    }

    public void dispatchSetSelected(boolean selected) {
    }

    @ViewDebug.ExportedProperty
    public boolean isSelected() {
        return (this.mPrivateFlags & 4) != 0;
    }

    public void setActivated(boolean activated) {
        if ((this.mPrivateFlags & 0x40000000) != 0 != activated) {
            this.mPrivateFlags = this.mPrivateFlags & 0xBFFFFFFF | (activated ? 0x40000000 : 0);
            this.invalidate(true);
            this.refreshDrawableState();
            this.dispatchSetActivated(activated);
        }
    }

    public void dispatchSetActivated(boolean activated) {
    }

    @ViewDebug.ExportedProperty
    public boolean isActivated() {
        return (this.mPrivateFlags & 0x40000000) != 0;
    }

    public ViewTreeObserver getViewTreeObserver() {
        if (this.mAttachInfo != null) {
            return this.mAttachInfo.mTreeObserver;
        }
        if (this.mFloatingTreeObserver == null) {
            this.mFloatingTreeObserver = new ViewTreeObserver();
        }
        return this.mFloatingTreeObserver;
    }

    public View getRootView() {
        View v;
        if (this.mAttachInfo != null && (v = this.mAttachInfo.mRootView) != null) {
            return v;
        }
        View parent = this;
        while (parent.mParent != null && parent.mParent instanceof View) {
            parent = (View)((Object)parent.mParent);
        }
        return parent;
    }

    public void getLocationOnScreen(int[] location) {
        this.getLocationInWindow(location);
        AttachInfo info = this.mAttachInfo;
        if (info != null) {
            location[0] = location[0] + info.mWindowLeft;
            location[1] = location[1] + info.mWindowTop;
        }
    }

    public void getLocationInWindow(int[] location) {
        if (location == null || location.length < 2) {
            throw new IllegalArgumentException("location must be an array of two integers");
        }
        location[0] = this.mLeft + (int)(this.mTranslationX + 0.5f);
        location[1] = this.mTop + (int)(this.mTranslationY + 0.5f);
        ViewParent viewParent = this.mParent;
        while (viewParent instanceof View) {
            View view = (View)((Object)viewParent);
            location[0] = location[0] + (view.mLeft + (int)(view.mTranslationX + 0.5f) - view.mScrollX);
            location[1] = location[1] + (view.mTop + (int)(view.mTranslationY + 0.5f) - view.mScrollY);
            viewParent = view.mParent;
        }
        if (viewParent instanceof ViewRoot) {
            ViewRoot vr = (ViewRoot)viewParent;
            location[1] = location[1] - vr.mCurScrollY;
        }
    }

    public View findViewTraversal(int id2) {
        if (id2 == this.mID) {
            return this;
        }
        return null;
    }

    public View findViewWithTagTraversal(Object tag) {
        if (tag != null && tag.equals(this.mTag)) {
            return this;
        }
        return null;
    }

    public View findViewByPredicateTraversal(Predicate<View> predicate) {
        if (predicate.apply(this)) {
            return this;
        }
        return null;
    }

    public View findViewById(int id2) {
        if (id2 < 0) {
            return null;
        }
        return this.findViewTraversal(id2);
    }

    public View findViewWithTag(Object tag) {
        if (tag == null) {
            return null;
        }
        return this.findViewWithTagTraversal(tag);
    }

    public View findViewByPredicate(Predicate<View> predicate) {
        return this.findViewByPredicateTraversal(predicate);
    }

    public void setId(int id2) {
        this.mID = id2;
    }

    public void setIsRootNamespace(boolean isRoot) {
        this.mPrivateFlags = isRoot ? (this.mPrivateFlags |= 8) : (this.mPrivateFlags &= 0xFFFFFFF7);
    }

    public boolean isRootNamespace() {
        return (this.mPrivateFlags & 8) != 0;
    }

    @ViewDebug.CapturedViewProperty
    public int getId() {
        return this.mID;
    }

    @ViewDebug.ExportedProperty
    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTag(int key) {
        SparseArray<Object> tags = null;
        Object object = sTagsLock;
        synchronized (object) {
            if (sTags != null) {
                tags = sTags.get(this);
            }
        }
        if (tags != null) {
            return tags.get(key);
        }
        return null;
    }

    public void setTag(int key, Object tag) {
        if (key >>> 24 < 2) {
            throw new IllegalArgumentException("The key must be an application-specific resource id.");
        }
        View.setTagInternal(this, key, tag);
    }

    public void setTagInternal(int key, Object tag) {
        if (key >>> 24 != 1) {
            throw new IllegalArgumentException("The key must be a framework-specific resource id.");
        }
        View.setTagInternal(this, key, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTagInternal(View view, int key, Object tag) {
        SparseArray<Object> tags = null;
        Object object = sTagsLock;
        synchronized (object) {
            if (sTags == null) {
                sTags = new WeakHashMap();
            } else {
                tags = sTags.get(view);
            }
        }
        if (tags == null) {
            tags = new SparseArray(2);
            object = sTagsLock;
            synchronized (object) {
                sTags.put(view, tags);
            }
        }
        tags.put(key, tag);
    }

    public boolean dispatchConsistencyCheck(int consistency) {
        return this.onConsistencyCheck(consistency);
    }

    public boolean onConsistencyCheck(int consistency) {
        boolean checkDrawing;
        boolean result = true;
        boolean checkLayout = (consistency & 1) != 0;
        boolean bl = checkDrawing = (consistency & 2) != 0;
        if (checkLayout) {
            if (this.getParent() == null) {
                result = false;
                Log.d("ViewConsistency", "View " + this + " does not have a parent.");
            }
            if (this.mAttachInfo == null) {
                result = false;
                Log.d("ViewConsistency", "View " + this + " is not attached to a window.");
            }
        }
        if (checkDrawing && (this.mPrivateFlags & 0x20) != 32 && (this.mPrivateFlags & 0x8000) == 32768) {
            result = false;
            Log.d("ViewConsistency", "View " + this + " was invalidated but its drawing cache is valid.");
        }
        return result;
    }

    public void debug() {
        this.debug(0);
    }

    public void debug(int depth) {
        Object tag;
        String output = View.debugIndent(depth - 1);
        output = output + "+ " + this;
        int id2 = this.getId();
        if (id2 != -1) {
            output = output + " (id=" + id2 + ")";
        }
        if ((tag = this.getTag()) != null) {
            output = output + " (tag=" + tag + ")";
        }
        Log.d(VIEW_LOG_TAG, output);
        if ((this.mPrivateFlags & 2) != 0) {
            output = View.debugIndent(depth) + " FOCUSED";
            Log.d(VIEW_LOG_TAG, output);
        }
        output = View.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        Log.d(VIEW_LOG_TAG, output);
        if (this.mPaddingLeft != 0 || this.mPaddingTop != 0 || this.mPaddingRight != 0 || this.mPaddingBottom != 0) {
            output = View.debugIndent(depth);
            output = output + "padding={" + this.mPaddingLeft + ", " + this.mPaddingTop + ", " + this.mPaddingRight + ", " + this.mPaddingBottom + "}";
            Log.d(VIEW_LOG_TAG, output);
        }
        output = View.debugIndent(depth);
        output = output + "mMeasureWidth=" + this.mMeasuredWidth + " mMeasureHeight=" + this.mMeasuredHeight;
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = this.mLayoutParams == null ? output + "BAD! no layout params" : this.mLayoutParams.debug(output);
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = output + "flags={";
        output = output + View.printFlags(this.mViewFlags);
        output = output + "}";
        Log.d(VIEW_LOG_TAG, output);
        output = View.debugIndent(depth);
        output = output + "privateFlags={";
        output = output + View.printPrivateFlags(this.mPrivateFlags);
        output = output + "}";
        Log.d(VIEW_LOG_TAG, output);
    }

    public static String debugIndent(int depth) {
        StringBuilder spaces = new StringBuilder((depth * 2 + 3) * 2);
        for (int i = 0; i < depth * 2 + 3; ++i) {
            spaces.append(' ').append(' ');
        }
        return spaces.toString();
    }

    @ViewDebug.ExportedProperty(category="layout")
    public int getBaseline() {
        return -1;
    }

    public void requestLayout() {
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
        if (this.mParent != null && !this.mParent.isLayoutRequested()) {
            this.mParent.requestLayout();
        }
    }

    public void forceLayout() {
        this.mPrivateFlags |= 0x1000;
        this.mPrivateFlags |= Integer.MIN_VALUE;
    }

    public void measure(int widthMeasureSpec, int heightMeasureSpec) {
        if ((this.mPrivateFlags & 0x1000) == 4096 || widthMeasureSpec != this.mOldWidthMeasureSpec || heightMeasureSpec != this.mOldHeightMeasureSpec) {
            this.mPrivateFlags &= 0xFFFFF7FF;
            this.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if ((this.mPrivateFlags & 0x800) != 2048) {
                throw new IllegalStateException("onMeasure() did not set the measured dimension by calling setMeasuredDimension()");
            }
            this.mPrivateFlags |= 0x2000;
        }
        this.mOldWidthMeasureSpec = widthMeasureSpec;
        this.mOldHeightMeasureSpec = heightMeasureSpec;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.getDefaultSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), View.getDefaultSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    public void setMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.mMeasuredWidth = measuredWidth;
        this.mMeasuredHeight = measuredHeight;
        this.mPrivateFlags |= 0x800;
    }

    public static int combineMeasuredStates(int curState, int newState) {
        return curState | newState;
    }

    public static int resolveSize(int size, int measureSpec) {
        return View.resolveSizeAndState(size, measureSpec, 0) & 0xFFFFFF;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    public static int getDefaultSize(int size, int measureSpec) {
        int result = size;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: 
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    public int getSuggestedMinimumHeight() {
        int bgMinHeight;
        int suggestedMinHeight = this.mMinHeight;
        if (this.mBGDrawable != null && suggestedMinHeight < (bgMinHeight = this.mBGDrawable.getMinimumHeight())) {
            suggestedMinHeight = bgMinHeight;
        }
        return suggestedMinHeight;
    }

    public int getSuggestedMinimumWidth() {
        int bgMinWidth;
        int suggestedMinWidth = this.mMinWidth;
        if (this.mBGDrawable != null && suggestedMinWidth < (bgMinWidth = this.mBGDrawable.getMinimumWidth())) {
            suggestedMinWidth = bgMinWidth;
        }
        return suggestedMinWidth;
    }

    public void setMinimumHeight(int minHeight) {
        this.mMinHeight = minHeight;
    }

    public void setMinimumWidth(int minWidth) {
        this.mMinWidth = minWidth;
    }

    public Animation getAnimation() {
        return this.mCurrentAnimation;
    }

    public void startAnimation(Animation animation) {
        animation.setStartTime(-1L);
        this.setAnimation(animation);
        this.invalidateParentCaches();
        this.invalidate(true);
    }

    public void clearAnimation() {
        if (this.mCurrentAnimation != null) {
            this.mCurrentAnimation.detach();
        }
        this.mCurrentAnimation = null;
        this.invalidateParentIfNeeded();
    }

    public void setAnimation(Animation animation) {
        this.mCurrentAnimation = animation;
        if (animation != null) {
            animation.reset();
        }
    }

    public void onAnimationStart() {
        this.mPrivateFlags |= 0x10000;
    }

    public void onAnimationEnd() {
        this.mPrivateFlags &= 0xFFFEFFFF;
    }

    public boolean onSetAlpha(int alpha) {
        return false;
    }

    public boolean gatherTransparentRegion(Region region) {
        AttachInfo attachInfo = this.mAttachInfo;
        if (region != null && attachInfo != null) {
            int pflags = this.mPrivateFlags;
            if ((pflags & 0x80) == 0) {
                int[] location = attachInfo.mTransparentLocation;
                this.getLocationInWindow(location);
                region.op(location[0], location[1], location[0] + this.mRight - this.mLeft, location[1] + this.mBottom - this.mTop, Region.Op.DIFFERENCE);
            } else if ((pflags & 0x100) != 0 && this.mBGDrawable != null) {
                this.applyDrawableToTransparentRegion(this.mBGDrawable, region);
            }
        }
        return true;
    }

    public void playSoundEffect(int soundConstant) {
        if (this.mAttachInfo == null || this.mAttachInfo.mRootCallbacks == null || !this.isSoundEffectsEnabled()) {
            return;
        }
        this.mAttachInfo.mRootCallbacks.playSoundEffect(soundConstant);
    }

    public boolean performHapticFeedback(int feedbackConstant) {
        return this.performHapticFeedback(feedbackConstant, 0);
    }

    public boolean performHapticFeedback(int feedbackConstant, int flags) {
        if (this.mAttachInfo == null) {
            return false;
        }
        if ((flags & 1) == 0 && !this.isHapticFeedbackEnabled()) {
            return false;
        }
        return this.mAttachInfo.mRootCallbacks.performHapticFeedback(feedbackConstant, (flags & 2) != 0);
    }

    public void setSystemUiVisibility(int visibility) {
        if (visibility != this.mSystemUiVisibility) {
            this.mSystemUiVisibility = visibility;
            if (this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
                this.mParent.recomputeViewAttributes(this);
            }
        }
    }

    public int getSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    public void setOnSystemUiVisibilityChangeListener(OnSystemUiVisibilityChangeListener l) {
        this.mOnSystemUiVisibilityChangeListener = l;
        if (this.mParent != null && this.mAttachInfo != null && !this.mAttachInfo.mRecomputeGlobalAttributes) {
            this.mParent.recomputeViewAttributes(this);
        }
    }

    public void dispatchSystemUiVisibilityChanged(int visibility) {
        if (this.mOnSystemUiVisibilityChangeListener != null) {
            this.mOnSystemUiVisibilityChangeListener.onSystemUiVisibilityChange(visibility & 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDrag(ClipData data, DragShadowBuilder shadowBuilder, Object myLocalState, int flags) {
        boolean okay;
        block5: {
            okay = false;
            Point shadowSize = new Point();
            Point shadowTouchPoint = new Point();
            shadowBuilder.onProvideShadowMetrics(shadowSize, shadowTouchPoint);
            if (shadowSize.x < 0 || shadowSize.y < 0 || shadowTouchPoint.x < 0 || shadowTouchPoint.y < 0) {
                throw new IllegalStateException("Drag shadow dimensions must not be negative");
            }
            Surface surface = new Surface();
            try {
                IBinder token = this.mAttachInfo.mSession.prepareDrag(this.mAttachInfo.mWindow, flags, shadowSize.x, shadowSize.y, surface);
                if (token == null) break block5;
                Canvas canvas = surface.lockCanvas(null);
                try {
                    canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    shadowBuilder.onDrawShadow(canvas);
                    Object var12_12 = null;
                    surface.unlockCanvasAndPost(canvas);
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    surface.unlockCanvasAndPost(canvas);
                    throw throwable;
                }
                ViewRoot root = this.getViewRoot();
                root.setLocalDragState(myLocalState);
                root.getLastTouchPoint(shadowSize);
                okay = this.mAttachInfo.mSession.performDrag(this.mAttachInfo.mWindow, token, shadowSize.x, shadowSize.y, shadowTouchPoint.x, shadowTouchPoint.y, data);
            }
            catch (Exception e) {
                Log.e(VIEW_LOG_TAG, "Unable to initiate drag", e);
                surface.destroy();
            }
        }
        return okay;
    }

    public boolean onDragEvent(DragEvent event) {
        return false;
    }

    public boolean dispatchDragEvent(DragEvent event) {
        if (this.mOnDragListener != null && (this.mViewFlags & 0x20) == 0 && this.mOnDragListener.onDrag(this, event)) {
            return true;
        }
        return this.onDragEvent(event);
    }

    public void onCloseSystemDialogs(String reason) {
    }

    public void applyDrawableToTransparentRegion(Drawable dr, Region region) {
        Region r = dr.getTransparentRegion();
        Rect db = dr.getBounds();
        AttachInfo attachInfo = this.mAttachInfo;
        if (r != null && attachInfo != null) {
            int w = this.getRight() - this.getLeft();
            int h = this.getBottom() - this.getTop();
            if (db.left > 0) {
                r.op(0, 0, db.left, h, Region.Op.UNION);
            }
            if (db.right < w) {
                r.op(db.right, 0, w, h, Region.Op.UNION);
            }
            if (db.top > 0) {
                r.op(0, 0, w, db.top, Region.Op.UNION);
            }
            if (db.bottom < h) {
                r.op(0, db.bottom, w, h, Region.Op.UNION);
            }
            int[] location = attachInfo.mTransparentLocation;
            this.getLocationInWindow(location);
            r.translate(location[0], location[1]);
            region.op(r, Region.Op.INTERSECT);
        } else {
            region.op(db, Region.Op.DIFFERENCE);
        }
    }

    public void postCheckForLongClick(int delayOffset) {
        this.mHasPerformedLongPress = false;
        if (this.mPendingCheckForLongPress == null) {
            this.mPendingCheckForLongPress = new CheckForLongPress();
        }
        this.mPendingCheckForLongPress.rememberWindowAttachCount();
        this.postDelayed(this.mPendingCheckForLongPress, ViewConfiguration.getLongPressTimeout() - delayOffset);
    }

    public static View inflate(Context context, int resource, ViewGroup root) {
        LayoutInflater factory = LayoutInflater.from(context);
        return factory.inflate(resource, root);
    }

    public boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        int overScrollMode = this.mOverScrollMode;
        boolean canScrollHorizontal = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        boolean canScrollVertical = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        boolean overScrollHorizontal = overScrollMode == 0 || overScrollMode == 1 && canScrollHorizontal;
        boolean overScrollVertical = overScrollMode == 0 || overScrollMode == 1 && canScrollVertical;
        int newScrollX = scrollX + deltaX;
        if (!overScrollHorizontal) {
            maxOverScrollX = 0;
        }
        int newScrollY = scrollY + deltaY;
        if (!overScrollVertical) {
            maxOverScrollY = 0;
        }
        int left = -maxOverScrollX;
        int right = maxOverScrollX + scrollRangeX;
        int top = -maxOverScrollY;
        int bottom = maxOverScrollY + scrollRangeY;
        boolean clampedX = false;
        if (newScrollX > right) {
            newScrollX = right;
            clampedX = true;
        } else if (newScrollX < left) {
            newScrollX = left;
            clampedX = true;
        }
        boolean clampedY = false;
        if (newScrollY > bottom) {
            newScrollY = bottom;
            clampedY = true;
        } else if (newScrollY < top) {
            newScrollY = top;
            clampedY = true;
        }
        this.onOverScrolled(newScrollX, newScrollY, clampedX, clampedY);
        return clampedX || clampedY;
    }

    public void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
    }

    public int getOverScrollMode() {
        return this.mOverScrollMode;
    }

    public void setOverScrollMode(int overScrollMode) {
        if (overScrollMode != 0 && overScrollMode != 1 && overScrollMode != 2) {
            throw new IllegalArgumentException("Invalid overscroll mode " + overScrollMode);
        }
        this.mOverScrollMode = overScrollMode;
    }

    public void hackTurnOffWindowResizeAnim(boolean off) {
        this.mAttachInfo.mTurnOffWindowResizeAnim = off;
    }

    static {
        VIEW_STATE_IDS = new int[]{16842909, 1, 0x10100A1, 2, 16842908, 4, 16842910, 8, 16842919, 16, 16843518, 32, 16843547, 64};
        if (VIEW_STATE_IDS.length / 2 != R.styleable.ViewDrawableStates.length) {
            throw new IllegalStateException("VIEW_STATE_IDs array length does not match ViewDrawableStates style array");
        }
        int[] orderedIds = new int[VIEW_STATE_IDS.length];
        for (int i = 0; i < R.styleable.ViewDrawableStates.length; ++i) {
            int viewState = R.styleable.ViewDrawableStates[i];
            for (int j = 0; j < VIEW_STATE_IDS.length; j += 2) {
                if (VIEW_STATE_IDS[j] != viewState) continue;
                orderedIds[i * 2] = viewState;
                orderedIds[i * 2 + 1] = VIEW_STATE_IDS[j + 1];
            }
        }
        int NUM_BITS = VIEW_STATE_IDS.length / 2;
        VIEW_STATE_SETS = new int[1 << NUM_BITS][];
        for (int i = 0; i < VIEW_STATE_SETS.length; ++i) {
            int numBits = Integer.bitCount(i);
            int[] set = new int[numBits];
            int pos = 0;
            for (int j = 0; j < orderedIds.length; j += 2) {
                if ((i & orderedIds[j + 1]) == 0) continue;
                set[pos++] = orderedIds[j];
            }
            View.VIEW_STATE_SETS[i] = set;
        }
        EMPTY_STATE_SET = VIEW_STATE_SETS[0];
        WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[1];
        SELECTED_STATE_SET = VIEW_STATE_SETS[2];
        SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[3];
        FOCUSED_STATE_SET = VIEW_STATE_SETS[4];
        FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[5];
        FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[6];
        FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[7];
        ENABLED_STATE_SET = VIEW_STATE_SETS[8];
        ENABLED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[9];
        ENABLED_SELECTED_STATE_SET = VIEW_STATE_SETS[10];
        ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[11];
        ENABLED_FOCUSED_STATE_SET = VIEW_STATE_SETS[12];
        ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[13];
        ENABLED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[14];
        ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[15];
        PRESSED_STATE_SET = VIEW_STATE_SETS[16];
        PRESSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[17];
        PRESSED_SELECTED_STATE_SET = VIEW_STATE_SETS[18];
        PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[19];
        PRESSED_FOCUSED_STATE_SET = VIEW_STATE_SETS[20];
        PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[21];
        PRESSED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[22];
        PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[23];
        PRESSED_ENABLED_STATE_SET = VIEW_STATE_SETS[24];
        PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[25];
        PRESSED_ENABLED_SELECTED_STATE_SET = VIEW_STATE_SETS[26];
        PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[27];
        PRESSED_ENABLED_FOCUSED_STATE_SET = VIEW_STATE_SETS[28];
        PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[29];
        PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET = VIEW_STATE_SETS[30];
        PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = VIEW_STATE_SETS[31];
        LAST_STATE_SET = new int[]{16842918};
        FIRST_STATE_SET = new int[]{16842916};
        MIDDLE_STATE_SET = new int[]{16842917};
        SINGLE_STATE_SET = new int[]{16842915};
        PRESSED_LAST_STATE_SET = new int[]{16842918, 16842919};
        PRESSED_FIRST_STATE_SET = new int[]{16842916, 16842919};
        PRESSED_MIDDLE_STATE_SET = new int[]{16842917, 16842919};
        PRESSED_SINGLE_STATE_SET = new int[]{16842915, 16842919};
        sThreadLocal = new ThreadLocal();
        sTagsLock = new Object();
    }

    public static class ScrollabilityCache
    implements Runnable {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FADING = 2;
        public boolean fadeScrollBars;
        public int fadingEdgeLength;
        public int scrollBarDefaultDelayBeforeFade;
        public int scrollBarFadeDuration;
        public int scrollBarSize;
        public ScrollBarDrawable scrollBar;
        public float[] interpolatorValues;
        public View host;
        public final Paint paint;
        public final Matrix matrix;
        public Shader shader;
        public final Interpolator scrollBarInterpolator = new Interpolator(1, 2);
        public static final float[] OPAQUE = new float[]{255.0f};
        public static final float[] TRANSPARENT = new float[]{0.0f};
        public long fadeStartTime;
        public int state = 0;
        public int mLastColor;

        public ScrollabilityCache(ViewConfiguration configuration, View host) {
            this.fadingEdgeLength = configuration.getScaledFadingEdgeLength();
            this.scrollBarSize = configuration.getScaledScrollBarSize();
            this.scrollBarDefaultDelayBeforeFade = ViewConfiguration.getScrollDefaultDelay();
            this.scrollBarFadeDuration = ViewConfiguration.getScrollBarFadeDuration();
            this.paint = new Paint();
            this.matrix = new Matrix();
            this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, -16777216, 0, Shader.TileMode.CLAMP);
            this.paint.setShader(this.shader);
            this.paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.host = host;
        }

        public void setFadeColor(int color2) {
            if (color2 != 0 && color2 != this.mLastColor) {
                this.mLastColor = color2;
                this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, (color2 |= 0xFF000000) | 0xFF000000, color2 & 0xFFFFFF, Shader.TileMode.CLAMP);
                this.paint.setShader(this.shader);
                this.paint.setXfermode(null);
            }
        }

        public void run() {
            long now = AnimationUtils.currentAnimationTimeMillis();
            if (now >= this.fadeStartTime) {
                int nextFrame = (int)now;
                int framesCount = 0;
                Interpolator interpolator2 = this.scrollBarInterpolator;
                interpolator2.setKeyFrame(framesCount++, nextFrame, OPAQUE);
                interpolator2.setKeyFrame(framesCount, nextFrame += this.scrollBarFadeDuration, TRANSPARENT);
                this.state = 2;
                this.host.invalidate(true);
            }
        }
    }

    public static class AttachInfo {
        public final IWindowSession mSession;
        public final IWindow mWindow;
        public final IBinder mWindowToken;
        public final Callbacks mRootCallbacks;
        public Canvas mHardwareCanvas;
        public View mRootView;
        public IBinder mPanelParentWindowToken;
        public Surface mSurface;
        public boolean mHardwareAccelerated;
        public boolean mHardwareAccelerationRequested;
        public HardwareRenderer mHardwareRenderer;
        public float mApplicationScale;
        public boolean mScalingRequired;
        public boolean mTurnOffWindowResizeAnim;
        public int mWindowLeft;
        public int mWindowTop;
        public boolean mUse32BitDrawingCache;
        public final Rect mContentInsets = new Rect();
        public final Rect mVisibleInsets = new Rect();
        public final ViewTreeObserver.InternalInsetsInfo mGivenInternalInsets = new ViewTreeObserver.InternalInsetsInfo();
        public final ArrayList<View> mScrollContainers = new ArrayList();
        public final KeyEvent.DispatcherState mKeyDispatchState = new KeyEvent.DispatcherState();
        public boolean mHasWindowFocus;
        public int mWindowVisibility;
        public long mDrawingTime;
        public boolean mIgnoreDirtyState;
        public boolean mInTouchMode;
        public boolean mRecomputeGlobalAttributes;
        public boolean mKeepScreenOn;
        public int mSystemUiVisibility;
        public boolean mHasSystemUiListeners;
        public boolean mViewVisibilityChanged;
        public boolean mViewScrollChanged;
        public final int[] mTransparentLocation = new int[2];
        public final int[] mInvalidateChildLocation = new int[2];
        public final float[] mTmpTransformLocation = new float[2];
        public final ViewTreeObserver mTreeObserver = new ViewTreeObserver();
        public Canvas mCanvas;
        public final Handler mHandler;
        public static final int INVALIDATE_MSG = 1;
        public static final int INVALIDATE_RECT_MSG = 2;
        public final Rect mTmpInvalRect = new Rect();
        public final RectF mTmpTransformRect = new RectF();
        public final ArrayList<View> mFocusablesTempList = new ArrayList(24);

        public AttachInfo(IWindowSession session, IWindow window, Handler handler, Callbacks effectPlayer) {
            this.mSession = session;
            this.mWindow = window;
            this.mWindowToken = window.asBinder();
            this.mHandler = handler;
            this.mRootCallbacks = effectPlayer;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class InvalidateInfo
        implements Poolable<InvalidateInfo> {
            public static final int POOL_LIMIT = 10;
            public static final Pool<InvalidateInfo> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<InvalidateInfo>(){

                @Override
                public InvalidateInfo newInstance() {
                    return new InvalidateInfo();
                }

                @Override
                public void onAcquired(InvalidateInfo element) {
                }

                @Override
                public void onReleased(InvalidateInfo element) {
                }
            }, 10));
            public InvalidateInfo mNext;
            public View target;
            public int left;
            public int top;
            public int right;
            public int bottom;

            @Override
            public void setNextPoolable(InvalidateInfo element) {
                this.mNext = element;
            }

            @Override
            public InvalidateInfo getNextPoolable() {
                return this.mNext;
            }

            public static InvalidateInfo acquire() {
                return sPool.acquire();
            }

            public void release() {
                sPool.release(this);
            }
        }

        public static interface Callbacks {
            public void playSoundEffect(int var1);

            public boolean performHapticFeedback(int var1, boolean var2);
        }
    }

    public static class BaseSavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<BaseSavedState> CREATOR = new Parcelable.Creator<BaseSavedState>(){

            @Override
            public BaseSavedState createFromParcel(Parcel in) {
                return new BaseSavedState(in);
            }

            public BaseSavedState[] newArray(int size) {
                return new BaseSavedState[size];
            }
        };

        public BaseSavedState(Parcel source) {
            super(source);
        }

        public BaseSavedState(Parcelable superState) {
            super(superState);
        }
    }

    public class UnsetPressedState
    implements Runnable {
        public UnsetPressedState() {
        }

        public void run() {
            View.this.setPressed(false);
        }

        public /* synthetic */ UnsetPressedState(1 x1) {
            this();
        }
    }

    public static interface OnSystemUiVisibilityChangeListener {
        public void onSystemUiVisibilityChange(int var1);
    }

    public static interface OnCreateContextMenuListener {
        public void onCreateContextMenu(ContextMenu var1, View var2, ContextMenu.ContextMenuInfo var3);
    }

    public static interface OnClickListener {
        public void onClick(View var1);
    }

    public static interface OnFocusChangeListener {
        public void onFocusChange(View var1, boolean var2);
    }

    public static interface OnDragListener {
        public boolean onDrag(View var1, DragEvent var2);
    }

    public static interface OnLongClickListener {
        public boolean onLongClick(View var1);
    }

    public static interface OnTouchListener {
        public boolean onTouch(View var1, MotionEvent var2);
    }

    public static interface OnKeyListener {
        public boolean onKey(View var1, int var2, KeyEvent var3);
    }

    public class PerformClick
    implements Runnable {
        public PerformClick() {
        }

        public void run() {
            View.this.performClick();
        }

        public /* synthetic */ PerformClick(1 x1) {
            this();
        }
    }

    public class CheckForTap
    implements Runnable {
        public CheckForTap() {
        }

        public void run() {
            View.this.mPrivateFlags &= 0xFDFFFFFF;
            View.this.mPrivateFlags |= 0x4000;
            View.this.refreshDrawableState();
            if ((View.this.mViewFlags & 0x200000) == 0x200000) {
                View.this.postCheckForLongClick(ViewConfiguration.getTapTimeout());
            }
        }

        public /* synthetic */ CheckForTap(1 x1) {
            this();
        }
    }

    public class CheckForLongPress
    implements Runnable {
        public int mOriginalWindowAttachCount;

        public void run() {
            if (View.this.isPressed() && View.this.mParent != null && this.mOriginalWindowAttachCount == View.this.mWindowAttachCount && View.this.performLongClick()) {
                View.this.mHasPerformedLongPress = true;
            }
        }

        public void rememberWindowAttachCount() {
            this.mOriginalWindowAttachCount = View.this.mWindowAttachCount;
        }
    }

    public static class MeasureSpec {
        public static final int MODE_SHIFT = 30;
        public static final int MODE_MASK = -1073741824;
        public static final int UNSPECIFIED = 0;
        public static final int EXACTLY = 0x40000000;
        public static final int AT_MOST = Integer.MIN_VALUE;

        public static int makeMeasureSpec(int size, int mode) {
            return size + mode;
        }

        public static int getMode(int measureSpec) {
            return measureSpec & 0xC0000000;
        }

        public static int getSize(int measureSpec) {
            return measureSpec & 0x3FFFFFFF;
        }

        public static String toString(int measureSpec) {
            int mode = MeasureSpec.getMode(measureSpec);
            int size = MeasureSpec.getSize(measureSpec);
            StringBuilder sb = new StringBuilder("MeasureSpec: ");
            if (mode == 0) {
                sb.append("UNSPECIFIED ");
            } else if (mode == 0x40000000) {
                sb.append("EXACTLY ");
            } else if (mode == Integer.MIN_VALUE) {
                sb.append("AT_MOST ");
            } else {
                sb.append(mode).append(" ");
            }
            sb.append(size);
            return sb.toString();
        }
    }

    public static class DragShadowBuilder {
        public final WeakReference<View> mView;

        public DragShadowBuilder(View view) {
            this.mView = new WeakReference<View>(view);
        }

        public DragShadowBuilder() {
            this.mView = new WeakReference<Object>(null);
        }

        public View getView() {
            return (View)this.mView.get();
        }

        public void onProvideShadowMetrics(Point shadowSize, Point shadowTouchPoint) {
            View view = (View)this.mView.get();
            if (view != null) {
                shadowSize.set(view.getWidth(), view.getHeight());
                shadowTouchPoint.set(shadowSize.x / 2, shadowSize.y / 2);
            } else {
                Log.e(View.VIEW_LOG_TAG, "Asked for drag thumb metrics but no view");
            }
        }

        public void onDrawShadow(Canvas canvas) {
            View view = (View)this.mView.get();
            if (view != null) {
                view.draw(canvas);
            } else {
                Log.e(View.VIEW_LOG_TAG, "Asked to draw drag shadow but no view");
            }
        }
    }

    public static interface OnLayoutChangeListener {
        public void onLayoutChange(View var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
    }
}

