/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.SparseArray;

public class ViewConfiguration {
    public static final float PANEL_BIT_DEPTH = 24.0f;
    public static final float ALPHA_THRESHOLD = 0.020833334f;
    public static final float ALPHA_THRESHOLD_INT = 5.2916665f;
    public static final int SCROLL_BAR_SIZE = 10;
    public static final int SCROLL_BAR_FADE_DURATION = 250;
    public static final int SCROLL_BAR_DEFAULT_DELAY = 300;
    public static final int FADING_EDGE_LENGTH = 12;
    public static final int PRESSED_STATE_DURATION = 125;
    public static final int LONG_PRESS_TIMEOUT = 500;
    public static final int GLOBAL_ACTIONS_KEY_TIMEOUT = 500;
    public static final int TAP_TIMEOUT = 115;
    public static final int JUMP_TAP_TIMEOUT = 500;
    public static final int DOUBLE_TAP_TIMEOUT = 300;
    public static final int ZOOM_CONTROLS_TIMEOUT = 3000;
    public static final int EDGE_SLOP = 12;
    public static final int TOUCH_SLOP = 16;
    public static final int PAGING_TOUCH_SLOP = 32;
    public static final int DOUBLE_TAP_SLOP = 100;
    public static final int WINDOW_TOUCH_SLOP = 16;
    public static final int MINIMUM_FLING_VELOCITY = 50;
    public static final int MAXIMUM_FLING_VELOCITY = 8000;
    @Deprecated
    public static final int MAXIMUM_DRAWING_CACHE_SIZE = 614400;
    public static float SCROLL_FRICTION = 0.015f;
    public static final int OVERSCROLL_DISTANCE = 0;
    public static final int OVERFLING_DISTANCE = 6;
    public final int mEdgeSlop;
    public final int mFadingEdgeLength;
    public final int mMinimumFlingVelocity;
    public final int mMaximumFlingVelocity;
    public final int mScrollbarSize;
    public final int mTouchSlop;
    public final int mPagingTouchSlop;
    public final int mDoubleTapSlop;
    public final int mWindowTouchSlop;
    public final int mMaximumDrawingCacheSize;
    public final int mOverscrollDistance;
    public final int mOverflingDistance;
    public static final SparseArray<ViewConfiguration> sConfigurations = new SparseArray(2);

    @Deprecated
    public ViewConfiguration() {
        this.mEdgeSlop = 12;
        this.mFadingEdgeLength = 12;
        this.mMinimumFlingVelocity = 50;
        this.mMaximumFlingVelocity = 8000;
        this.mScrollbarSize = 10;
        this.mTouchSlop = 16;
        this.mPagingTouchSlop = 32;
        this.mDoubleTapSlop = 100;
        this.mWindowTouchSlop = 16;
        this.mMaximumDrawingCacheSize = 614400;
        this.mOverscrollDistance = 0;
        this.mOverflingDistance = 6;
    }

    public ViewConfiguration(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float density = metrics.density;
        float sizeAndDensity = context.getResources().getConfiguration().isLayoutSizeAtLeast(4) ? density * 1.5f : density;
        this.mEdgeSlop = (int)(sizeAndDensity * 12.0f + 0.5f);
        this.mFadingEdgeLength = (int)(sizeAndDensity * 12.0f + 0.5f);
        this.mMinimumFlingVelocity = (int)(density * 50.0f + 0.5f);
        this.mMaximumFlingVelocity = (int)(density * 8000.0f + 0.5f);
        this.mScrollbarSize = (int)(density * 10.0f + 0.5f);
        this.mTouchSlop = (int)(sizeAndDensity * 16.0f + 0.5f);
        this.mPagingTouchSlop = (int)(sizeAndDensity * 32.0f + 0.5f);
        this.mDoubleTapSlop = (int)(sizeAndDensity * 100.0f + 0.5f);
        this.mWindowTouchSlop = (int)(sizeAndDensity * 16.0f + 0.5f);
        this.mMaximumDrawingCacheSize = 4 * metrics.widthPixels * metrics.heightPixels;
        this.mOverscrollDistance = (int)(sizeAndDensity * 0.0f + 0.5f);
        this.mOverflingDistance = (int)(sizeAndDensity * 6.0f + 0.5f);
    }

    public static ViewConfiguration get(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int density = (int)(100.0f * metrics.density);
        ViewConfiguration configuration = sConfigurations.get(density);
        if (configuration == null) {
            configuration = new ViewConfiguration(context);
            sConfigurations.put(density, configuration);
        }
        return configuration;
    }

    @Deprecated
    public static int getScrollBarSize() {
        return 10;
    }

    public int getScaledScrollBarSize() {
        return this.mScrollbarSize;
    }

    public static int getScrollBarFadeDuration() {
        return 250;
    }

    public static int getScrollDefaultDelay() {
        return 300;
    }

    @Deprecated
    public static int getFadingEdgeLength() {
        return 12;
    }

    public int getScaledFadingEdgeLength() {
        return this.mFadingEdgeLength;
    }

    public static int getPressedStateDuration() {
        return 125;
    }

    public static int getLongPressTimeout() {
        return 500;
    }

    public static int getTapTimeout() {
        return 115;
    }

    public static int getJumpTapTimeout() {
        return 500;
    }

    public static int getDoubleTapTimeout() {
        return 300;
    }

    @Deprecated
    public static int getEdgeSlop() {
        return 12;
    }

    public int getScaledEdgeSlop() {
        return this.mEdgeSlop;
    }

    @Deprecated
    public static int getTouchSlop() {
        return 16;
    }

    public int getScaledTouchSlop() {
        return this.mTouchSlop;
    }

    public int getScaledPagingTouchSlop() {
        return this.mPagingTouchSlop;
    }

    @Deprecated
    public static int getDoubleTapSlop() {
        return 100;
    }

    public int getScaledDoubleTapSlop() {
        return this.mDoubleTapSlop;
    }

    @Deprecated
    public static int getWindowTouchSlop() {
        return 16;
    }

    public int getScaledWindowTouchSlop() {
        return this.mWindowTouchSlop;
    }

    @Deprecated
    public static int getMinimumFlingVelocity() {
        return 50;
    }

    public int getScaledMinimumFlingVelocity() {
        return this.mMinimumFlingVelocity;
    }

    @Deprecated
    public static int getMaximumFlingVelocity() {
        return 8000;
    }

    public int getScaledMaximumFlingVelocity() {
        return this.mMaximumFlingVelocity;
    }

    @Deprecated
    public static int getMaximumDrawingCacheSize() {
        return 614400;
    }

    public int getScaledMaximumDrawingCacheSize() {
        return this.mMaximumDrawingCacheSize;
    }

    public int getScaledOverscrollDistance() {
        return this.mOverscrollDistance;
    }

    public int getScaledOverflingDistance() {
        return this.mOverflingDistance;
    }

    public static long getZoomControlsTimeout() {
        return 3000L;
    }

    public static long getGlobalActionKeyTimeout() {
        return 500L;
    }

    public static float getScrollFriction() {
        return SCROLL_FRICTION;
    }
}

