/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ActivityManagerNative;
import android.content.ClipDescription;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.LatencyTimer;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.DragEvent;
import android.view.FallbackEventHandler;
import android.view.FocusFinder;
import android.view.HardwareRenderer;
import android.view.IWindow;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Scroller;
import com.android.internal.policy.PolicyManager;
import com.android.internal.view.BaseSurfaceHolder;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class ViewRoot
extends Handler
implements ViewParent,
View.AttachInfo.Callbacks,
HardwareRenderer.HardwareDrawCallbacks {
    public static final String TAG = "ViewRoot";
    public static final boolean DBG = false;
    public static final boolean SHOW_FPS = false;
    public static final boolean LOCAL_LOGV = false;
    public static final boolean DEBUG_DRAW = false;
    public static final boolean DEBUG_LAYOUT = false;
    public static final boolean DEBUG_DIALOG = false;
    public static final boolean DEBUG_INPUT_RESIZE = false;
    public static final boolean DEBUG_ORIENTATION = false;
    public static final boolean DEBUG_TRACKBALL = false;
    public static final boolean DEBUG_IMF = false;
    public static final boolean DEBUG_CONFIGURATION = false;
    public static final boolean WATCH_POINTER = false;
    public static final boolean MEASURE_LATENCY = false;
    public static LatencyTimer lt;
    public static final int MAX_TRACKBALL_DELAY = 250;
    public static IWindowSession sWindowSession;
    public static final Object mStaticInit;
    public static boolean mInitialized;
    public static final ThreadLocal<RunQueue> sRunQueues;
    public static final ArrayList<Runnable> sFirstDrawHandlers;
    public static boolean sFirstDrawComplete;
    public static final ArrayList<ComponentCallbacks> sConfigCallbacks;
    public static int sDrawTime;
    public long mLastTrackballTime = 0L;
    public final TrackballAxis mTrackballAxisX = new TrackballAxis();
    public final TrackballAxis mTrackballAxisY = new TrackballAxis();
    public final int[] mTmpLocation = new int[2];
    public final TypedValue mTmpValue = new TypedValue();
    public final InputMethodCallback mInputMethodCallback;
    public final SparseArray<Object> mPendingEvents = new SparseArray();
    public int mPendingEventSeq = 0;
    public final Thread mThread;
    public final WindowLeaked mLocation;
    public final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();
    public final W mWindow;
    public View mView;
    public View mFocusedView;
    public View mRealFocusedView;
    public int mViewVisibility;
    public boolean mAppVisible = true;
    public SurfaceHolder.Callback2 mSurfaceHolderCallback;
    public BaseSurfaceHolder mSurfaceHolder;
    public boolean mIsCreating;
    public boolean mDrawingAllowed;
    public final Region mTransparentRegion;
    public final Region mPreviousTransparentRegion;
    public int mWidth;
    public int mHeight;
    public Rect mDirty;
    public final Rect mCurrentDirty = new Rect();
    public final Rect mPreviousDirty = new Rect();
    public boolean mIsAnimating;
    public CompatibilityInfo.Translator mTranslator;
    public final View.AttachInfo mAttachInfo;
    public InputChannel mInputChannel;
    public InputQueue.Callback mInputQueueCallback;
    public InputQueue mInputQueue;
    public FallbackEventHandler mFallbackEventHandler;
    public final Rect mTempRect;
    public final Rect mVisRect;
    public boolean mTraversalScheduled;
    public boolean mWillDrawSoon;
    public boolean mLayoutRequested;
    public boolean mFirst;
    public boolean mReportNextDraw;
    public boolean mFullRedrawNeeded;
    public boolean mNewSurfaceNeeded;
    public boolean mHasHadWindowFocus;
    public boolean mLastWasImTarget;
    public boolean mWindowAttributesChanged = false;
    public final Surface mSurface = new Surface();
    public boolean mAdded;
    public boolean mAddedTouchMode;
    public int mAddNesting;
    public final Rect mWinFrame;
    public final Rect mPendingVisibleInsets = new Rect();
    public final Rect mPendingContentInsets = new Rect();
    public final ViewTreeObserver.InternalInsetsInfo mLastGivenInsets = new ViewTreeObserver.InternalInsetsInfo();
    public final Configuration mLastConfiguration = new Configuration();
    public final Configuration mPendingConfiguration = new Configuration();
    public boolean mScrollMayChange;
    public int mSoftInputMode;
    public View mLastScrolledFocus;
    public int mScrollY;
    public int mCurScrollY;
    public Scroller mScroller;
    public Bitmap mResizeBitmap;
    public long mResizeBitmapStartTime;
    public int mResizeBitmapDuration;
    public static final Interpolator mResizeInterpolator;
    public final ViewConfiguration mViewConfiguration;
    public ClipDescription mDragDescription;
    public View mCurrentDragView;
    public volatile Object mLocalDragState;
    public final PointF mDragPoint = new PointF();
    public final PointF mLastTouchPoint = new PointF();
    public AudioManager mAudioManager;
    public final int mDensity;
    public boolean mProfile = false;
    public int mHardwareYOffset;
    public int mResizeAlpha;
    public final Paint mResizePaint = new Paint();
    public static final int DO_TRAVERSAL = 1000;
    public static final int DIE = 1001;
    public static final int RESIZED = 1002;
    public static final int RESIZED_REPORT = 1003;
    public static final int WINDOW_FOCUS_CHANGED = 1004;
    public static final int DISPATCH_KEY = 1005;
    public static final int DISPATCH_POINTER = 1006;
    public static final int DISPATCH_TRACKBALL = 1007;
    public static final int DISPATCH_APP_VISIBILITY = 1008;
    public static final int DISPATCH_GET_NEW_SURFACE = 1009;
    public static final int FINISHED_EVENT = 1010;
    public static final int DISPATCH_KEY_FROM_IME = 1011;
    public static final int FINISH_INPUT_CONNECTION = 1012;
    public static final int CHECK_FOCUS = 1013;
    public static final int CLOSE_SYSTEM_DIALOGS = 1014;
    public static final int DISPATCH_DRAG_EVENT = 1015;
    public static final int DISPATCH_DRAG_LOCATION_EVENT = 1016;
    public static final int DISPATCH_SYSTEM_UI_VISIBILITY = 1017;
    public InputQueue.FinishedCallback mFinishedCallback;
    public final InputHandler mInputHandler = new InputHandler(){

        public void handleKey(KeyEvent event, InputQueue.FinishedCallback finishedCallback) {
            ViewRoot.this.startInputEvent(finishedCallback);
            ViewRoot.this.dispatchKey(event, true);
        }

        public void handleMotion(MotionEvent event, InputQueue.FinishedCallback finishedCallback) {
            ViewRoot.this.startInputEvent(finishedCallback);
            ViewRoot.this.dispatchMotion(event, true);
        }
    };
    public SurfaceHolder mHolder = new SurfaceHolder(){

        public Surface getSurface() {
            return ViewRoot.this.mSurface;
        }

        public boolean isCreating() {
            return false;
        }

        public void addCallback(SurfaceHolder.Callback callback) {
        }

        public void removeCallback(SurfaceHolder.Callback callback) {
        }

        public void setFixedSize(int width, int height) {
        }

        public void setSizeFromLayout() {
        }

        public void setFormat(int format) {
        }

        public void setType(int type) {
        }

        public void setKeepScreenOn(boolean screenOn) {
        }

        public Canvas lockCanvas() {
            return null;
        }

        public Canvas lockCanvas(Rect dirty) {
            return null;
        }

        public void unlockCanvasAndPost(Canvas canvas) {
        }

        public Rect getSurfaceFrame() {
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWindowSession getWindowSession(Looper mainLooper) {
        Object object = mStaticInit;
        synchronized (object) {
            if (!mInitialized) {
                try {
                    InputMethodManager imm = InputMethodManager.getInstance(mainLooper);
                    sWindowSession = IWindowManager.Stub.asInterface(ServiceManager.getService("window")).openSession(imm.getClient(), imm.getInputContext());
                    mInitialized = true;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return sWindowSession;
        }
    }

    public ViewRoot(Context context) {
        ViewRoot.getWindowSession(context.getMainLooper());
        this.mThread = Thread.currentThread();
        this.mLocation = new WindowLeaked(null);
        this.mLocation.fillInStackTrace();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mDirty = new Rect();
        this.mTempRect = new Rect();
        this.mVisRect = new Rect();
        this.mWinFrame = new Rect();
        this.mWindow = new W(this);
        this.mInputMethodCallback = new InputMethodCallback(this);
        this.mViewVisibility = 8;
        this.mTransparentRegion = new Region();
        this.mPreviousTransparentRegion = new Region();
        this.mFirst = true;
        this.mAdded = false;
        this.mAttachInfo = new View.AttachInfo(sWindowSession, this.mWindow, this, this);
        this.mViewConfiguration = ViewConfiguration.get(context);
        this.mDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.mFallbackEventHandler = PolicyManager.makeNewFallbackEventHandler(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFirstDrawHandler(Runnable callback) {
        ArrayList<Runnable> arrayList = sFirstDrawHandlers;
        synchronized (arrayList) {
            if (!sFirstDrawComplete) {
                sFirstDrawHandlers.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigCallback(ComponentCallbacks callback) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            sConfigCallbacks.add(callback);
        }
    }

    public void profile() {
        this.mProfile = true;
    }

    public static boolean isInTouchMode() {
        if (mInitialized) {
            try {
                return sWindowSession.getInTouchMode();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(View view, WindowManager.LayoutParams attrs, View panelParentView) {
        ViewRoot viewRoot = this;
        synchronized (viewRoot) {
            if (this.mView == null) {
                int res;
                this.mView = view;
                this.mFallbackEventHandler.setView(view);
                this.mWindowAttributes.copyFrom(attrs);
                attrs = this.mWindowAttributes;
                if (view instanceof RootViewSurfaceTaker) {
                    this.mSurfaceHolderCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheSurface();
                    if (this.mSurfaceHolderCallback != null) {
                        this.mSurfaceHolder = new TakenSurfaceHolder();
                        this.mSurfaceHolder.setFormat(0);
                    }
                }
                if (this.mSurfaceHolder == null) {
                    this.enableHardwareAcceleration(attrs);
                }
                Resources resources = this.mView.getContext().getResources();
                CompatibilityInfo compatibilityInfo = resources.getCompatibilityInfo();
                this.mTranslator = compatibilityInfo.getTranslator();
                if (this.mTranslator != null || !compatibilityInfo.supportsScreen()) {
                    this.mSurface.setCompatibleDisplayMetrics(resources.getDisplayMetrics(), this.mTranslator);
                }
                boolean restore = false;
                if (this.mTranslator != null) {
                    restore = true;
                    attrs.backup();
                    this.mTranslator.translateWindowLayout(attrs);
                }
                if (!compatibilityInfo.supportsScreen()) {
                    attrs.flags |= 0x20000000;
                }
                this.mSoftInputMode = attrs.softInputMode;
                this.mWindowAttributesChanged = true;
                this.mAttachInfo.mRootView = view;
                this.mAttachInfo.mScalingRequired = this.mTranslator != null;
                float f = this.mAttachInfo.mApplicationScale = this.mTranslator == null ? 1.0f : this.mTranslator.applicationScale;
                if (panelParentView != null) {
                    this.mAttachInfo.mPanelParentWindowToken = panelParentView.getApplicationWindowToken();
                }
                this.mAdded = true;
                this.requestLayout();
                this.mInputChannel = new InputChannel();
                try {
                    try {
                        res = sWindowSession.add(this.mWindow, this.mWindowAttributes, this.getHostVisibility(), this.mAttachInfo.mContentInsets, this.mInputChannel);
                    }
                    catch (RemoteException e) {
                        this.mAdded = false;
                        this.mView = null;
                        this.mAttachInfo.mRootView = null;
                        this.mInputChannel = null;
                        this.mFallbackEventHandler.setView(null);
                        this.unscheduleTraversals();
                        throw new RuntimeException("Adding window failed", e);
                    }
                    Object var11_9 = null;
                    if (restore) {
                        attrs.restore();
                    }
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    if (restore) {
                        attrs.restore();
                    }
                    throw throwable;
                }
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInScreenToAppWindow(this.mAttachInfo.mContentInsets);
                }
                this.mPendingContentInsets.set(this.mAttachInfo.mContentInsets);
                this.mPendingVisibleInsets.set(0, 0, 0, 0);
                if (res < 0) {
                    this.mView = null;
                    this.mAttachInfo.mRootView = null;
                    this.mAdded = false;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    switch (res) {
                        case -2: 
                        case -1: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not valid; is your activity running?");
                        }
                        case -3: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not for an application");
                        }
                        case -4: {
                            throw new WindowManager.BadTokenException("Unable to add window -- app for token " + attrs.token + " is exiting");
                        }
                        case -5: {
                            throw new WindowManager.BadTokenException("Unable to add window -- window " + this.mWindow + " has already been added");
                        }
                        case -6: {
                            return;
                        }
                        case -7: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- another window of this type already exists");
                        }
                        case -8: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- permission denied for this window type");
                        }
                    }
                    throw new RuntimeException("Unable to add window -- unknown error code " + res);
                }
                if (view instanceof RootViewSurfaceTaker) {
                    this.mInputQueueCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheInputQueue();
                }
                if (this.mInputQueueCallback != null) {
                    this.mInputQueue = new InputQueue(this.mInputChannel);
                    this.mInputQueueCallback.onInputQueueCreated(this.mInputQueue);
                } else {
                    InputQueue.registerInputChannel(this.mInputChannel, this.mInputHandler, Looper.myQueue());
                }
                view.assignParent(this);
                this.mAddedTouchMode = (res & 1) != 0;
                this.mAppVisible = (res & 2) != 0;
            }
        }
    }

    public void enableHardwareAcceleration(WindowManager.LayoutParams attrs) {
        this.mAttachInfo.mHardwareAccelerated = false;
        this.mAttachInfo.mHardwareAccelerationRequested = false;
        if (attrs != null && (attrs.flags & 0x1000000) != 0) {
            if (!HardwareRenderer.sRendererDisabled) {
                boolean translucent;
                if (Looper.getMainLooper() != Looper.myLooper()) {
                    Log.w("HardwareRenderer", "Attempting to initialize hardware acceleration outside of the main thread, aborting");
                    return;
                }
                boolean bl = translucent = attrs.format != -1;
                if (this.mAttachInfo.mHardwareRenderer != null) {
                    this.mAttachInfo.mHardwareRenderer.destroy(true);
                }
                this.mAttachInfo.mHardwareRenderer = HardwareRenderer.createGlRenderer(2, translucent);
                this.mAttachInfo.mHardwareAccelerationRequested = this.mAttachInfo.mHardwareRenderer != null;
                this.mAttachInfo.mHardwareAccelerated = this.mAttachInfo.mHardwareAccelerationRequested;
            } else if (HardwareRenderer.isAvailable()) {
                this.mAttachInfo.mHardwareAccelerationRequested = true;
            }
        }
    }

    public View getView() {
        return this.mView;
    }

    public WindowLeaked getLocation() {
        return this.mLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutParams(WindowManager.LayoutParams attrs, boolean newView) {
        ViewRoot viewRoot = this;
        synchronized (viewRoot) {
            int oldSoftInputMode = this.mWindowAttributes.softInputMode;
            int compatibleWindowFlag = this.mWindowAttributes.flags & 0x20000000;
            this.mWindowAttributes.copyFrom(attrs);
            this.mWindowAttributes.flags |= compatibleWindowFlag;
            if (newView) {
                this.mSoftInputMode = attrs.softInputMode;
                this.requestLayout();
            }
            if ((attrs.softInputMode & 0xF0) == 0) {
                this.mWindowAttributes.softInputMode = this.mWindowAttributes.softInputMode & 0xFFFFFF0F | oldSoftInputMode & 0xF0;
            }
            this.mWindowAttributesChanged = true;
            this.scheduleTraversals();
        }
    }

    public void handleAppVisibility(boolean visible) {
        if (this.mAppVisible != visible) {
            this.mAppVisible = visible;
            this.scheduleTraversals();
        }
    }

    public void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    public void requestLayout() {
        this.checkThread();
        this.mLayoutRequested = true;
        this.scheduleTraversals();
    }

    public boolean isLayoutRequested() {
        return this.mLayoutRequested;
    }

    public void invalidateChild(View child, Rect dirty) {
        this.checkThread();
        if (dirty == null) {
            this.invalidate();
            return;
        }
        if (this.mCurScrollY != 0 || this.mTranslator != null) {
            this.mTempRect.set(dirty);
            dirty = this.mTempRect;
            if (this.mCurScrollY != 0) {
                dirty.offset(0, -this.mCurScrollY);
            }
            if (this.mTranslator != null) {
                this.mTranslator.translateRectInAppWindowToScreen(dirty);
            }
            if (this.mAttachInfo.mScalingRequired) {
                dirty.inset(-1, -1);
            }
        }
        if (!this.mDirty.isEmpty() && !this.mDirty.contains(dirty)) {
            this.mAttachInfo.mIgnoreDirtyState = true;
        }
        this.mDirty.union(dirty);
        if (!this.mWillDrawSoon) {
            this.scheduleTraversals();
        }
    }

    public void invalidate() {
        this.mDirty.set(0, 0, this.mWidth, this.mHeight);
        this.scheduleTraversals();
    }

    public ViewParent getParent() {
        return null;
    }

    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        this.invalidateChild(null, dirty);
        return null;
    }

    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        if (child != this.mView) {
            throw new RuntimeException("child is not mine, honest!");
        }
        return r.intersect(0, 0, this.mWidth, this.mHeight);
    }

    public void bringChildToFront(View child) {
    }

    public void scheduleTraversals() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.sendEmptyMessage(1000);
        }
    }

    public void unscheduleTraversals() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.removeMessages(1000);
        }
    }

    public int getHostVisibility() {
        return this.mAppVisible ? this.mView.getVisibility() : 8;
    }

    public void disposeResizeBitmap() {
        if (this.mResizeBitmap != null) {
            this.mResizeBitmap.recycle();
            this.mResizeBitmap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTraversals() {
        boolean cancelDraw;
        boolean imTarget;
        boolean didLayout;
        boolean triggerGlobalLayoutListener;
        int childHeightMeasureSpec;
        int childWidthMeasureSpec;
        int desiredWindowHeight;
        int desiredWindowWidth;
        View host = this.mView;
        if (host == null || !this.mAdded) {
            return;
        }
        this.mTraversalScheduled = false;
        this.mWillDrawSoon = true;
        boolean windowSizeMayChange = false;
        boolean fullRedrawNeeded = this.mFullRedrawNeeded;
        boolean newSurface = false;
        boolean surfaceChanged = false;
        WindowManager.LayoutParams lp = this.mWindowAttributes;
        View.AttachInfo attachInfo = this.mAttachInfo;
        int viewVisibility = this.getHostVisibility();
        boolean viewVisibilityChanged = this.mViewVisibility != viewVisibility || this.mNewSurfaceNeeded;
        WindowManager.LayoutParams params = null;
        if (this.mWindowAttributesChanged) {
            this.mWindowAttributesChanged = false;
            surfaceChanged = true;
            params = lp;
        }
        Rect frame = this.mWinFrame;
        if (this.mFirst) {
            fullRedrawNeeded = true;
            this.mLayoutRequested = true;
            DisplayMetrics packageMetrics = this.mView.getContext().getResources().getDisplayMetrics();
            desiredWindowWidth = packageMetrics.widthPixels;
            desiredWindowHeight = packageMetrics.heightPixels;
            attachInfo.mSurface = this.mSurface;
            attachInfo.mUse32BitDrawingCache = true;
            attachInfo.mHasWindowFocus = false;
            attachInfo.mWindowVisibility = viewVisibility;
            attachInfo.mRecomputeGlobalAttributes = false;
            attachInfo.mKeepScreenOn = false;
            attachInfo.mSystemUiVisibility = 0;
            viewVisibilityChanged = false;
            this.mLastConfiguration.setTo(host.getResources().getConfiguration());
            host.dispatchAttachedToWindow(attachInfo, 0);
        } else {
            desiredWindowWidth = frame.width();
            desiredWindowHeight = frame.height();
            if (desiredWindowWidth != this.mWidth || desiredWindowHeight != this.mHeight) {
                fullRedrawNeeded = true;
                this.mLayoutRequested = true;
                windowSizeMayChange = true;
            }
        }
        if (viewVisibilityChanged) {
            attachInfo.mWindowVisibility = viewVisibility;
            host.dispatchWindowVisibilityChanged(viewVisibility);
            if ((viewVisibility != 0 || this.mNewSurfaceNeeded) && this.mAttachInfo.mHardwareRenderer != null) {
                this.mAttachInfo.mHardwareRenderer.destroy(false);
            }
            if (viewVisibility == 8) {
                this.mHasHadWindowFocus = false;
            }
        }
        boolean insetsChanged = false;
        if (this.mLayoutRequested) {
            ViewRoot.getRunQueue().executeActions(attachInfo.mHandler);
            Resources res = this.mView.getContext().getResources();
            if (this.mFirst) {
                host.fitSystemWindows(this.mAttachInfo.mContentInsets);
                this.mAttachInfo.mInTouchMode = !this.mAddedTouchMode;
                this.ensureTouchModeLocally(this.mAddedTouchMode);
            } else {
                if (!this.mAttachInfo.mContentInsets.equals(this.mPendingContentInsets)) {
                    if (this.mWidth > 0 && this.mHeight > 0 && this.mSurface != null && this.mSurface.isValid() && !this.mAttachInfo.mTurnOffWindowResizeAnim && this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled() && lp != null && !PixelFormat.formatHasAlpha(lp.format)) {
                        this.disposeResizeBitmap();
                        boolean completed = false;
                        try {
                            Object var23_29;
                            try {
                                int yoff;
                                boolean scrolling;
                                this.mResizeBitmap = Bitmap.createBitmap(this.mWidth, this.mHeight, Bitmap.Config.ARGB_8888);
                                this.mResizeBitmap.setHasAlpha(false);
                                Canvas canvas = new Canvas(this.mResizeBitmap);
                                canvas.drawColor(-16777216, PorterDuff.Mode.SRC);
                                boolean bl = scrolling = this.mScroller != null && this.mScroller.computeScrollOffset();
                                if (scrolling) {
                                    yoff = this.mScroller.getCurrY();
                                    this.mScroller.abortAnimation();
                                } else {
                                    yoff = this.mScrollY;
                                }
                                canvas.translate(0.0f, -yoff);
                                if (this.mTranslator != null) {
                                    this.mTranslator.translateCanvas(canvas);
                                }
                                canvas.setScreenDensity(this.mAttachInfo.mScalingRequired ? DisplayMetrics.DENSITY_DEVICE : 0);
                                this.mView.draw(canvas);
                                this.mResizeBitmapStartTime = SystemClock.uptimeMillis();
                                this.mResizeBitmapDuration = this.mView.getResources().getInteger(0x10E0001);
                                completed = true;
                            }
                            catch (OutOfMemoryError e) {
                                Log.w(TAG, "Not enough memory for content change anim buffer", e);
                                var23_29 = null;
                                if (!completed) {
                                    this.mResizeBitmap = null;
                                }
                            }
                            var23_29 = null;
                            if (!completed) {
                                this.mResizeBitmap = null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var23_30 = null;
                            if (!completed) {
                                this.mResizeBitmap = null;
                            }
                            throw throwable;
                        }
                    }
                    this.mAttachInfo.mContentInsets.set(this.mPendingContentInsets);
                    host.fitSystemWindows(this.mAttachInfo.mContentInsets);
                    insetsChanged = true;
                }
                if (!this.mAttachInfo.mVisibleInsets.equals(this.mPendingVisibleInsets)) {
                    this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                }
                if (lp.width == -2 || lp.height == -2) {
                    windowSizeMayChange = true;
                    DisplayMetrics packageMetrics = res.getDisplayMetrics();
                    desiredWindowWidth = packageMetrics.widthPixels;
                    desiredWindowHeight = packageMetrics.heightPixels;
                }
            }
            boolean goodMeasure = false;
            if (lp.width == -2 || lp.height == -2) {
                DisplayMetrics packageMetrics = res.getDisplayMetrics();
                res.getValue(17104903, this.mTmpValue, true);
                int baseSize = 0;
                if (this.mTmpValue.type == 5) {
                    baseSize = (int)this.mTmpValue.getDimension(packageMetrics);
                }
                if (baseSize != 0 && desiredWindowWidth > baseSize) {
                    childWidthMeasureSpec = this.getRootMeasureSpec(baseSize, lp.width);
                    childHeightMeasureSpec = this.getRootMeasureSpec(desiredWindowHeight, lp.height);
                    host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                        goodMeasure = true;
                    } else {
                        baseSize = (baseSize + desiredWindowWidth) / 2;
                        childWidthMeasureSpec = this.getRootMeasureSpec(baseSize, lp.width);
                        host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                        if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                            goodMeasure = true;
                        }
                    }
                }
            }
            if (!goodMeasure) {
                childWidthMeasureSpec = this.getRootMeasureSpec(desiredWindowWidth, lp.width);
                childHeightMeasureSpec = this.getRootMeasureSpec(desiredWindowHeight, lp.height);
                host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                if (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight()) {
                    windowSizeMayChange = true;
                }
            }
        }
        if (attachInfo.mRecomputeGlobalAttributes && host.mAttachInfo != null) {
            attachInfo.mRecomputeGlobalAttributes = false;
            boolean oldScreenOn = attachInfo.mKeepScreenOn;
            int oldVis = attachInfo.mSystemUiVisibility;
            attachInfo.mKeepScreenOn = false;
            attachInfo.mSystemUiVisibility = 0;
            attachInfo.mHasSystemUiListeners = false;
            host.dispatchCollectViewAttributes(0);
            if (attachInfo.mKeepScreenOn != oldScreenOn || attachInfo.mSystemUiVisibility != oldVis || attachInfo.mHasSystemUiListeners) {
                params = lp;
            }
        }
        if (this.mFirst || attachInfo.mViewVisibilityChanged) {
            attachInfo.mViewVisibilityChanged = false;
            int resizeMode = this.mSoftInputMode & 0xF0;
            if (resizeMode == 0) {
                int N = attachInfo.mScrollContainers.size();
                for (int i = 0; i < N; ++i) {
                    if (!attachInfo.mScrollContainers.get(i).isShown()) continue;
                    resizeMode = 16;
                }
                if (resizeMode == 0) {
                    resizeMode = 32;
                }
                if ((lp.softInputMode & 0xF0) != resizeMode) {
                    lp.softInputMode = lp.softInputMode & 0xFFFFFF0F | resizeMode;
                    params = lp;
                }
            }
        }
        if (params != null && (host.mPrivateFlags & 0x200) != 0 && !PixelFormat.formatHasAlpha(params.format)) {
            params.format = -3;
        }
        boolean windowShouldResize = this.mLayoutRequested && windowSizeMayChange && (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || lp.width == -2 && frame.width() < desiredWindowWidth && frame.width() != this.mWidth || lp.height == -2 && frame.height() < desiredWindowHeight && frame.height() != this.mHeight);
        boolean computesInternalInsets = attachInfo.mTreeObserver.hasComputeInternalInsetsListeners();
        boolean insetsPending = false;
        int relayoutResult = 0;
        if (this.mFirst || windowShouldResize || insetsChanged || viewVisibilityChanged || params != null) {
            boolean focusChangedDueToTouchMode;
            if (viewVisibility == 0) {
                boolean bl = insetsPending = computesInternalInsets && (this.mFirst || viewVisibilityChanged);
            }
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.mSurfaceLock.lock();
                this.mDrawingAllowed = true;
            }
            boolean hwInitialized = false;
            boolean contentInsetsChanged = false;
            boolean hadSurface = this.mSurface.isValid();
            try {
                boolean visibleInsetsChanged;
                int fl = 0;
                if (params != null) {
                    fl = params.flags;
                    if (attachInfo.mKeepScreenOn) {
                        params.flags |= 0x80;
                    }
                    params.subtreeSystemUiVisibility = attachInfo.mSystemUiVisibility;
                    params.hasSystemUiListeners = attachInfo.mHasSystemUiListeners || params.subtreeSystemUiVisibility != 0 || params.systemUiVisibility != 0;
                }
                int surfaceGenerationId = this.mSurface.getGenerationId();
                relayoutResult = this.relayoutWindow(params, viewVisibility, insetsPending);
                if (params != null) {
                    params.flags = fl;
                }
                if (this.mPendingConfiguration.seq != 0) {
                    this.updateConfiguration(this.mPendingConfiguration, !this.mFirst);
                    this.mPendingConfiguration.seq = 0;
                }
                contentInsetsChanged = !this.mPendingContentInsets.equals(this.mAttachInfo.mContentInsets);
                boolean bl = visibleInsetsChanged = !this.mPendingVisibleInsets.equals(this.mAttachInfo.mVisibleInsets);
                if (contentInsetsChanged) {
                    this.mAttachInfo.mContentInsets.set(this.mPendingContentInsets);
                    host.fitSystemWindows(this.mAttachInfo.mContentInsets);
                }
                if (visibleInsetsChanged) {
                    this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                }
                if (!hadSurface) {
                    if (this.mSurface.isValid()) {
                        newSurface = true;
                        fullRedrawNeeded = true;
                        this.mPreviousTransparentRegion.setEmpty();
                        if (this.mAttachInfo.mHardwareRenderer != null) {
                            hwInitialized = this.mAttachInfo.mHardwareRenderer.initialize(this.mHolder);
                        }
                    }
                } else if (!this.mSurface.isValid()) {
                    this.mLastScrolledFocus = null;
                    this.mCurScrollY = 0;
                    this.mScrollY = 0;
                    if (this.mScroller != null) {
                        this.mScroller.abortAnimation();
                    }
                    this.disposeResizeBitmap();
                } else if (surfaceGenerationId != this.mSurface.getGenerationId() && this.mSurfaceHolder == null && this.mAttachInfo.mHardwareRenderer != null) {
                    fullRedrawNeeded = true;
                    this.mAttachInfo.mHardwareRenderer.updateSurface(this.mHolder);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            attachInfo.mWindowLeft = frame.left;
            attachInfo.mWindowTop = frame.top;
            this.mWidth = frame.width();
            this.mHeight = frame.height();
            if (this.mSurfaceHolder != null) {
                if (this.mSurface.isValid()) {
                    this.mSurfaceHolder.mSurface = this.mSurface;
                }
                this.mSurfaceHolder.setSurfaceFrameSize(this.mWidth, this.mHeight);
                this.mSurfaceHolder.mSurfaceLock.unlock();
                if (this.mSurface.isValid()) {
                    if (!hadSurface) {
                        this.mSurfaceHolder.ungetCallbacks();
                        this.mIsCreating = true;
                        this.mSurfaceHolderCallback.surfaceCreated(this.mSurfaceHolder);
                        SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        surfaceChanged = true;
                    }
                    if (surfaceChanged) {
                        this.mSurfaceHolderCallback.surfaceChanged(this.mSurfaceHolder, lp.format, this.mWidth, this.mHeight);
                        SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, lp.format, this.mWidth, this.mHeight);
                            }
                        }
                    }
                    this.mIsCreating = false;
                } else if (hadSurface) {
                    this.mSurfaceHolder.ungetCallbacks();
                    SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                    this.mSurfaceHolderCallback.surfaceDestroyed(this.mSurfaceHolder);
                    if (callbacks != null) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceDestroyed(this.mSurfaceHolder);
                        }
                    }
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    this.mSurfaceHolder.mSurface = new Surface();
                    this.mSurfaceHolder.mSurfaceLock.unlock();
                }
            }
            if (hwInitialized || (windowShouldResize || params != null) && this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                this.mAttachInfo.mHardwareRenderer.setup(this.mWidth, this.mHeight);
            }
            if ((focusChangedDueToTouchMode = this.ensureTouchModeLocally((relayoutResult & 1) != 0)) || this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || contentInsetsChanged) {
                childWidthMeasureSpec = this.getRootMeasureSpec(this.mWidth, lp.width);
                childHeightMeasureSpec = this.getRootMeasureSpec(this.mHeight, lp.height);
                host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                int width = host.getMeasuredWidth();
                int height = host.getMeasuredHeight();
                boolean measureAgain = false;
                if (lp.horizontalWeight > 0.0f) {
                    width += (int)((float)(this.mWidth - width) * lp.horizontalWeight);
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
                    measureAgain = true;
                }
                if (lp.verticalWeight > 0.0f) {
                    height += (int)((float)(this.mHeight - height) * lp.verticalWeight);
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
                    measureAgain = true;
                }
                if (measureAgain) {
                    host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
                this.mLayoutRequested = true;
            }
        }
        boolean bl = triggerGlobalLayoutListener = (didLayout = this.mLayoutRequested) || attachInfo.mRecomputeGlobalAttributes;
        if (didLayout) {
            this.mLayoutRequested = false;
            this.mScrollMayChange = true;
            long startTime = 0L;
            host.layout(0, 0, host.getMeasuredWidth(), host.getMeasuredHeight());
            if ((host.mPrivateFlags & 0x200) != 0) {
                host.getLocationInWindow(this.mTmpLocation);
                this.mTransparentRegion.set(this.mTmpLocation[0], this.mTmpLocation[1], this.mTmpLocation[0] + host.mRight - host.mLeft, this.mTmpLocation[1] + host.mBottom - host.mTop);
                host.gatherTransparentRegion(this.mTransparentRegion);
                if (this.mTranslator != null) {
                    this.mTranslator.translateRegionInWindowToScreen(this.mTransparentRegion);
                }
                if (!this.mTransparentRegion.equals(this.mPreviousTransparentRegion)) {
                    this.mPreviousTransparentRegion.set(this.mTransparentRegion);
                    try {
                        sWindowSession.setTransparentRegion(this.mWindow, this.mTransparentRegion);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (triggerGlobalLayoutListener) {
            attachInfo.mRecomputeGlobalAttributes = false;
            attachInfo.mTreeObserver.dispatchOnGlobalLayout();
        }
        if (computesInternalInsets) {
            ViewTreeObserver.InternalInsetsInfo insets = attachInfo.mGivenInternalInsets;
            insets.reset();
            attachInfo.mTreeObserver.dispatchOnComputeInternalInsets(insets);
            if (insetsPending || !this.mLastGivenInsets.equals(insets)) {
                Region touchableRegion;
                Rect visibleInsets;
                Rect contentInsets;
                this.mLastGivenInsets.set(insets);
                if (this.mTranslator != null) {
                    contentInsets = this.mTranslator.getTranslatedContentInsets(insets.contentInsets);
                    visibleInsets = this.mTranslator.getTranslatedVisibleInsets(insets.visibleInsets);
                    touchableRegion = this.mTranslator.getTranslatedTouchableArea(insets.touchableRegion);
                } else {
                    contentInsets = insets.contentInsets;
                    visibleInsets = insets.visibleInsets;
                    touchableRegion = insets.touchableRegion;
                }
                try {
                    sWindowSession.setInsets(this.mWindow, insets.mTouchableInsets, contentInsets, visibleInsets, touchableRegion);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        if (this.mFirst && this.mView != null) {
            if (!this.mView.hasFocus()) {
                this.mView.requestFocus(2);
                this.mFocusedView = this.mRealFocusedView = this.mView.findFocus();
            } else {
                this.mRealFocusedView = this.mView.findFocus();
            }
        }
        this.mFirst = false;
        this.mWillDrawSoon = false;
        this.mNewSurfaceNeeded = false;
        this.mViewVisibility = viewVisibility;
        if (this.mAttachInfo.mHasWindowFocus && (imTarget = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags)) != this.mLastWasImTarget) {
            this.mLastWasImTarget = imTarget;
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null && imTarget) {
                imm.startGettingWindowFocus(this.mView);
                imm.onWindowFocus(this.mView, this.mView.findFocus(), this.mWindowAttributes.softInputMode, !this.mHasHadWindowFocus, this.mWindowAttributes.flags);
            }
        }
        if (!(cancelDraw = attachInfo.mTreeObserver.dispatchOnPreDraw()) && !newSurface) {
            this.mFullRedrawNeeded = false;
            this.draw(fullRedrawNeeded);
            if ((relayoutResult & 2) != 0 || this.mReportNextDraw) {
                this.mReportNextDraw = false;
                if (this.mSurfaceHolder != null && this.mSurface.isValid()) {
                    this.mSurfaceHolderCallback.surfaceRedrawNeeded(this.mSurfaceHolder);
                    SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                    if (callbacks != null) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            if (!(c instanceof SurfaceHolder.Callback2)) continue;
                            ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                        }
                    }
                }
                try {
                    sWindowSession.finishDrawing(this.mWindow);
                }
                catch (RemoteException e) {}
            }
        } else {
            if ((relayoutResult & 2) != 0) {
                this.mReportNextDraw = true;
            }
            if (fullRedrawNeeded) {
                this.mFullRedrawNeeded = true;
            }
            this.scheduleTraversals();
        }
    }

    public void requestTransparentRegion(View child) {
        this.checkThread();
        if (this.mView == child) {
            this.mView.mPrivateFlags |= 0x200;
            this.mWindowAttributesChanged = true;
            this.requestLayout();
        }
    }

    public int getRootMeasureSpec(int windowSize, int rootDimension) {
        int measureSpec;
        switch (rootDimension) {
            case -1: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, 0x40000000);
                break;
            }
            case -2: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, Integer.MIN_VALUE);
                break;
            }
            default: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(rootDimension, 0x40000000);
            }
        }
        return measureSpec;
    }

    public void onHardwarePreDraw(Canvas canvas) {
        canvas.translate(0.0f, -this.mHardwareYOffset);
    }

    public void onHardwarePostDraw(Canvas canvas) {
        if (this.mResizeBitmap != null) {
            canvas.translate(0.0f, this.mHardwareYOffset);
            this.mResizePaint.setAlpha(this.mResizeAlpha);
            canvas.drawBitmap(this.mResizeBitmap, 0.0f, 0.0f, this.mResizePaint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(boolean fullRedrawNeeded) {
        boolean animating;
        int yoff;
        Surface surface = this.mSurface;
        if (surface == null || !surface.isValid()) {
            return;
        }
        if (!sFirstDrawComplete) {
            ArrayList<Runnable> arrayList = sFirstDrawHandlers;
            synchronized (arrayList) {
                sFirstDrawComplete = true;
                int count = sFirstDrawHandlers.size();
                for (int i = 0; i < count; ++i) {
                    this.post(sFirstDrawHandlers.get(i));
                }
            }
        }
        this.scrollToRectOrFocus(null, false);
        if (this.mAttachInfo.mViewScrollChanged) {
            this.mAttachInfo.mViewScrollChanged = false;
            this.mAttachInfo.mTreeObserver.dispatchOnScrollChanged();
        }
        if (this.mCurScrollY != (yoff = (animating = this.mScroller != null && this.mScroller.computeScrollOffset()) ? this.mScroller.getCurrY() : this.mScrollY)) {
            this.mCurScrollY = yoff;
            fullRedrawNeeded = true;
        }
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean scalingRequired = this.mAttachInfo.mScalingRequired;
        int resizeAlpha = 0;
        if (this.mResizeBitmap != null) {
            long deltaTime = SystemClock.uptimeMillis() - this.mResizeBitmapStartTime;
            if (deltaTime < (long)this.mResizeBitmapDuration) {
                float amt = (float)deltaTime / (float)this.mResizeBitmapDuration;
                amt = mResizeInterpolator.getInterpolation(amt);
                animating = true;
                resizeAlpha = 255 - (int)(amt * 255.0f);
            } else {
                this.disposeResizeBitmap();
            }
        }
        Rect dirty = this.mDirty;
        if (this.mSurfaceHolder != null) {
            dirty.setEmpty();
            if (animating) {
                if (this.mScroller != null) {
                    this.mScroller.abortAnimation();
                }
                this.disposeResizeBitmap();
            }
            return;
        }
        if (fullRedrawNeeded) {
            this.mAttachInfo.mIgnoreDirtyState = true;
            dirty.union(0, 0, (int)((float)this.mWidth * appScale + 0.5f), (int)((float)this.mHeight * appScale + 0.5f));
        }
        if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
            if (!dirty.isEmpty() || this.mIsAnimating) {
                this.mIsAnimating = false;
                this.mHardwareYOffset = yoff;
                this.mResizeAlpha = resizeAlpha;
                this.mCurrentDirty.set(dirty);
                this.mCurrentDirty.union(this.mPreviousDirty);
                this.mPreviousDirty.set(dirty);
                dirty.setEmpty();
                Rect currentDirty = this.mCurrentDirty;
                if (animating) {
                    currentDirty = null;
                }
                this.mAttachInfo.mHardwareRenderer.draw(this.mView, this.mAttachInfo, this, currentDirty);
            }
            if (animating) {
                this.mFullRedrawNeeded = true;
                this.scheduleTraversals();
            }
            return;
        }
        if (!dirty.isEmpty() || this.mIsAnimating) {
            Canvas canvas;
            try {
                int left = dirty.left;
                int top = dirty.top;
                int right = dirty.right;
                int bottom = dirty.bottom;
                canvas = surface.lockCanvas(dirty);
                if (left != dirty.left || top != dirty.top || right != dirty.right || bottom != dirty.bottom) {
                    this.mAttachInfo.mIgnoreDirtyState = true;
                }
                canvas.setDensity(this.mDensity);
            }
            catch (Surface.OutOfResourcesException e) {
                Log.e(TAG, "OutOfResourcesException locking surface", e);
                this.mLayoutRequested = true;
                return;
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "IllegalArgumentException locking surface", e);
                this.mLayoutRequested = true;
                return;
            }
            try {
                if (!dirty.isEmpty() || this.mIsAnimating) {
                    long startTime = 0L;
                    if (!canvas.isOpaque() || yoff != 0) {
                        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    }
                    dirty.setEmpty();
                    this.mIsAnimating = false;
                    this.mAttachInfo.mDrawingTime = SystemClock.uptimeMillis();
                    this.mView.mPrivateFlags |= 0x20;
                    try {
                        canvas.translate(0.0f, -yoff);
                        if (this.mTranslator != null) {
                            this.mTranslator.translateCanvas(canvas);
                        }
                        canvas.setScreenDensity(scalingRequired ? DisplayMetrics.DENSITY_DEVICE : 0);
                        this.mView.draw(canvas);
                        Object var15_23 = null;
                        this.mAttachInfo.mIgnoreDirtyState = false;
                    }
                    catch (Throwable throwable) {
                        Object var15_24 = null;
                        this.mAttachInfo.mIgnoreDirtyState = false;
                        throw throwable;
                    }
                }
                Object var17_26 = null;
                surface.unlockCanvasAndPost(canvas);
            }
            catch (Throwable throwable) {
                Object var17_27 = null;
                surface.unlockCanvasAndPost(canvas);
                throw throwable;
            }
        }
        if (animating) {
            this.mFullRedrawNeeded = true;
            this.scheduleTraversals();
        }
    }

    public boolean scrollToRectOrFocus(Rect rectangle, boolean immediate) {
        View.AttachInfo attachInfo = this.mAttachInfo;
        Rect ci = attachInfo.mContentInsets;
        Rect vi = attachInfo.mVisibleInsets;
        int scrollY = 0;
        boolean handled = false;
        if (vi.left > ci.left || vi.top > ci.top || vi.right > ci.right || vi.bottom > ci.bottom) {
            scrollY = this.mScrollY;
            View focus = this.mRealFocusedView;
            if (focus == null || focus.mAttachInfo != this.mAttachInfo) {
                this.mRealFocusedView = null;
                return false;
            }
            if (focus != this.mLastScrolledFocus) {
                rectangle = null;
            }
            if ((focus != this.mLastScrolledFocus || this.mScrollMayChange || rectangle != null) && focus != null) {
                this.mLastScrolledFocus = focus;
                this.mScrollMayChange = false;
                if (focus.getGlobalVisibleRect(this.mVisRect, null)) {
                    if (rectangle == null) {
                        focus.getFocusedRect(this.mTempRect);
                        if (this.mView instanceof ViewGroup) {
                            ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(focus, this.mTempRect);
                        }
                    } else {
                        this.mTempRect.set(rectangle);
                    }
                    if (this.mTempRect.intersect(this.mVisRect)) {
                        if (this.mTempRect.height() <= this.mView.getHeight() - vi.top - vi.bottom) {
                            if (this.mTempRect.top - scrollY < vi.top) {
                                scrollY -= vi.top - (this.mTempRect.top - scrollY);
                            } else if (this.mTempRect.bottom - scrollY > this.mView.getHeight() - vi.bottom) {
                                scrollY += this.mTempRect.bottom - scrollY - (this.mView.getHeight() - vi.bottom);
                            }
                        }
                        handled = true;
                    }
                }
            }
        }
        if (scrollY != this.mScrollY) {
            if (!immediate && this.mResizeBitmap == null) {
                if (this.mScroller == null) {
                    this.mScroller = new Scroller(this.mView.getContext());
                }
                this.mScroller.startScroll(0, this.mScrollY, 0, scrollY - this.mScrollY);
            } else if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.mScrollY = scrollY;
        }
        return handled;
    }

    public void requestChildFocus(View child, View focused) {
        this.checkThread();
        if (this.mFocusedView != focused) {
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(this.mFocusedView, focused);
            this.scheduleTraversals();
        }
        this.mFocusedView = this.mRealFocusedView = focused;
    }

    public void clearChildFocus(View child) {
        this.checkThread();
        View oldFocus = this.mFocusedView;
        this.mRealFocusedView = null;
        this.mFocusedView = null;
        if (this.mView != null && !this.mView.hasFocus()) {
            if (!this.mView.requestFocus(2)) {
                this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(oldFocus, null);
            }
        } else if (oldFocus != null) {
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(oldFocus, null);
        }
    }

    public void focusableViewAvailable(View v) {
        this.checkThread();
        if (this.mView != null && !this.mView.hasFocus()) {
            v.requestFocus();
        } else {
            boolean descendantsHaveDibsOnFocus;
            this.mFocusedView = this.mView.findFocus();
            boolean bl = descendantsHaveDibsOnFocus = this.mFocusedView instanceof ViewGroup && ((ViewGroup)this.mFocusedView).getDescendantFocusability() == 262144;
            if (descendantsHaveDibsOnFocus && ViewRoot.isViewDescendantOf(v, this.mFocusedView)) {
                v.requestFocus();
            }
        }
    }

    public void recomputeViewAttributes(View child) {
        this.checkThread();
        if (this.mView == child) {
            this.mAttachInfo.mRecomputeGlobalAttributes = true;
            if (!this.mWillDrawSoon) {
                this.scheduleTraversals();
            }
        }
    }

    public void dispatchDetachedFromWindow() {
        if (this.mView != null && this.mView.mAttachInfo != null) {
            this.mView.dispatchDetachedFromWindow();
        }
        this.mView = null;
        this.mAttachInfo.mRootView = null;
        this.mAttachInfo.mSurface = null;
        this.destroyHardwareRenderer();
        this.mSurface.release();
        if (this.mInputChannel != null) {
            if (this.mInputQueueCallback != null) {
                this.mInputQueueCallback.onInputQueueDestroyed(this.mInputQueue);
                this.mInputQueueCallback = null;
            } else {
                InputQueue.unregisterInputChannel(this.mInputChannel);
            }
        }
        try {
            sWindowSession.remove(this.mWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mInputChannel != null) {
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(Configuration config, boolean force) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            for (int i = sConfigCallbacks.size() - 1; i >= 0; --i) {
                sConfigCallbacks.get(i).onConfigurationChanged(config);
            }
        }
        if (this.mView != null) {
            if (this.mView != null) {
                config = this.mView.getResources().getConfiguration();
            }
            if (force || this.mLastConfiguration.diff(config) != 0) {
                this.mLastConfiguration.setTo(config);
                this.mView.dispatchConfigurationChanged(config);
            }
        }
    }

    public static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && ViewRoot.isViewDescendantOf((View)((Object)theParent), parent);
    }

    public static void forceLayout(View view) {
        view.forceLayout();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewRoot.forceLayout(group.getChildAt(i));
            }
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                ((View)msg.obj).invalidate();
                break;
            }
            case 2: {
                View.AttachInfo.InvalidateInfo info = (View.AttachInfo.InvalidateInfo)msg.obj;
                info.target.invalidate(info.left, info.top, info.right, info.bottom);
                info.release();
                break;
            }
            case 1000: {
                if (this.mProfile) {
                    Debug.startMethodTracing(TAG);
                }
                this.performTraversals();
                if (!this.mProfile) break;
                Debug.stopMethodTracing();
                this.mProfile = false;
                break;
            }
            case 1010: {
                this.handleFinishedEvent(msg.arg1, msg.arg2 != 0);
                break;
            }
            case 1005: {
                this.deliverKeyEvent((KeyEvent)msg.obj, msg.arg1 != 0);
                break;
            }
            case 1006: {
                this.deliverPointerEvent((MotionEvent)msg.obj, msg.arg1 != 0);
                break;
            }
            case 1007: {
                this.deliverTrackballEvent((MotionEvent)msg.obj, msg.arg1 != 0);
                break;
            }
            case 1008: {
                this.handleAppVisibility(msg.arg1 != 0);
                break;
            }
            case 1009: {
                this.handleGetNewSurface();
                break;
            }
            case 1002: {
                ResizedInfo ri = (ResizedInfo)msg.obj;
                if (this.mWinFrame.width() == msg.arg1 && this.mWinFrame.height() == msg.arg2 && this.mPendingContentInsets.equals(ri.coveredInsets) && this.mPendingVisibleInsets.equals(ri.visibleInsets) && ((ResizedInfo)msg.obj).newConfig == null) break;
            }
            case 1003: {
                if (!this.mAdded) break;
                Configuration config = ((ResizedInfo)msg.obj).newConfig;
                if (config != null) {
                    this.updateConfiguration(config, false);
                }
                this.mWinFrame.left = 0;
                this.mWinFrame.right = msg.arg1;
                this.mWinFrame.top = 0;
                this.mWinFrame.bottom = msg.arg2;
                this.mPendingContentInsets.set(((ResizedInfo)msg.obj).coveredInsets);
                this.mPendingVisibleInsets.set(((ResizedInfo)msg.obj).visibleInsets);
                if (msg.what == 1003) {
                    this.mReportNextDraw = true;
                }
                if (this.mView != null) {
                    ViewRoot.forceLayout(this.mView);
                }
                this.requestLayout();
                break;
            }
            case 1004: {
                boolean hasWindowFocus;
                if (!this.mAdded) break;
                this.mAttachInfo.mHasWindowFocus = hasWindowFocus = msg.arg1 != 0;
                if (hasWindowFocus) {
                    boolean inTouchMode = msg.arg2 != 0;
                    this.ensureTouchModeLocally(inTouchMode);
                    if (this.mAttachInfo.mHardwareRenderer != null && this.mSurface != null && this.mSurface.isValid()) {
                        this.mFullRedrawNeeded = true;
                        this.mAttachInfo.mHardwareRenderer.initializeIfNeeded(this.mWidth, this.mHeight, this.mAttachInfo, this.mHolder);
                    }
                }
                this.mLastWasImTarget = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags);
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (this.mView != null) {
                    if (hasWindowFocus && imm != null && this.mLastWasImTarget) {
                        imm.startGettingWindowFocus(this.mView);
                    }
                    this.mAttachInfo.mKeyDispatchState.reset();
                    this.mView.dispatchWindowFocusChanged(hasWindowFocus);
                }
                if (hasWindowFocus) {
                    if (imm != null && this.mLastWasImTarget) {
                        imm.onWindowFocus(this.mView, this.mView.findFocus(), this.mWindowAttributes.softInputMode, !this.mHasHadWindowFocus, this.mWindowAttributes.flags);
                    }
                    this.mWindowAttributes.softInputMode &= 0xFFFFFEFF;
                    ((WindowManager.LayoutParams)this.mView.getLayoutParams()).softInputMode &= 0xFFFFFEFF;
                    this.mHasHadWindowFocus = true;
                }
                if (!hasWindowFocus || this.mView == null) break;
                this.sendAccessibilityEvents();
                break;
            }
            case 1001: {
                this.doDie();
                break;
            }
            case 1011: {
                KeyEvent event = (KeyEvent)msg.obj;
                if ((event.getFlags() & 8) != 0) {
                    event = KeyEvent.changeFlags(event, event.getFlags() & 0xFFFFFFF7);
                }
                this.deliverKeyEventPostIme((KeyEvent)msg.obj, false);
                break;
            }
            case 1012: {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm == null) break;
                imm.reportFinishInputConnection((InputConnection)msg.obj);
                break;
            }
            case 1013: {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm == null) break;
                imm.checkFocus();
                break;
            }
            case 1014: {
                if (this.mView == null) break;
                this.mView.onCloseSystemDialogs((String)msg.obj);
                break;
            }
            case 1015: 
            case 1016: {
                DragEvent event = (DragEvent)msg.obj;
                event.mLocalState = this.mLocalDragState;
                this.handleDragEvent(event);
                break;
            }
            case 1017: {
                this.handleDispatchSystemUiVisibilityChanged(msg.arg1);
            }
        }
    }

    public void startInputEvent(InputQueue.FinishedCallback finishedCallback) {
        if (this.mFinishedCallback != null) {
            Slog.w(TAG, "Received a new input event from the input queue but there is already an unfinished input event in progress.");
        }
        this.mFinishedCallback = finishedCallback;
    }

    public void finishInputEvent(boolean handled) {
        if (this.mFinishedCallback != null) {
            this.mFinishedCallback.finished(handled);
            this.mFinishedCallback = null;
        } else {
            Slog.w(TAG, "Attempted to tell the input queue that the current input event is finished but there is no input event actually in progress.");
        }
    }

    public boolean ensureTouchMode(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        try {
            sWindowSession.setInTouchMode(inTouchMode);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return this.ensureTouchModeLocally(inTouchMode);
    }

    public boolean ensureTouchModeLocally(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        this.mAttachInfo.mInTouchMode = inTouchMode;
        this.mAttachInfo.mTreeObserver.dispatchOnTouchModeChanged(inTouchMode);
        return inTouchMode ? this.enterTouchMode() : this.leaveTouchMode();
    }

    public boolean enterTouchMode() {
        View focused;
        if (this.mView != null && this.mView.hasFocus() && (focused = this.mView.findFocus()) != null && !focused.isFocusableInTouchMode()) {
            ViewGroup ancestorToTakeFocus = this.findAncestorToTakeFocusInTouchMode(focused);
            if (ancestorToTakeFocus != null) {
                return ancestorToTakeFocus.requestFocus();
            }
            this.mView.unFocus();
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(focused, null);
            this.mFocusedView = null;
            return true;
        }
        return false;
    }

    public ViewGroup findAncestorToTakeFocusInTouchMode(View focused) {
        ViewParent parent = focused.getParent();
        while (parent instanceof ViewGroup) {
            ViewGroup vgParent = (ViewGroup)parent;
            if (vgParent.getDescendantFocusability() == 262144 && vgParent.isFocusableInTouchMode()) {
                return vgParent;
            }
            if (vgParent.isRootNamespace()) {
                return null;
            }
            parent = vgParent.getParent();
        }
        return null;
    }

    public boolean leaveTouchMode() {
        if (this.mView != null) {
            View focused;
            if (this.mView.hasFocus()) {
                this.mFocusedView = this.mView.findFocus();
                if (!(this.mFocusedView instanceof ViewGroup)) {
                    return false;
                }
                if (((ViewGroup)this.mFocusedView).getDescendantFocusability() != 262144) {
                    return false;
                }
            }
            if ((focused = this.focusSearch(null, 130)) != null) {
                return focused.requestFocus(130);
            }
        }
        return false;
    }

    public void deliverPointerEvent(MotionEvent event, boolean sendDone) {
        boolean isDown;
        if (this.mView == null || !this.mAdded) {
            this.finishPointerEvent(event, sendDone, false);
            return;
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateEventInScreenToAppWindow(event);
        }
        boolean bl = isDown = event.getAction() == 0;
        if (isDown) {
            this.ensureTouchMode(true);
        }
        if (this.mCurScrollY != 0) {
            event.offsetLocation(0.0f, this.mCurScrollY);
        }
        this.mLastTouchPoint.x = event.getRawX();
        this.mLastTouchPoint.y = event.getRawY();
        boolean handled = this.mView.dispatchTouchEvent(event);
        if (handled) {
            this.finishPointerEvent(event, sendDone, true);
            return;
        }
        int edgeFlags = event.getEdgeFlags();
        if (edgeFlags != 0 && this.mView instanceof ViewGroup) {
            int edgeSlop = this.mViewConfiguration.getScaledEdgeSlop();
            int direction = 33;
            int x = (int)event.getX();
            int y = (int)event.getY();
            int[] deltas = new int[2];
            if ((edgeFlags & 1) != 0) {
                direction = 130;
                if ((edgeFlags & 4) != 0) {
                    deltas[0] = edgeSlop;
                    x += edgeSlop;
                } else if ((edgeFlags & 8) != 0) {
                    deltas[0] = -edgeSlop;
                    x -= edgeSlop;
                }
            } else if ((edgeFlags & 2) != 0) {
                direction = 33;
                if ((edgeFlags & 4) != 0) {
                    deltas[0] = edgeSlop;
                    x += edgeSlop;
                } else if ((edgeFlags & 8) != 0) {
                    deltas[0] = -edgeSlop;
                    x -= edgeSlop;
                }
            } else if ((edgeFlags & 4) != 0) {
                direction = 66;
            } else if ((edgeFlags & 8) != 0) {
                direction = 17;
            }
            View nearest = FocusFinder.getInstance().findNearestTouchable((ViewGroup)this.mView, x, y, direction, deltas);
            if (nearest != null) {
                event.offsetLocation(deltas[0], deltas[1]);
                event.setEdgeFlags(0);
                if (this.mView.dispatchTouchEvent(event)) {
                    this.finishPointerEvent(event, sendDone, true);
                    return;
                }
            }
        }
        this.finishPointerEvent(event, sendDone, false);
    }

    public void finishPointerEvent(MotionEvent event, boolean sendDone, boolean handled) {
        event.recycle();
        if (sendDone) {
            this.finishInputEvent(handled);
        }
    }

    public void deliverTrackballEvent(MotionEvent event, boolean sendDone) {
        if (this.mView == null || !this.mAdded) {
            this.finishTrackballEvent(event, sendDone, false);
            return;
        }
        if (this.mView.dispatchTrackballEvent(event)) {
            this.ensureTouchMode(false);
            this.finishTrackballEvent(event, sendDone, true);
            this.mLastTrackballTime = Integer.MIN_VALUE;
            return;
        }
        TrackballAxis x = this.mTrackballAxisX;
        TrackballAxis y = this.mTrackballAxisY;
        long curTime = SystemClock.uptimeMillis();
        if (this.mLastTrackballTime + 250L < curTime) {
            x.reset(0);
            y.reset(0);
            this.mLastTrackballTime = curTime;
        }
        int action = event.getAction();
        int metaState = event.getMetaState();
        switch (action) {
            case 0: {
                x.reset(2);
                y.reset(2);
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 0, 23, 0, metaState, -1, 0, 1024, 257), false);
                break;
            }
            case 1: {
                x.reset(2);
                y.reset(2);
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 1, 23, 0, metaState, -1, 0, 1024, 257), false);
            }
        }
        float xOff = x.collect(event.getX(), event.getEventTime(), "X");
        float yOff = y.collect(event.getY(), event.getEventTime(), "Y");
        int keycode = 0;
        int movement = 0;
        float accel = 1.0f;
        if (xOff > yOff) {
            movement = x.generate(2.0f / event.getXPrecision());
            if (movement != 0) {
                keycode = movement > 0 ? 22 : 21;
                accel = x.acceleration;
                y.reset(2);
            }
        } else if (yOff > 0.0f && (movement = y.generate(2.0f / event.getYPrecision())) != 0) {
            keycode = movement > 0 ? 20 : 19;
            accel = y.acceleration;
            x.reset(2);
        }
        if (keycode != 0) {
            int accelMovement;
            if (movement < 0) {
                movement = -movement;
            }
            if ((accelMovement = (int)((float)movement * accel)) > movement) {
                int repeatCount = accelMovement - --movement;
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 2, keycode, repeatCount, metaState, -1, 0, 1024, 257), false);
            }
            while (movement > 0) {
                --movement;
                curTime = SystemClock.uptimeMillis();
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 0, keycode, 0, metaState, -1, 0, 1024, 257), false);
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 1, keycode, 0, metaState, -1, 0, 1024, 257), false);
            }
            this.mLastTrackballTime = curTime;
        }
        this.finishTrackballEvent(event, sendDone, true);
    }

    public void finishTrackballEvent(MotionEvent event, boolean sendDone, boolean handled) {
        event.recycle();
        if (sendDone) {
            this.finishInputEvent(handled);
        }
    }

    public static boolean isNavigationKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTypingKey(KeyEvent keyEvent) {
        return keyEvent.getUnicodeChar() > 0;
    }

    public boolean checkForLeavingTouchModeAndConsume(KeyEvent event) {
        if (!this.mAttachInfo.mInTouchMode) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 2) {
            return false;
        }
        if ((event.getFlags() & 4) != 0) {
            return false;
        }
        if (ViewRoot.isNavigationKey(event)) {
            return this.ensureTouchMode(false);
        }
        if (ViewRoot.isTypingKey(event)) {
            this.ensureTouchMode(false);
            return false;
        }
        return false;
    }

    public static void captureMotionLog(String subTag, MotionEvent ev) {
        if (ev == null || SystemProperties.getInt("debug.captureevent", 0) == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(subTag + ": ");
        sb.append(ev.getDownTime()).append(',');
        sb.append(ev.getEventTime()).append(',');
        sb.append(ev.getAction()).append(',');
        sb.append(ev.getX()).append(',');
        sb.append(ev.getY()).append(',');
        sb.append(ev.getPressure()).append(',');
        sb.append(ev.getSize()).append(',');
        sb.append(ev.getMetaState()).append(',');
        sb.append(ev.getXPrecision()).append(',');
        sb.append(ev.getYPrecision()).append(',');
        sb.append(ev.getDeviceId()).append(',');
        sb.append(ev.getEdgeFlags());
        Log.d(TAG, sb.toString());
    }

    public static void captureKeyLog(String subTag, KeyEvent ev) {
        if (ev == null || SystemProperties.getInt("debug.captureevent", 0) == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(subTag + ": ");
        sb.append(ev.getDownTime()).append(',');
        sb.append(ev.getEventTime()).append(',');
        sb.append(ev.getAction()).append(',');
        sb.append(ev.getKeyCode()).append(',');
        sb.append(ev.getRepeatCount()).append(',');
        sb.append(ev.getMetaState()).append(',');
        sb.append(ev.getDeviceId()).append(',');
        sb.append(ev.getScanCode());
        Log.d(TAG, sb.toString());
    }

    public int enqueuePendingEvent(Object event, boolean sendDone) {
        int seq = this.mPendingEventSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mPendingEventSeq = seq;
        this.mPendingEvents.put(seq, event);
        return sendDone ? seq : -seq;
    }

    public Object retrievePendingEvent(int seq) {
        Object event;
        if (seq < 0) {
            seq = -seq;
        }
        if ((event = this.mPendingEvents.get(seq)) != null) {
            this.mPendingEvents.remove(seq);
        }
        return event;
    }

    public void deliverKeyEvent(KeyEvent event, boolean sendDone) {
        InputMethodManager imm;
        if (this.mView == null || !this.mAdded) {
            this.finishKeyEvent(event, sendDone, false);
            return;
        }
        if (this.mView.dispatchKeyEventPreIme(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (this.mLastWasImTarget && (imm = InputMethodManager.peekInstance()) != null) {
            int seq = this.enqueuePendingEvent(event, sendDone);
            imm.dispatchKeyEvent(this.mView.getContext(), seq, event, this.mInputMethodCallback);
            return;
        }
        this.deliverKeyEventPostIme(event, sendDone);
    }

    public void handleFinishedEvent(int seq, boolean handled) {
        KeyEvent event = (KeyEvent)this.retrievePendingEvent(seq);
        if (event != null) {
            boolean sendDone;
            boolean bl = sendDone = seq >= 0;
            if (handled) {
                this.finishKeyEvent(event, sendDone, true);
            } else {
                this.deliverKeyEventPostIme(event, sendDone);
            }
        }
    }

    public void deliverKeyEventPostIme(KeyEvent event, boolean sendDone) {
        if (this.mView == null || !this.mAdded) {
            this.finishKeyEvent(event, sendDone, false);
            return;
        }
        if (this.checkForLeavingTouchModeAndConsume(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        this.mFallbackEventHandler.preDispatchKeyEvent(event);
        if (this.mView.dispatchKeyEvent(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (event.getAction() == 1 && event.isCtrlPressed() && !KeyEvent.isModifierKey(event.getKeyCode()) && this.mView.dispatchKeyShortcutEvent(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (this.mFallbackEventHandler.dispatchKeyEvent(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (event.getAction() == 0) {
            int direction = 0;
            switch (event.getKeyCode()) {
                case 21: {
                    if (!event.hasNoModifiers()) break;
                    direction = 17;
                    break;
                }
                case 22: {
                    if (!event.hasNoModifiers()) break;
                    direction = 66;
                    break;
                }
                case 19: {
                    if (!event.hasNoModifiers()) break;
                    direction = 33;
                    break;
                }
                case 20: {
                    if (!event.hasNoModifiers()) break;
                    direction = 130;
                    break;
                }
                case 61: {
                    if (event.hasNoModifiers()) {
                        direction = 2;
                        break;
                    }
                    if (!event.hasModifiers(1)) break;
                    direction = 1;
                }
            }
            if (direction != 0) {
                View focused;
                View view = focused = this.mView != null ? this.mView.findFocus() : null;
                if (focused != null) {
                    View v = focused.focusSearch(direction);
                    if (v != null && v != focused) {
                        focused.getFocusedRect(this.mTempRect);
                        if (this.mView instanceof ViewGroup) {
                            ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(focused, this.mTempRect);
                            ((ViewGroup)this.mView).offsetRectIntoDescendantCoords(v, this.mTempRect);
                        }
                        if (v.requestFocus(direction, this.mTempRect)) {
                            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
                            this.finishKeyEvent(event, sendDone, true);
                            return;
                        }
                    }
                    if (this.mView.dispatchUnhandledMove(focused, direction)) {
                        this.finishKeyEvent(event, sendDone, true);
                        return;
                    }
                }
            }
        }
        this.finishKeyEvent(event, sendDone, false);
    }

    public void finishKeyEvent(KeyEvent event, boolean sendDone, boolean handled) {
        if (sendDone) {
            this.finishInputEvent(handled);
        }
    }

    public void setLocalDragState(Object obj) {
        this.mLocalDragState = obj;
    }

    public void handleDragEvent(DragEvent event) {
        if (this.mView != null && this.mAdded) {
            int what = event.mAction;
            if (what == 6) {
                this.mView.dispatchDragEvent(event);
            } else {
                if (what == 1) {
                    this.mCurrentDragView = null;
                    this.mDragDescription = event.mClipDescription;
                } else {
                    event.mClipDescription = this.mDragDescription;
                }
                if (what == 2 || what == 3) {
                    this.mDragPoint.set(event.mX, event.mY);
                    if (this.mTranslator != null) {
                        this.mTranslator.translatePointInScreenToAppWindow(this.mDragPoint);
                    }
                    if (this.mCurScrollY != 0) {
                        this.mDragPoint.offset(0.0f, this.mCurScrollY);
                    }
                    event.mX = this.mDragPoint.x;
                    event.mY = this.mDragPoint.y;
                }
                View prevDragView = this.mCurrentDragView;
                boolean result = this.mView.dispatchDragEvent(event);
                if (prevDragView != this.mCurrentDragView) {
                    try {
                        if (prevDragView != null) {
                            sWindowSession.dragRecipientExited(this.mWindow);
                        }
                        if (this.mCurrentDragView != null) {
                            sWindowSession.dragRecipientEntered(this.mWindow);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Unable to note drag target change");
                    }
                }
                if (what == 3) {
                    this.mDragDescription = null;
                    try {
                        Log.i(TAG, "Reporting drop result: " + result);
                        sWindowSession.reportDropResult(this.mWindow, result);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Unable to report drop result");
                    }
                }
                if (what == 4) {
                    this.setLocalDragState(null);
                }
            }
        }
        event.recycle();
    }

    public void handleDispatchSystemUiVisibilityChanged(int visibility) {
        if (this.mView == null) {
            return;
        }
        if (this.mAttachInfo != null) {
            this.mAttachInfo.mSystemUiVisibility = visibility;
        }
        this.mView.dispatchSystemUiVisibilityChanged(visibility);
    }

    public void getLastTouchPoint(Point outLocation) {
        outLocation.x = (int)this.mLastTouchPoint.x;
        outLocation.y = (int)this.mLastTouchPoint.y;
    }

    public void setDragFocus(View newDragTarget) {
        if (this.mCurrentDragView != newDragTarget) {
            this.mCurrentDragView = newDragTarget;
        }
    }

    public AudioManager getAudioManager() {
        if (this.mView == null) {
            throw new IllegalStateException("getAudioManager called when there is no mView");
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mView.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    public int relayoutWindow(WindowManager.LayoutParams params, int viewVisibility, boolean insetsPending) throws RemoteException {
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean restore = false;
        if (params != null && this.mTranslator != null) {
            restore = true;
            params.backup();
            this.mTranslator.translateWindowLayout(params);
        }
        if (params != null) {
            // empty if block
        }
        this.mPendingConfiguration.seq = 0;
        int relayoutResult = sWindowSession.relayout(this.mWindow, params, (int)((float)this.mView.getMeasuredWidth() * appScale + 0.5f), (int)((float)this.mView.getMeasuredHeight() * appScale + 0.5f), viewVisibility, insetsPending, this.mWinFrame, this.mPendingContentInsets, this.mPendingVisibleInsets, this.mPendingConfiguration, this.mSurface);
        if (restore) {
            params.restore();
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWinFrame(this.mWinFrame);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingContentInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingVisibleInsets);
        }
        return relayoutResult;
    }

    public void playSoundEffect(int effectId) {
        this.checkThread();
        try {
            AudioManager audioManager = this.getAudioManager();
            switch (effectId) {
                case 0: {
                    audioManager.playSoundEffect(0);
                    return;
                }
                case 4: {
                    audioManager.playSoundEffect(2);
                    return;
                }
                case 1: {
                    audioManager.playSoundEffect(3);
                    return;
                }
                case 3: {
                    audioManager.playSoundEffect(4);
                    return;
                }
                case 2: {
                    audioManager.playSoundEffect(1);
                    return;
                }
            }
            throw new IllegalArgumentException("unknown effect id " + effectId + " not defined in " + SoundEffectConstants.class.getCanonicalName());
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "FATAL EXCEPTION when attempting to play sound effect: " + e);
            e.printStackTrace();
            return;
        }
    }

    public boolean performHapticFeedback(int effectId, boolean always) {
        try {
            return sWindowSession.performHapticFeedback(this.mWindow, effectId, always);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public View focusSearch(View focused, int direction) {
        this.checkThread();
        if (!(this.mView instanceof ViewGroup)) {
            return null;
        }
        return FocusFinder.getInstance().findNextFocus((ViewGroup)this.mView, focused, direction);
    }

    public void debug() {
        this.mView.debug();
    }

    public void die(boolean immediate) {
        if (immediate) {
            this.doDie();
        } else {
            this.sendEmptyMessage(1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDie() {
        this.checkThread();
        ViewRoot viewRoot = this;
        synchronized (viewRoot) {
            if (this.mAdded && !this.mFirst) {
                boolean viewVisibilityChanged;
                this.destroyHardwareRenderer();
                int viewVisibility = this.mView.getVisibility();
                boolean bl = viewVisibilityChanged = this.mViewVisibility != viewVisibility;
                if (this.mWindowAttributesChanged || viewVisibilityChanged) {
                    try {
                        if ((this.relayoutWindow(this.mWindowAttributes, viewVisibility, false) & 2) != 0) {
                            sWindowSession.finishDrawing(this.mWindow);
                        }
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                this.mSurface.release();
            }
            if (this.mAdded) {
                this.mAdded = false;
                this.dispatchDetachedFromWindow();
            }
        }
    }

    public void destroyHardwareRenderer() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.destroy(true);
            this.mAttachInfo.mHardwareRenderer = null;
            this.mAttachInfo.mHardwareAccelerated = false;
        }
    }

    public void dispatchFinishedEvent(int seq, boolean handled) {
        Message msg = this.obtainMessage(1010);
        msg.arg1 = seq;
        msg.arg2 = handled ? 1 : 0;
        this.sendMessage(msg);
    }

    public void dispatchResized(int w, int h, Rect coveredInsets, Rect visibleInsets, boolean reportDraw, Configuration newConfig) {
        Message msg = this.obtainMessage(reportDraw ? 1003 : 1002);
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(coveredInsets);
            this.mTranslator.translateRectInScreenToAppWindow(visibleInsets);
            w = (int)((float)w * this.mTranslator.applicationInvertedScale);
            h = (int)((float)h * this.mTranslator.applicationInvertedScale);
        }
        msg.arg1 = w;
        msg.arg2 = h;
        ResizedInfo ri = new ResizedInfo();
        ri.coveredInsets = new Rect(coveredInsets);
        ri.visibleInsets = new Rect(visibleInsets);
        ri.newConfig = newConfig;
        msg.obj = ri;
        this.sendMessage(msg);
    }

    public void dispatchKey(KeyEvent event) {
        this.dispatchKey(event, false);
    }

    public void dispatchKey(KeyEvent event, boolean sendDone) {
        Message msg = this.obtainMessage(1005);
        msg.obj = event;
        msg.arg1 = sendDone ? 1 : 0;
        this.sendMessageAtTime(msg, event.getEventTime());
    }

    public void dispatchMotion(MotionEvent event) {
        this.dispatchMotion(event, false);
    }

    public void dispatchMotion(MotionEvent event, boolean sendDone) {
        int source = event.getSource();
        if ((source & 2) != 0) {
            this.dispatchPointer(event, sendDone);
        } else if ((source & 4) != 0) {
            this.dispatchTrackball(event, sendDone);
        } else {
            Log.v(TAG, "Dropping unsupported motion event (unimplemented): " + event);
            if (sendDone) {
                this.finishInputEvent(false);
            }
        }
    }

    public void dispatchPointer(MotionEvent event) {
        this.dispatchPointer(event, false);
    }

    public void dispatchPointer(MotionEvent event, boolean sendDone) {
        Message msg = this.obtainMessage(1006);
        msg.obj = event;
        msg.arg1 = sendDone ? 1 : 0;
        this.sendMessageAtTime(msg, event.getEventTime());
    }

    public void dispatchTrackball(MotionEvent event) {
        this.dispatchTrackball(event, false);
    }

    public void dispatchTrackball(MotionEvent event, boolean sendDone) {
        Message msg = this.obtainMessage(1007);
        msg.obj = event;
        msg.arg1 = sendDone ? 1 : 0;
        this.sendMessageAtTime(msg, event.getEventTime());
    }

    public void dispatchAppVisibility(boolean visible) {
        Message msg = this.obtainMessage(1008);
        msg.arg1 = visible ? 1 : 0;
        this.sendMessage(msg);
    }

    public void dispatchGetNewSurface() {
        Message msg = this.obtainMessage(1009);
        this.sendMessage(msg);
    }

    public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
        Message msg = Message.obtain();
        msg.what = 1004;
        msg.arg1 = hasFocus ? 1 : 0;
        msg.arg2 = inTouchMode ? 1 : 0;
        this.sendMessage(msg);
    }

    public void dispatchCloseSystemDialogs(String reason) {
        Message msg = Message.obtain();
        msg.what = 1014;
        msg.obj = reason;
        this.sendMessage(msg);
    }

    public void dispatchDragEvent(DragEvent event) {
        int what;
        if (event.getAction() == 2) {
            what = 1016;
            this.removeMessages(what);
        } else {
            what = 1015;
        }
        Message msg = this.obtainMessage(what, event);
        this.sendMessage(msg);
    }

    public void dispatchSystemUiVisibilityChanged(int visibility) {
        this.sendMessage(this.obtainMessage(1017, visibility, 0));
    }

    public void sendAccessibilityEvents() {
        if (!AccessibilityManager.getInstance(this.mView.getContext()).isEnabled()) {
            return;
        }
        this.mView.sendAccessibilityEvent(32);
        View focusedView = this.mView.findFocus();
        if (focusedView != null && focusedView != this.mView) {
            focusedView.sendAccessibilityEvent(8);
        }
    }

    public boolean showContextMenuForChild(View originalView) {
        return false;
    }

    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return null;
    }

    public void createContextMenu(ContextMenu menu2) {
    }

    public void childDrawableStateChanged(View child) {
    }

    public void checkThread() {
        if (this.mThread != Thread.currentThread()) {
            throw new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
        }
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        return this.scrollToRectOrFocus(rectangle, immediate);
    }

    public static RunQueue getRunQueue() {
        RunQueue rq = sRunQueues.get();
        if (rq != null) {
            return rq;
        }
        rq = new RunQueue();
        sRunQueues.set(rq);
        return rq;
    }

    public static void nativeShowFPS(Canvas canvas, int n) {
        OverrideMethod.invokeV("android.view.ViewRoot#nativeShowFPS(Landroid/graphics/Canvas;I)V", true, null);
    }

    static {
        mStaticInit = new Object();
        mInitialized = false;
        sRunQueues = new ThreadLocal();
        sFirstDrawHandlers = new ArrayList();
        sFirstDrawComplete = false;
        sConfigCallbacks = new ArrayList();
        mResizeInterpolator = new AccelerateDecelerateInterpolator();
    }

    public static class RunQueue {
        public final ArrayList<HandlerAction> mActions = new ArrayList();

        public void post(Runnable action) {
            this.postDelayed(action, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postDelayed(Runnable action, long delayMillis) {
            HandlerAction handlerAction = new HandlerAction(null);
            handlerAction.action = action;
            handlerAction.delay = delayMillis;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                this.mActions.add(handlerAction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCallbacks(Runnable action) {
            HandlerAction handlerAction = new HandlerAction(null);
            handlerAction.action = action;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> actions = this.mActions;
                while (actions.remove(handlerAction)) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeActions(Handler handler) {
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> actions = this.mActions;
                int count = actions.size();
                for (int i = 0; i < count; ++i) {
                    HandlerAction handlerAction = actions.get(i);
                    handler.postDelayed(handlerAction.action, handlerAction.delay);
                }
                actions.clear();
            }
        }

        public static class HandlerAction {
            public Runnable action;
            public long delay;

            public HandlerAction() {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                HandlerAction that = (HandlerAction)o;
                return !(this.action == null ? that.action != null : !this.action.equals(that.action));
            }

            public int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
                return result;
            }

            public /* synthetic */ HandlerAction(1 x0) {
                this();
            }
        }
    }

    public static class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String msg) {
            super(msg);
        }
    }

    public static class TrackballAxis {
        public static final float MAX_ACCELERATION = 20.0f;
        public static final long FAST_MOVE_TIME = 150L;
        public static final float ACCEL_MOVE_SCALING_FACTOR = 0.025f;
        public float position;
        public float absPosition;
        public float acceleration = 1.0f;
        public long lastMoveTime = 0L;
        public int step;
        public int dir;
        public int nonAccelMovement;

        public void reset(int _step) {
            this.position = 0.0f;
            this.acceleration = 1.0f;
            this.lastMoveTime = 0L;
            this.step = _step;
            this.dir = 0;
        }

        public float collect(float off, long time, String axis) {
            long normTime;
            if (off > 0.0f) {
                normTime = (long)(off * 150.0f);
                if (this.dir < 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = 1;
            } else if (off < 0.0f) {
                normTime = (long)(-off * 150.0f);
                if (this.dir > 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = -1;
            } else {
                normTime = 0L;
            }
            if (normTime > 0L) {
                long delta = time - this.lastMoveTime;
                this.lastMoveTime = time;
                float acc = this.acceleration;
                if (delta < normTime) {
                    float scale = (float)(normTime - delta) * 0.025f;
                    if (scale > 1.0f) {
                        acc *= scale;
                    }
                    this.acceleration = acc < 20.0f ? acc : 20.0f;
                } else {
                    float scale = (float)(delta - normTime) * 0.025f;
                    if (scale > 1.0f) {
                        acc /= scale;
                    }
                    this.acceleration = acc > 1.0f ? acc : 1.0f;
                }
            }
            this.position += off;
            this.absPosition = Math.abs(this.position);
            return this.absPosition;
        }

        public int generate(float precision) {
            int movement = 0;
            this.nonAccelMovement = 0;
            block4: while (true) {
                int dir = this.position >= 0.0f ? 1 : -1;
                switch (this.step) {
                    case 0: {
                        if (this.absPosition < precision) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.step = 1;
                        continue block4;
                    }
                    case 1: {
                        if (this.absPosition < 2.0f) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.position += dir > 0 ? -2.0f : 2.0f;
                        this.absPosition = Math.abs(this.position);
                        this.step = 2;
                        continue block4;
                    }
                }
                if (this.absPosition < 1.0f) {
                    return movement;
                }
                movement += dir;
                this.position += dir >= 0 ? -1.0f : 1.0f;
                this.absPosition = Math.abs(this.position);
                float acc = this.acceleration;
                this.acceleration = acc < 20.0f ? (acc *= 1.1f) : this.acceleration;
            }
        }
    }

    public static class W
    extends IWindow.Stub {
        public final WeakReference<ViewRoot> mViewRoot;

        public W(ViewRoot viewRoot) {
            this.mViewRoot = new WeakReference<ViewRoot>(viewRoot);
        }

        public void resized(int w, int h, Rect coveredInsets, Rect visibleInsets, boolean reportDraw, Configuration newConfig) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchResized(w, h, coveredInsets, visibleInsets, reportDraw, newConfig);
            }
        }

        public void dispatchAppVisibility(boolean visible) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchAppVisibility(visible);
            }
        }

        public void dispatchGetNewSurface() {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchGetNewSurface();
            }
        }

        public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.windowFocusChanged(hasFocus, inTouchMode);
            }
        }

        public static int checkCallingPermission(String permission2) {
            if (!Process.supportsProcesses()) {
                return 0;
            }
            try {
                return ActivityManagerNative.getDefault().checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
            }
            catch (RemoteException e) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void executeCommand(String command, String parameters, ParcelFileDescriptor out) {
            View view;
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot == null || (view = viewRoot.mView) == null) return;
            if (W.checkCallingPermission("android.permission.DUMP") != 0) {
                throw new SecurityException("Insufficient permissions to invoke executeCommand() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            }
            ParcelFileDescriptor.AutoCloseOutputStream clientStream = null;
            clientStream = new ParcelFileDescriptor.AutoCloseOutputStream(out);
            ViewDebug.dispatchCommand(view, command, parameters, clientStream);
            Object var9_7 = null;
            if (clientStream == null) return;
            try {
                ((OutputStream)clientStream).close();
                return;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var9_8 = null;
                    if (clientStream == null) return;
                    try {
                        ((OutputStream)clientStream).close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (clientStream == null) throw throwable;
                try {
                    ((OutputStream)clientStream).close();
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }

        public void closeSystemDialogs(String reason) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchCloseSystemDialogs(reason);
            }
        }

        public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, boolean sync) {
            if (sync) {
                try {
                    sWindowSession.wallpaperOffsetsComplete(this.asBinder());
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }

        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
            if (sync) {
                try {
                    sWindowSession.wallpaperCommandComplete(this.asBinder(), null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }

        public void dispatchDragEvent(DragEvent event) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchDragEvent(event);
            }
        }

        public void dispatchSystemUiVisibilityChanged(int visibility) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchSystemUiVisibilityChanged(visibility);
            }
        }
    }

    public static class InputMethodCallback
    extends IInputMethodCallback.Stub {
        public WeakReference<ViewRoot> mViewRoot;

        public InputMethodCallback(ViewRoot viewRoot) {
            this.mViewRoot = new WeakReference<ViewRoot>(viewRoot);
        }

        public void finishedEvent(int seq, boolean handled) {
            ViewRoot viewRoot = (ViewRoot)this.mViewRoot.get();
            if (viewRoot != null) {
                viewRoot.dispatchFinishedEvent(seq, handled);
            }
        }

        public void sessionCreated(IInputMethodSession session) throws RemoteException {
        }
    }

    public class TakenSurfaceHolder
    extends BaseSurfaceHolder {
        public boolean onAllowLockCanvas() {
            return ViewRoot.this.mDrawingAllowed;
        }

        public void onRelayoutContainer() {
        }

        public void setFormat(int format) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceFormat(format);
        }

        public void setType(int type) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceType(type);
        }

        public void onUpdateSurface() {
            throw new IllegalStateException("Shouldn't be here");
        }

        public boolean isCreating() {
            return ViewRoot.this.mIsCreating;
        }

        public void setFixedSize(int width, int height) {
            throw new UnsupportedOperationException("Currently only support sizing from layout");
        }

        public void setKeepScreenOn(boolean screenOn) {
            ((RootViewSurfaceTaker)((Object)ViewRoot.this.mView)).setSurfaceKeepScreenOn(screenOn);
        }
    }

    public class ResizedInfo {
        public Rect coveredInsets;
        public Rect visibleInsets;
        public Configuration newConfig;
    }
}

