/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.Headers;
import android.util.Log;
import android.util.TypedValue;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import android.webkit.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;

public class FileLoader
extends StreamLoader {
    public String mPath;
    public int mType;
    public boolean mAllowFileAccess;
    public static final int TYPE_ASSET = 1;
    public static final int TYPE_RES = 2;
    public static final int TYPE_FILE = 3;
    public static final String LOGTAG = "webkit";

    public FileLoader(String url, LoadListener loadListener, int type, boolean allowFileAccess) {
        super(loadListener);
        this.mType = type;
        this.mAllowFileAccess = allowFileAccess;
        int index = url.indexOf(63);
        this.mPath = this.mType == 1 ? (index > 0 ? URLUtil.stripAnchor(url.substring("file:///android_asset/".length(), index)) : URLUtil.stripAnchor(url.substring("file:///android_asset/".length()))) : (this.mType == 2 ? (index > 0 ? URLUtil.stripAnchor(url.substring("file:///android_res/".length(), index)) : URLUtil.stripAnchor(url.substring("file:///android_res/".length()))) : (index > 0 ? URLUtil.stripAnchor(url.substring("file://".length(), index)) : URLUtil.stripAnchor(url.substring("file://".length()))));
    }

    public String errString(Exception ex) {
        String exMessage = ex.getMessage();
        String errString = this.mContext.getString(17039626);
        if (exMessage != null) {
            errString = errString + " " + exMessage;
        }
        return errString;
    }

    public boolean setupStreamAndSendStatus() {
        try {
            if (this.mType == 1) {
                try {
                    this.mDataStream = this.mContext.getAssets().open(this.mPath);
                }
                catch (FileNotFoundException ex) {
                    this.mDataStream = this.mContext.getAssets().openNonAsset(this.mPath);
                }
            } else if (this.mType == 2) {
                if (this.mPath == null || this.mPath.length() == 0) {
                    Log.e(LOGTAG, "Need a path to resolve the res file");
                    this.mLoadListener.error(-13, this.mContext.getString(17039626));
                    return false;
                }
                int slash = this.mPath.indexOf(47);
                int dot = this.mPath.indexOf(46, slash);
                if (slash == -1 || dot == -1) {
                    Log.e(LOGTAG, "Incorrect res path: " + this.mPath);
                    this.mLoadListener.error(-13, this.mContext.getString(17039626));
                    return false;
                }
                String subClassName = this.mPath.substring(0, slash);
                String fieldName = this.mPath.substring(slash + 1, dot);
                String errorMsg = null;
                try {
                    Class<?> d = this.mContext.getApplicationContext().getClassLoader().loadClass(this.mContext.getPackageName() + ".R$" + subClassName);
                    Field field = d.getField(fieldName);
                    int id2 = field.getInt(null);
                    TypedValue value = new TypedValue();
                    this.mContext.getResources().getValue(id2, value, true);
                    if (value.type == 3) {
                        this.mDataStream = this.mContext.getAssets().openNonAsset(value.assetCookie, ((Object)value.string).toString(), 2);
                    } else {
                        errorMsg = "Only support TYPE_STRING for the res files";
                    }
                }
                catch (ClassNotFoundException e) {
                    errorMsg = "Can't find class:  " + this.mContext.getPackageName() + ".R$" + subClassName;
                }
                catch (SecurityException e) {
                    errorMsg = "Caught SecurityException: " + e;
                }
                catch (NoSuchFieldException e) {
                    errorMsg = "Can't find field:  " + fieldName + " in " + this.mContext.getPackageName() + ".R$" + subClassName;
                }
                catch (IllegalArgumentException e) {
                    errorMsg = "Caught IllegalArgumentException: " + e;
                }
                catch (IllegalAccessException e) {
                    errorMsg = "Caught IllegalAccessException: " + e;
                }
                if (errorMsg != null) {
                    this.mLoadListener.error(-13, this.mContext.getString(17039626));
                    return false;
                }
            } else {
                if (!this.mAllowFileAccess) {
                    this.mLoadListener.error(-13, this.mContext.getString(17039626));
                    return false;
                }
                this.mDataStream = new FileInputStream(this.mPath);
                this.mContentLength = new File(this.mPath).length();
            }
            this.mLoadListener.status(1, 1, 200, "OK");
        }
        catch (FileNotFoundException ex) {
            this.mLoadListener.error(-14, this.errString(ex));
            return false;
        }
        catch (IOException ex) {
            this.mLoadListener.error(-13, this.errString(ex));
            return false;
        }
        return true;
    }

    public void buildHeaders(Headers headers) {
    }
}

