/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.webkit.WebView;
import android.widget.EdgeGlow;

public class OverScrollGlow {
    public WebView mHostView;
    public EdgeGlow mEdgeGlowTop;
    public EdgeGlow mEdgeGlowBottom;
    public EdgeGlow mEdgeGlowLeft;
    public EdgeGlow mEdgeGlowRight;
    public int mOverScrollDeltaX;
    public int mOverScrollDeltaY;

    public OverScrollGlow(WebView host) {
        this.mHostView = host;
        Context context = host.getContext();
        Resources res = context.getResources();
        Drawable edge = res.getDrawable(17302481);
        Drawable glow = res.getDrawable(17302482);
        this.mEdgeGlowTop = new EdgeGlow(context, edge, glow);
        this.mEdgeGlowBottom = new EdgeGlow(context, edge, glow);
        this.mEdgeGlowLeft = new EdgeGlow(context, edge, glow);
        this.mEdgeGlowRight = new EdgeGlow(context, edge, glow);
    }

    public void pullGlow(int x, int y, int oldX, int oldY, int maxX, int maxY) {
        if (oldX == this.mHostView.getScrollX() && oldY == this.mHostView.getScrollY()) {
            if (maxX > 0) {
                int pulledToX = oldX + this.mOverScrollDeltaX;
                if (pulledToX < 0) {
                    this.mEdgeGlowLeft.onPull((float)this.mOverScrollDeltaX / (float)this.mHostView.getWidth());
                    if (!this.mEdgeGlowRight.isFinished()) {
                        this.mEdgeGlowRight.onRelease();
                    }
                } else if (pulledToX > maxX) {
                    this.mEdgeGlowRight.onPull((float)this.mOverScrollDeltaX / (float)this.mHostView.getWidth());
                    if (!this.mEdgeGlowLeft.isFinished()) {
                        this.mEdgeGlowLeft.onRelease();
                    }
                }
                this.mOverScrollDeltaX = 0;
            }
            if (maxY > 0 || this.mHostView.getOverScrollMode() == 0) {
                int pulledToY = oldY + this.mOverScrollDeltaY;
                if (pulledToY < 0) {
                    this.mEdgeGlowTop.onPull((float)this.mOverScrollDeltaY / (float)this.mHostView.getHeight());
                    if (!this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onRelease();
                    }
                } else if (pulledToY > maxY) {
                    this.mEdgeGlowBottom.onPull((float)this.mOverScrollDeltaY / (float)this.mHostView.getHeight());
                    if (!this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onRelease();
                    }
                }
                this.mOverScrollDeltaY = 0;
            }
        }
    }

    public void setOverScrollDeltas(int deltaX, int deltaY) {
        this.mOverScrollDeltaX = deltaX;
        this.mOverScrollDeltaY = deltaY;
    }

    public void absorbGlow(int x, int y, int oldX, int oldY, int rangeX, int rangeY) {
        if (rangeY > 0 || this.mHostView.getOverScrollMode() == 0) {
            if (y < 0 && oldY >= 0) {
                this.mEdgeGlowTop.onAbsorb((int)this.mHostView.mScroller.getCurrVelocity());
                if (!this.mEdgeGlowBottom.isFinished()) {
                    this.mEdgeGlowBottom.onRelease();
                }
            } else if (y > rangeY && oldY <= rangeY) {
                this.mEdgeGlowBottom.onAbsorb((int)this.mHostView.mScroller.getCurrVelocity());
                if (!this.mEdgeGlowTop.isFinished()) {
                    this.mEdgeGlowTop.onRelease();
                }
            }
        }
        if (rangeX > 0) {
            if (x < 0 && oldX >= 0) {
                this.mEdgeGlowLeft.onAbsorb((int)this.mHostView.mScroller.getCurrVelocity());
                if (!this.mEdgeGlowRight.isFinished()) {
                    this.mEdgeGlowRight.onRelease();
                }
            } else if (x > rangeX && oldX <= rangeX) {
                this.mEdgeGlowRight.onAbsorb((int)this.mHostView.mScroller.getCurrVelocity());
                if (!this.mEdgeGlowLeft.isFinished()) {
                    this.mEdgeGlowLeft.onRelease();
                }
            }
        }
    }

    public boolean drawEdgeGlows(Canvas canvas) {
        int restoreCount;
        int scrollX = this.mHostView.getScrollX();
        int scrollY = this.mHostView.getScrollY();
        int width = this.mHostView.getWidth();
        int height = this.mHostView.getHeight();
        boolean invalidateForGlow = false;
        if (!this.mEdgeGlowTop.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate(scrollX, this.mHostView.getVisibleTitleHeight() + Math.min(0, scrollY));
            this.mEdgeGlowTop.setSize(width, height);
            invalidateForGlow |= this.mEdgeGlowTop.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowBottom.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate(-width + scrollX, Math.max(this.mHostView.computeMaxScrollY(), scrollY) + height);
            canvas.rotate(180.0f, width, 0.0f);
            this.mEdgeGlowBottom.setSize(width, height);
            invalidateForGlow |= this.mEdgeGlowBottom.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowLeft.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(270.0f);
            canvas.translate(-height - scrollY, Math.min(0, scrollX));
            this.mEdgeGlowLeft.setSize(height, width);
            invalidateForGlow |= this.mEdgeGlowLeft.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowRight.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(90.0f);
            canvas.translate(scrollY, -(Math.max(this.mHostView.computeMaxScrollX(), scrollX) + width));
            this.mEdgeGlowRight.setSize(height, width);
            invalidateForGlow |= this.mEdgeGlowRight.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        return invalidateForGlow;
    }

    public boolean isAnimating() {
        return !this.mEdgeGlowTop.isFinished() || !this.mEdgeGlowBottom.isFinished() || !this.mEdgeGlowLeft.isFinished() || !this.mEdgeGlowRight.isFinished();
    }

    public void releaseAll() {
        this.mEdgeGlowTop.onRelease();
        this.mEdgeGlowBottom.onRelease();
        this.mEdgeGlowLeft.onRelease();
        this.mEdgeGlowRight.onRelease();
    }
}

