/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.SslError;
import android.os.Bundle;
import android.os.Message;
import android.webkit.CallbackProxy;
import android.webkit.LoadListener;
import android.webkit.SslErrorHandler;
import java.util.LinkedList;

public class SslErrorHandlerImpl
extends SslErrorHandler {
    public static final String LOGTAG = "network";
    public LinkedList<LoadListener> mLoaderQueue;
    public Bundle mSslPrefTable;
    public final SslErrorHandler mOriginHandler;
    public final LoadListener mLoadListener;
    public static final int HANDLE_RESPONSE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                LoadListener loader = (LoadListener)msg.obj;
                SslErrorHandlerImpl sslErrorHandlerImpl = this;
                synchronized (sslErrorHandlerImpl) {
                    this.handleSslErrorResponse(loader, loader.sslError(), msg.arg1 == 1);
                    this.mLoaderQueue.remove(loader);
                    this.fastProcessQueuedSslErrors();
                    break;
                }
            }
        }
    }

    public SslErrorHandlerImpl() {
        this.mLoaderQueue = new LinkedList();
        this.mSslPrefTable = new Bundle();
        this.mOriginHandler = null;
        this.mLoadListener = null;
    }

    public SslErrorHandlerImpl(SslErrorHandler origin, LoadListener listener) {
        this.mOriginHandler = origin;
        this.mLoadListener = listener;
    }

    public synchronized boolean saveState(Bundle outState) {
        boolean success;
        boolean bl = success = outState != null;
        if (success) {
            outState.putBundle("ssl-error-handler", this.mSslPrefTable);
        }
        return success;
    }

    public synchronized boolean restoreState(Bundle inState) {
        boolean success;
        boolean bl = success = inState != null;
        if (success && (success = inState.containsKey("ssl-error-handler"))) {
            this.mSslPrefTable = inState.getBundle("ssl-error-handler");
        }
        return success;
    }

    public synchronized void clear() {
        this.mSslPrefTable.clear();
    }

    public synchronized void handleSslErrorRequest(LoadListener loader) {
        if (!loader.cancelled()) {
            this.mLoaderQueue.offer(loader);
            if (loader == this.mLoaderQueue.peek()) {
                this.fastProcessQueuedSslErrors();
            }
        }
    }

    public synchronized boolean checkSslPrefTable(LoadListener loader, SslError error) {
        String host = loader.host();
        int primary = error.getPrimaryError();
        if (this.mSslPrefTable.containsKey(host) && primary <= this.mSslPrefTable.getInt(host)) {
            this.handleSslErrorResponse(loader, error, true);
            return true;
        }
        return false;
    }

    public void fastProcessQueuedSslErrors() {
        while (this.processNextLoader()) {
        }
    }

    public synchronized boolean processNextLoader() {
        LoadListener loader = this.mLoaderQueue.peek();
        if (loader != null) {
            if (loader.cancelled()) {
                this.mLoaderQueue.remove(loader);
                return true;
            }
            SslError error = loader.sslError();
            if (this.checkSslPrefTable(loader, error)) {
                this.mLoaderQueue.remove(loader);
                return true;
            }
            CallbackProxy proxy = loader.getFrame().getCallbackProxy();
            proxy.onReceivedSslError(new SslErrorHandlerImpl(this, loader), error);
        }
        return false;
    }

    public void proceed() {
        this.mOriginHandler.sendMessage(this.mOriginHandler.obtainMessage(100, 1, 0, this.mLoadListener));
    }

    public void cancel() {
        this.mOriginHandler.sendMessage(this.mOriginHandler.obtainMessage(100, 0, 0, this.mLoadListener));
    }

    public synchronized void handleSslErrorResponse(LoadListener loader, SslError error, boolean proceed) {
        if (!loader.cancelled()) {
            if (proceed) {
                int primary = error.getPrimaryError();
                String host = loader.host();
                boolean hasKey = this.mSslPrefTable.containsKey(host);
                if (!hasKey || primary > this.mSslPrefTable.getInt(host)) {
                    this.mSslPrefTable.putInt(host, primary);
                }
            }
            loader.handleSslErrorResponse(proceed);
        }
    }
}

