/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.ZoomControlBase;
import android.webkit.ZoomManager;
import android.widget.FrameLayout;
import android.widget.Toast;
import android.widget.ZoomButtonsController;

public class ZoomControlEmbedded
implements ZoomControlBase {
    public final ZoomManager mZoomManager;
    public final WebView mWebView;
    public ZoomButtonsController mZoomButtonsController;

    public ZoomControlEmbedded(ZoomManager zoomManager, WebView webView) {
        this.mZoomManager = zoomManager;
        this.mWebView = webView;
    }

    public void show() {
        if (!this.getControls().isVisible() && !this.mZoomManager.isZoomScaleFixed()) {
            this.mZoomButtonsController.setVisible(true);
            if (this.mZoomManager.isDoubleTapEnabled()) {
                WebSettings settings = this.mWebView.getSettings();
                int count = settings.getDoubleTapToastCount();
                if (this.mZoomManager.isInZoomOverview() && count > 0) {
                    settings.setDoubleTapToastCount(--count);
                    Toast.makeText(this.mWebView.getContext(), 17040090, 1).show();
                }
            }
        }
    }

    public void hide() {
        if (this.mZoomButtonsController != null) {
            this.mZoomButtonsController.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.mZoomButtonsController != null && this.mZoomButtonsController.isVisible();
    }

    public void update() {
        boolean canZoomOut;
        if (this.mZoomButtonsController == null) {
            return;
        }
        boolean canZoomIn = this.mZoomManager.canZoomIn();
        boolean bl = canZoomOut = this.mZoomManager.canZoomOut() && !this.mZoomManager.isInZoomOverview();
        if (!canZoomIn && !canZoomOut) {
            this.mZoomButtonsController.getZoomControls().setVisibility(8);
        } else {
            this.mZoomButtonsController.setZoomInEnabled(canZoomIn);
            this.mZoomButtonsController.setZoomOutEnabled(canZoomOut);
        }
    }

    public ZoomButtonsController getControls() {
        if (this.mZoomButtonsController == null) {
            this.mZoomButtonsController = new ZoomButtonsController(this.mWebView);
            this.mZoomButtonsController.setOnZoomListener(new ZoomListener(null));
            View controls = this.mZoomButtonsController.getZoomControls();
            ViewGroup.LayoutParams params = controls.getLayoutParams();
            if (params instanceof FrameLayout.LayoutParams) {
                ((FrameLayout.LayoutParams)params).gravity = 5;
            }
        }
        return this.mZoomButtonsController;
    }

    public static class 1 {
    }

    public class ZoomListener
    implements ZoomButtonsController.OnZoomListener {
        public ZoomListener() {
        }

        public void onVisibilityChanged(boolean visible) {
            if (visible) {
                ZoomControlEmbedded.this.mWebView.switchOutDrawHistory();
                ZoomControlEmbedded.this.mZoomButtonsController.getZoomControls().setVisibility(0);
                ZoomControlEmbedded.this.update();
            }
        }

        public void onZoom(boolean zoomIn) {
            if (zoomIn) {
                ZoomControlEmbedded.this.mWebView.zoomIn();
            } else {
                ZoomControlEmbedded.this.mWebView.zoomOut();
            }
            ZoomControlEmbedded.this.update();
        }

        public /* synthetic */ ZoomListener(1 x1) {
            this();
        }
    }
}

