/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.webkit.CallbackProxy;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewCore;
import android.webkit.ZoomControlBase;
import android.webkit.ZoomControlEmbedded;
import android.webkit.ZoomControlExternal;

public class ZoomManager {
    public static final String LOGTAG = "webviewZoom";
    public final WebView mWebView;
    public final CallbackProxy mCallbackProxy;
    public ZoomControlEmbedded mEmbeddedZoomControl;
    public ZoomControlExternal mExternalZoomControl;
    public static final float DEFAULT_READING_LEVEL_SCALE = 1.5f;
    public static final float DEFAULT_MAX_ZOOM_SCALE_FACTOR = 4.0f;
    public static final float DEFAULT_MIN_ZOOM_SCALE_FACTOR = 0.25f;
    public float mDefaultMaxZoomScale;
    public float mDefaultMinZoomScale;
    public float mMaxZoomScale;
    public float mMinZoomScale;
    public boolean mMinZoomScaleFixed = true;
    public boolean mInitialZoomOverview = false;
    public boolean mInZoomOverview = false;
    public int mZoomOverviewWidth;
    public float mInvZoomOverviewWidth;
    public float mZoomCenterX;
    public float mZoomCenterY;
    public int mAnchorX;
    public int mAnchorY;
    public float mTextWrapScale;
    public float mDefaultScale;
    public float mInvDefaultScale;
    public float mActualScale;
    public float mInvActualScale;
    public float mInitialScale;
    public static float MINIMUM_SCALE_INCREMENT = 0.007f;
    public static float MINIMUM_SCALE_WITHOUT_JITTER = 0.007f;
    public float mZoomScale;
    public float mInvInitialZoomScale;
    public float mInvFinalZoomScale;
    public int mInitialScrollX;
    public int mInitialScrollY;
    public long mZoomStart;
    public static final int ZOOM_ANIMATION_LENGTH = 500;
    public boolean mSupportMultiTouch;
    public boolean mAllowPanAndScale;
    public ScaleGestureDetector mScaleDetector;
    public boolean mPinchToZoomAnimating = false;
    public boolean mHardwareAccelerated = false;
    public boolean mInHWAcceleratedZoom = false;

    public ZoomManager(WebView webView, CallbackProxy callbackProxy) {
        this.mWebView = webView;
        this.mCallbackProxy = callbackProxy;
        this.setZoomOverviewWidth(980);
    }

    public void init(float density) {
        assert (density > 0.0f);
        this.setDefaultZoomScale(density);
        this.mActualScale = density;
        this.mInvActualScale = 1.0f / density;
        this.mTextWrapScale = density;
    }

    public void updateDefaultZoomDensity(float density) {
        assert (density > 0.0f);
        if (Math.abs(density - this.mDefaultScale) > MINIMUM_SCALE_INCREMENT) {
            this.setDefaultZoomScale(density);
            this.setZoomScale(this.mActualScale, true);
        }
    }

    public void setDefaultZoomScale(float defaultScale) {
        float originalDefault = this.mDefaultScale;
        this.mDefaultScale = defaultScale;
        this.mInvDefaultScale = 1.0f / defaultScale;
        this.mDefaultMaxZoomScale = defaultScale * 4.0f;
        this.mDefaultMinZoomScale = defaultScale * 0.25f;
        this.mMaxZoomScale = (double)originalDefault > 0.0 && (double)this.mMaxZoomScale > 0.0 ? defaultScale / originalDefault * this.mMaxZoomScale : this.mDefaultMaxZoomScale;
        this.mMinZoomScale = (double)originalDefault > 0.0 && (double)this.mMinZoomScale > 0.0 ? defaultScale / originalDefault * this.mMinZoomScale : this.mDefaultMinZoomScale;
        if (!ZoomManager.exceedsMinScaleIncrement(this.mMinZoomScale, this.mMaxZoomScale)) {
            this.mMaxZoomScale = this.mMinZoomScale;
        }
    }

    public float getScale() {
        return this.mActualScale;
    }

    public float getInvScale() {
        return this.mInvActualScale;
    }

    public float getTextWrapScale() {
        return this.mTextWrapScale;
    }

    public float getMaxZoomScale() {
        return this.mMaxZoomScale;
    }

    public float getMinZoomScale() {
        return this.mMinZoomScale;
    }

    public float getDefaultScale() {
        return this.mDefaultScale;
    }

    public float getReadingLevelScale() {
        float MIN_SCALE_DIFF = 0.5f;
        return this.computeScaleWithLimits(Math.max(this.getZoomOverviewScale() + 0.5f, 1.5f));
    }

    public float getInvDefaultScale() {
        return this.mInvDefaultScale;
    }

    public float getDefaultMaxZoomScale() {
        return this.mDefaultMaxZoomScale;
    }

    public float getDefaultMinZoomScale() {
        return this.mDefaultMinZoomScale;
    }

    public int getDocumentAnchorX() {
        return this.mAnchorX;
    }

    public int getDocumentAnchorY() {
        return this.mAnchorY;
    }

    public void clearDocumentAnchor() {
        this.mAnchorY = 0;
        this.mAnchorX = 0;
    }

    public void setZoomCenter(float x, float y) {
        this.mZoomCenterX = x;
        this.mZoomCenterY = y;
    }

    public void setInitialScaleInPercent(int scaleInPercent) {
        this.mInitialScale = (float)scaleInPercent * 0.01f;
    }

    public float computeScaleWithLimits(float scale) {
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        return scale;
    }

    public boolean isZoomScaleFixed() {
        return this.mMinZoomScale >= this.mMaxZoomScale;
    }

    public static boolean exceedsMinScaleIncrement(float scaleA, float scaleB) {
        return Math.abs(scaleA - scaleB) >= MINIMUM_SCALE_INCREMENT;
    }

    public boolean willScaleTriggerZoom(float scale) {
        return ZoomManager.exceedsMinScaleIncrement(scale, this.mActualScale);
    }

    public boolean canZoomIn() {
        return this.mMaxZoomScale - this.mActualScale > MINIMUM_SCALE_INCREMENT;
    }

    public boolean canZoomOut() {
        return this.mActualScale - this.mMinZoomScale > MINIMUM_SCALE_INCREMENT;
    }

    public boolean zoomIn() {
        return this.zoom(1.25f);
    }

    public boolean zoomOut() {
        return this.zoom(0.8f);
    }

    public boolean zoom(float zoomMultiplier) {
        this.mWebView.switchOutDrawHistory();
        this.mZoomCenterX = (float)this.mWebView.getViewWidth() * 0.5f;
        this.mZoomCenterY = (float)this.mWebView.getViewHeight() * 0.5f;
        this.mAnchorX = this.mWebView.viewToContentX((int)this.mZoomCenterX + this.mWebView.getScrollX());
        this.mAnchorY = this.mWebView.viewToContentY((int)this.mZoomCenterY + this.mWebView.getScrollY());
        return this.startZoomAnimation(this.mActualScale * zoomMultiplier, !this.mWebView.getSettings().getUseFixedViewport());
    }

    public boolean startZoomAnimation(float scale, boolean reflowText) {
        float oldScale = this.mActualScale;
        this.mInitialScrollX = this.mWebView.getScrollX();
        this.mInitialScrollY = this.mWebView.getScrollY();
        if (!ZoomManager.exceedsMinScaleIncrement(scale, this.getReadingLevelScale())) {
            scale = this.getReadingLevelScale();
        }
        if (this.mHardwareAccelerated) {
            this.mInHWAcceleratedZoom = true;
        }
        this.setZoomScale(scale, reflowText);
        if (oldScale != this.mActualScale) {
            this.mZoomStart = SystemClock.uptimeMillis();
            this.mInvInitialZoomScale = 1.0f / oldScale;
            this.mInvFinalZoomScale = 1.0f / this.mActualScale;
            this.mZoomScale = this.mActualScale;
            this.mWebView.onFixedLengthZoomAnimationStart();
            this.mWebView.invalidate();
            return true;
        }
        return false;
    }

    public void animateZoom(Canvas canvas) {
        float zoomScale;
        if (this.mZoomScale == 0.0f) {
            Log.w(LOGTAG, "A WebView is attempting to perform a fixed length zoom animation when no zoom is in progress");
            return;
        }
        int interval = (int)(SystemClock.uptimeMillis() - this.mZoomStart);
        if (interval < 500) {
            float ratio = (float)interval / 500.0f;
            zoomScale = 1.0f / (this.mInvInitialZoomScale + (this.mInvFinalZoomScale - this.mInvInitialZoomScale) * ratio);
            this.mWebView.invalidate();
        } else {
            zoomScale = this.mZoomScale;
            this.mZoomScale = 0.0f;
            this.mWebView.onFixedLengthZoomAnimationEnd();
        }
        float scale = zoomScale * this.mInvInitialZoomScale;
        int tx = Math.round(scale * ((float)this.mInitialScrollX + this.mZoomCenterX) - this.mZoomCenterX);
        tx = -WebView.pinLoc((int)tx, (int)this.mWebView.getViewWidth(), (int)Math.round((float)this.mWebView.getContentWidth() * zoomScale)) + this.mWebView.getScrollX();
        int titleHeight = this.mWebView.getTitleHeight();
        int ty = Math.round(scale * ((float)this.mInitialScrollY + this.mZoomCenterY - (float)titleHeight) - (this.mZoomCenterY - (float)titleHeight));
        ty = -(ty <= titleHeight ? Math.max(ty, 0) : WebView.pinLoc((int)(ty - titleHeight), (int)this.mWebView.getViewHeight(), (int)Math.round((float)this.mWebView.getContentHeight() * zoomScale)) + titleHeight) + this.mWebView.getScrollY();
        if (this.mHardwareAccelerated) {
            this.mWebView.updateScrollCoordinates(this.mWebView.getScrollX() - tx, this.mWebView.getScrollY() - ty);
            this.setZoomScale(zoomScale, false);
            if (this.mZoomScale == 0.0f) {
                this.mInHWAcceleratedZoom = false;
            }
        } else {
            canvas.translate(tx, ty);
            canvas.scale(zoomScale, zoomScale);
        }
    }

    public boolean isZoomAnimating() {
        return this.isFixedLengthAnimationInProgress() || this.mPinchToZoomAnimating;
    }

    public boolean isFixedLengthAnimationInProgress() {
        return this.mZoomScale != 0.0f;
    }

    public void refreshZoomScale(boolean reflowText) {
        this.setZoomScale(this.mActualScale, reflowText, true);
    }

    public void setZoomScale(float scale, boolean reflowText) {
        this.setZoomScale(scale, reflowText, false);
    }

    public void setZoomScale(float scale, boolean reflowText, boolean force) {
        boolean isScaleLessThanMinZoom = scale < this.mMinZoomScale;
        scale = this.computeScaleWithLimits(scale);
        if (isScaleLessThanMinZoom && this.mMinZoomScale < this.mDefaultScale) {
            this.mInZoomOverview = true;
        } else {
            boolean bl = this.mInZoomOverview = !ZoomManager.exceedsMinScaleIncrement(scale, this.getZoomOverviewScale());
        }
        if (reflowText && !this.mWebView.getSettings().getUseFixedViewport()) {
            this.mTextWrapScale = scale;
        }
        if (ZoomManager.exceedsMinScaleIncrement(scale, this.mActualScale) || force) {
            float oldScale = this.mActualScale;
            float oldInvScale = this.mInvActualScale;
            if (scale != this.mActualScale && !this.mPinchToZoomAnimating) {
                this.mCallbackProxy.onScaleChanged(this.mActualScale, scale);
            }
            this.mActualScale = scale;
            this.mInvActualScale = 1.0f / scale;
            if (!this.mWebView.drawHistory() && !this.mInHWAcceleratedZoom) {
                int oldX = this.mWebView.getScrollX();
                int oldY = this.mWebView.getScrollY();
                float ratio = scale * oldInvScale;
                float sx = ratio * (float)oldX + (ratio - 1.0f) * this.mZoomCenterX;
                float sy = ratio * (float)oldY + (ratio - 1.0f) * (this.mZoomCenterY - (float)this.mWebView.getTitleHeight());
                this.mWebView.mViewManager.scaleAll();
                int scrollX = this.mWebView.pinLocX(Math.round(sx));
                int scrollY = this.mWebView.pinLocY(Math.round(sy));
                if (!this.mWebView.updateScrollCoordinates(scrollX, scrollY)) {
                    this.mWebView.sendOurVisibleRect();
                }
            }
            this.mWebView.sendViewSizeZoom(reflowText);
        }
    }

    public boolean isDoubleTapEnabled() {
        WebSettings settings = this.mWebView.getSettings();
        return settings != null && settings.getUseWideViewPort();
    }

    public void handleDoubleTap(float lastTouchX, float lastTouchY) {
        WebSettings settings = this.mWebView.getSettings();
        if (!this.isDoubleTapEnabled()) {
            return;
        }
        this.setZoomCenter(lastTouchX, lastTouchY);
        this.mAnchorX = this.mWebView.viewToContentX((int)lastTouchX + this.mWebView.getScrollX());
        this.mAnchorY = this.mWebView.viewToContentY((int)lastTouchY + this.mWebView.getScrollY());
        settings.setDoubleTapToastCount(0);
        this.dismissZoomPicker();
        Rect pluginBounds = this.mWebView.getPluginBounds(this.mAnchorX, this.mAnchorY);
        if (pluginBounds != null) {
            if (this.mWebView.isRectFitOnScreen(pluginBounds)) {
                this.zoomToOverview();
            } else {
                this.mWebView.centerFitRect(pluginBounds);
            }
            return;
        }
        float newTextWrapScale = settings.getUseFixedViewport() ? Math.max(this.mActualScale, this.getReadingLevelScale()) : this.mActualScale;
        if (settings.isNarrowColumnLayout() && ZoomManager.exceedsMinScaleIncrement(this.mTextWrapScale, newTextWrapScale)) {
            this.mTextWrapScale = newTextWrapScale;
            this.refreshZoomScale(true);
        } else if (!this.mInZoomOverview && this.willScaleTriggerZoom(this.getZoomOverviewScale())) {
            this.zoomToOverview();
        } else {
            this.zoomToReadingLevel();
        }
    }

    public void setZoomOverviewWidth(int width) {
        this.mZoomOverviewWidth = width == 0 ? 980 : width;
        this.mInvZoomOverviewWidth = 1.0f / (float)width;
    }

    public float getZoomOverviewScale() {
        return (float)this.mWebView.getViewWidth() * this.mInvZoomOverviewWidth;
    }

    public boolean isInZoomOverview() {
        return this.mInZoomOverview;
    }

    public void zoomToOverview() {
        int scrollY = this.mWebView.getScrollY();
        if (scrollY < this.mWebView.getTitleHeight()) {
            this.mWebView.updateScrollCoordinates(this.mWebView.getScrollX(), 0);
        }
        this.startZoomAnimation(this.getZoomOverviewScale(), !this.mWebView.getSettings().getUseFixedViewport());
    }

    public void zoomToReadingLevel() {
        float readingScale = this.getReadingLevelScale();
        int left = this.mWebView.nativeGetBlockLeftEdge(this.mAnchorX, this.mAnchorY, this.mActualScale);
        if (left != -1) {
            int viewLeft = this.mWebView.contentToViewX(left < 5 ? 0 : left - 5) - this.mWebView.getScrollX();
            if (viewLeft > 0) {
                this.mZoomCenterX = (float)viewLeft * readingScale / (readingScale - this.mActualScale);
            } else {
                this.mWebView.scrollBy(viewLeft, 0);
                this.mZoomCenterX = 0.0f;
            }
        }
        this.startZoomAnimation(readingScale, !this.mWebView.getSettings().getUseFixedViewport());
    }

    public void updateMultiTouchSupport(Context context) {
        assert (this.mWebView.getSettings() != null);
        WebSettings settings = this.mWebView.getSettings();
        PackageManager pm = context.getPackageManager();
        this.mSupportMultiTouch = pm.hasSystemFeature("android.hardware.touchscreen.multitouch") && settings.supportZoom() && settings.getBuiltInZoomControls();
        this.mAllowPanAndScale = pm.hasSystemFeature("android.hardware.touchscreen.multitouch.distinct");
        if (this.mSupportMultiTouch && this.mScaleDetector == null) {
            this.mScaleDetector = new ScaleGestureDetector(context, new ScaleDetectorListener(null));
        } else if (!this.mSupportMultiTouch && this.mScaleDetector != null) {
            this.mScaleDetector = null;
        }
    }

    public boolean supportsMultiTouchZoom() {
        return this.mSupportMultiTouch;
    }

    public boolean supportsPanDuringZoom() {
        return this.mAllowPanAndScale;
    }

    public boolean isPreventingWebkitUpdates() {
        return this.mPinchToZoomAnimating;
    }

    public ScaleGestureDetector getMultiTouchGestureDetector() {
        return this.mScaleDetector;
    }

    public void onSizeChanged(int w, int h, int ow, int oh) {
        if (!this.isFixedLengthAnimationInProgress()) {
            int visibleTitleHeight = this.mWebView.getVisibleTitleHeight();
            this.mZoomCenterX = 0.0f;
            this.mZoomCenterY = visibleTitleHeight;
            this.mAnchorX = this.mWebView.viewToContentX(this.mWebView.getScrollX());
            this.mAnchorY = this.mWebView.viewToContentY(visibleTitleHeight + this.mWebView.getScrollY());
        }
        if (!this.mMinZoomScaleFixed) {
            this.mMinZoomScale = Math.min(1.0f, (float)this.mWebView.getViewWidth() / (float)(this.mWebView.drawHistory() ? this.mWebView.getHistoryPictureWidth() : this.mZoomOverviewWidth));
            if (this.mInitialScale > 0.0f && this.mInitialScale < this.mMinZoomScale) {
                this.mMinZoomScale = this.mInitialScale;
            }
        }
        this.dismissZoomPicker();
        this.mWebView.post(new PostScale(w != ow && !this.mWebView.getSettings().getUseFixedViewport()));
    }

    public void updateZoomRange(WebViewCore.ViewState viewState, int viewWidth, int minPrefWidth) {
        if (viewState.mMinScale == 0.0f) {
            if (viewState.mMobileSite) {
                if (minPrefWidth > Math.max(0, viewWidth)) {
                    this.mMinZoomScale = (float)viewWidth / (float)minPrefWidth;
                    this.mMinZoomScaleFixed = false;
                } else {
                    this.mMinZoomScale = viewState.mDefaultScale;
                    this.mMinZoomScaleFixed = true;
                }
            } else {
                this.mMinZoomScale = this.mDefaultMinZoomScale;
                this.mMinZoomScaleFixed = false;
            }
        } else {
            this.mMinZoomScale = viewState.mMinScale;
            this.mMinZoomScaleFixed = true;
        }
        this.mMaxZoomScale = viewState.mMaxScale == 0.0f ? this.mDefaultMaxZoomScale : viewState.mMaxScale;
    }

    public void onNewPicture(WebViewCore.DrawData drawData) {
        int viewWidth = this.mWebView.getViewWidth();
        boolean zoomOverviewWidthChanged = this.setupZoomOverviewWidth(drawData, viewWidth);
        WebSettings settings = this.mWebView.getSettings();
        if (zoomOverviewWidthChanged && settings.isNarrowColumnLayout() && settings.getUseFixedViewport() && (this.mInitialZoomOverview || this.mInZoomOverview)) {
            this.mTextWrapScale = this.getReadingLevelScale();
        }
        float zoomOverviewScale = this.getZoomOverviewScale();
        if (!this.mMinZoomScaleFixed) {
            this.mMinZoomScale = zoomOverviewScale;
        }
        if (!this.mWebView.drawHistory() && (this.mInitialZoomOverview || this.mInZoomOverview && Math.abs((float)viewWidth * this.mInvActualScale - (float)this.mZoomOverviewWidth) > 1.0f)) {
            this.mInitialZoomOverview = false;
            this.setZoomScale(zoomOverviewScale, !this.willScaleTriggerZoom(this.mTextWrapScale) && !this.mWebView.getSettings().getUseFixedViewport());
        }
    }

    public boolean setupZoomOverviewWidth(WebViewCore.DrawData drawData, int viewWidth) {
        WebSettings settings = this.mWebView.getSettings();
        int newZoomOverviewWidth = this.mZoomOverviewWidth;
        if (settings.getUseWideViewPort()) {
            if (!settings.getUseFixedViewport()) {
                newZoomOverviewWidth = Math.min(WebView.sMaxViewportWidth, Math.max((int)((float)viewWidth * this.mInvDefaultScale), Math.max(drawData.mMinPrefWidth, drawData.mViewSize.x)));
            } else if (drawData.mContentSize.x > 0) {
                int contentWidth = Math.max(drawData.mContentSize.x, drawData.mMinPrefWidth);
                newZoomOverviewWidth = Math.min(WebView.sMaxViewportWidth, contentWidth);
            }
        } else {
            newZoomOverviewWidth = viewWidth;
        }
        if (newZoomOverviewWidth != this.mZoomOverviewWidth) {
            this.setZoomOverviewWidth(newZoomOverviewWidth);
            return true;
        }
        return false;
    }

    public void onFirstLayout(WebViewCore.DrawData drawData) {
        assert (drawData != null);
        assert (drawData.mViewState != null);
        assert (this.mWebView.getSettings() != null);
        WebViewCore.ViewState viewState = drawData.mViewState;
        Point viewSize = drawData.mViewSize;
        this.updateZoomRange(viewState, viewSize.x, drawData.mMinPrefWidth);
        this.setupZoomOverviewWidth(drawData, this.mWebView.getViewWidth());
        if (!this.mWebView.drawHistory()) {
            float scale;
            float overviewScale = this.getZoomOverviewScale();
            WebSettings settings = this.mWebView.getSettings();
            if (this.mInitialScale > 0.0f) {
                scale = this.mInitialScale;
            } else if (viewState.mViewScale > 0.0f) {
                this.mTextWrapScale = viewState.mTextWrapScale;
                scale = viewState.mViewScale;
            } else {
                scale = overviewScale;
                if (!settings.getUseWideViewPort() || !settings.getLoadWithOverviewMode()) {
                    scale = Math.max(viewState.mTextWrapScale, scale);
                }
                if (settings.isNarrowColumnLayout() && settings.getUseFixedViewport()) {
                    this.mTextWrapScale = this.getReadingLevelScale();
                }
            }
            boolean reflowText = false;
            if (!viewState.mIsRestored) {
                if (settings.getUseFixedViewport()) {
                    scale = Math.max(scale, overviewScale);
                    this.mTextWrapScale = Math.max(this.mTextWrapScale, overviewScale);
                }
                reflowText = ZoomManager.exceedsMinScaleIncrement(this.mTextWrapScale, scale);
            }
            this.mInitialZoomOverview = !ZoomManager.exceedsMinScaleIncrement(scale, overviewScale);
            this.setZoomScale(scale, reflowText);
            this.updateZoomPicker();
        }
    }

    public void saveZoomState(Bundle b) {
        b.putFloat("scale", this.mActualScale);
        b.putFloat("textwrapScale", this.mTextWrapScale);
        b.putBoolean("overview", this.mInZoomOverview);
    }

    public void restoreZoomState(Bundle b) {
        this.mActualScale = b.getFloat("scale", 1.0f);
        this.mInvActualScale = 1.0f / this.mActualScale;
        this.mTextWrapScale = b.getFloat("textwrapScale", this.mActualScale);
        this.mInZoomOverview = b.getBoolean("overview");
    }

    public ZoomControlBase getCurrentZoomControl() {
        if (this.mWebView.getSettings() != null && this.mWebView.getSettings().supportZoom()) {
            if (this.mWebView.getSettings().getBuiltInZoomControls()) {
                if (this.mEmbeddedZoomControl == null && this.mWebView.getSettings().getDisplayZoomControls()) {
                    this.mEmbeddedZoomControl = new ZoomControlEmbedded(this, this.mWebView);
                }
                return this.mEmbeddedZoomControl;
            }
            if (this.mExternalZoomControl == null) {
                this.mExternalZoomControl = new ZoomControlExternal(this.mWebView);
            }
            return this.mExternalZoomControl;
        }
        return null;
    }

    public void invokeZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null) {
            control.show();
        }
    }

    public void dismissZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null) {
            control.hide();
        }
    }

    public boolean isZoomPickerVisible() {
        ZoomControlBase control = this.getCurrentZoomControl();
        return control != null ? control.isVisible() : false;
    }

    public void updateZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null) {
            control.update();
        }
    }

    public void keepZoomPickerVisible() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null && control == this.mExternalZoomControl) {
            control.show();
        }
    }

    public View getExternalZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null && control == this.mExternalZoomControl) {
            return this.mExternalZoomControl.getControls();
        }
        return null;
    }

    public void setHardwareAccelerated() {
        this.mHardwareAccelerated = true;
    }

    public static class 1 {
    }

    public class PostScale
    implements Runnable {
        public final boolean mUpdateTextWrap;

        public PostScale(boolean updateTextWrap) {
            this.mUpdateTextWrap = updateTextWrap;
        }

        public void run() {
            if (ZoomManager.this.mWebView.getWebViewCore() != null) {
                ZoomManager.this.setZoomScale(Math.max(ZoomManager.this.mActualScale, ZoomManager.this.getZoomOverviewScale()), this.mUpdateTextWrap, true);
                ZoomManager.this.updateZoomPicker();
            }
        }
    }

    public class ScaleDetectorListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        public ScaleDetectorListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ZoomManager.this.dismissZoomPicker();
            ((ZoomManager)ZoomManager.this).mWebView.mViewManager.startZoom();
            ZoomManager.this.mWebView.onPinchToZoomAnimationStart();
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = Math.max(detector.getScaleFactor() * ZoomManager.this.mActualScale, ZoomManager.this.getZoomOverviewScale());
            if (ZoomManager.this.mPinchToZoomAnimating || ZoomManager.this.willScaleTriggerZoom(scale)) {
                ZoomManager.this.mPinchToZoomAnimating = true;
                scale = scale > ZoomManager.this.mActualScale ? Math.min(scale, ZoomManager.this.mActualScale * 1.25f) : Math.max(scale, ZoomManager.this.mActualScale * 0.8f);
                if (Math.abs(scale - ZoomManager.this.mActualScale) < MINIMUM_SCALE_WITHOUT_JITTER) {
                    return false;
                }
                ZoomManager.this.setZoomCenter(detector.getFocusX(), detector.getFocusY());
                ZoomManager.this.setZoomScale(scale, false);
                ZoomManager.this.mWebView.invalidate();
                return true;
            }
            return false;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (ZoomManager.this.mPinchToZoomAnimating) {
                ZoomManager.this.mPinchToZoomAnimating = false;
                ZoomManager.this.mAnchorX = ZoomManager.this.mWebView.viewToContentX((int)ZoomManager.this.mZoomCenterX + ZoomManager.this.mWebView.getScrollX());
                ZoomManager.this.mAnchorY = ZoomManager.this.mWebView.viewToContentY((int)ZoomManager.this.mZoomCenterY + ZoomManager.this.mWebView.getScrollY());
                boolean reflowNow = !ZoomManager.this.canZoomOut() || (double)ZoomManager.this.mActualScale <= 0.8 * (double)ZoomManager.this.mTextWrapScale;
                ZoomManager.this.refreshZoomScale(reflowNow && !ZoomManager.this.mWebView.getSettings().getUseFixedViewport());
                ZoomManager.this.mWebView.invalidate();
            }
            ((ZoomManager)ZoomManager.this).mWebView.mViewManager.endZoom();
            ZoomManager.this.mWebView.onPinchToZoomAnimationEnd(detector);
        }

        public /* synthetic */ ScaleDetectorListener(1 x1) {
            this();
        }
    }
}

