/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.net.ProxyProperties;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.text.Editable;
import android.text.Selection;
import android.util.AttributeSet;
import android.util.EventLog;
import android.util.Log;
import android.view.HardwareCanvas;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.AccessibilityInjector;
import android.webkit.CallbackProxy;
import android.webkit.DownloadListener;
import android.webkit.FindActionModeCallback;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.JniUtil;
import android.webkit.L10nUtils;
import android.webkit.Network;
import android.webkit.OverScrollGlow;
import android.webkit.PluginFullScreenHolder;
import android.webkit.PluginList;
import android.webkit.PluginManager;
import android.webkit.SelectActionModeCallback;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebTextView;
import android.webkit.WebViewClient;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import android.webkit.ZoomManager;
import android.webkit._Original_WebView$1;
import android.webkit._Original_WebView$2;
import android.webkit._Original_WebView$3;
import android.webkit._Original_WebView$4;
import android.webkit._Original_WebView$5;
import android.webkit._Original_WebView$6;
import android.webkit._Original_WebView$7;
import android.webkit._Original_WebView$8;
import android.webkit._Original_WebView$InvokeListBox$1;
import android.webkit._Original_WebView$InvokeListBox$2;
import android.webkit._Original_WebView$InvokeListBox$3;
import android.webkit._Original_WebView$InvokeListBox$4;
import android.widget.AbsoluteLayout;
import android.widget.Adapter;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.OverScroller;
import android.widget.Toast;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _Original_WebView
extends AbsoluteLayout
implements ViewTreeObserver.OnGlobalFocusChangeListener,
ViewGroup.OnHierarchyChangeListener {
    public InnerGlobalLayoutListener mGlobalLayoutListener = null;
    public InnerScrollChangedListener mScrollChangedListener = null;
    public static final boolean AUTO_REDRAW_HACK = false;
    public boolean mAutoRedraw;
    public AlertDialog mListBoxDialog = null;
    public static final String LOGTAG = "webview";
    public ZoomManager mZoomManager;
    public Rect mGLRectViewport = new Rect();
    public boolean mGLViewportEmpty = false;
    public final CallbackProxy mCallbackProxy;
    public final WebViewDatabase mDatabase;
    public SslCertificate mCertificate;
    public int mNativeClass;
    public WebViewCore mWebViewCore;
    public final Handler mPrivateHandler = new PrivateHandler();
    public WebTextView mWebTextView;
    public int mTextGeneration;
    public final ViewManager mViewManager;
    public PluginFullScreenHolder mFullScreenHolder;
    public int mLastTouchX;
    public int mLastTouchY;
    public long mLastTouchTime;
    public long mLastSentTouchTime;
    public static final int TOUCH_SENT_INTERVAL = 0;
    public int mCurrentTouchInterval = 0;
    public VelocityTracker mVelocityTracker;
    public int mMaximumFling;
    public float mLastVelocity;
    public float mLastVelX;
    public float mLastVelY;
    public int mScrollingLayer;
    public Rect mScrollingLayerRect = new Rect();
    public static final float MINIMUM_VELOCITY_RATIO_FOR_ACCELERATION = 0.2f;
    public int mTouchMode = 7;
    public static final int TOUCH_INIT_MODE = 1;
    public static final int TOUCH_DRAG_START_MODE = 2;
    public static final int TOUCH_DRAG_MODE = 3;
    public static final int TOUCH_SHORTPRESS_START_MODE = 4;
    public static final int TOUCH_SHORTPRESS_MODE = 5;
    public static final int TOUCH_DOUBLE_TAP_MODE = 6;
    public static final int TOUCH_DONE_MODE = 7;
    public static final int TOUCH_PINCH_DRAG = 8;
    public static final int TOUCH_DRAG_LAYER_MODE = 9;
    public boolean mForwardTouchEvents = false;
    public static final int PREVENT_DEFAULT_NO = 0;
    public static final int PREVENT_DEFAULT_MAYBE_YES = 1;
    public static final int PREVENT_DEFAULT_NO_FROM_TOUCH_DOWN = 2;
    public static final int PREVENT_DEFAULT_YES = 3;
    public static final int PREVENT_DEFAULT_IGNORE = 4;
    public int mPreventDefault = 4;
    public boolean mConfirmMove;
    public boolean mDeferTouchProcess;
    public boolean mIsHandlingMultiTouch = false;
    public int mDeferTouchMode = 7;
    public float mLastDeferTouchX;
    public float mLastDeferTouchY;
    public boolean mDragFromTextInput;
    public boolean mDrawCursorRing = true;
    public boolean mIsPaused;
    public HitTestResult mInitialHitTestResult;
    public int mTouchSlopSquare;
    public int mDoubleTapSlopSquare;
    public int mNavSlop;
    public static final int TAP_TIMEOUT = 200;
    public static final int LONG_PRESS_TIMEOUT = 1000;
    public static final int MIN_FLING_TIME = 250;
    public static final int MOTIONLESS_TIME = 100;
    public static final int PAGE_SCROLL_OVERLAP = 24;
    public boolean mWidthCanMeasure;
    public boolean mHeightCanMeasure;
    public int mLastWidthSent;
    public int mLastHeightSent;
    public int mContentWidth;
    public int mContentHeight;
    public boolean mOverlayHorizontalScrollbar = true;
    public boolean mOverlayVerticalScrollbar = false;
    public static final int STD_SPEED = 480;
    public static final int MAX_DURATION = 750;
    public static final int SLIDE_TITLE_DURATION = 500;
    public OverScroller mScroller;
    public boolean mInOverScrollMode = false;
    public static Paint mOverScrollBackground;
    public static Paint mOverScrollBorder;
    public boolean mWrapContent;
    public static final int MOTIONLESS_FALSE = 0;
    public static final int MOTIONLESS_PENDING = 1;
    public static final int MOTIONLESS_TRUE = 2;
    public static final int MOTIONLESS_IGNORE = 3;
    public int mHeldMotionless;
    public AccessibilityInjector mAccessibilityInjector;
    public boolean mAccessibilityScriptInjected;
    public static final int mHightlightColor = 0x33000000;
    public static final float TOUCH_HIGHLIGHT_ARC = 5.0f;
    public Region mTouchHighlightRegion = new Region();
    public Paint mTouchHightlightPaint;
    public static final boolean DEBUG_TOUCH_HIGHLIGHT = true;
    public static final int TOUCH_HIGHLIGHT_ELAPSE_TIME = 2000;
    public Paint mTouchCrossHairColor;
    public int mTouchHighlightX;
    public int mTouchHighlightY;
    public static final int REMEMBER_PASSWORD = 1;
    public static final int NEVER_REMEMBER_PASSWORD = 2;
    public static final int SWITCH_TO_SHORTPRESS = 3;
    public static final int SWITCH_TO_LONGPRESS = 4;
    public static final int RELEASE_SINGLE_TAP = 5;
    public static final int REQUEST_FORM_DATA = 6;
    public static final int RESUME_WEBCORE_PRIORITY = 7;
    public static final int DRAG_HELD_MOTIONLESS = 8;
    public static final int AWAKEN_SCROLL_BARS = 9;
    public static final int PREVENT_DEFAULT_TIMEOUT = 10;
    public static final int SCROLL_SELECT_TEXT = 11;
    public static final int FIRST_PRIVATE_MSG_ID = 1;
    public static final int LAST_PRIVATE_MSG_ID = 11;
    public static final int SCROLL_TO_MSG_ID = 101;
    public static final int SCROLL_BY_MSG_ID = 102;
    public static final int SPAWN_SCROLL_TO_MSG_ID = 103;
    public static final int SYNC_SCROLL_TO_MSG_ID = 104;
    public static final int NEW_PICTURE_MSG_ID = 105;
    public static final int UPDATE_TEXT_ENTRY_MSG_ID = 106;
    public static final int WEBCORE_INITIALIZED_MSG_ID = 107;
    public static final int UPDATE_TEXTFIELD_TEXT_MSG_ID = 108;
    public static final int UPDATE_ZOOM_RANGE = 109;
    public static final int UNHANDLED_NAV_KEY = 110;
    public static final int CLEAR_TEXT_ENTRY = 111;
    public static final int UPDATE_TEXT_SELECTION_MSG_ID = 112;
    public static final int SHOW_RECT_MSG_ID = 113;
    public static final int LONG_PRESS_CENTER = 114;
    public static final int PREVENT_TOUCH_ID = 115;
    public static final int WEBCORE_NEED_TOUCH_EVENTS = 116;
    public static final int INVAL_RECT_MSG_ID = 117;
    public static final int REQUEST_KEYBOARD = 118;
    public static final int DO_MOTION_UP = 119;
    public static final int SHOW_FULLSCREEN = 120;
    public static final int HIDE_FULLSCREEN = 121;
    public static final int DOM_FOCUS_CHANGED = 122;
    public static final int REPLACE_BASE_CONTENT = 123;
    public static final int FORM_DID_BLUR = 124;
    public static final int RETURN_LABEL = 125;
    public static final int FIND_AGAIN = 126;
    public static final int CENTER_FIT_RECT = 127;
    public static final int REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID = 128;
    public static final int SET_SCROLLBAR_MODES = 129;
    public static final int SELECTION_STRING_CHANGED = 130;
    public static final int SET_TOUCH_HIGHLIGHT_RECTS = 131;
    public static final int SAVE_WEBARCHIVE_FINISHED = 132;
    public static final int SET_AUTOFILLABLE = 133;
    public static final int AUTOFILL_COMPLETE = 134;
    public static final int SELECT_AT = 135;
    public static final int SCREEN_ON = 136;
    public static final int FIRST_PACKAGE_MSG_ID = 101;
    public static final int LAST_PACKAGE_MSG_ID = 131;
    public static final String[] HandlerPrivateDebugString;
    public static final String[] HandlerPackageDebugString;
    public static final int DEFAULT_VIEWPORT_WIDTH = 980;
    public static int sMaxViewportWidth;
    public int mInitialScaleInPercent = 0;
    public boolean mUserScroll = false;
    public int mSnapScrollMode = 0;
    public static final int SNAP_NONE = 0;
    public static final int SNAP_LOCK = 1;
    public static final int SNAP_X = 2;
    public static final int SNAP_Y = 4;
    public boolean mSnapPositive;
    public static final int DRAW_EXTRAS_NONE = 0;
    public static final int DRAW_EXTRAS_FIND = 1;
    public static final int DRAW_EXTRAS_SELECTION = 2;
    public static final int DRAW_EXTRAS_CURSOR_RING = 3;
    public static final int SCROLLBAR_AUTO = 0;
    public static final int SCROLLBAR_ALWAYSOFF = 1;
    public static final int SCROLLBAR_ALWAYSON = 2;
    public int mHorizontalScrollBarMode = 0;
    public int mVerticalScrollBarMode = 0;
    public static final int ACCESSIBILITY_SCRIPT_INJECTION_UNDEFINED = -1;
    public static final int ACCESSIBILITY_SCRIPT_INJECTION_OPTED_OUT = 0;
    public static final int ACCESSIBILITY_SCRIPT_INJECTION_PROVIDED = 1;
    public static final String ALIAS_ACCESSIBILITY_JS_INTERFACE = "accessibility";
    public static final String ACCESSIBILITY_SCRIPT_CHOOSER_JAVASCRIPT = "javascript:(function() {    var chooser = document.createElement('script');    chooser.type = 'text/javascript';    chooser.src = 'https://ssl.gstatic.com/accessibility/javascript/android/AndroidScriptChooser.user.js';    document.getElementsByTagName('head')[0].appendChild(chooser);  })();";
    public static final String PATTERN_MATCH_AXS_URL_PARAMETER = "(\\?axs=(0|1))|(&axs=(0|1))";
    public Pattern mMatchAxsUrlParameterPattern;
    public int mOverscrollDistance;
    public int mOverflingDistance;
    public OverScrollGlow mOverScrollGlow;
    public boolean mGotKeyDown;
    public static boolean mLogEvent;
    public long mLastTouchUpTime = 0L;
    public WebViewCore.AutoFillData mAutoFillData;
    public static final String SCHEME_TEL = "tel:";
    public static final String SCHEME_MAILTO = "mailto:";
    public static final String SCHEME_GEO = "geo:0,0?q=";
    public int mBackgroundColor = -1;
    public static final long SELECT_SCROLL_INTERVAL = 16L;
    public int mAutoScrollX = 0;
    public int mAutoScrollY = 0;
    public int mMinAutoScrollX = 0;
    public int mMaxAutoScrollX = 0;
    public int mMinAutoScrollY = 0;
    public int mMaxAutoScrollY = 0;
    public Rect mScrollingLayerBounds = new Rect();
    public boolean mSentAutoScrollMessage = false;
    public PictureListener mPictureListener;
    public static boolean sProxyReceiverAdded;
    public static boolean sPackageInstallationReceiverAdded;
    public static Set<String> sGoogleApps;
    public View mTitleBar;
    public Rect mLastVisibleRectSent;
    public Rect mLastGlobalRect;
    public FindActionModeCallback mFindCallback;
    public boolean mFindIsUp;
    public String mLastFind;
    public String mPageThatNeedsToSlideTitleBarOffScreen;
    public int mYDistanceToSlideTitleOffScreen;
    public int mOrientation = 0;
    public SelectActionModeCallback mSelectCallback;
    public static final int FULLY_ON_SCREEN = 0;
    public static final int INTERSECTS_SCREEN = 1;
    public static final int ANYWHERE = 2;
    public static final int ZOOM_BITS = 134;
    public static final int SCROLL_BITS = 6;
    public final DrawFilter mZoomFilter = new PaintFlagsDrawFilter(134, 64);
    public final DrawFilter mScrollFilter = new PaintFlagsDrawFilter(6, 0);
    public boolean mDrawHistory = false;
    public Picture mHistoryPicture = null;
    public int mHistoryWidth = 0;
    public int mHistoryHeight = 0;
    public boolean mGotCenterDown = false;
    public int mMinLockSnapReverseDistance;
    public static final float MAX_SLOPE_FOR_DIAG = 1.5f;
    public static final int MIN_BREAK_SNAP_CROSS_DISTANCE = 80;
    public float DRAG_LAYER_INVERSE_DENSITY_SQUARED;
    public static final int DRAG_LAYER_FINGER_DISTANCE = 20000;
    public long mTrackballFirstTime = 0L;
    public long mTrackballLastTime = 0L;
    public float mTrackballRemainsX = 0.0f;
    public float mTrackballRemainsY = 0.0f;
    public int mTrackballXMove = 0;
    public int mTrackballYMove = 0;
    public boolean mSelectingText = false;
    public boolean mSelectionStarted = false;
    public boolean mExtendSelection = false;
    public boolean mDrawSelectionPointer = false;
    public static final int TRACKBALL_KEY_TIMEOUT = 1000;
    public static final int TRACKBALL_TIMEOUT = 200;
    public static final int TRACKBALL_WAIT = 100;
    public static final int TRACKBALL_SCALE = 400;
    public static final int TRACKBALL_SCROLL_COUNT = 5;
    public static final int TRACKBALL_MOVE_COUNT = 10;
    public static final int TRACKBALL_MULTIPLIER = 3;
    public static final int SELECT_CURSOR_OFFSET = 16;
    public static final int SELECT_SCROLL = 5;
    public int mSelectX = 0;
    public int mSelectY = 0;
    public boolean mFocusSizeChanged = false;
    public boolean mTrackballDown = false;
    public long mTrackballUpTime = 0L;
    public long mLastCursorTime = 0L;
    public Rect mLastCursorBounds;
    public boolean mMapTrackballToArrowKeys = true;
    public Message mListBoxMessage;
    public static final int NO_LEFTEDGE = -1;

    public void incrementTextGeneration() {
        ++this.mTextGeneration;
    }

    public _Original_WebView(Context context) {
        this(context, null);
    }

    public _Original_WebView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842885);
    }

    public _Original_WebView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, false);
    }

    public _Original_WebView(Context context, AttributeSet attrs, int defStyle, boolean privateBrowsing) {
        this(context, attrs, defStyle, null, privateBrowsing);
    }

    public _Original_WebView(Context context, AttributeSet attrs, int defStyle, Map<String, Object> javaScriptInterfaces, boolean privateBrowsing) {
        super(context, attrs, defStyle);
        JniUtil.setContext(context);
        if (AccessibilityManager.getInstance(context).isEnabled()) {
            if (javaScriptInterfaces == null) {
                javaScriptInterfaces = new HashMap<String, Object>();
            }
            this.exposeAccessibilityJavaScriptApi(javaScriptInterfaces);
        }
        this.mCallbackProxy = new CallbackProxy(context, this);
        this.mViewManager = new ViewManager(this);
        L10nUtils.loadStrings(context);
        this.mWebViewCore = new WebViewCore(context, this, this.mCallbackProxy, javaScriptInterfaces);
        this.mDatabase = WebViewDatabase.getInstance(context);
        this.mScroller = new OverScroller(context, null, 0.0f, 0.0f, false);
        this.mZoomManager = new ZoomManager(this, this.mCallbackProxy);
        this.init();
        this.setupPackageListener(context);
        _Original_WebView.setupProxyListener(context);
        this.updateMultiTouchSupport(context);
        if (privateBrowsing) {
            this.startPrivateBrowsing();
        }
        this.mAutoFillData = new WebViewCore.AutoFillData();
    }

    public static synchronized void setupProxyListener(Context context) {
        if (sProxyReceiverAdded) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PROXY_CHANGE");
        Intent currentProxy = context.getApplicationContext().registerReceiver(new ProxyReceiver(null), filter);
        sProxyReceiverAdded = true;
        if (currentProxy != null) {
            _Original_WebView.handleProxyBroadcast(currentProxy);
        }
    }

    public static void handleProxyBroadcast(Intent intent) {
        ProxyProperties proxyProperties = (ProxyProperties)intent.getExtra("proxy");
        if (proxyProperties == null || proxyProperties.getHost() == null) {
            WebViewCore.sendStaticMessage(193, "");
            return;
        }
        String host = proxyProperties.getHost();
        int port = proxyProperties.getPort();
        if (port != 0) {
            host = host + ":" + port;
        }
        String exclusionList = proxyProperties.getExclusionList();
        WebViewCore.sendStaticMessage(193, host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupPackageListener(Context context) {
        Class<_Original_WebView> clazz = _Original_WebView.class;
        synchronized (_Original_WebView.class) {
            if (sPackageInstallationReceiverAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addDataScheme("package");
            PackageListener packageListener = new PackageListener(null);
            context.getApplicationContext().registerReceiver(packageListener, filter);
            sPackageInstallationReceiverAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            _Original_WebView$1 task = new _Original_WebView$1(this);
            task.execute(new Void[0]);
            return;
        }
    }

    public void updateMultiTouchSupport(Context context) {
        this.mZoomManager.updateMultiTouchSupport(context);
    }

    public void init() {
        this.setWillNotDraw(false);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setClickable(true);
        this.setLongClickable(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.getContext());
        int slop = configuration.getScaledTouchSlop();
        this.mTouchSlopSquare = slop * slop;
        this.mMinLockSnapReverseDistance = slop;
        slop = configuration.getScaledDoubleTapSlop();
        this.mDoubleTapSlopSquare = slop * slop;
        float density = this.getContext().getResources().getDisplayMetrics().density;
        this.mNavSlop = (int)(16.0f * density);
        this.mZoomManager.init(density);
        this.mMaximumFling = configuration.getScaledMaximumFlingVelocity();
        this.DRAG_LAYER_INVERSE_DENSITY_SQUARED = 1.0f / (density * density);
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
    }

    public void exposeAccessibilityJavaScriptApi(Map<String, Object> javaScriptInterfaces) {
        if (javaScriptInterfaces.containsKey(ALIAS_ACCESSIBILITY_JS_INTERFACE)) {
            Log.w(LOGTAG, "JavaScript interface mapped to \"accessibility\" overrides the accessibility API JavaScript interface. No accessibilityAPI will be exposed to JavaScript!");
            return;
        }
        javaScriptInterfaces.put(ALIAS_ACCESSIBILITY_JS_INTERFACE, new TextToSpeech(this.getContext(), null));
    }

    @Override
    public void setOverScrollMode(int mode) {
        super.setOverScrollMode(mode);
        if (mode != 2) {
            if (this.mOverScrollGlow == null) {
                this.mOverScrollGlow = new OverScrollGlow(this);
            }
        } else {
            this.mOverScrollGlow = null;
        }
    }

    public void updateDefaultZoomDensity(int zoomDensity) {
        float density = this.mContext.getResources().getDisplayMetrics().density * 100.0f / (float)zoomDensity;
        this.mNavSlop = (int)(16.0f * density);
        this.mZoomManager.updateDefaultZoomDensity(density);
    }

    public boolean onSavePassword(String schemePlusHost, String username, String password, Message resumeMsg) {
        boolean rVal = false;
        if (resumeMsg == null) {
            this.mDatabase.setUsernamePassword(schemePlusHost, username, password);
        } else {
            Message remember = this.mPrivateHandler.obtainMessage(1);
            remember.getData().putString("host", schemePlusHost);
            remember.getData().putString("username", username);
            remember.getData().putString("password", password);
            remember.obj = resumeMsg;
            Message neverRemember = this.mPrivateHandler.obtainMessage(2);
            neverRemember.getData().putString("host", schemePlusHost);
            neverRemember.getData().putString("username", username);
            neverRemember.getData().putString("password", password);
            neverRemember.obj = resumeMsg;
            new AlertDialog.Builder(this.getContext()).setTitle(17040089).setMessage(17040105).setPositiveButton(17040106, (DialogInterface.OnClickListener)new _Original_WebView$5(this, resumeMsg)).setNeutralButton(17040107, (DialogInterface.OnClickListener)new _Original_WebView$4(this, remember)).setNegativeButton(17040108, (DialogInterface.OnClickListener)new _Original_WebView$3(this, neverRemember)).setOnCancelListener(new _Original_WebView$2(this, resumeMsg)).show();
            rVal = true;
        }
        return rVal;
    }

    @Override
    public void setScrollBarStyle(int style2) {
        if (style2 == 0x1000000 || style2 == 0x3000000) {
            this.mOverlayVerticalScrollbar = false;
            this.mOverlayHorizontalScrollbar = false;
        } else {
            this.mOverlayVerticalScrollbar = true;
            this.mOverlayHorizontalScrollbar = true;
        }
        super.setScrollBarStyle(style2);
    }

    public void setHorizontalScrollbarOverlay(boolean overlay) {
        this.mOverlayHorizontalScrollbar = overlay;
    }

    public void setVerticalScrollbarOverlay(boolean overlay) {
        this.mOverlayVerticalScrollbar = overlay;
    }

    public boolean overlayHorizontalScrollbar() {
        return this.mOverlayHorizontalScrollbar;
    }

    public boolean overlayVerticalScrollbar() {
        return this.mOverlayVerticalScrollbar;
    }

    public int getViewWidth() {
        if (!this.isVerticalScrollBarEnabled() || this.mOverlayVerticalScrollbar) {
            return this.getWidth();
        }
        return Math.max(0, this.getWidth() - this.getVerticalScrollbarWidth());
    }

    public int getTitleHeight() {
        return this.mTitleBar != null ? this.mTitleBar.getHeight() : 0;
    }

    public int getVisibleTitleHeight() {
        return Math.max(this.getTitleHeight() - Math.max(0, this.mScrollY), 0);
    }

    public int getViewHeight() {
        return this.getViewHeightWithTitle() - this.getVisibleTitleHeight();
    }

    public int getViewHeightWithTitle() {
        int height = this.getHeight();
        if (this.isHorizontalScrollBarEnabled() && !this.mOverlayHorizontalScrollbar) {
            height -= this.getHorizontalScrollbarHeight();
        }
        return height;
    }

    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    public void setCertificate(SslCertificate certificate) {
        this.mCertificate = certificate;
    }

    public void savePassword(String host, String username, String password) {
        this.mDatabase.setUsernamePassword(host, username, password);
    }

    public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        this.mDatabase.setHttpAuthUsernamePassword(host, realm, username, password);
    }

    public String[] getHttpAuthUsernamePassword(String host, String realm) {
        return this.mDatabase.getHttpAuthUsernamePassword(host, realm);
    }

    public void clearActionModes() {
        if (this.mSelectCallback != null) {
            this.mSelectCallback.finish();
        }
        if (this.mFindCallback != null) {
            this.mFindCallback.finish();
        }
    }

    public void clearHelpers() {
        this.clearTextEntry();
        this.clearActionModes();
        this.dismissFullScreenMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.clearHelpers();
        if (this.mListBoxDialog != null) {
            this.mListBoxDialog.dismiss();
            this.mListBoxDialog = null;
        }
        if (this.mNativeClass != 0) {
            this.nativeStopGL();
        }
        if (this.mWebViewCore != null) {
            this.mCallbackProxy.setWebViewClient(null);
            this.mCallbackProxy.setWebChromeClient(null);
            Object object = this;
            synchronized (object) {
                WebViewCore webViewCore = this.mWebViewCore;
                this.mWebViewCore = null;
                webViewCore.destroy();
            }
            this.mPrivateHandler.removeCallbacksAndMessages(null);
            this.mCallbackProxy.removeCallbacksAndMessages(null);
            object = this.mCallbackProxy;
            synchronized (object) {
                this.mCallbackProxy.notify();
            }
        }
        if (this.mNativeClass != 0) {
            this.nativeDestroy();
            this.mNativeClass = 0;
        }
    }

    public static void enablePlatformNotifications() {
        Network.enablePlatformNotifications();
    }

    public static void disablePlatformNotifications() {
        Network.disablePlatformNotifications();
    }

    public void setJsFlags(String flags) {
        this.mWebViewCore.sendMessage(174, flags);
    }

    public void setNetworkAvailable(boolean networkUp) {
        this.mWebViewCore.sendMessage(119, networkUp ? 1 : 0, 0);
    }

    public void setNetworkType(String type, String subtype) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        map.put("subtype", subtype);
        this.mWebViewCore.sendMessage(183, map);
    }

    public WebBackForwardList saveState(Bundle outState) {
        if (outState == null) {
            return null;
        }
        WebBackForwardList list = this.copyBackForwardList();
        int currentIndex = list.getCurrentIndex();
        int size = list.getSize();
        if (currentIndex < 0 || currentIndex >= size || size == 0) {
            return null;
        }
        outState.putInt("index", currentIndex);
        ArrayList<byte[]> history = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            WebHistoryItem item = list.getItemAtIndex(i);
            if (null == item) {
                Log.w(LOGTAG, "saveState: Unexpected null history item.");
                return null;
            }
            byte[] data = item.getFlattenedData();
            if (data == null) {
                return null;
            }
            history.add(data);
        }
        outState.putSerializable("history", history);
        if (this.mCertificate != null) {
            outState.putBundle("certificate", SslCertificate.saveState(this.mCertificate));
        }
        outState.putBoolean("privateBrowsingEnabled", this.isPrivateBrowsingEnabled());
        this.mZoomManager.saveZoomState(outState);
        return list;
    }

    public boolean savePicture(Bundle b, File dest) {
        if (dest == null || b == null) {
            return false;
        }
        Picture p = this.capturePicture();
        File temp = new File(dest.getPath() + ".writing");
        new Thread(new _Original_WebView$6(this, temp, p, dest)).start();
        b.putInt("scrollX", this.mScrollX);
        b.putInt("scrollY", this.mScrollY);
        this.mZoomManager.saveZoomState(b);
        return true;
    }

    public void restoreHistoryPictureFields(Picture p, Bundle b) {
        int sx = b.getInt("scrollX", 0);
        int sy = b.getInt("scrollY", 0);
        this.mDrawHistory = true;
        this.mHistoryPicture = p;
        this.mScrollX = sx;
        this.mScrollY = sy;
        this.mZoomManager.restoreZoomState(b);
        float scale = this.mZoomManager.getScale();
        this.mHistoryWidth = Math.round((float)p.getWidth() * scale);
        this.mHistoryHeight = Math.round((float)p.getHeight() * scale);
        this.invalidate();
    }

    public boolean restorePicture(Bundle b, File src) {
        if (src == null || b == null) {
            return false;
        }
        if (!src.exists()) {
            return false;
        }
        try {
            FileInputStream in = new FileInputStream(src);
            Bundle copy = new Bundle(b);
            new Thread(new _Original_WebView$7(this, in, copy)).start();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBackForwardList restoreState(Bundle inState) {
        WebBackForwardList returnList = null;
        if (inState == null) {
            return returnList;
        }
        if (inState.containsKey("index") && inState.containsKey("history")) {
            this.mCertificate = SslCertificate.restoreState(inState.getBundle("certificate"));
            WebBackForwardList list = this.mCallbackProxy.getBackForwardList();
            int index = inState.getInt("index");
            WebBackForwardList webBackForwardList = list;
            synchronized (webBackForwardList) {
                List history = (List)((Object)inState.getSerializable("history"));
                int size = history.size();
                if (index < 0 || index >= size) {
                    return null;
                }
                for (int i = 0; i < size; ++i) {
                    byte[] data = (byte[])history.remove(0);
                    if (data == null) {
                        return null;
                    }
                    WebHistoryItem item = new WebHistoryItem(data);
                    list.addHistoryItem(item);
                }
                returnList = this.copyBackForwardList();
                returnList.setCurrentIndex(index);
            }
            if (inState.getBoolean("privateBrowsingEnabled")) {
                this.getSettings().setPrivateBrowsingEnabled(true);
            }
            this.mZoomManager.restoreZoomState(inState);
            this.mWebViewCore.removeMessages();
            this.mWebViewCore.sendMessage(108, index);
        }
        return returnList;
    }

    public void loadUrl(String url, Map<String, String> extraHeaders) {
        this.switchOutDrawHistory();
        WebViewCore.GetUrlData arg = new WebViewCore.GetUrlData();
        arg.mUrl = url;
        arg.mExtraHeaders = extraHeaders;
        this.mWebViewCore.sendMessage(100, arg);
        this.clearHelpers();
    }

    public void loadUrl(String url) {
        if (url == null) {
            return;
        }
        this.loadUrl(url, null);
    }

    public void postUrl(String url, byte[] postData) {
        if (URLUtil.isNetworkUrl(url)) {
            this.switchOutDrawHistory();
            WebViewCore.PostUrlData arg = new WebViewCore.PostUrlData();
            arg.mUrl = url;
            arg.mPostData = postData;
            this.mWebViewCore.sendMessage(132, arg);
            this.clearHelpers();
        } else {
            this.loadUrl(url);
        }
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.loadUrl("data:" + mimeType + ";" + encoding + "," + data);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        if (baseUrl != null && baseUrl.toLowerCase().startsWith("data:")) {
            this.loadData(data, mimeType, encoding);
            return;
        }
        this.switchOutDrawHistory();
        WebViewCore.BaseUrlData arg = new WebViewCore.BaseUrlData();
        arg.mBaseUrl = baseUrl;
        arg.mData = data;
        arg.mMimeType = mimeType;
        arg.mEncoding = encoding;
        arg.mHistoryUrl = historyUrl;
        this.mWebViewCore.sendMessage(139, arg);
        this.clearHelpers();
    }

    public void saveWebArchive(String filename) {
        this.saveWebArchive(filename, false, null);
    }

    public void saveWebArchive(String basename, boolean autoname, ValueCallback<String> callback) {
        this.mWebViewCore.sendMessage(147, new SaveWebArchiveMessage(basename, autoname, callback));
    }

    public void stopLoading() {
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(101);
    }

    public void reload() {
        this.clearHelpers();
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoBack() {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() > 0;
        }
    }

    public void goBack() {
        this.goBackOrForward(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoForward() {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() < l.getSize() - 1;
        }
    }

    public void goForward() {
        this.goBackOrForward(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoBackOrForward(int steps) {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            int newIndex = l.getCurrentIndex() + steps;
            return newIndex >= 0 && newIndex < l.getSize();
        }
    }

    public void goBackOrForward(int steps) {
        this.goBackOrForward(steps, false);
    }

    public void goBackOrForward(int steps, boolean ignoreSnapshot) {
        if (steps != 0) {
            this.clearHelpers();
            this.mWebViewCore.sendMessage(106, steps, ignoreSnapshot ? 1 : 0);
        }
    }

    public boolean isPrivateBrowsingEnabled() {
        return this.getSettings().isPrivateBrowsingEnabled();
    }

    public void startPrivateBrowsing() {
        this.getSettings().setPrivateBrowsingEnabled(true);
    }

    public boolean extendScroll(int y) {
        int finalY = this.mScroller.getFinalY();
        int newY = this.pinLocY(finalY + y);
        if (newY == finalY) {
            return false;
        }
        this.mScroller.setFinalY(newY);
        this.mScroller.extendDuration(_Original_WebView.computeDuration(0, y));
        return true;
    }

    public boolean pageUp(boolean top) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (top) {
            return this.pinScrollTo(this.mScrollX, 0, true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? -h + 24 : -h / 2;
        this.mUserScroll = true;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    public boolean pageDown(boolean bottom) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (bottom) {
            return this.pinScrollTo(this.mScrollX, this.computeRealVerticalScrollRange(), true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? h - 24 : h / 2;
        this.mUserScroll = true;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    public void clearView() {
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        this.setBaseLayer(0, null);
        this.mWebViewCore.sendMessage(134);
    }

    public Picture capturePicture() {
        if (this.mNativeClass == 0) {
            return null;
        }
        Picture result = new Picture();
        this.nativeCopyBaseContentToPicture(result);
        return result;
    }

    public boolean inEditingMode() {
        return this.mWebTextView != null && this.mWebTextView.getParent() != null;
    }

    public void clearTextEntry() {
        if (this.inEditingMode()) {
            this.mWebTextView.remove();
        } else {
            this.hideSoftKeyboard();
        }
    }

    public float getScale() {
        return this.mZoomManager.getScale();
    }

    public void setInitialScale(int scaleInPercent) {
        this.mZoomManager.setInitialScaleInPercent(scaleInPercent);
    }

    public void invokeZoomPicker() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return;
        }
        this.clearHelpers();
        this.mZoomManager.invokeZoomPicker();
    }

    public HitTestResult getHitTestResult() {
        return this.hitTestResult(this.mInitialHitTestResult);
    }

    public HitTestResult hitTestResult(HitTestResult fallback) {
        int contentY;
        int contentX;
        String text;
        if (this.mNativeClass == 0) {
            return null;
        }
        HitTestResult result = new HitTestResult();
        if (this.nativeHasCursorNode()) {
            if (this.nativeCursorIsTextInput()) {
                result.setType(9);
            } else {
                String text2 = this.nativeCursorText();
                if (text2 != null) {
                    if (text2.startsWith(SCHEME_TEL)) {
                        result.setType(2);
                        result.setExtra(text2.substring(SCHEME_TEL.length()));
                    } else if (text2.startsWith(SCHEME_MAILTO)) {
                        result.setType(4);
                        result.setExtra(text2.substring(SCHEME_MAILTO.length()));
                    } else if (text2.startsWith(SCHEME_GEO)) {
                        result.setType(3);
                        result.setExtra(URLDecoder.decode(text2.substring(SCHEME_GEO.length())));
                    } else if (this.nativeCursorIsAnchor()) {
                        result.setType(7);
                        result.setExtra(text2);
                    }
                }
            }
        } else if (fallback != null) {
            Log.v(LOGTAG, "hitTestResult use fallback");
            result = fallback;
        }
        int type = result.getType();
        if ((type == 0 || type == 7) && (text = this.nativeImageURI(contentX = this.viewToContentX(this.mLastTouchX + this.mScrollX), contentY = this.viewToContentY(this.mLastTouchY + this.mScrollY))) != null) {
            result.setType(type == 0 ? 5 : 8);
            result.setExtra(text);
        }
        return result;
    }

    public void domChangedFocus() {
        if (this.inEditingMode()) {
            this.mPrivateHandler.obtainMessage(122).sendToTarget();
        }
    }

    public void requestFocusNodeHref(Message hrefMsg) {
        if (hrefMsg == null) {
            return;
        }
        int contentX = this.viewToContentX(this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY(this.mLastTouchY + this.mScrollY);
        this.mWebViewCore.sendMessage(137, contentX, contentY, hrefMsg);
    }

    public void requestImageRef(Message msg) {
        if (0 == this.mNativeClass) {
            return;
        }
        int contentX = this.viewToContentX(this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY(this.mLastTouchY + this.mScrollY);
        String ref = this.nativeImageURI(contentX, contentY);
        Bundle data = msg.getData();
        data.putString("url", ref);
        msg.setData(data);
        msg.sendToTarget();
    }

    public static int pinLoc(int x, int viewMax, int docMax) {
        if (docMax < viewMax) {
            x = 0;
        } else if (x < 0) {
            x = 0;
        } else if (x + viewMax > docMax) {
            x = docMax - viewMax;
        }
        return x;
    }

    public int pinLocX(int x) {
        if (this.mInOverScrollMode) {
            return x;
        }
        return _Original_WebView.pinLoc(x, this.getViewWidth(), this.computeRealHorizontalScrollRange());
    }

    public int pinLocY(int y) {
        if (this.mInOverScrollMode) {
            return y;
        }
        return _Original_WebView.pinLoc(y, this.getViewHeightWithTitle(), this.computeRealVerticalScrollRange() + this.getTitleHeight());
    }

    public void setEmbeddedTitleBar(View v) {
        if (this.mTitleBar == v) {
            return;
        }
        if (this.mTitleBar != null) {
            this.removeView(this.mTitleBar);
        }
        if (null != v) {
            this.addView(v, new AbsoluteLayout.LayoutParams(-1, -2, 0, 0));
        }
        this.mTitleBar = v;
    }

    public int viewToContentDimension(int d) {
        return Math.round((float)d * this.mZoomManager.getInvScale());
    }

    public int viewToContentX(int x) {
        return this.viewToContentDimension(x);
    }

    public int viewToContentY(int y) {
        return this.viewToContentDimension(y - this.getTitleHeight());
    }

    public float viewToContentXf(int x) {
        return (float)x * this.mZoomManager.getInvScale();
    }

    public float viewToContentYf(int y) {
        return (float)(y - this.getTitleHeight()) * this.mZoomManager.getInvScale();
    }

    public int contentToViewDimension(int d) {
        return Math.round((float)d * this.mZoomManager.getScale());
    }

    public int contentToViewX(int x) {
        return this.contentToViewDimension(x);
    }

    public int contentToViewY(int y) {
        return this.contentToViewDimension(y) + this.getTitleHeight();
    }

    public Rect contentToViewRect(Rect x) {
        return new Rect(this.contentToViewX(x.left), this.contentToViewY(x.top), this.contentToViewX(x.right), this.contentToViewY(x.bottom));
    }

    public void viewInvalidate(int l, int t, int r, int b) {
        float scale = this.mZoomManager.getScale();
        int dy = this.getTitleHeight();
        this.invalidate((int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    public void viewInvalidateDelayed(long delay, int l, int t, int r, int b) {
        float scale = this.mZoomManager.getScale();
        int dy = this.getTitleHeight();
        this.postInvalidateDelayed(delay, (int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    public void invalidateContentRect(Rect r) {
        this.viewInvalidate(r.left, r.top, r.right, r.bottom);
    }

    public void abortAnimation() {
        this.mScroller.abortAnimation();
        this.mLastVelocity = 0.0f;
    }

    public void recordNewContentSize(int w, int h, boolean updateLayout) {
        if ((w | h) == 0) {
            return;
        }
        if (this.mContentWidth != w || this.mContentHeight != h) {
            this.mContentWidth = w;
            this.mContentHeight = h;
            if (!this.mDrawHistory) {
                this.updateScrollCoordinates(this.pinLocX(this.mScrollX), this.pinLocY(this.mScrollY));
                if (!this.mScroller.isFinished()) {
                    this.mScroller.setFinalX(this.pinLocX(this.mScroller.getFinalX()));
                    this.mScroller.setFinalY(this.pinLocY(this.mScroller.getFinalY()));
                }
            }
        }
        this.contentSizeChanged(updateLayout);
    }

    public Rect sendOurVisibleRect() {
        Rect globalRect;
        if (this.mZoomManager.isPreventingWebkitUpdates()) {
            return this.mLastVisibleRectSent;
        }
        Rect rect = new Rect();
        this.calcOurContentVisibleRect(rect);
        if (!rect.equals(this.mLastVisibleRectSent)) {
            Point pos = new Point(rect.left, rect.top);
            this.mWebViewCore.removeMessages(107);
            this.mWebViewCore.sendMessage(107, this.nativeMoveGeneration(), this.mUserScroll ? 1 : 0, pos);
            this.mLastVisibleRectSent = rect;
            this.mPrivateHandler.removeMessages(4);
        }
        if (this.getGlobalVisibleRect(globalRect = new Rect()) && !globalRect.equals(this.mLastGlobalRect)) {
            this.mWebViewCore.sendMessage(116, globalRect);
            this.mLastGlobalRect = globalRect;
        }
        return rect;
    }

    public void calcOurVisibleRect(Rect r) {
        Point p = new Point();
        this.getGlobalVisibleRect(r, p);
        r.offset(-p.x, -p.y);
    }

    public void calcOurContentVisibleRect(Rect r) {
        this.calcOurVisibleRect(r);
        r.left = this.viewToContentX(r.left);
        r.top = this.viewToContentY(r.top + this.getVisibleTitleHeight());
        r.right = this.viewToContentX(r.right);
        r.bottom = this.viewToContentY(r.bottom);
    }

    public void calcOurContentVisibleRectF(RectF r) {
        Rect ri = new Rect(0, 0, 0, 0);
        this.calcOurVisibleRect(ri);
        r.left = this.viewToContentXf(ri.left);
        r.top = this.viewToContentYf(ri.top + this.getVisibleTitleHeight());
        r.right = this.viewToContentXf(ri.right);
        r.bottom = this.viewToContentYf(ri.bottom);
    }

    public boolean sendViewSizeZoom(boolean force) {
        if (this.mZoomManager.isPreventingWebkitUpdates()) {
            return false;
        }
        int viewWidth = this.getViewWidth();
        int newWidth = Math.round((float)viewWidth * this.mZoomManager.getInvScale());
        int newHeight = Math.round((float)(this.getViewHeightWithTitle() - this.getTitleHeight()) * this.mZoomManager.getInvScale());
        if (newWidth > this.mLastWidthSent && this.mWrapContent) {
            newHeight = 0;
        }
        if (newWidth != this.mLastWidthSent || newHeight != this.mLastHeightSent || force) {
            ViewSizeData data = new ViewSizeData();
            data.mWidth = newWidth;
            data.mHeight = newHeight;
            data.mTextWrapWidth = Math.round((float)viewWidth / this.mZoomManager.getTextWrapScale());
            data.mScale = this.mZoomManager.getScale();
            data.mIgnoreHeight = this.mZoomManager.isFixedLengthAnimationInProgress() && !this.mHeightCanMeasure;
            data.mAnchorX = this.mZoomManager.getDocumentAnchorX();
            data.mAnchorY = this.mZoomManager.getDocumentAnchorY();
            this.mWebViewCore.sendMessage(105, data);
            this.mLastWidthSent = newWidth;
            this.mLastHeightSent = newHeight;
            this.mZoomManager.clearDocumentAnchor();
            return true;
        }
        return false;
    }

    public int computeRealHorizontalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryWidth;
        }
        return (int)Math.floor((float)this.mContentWidth * this.mZoomManager.getScale());
    }

    @Override
    public int computeHorizontalScrollRange() {
        int range = this.computeRealHorizontalScrollRange();
        int scrollX = this.mScrollX;
        int overscrollRight = this.computeMaxScrollX();
        if (scrollX < 0) {
            range -= scrollX;
        } else if (scrollX > overscrollRight) {
            range += scrollX - overscrollRight;
        }
        return range;
    }

    @Override
    public int computeHorizontalScrollOffset() {
        return Math.max(this.mScrollX, 0);
    }

    public int computeRealVerticalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryHeight;
        }
        return (int)Math.floor((float)this.mContentHeight * this.mZoomManager.getScale());
    }

    @Override
    public int computeVerticalScrollRange() {
        int range = this.computeRealVerticalScrollRange();
        int scrollY = this.mScrollY;
        int overscrollBottom = this.computeMaxScrollY();
        if (scrollY < 0) {
            range -= scrollY;
        } else if (scrollY > overscrollBottom) {
            range += scrollY - overscrollBottom;
        }
        return range;
    }

    @Override
    public int computeVerticalScrollOffset() {
        return Math.max(this.mScrollY - this.getTitleHeight(), 0);
    }

    @Override
    public int computeVerticalScrollExtent() {
        return this.getViewHeight();
    }

    @Override
    public void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        if (this.mScrollY < 0) {
            t -= this.mScrollY;
        }
        scrollBar.setBounds(l, t + this.getVisibleTitleHeight(), r, b);
        scrollBar.draw(canvas);
    }

    @Override
    public void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (this.mTouchMode == 9) {
            this.nativeScrollLayer(this.mScrollingLayer, scrollX, scrollY);
            this.mScrollingLayerRect.left = scrollX;
            this.mScrollingLayerRect.top = scrollY;
            this.invalidate();
            return;
        }
        this.mInOverScrollMode = false;
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        if (maxX == 0) {
            scrollX = this.pinLocX(scrollX);
        } else if (scrollX < 0 || scrollX > maxX) {
            this.mInOverScrollMode = true;
        }
        if (scrollY < 0 || scrollY > maxY) {
            this.mInOverScrollMode = true;
        }
        int oldX = this.mScrollX;
        int oldY = this.mScrollY;
        super.scrollTo(scrollX, scrollY);
        if (this.mOverScrollGlow != null) {
            this.mOverScrollGlow.pullGlow(this.mScrollX, this.mScrollY, oldX, oldY, maxX, maxY);
        }
    }

    public String getUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getUrl() : null;
    }

    public String getOriginalUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getOriginalUrl() : null;
    }

    public String getTitle() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getTitle() : null;
    }

    public Bitmap getFavicon() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getFavicon() : null;
    }

    public String getTouchIconUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getTouchIconUrl() : null;
    }

    public int getProgress() {
        return this.mCallbackProxy.getProgress();
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    public int getContentWidth() {
        return this.mContentWidth;
    }

    public void pauseTimers() {
        this.mWebViewCore.sendMessage(109);
    }

    public void resumeTimers() {
        this.mWebViewCore.sendMessage(110);
    }

    public void onPause() {
        if (!this.mIsPaused) {
            this.mIsPaused = true;
            this.mWebViewCore.sendMessage(143);
        }
    }

    public void onResume() {
        if (this.mIsPaused) {
            this.mIsPaused = false;
            this.mWebViewCore.sendMessage(144);
        }
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void freeMemory() {
        this.mWebViewCore.sendMessage(145);
    }

    public void clearCache(boolean includeDiskFiles) {
        this.mWebViewCore.sendMessage(111, includeDiskFiles ? 1 : 0, 0);
    }

    public void clearFormData() {
        if (this.inEditingMode()) {
            WebTextView.AutoCompleteAdapter adapter = null;
            this.mWebTextView.setAdapterCustom(adapter);
        }
    }

    public void clearHistory() {
        this.mCallbackProxy.getBackForwardList().setClearPending();
        this.mWebViewCore.sendMessage(112);
    }

    public void clearSslPreferences() {
        this.mWebViewCore.sendMessage(150);
    }

    public WebBackForwardList copyBackForwardList() {
        return this.mCallbackProxy.getBackForwardList().clone();
    }

    public void findNext(boolean forward) {
        if (0 == this.mNativeClass) {
            return;
        }
        this.nativeFindNext(forward);
    }

    public int findAll(String find) {
        if (0 == this.mNativeClass) {
            return 0;
        }
        int result = find != null ? this.nativeFindAll(find.toLowerCase(), find.toUpperCase(), find.equalsIgnoreCase(this.mLastFind)) : 0;
        this.invalidate();
        this.mLastFind = find;
        return result;
    }

    public boolean showFindDialog(String text, boolean showIme) {
        FindActionModeCallback callback = new FindActionModeCallback(this.mContext);
        if (this.startActionMode(callback) == null) {
            return false;
        }
        this.mFindCallback = callback;
        this.setFindIsUp(true);
        this.mFindCallback.setWebView(this);
        if (showIme) {
            this.mFindCallback.showSoftInput();
        } else if (text != null) {
            this.mFindCallback.setText(text);
            this.mFindCallback.findAll();
            return true;
        }
        if (text == null) {
            text = this.mLastFind;
        }
        if (text != null) {
            this.mFindCallback.setText(text);
        }
        return true;
    }

    public void setFindIsUp(boolean isUp) {
        this.mFindIsUp = isUp;
        if (0 == this.mNativeClass) {
            return;
        }
        this.nativeSetFindIsUp(isUp);
    }

    public int findIndex() {
        if (0 == this.mNativeClass) {
            return -1;
        }
        return this.nativeFindIndex();
    }

    public static String findAddress(String addr) {
        return _Original_WebView.findAddress(addr, false);
    }

    public static String findAddress(String addr, boolean caseInsensitive) {
        return WebViewCore.nativeFindAddress(addr, caseInsensitive);
    }

    public void clearMatches() {
        if (this.mNativeClass == 0) {
            return;
        }
        this.nativeSetFindIsEmpty();
        this.invalidate();
    }

    public void notifyFindDialogDismissed() {
        this.mFindCallback = null;
        if (this.mWebViewCore == null) {
            return;
        }
        this.clearMatches();
        this.setFindIsUp(false);
        this.pinScrollTo(this.mScrollX, this.mScrollY, false, 0);
        this.invalidate();
    }

    public void documentHasImages(Message response) {
        if (response == null) {
            return;
        }
        this.mWebViewCore.sendMessage(120, response);
    }

    public void stopScroll() {
        this.mScroller.forceFinished(true);
        this.mLastVelocity = 0.0f;
    }

    @Override
    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            this.invalidate();
            if (!this.mScroller.isFinished()) {
                int rangeX = this.computeMaxScrollX();
                int rangeY = this.computeMaxScrollY();
                int overflingDistance = this.mOverflingDistance;
                if (this.mTouchMode == 9) {
                    oldX = this.mScrollingLayerRect.left;
                    oldY = this.mScrollingLayerRect.top;
                    rangeX = this.mScrollingLayerRect.right;
                    rangeY = this.mScrollingLayerRect.bottom;
                    overflingDistance = 0;
                }
                this.overScrollBy(x - oldX, y - oldY, oldX, oldY, rangeX, rangeY, overflingDistance, overflingDistance, false);
                if (this.mOverScrollGlow != null) {
                    this.mOverScrollGlow.absorbGlow(x, y, oldX, oldY, rangeX, rangeY);
                }
            } else {
                if (this.mTouchMode != 9) {
                    this.mScrollX = x;
                    this.mScrollY = y;
                } else {
                    this.nativeScrollLayer(this.mScrollingLayer, x, y);
                    this.mScrollingLayerRect.left = x;
                    this.mScrollingLayerRect.top = y;
                }
                this.abortAnimation();
                this.mPrivateHandler.removeMessages(7);
                WebViewCore.resumePriority();
                if (!this.mSelectingText) {
                    WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                }
            }
        } else {
            super.computeScroll();
        }
    }

    public static int computeDuration(int dx, int dy) {
        int distance = Math.max(Math.abs(dx), Math.abs(dy));
        int duration = distance * 1000 / 480;
        return Math.min(duration, 750);
    }

    public boolean pinScrollBy(int dx, int dy, boolean animate, int animationDuration) {
        return this.pinScrollTo(this.mScrollX + dx, this.mScrollY + dy, animate, animationDuration);
    }

    public boolean pinScrollTo(int x, int y, boolean animate, int animationDuration) {
        int dy;
        int dx = (x = this.pinLocX(x)) - this.mScrollX;
        if ((dx | (dy = (y = this.pinLocY(y)) - this.mScrollY)) == 0) {
            return false;
        }
        this.abortAnimation();
        if (animate) {
            this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy, animationDuration > 0 ? animationDuration : _Original_WebView.computeDuration(dx, dy));
            this.awakenScrollBars(this.mScroller.getDuration());
            this.invalidate();
        } else {
            this.scrollTo(x, y);
        }
        return true;
    }

    public boolean setContentScrollBy(int cx, int cy, boolean animate) {
        if (this.mDrawHistory) {
            return false;
        }
        cx = this.contentToViewDimension(cx);
        cy = this.contentToViewDimension(cy);
        if (this.mHeightCanMeasure) {
            if (cy != 0) {
                Rect tempRect = new Rect();
                this.calcOurVisibleRect(tempRect);
                tempRect.offset(cx, cy);
                this.requestRectangleOnScreen(tempRect);
            }
            return cy == 0 && cx != 0 && this.pinScrollBy(cx, 0, animate, 0);
        }
        return this.pinScrollBy(cx, cy, animate, 0);
    }

    public void onPageStarted(String url) {
        this.setCertificate(null);
        this.mAccessibilityScriptInjected = false;
    }

    public void onPageFinished(String url) {
        if (this.mPageThatNeedsToSlideTitleBarOffScreen != null) {
            if (this.mPageThatNeedsToSlideTitleBarOffScreen.equals(url) && this.mScrollX == 0 && this.mScrollY == 0) {
                this.pinScrollTo(0, this.mYDistanceToSlideTitleOffScreen, true, 500);
            }
            this.mPageThatNeedsToSlideTitleBarOffScreen = null;
        }
        this.injectAccessibilityForUrl(url);
    }

    public void injectAccessibilityForUrl(String url) {
        if (this.mWebViewCore == null) {
            return;
        }
        AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(this.mContext);
        if (!accessibilityManager.isEnabled()) {
            this.ensureAccessibilityScriptInjectorInstance(false);
            return;
        }
        if (!this.getSettings().getJavaScriptEnabled()) {
            this.ensureAccessibilityScriptInjectorInstance(true);
            return;
        }
        int axsParameterValue = this.getAxsUrlParameterValue(url);
        if (axsParameterValue == -1) {
            boolean onDeviceScriptInjectionEnabled;
            boolean bl = onDeviceScriptInjectionEnabled = Settings.Secure.getInt(this.mContext.getContentResolver(), "accessibility_script_injection", 0) == 1;
            if (onDeviceScriptInjectionEnabled) {
                this.ensureAccessibilityScriptInjectorInstance(false);
                this.loadUrl(ACCESSIBILITY_SCRIPT_CHOOSER_JAVASCRIPT);
                this.mAccessibilityScriptInjected = true;
            } else {
                this.ensureAccessibilityScriptInjectorInstance(true);
            }
        } else if (axsParameterValue == 0) {
            this.ensureAccessibilityScriptInjectorInstance(true);
        } else if (axsParameterValue == 1) {
            this.ensureAccessibilityScriptInjectorInstance(false);
            this.loadUrl(ACCESSIBILITY_SCRIPT_CHOOSER_JAVASCRIPT);
        } else {
            Log.e(LOGTAG, "Unknown URL value for the \"axs\" URL parameter: " + axsParameterValue);
        }
    }

    public void ensureAccessibilityScriptInjectorInstance(boolean present) {
        if (present) {
            if (this.mAccessibilityInjector == null) {
                this.mAccessibilityInjector = new AccessibilityInjector(this);
            }
        } else {
            this.mAccessibilityInjector = null;
        }
    }

    public int getAxsUrlParameterValue(String url) {
        Matcher matcher;
        if (this.mMatchAxsUrlParameterPattern == null) {
            this.mMatchAxsUrlParameterPattern = Pattern.compile(PATTERN_MATCH_AXS_URL_PARAMETER);
        }
        if ((matcher = this.mMatchAxsUrlParameterPattern.matcher(url)).find()) {
            String keyValuePair = url.substring(matcher.start(), matcher.end());
            return Integer.parseInt(keyValuePair.split("=")[1]);
        }
        return -1;
    }

    public boolean setContentScrollTo(int cx, int cy) {
        int vy;
        int vx;
        if (this.mDrawHistory) {
            return false;
        }
        if ((cx | cy) == 0) {
            vx = 0;
            vy = 0;
        } else {
            vx = this.contentToViewX(cx);
            vy = this.contentToViewY(cy);
        }
        if (cx == 0 && cy == 1 && this.mScrollX == 0 && this.mScrollY == 0 && this.mTitleBar != null) {
            if (this.getProgress() < 100) {
                this.mPageThatNeedsToSlideTitleBarOffScreen = this.getUrl();
                this.mYDistanceToSlideTitleOffScreen = vy;
            } else {
                this.pinScrollTo(vx, vy, true, 500);
            }
            return false;
        }
        this.pinScrollTo(vx, vy, false, 0);
        return this.mScrollX != vx && cx >= 0 || this.mScrollY != vy && cy >= 0;
    }

    public void spawnContentScrollTo(int cx, int cy) {
        if (this.mDrawHistory) {
            return;
        }
        int vx = this.contentToViewX(cx);
        int vy = this.contentToViewY(cy);
        this.pinScrollTo(vx, vy, true, 0);
    }

    public void contentSizeChanged(boolean updateLayout) {
        if ((this.mContentWidth | this.mContentHeight) == 0) {
            return;
        }
        if (this.mHeightCanMeasure) {
            if (this.getMeasuredHeight() != this.contentToViewDimension(this.mContentHeight) || updateLayout) {
                this.requestLayout();
            }
        } else if (this.mWidthCanMeasure) {
            if (this.getMeasuredWidth() != this.contentToViewDimension(this.mContentWidth) || updateLayout) {
                this.requestLayout();
            }
        } else {
            this.sendViewSizeZoom(false);
        }
    }

    public void setWebViewClient(WebViewClient client) {
        this.mCallbackProxy.setWebViewClient(client);
    }

    public WebViewClient getWebViewClient() {
        return this.mCallbackProxy.getWebViewClient();
    }

    public void setDownloadListener(DownloadListener listener) {
        this.mCallbackProxy.setDownloadListener(listener);
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.mCallbackProxy.setWebChromeClient(client);
    }

    public WebChromeClient getWebChromeClient() {
        return this.mCallbackProxy.getWebChromeClient();
    }

    public void setWebBackForwardListClient(WebBackForwardListClient client) {
        this.mCallbackProxy.setWebBackForwardListClient(client);
    }

    public WebBackForwardListClient getWebBackForwardListClient() {
        return this.mCallbackProxy.getWebBackForwardListClient();
    }

    public void setPictureListener(PictureListener listener) {
        this.mPictureListener = listener;
    }

    public void externalRepresentation(Message callback) {
        this.mWebViewCore.sendMessage(160, callback);
    }

    public void documentAsText(Message callback) {
        this.mWebViewCore.sendMessage(161, callback);
    }

    public void addJavascriptInterface(Object obj, String interfaceName) {
        if (obj == null) {
            return;
        }
        WebViewCore.JSInterfaceData arg = new WebViewCore.JSInterfaceData();
        arg.mObject = obj;
        arg.mInterfaceName = interfaceName;
        this.mWebViewCore.sendMessage(138, arg);
    }

    public void removeJavascriptInterface(String interfaceName) {
        WebViewCore.JSInterfaceData arg = new WebViewCore.JSInterfaceData();
        arg.mInterfaceName = interfaceName;
        this.mWebViewCore.sendMessage(149, arg);
    }

    public WebSettings getSettings() {
        return this.mWebViewCore != null ? this.mWebViewCore.getSettings() : null;
    }

    @Deprecated
    public static synchronized PluginList getPluginList() {
        return new PluginList();
    }

    @Deprecated
    public void refreshPlugins(boolean reloadOpenPages) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.destroy();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    @Override
    public boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (child == this.mTitleBar) {
            this.mTitleBar.offsetLeftAndRight(this.mScrollX - this.mTitleBar.getLeft());
            int newTop = Math.min(0, this.mScrollY);
            this.mTitleBar.setBottom(newTop + this.getTitleHeight());
            this.mTitleBar.setTop(newTop);
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    public void drawContent(Canvas canvas) {
        this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), this.mTouchMode == 4 || this.mTrackballDown || this.mGotCenterDown, false);
        this.drawCoreAndCursorRing(canvas, this.mBackgroundColor, this.mDrawCursorRing);
    }

    public void drawOverScrollBackground(Canvas canvas) {
        if (mOverScrollBackground == null) {
            mOverScrollBackground = new Paint();
            Bitmap bm = BitmapFactory.decodeResource(this.mContext.getResources(), 17302752);
            mOverScrollBackground.setShader(new BitmapShader(bm, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
            mOverScrollBorder = new Paint();
            mOverScrollBorder.setStyle(Paint.Style.STROKE);
            mOverScrollBorder.setStrokeWidth(0.0f);
            mOverScrollBorder.setColor(-4473925);
        }
        int top = 0;
        int right = this.computeRealHorizontalScrollRange();
        int bottom = top + this.computeRealVerticalScrollRange();
        canvas.save();
        canvas.translate(this.mScrollX, this.mScrollY);
        canvas.clipRect(-this.mScrollX, top - this.mScrollY, right - this.mScrollX, bottom - this.mScrollY, Region.Op.DIFFERENCE);
        canvas.drawPaint(mOverScrollBackground);
        canvas.restore();
        canvas.drawRect(-1.0f, top - 1, right, bottom, mOverScrollBorder);
        canvas.clipRect(0, top, right, bottom);
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (this.mNativeClass == 0) {
            return;
        }
        if ((this.mContentWidth | this.mContentHeight) == 0 && this.mHistoryPicture == null) {
            canvas.drawColor(this.mBackgroundColor);
            return;
        }
        if (canvas.isHardwareAccelerated()) {
            this.mZoomManager.setHardwareAccelerated();
        }
        int saveCount = canvas.save();
        if (this.mInOverScrollMode && !this.getSettings().getUseWebViewBackgroundForOverscrollBackground()) {
            this.drawOverScrollBackground(canvas);
        }
        if (this.mTitleBar != null) {
            canvas.translate(0.0f, this.mTitleBar.getHeight());
        }
        this.drawContent(canvas);
        canvas.restoreToCount(saveCount);
        if (this.inEditingMode()) {
            this.mWebTextView.onDrawSubstitute();
        }
        this.mWebViewCore.signalRepaintDone();
        if (this.mOverScrollGlow != null && this.mOverScrollGlow.drawEdgeGlows(canvas)) {
            this.invalidate();
        }
        if (!this.mTouchHighlightRegion.isEmpty()) {
            if (this.mTouchHightlightPaint == null) {
                this.mTouchHightlightPaint = new Paint();
                this.mTouchHightlightPaint.setColor(0x33000000);
                this.mTouchHightlightPaint.setAntiAlias(true);
                this.mTouchHightlightPaint.setPathEffect(new CornerPathEffect(5.0f));
            }
            canvas.drawPath(this.mTouchHighlightRegion.getBoundaryPath(), this.mTouchHightlightPaint);
        }
        if (this.getSettings().getNavDump() && (this.mTouchHighlightX | this.mTouchHighlightY) != 0) {
            if (this.mTouchCrossHairColor == null) {
                this.mTouchCrossHairColor = new Paint();
                this.mTouchCrossHairColor.setColor(-65536);
            }
            canvas.drawLine(this.mTouchHighlightX - this.mNavSlop, this.mTouchHighlightY - this.mNavSlop, this.mTouchHighlightX + this.mNavSlop + 1, this.mTouchHighlightY + this.mNavSlop + 1, this.mTouchCrossHairColor);
            canvas.drawLine(this.mTouchHighlightX + this.mNavSlop + 1, this.mTouchHighlightY - this.mNavSlop, this.mTouchHighlightX - this.mNavSlop, this.mTouchHighlightY + this.mNavSlop + 1, this.mTouchCrossHairColor);
        }
    }

    public void removeTouchHighlight(boolean removePendingMessage) {
        if (removePendingMessage) {
            this.mWebViewCore.removeMessages(187);
        }
        this.mWebViewCore.sendMessage(188);
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.height == -2) {
            this.mWrapContent = true;
        }
        super.setLayoutParams(params);
    }

    @Override
    public boolean performLongClick() {
        if (this.getParent() == null) {
            return false;
        }
        ScaleGestureDetector detector = this.mZoomManager.getMultiTouchGestureDetector();
        if (detector != null && detector.isInProgress()) {
            return false;
        }
        if (this.mNativeClass != 0 && this.nativeCursorIsTextInput()) {
            this.centerKeyPressOnTextField();
            this.rebuildWebTextView();
        } else {
            this.clearTextEntry();
        }
        if (this.inEditingMode()) {
            this.mWebTextView.ensureLayout();
            AbsoluteLayout.LayoutParams params = (AbsoluteLayout.LayoutParams)this.mWebTextView.getLayoutParams();
            MotionEvent fake = MotionEvent.obtain(this.mLastTouchTime, this.mLastTouchTime, 0, this.mLastTouchX - params.x + this.mScrollX, this.mLastTouchY - params.y + this.mScrollY, 0);
            this.mWebTextView.dispatchTouchEvent(fake);
            return this.mWebTextView.performLongClick();
        }
        if (this.mSelectingText) {
            return false;
        }
        if (super.performLongClick()) {
            return true;
        }
        return this.selectText();
    }

    public boolean selectText() {
        int x = this.viewToContentX(this.mLastTouchX + this.mScrollX);
        int y = this.viewToContentY(this.mLastTouchY + this.mScrollY);
        return this.selectText(x, y);
    }

    public boolean selectText(int x, int y) {
        if (!this.setUpSelect()) {
            return false;
        }
        if (this.mNativeClass != 0 && this.nativeWordSelection(x, y)) {
            this.nativeSetExtendSelection();
            this.mDrawSelectionPointer = false;
            this.mSelectionStarted = true;
            this.mTouchMode = 3;
            return true;
        }
        this.selectionDone();
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        if (this.mSelectingText && this.mOrientation != newConfig.orientation) {
            this.selectionDone();
        }
        this.mOrientation = newConfig.orientation;
    }

    public boolean didUpdateWebTextViewDimensions(int intersection) {
        boolean onScreen;
        Rect contentBounds = this.nativeFocusCandidateNodeBounds();
        Rect vBox = this.contentToViewRect(contentBounds);
        Rect visibleRect = new Rect();
        this.calcOurVisibleRect(visibleRect);
        switch (intersection) {
            case 0: {
                onScreen = visibleRect.contains(vBox);
                break;
            }
            case 1: {
                onScreen = Rect.intersects(visibleRect, vBox);
                break;
            }
            case 2: {
                onScreen = true;
                break;
            }
            default: {
                throw new AssertionError((Object)"invalid parameter passed to didUpdateWebTextViewDimensions");
            }
        }
        if (onScreen) {
            this.mWebTextView.setRect(vBox.left, vBox.top, vBox.width(), vBox.height());
            this.mWebTextView.updateTextSize();
            this.updateWebTextViewPadding();
            return true;
        }
        this.mWebTextView.remove();
        return false;
    }

    public void setBaseLayer(int layer, Rect invalRect) {
        if (this.mNativeClass == 0) {
            return;
        }
        if (invalRect == null) {
            Rect rect = new Rect(0, 0, this.mContentWidth, this.mContentHeight);
            this.nativeSetBaseLayer(layer, rect);
        } else {
            this.nativeSetBaseLayer(layer, invalRect);
        }
    }

    public void onZoomAnimationStart() {
        if (this.inEditingMode() && this.nativeFocusCandidateIsPassword()) {
            this.mWebTextView.setInPassword(false);
        }
    }

    public void onZoomAnimationEnd() {
        if (this.inEditingMode() && this.didUpdateWebTextViewDimensions(0) && this.nativeFocusCandidateIsPassword()) {
            this.mWebTextView.setInPassword(true);
        }
    }

    public void onFixedLengthZoomAnimationStart() {
        WebViewCore.pauseUpdatePicture(this.getWebViewCore());
        this.onZoomAnimationStart();
    }

    public void onFixedLengthZoomAnimationEnd() {
        if (!this.mSelectingText) {
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
        }
        this.onZoomAnimationEnd();
    }

    public void drawCoreAndCursorRing(Canvas canvas, int color2, boolean drawCursorRing) {
        boolean animateScroll;
        if (this.mDrawHistory) {
            canvas.scale(this.mZoomManager.getScale(), this.mZoomManager.getScale());
            canvas.drawPicture(this.mHistoryPicture);
            return;
        }
        if (this.mNativeClass == 0) {
            return;
        }
        boolean animateZoom = this.mZoomManager.isFixedLengthAnimationInProgress();
        boolean bl = animateScroll = (!this.mScroller.isFinished() || this.mVelocityTracker != null) && (this.mTouchMode != 3 || this.mHeldMotionless != 2) || this.mDeferTouchMode == 3;
        if (this.mTouchMode == 3) {
            if (this.mHeldMotionless == 1) {
                this.mPrivateHandler.removeMessages(8);
                this.mPrivateHandler.removeMessages(9);
                this.mHeldMotionless = 0;
            }
            if (this.mHeldMotionless == 0) {
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(8), 100L);
                this.mHeldMotionless = 1;
            }
        }
        if (animateZoom) {
            this.mZoomManager.animateZoom(canvas);
        } else {
            canvas.scale(this.mZoomManager.getScale(), this.mZoomManager.getScale());
        }
        boolean UIAnimationsRunning = false;
        if (this.mNativeClass != 0 && this.nativeEvaluateLayersAnimations()) {
            UIAnimationsRunning = true;
            this.invalidate();
        }
        int extras = 0;
        if (this.mFindIsUp) {
            extras = 1;
        } else if (this.mSelectingText) {
            extras = 2;
            this.nativeSetSelectionPointer(this.mDrawSelectionPointer, this.mZoomManager.getInvScale(), this.mSelectX, this.mSelectY - this.getTitleHeight());
        } else if (drawCursorRing) {
            extras = 3;
        }
        if (canvas.isHardwareAccelerated()) {
            int functor = this.nativeGetDrawGLFunction(this.mGLViewportEmpty ? null : this.mGLRectViewport, this.getScale(), extras);
            ((HardwareCanvas)canvas).callDrawGLFunction(functor);
        } else {
            DrawFilter df = null;
            if (this.mZoomManager.isZoomAnimating() || UIAnimationsRunning) {
                df = this.mZoomFilter;
            } else if (animateScroll) {
                df = this.mScrollFilter;
            }
            canvas.setDrawFilter(df);
            int content = this.nativeDraw(canvas, color2, extras, false);
            canvas.setDrawFilter(null);
            if (content != 0) {
                this.mWebViewCore.sendMessage(133, content, 0);
            }
        }
        if (extras == 3 && this.mTouchMode == 4) {
            this.mTouchMode = 5;
        }
        if (this.mFocusSizeChanged) {
            this.mFocusSizeChanged = false;
            if (!animateZoom && this.inEditingMode()) {
                this.didUpdateWebTextViewDimensions(2);
            }
        }
    }

    public boolean drawHistory() {
        return this.mDrawHistory;
    }

    public int getHistoryPictureWidth() {
        return this.mHistoryPicture != null ? this.mHistoryPicture.getWidth() : 0;
    }

    public void switchOutDrawHistory() {
        if (null == this.mWebViewCore) {
            return;
        }
        if (this.mDrawHistory && (this.getProgress() == 100 || this.nativeHasContent())) {
            this.mDrawHistory = false;
            this.mHistoryPicture = null;
            this.invalidate();
            int oldScrollX = this.mScrollX;
            int oldScrollY = this.mScrollY;
            this.mScrollX = this.pinLocX(this.mScrollX);
            this.mScrollY = this.pinLocY(this.mScrollY);
            if (oldScrollX != this.mScrollX || oldScrollY != this.mScrollY) {
                this.mUserScroll = false;
                this.mWebViewCore.sendMessage(131, oldScrollX, oldScrollY);
                this.onScrollChanged(this.mScrollX, this.mScrollY, oldScrollX, oldScrollY);
            } else {
                this.sendOurVisibleRect();
            }
        }
    }

    public WebViewCore.CursorData cursorData() {
        WebViewCore.CursorData result = new WebViewCore.CursorData();
        result.mMoveGeneration = this.nativeMoveGeneration();
        result.mFrame = this.nativeCursorFramePointer();
        Point position = this.nativeCursorPosition();
        result.mX = position.x;
        result.mY = position.y;
        return result;
    }

    public void deleteSelection(int start, int end) {
        ++this.mTextGeneration;
        WebViewCore.TextSelectionData data = new WebViewCore.TextSelectionData(start, end);
        this.mWebViewCore.sendMessage(122, this.mTextGeneration, 0, data);
    }

    public void setSelection(int start, int end) {
        if (this.mWebViewCore != null) {
            this.mWebViewCore.sendMessage(113, start, end);
        }
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        outAttrs.imeOptions |= 0x2000000;
        return connection;
    }

    public void displaySoftKeyboard(boolean isTextView) {
        boolean zoom;
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        boolean bl = zoom = this.mZoomManager.getScale() < this.mZoomManager.getDefaultScale();
        if (zoom) {
            this.mZoomManager.setZoomCenter(this.mLastTouchX, this.mLastTouchY);
            this.mZoomManager.setZoomScale(this.mZoomManager.getDefaultScale(), false);
        }
        if (isTextView) {
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                imm.showSoftInput(this.mWebTextView, 0);
                if (zoom) {
                    this.didUpdateWebTextViewDimensions(1);
                }
                return;
            }
        }
        imm.showSoftInput(this, 0);
    }

    public void hideSoftKeyboard() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        if (imm != null && (imm.isActive(this) || this.inEditingMode() && imm.isActive(this.mWebTextView))) {
            imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
    }

    public void rebuildWebTextView() {
        if (!(this.hasFocus() || null != this.mWebTextView && this.mWebTextView.hasFocus())) {
            return;
        }
        boolean alreadyThere = this.inEditingMode();
        if (0 == this.mNativeClass || !this.nativeFocusCandidateIsTextInput()) {
            if (alreadyThere) {
                this.mWebTextView.remove();
            }
            return;
        }
        if (this.mWebTextView == null) {
            this.mWebTextView = new WebTextView(this.mContext, this, this.mAutoFillData.getQueryId());
            this.mTextGeneration = 0;
        }
        this.mWebTextView.updateTextSize();
        Rect visibleRect = new Rect();
        this.calcOurContentVisibleRect(visibleRect);
        Rect bounds = this.nativeFocusCandidateNodeBounds();
        Rect vBox = this.contentToViewRect(bounds);
        this.mWebTextView.setRect(vBox.left, vBox.top, vBox.width(), vBox.height());
        if (!Rect.intersects(bounds, visibleRect)) {
            this.revealSelection();
        }
        String text = this.nativeFocusCandidateText();
        int nodePointer = this.nativeFocusCandidatePointer();
        if (alreadyThere && this.mWebTextView.isSameTextField(nodePointer)) {
            if (text != null && !text.equals(this.mWebTextView.getText().toString()) && this.nativeTextGeneration() == this.mTextGeneration) {
                this.mWebTextView.setTextAndKeepSelection(text);
            }
        } else {
            this.mWebTextView.setGravity(this.nativeFocusCandidateIsRtlText() ? 5 : 0);
            this.mWebTextView.setNodePointer(nodePointer);
            this.mWebTextView.setType(this.nativeFocusCandidateType());
            this.updateWebTextViewPadding();
            if (null == text) {
                text = "";
            }
            this.mWebTextView.setTextAndKeepSelection(text);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null && imm.isActive(this.mWebTextView)) {
                imm.restartInput(this.mWebTextView);
            }
        }
        if (this.isFocused()) {
            this.mWebTextView.requestFocus();
        }
    }

    public void updateWebTextViewPadding() {
        Rect paddingRect = this.nativeFocusCandidatePaddingRect();
        if (paddingRect != null) {
            this.mWebTextView.setPadding(this.contentToViewDimension(paddingRect.left), this.contentToViewDimension(paddingRect.top), this.contentToViewDimension(paddingRect.right), this.contentToViewDimension(paddingRect.bottom));
        }
    }

    public void revealSelection() {
        if (this.mWebViewCore != null) {
            this.mWebViewCore.sendMessage(96);
        }
    }

    public void requestFormData(String name, int nodePointer, boolean autoFillable, boolean autoComplete) {
        if (this.mWebViewCore.getSettings().getSaveFormData()) {
            Message update = this.mPrivateHandler.obtainMessage(6);
            update.arg1 = nodePointer;
            RequestFormData updater = new RequestFormData(name, this.getUrl(), update, autoFillable, autoComplete);
            Thread t = new Thread(updater);
            t.start();
        }
    }

    public void requestLabel(int framePointer, int nodePointer) {
        this.mWebViewCore.sendMessage(97, framePointer, nodePointer);
    }

    public void dumpDisplayTree() {
        this.nativeDumpDisplayTree(this.getUrl());
    }

    public void dumpDomTree(boolean toFile) {
        this.mWebViewCore.sendMessage(170, toFile ? 1 : 0, 0);
    }

    public void dumpRenderTree(boolean toFile) {
        this.mWebViewCore.sendMessage(171, toFile ? 1 : 0, 0);
    }

    public void useMockDeviceOrientation() {
        this.mWebViewCore.sendMessage(191);
    }

    public void setMockDeviceOrientation(boolean canProvideAlpha, double alpha, boolean canProvideBeta, double beta, boolean canProvideGamma, double gamma) {
        this.mWebViewCore.setMockDeviceOrientation(canProvideAlpha, alpha, canProvideBeta, beta, canProvideGamma, gamma);
    }

    public void dumpV8Counters() {
        this.mWebViewCore.sendMessage(173);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        if (keyCode == 0 && event.getCharacters() != null) {
            this.mWebViewCore.sendMessage(103, event);
            this.mWebViewCore.sendMessage(104, event);
            return true;
        }
        return false;
    }

    public boolean isEnterActionKey(int keyCode) {
        return keyCode == 23 || keyCode == 66 || keyCode == 160;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.isCtrlPressed()) {
            return false;
        }
        if (this.mNativeClass == 0) {
            return false;
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (this.accessibilityScriptInjected()) {
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                this.mWebViewCore.sendMessage(103, event);
                return true;
            }
            this.mAccessibilityScriptInjected = false;
        } else if (this.mAccessibilityInjector != null) {
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                if (this.mAccessibilityInjector.onKeyEvent(event)) {
                    return true;
                }
            } else {
                this.mAccessibilityInjector = null;
            }
        }
        if (keyCode == 92) {
            if (event.hasNoModifiers()) {
                this.pageUp(false);
                return true;
            }
            if (event.hasModifiers(2)) {
                this.pageUp(true);
                return true;
            }
        }
        if (keyCode == 93) {
            if (event.hasNoModifiers()) {
                this.pageDown(false);
                return true;
            }
            if (event.hasModifiers(2)) {
                this.pageDown(true);
                return true;
            }
        }
        if (keyCode == 122 && event.hasNoModifiers()) {
            this.pageUp(true);
            return true;
        }
        if (keyCode == 123 && event.hasNoModifiers()) {
            this.pageDown(true);
            return true;
        }
        if (keyCode >= 19 && keyCode <= 22) {
            this.switchOutDrawHistory();
            if (this.nativePageShouldHandleShiftAndArrows()) {
                this.letPageHandleNavKey(keyCode, event.getEventTime(), true, event.getMetaState());
                return true;
            }
            if (event.hasModifiers(2)) {
                switch (keyCode) {
                    case 19: {
                        this.pageUp(true);
                        return true;
                    }
                    case 20: {
                        this.pageDown(true);
                        return true;
                    }
                    case 21: {
                        this.nativeClearCursor();
                        return this.pinScrollTo(0, this.mScrollY, true, 0);
                    }
                    case 22: {
                        this.nativeClearCursor();
                        return this.pinScrollTo(this.mContentWidth, this.mScrollY, true, 0);
                    }
                }
            }
            if (this.mSelectingText) {
                int xRate;
                int n = keyCode == 21 ? -1 : (xRate = keyCode == 22 ? 1 : 0);
                int yRate = keyCode == 19 ? -1 : (keyCode == 20 ? 1 : 0);
                int multiplier = event.getRepeatCount() + 1;
                this.moveSelection(xRate * multiplier, yRate * multiplier);
                return true;
            }
            if (this.navHandledKey(keyCode, 1, false, event.getEventTime())) {
                this.playSoundEffect(this.keyCodeToSoundsEffect(keyCode));
                return true;
            }
            return false;
        }
        if (this.isEnterActionKey(keyCode)) {
            boolean wantsKeyEvents;
            this.switchOutDrawHistory();
            boolean bl = wantsKeyEvents = this.nativeCursorNodePointer() == 0 || this.nativeCursorWantsKeyEvents();
            if (event.getRepeatCount() == 0) {
                if (this.mSelectingText) {
                    return true;
                }
                this.mGotCenterDown = true;
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(114), 1000L);
                this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), true, true);
                if (!wantsKeyEvents) {
                    return true;
                }
            }
            if (!wantsKeyEvents) {
                return false;
            }
        }
        if (this.getSettings().getNavDump()) {
            switch (keyCode) {
                case 11: {
                    this.dumpDisplayTree();
                    break;
                }
                case 12: 
                case 13: {
                    this.dumpDomTree(keyCode == 12);
                    break;
                }
                case 14: 
                case 15: {
                    this.dumpRenderTree(keyCode == 14);
                    break;
                }
                case 16: {
                    this.nativeInstrumentReport();
                    return true;
                }
            }
        }
        if (this.nativeCursorIsTextInput()) {
            this.mWebViewCore.sendMessage(121, this.nativeCursorFramePointer(), this.nativeCursorNodePointer());
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                this.mWebTextView.setDefaultSelection();
                return this.mWebTextView.dispatchKeyEvent(event);
            }
        } else if (this.nativeHasFocusNode()) {
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                this.mWebTextView.setDefaultSelection();
                return this.mWebTextView.dispatchKeyEvent(event);
            }
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(103, event);
        return true;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (keyCode == 5 && this.nativeHasCursorNode()) {
            String text = this.nativeCursorText();
            if (!this.nativeCursorIsTextInput() && text != null && text.startsWith(SCHEME_TEL)) {
                Intent intent = new Intent("android.intent.action.DIAL", Uri.parse(text));
                this.getContext().startActivity(intent);
                return true;
            }
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (this.accessibilityScriptInjected()) {
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                this.mWebViewCore.sendMessage(104, event);
                return true;
            }
            this.mAccessibilityScriptInjected = false;
        } else if (this.mAccessibilityInjector != null) {
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                if (this.mAccessibilityInjector.onKeyEvent(event)) {
                    return true;
                }
            } else {
                this.mAccessibilityInjector = null;
            }
        }
        if (keyCode >= 19 && keyCode <= 22) {
            if (this.nativePageShouldHandleShiftAndArrows()) {
                this.letPageHandleNavKey(keyCode, event.getEventTime(), false, event.getMetaState());
                return true;
            }
            return false;
        }
        if (this.isEnterActionKey(keyCode)) {
            this.mPrivateHandler.removeMessages(114);
            this.mGotCenterDown = false;
            if (this.mSelectingText) {
                if (this.mExtendSelection) {
                    this.copySelection();
                    this.selectionDone();
                } else {
                    this.mExtendSelection = true;
                    this.nativeSetExtendSelection();
                    this.invalidate();
                }
                return true;
            }
            Rect visibleRect = this.sendOurVisibleRect();
            if (!this.nativeCursorIntersects(visibleRect)) {
                return false;
            }
            WebViewCore.CursorData data = this.cursorData();
            this.mWebViewCore.sendMessage(135, data);
            this.playSoundEffect(0);
            if (this.nativeCursorIsTextInput()) {
                this.rebuildWebTextView();
                this.centerKeyPressOnTextField();
                if (this.inEditingMode()) {
                    this.mWebTextView.setDefaultSelection();
                }
                return true;
            }
            this.clearTextEntry();
            this.nativeShowCursorTimed();
            if (this.mCallbackProxy.uiOverrideUrlLoading(this.nativeCursorText())) {
                return true;
            }
            if (this.nativeCursorNodePointer() != 0 && !this.nativeCursorWantsKeyEvents()) {
                this.mWebViewCore.sendMessage(118, data.mFrame, this.nativeCursorNodePointer());
                return true;
            }
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(104, event);
        return true;
    }

    public boolean setUpSelect() {
        if (0 == this.mNativeClass) {
            return false;
        }
        if (this.inFullScreenMode()) {
            return false;
        }
        if (this.mSelectingText) {
            return true;
        }
        this.mExtendSelection = false;
        this.mDrawSelectionPointer = true;
        this.mSelectingText = true;
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        this.nativeResetSelection();
        if (this.nativeHasCursorNode()) {
            Rect rect = this.nativeCursorNodeBounds();
            this.mSelectX = this.contentToViewX(rect.left);
            this.mSelectY = this.contentToViewY(rect.top);
        } else if (this.mLastTouchY > this.getVisibleTitleHeight()) {
            this.mSelectX = this.mScrollX + this.mLastTouchX;
            this.mSelectY = this.mScrollY + this.mLastTouchY;
        } else {
            this.mSelectX = this.mScrollX + this.getViewWidth() / 2;
            this.mSelectY = this.mScrollY + this.getViewHeightWithTitle() / 2;
        }
        this.nativeHideCursor();
        this.mSelectCallback = new SelectActionModeCallback();
        this.mSelectCallback.setWebView(this);
        if (this.startActionMode(this.mSelectCallback) == null) {
            this.selectionDone();
            return false;
        }
        this.mMinAutoScrollX = 0;
        this.mMaxAutoScrollX = this.getViewWidth();
        this.mMinAutoScrollY = 0;
        this.mMaxAutoScrollY = this.getViewHeightWithTitle();
        this.mScrollingLayer = this.nativeScrollableLayer(this.viewToContentX(this.mSelectX), this.viewToContentY(this.mSelectY), this.mScrollingLayerRect, this.mScrollingLayerBounds);
        if (this.mScrollingLayer != 0) {
            if (this.mScrollingLayerRect.left != this.mScrollingLayerRect.right) {
                this.mMinAutoScrollX = Math.max(this.mMinAutoScrollX, this.contentToViewX(this.mScrollingLayerBounds.left));
                this.mMaxAutoScrollX = Math.min(this.mMaxAutoScrollX, this.contentToViewX(this.mScrollingLayerBounds.right));
            }
            if (this.mScrollingLayerRect.top != this.mScrollingLayerRect.bottom) {
                this.mMinAutoScrollY = Math.max(this.mMinAutoScrollY, this.contentToViewY(this.mScrollingLayerBounds.top));
                this.mMaxAutoScrollY = Math.min(this.mMaxAutoScrollY, this.contentToViewY(this.mScrollingLayerBounds.bottom));
            }
        }
        this.mMinAutoScrollX += 5;
        this.mMaxAutoScrollX -= 5;
        this.mMinAutoScrollY += 5;
        this.mMaxAutoScrollY -= 5;
        return true;
    }

    public void emulateShiftHeld() {
        this.setUpSelect();
    }

    public void selectAll() {
        if (0 == this.mNativeClass) {
            return;
        }
        if (this.inFullScreenMode()) {
            return;
        }
        if (!this.mSelectingText) {
            Point select = this.nativeSelectableText();
            if (!this.selectText(select.x, select.y)) {
                return;
            }
        }
        this.nativeSelectAll();
        this.mDrawSelectionPointer = false;
        this.mExtendSelection = true;
        this.invalidate();
    }

    public void selectionDone() {
        if (this.mSelectingText) {
            this.mSelectingText = false;
            this.mSelectCallback.finish();
            this.mSelectCallback = null;
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            this.invalidate();
            this.mAutoScrollX = 0;
            this.mAutoScrollY = 0;
            this.mSentAutoScrollMessage = false;
        }
    }

    public boolean copySelection() {
        boolean copiedSomething = false;
        String selection = this.getSelection();
        if (selection != null && selection != "") {
            Toast.makeText(this.mContext, 17040110, 0).show();
            copiedSomething = true;
            ClipboardManager cm = (ClipboardManager)this.getContext().getSystemService("clipboard");
            cm.setText(selection);
        }
        this.invalidate();
        return copiedSomething;
    }

    public String getSelection() {
        if (this.mNativeClass == 0) {
            return "";
        }
        return this.nativeGetSelection();
    }

    @Override
    public void onAttachedToWindow() {
        ViewTreeObserver treeObserver;
        super.onAttachedToWindow();
        if (this.hasWindowFocus()) {
            this.setActive(true);
        }
        if ((treeObserver = this.getViewTreeObserver()) != null) {
            if (this.mGlobalLayoutListener == null) {
                this.mGlobalLayoutListener = new InnerGlobalLayoutListener(null);
                treeObserver.addOnGlobalLayoutListener(this.mGlobalLayoutListener);
            }
            if (this.mScrollChangedListener == null) {
                this.mScrollChangedListener = new InnerScrollChangedListener(null);
                treeObserver.addOnScrollChangedListener(this.mScrollChangedListener);
            }
        }
    }

    @Override
    public void onDetachedFromWindow() {
        ViewTreeObserver treeObserver;
        this.clearHelpers();
        this.mZoomManager.dismissZoomPicker();
        if (this.hasWindowFocus()) {
            this.setActive(false);
        }
        if ((treeObserver = this.getViewTreeObserver()) != null) {
            if (this.mGlobalLayoutListener != null) {
                treeObserver.removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
                this.mGlobalLayoutListener = null;
            }
            if (this.mScrollChangedListener != null) {
                treeObserver.removeOnScrollChangedListener(this.mScrollChangedListener);
                this.mScrollChangedListener = null;
            }
        }
        super.onDetachedFromWindow();
    }

    @Override
    public void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0 && this.mZoomManager != null) {
            this.mZoomManager.dismissZoomPicker();
        }
    }

    @Override
    @Deprecated
    public void onChildViewAdded(View parent, View child) {
    }

    @Override
    @Deprecated
    public void onChildViewRemoved(View p, View child) {
    }

    @Override
    @Deprecated
    public void onGlobalFocusChanged(View oldFocus, View newFocus) {
    }

    public void setActive(boolean active) {
        if (active) {
            if (this.hasFocus()) {
                this.mDrawCursorRing = true;
                this.setFocusControllerActive(true);
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(true, false, true);
                }
            } else if (!this.inEditingMode()) {
                this.mDrawCursorRing = false;
                this.setFocusControllerActive(false);
            }
        } else {
            if (!this.mZoomManager.isZoomPickerVisible()) {
                this.mDrawCursorRing = false;
            }
            this.mGotKeyDown = false;
            this.mPrivateHandler.removeMessages(4);
            this.mTouchMode = 7;
            if (this.mNativeClass != 0) {
                this.nativeRecordButtons(false, false, true);
            }
            this.setFocusControllerActive(false);
        }
        this.invalidate();
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        this.setActive(hasWindowFocus);
        if (hasWindowFocus) {
            JWebCoreJavaBridge.setActiveWebView((_Original_WebView)this);
        } else {
            JWebCoreJavaBridge.removeActiveWebView((_Original_WebView)this);
        }
        super.onWindowFocusChanged(hasWindowFocus);
    }

    public void setFocusControllerActive(boolean active) {
        if (this.mWebViewCore == null) {
            return;
        }
        this.mWebViewCore.sendMessage(142, active ? 1 : 0, 0);
        if (active && this.mListBoxMessage != null) {
            this.mWebViewCore.sendMessage(this.mListBoxMessage);
            this.mListBoxMessage = null;
        }
    }

    @Override
    public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (focused) {
            if (this.hasWindowFocus()) {
                this.mDrawCursorRing = true;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(true, false, true);
                }
                this.setFocusControllerActive(true);
            }
        } else {
            if (!this.inEditingMode()) {
                this.mDrawCursorRing = false;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(false, false, true);
                }
                this.setFocusControllerActive(false);
            }
            this.mGotKeyDown = false;
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    public void setGLRectViewport() {
        boolean visible = this.getGlobalVisibleRect(this.mGLRectViewport);
        if (visible) {
            View rootView = this.getRootView();
            int rootViewHeight = rootView.getHeight();
            int savedWebViewBottom = this.mGLRectViewport.bottom;
            this.mGLRectViewport.bottom = rootViewHeight - this.mGLRectViewport.top - this.getVisibleTitleHeight();
            this.mGLRectViewport.top = rootViewHeight - savedWebViewBottom;
            this.mGLViewportEmpty = false;
        } else {
            this.mGLViewportEmpty = true;
        }
        this.nativeUpdateDrawGLFunction(this.mGLViewportEmpty ? null : this.mGLRectViewport);
    }

    @Override
    public boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = super.setFrame(left, top, right, bottom);
        if (!changed && this.mHeightCanMeasure) {
            this.sendViewSizeZoom(false);
        }
        this.setGLRectViewport();
        return changed;
    }

    @Override
    public void onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
        int newMaxViewportWidth = (int)((float)Math.max(w, h) / this.mZoomManager.getDefaultMinZoomScale());
        if (newMaxViewportWidth > sMaxViewportWidth) {
            sMaxViewportWidth = newMaxViewportWidth;
        }
        this.mZoomManager.onSizeChanged(w, h, ow, oh);
    }

    @Override
    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (!this.mInOverScrollMode) {
            this.sendOurVisibleRect();
            int titleHeight = this.getTitleHeight();
            if (Math.max(titleHeight - t, 0) != Math.max(titleHeight - oldt, 0)) {
                this.sendViewSizeZoom(false);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean dispatch = true;
        boolean inEditingMode = this.inEditingMode();
        if (!(inEditingMode || this.mNativeClass != 0 && this.nativePageShouldHandleShiftAndArrows())) {
            if (event.getAction() == 0) {
                this.mGotKeyDown = true;
            } else {
                if (!this.mGotKeyDown && event.getAction() != 2) {
                    dispatch = false;
                }
                this.mGotKeyDown = false;
            }
        }
        if (dispatch) {
            if (inEditingMode) {
                return this.mWebTextView.dispatchKeyEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }
        return false;
    }

    public boolean hitFocusedPlugin(int contentX, int contentY) {
        return this.nativeFocusIsPlugin() && this.nativeFocusNodeBounds().contains(contentX, contentY);
    }

    public boolean shouldForwardTouchEvent() {
        return this.mFullScreenHolder != null || this.mForwardTouchEvents && !this.mSelectingText && this.mPreventDefault != 4;
    }

    public boolean inFullScreenMode() {
        return this.mFullScreenHolder != null;
    }

    public void dismissFullScreenMode() {
        if (this.inFullScreenMode()) {
            this.mFullScreenHolder.dismiss();
            this.mFullScreenHolder = null;
        }
    }

    public void onPinchToZoomAnimationStart() {
        this.cancelTouch();
        this.onZoomAnimationStart();
    }

    public void onPinchToZoomAnimationEnd(ScaleGestureDetector detector) {
        this.onZoomAnimationEnd();
        this.mTouchMode = 8;
        this.mConfirmMove = true;
        this.startTouch(detector.getFocusX(), detector.getFocusY(), this.mLastTouchTime);
    }

    public void startScrollingLayer(float x, float y) {
        int contentX = this.viewToContentX((int)x + this.mScrollX);
        int contentY = this.viewToContentY((int)y + this.mScrollY);
        this.mScrollingLayer = this.nativeScrollableLayer(contentX, contentY, this.mScrollingLayerRect, this.mScrollingLayerBounds);
        if (this.mScrollingLayer != 0) {
            this.mTouchMode = 9;
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mNativeClass == 0 || !this.isClickable() && !this.isLongClickable()) {
            return false;
        }
        int action = ev.getActionMasked();
        if (ev.getPointerCount() > 1) {
            this.mIsHandlingMultiTouch = true;
            if (this.mPreventDefault == 0 && action == 2) {
                this.handleMultiTouchInWebView(ev);
            } else {
                this.passMultiTouchToWebKit(ev);
            }
            return true;
        }
        if (this.mIsHandlingMultiTouch && action == 2) {
            return false;
        }
        return this.handleTouchEventCommon(ev, action, Math.round(ev.getX()), Math.round(ev.getY()));
    }

    /*
     * Unable to fully structure code
     */
    public boolean handleTouchEventCommon(MotionEvent ev, int action, int x, int y) {
        eventTime = ev.getEventTime();
        x = Math.min(x, this.getViewWidth() - 1);
        y = Math.min(y, this.getViewHeightWithTitle() - 1);
        deltaX = this.mLastTouchX - x;
        deltaY = this.mLastTouchY - y;
        contentX = this.viewToContentX(x + this.mScrollX);
        contentY = this.viewToContentY(y + this.mScrollY);
        switch (action) {
            case 0: {
                this.mPreventDefault = 0;
                this.mConfirmMove = false;
                this.mIsHandlingMultiTouch = false;
                this.mInitialHitTestResult = null;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    this.mTouchMode = 2;
                    this.mConfirmMove = true;
                    this.mPrivateHandler.removeMessages(7);
                } else if (this.mPrivateHandler.hasMessages(5)) {
                    this.mPrivateHandler.removeMessages(5);
                    if (this.getSettings().supportTouchOnly()) {
                        this.removeTouchHighlight(true);
                    }
                    if (deltaX * deltaX + deltaY * deltaY < this.mDoubleTapSlopSquare) {
                        this.mTouchMode = 6;
                    } else {
                        this.doShortPress();
                        this.mTouchMode = 1;
                        this.mDeferTouchProcess = this.inFullScreenMode() == false && this.mForwardTouchEvents != false ? this.hitFocusedPlugin(contentX, contentY) : false;
                    }
                } else {
                    this.mTouchMode = 1;
                    this.mDeferTouchProcess = this.inFullScreenMode() == false && this.mForwardTouchEvents != false ? this.hitFocusedPlugin(contentX, contentY) : false;
                    this.mWebViewCore.sendMessage(98);
                    if (this.getSettings().supportTouchOnly()) {
                        data = new WebViewCore.TouchHighlightData();
                        data.mX = contentX;
                        data.mY = contentY;
                        data.mSlop = this.viewToContentDimension(this.mNavSlop);
                        this.mWebViewCore.sendMessageDelayed(187, data, ViewConfiguration.getTapTimeout());
                        if (this.getSettings().getNavDump()) {
                            this.mTouchHighlightX = x + this.mScrollX;
                            this.mTouchHighlightY = y + this.mScrollY;
                            this.mPrivateHandler.postDelayed(new _Original_WebView$8(this), 2000L);
                        }
                    }
                    if (_Original_WebView.mLogEvent && eventTime - this.mLastTouchUpTime < 1000L) {
                        EventLog.writeEvent(70102, new Object[]{eventTime - this.mLastTouchUpTime, eventTime});
                    }
                    if (this.mSelectingText) {
                        this.mDrawSelectionPointer = false;
                        this.mSelectionStarted = this.nativeStartSelection(contentX, contentY);
                        this.invalidate();
                    }
                }
                if (this.mTouchMode == 1 || this.mTouchMode == 6) {
                    this.mPrivateHandler.sendEmptyMessageDelayed(3, 200L);
                    this.mPrivateHandler.sendEmptyMessageDelayed(4, 1000L);
                    this.mPreventDefault = this.inFullScreenMode() != false || this.mDeferTouchProcess != false ? 3 : (this.mForwardTouchEvents != false ? 1 : 0);
                    if (this.shouldForwardTouchEvent()) {
                        ted = new WebViewCore.TouchEventData();
                        ted.mAction = action;
                        ted.mIds = new int[1];
                        ted.mIds[0] = ev.getPointerId(0);
                        ted.mPoints = new Point[1];
                        ted.mPoints[0] = new Point(contentX, contentY);
                        ted.mMetaState = ev.getMetaState();
                        ted.mReprocess = this.mDeferTouchProcess;
                        this.mWebViewCore.sendMessage(141, ted);
                        if (this.mDeferTouchProcess) {
                            this.mLastTouchX = x;
                            this.mLastTouchY = y;
                            break;
                        }
                        if (!this.inFullScreenMode()) {
                            this.mPrivateHandler.removeMessages(10);
                            this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(10, action, 0), 200L);
                        }
                    }
                }
                this.startTouch(x, y, eventTime);
                break;
            }
            case 2: {
                firstMove = false;
                if (!this.mConfirmMove && deltaX * deltaX + deltaY * deltaY >= this.mTouchSlopSquare) {
                    this.mPrivateHandler.removeMessages(3);
                    this.mPrivateHandler.removeMessages(4);
                    this.mConfirmMove = true;
                    firstMove = true;
                    if (this.mTouchMode == 6) {
                        this.mTouchMode = 1;
                    }
                    if (this.getSettings().supportTouchOnly()) {
                        this.removeTouchHighlight(true);
                    }
                }
                if (this.shouldForwardTouchEvent() && this.mConfirmMove && (firstMove || eventTime - this.mLastSentTouchTime > (long)this.mCurrentTouchInterval)) {
                    ted = new WebViewCore.TouchEventData();
                    ted.mAction = action;
                    ted.mIds = new int[1];
                    ted.mIds[0] = ev.getPointerId(0);
                    ted.mPoints = new Point[1];
                    ted.mPoints[0] = new Point(contentX, contentY);
                    ted.mMetaState = ev.getMetaState();
                    ted.mReprocess = this.mDeferTouchProcess;
                    this.mWebViewCore.sendMessage(141, ted);
                    this.mLastSentTouchTime = eventTime;
                    if (this.mDeferTouchProcess) break;
                    if (firstMove && !this.inFullScreenMode()) {
                        this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(10, action, 0), 200L);
                    }
                }
                if (this.mTouchMode == 7 || this.mPreventDefault == 3) break;
                if (this.mVelocityTracker == null) {
                    Log.e("webview", "Got null mVelocityTracker when mPreventDefault = " + this.mPreventDefault + " mDeferTouchProcess = " + this.mDeferTouchProcess + " mTouchMode = " + this.mTouchMode);
                } else {
                    this.mVelocityTracker.addMovement(ev);
                }
                if (this.mSelectingText && this.mSelectionStarted) {
                    parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    v0 = x <= this.mMinAutoScrollX ? -5 : (this.mAutoScrollX = x >= this.mMaxAutoScrollX ? 5 : 0);
                    v1 = y <= this.mMinAutoScrollY ? -5 : (this.mAutoScrollY = y >= this.mMaxAutoScrollY ? 5 : 0);
                    if (!(this.mAutoScrollX == 0 && this.mAutoScrollY == 0 || this.mSentAutoScrollMessage)) {
                        this.mSentAutoScrollMessage = true;
                        this.mPrivateHandler.sendEmptyMessageDelayed(11, 16L);
                    }
                    if (deltaX == 0 && deltaY == 0) break;
                    this.nativeExtendSelection(contentX, contentY);
                    this.invalidate();
                    break;
                }
                if (this.mTouchMode != 3 && this.mTouchMode != 9) {
                    if (!this.mConfirmMove) break;
                    if (this.mPreventDefault == 1 || this.mPreventDefault == 2) {
                        this.mLastTouchTime = eventTime;
                        break;
                    }
                    detector = this.mZoomManager.getMultiTouchGestureDetector();
                    if (detector == null || !detector.isInProgress()) {
                        ax = Math.abs(deltaX);
                        if ((float)ax > 1.5f * (float)(ay = Math.abs(deltaY))) {
                            this.mSnapScrollMode = 2;
                            this.mSnapPositive = deltaX > 0;
                        } else if ((float)ay > 1.5f * (float)ax) {
                            this.mSnapScrollMode = 4;
                            this.mSnapPositive = deltaY > 0;
                        }
                    }
                    this.mTouchMode = 3;
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    deltaX = 0;
                    deltaY = 0;
                    this.startScrollingLayer(x, y);
                    this.startDrag();
                }
                done = false;
                keepScrollBarsVisible = false;
                if (deltaX == 0 && deltaY == 0) {
                    done = true;
                    keepScrollBarsVisible = true;
                } else {
                    if (this.mSnapScrollMode == 2 || this.mSnapScrollMode == 4) {
                        ax = Math.abs(deltaX);
                        ay = Math.abs(deltaY);
                        if (this.mSnapScrollMode == 2) {
                            if ((float)ay > 1.5f * (float)ax && ay > 80) {
                                this.mSnapScrollMode = 0;
                            }
                            if ((float)ax > 1.5f * (float)ay && (this.mSnapPositive != false ? deltaX < -this.mMinLockSnapReverseDistance : deltaX > this.mMinLockSnapReverseDistance)) {
                                this.mSnapScrollMode |= 1;
                            }
                        } else {
                            if ((float)ax > 1.5f * (float)ay && ax > 80) {
                                this.mSnapScrollMode = 0;
                            }
                            if ((float)ay > 1.5f * (float)ax && (this.mSnapPositive != false ? deltaY < -this.mMinLockSnapReverseDistance : deltaY > this.mMinLockSnapReverseDistance)) {
                                this.mSnapScrollMode |= 1;
                            }
                        }
                    }
                    if (this.mSnapScrollMode != 0) {
                        if ((this.mSnapScrollMode & 2) == 2) {
                            deltaY = 0;
                        } else {
                            deltaX = 0;
                        }
                    }
                    if ((deltaX | deltaY) != 0) {
                        if (deltaX != 0) {
                            this.mLastTouchX = x;
                        }
                        if (deltaY != 0) {
                            this.mLastTouchY = y;
                        }
                        this.mHeldMotionless = 0;
                    }
                    this.mLastTouchTime = eventTime;
                    this.mUserScroll = true;
                }
                this.doDrag(deltaX, deltaY);
                if (!keepScrollBarsVisible || this.mTouchMode == 9) break;
                if (this.mHeldMotionless != 2) {
                    this.mHeldMotionless = 2;
                    this.invalidate();
                }
                this.awakenScrollBars(ViewConfiguration.getScrollDefaultDelay(), false);
                return done == false;
            }
            case 1: {
                if (!this.isFocused()) {
                    this.requestFocus();
                }
                if (this.shouldForwardTouchEvent()) {
                    ted = new WebViewCore.TouchEventData();
                    ted.mIds = new int[1];
                    ted.mIds[0] = ev.getPointerId(0);
                    ted.mAction = action;
                    ted.mPoints = new Point[1];
                    ted.mPoints[0] = new Point(contentX, contentY);
                    ted.mMetaState = ev.getMetaState();
                    ted.mReprocess = this.mDeferTouchProcess;
                    this.mWebViewCore.sendMessage(141, ted);
                }
                this.mLastTouchUpTime = eventTime;
                if (this.mSentAutoScrollMessage) {
                    this.mAutoScrollY = 0;
                    this.mAutoScrollX = 0;
                }
                switch (this.mTouchMode) {
                    case 6: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        if (this.inFullScreenMode() || this.mDeferTouchProcess) {
                            ted = new WebViewCore.TouchEventData();
                            ted.mIds = new int[1];
                            ted.mIds[0] = ev.getPointerId(0);
                            ted.mAction = 512;
                            ted.mPoints = new Point[1];
                            ted.mPoints[0] = new Point(contentX, contentY);
                            ted.mMetaState = ev.getMetaState();
                            ted.mReprocess = this.mDeferTouchProcess;
                            this.mWebViewCore.sendMessage(141, ted);
                            break;
                        }
                        if (this.mPreventDefault == 3) break;
                        this.mZoomManager.handleDoubleTap(this.mLastTouchX, this.mLastTouchY);
                        this.mTouchMode = 7;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        if (!this.mConfirmMove) ** GOTO lbl235
                        Log.w("webview", "Miss a drag as we are waiting for WebCore's response for touch down.");
                        if (this.mPreventDefault != 3 && (this.computeMaxScrollX() > 0 || this.computeMaxScrollY() > 0)) {
                            WebViewCore.reducePriority();
                            WebViewCore.pauseUpdatePicture(this.mWebViewCore);
                        } else {
                            this.invalidate();
                            break;
lbl235:
                            // 1 sources

                            if (this.mSelectingText) {
                                if (this.nativeHitSelection(contentX, contentY)) break;
                                this.selectionDone();
                                break;
                            }
                            if (this.mTouchMode == 1 && (this.canZoomIn() || this.canZoomOut())) {
                                this.mPrivateHandler.sendEmptyMessageDelayed(5, ViewConfiguration.getDoubleTapTimeout());
                                break;
                            }
                            this.doShortPress();
                            break;
                        }
                    }
                    case 3: 
                    case 9: {
                        this.mPrivateHandler.removeMessages(8);
                        this.mPrivateHandler.removeMessages(9);
                        if (eventTime - this.mLastTouchTime <= 250L) {
                            if (this.mVelocityTracker == null) {
                                Log.e("webview", "Got null mVelocityTracker when mPreventDefault = " + this.mPreventDefault + " mDeferTouchProcess = " + this.mDeferTouchProcess);
                            } else {
                                this.mVelocityTracker.addMovement(ev);
                            }
                            this.mHeldMotionless = 3;
                            this.doFling();
                            break;
                        }
                        if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY())) {
                            this.invalidate();
                        }
                        this.mHeldMotionless = 2;
                        this.invalidate();
                    }
                    case 2: {
                        this.mLastVelocity = 0.0f;
                        WebViewCore.resumePriority();
                        if (this.mSelectingText) break;
                        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                    }
                }
                this.stopTouch();
                break;
            }
            case 3: {
                if (this.mTouchMode == 3) {
                    this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY());
                    this.invalidate();
                }
                this.cancelWebCoreTouchEvent(contentX, contentY, false);
                this.cancelTouch();
            }
        }
        return true;
    }

    public void passMultiTouchToWebKit(MotionEvent ev) {
        WebViewCore.TouchEventData ted = new WebViewCore.TouchEventData();
        ted.mAction = ev.getActionMasked();
        int count = ev.getPointerCount();
        ted.mIds = new int[count];
        ted.mPoints = new Point[count];
        for (int c = 0; c < count; ++c) {
            ted.mIds[c] = ev.getPointerId(c);
            int x = this.viewToContentX((int)ev.getX(c) + this.mScrollX);
            int y = this.viewToContentY((int)ev.getY(c) + this.mScrollY);
            ted.mPoints[c] = new Point(x, y);
        }
        ted.mMetaState = ev.getMetaState();
        ted.mReprocess = true;
        ted.mMotionEvent = MotionEvent.obtain(ev);
        this.mWebViewCore.sendMessage(141, ted);
        this.cancelLongPress();
        this.mPrivateHandler.removeMessages(4);
        this.mPreventDefault = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMultiTouchInWebView(MotionEvent ev) {
        int action;
        ScaleGestureDetector detector = this.mZoomManager.getMultiTouchGestureDetector();
        if (detector == null) {
            return;
        }
        float x = ev.getX();
        float y = ev.getY();
        if (!detector.isInProgress() && ev.getActionMasked() != 5) {
            MotionEvent temp = MotionEvent.obtain(ev);
            try {
                temp.setAction(temp.getAction() & 0xFFFFFF00 | 5);
                detector.onTouchEvent(temp);
                Object var7_7 = null;
                temp.recycle();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                temp.recycle();
                throw throwable;
            }
        }
        detector.onTouchEvent(ev);
        if (detector.isInProgress()) {
            this.mLastTouchTime = ev.getEventTime();
            x = detector.getFocusX();
            y = detector.getFocusY();
            this.cancelLongPress();
            this.mPrivateHandler.removeMessages(4);
            if (!this.mZoomManager.supportsPanDuringZoom()) {
                return;
            }
            this.mTouchMode = 3;
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
        }
        if ((action = ev.getActionMasked()) == 5) {
            this.cancelTouch();
            action = 0;
        } else if (action == 6) {
            this.mLastTouchX = Math.round(x);
            this.mLastTouchY = Math.round(y);
            this.mIsHandlingMultiTouch = false;
        } else if (action == 2 && (x < 0.0f || y < 0.0f)) {
            return;
        }
        this.handleTouchEventCommon(ev, action, Math.round(x), Math.round(y));
    }

    public void cancelWebCoreTouchEvent(int x, int y, boolean removeEvents) {
        if (this.shouldForwardTouchEvent()) {
            if (removeEvents) {
                this.mWebViewCore.removeMessages(141);
            }
            WebViewCore.TouchEventData ted = new WebViewCore.TouchEventData();
            ted.mIds = new int[1];
            ted.mIds[0] = 0;
            ted.mPoints = new Point[1];
            ted.mPoints[0] = new Point(x, y);
            ted.mAction = 3;
            this.mWebViewCore.sendMessage(141, ted);
            this.mPreventDefault = 4;
        }
    }

    public void startTouch(float x, float y, long eventTime) {
        this.mLastTouchX = Math.round(x);
        this.mLastTouchY = Math.round(y);
        this.mLastTouchTime = eventTime;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mSnapScrollMode = 0;
    }

    public void startDrag() {
        WebViewCore.reducePriority();
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        if (!this.mDragFromTextInput) {
            this.nativeHideCursor();
        }
        if (this.mHorizontalScrollBarMode != 1 || this.mVerticalScrollBarMode != 1) {
            this.mZoomManager.invokeZoomPicker();
        }
    }

    public void doDrag(int deltaX, int deltaY) {
        if ((deltaX | deltaY) != 0) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int rangeX = this.computeMaxScrollX();
            int rangeY = this.computeMaxScrollY();
            int overscrollDistance = this.mOverscrollDistance;
            if (this.mScrollingLayer != 0) {
                int contentX = this.viewToContentDimension(deltaX);
                int contentY = this.viewToContentDimension(deltaY);
                int maxX = this.mScrollingLayerRect.right;
                int maxY = this.mScrollingLayerRect.bottom;
                int resultX = Math.max(0, Math.min(this.mScrollingLayerRect.left + contentX, maxX));
                int resultY = Math.max(0, Math.min(this.mScrollingLayerRect.top + contentY, maxY));
                if (resultX != this.mScrollingLayerRect.left || resultY != this.mScrollingLayerRect.top) {
                    this.mTouchMode = 9;
                    deltaX = contentX;
                    deltaY = contentY;
                    oldX = this.mScrollingLayerRect.left;
                    oldY = this.mScrollingLayerRect.top;
                    rangeX = maxX;
                    rangeY = maxY;
                } else {
                    this.mTouchMode = 3;
                }
            }
            if (this.mOverScrollGlow != null) {
                this.mOverScrollGlow.setOverScrollDeltas(deltaX, deltaY);
            }
            this.overScrollBy(deltaX, deltaY, oldX, oldY, rangeX, rangeY, this.mOverscrollDistance, this.mOverscrollDistance, true);
            if (this.mOverScrollGlow != null && this.mOverScrollGlow.isAnimating()) {
                this.invalidate();
            }
        }
        this.mZoomManager.keepZoomPickerVisible();
    }

    public void stopTouch() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mOverScrollGlow != null) {
            this.mOverScrollGlow.releaseAll();
        }
    }

    public void cancelTouch() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (!(this.mTouchMode != 3 && this.mTouchMode != 9 || this.mSelectingText)) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
        }
        this.mPrivateHandler.removeMessages(3);
        this.mPrivateHandler.removeMessages(4);
        this.mPrivateHandler.removeMessages(8);
        this.mPrivateHandler.removeMessages(9);
        if (this.getSettings().supportTouchOnly()) {
            this.removeTouchHighlight(true);
        }
        this.mHeldMotionless = 2;
        this.mTouchMode = 7;
        this.nativeHideCursor();
    }

    public void setMapTrackballToArrowKeys(boolean setMap) {
        this.mMapTrackballToArrowKeys = setMap;
    }

    public void resetTrackballTime() {
        this.mTrackballLastTime = 0L;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent ev) {
        long time = ev.getEventTime();
        if ((ev.getMetaState() & 2) != 0) {
            if (ev.getY() > 0.0f) {
                this.pageDown(true);
            }
            if (ev.getY() < 0.0f) {
                this.pageUp(true);
            }
            return true;
        }
        if (ev.getAction() == 0) {
            if (this.mSelectingText) {
                return true;
            }
            this.mTrackballDown = true;
            if (this.mNativeClass == 0) {
                return false;
            }
            this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), true, true);
            if (time - this.mLastCursorTime <= 200L && !this.mLastCursorBounds.equals(this.nativeGetCursorRingBounds())) {
                this.nativeSelectBestAt(this.mLastCursorBounds);
            }
            if (this.isInTouchMode()) {
                this.requestFocusFromTouch();
            }
            return false;
        }
        if (ev.getAction() == 1) {
            this.mPrivateHandler.removeMessages(114);
            this.mTrackballDown = false;
            this.mTrackballUpTime = time;
            if (this.mSelectingText) {
                if (this.mExtendSelection) {
                    this.copySelection();
                    this.selectionDone();
                } else {
                    this.mExtendSelection = true;
                    this.nativeSetExtendSelection();
                    this.invalidate();
                }
                return true;
            }
            return false;
        }
        if (this.mMapTrackballToArrowKeys && (ev.getMetaState() & 1) == 0 || AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return false;
        }
        if (this.mTrackballDown) {
            return true;
        }
        if (time - this.mTrackballUpTime < 200L) {
            return true;
        }
        this.switchOutDrawHistory();
        if (time - this.mTrackballLastTime > 200L) {
            this.mTrackballFirstTime = time;
            this.mTrackballYMove = 0;
            this.mTrackballXMove = 0;
        }
        this.mTrackballLastTime = time;
        this.mTrackballRemainsX += ev.getX();
        this.mTrackballRemainsY += ev.getY();
        this.doTrackball(time, ev.getMetaState());
        return true;
    }

    public void moveSelection(float xRate, float yRate) {
        int scrollX;
        if (this.mNativeClass == 0) {
            return;
        }
        int width = this.getViewWidth();
        int height = this.getViewHeight();
        this.mSelectX = (int)((float)this.mSelectX + xRate);
        this.mSelectY = (int)((float)this.mSelectY + yRate);
        int maxX = width + this.mScrollX;
        int maxY = height + this.mScrollY;
        this.mSelectX = Math.min(maxX, Math.max(this.mScrollX - 16, this.mSelectX));
        this.mSelectY = Math.min(maxY, Math.max(this.mScrollY - 16, this.mSelectY));
        this.nativeMoveSelection(this.viewToContentX(this.mSelectX), this.viewToContentY(this.mSelectY));
        int n = this.mSelectX < this.mScrollX ? -16 : (scrollX = this.mSelectX > maxX - 16 ? 16 : 0);
        int scrollY = this.mSelectY < this.mScrollY ? -16 : (this.mSelectY > maxY - 16 ? 16 : 0);
        this.pinScrollBy(scrollX, scrollY, true, 0);
        Rect select = new Rect(this.mSelectX, this.mSelectY, this.mSelectX + 1, this.mSelectY + 1);
        this.requestRectangleOnScreen(select);
        this.invalidate();
    }

    public int scaleTrackballX(float xRate, int width) {
        int xMove;
        int nextXMove = xMove = (int)(xRate / 400.0f * (float)width);
        if (xMove > 0) {
            if (xMove > this.mTrackballXMove) {
                xMove -= this.mTrackballXMove;
            }
        } else if (xMove < this.mTrackballXMove) {
            xMove -= this.mTrackballXMove;
        }
        this.mTrackballXMove = nextXMove;
        return xMove;
    }

    public int scaleTrackballY(float yRate, int height) {
        int yMove;
        int nextYMove = yMove = (int)(yRate / 400.0f * (float)height);
        if (yMove > 0) {
            if (yMove > this.mTrackballYMove) {
                yMove -= this.mTrackballYMove;
            }
        } else if (yMove < this.mTrackballYMove) {
            yMove -= this.mTrackballYMove;
        }
        this.mTrackballYMove = nextYMove;
        return yMove;
    }

    public int keyCodeToSoundsEffect(int keyCode) {
        switch (keyCode) {
            case 19: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 1;
            }
        }
        throw new IllegalArgumentException("keyCode must be one of {KEYCODE_DPAD_UP, KEYCODE_DPAD_RIGHT, KEYCODE_DPAD_DOWN, KEYCODE_DPAD_LEFT}.");
    }

    public void doTrackball(long time, int metaState) {
        int elapsed = (int)(this.mTrackballLastTime - this.mTrackballFirstTime);
        if (elapsed == 0) {
            elapsed = 200;
        }
        float xRate = this.mTrackballRemainsX * 1000.0f / (float)elapsed;
        float yRate = this.mTrackballRemainsY * 1000.0f / (float)elapsed;
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeight();
        if (this.mSelectingText) {
            if (!this.mDrawSelectionPointer) {
                this.mSelectX = this.contentToViewX(this.nativeSelectionX());
                this.mSelectY = this.contentToViewY(this.nativeSelectionY());
                this.mExtendSelection = true;
                this.mDrawSelectionPointer = true;
                this.nativeSetExtendSelection();
            }
            this.moveSelection(this.scaleTrackballX(xRate, viewWidth), this.scaleTrackballY(yRate, viewHeight));
            this.mTrackballRemainsY = 0.0f;
            this.mTrackballRemainsX = 0.0f;
            return;
        }
        float ax = Math.abs(xRate);
        float ay = Math.abs(yRate);
        float maxA = Math.max(ax, ay);
        int width = this.mContentWidth - viewWidth;
        int height = this.mContentHeight - viewHeight;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        ax = Math.abs(this.mTrackballRemainsX * 3.0f);
        ay = Math.abs(this.mTrackballRemainsY * 3.0f);
        maxA = Math.max(ax, ay);
        int count = Math.max(0, (int)maxA);
        int oldScrollX = this.mScrollX;
        int oldScrollY = this.mScrollY;
        if (count > 0) {
            int selectKeyCode = ax < ay ? (this.mTrackballRemainsY < 0.0f ? 19 : 20) : (this.mTrackballRemainsX < 0.0f ? 21 : 22);
            count = Math.min(count, 10);
            if (this.mNativeClass != 0 && this.nativePageShouldHandleShiftAndArrows()) {
                for (int i = 0; i < count; ++i) {
                    this.letPageHandleNavKey(selectKeyCode, time, true, metaState);
                }
                this.letPageHandleNavKey(selectKeyCode, time, false, metaState);
            } else if (this.navHandledKey(selectKeyCode, count, false, time)) {
                this.playSoundEffect(this.keyCodeToSoundsEffect(selectKeyCode));
            }
            this.mTrackballRemainsY = 0.0f;
            this.mTrackballRemainsX = 0.0f;
        }
        if (count >= 5) {
            int xMove = this.scaleTrackballX(xRate, width);
            int yMove = this.scaleTrackballY(yRate, height);
            if (Math.abs(this.mScrollX - oldScrollX) > Math.abs(xMove)) {
                xMove = 0;
            }
            if (Math.abs(this.mScrollY - oldScrollY) > Math.abs(yMove)) {
                yMove = 0;
            }
            if (xMove != 0 || yMove != 0) {
                this.pinScrollBy(xMove, yMove, true, 0);
            }
            this.mUserScroll = true;
        }
    }

    public int computeMaxScrollX() {
        return Math.max(this.computeRealHorizontalScrollRange() - this.getViewWidth(), 0);
    }

    public int computeMaxScrollY() {
        return Math.max(this.computeRealVerticalScrollRange() + this.getTitleHeight() - this.getViewHeightWithTitle(), 0);
    }

    public boolean updateScrollCoordinates(int x, int y) {
        int oldX = this.mScrollX;
        int oldY = this.mScrollY;
        this.mScrollX = x;
        this.mScrollY = y;
        if (oldX != this.mScrollX || oldY != this.mScrollY) {
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            return true;
        }
        return false;
    }

    public void flingScroll(int vx, int vy) {
        this.mScroller.fling(this.mScrollX, this.mScrollY, vx, vy, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY(), this.mOverflingDistance, this.mOverflingDistance);
        this.invalidate();
    }

    public void doFling() {
        if (this.mVelocityTracker == null) {
            return;
        }
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFling);
        int vx = (int)this.mVelocityTracker.getXVelocity();
        int vy = (int)this.mVelocityTracker.getYVelocity();
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int overscrollDistance = this.mOverscrollDistance;
        int overflingDistance = this.mOverflingDistance;
        if (this.mTouchMode == 9) {
            scrollX = this.mScrollingLayerRect.left;
            scrollY = this.mScrollingLayerRect.top;
            maxX = this.mScrollingLayerRect.right;
            maxY = this.mScrollingLayerRect.bottom;
            overflingDistance = 0;
            overscrollDistance = 0;
        }
        if (this.mSnapScrollMode != 0) {
            if ((this.mSnapScrollMode & 2) == 2) {
                vy = 0;
            } else {
                vx = 0;
            }
        }
        vx = vx * 3 / 4;
        vy = vy * 3 / 4;
        if (maxX == 0 && vy == 0 || maxY == 0 && vx == 0) {
            WebViewCore.resumePriority();
            if (!this.mSelectingText) {
                WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            }
            if (this.mScroller.springBack(scrollX, scrollY, 0, maxX, 0, maxY)) {
                this.invalidate();
            }
            return;
        }
        float currentVelocity = this.mScroller.getCurrVelocity();
        float velocity = (float)Math.hypot(vx, vy);
        if (this.mLastVelocity > 0.0f && currentVelocity > 0.0f && velocity > this.mLastVelocity * 0.2f) {
            float deltaR = (float)Math.abs(Math.atan2(this.mLastVelY, this.mLastVelX) - Math.atan2(vy, vx));
            float circle = (float)Math.PI * 2;
            if (deltaR > 5.6548667f || deltaR < 0.62831855f) {
                vx = (int)((float)vx + currentVelocity * this.mLastVelX / this.mLastVelocity);
                vy = (int)((float)vy + currentVelocity * this.mLastVelY / this.mLastVelocity);
                velocity = (float)Math.hypot(vx, vy);
            }
        }
        if ((scrollX == 0 || scrollX == maxX) && Math.abs(vx) < Math.abs(vy)) {
            vx = 0;
        }
        if ((scrollY == 0 || scrollY == maxY) && Math.abs(vy) < Math.abs(vx)) {
            vy = 0;
        }
        if (overscrollDistance < overflingDistance) {
            if (vx > 0 && scrollX == -overscrollDistance || vx < 0 && scrollX == maxX + overscrollDistance) {
                vx = 0;
            }
            if (vy > 0 && scrollY == -overscrollDistance || vy < 0 && scrollY == maxY + overscrollDistance) {
                vy = 0;
            }
        }
        this.mLastVelX = vx;
        this.mLastVelY = vy;
        this.mLastVelocity = velocity;
        this.mScroller.fling(scrollX, scrollY, -vx, -vy, 0, maxX, 0, maxY, maxX == 0 ? 0 : overflingDistance, overflingDistance);
        int time = this.mScroller.getDuration();
        if (this.mTouchMode != 9) {
            this.awakenScrollBars(time);
        }
        this.invalidate();
    }

    @Deprecated
    public View getZoomControls() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return null;
        }
        return this.mZoomManager.getExternalZoomPicker();
    }

    public void dismissZoomControl() {
        this.mZoomManager.dismissZoomPicker();
    }

    public float getDefaultZoomScale() {
        return this.mZoomManager.getDefaultScale();
    }

    public boolean canZoomIn() {
        return this.mZoomManager.canZoomIn();
    }

    public boolean canZoomOut() {
        return this.mZoomManager.canZoomOut();
    }

    public boolean zoomIn() {
        return this.mZoomManager.zoomIn();
    }

    public boolean zoomOut() {
        return this.mZoomManager.zoomOut();
    }

    public void updateSelection() {
        if (this.mNativeClass == 0) {
            return;
        }
        int contentX = this.viewToContentX(this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY(this.mLastTouchY + this.mScrollY);
        Rect rect = new Rect(contentX - this.mNavSlop, contentY - this.mNavSlop, contentX + this.mNavSlop, contentY + this.mNavSlop);
        this.nativeSelectBestAt(rect);
        this.mInitialHitTestResult = this.hitTestResult(null);
    }

    public void scrollFocusedTextInputX(float xPercent) {
        if (!this.inEditingMode() || this.mWebViewCore == null) {
            return;
        }
        this.mWebViewCore.sendMessage(99, 0, new Float(xPercent));
    }

    public void scrollFocusedTextInputY(int y) {
        if (!this.inEditingMode() || this.mWebViewCore == null) {
            return;
        }
        this.mWebViewCore.sendMessage(99, 0, this.viewToContentDimension(y));
    }

    public void initiateTextFieldDrag(float x, float y, long eventTime) {
        if (!this.inEditingMode()) {
            return;
        }
        this.mLastTouchX = Math.round(x + (float)this.mWebTextView.getLeft() - (float)this.mScrollX);
        this.mLastTouchY = Math.round(y + (float)this.mWebTextView.getTop() - (float)this.mScrollY);
        this.mLastTouchTime = eventTime;
        if (!this.mScroller.isFinished()) {
            this.abortAnimation();
            this.mPrivateHandler.removeMessages(7);
        }
        this.mSnapScrollMode = 0;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mTouchMode = 2;
    }

    public boolean textFieldDrag(MotionEvent event) {
        if (!this.inEditingMode()) {
            return false;
        }
        this.mDragFromTextInput = true;
        event.offsetLocation(this.mWebTextView.getLeft() - this.mScrollX, this.mWebTextView.getTop() - this.mScrollY);
        boolean result = this.onTouchEvent(event);
        this.mDragFromTextInput = false;
        return result;
    }

    public void touchUpOnTextField(MotionEvent event) {
        if (!this.inEditingMode()) {
            return;
        }
        int x = this.viewToContentX((int)event.getX() + this.mWebTextView.getLeft());
        int y = this.viewToContentY((int)event.getY() + this.mWebTextView.getTop());
        this.nativeMotionUp(x, y, this.mNavSlop);
    }

    public void centerKeyPressOnTextField() {
        this.mWebViewCore.sendMessage(118, this.nativeCursorFramePointer(), this.nativeCursorNodePointer());
    }

    public void doShortPress() {
        if (this.mNativeClass == 0) {
            return;
        }
        if (this.mPreventDefault == 3) {
            return;
        }
        this.mTouchMode = 7;
        this.switchOutDrawHistory();
        int contentX = this.viewToContentX(this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY(this.mLastTouchY + this.mScrollY);
        if (this.getSettings().supportTouchOnly()) {
            this.removeTouchHighlight(false);
            WebViewCore.TouchUpData touchUpData = new WebViewCore.TouchUpData();
            touchUpData.mMoveGeneration = 0;
            this.mWebViewCore.sendMessage(140, touchUpData);
        } else if (this.nativePointInNavCache(contentX, contentY, this.mNavSlop)) {
            WebViewCore.MotionUpData motionUpData = new WebViewCore.MotionUpData();
            motionUpData.mFrame = this.nativeCacheHitFramePointer();
            motionUpData.mNode = this.nativeCacheHitNodePointer();
            motionUpData.mBounds = this.nativeCacheHitNodeBounds();
            motionUpData.mX = contentX;
            motionUpData.mY = contentY;
            this.mWebViewCore.sendMessageAtFrontOfQueue(146, motionUpData);
        } else {
            this.doMotionUp(contentX, contentY);
        }
    }

    public void doMotionUp(int contentX, int contentY) {
        if (this.nativeMotionUp(contentX, contentY, this.mNavSlop) && mLogEvent) {
            EventLog.writeEvent(70150, new Object[0]);
        }
        if (this.nativeHasCursorNode() && !this.nativeCursorIsTextInput()) {
            this.playSoundEffect(0);
        }
    }

    public Rect getPluginBounds(int x, int y) {
        if (this.nativePointInNavCache(x, y, this.mNavSlop) && this.nativeCacheHitIsPlugin()) {
            return this.nativeCacheHitNodeBounds();
        }
        return null;
    }

    public boolean isRectFitOnScreen(Rect rect) {
        int rectWidth = rect.width();
        int rectHeight = rect.height();
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeightWithTitle();
        float scale = Math.min((float)viewWidth / (float)rectWidth, (float)viewHeight / (float)rectHeight);
        return !this.mZoomManager.willScaleTriggerZoom(scale = this.mZoomManager.computeScaleWithLimits(scale)) && this.contentToViewX(rect.left) >= this.mScrollX && this.contentToViewX(rect.right) <= this.mScrollX + viewWidth && this.contentToViewY(rect.top) >= this.mScrollY && this.contentToViewY(rect.bottom) <= this.mScrollY + viewHeight;
    }

    public void centerFitRect(Rect rect) {
        int rectWidth = rect.width();
        int rectHeight = rect.height();
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeightWithTitle();
        float scale = Math.min((float)viewWidth / (float)rectWidth, (float)viewHeight / (float)rectHeight);
        if (!this.mZoomManager.willScaleTriggerZoom(scale = this.mZoomManager.computeScaleWithLimits(scale))) {
            this.pinScrollTo(this.contentToViewX(rect.left + rectWidth / 2) - viewWidth / 2, this.contentToViewY(rect.top + rectHeight / 2) - viewHeight / 2, true, 0);
        } else {
            float actualScale = this.mZoomManager.getScale();
            float oldScreenX = (float)rect.left * actualScale - (float)this.mScrollX;
            float rectViewX = (float)rect.left * scale;
            float rectViewWidth = (float)rectWidth * scale;
            float newMaxWidth = (float)this.mContentWidth * scale;
            float newScreenX = ((float)viewWidth - rectViewWidth) / 2.0f;
            if (newScreenX > rectViewX) {
                newScreenX = rectViewX;
            } else if (newScreenX > newMaxWidth - rectViewX - rectViewWidth) {
                newScreenX = (float)viewWidth - (newMaxWidth - rectViewX);
            }
            float zoomCenterX = (oldScreenX * scale - newScreenX * actualScale) / (scale - actualScale);
            float oldScreenY = (float)rect.top * actualScale + (float)this.getTitleHeight() - (float)this.mScrollY;
            float rectViewY = (float)rect.top * scale + (float)this.getTitleHeight();
            float rectViewHeight = (float)rectHeight * scale;
            float newMaxHeight = (float)this.mContentHeight * scale + (float)this.getTitleHeight();
            float newScreenY = ((float)viewHeight - rectViewHeight) / 2.0f;
            if (newScreenY > rectViewY) {
                newScreenY = rectViewY;
            } else if (newScreenY > newMaxHeight - rectViewY - rectViewHeight) {
                newScreenY = (float)viewHeight - (newMaxHeight - rectViewY);
            }
            float zoomCenterY = (oldScreenY * scale - newScreenY * actualScale) / (scale - actualScale);
            this.mZoomManager.setZoomCenter(zoomCenterX, zoomCenterY);
            this.mZoomManager.startZoomAnimation(scale, false);
        }
    }

    public void overrideLoading(String url) {
        this.mCallbackProxy.uiOverrideUrlLoading(url);
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (this.mFindIsUp) {
            return false;
        }
        boolean result = false;
        if (this.inEditingMode()) {
            result = this.mWebTextView.requestFocus(direction, previouslyFocusedRect);
        } else {
            result = super.requestFocus(direction, previouslyFocusedRect);
            if (this.mWebViewCore.getSettings().getNeedInitialFocus() && !this.isInTouchMode()) {
                int fakeKeyDirection = 0;
                switch (direction) {
                    case 33: {
                        fakeKeyDirection = 19;
                        break;
                    }
                    case 130: {
                        fakeKeyDirection = 20;
                        break;
                    }
                    case 17: {
                        fakeKeyDirection = 21;
                        break;
                    }
                    case 66: {
                        fakeKeyDirection = 22;
                        break;
                    }
                    default: {
                        return result;
                    }
                }
                if (this.mNativeClass != 0 && !this.nativeHasCursorNode()) {
                    this.navHandledKey(fakeKeyDirection, 1, true, 0L);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int measuredHeight = heightSize;
        int measuredWidth = widthSize;
        int contentHeight = this.contentToViewDimension(this.mContentHeight);
        int contentWidth = this.contentToViewDimension(this.mContentWidth);
        if (heightMode != 0x40000000) {
            this.mHeightCanMeasure = true;
            measuredHeight = contentHeight;
            if (heightMode == Integer.MIN_VALUE) {
                if (measuredHeight > heightSize) {
                    measuredHeight = heightSize;
                    this.mHeightCanMeasure = false;
                } else if (measuredHeight < heightSize) {
                    measuredHeight |= 0x1000000;
                }
            }
        } else {
            this.mHeightCanMeasure = false;
        }
        if (this.mNativeClass != 0) {
            this.nativeSetHeightCanMeasure(this.mHeightCanMeasure);
        }
        if (widthMode == 0) {
            this.mWidthCanMeasure = true;
            measuredWidth = contentWidth;
        } else {
            if (measuredWidth < contentWidth) {
                measuredWidth |= 0x1000000;
            }
            this.mWidthCanMeasure = false;
        }
        _Original_WebView _Original_WebView2 = this;
        synchronized (_Original_WebView2) {
            this.setMeasuredDimension(measuredWidth, measuredHeight);
        }
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (this.mZoomManager.isFixedLengthAnimationInProgress()) {
            return false;
        }
        rect.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        Rect content = new Rect(this.viewToContentX(this.mScrollX), this.viewToContentY(this.mScrollY), this.viewToContentX(this.mScrollX + this.getWidth() - this.getVerticalScrollbarWidth()), this.viewToContentY(this.mScrollY + this.getViewHeightWithTitle()));
        content = this.nativeSubtractLayers(content);
        int screenTop = this.contentToViewY(content.top);
        int screenBottom = this.contentToViewY(content.bottom);
        int height = screenBottom - screenTop;
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom) {
            int oneThirdOfScreenHeight = height / 3;
            scrollYDelta = rect.height() > 2 * oneThirdOfScreenHeight ? rect.top - screenTop : rect.top - (screenTop + oneThirdOfScreenHeight);
        } else if (rect.top < screenTop) {
            scrollYDelta = rect.top - screenTop;
        }
        int screenLeft = this.contentToViewX(content.left);
        int screenRight = this.contentToViewX(content.right);
        int width = screenRight - screenLeft;
        int scrollXDelta = 0;
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
        } else if (rect.left < screenLeft) {
            scrollXDelta -= screenLeft - rect.left;
        }
        if ((scrollYDelta | scrollXDelta) != 0) {
            return this.pinScrollBy(scrollXDelta, scrollYDelta, !immediate, 0);
        }
        return false;
    }

    public void replaceTextfieldText(int oldStart, int oldEnd, String replace, int newStart, int newEnd) {
        WebViewCore.ReplaceTextData arg = new WebViewCore.ReplaceTextData();
        arg.mReplace = replace;
        arg.mNewStart = newStart;
        arg.mNewEnd = newEnd;
        ++this.mTextGeneration;
        arg.mTextGeneration = this.mTextGeneration;
        this.mWebViewCore.sendMessage(114, oldStart, oldEnd, arg);
    }

    public void passToJavaScript(String currentText, KeyEvent event) {
        WebViewCore.JSKeyData arg = new WebViewCore.JSKeyData();
        arg.mEvent = event;
        arg.mCurrentText = currentText;
        ++this.mTextGeneration;
        this.mWebViewCore.sendMessage(115, this.mTextGeneration, 0, arg);
        this.mWebViewCore.removeMessages(128);
        this.mWebViewCore.sendMessageDelayed(128, this.cursorData(), 1000L);
    }

    public synchronized WebViewCore getWebViewCore() {
        return this.mWebViewCore;
    }

    public void updateTextSelectionFromMessage(int nodePointer, int textGeneration, WebViewCore.TextSelectionData data) {
        if (this.inEditingMode() && this.mWebTextView.isSameTextField(nodePointer) && textGeneration == this.mTextGeneration) {
            this.mWebTextView.setSelectionFromWebKit(data.mStart, data.mEnd);
        }
    }

    public void requestListBox(String[] array2, int[] enabledArray, int[] selectedArray) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selectedArray, null));
    }

    public void requestListBox(String[] array2, int[] enabledArray, int selection) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selection, null));
    }

    public void sendMoveFocus(int frame, int node) {
        this.mWebViewCore.sendMessage(127, new WebViewCore.CursorData(frame, node, 0, 0));
    }

    public void sendMoveMouse(int frame, int node, int x, int y) {
        this.mWebViewCore.sendMessage(135, new WebViewCore.CursorData(frame, node, x, y));
    }

    public void sendMoveMouseIfLatest(boolean removeFocus) {
        if (removeFocus) {
            this.clearTextEntry();
        }
        this.mWebViewCore.sendMessage(136, this.cursorData());
    }

    public void sendMotionUp(int touchGeneration, int frame, int node, int x, int y) {
        WebViewCore.TouchUpData touchUpData = new WebViewCore.TouchUpData();
        touchUpData.mMoveGeneration = touchGeneration;
        touchUpData.mFrame = frame;
        touchUpData.mNode = node;
        touchUpData.mX = x;
        touchUpData.mY = y;
        this.mWebViewCore.sendMessage(140, touchUpData);
    }

    public int getScaledMaxXScroll() {
        int width;
        if (!this.mHeightCanMeasure) {
            width = this.getViewWidth() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            width = visRect.width() / 2;
        }
        return this.viewToContentX(width);
    }

    public int getScaledMaxYScroll() {
        int height;
        if (!this.mHeightCanMeasure) {
            height = this.getViewHeight() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            height = visRect.height() / 2;
        }
        return Math.round((float)height * this.mZoomManager.getInvScale());
    }

    public void viewInvalidate() {
        this.invalidate();
    }

    public void letPageHandleNavKey(int keyCode, long time, boolean down, int metaState) {
        int eventHubAction;
        int keyEventAction;
        if (down) {
            keyEventAction = 0;
            eventHubAction = 103;
            this.playSoundEffect(this.keyCodeToSoundsEffect(keyCode));
        } else {
            keyEventAction = 1;
            eventHubAction = 104;
        }
        KeyEvent event = new KeyEvent(time, time, keyEventAction, keyCode, 1, metaState & 1 | metaState & 2 | metaState & 4, -1, 0, 0);
        this.mWebViewCore.sendMessage(eventHubAction, event);
    }

    public boolean navHandledKey(int keyCode, int count, boolean noScroll, long time) {
        boolean keyHandled;
        if (this.mNativeClass == 0) {
            return false;
        }
        this.mInitialHitTestResult = null;
        this.mLastCursorTime = time;
        this.mLastCursorBounds = this.nativeGetCursorRingBounds();
        boolean bl = keyHandled = !this.nativeMoveCursor(keyCode, count, noScroll);
        if (!keyHandled) {
            return keyHandled;
        }
        Rect contentCursorRingBounds = this.nativeGetCursorRingBounds();
        if (contentCursorRingBounds.isEmpty()) {
            return keyHandled;
        }
        Rect viewCursorRingBounds = this.contentToViewRect(contentCursorRingBounds);
        this.mLastTouchX = (viewCursorRingBounds.left + viewCursorRingBounds.right) / 2;
        this.mLastTouchY = (viewCursorRingBounds.top + viewCursorRingBounds.bottom) / 2;
        if (!this.mHeightCanMeasure) {
            return keyHandled;
        }
        Rect visRect = new Rect();
        this.calcOurVisibleRect(visRect);
        Rect outset = new Rect(visRect);
        int maxXScroll = visRect.width() / 2;
        int maxYScroll = visRect.height() / 2;
        outset.inset(-maxXScroll, -maxYScroll);
        if (!Rect.intersects(outset, viewCursorRingBounds)) {
            return keyHandled;
        }
        int maxH = Math.min(viewCursorRingBounds.right - visRect.right, maxXScroll);
        if (maxH > 0) {
            this.pinScrollBy(maxH, 0, true, 0);
        } else {
            maxH = Math.max(viewCursorRingBounds.left - visRect.left, -maxXScroll);
            if (maxH < 0) {
                this.pinScrollBy(maxH, 0, true, 0);
            }
        }
        if (this.mLastCursorBounds.isEmpty()) {
            return keyHandled;
        }
        if (this.mLastCursorBounds.equals(contentCursorRingBounds)) {
            return keyHandled;
        }
        this.requestRectangleOnScreen(viewCursorRingBounds);
        this.mUserScroll = true;
        return keyHandled;
    }

    public boolean accessibilityScriptInjected() {
        return this.mAccessibilityScriptInjected;
    }

    @Override
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.mWebViewCore.sendMessage(126, color2);
    }

    public void debugDump() {
        this.nativeDebugDump();
        this.mWebViewCore.sendMessage(172);
    }

    public void drawPage(Canvas canvas) {
        this.nativeDraw(canvas, 0, 0, false);
    }

    public void setExpandedTileBounds(boolean enabled) {
        this.nativeSetExpandedTileBounds(enabled);
    }

    public void setTouchInterval(int interval) {
        this.mCurrentTouchInterval = interval;
    }

    public void updateCachedTextfield(String updatedText) {
        this.nativeUpdateCachedTextfield(updatedText, this.mTextGeneration);
    }

    public void autoFillForm(int autoFillQueryId) {
        this.mWebViewCore.sendMessage(192, autoFillQueryId, 0);
    }

    public ViewManager getViewManager() {
        return this.mViewManager;
    }

    public int nativeCacheHitFramePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCacheHitFramePointer()I", true, this);
    }

    public boolean nativeCacheHitIsPlugin() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCacheHitIsPlugin()Z", true, this) != 0;
    }

    public Rect nativeCacheHitNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCacheHitNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public int nativeCacheHitNodePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCacheHitNodePointer()I", true, this);
    }

    public void nativeClearCursor() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeClearCursor()V", true, this);
    }

    public void nativeCreate(int n) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeCreate(I)V", true, this);
    }

    public int nativeCursorFramePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorFramePointer()I", true, this);
    }

    public Rect nativeCursorNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCursorNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public int nativeCursorNodePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorNodePointer()I", true, this);
    }

    public boolean nativeCursorIntersects(Rect rect) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorIntersects(Landroid/graphics/Rect;)Z", true, this) != 0;
    }

    public boolean nativeCursorIsAnchor() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorIsAnchor()Z", true, this) != 0;
    }

    public boolean nativeCursorIsTextInput() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorIsTextInput()Z", true, this) != 0;
    }

    public Point nativeCursorPosition() {
        return (Point)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCursorPosition()Landroid/graphics/Point;", true, this);
    }

    public String nativeCursorText() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCursorText()Ljava/lang/String;", true, this);
    }

    public boolean nativeCursorWantsKeyEvents() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorWantsKeyEvents()Z", true, this) != 0;
    }

    public void nativeDebugDump() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeDebugDump()V", true, this);
    }

    public void nativeDestroy() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeDestroy()V", true, this);
    }

    public int nativeDraw(Canvas canvas, int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeDraw(Landroid/graphics/Canvas;IIZ)I", true, this);
    }

    public void nativeDumpDisplayTree(String string2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeDumpDisplayTree(Ljava/lang/String;)V", true, this);
    }

    public boolean nativeEvaluateLayersAnimations() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeEvaluateLayersAnimations()Z", true, this) != 0;
    }

    public int nativeGetDrawGLFunction(Rect rect, float f, int n) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeGetDrawGLFunction(Landroid/graphics/Rect;FI)I", true, this);
    }

    public void nativeUpdateDrawGLFunction(Rect rect) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeUpdateDrawGLFunction(Landroid/graphics/Rect;)V", true, this);
    }

    public boolean nativeDrawGL(Rect rect, float f, int n) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeDrawGL(Landroid/graphics/Rect;FI)Z", true, this) != 0;
    }

    public void nativeExtendSelection(int n, int n2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeExtendSelection(II)V", true, this);
    }

    public int nativeFindAll(String string2, String string3, boolean bl) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFindAll(Ljava/lang/String;Ljava/lang/String;Z)I", true, this);
    }

    public void nativeFindNext(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeFindNext(Z)V", true, this);
    }

    public int nativeFocusCandidateFramePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateFramePointer()I", true, this);
    }

    public boolean nativeFocusCandidateHasNextTextfield() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateHasNextTextfield()Z", true, this) != 0;
    }

    public boolean nativeFocusCandidateIsPassword() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateIsPassword()Z", true, this) != 0;
    }

    public boolean nativeFocusCandidateIsRtlText() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateIsRtlText()Z", true, this) != 0;
    }

    public boolean nativeFocusCandidateIsTextInput() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateIsTextInput()Z", true, this) != 0;
    }

    public int nativeFocusCandidateMaxLength() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateMaxLength()I", true, this);
    }

    public boolean nativeFocusCandidateIsAutoComplete() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateIsAutoComplete()Z", true, this) != 0;
    }

    public String nativeFocusCandidateName() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidateName()Ljava/lang/String;", true, this);
    }

    public Rect nativeFocusCandidateNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidateNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public Rect nativeFocusCandidatePaddingRect() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidatePaddingRect()Landroid/graphics/Rect;", true, this);
    }

    public int nativeFocusCandidatePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidatePointer()I", true, this);
    }

    public String nativeFocusCandidateText() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidateText()Ljava/lang/String;", true, this);
    }

    public float nativeFocusCandidateTextSize() {
        return OverrideMethod.invokeF("android.webkit._Original_WebView#nativeFocusCandidateTextSize()F", true, this);
    }

    public int nativeFocusCandidateLineHeight() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateLineHeight()I", true, this);
    }

    public int nativeFocusCandidateType() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateType()I", true, this);
    }

    public boolean nativeFocusIsPlugin() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusIsPlugin()Z", true, this) != 0;
    }

    public Rect nativeFocusNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public int nativeFocusNodePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusNodePointer()I", true, this);
    }

    public Rect nativeGetCursorRingBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeGetCursorRingBounds()Landroid/graphics/Rect;", true, this);
    }

    public String nativeGetSelection() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeGetSelection()Ljava/lang/String;", true, this);
    }

    public boolean nativeHasCursorNode() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeHasCursorNode()Z", true, this) != 0;
    }

    public boolean nativeHasFocusNode() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeHasFocusNode()Z", true, this) != 0;
    }

    public void nativeHideCursor() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeHideCursor()V", true, this);
    }

    public boolean nativeHitSelection(int n, int n2) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeHitSelection(II)Z", true, this) != 0;
    }

    public String nativeImageURI(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeImageURI(II)Ljava/lang/String;", true, this);
    }

    public void nativeInstrumentReport() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeInstrumentReport()V", true, this);
    }

    public Rect nativeLayerBounds(int n) {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeLayerBounds(I)Landroid/graphics/Rect;", true, this);
    }

    public boolean nativeMoveCursorToNextTextInput() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMoveCursorToNextTextInput()Z", true, this) != 0;
    }

    public boolean nativeMotionUp(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMotionUp(III)Z", true, this) != 0;
    }

    public boolean nativeMoveCursor(int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMoveCursor(IIZ)Z", true, this) != 0;
    }

    public int nativeMoveGeneration() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMoveGeneration()I", true, this);
    }

    public void nativeMoveSelection(int n, int n2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeMoveSelection(II)V", true, this);
    }

    public boolean nativePageShouldHandleShiftAndArrows() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativePageShouldHandleShiftAndArrows()Z", true, this) != 0;
    }

    public boolean nativePointInNavCache(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativePointInNavCache(III)Z", true, this) != 0;
    }

    public void nativeRecordButtons(boolean bl, boolean bl2, boolean bl3) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeRecordButtons(ZZZ)V", true, this);
    }

    public void nativeResetSelection() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeResetSelection()V", true, this);
    }

    public Point nativeSelectableText() {
        return (Point)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeSelectableText()Landroid/graphics/Point;", true, this);
    }

    public void nativeSelectAll() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSelectAll()V", true, this);
    }

    public void nativeSelectBestAt(Rect rect) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSelectBestAt(Landroid/graphics/Rect;)V", true, this);
    }

    public void nativeSelectAt(int n, int n2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSelectAt(II)V", true, this);
    }

    public int nativeSelectionX() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeSelectionX()I", true, this);
    }

    public int nativeSelectionY() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeSelectionY()I", true, this);
    }

    public int nativeFindIndex() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFindIndex()I", true, this);
    }

    public void nativeSetExtendSelection() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetExtendSelection()V", true, this);
    }

    public void nativeSetFindIsEmpty() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetFindIsEmpty()V", true, this);
    }

    public void nativeSetFindIsUp(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetFindIsUp(Z)V", true, this);
    }

    public void nativeSetHeightCanMeasure(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetHeightCanMeasure(Z)V", true, this);
    }

    public void nativeSetBaseLayer(int n, Rect rect) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetBaseLayer(ILandroid/graphics/Rect;)V", true, this);
    }

    public void nativeShowCursorTimed() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeShowCursorTimed()V", true, this);
    }

    public void nativeReplaceBaseContent(int n) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeReplaceBaseContent(I)V", true, this);
    }

    public void nativeCopyBaseContentToPicture(Picture picture) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeCopyBaseContentToPicture(Landroid/graphics/Picture;)V", true, this);
    }

    public boolean nativeHasContent() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeHasContent()Z", true, this) != 0;
    }

    public void nativeSetSelectionPointer(boolean bl, float f, int n, int n2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetSelectionPointer(ZFII)V", true, this);
    }

    public boolean nativeStartSelection(int n, int n2) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeStartSelection(II)Z", true, this) != 0;
    }

    public void nativeStopGL() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeStopGL()V", true, this);
    }

    public Rect nativeSubtractLayers(Rect rect) {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeSubtractLayers(Landroid/graphics/Rect;)Landroid/graphics/Rect;", true, this);
    }

    public int nativeTextGeneration() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeTextGeneration()I", true, this);
    }

    public void nativeUpdateCachedTextfield(String string2, int n) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeUpdateCachedTextfield(Ljava/lang/String;I)V", true, this);
    }

    public boolean nativeWordSelection(int n, int n2) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeWordSelection(II)Z", true, this) != 0;
    }

    public int nativeGetBlockLeftEdge(int n, int n2, float f) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeGetBlockLeftEdge(IIF)I", true, this);
    }

    public void nativeSetExpandedTileBounds(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetExpandedTileBounds(Z)V", true, this);
    }

    public int nativeScrollableLayer(int n, int n2, Rect rect, Rect rect2) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeScrollableLayer(IILandroid/graphics/Rect;Landroid/graphics/Rect;)I", true, this);
    }

    public boolean nativeScrollLayer(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeScrollLayer(III)Z", true, this) != 0;
    }

    public static /* synthetic */ Context access$400(_Original_WebView x0) {
        return x0.mContext;
    }

    public static /* synthetic */ void access$600(_Original_WebView x0, Picture x1, Bundle x2) {
        x0.restoreHistoryPictureFields(x1, x2);
    }

    public static /* synthetic */ int access$1502(_Original_WebView x0, int x1) {
        x0.mTouchHighlightX = x1;
        return x0.mTouchHighlightX;
    }

    public static /* synthetic */ int access$1602(_Original_WebView x0, int x1) {
        x0.mTouchHighlightY = x1;
        return x0.mTouchHighlightY;
    }

    public static /* synthetic */ Message access$10702(_Original_WebView x0, Message x1) {
        x0.mListBoxMessage = x1;
        return x0.mListBoxMessage;
    }

    static {
        HandlerPrivateDebugString = new String[]{"REMEMBER_PASSWORD", "NEVER_REMEMBER_PASSWORD", "SWITCH_TO_SHORTPRESS", "SWITCH_TO_LONGPRESS", "RELEASE_SINGLE_TAP", "REQUEST_FORM_DATA", "RESUME_WEBCORE_PRIORITY", "DRAG_HELD_MOTIONLESS", "AWAKEN_SCROLL_BARS", "PREVENT_DEFAULT_TIMEOUT", "SCROLL_SELECT_TEXT"};
        HandlerPackageDebugString = new String[]{"SCROLL_TO_MSG_ID", "SCROLL_BY_MSG_ID", "SPAWN_SCROLL_TO_MSG_ID", "SYNC_SCROLL_TO_MSG_ID", "NEW_PICTURE_MSG_ID", "UPDATE_TEXT_ENTRY_MSG_ID", "WEBCORE_INITIALIZED_MSG_ID", "UPDATE_TEXTFIELD_TEXT_MSG_ID", "UPDATE_ZOOM_RANGE", "UNHANDLED_NAV_KEY", "CLEAR_TEXT_ENTRY", "UPDATE_TEXT_SELECTION_MSG_ID", "SHOW_RECT_MSG_ID", "LONG_PRESS_CENTER", "PREVENT_TOUCH_ID", "WEBCORE_NEED_TOUCH_EVENTS", "INVAL_RECT_MSG_ID", "REQUEST_KEYBOARD", "DO_MOTION_UP", "SHOW_FULLSCREEN", "HIDE_FULLSCREEN", "DOM_FOCUS_CHANGED", "REPLACE_BASE_CONTENT", "FORM_DID_BLUR", "RETURN_LABEL", "FIND_AGAIN", "CENTER_FIT_RECT", "REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID", "SET_SCROLLBAR_MODES", "SELECTION_STRING_CHANGED", "SET_TOUCH_HIGHLIGHT_RECTS", "SAVE_WEBARCHIVE_FINISHED", "SET_AUTOFILLABLE", "AUTOFILL_COMPLETE", "SELECT_AT", "SCREEN_ON"};
        sMaxViewportWidth = 980;
        mLogEvent = true;
        sPackageInstallationReceiverAdded = false;
        sGoogleApps = new HashSet<String>();
        sGoogleApps.add("com.google.android.youtube");
    }

    public class InvokeListBox
    implements Runnable {
        public boolean mMultiple;
        public int[] mSelectedArray;
        public int mSelection;
        public Container[] mContainers;

        public InvokeListBox(String[] array2, int[] enabled, int[] selected) {
            this.mMultiple = true;
            this.mSelectedArray = selected;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container(null);
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        public InvokeListBox(String[] array2, int[] enabled, int selection) {
            this.mSelection = selection;
            this.mMultiple = false;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container(null);
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        public void run() {
            ListView listView = (ListView)LayoutInflater.from(_Original_WebView.this.mContext).inflate(17367167, null);
            MyArrayListAdapter adapter = new MyArrayListAdapter(_Original_WebView.this.mContext, this.mContainers, this.mMultiple);
            AlertDialog.Builder b = new AlertDialog.Builder(_Original_WebView.this.mContext).setView(listView).setCancelable(true).setInverseBackgroundForced(true);
            if (this.mMultiple) {
                b.setPositiveButton(17039370, (DialogInterface.OnClickListener)new _Original_WebView$InvokeListBox$1(this, adapter, listView));
                b.setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new _Original_WebView$InvokeListBox$2(this));
            }
            _Original_WebView.this.mListBoxDialog = b.create();
            listView.setAdapter(adapter);
            listView.setFocusableInTouchMode(true);
            listView.setTextFilterEnabled(!this.mMultiple);
            if (this.mMultiple) {
                listView.setChoiceMode(2);
                int length = this.mSelectedArray.length;
                for (int i = 0; i < length; ++i) {
                    listView.setItemChecked(this.mSelectedArray[i], true);
                }
            } else {
                listView.setOnItemClickListener(new _Original_WebView$InvokeListBox$3(this));
                if (this.mSelection != -1) {
                    listView.setSelection(this.mSelection);
                    listView.setChoiceMode(1);
                    listView.setItemChecked(this.mSelection, true);
                    SingleDataSetObserver observer = new SingleDataSetObserver(adapter.getItemId(this.mSelection), listView, adapter);
                    adapter.registerDataSetObserver(observer);
                }
            }
            _Original_WebView.this.mListBoxDialog.setOnCancelListener(new _Original_WebView$InvokeListBox$4(this));
            _Original_WebView.this.mListBoxDialog.show();
        }

        public /* synthetic */ InvokeListBox(String[] x1, int[] x2, int[] x3, _Original_WebView$1 x4) {
            this(x1, x2, x3);
        }

        public /* synthetic */ InvokeListBox(String[] x1, int[] x2, int x3, _Original_WebView$1 x4) {
            this(x1, x2, x3);
        }

        public class SingleDataSetObserver
        extends DataSetObserver {
            public long mCheckedId;
            public ListView mListView;
            public Adapter mAdapter;

            public SingleDataSetObserver(long id2, ListView l, Adapter a) {
                this.mCheckedId = id2;
                this.mListView = l;
                this.mAdapter = a;
            }

            public void onChanged() {
                int position = this.mListView.getCheckedItemPosition();
                long id2 = this.mAdapter.getItemId(position);
                if (this.mCheckedId != id2) {
                    this.mListView.clearChoices();
                    int count = this.mAdapter.getCount();
                    for (int i = 0; i < count; ++i) {
                        if (this.mAdapter.getItemId(i) != this.mCheckedId) continue;
                        this.mListView.setItemChecked(i, true);
                        break;
                    }
                }
            }

            public void onInvalidate() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MyArrayListAdapter
        extends ArrayAdapter<Container> {
            public MyArrayListAdapter(Context context, Container[] objects, boolean multiple) {
                super(context, multiple ? 17367059 : 17367058, objects);
            }

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                convertView = super.getView(position, null, parent);
                Container c = this.item(position);
                if (c != null && 1 != c.mEnabled) {
                    LinearLayout layout2 = new LinearLayout(_Original_WebView.this.mContext);
                    layout2.setOrientation(1);
                    if (position > 0) {
                        View dividerTop = new View(_Original_WebView.this.mContext);
                        dividerTop.setBackgroundResource(17301522);
                        layout2.addView(dividerTop);
                    }
                    if (-1 == c.mEnabled) {
                        Assert.assertTrue((boolean)(convertView instanceof CheckedTextView));
                        ((CheckedTextView)convertView).setCheckMarkDrawable(null);
                    } else {
                        convertView.setEnabled(false);
                    }
                    layout2.addView(convertView);
                    if (position < this.getCount() - 1) {
                        View dividerBottom = new View(_Original_WebView.this.mContext);
                        dividerBottom.setBackgroundResource(17301522);
                        layout2.addView(dividerBottom);
                    }
                    return layout2;
                }
                return convertView;
            }

            @Override
            public boolean hasStableIds() {
                return false;
            }

            public Container item(int position) {
                if (position < 0 || position >= this.getCount()) {
                    return null;
                }
                return (Container)this.getItem(position);
            }

            @Override
            public long getItemId(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return -1L;
                }
                return item.mId;
            }

            @Override
            public boolean areAllItemsEnabled() {
                return false;
            }

            @Override
            public boolean isEnabled(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return false;
                }
                return 1 == item.mEnabled;
            }
        }

        public class Container {
            public static final int OPTGROUP = -1;
            public static final int OPTION_DISABLED = 0;
            public static final int OPTION_ENABLED = 1;
            public String mString;
            public int mEnabled;
            public int mId;

            public Container() {
            }

            public String toString() {
                return this.mString;
            }

            public /* synthetic */ Container(_Original_WebView$1 x1) {
                this();
            }
        }
    }

    public class PrivateHandler
    extends Handler {
        public void handleMessage(Message msg) {
            if (_Original_WebView.this.mWebViewCore == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    _Original_WebView.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), msg.getData().getString("username"), msg.getData().getString("password"));
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 2: {
                    _Original_WebView.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), null, null);
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 10: {
                    if ((msg.arg1 != 0 || _Original_WebView.this.mPreventDefault != 1) && (msg.arg1 != 2 || _Original_WebView.this.mPreventDefault != 2)) break;
                    _Original_WebView.this.cancelWebCoreTouchEvent(_Original_WebView.this.viewToContentX(_Original_WebView.this.mLastTouchX + _Original_WebView.this.mScrollX), _Original_WebView.this.viewToContentY(_Original_WebView.this.mLastTouchY + _Original_WebView.this.mScrollY), true);
                    break;
                }
                case 11: {
                    if (_Original_WebView.this.mAutoScrollX == 0 && _Original_WebView.this.mAutoScrollY == 0) {
                        _Original_WebView.this.mSentAutoScrollMessage = false;
                        break;
                    }
                    if (_Original_WebView.this.mScrollingLayer == 0) {
                        _Original_WebView.this.pinScrollBy(_Original_WebView.this.mAutoScrollX, _Original_WebView.this.mAutoScrollY, true, 0);
                    } else {
                        ((_Original_WebView)_Original_WebView.this).mScrollingLayerRect.left += _Original_WebView.this.mAutoScrollX;
                        ((_Original_WebView)_Original_WebView.this).mScrollingLayerRect.top += _Original_WebView.this.mAutoScrollY;
                        _Original_WebView.this.nativeScrollLayer(_Original_WebView.this.mScrollingLayer, ((_Original_WebView)_Original_WebView.this).mScrollingLayerRect.left, ((_Original_WebView)_Original_WebView.this).mScrollingLayerRect.top);
                        _Original_WebView.this.invalidate();
                    }
                    this.sendEmptyMessageDelayed(11, 16L);
                    break;
                }
                case 3: {
                    _Original_WebView.this.mInitialHitTestResult = null;
                    if (_Original_WebView.this.mTouchMode == 1) {
                        if (!_Original_WebView.this.getSettings().supportTouchOnly() && _Original_WebView.this.mPreventDefault != 3) {
                            _Original_WebView.this.mTouchMode = 4;
                            _Original_WebView.this.updateSelection();
                            break;
                        }
                        _Original_WebView.this.mTouchMode = 5;
                        break;
                    }
                    if (_Original_WebView.this.mTouchMode != 6) break;
                    _Original_WebView.this.mTouchMode = 7;
                    break;
                }
                case 4: {
                    if (_Original_WebView.this.getSettings().supportTouchOnly()) {
                        _Original_WebView.this.removeTouchHighlight(false);
                    }
                    if (_Original_WebView.this.inFullScreenMode() || _Original_WebView.this.mDeferTouchProcess) {
                        WebViewCore.TouchEventData ted = new WebViewCore.TouchEventData();
                        ted.mAction = 256;
                        ted.mIds = new int[1];
                        ted.mIds[0] = 0;
                        ted.mPoints = new Point[1];
                        ted.mPoints[0] = new Point(_Original_WebView.this.viewToContentX(_Original_WebView.this.mLastTouchX + _Original_WebView.this.mScrollX), _Original_WebView.this.viewToContentY(_Original_WebView.this.mLastTouchY + _Original_WebView.this.mScrollY));
                        ted.mMetaState = 0;
                        ted.mReprocess = _Original_WebView.this.mDeferTouchProcess;
                        _Original_WebView.this.mWebViewCore.sendMessage(141, ted);
                        break;
                    }
                    if (_Original_WebView.this.mPreventDefault == 3) break;
                    _Original_WebView.this.mTouchMode = 7;
                    _Original_WebView.this.performLongClick();
                    break;
                }
                case 5: {
                    _Original_WebView.this.doShortPress();
                    break;
                }
                case 102: {
                    _Original_WebView.this.setContentScrollBy(msg.arg1, msg.arg2, (Boolean)msg.obj);
                    break;
                }
                case 104: {
                    if (_Original_WebView.this.mUserScroll) {
                        _Original_WebView.this.mUserScroll = false;
                        break;
                    }
                    _Original_WebView.this.setContentScrollTo(msg.arg1, msg.arg2);
                    break;
                }
                case 101: {
                    InputMethodManager imm;
                    if (((Boolean)msg.obj).booleanValue() && ((imm = InputMethodManager.peekInstance()) == null || !imm.isAcceptingText() || !imm.isActive(_Original_WebView.this) && (!_Original_WebView.this.inEditingMode() || !imm.isActive(_Original_WebView.this.mWebTextView))) || !_Original_WebView.this.setContentScrollTo(msg.arg1, msg.arg2)) break;
                    _Original_WebView.this.mUserScroll = false;
                    _Original_WebView.this.mWebViewCore.sendMessage(131, msg.arg1, msg.arg2);
                    break;
                }
                case 103: {
                    _Original_WebView.this.spawnContentScrollTo(msg.arg1, msg.arg2);
                    break;
                }
                case 109: {
                    WebViewCore.ViewState viewState = (WebViewCore.ViewState)msg.obj;
                    _Original_WebView.this.mZoomManager.updateZoomRange(viewState, _Original_WebView.this.getViewWidth(), viewState.mScrollX);
                    break;
                }
                case 123: {
                    _Original_WebView.this.nativeReplaceBaseContent(msg.arg1);
                    break;
                }
                case 105: {
                    boolean isPictureAfterFirstLayout;
                    _Original_WebView.this.mUserScroll = false;
                    WebViewCore.DrawData draw = (WebViewCore.DrawData)msg.obj;
                    _Original_WebView.this.setBaseLayer(draw.mBaseLayer, draw.mInvalRegion.getBounds());
                    Point viewSize = draw.mViewSize;
                    WebViewCore.ViewState viewState = draw.mViewState;
                    boolean bl = isPictureAfterFirstLayout = viewState != null;
                    if (isPictureAfterFirstLayout) {
                        _Original_WebView.this.mLastWidthSent = 0;
                        _Original_WebView.this.mZoomManager.onFirstLayout(draw);
                        if (!_Original_WebView.this.mDrawHistory) {
                            _Original_WebView.this.setContentScrollTo(viewState.mScrollX, viewState.mScrollY);
                            _Original_WebView.this.clearTextEntry();
                        }
                    }
                    boolean updateLayout = viewSize.x == _Original_WebView.this.mLastWidthSent && viewSize.y == _Original_WebView.this.mLastHeightSent;
                    _Original_WebView.this.recordNewContentSize(draw.mContentSize.x, draw.mContentSize.y, updateLayout);
                    _Original_WebView.this.invalidateContentRect(draw.mInvalRegion.getBounds());
                    if (_Original_WebView.this.mPictureListener != null) {
                        _Original_WebView.this.mPictureListener.onNewPicture(_Original_WebView.this, _Original_WebView.this.capturePicture());
                    }
                    _Original_WebView.this.mZoomManager.onNewPicture(draw);
                    if (draw.mFocusSizeChanged && _Original_WebView.this.inEditingMode()) {
                        _Original_WebView.this.mFocusSizeChanged = true;
                    }
                    if (!isPictureAfterFirstLayout) break;
                    _Original_WebView.this.mViewManager.postReadyToDrawAll();
                    break;
                }
                case 107: {
                    _Original_WebView.this.nativeCreate(msg.arg1);
                    break;
                }
                case 108: {
                    if (!_Original_WebView.this.inEditingMode() || !_Original_WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    if (msg.getData().getBoolean("password")) {
                        Editable text = _Original_WebView.this.mWebTextView.getText();
                        int start = Selection.getSelectionStart(text);
                        int end = Selection.getSelectionEnd(text);
                        _Original_WebView.this.mWebTextView.setInPassword(true);
                        Editable pword = _Original_WebView.this.mWebTextView.getText();
                        Selection.setSelection(pword, start, end);
                        break;
                    }
                    if (msg.arg2 != _Original_WebView.this.mTextGeneration) break;
                    String text = (String)msg.obj;
                    if (null == text) {
                        text = "";
                    }
                    _Original_WebView.this.mWebTextView.setTextAndKeepSelection(text);
                    break;
                }
                case 128: {
                    _Original_WebView.this.displaySoftKeyboard(true);
                }
                case 112: {
                    _Original_WebView.this.updateTextSelectionFromMessage(msg.arg1, msg.arg2, (WebViewCore.TextSelectionData)msg.obj);
                    break;
                }
                case 124: {
                    if (!_Original_WebView.this.inEditingMode() || !_Original_WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    _Original_WebView.this.hideSoftKeyboard();
                    break;
                }
                case 125: {
                    if (!_Original_WebView.this.inEditingMode() || !_Original_WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    _Original_WebView.this.mWebTextView.setHint((String)msg.obj);
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    if (imm == null || !imm.isActive(_Original_WebView.this.mWebTextView)) break;
                    imm.restartInput(_Original_WebView.this.mWebTextView);
                    break;
                }
                case 110: {
                    _Original_WebView.this.navHandledKey(msg.arg1, 1, false, 0L);
                    break;
                }
                case 106: {
                    if (!_Original_WebView.this.inEditingMode() || !_Original_WebView.this.nativeCursorIsTextInput()) break;
                    _Original_WebView.this.rebuildWebTextView();
                    break;
                }
                case 111: {
                    _Original_WebView.this.clearTextEntry();
                    break;
                }
                case 117: {
                    Rect r = (Rect)msg.obj;
                    if (r == null) {
                        _Original_WebView.this.invalidate();
                        break;
                    }
                    _Original_WebView.this.viewInvalidate(r.left, r.top, r.right, r.bottom);
                    break;
                }
                case 6: {
                    WebTextView.AutoCompleteAdapter adapter = (WebTextView.AutoCompleteAdapter)msg.obj;
                    if (!_Original_WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    _Original_WebView.this.mWebTextView.setAdapterCustom(adapter);
                    break;
                }
                case 7: {
                    WebViewCore.resumePriority();
                    WebViewCore.resumeUpdatePicture(_Original_WebView.this.mWebViewCore);
                    break;
                }
                case 114: {
                    _Original_WebView.this.mGotCenterDown = false;
                    _Original_WebView.this.mTrackballDown = false;
                    _Original_WebView.this.performLongClick();
                    break;
                }
                case 116: {
                    _Original_WebView.this.mForwardTouchEvents = msg.arg1 != 0;
                    break;
                }
                case 115: {
                    if (_Original_WebView.this.inFullScreenMode()) break;
                    if (msg.obj == null) {
                        if (msg.arg1 == 0 && _Original_WebView.this.mPreventDefault == 1) {
                            _Original_WebView.this.mPreventDefault = msg.arg2 == 1 ? 3 : 2;
                        } else if (msg.arg1 == 2 && _Original_WebView.this.mPreventDefault == 2) {
                            _Original_WebView.this.mPreventDefault = msg.arg2 == 1 ? 3 : 0;
                        }
                        if (_Original_WebView.this.mPreventDefault != 3) break;
                        _Original_WebView.this.mTouchHighlightRegion.setEmpty();
                        break;
                    }
                    WebViewCore.TouchEventData ted = (WebViewCore.TouchEventData)msg.obj;
                    if (ted.mPoints.length > 1) {
                        if (ted.mAction == 6) {
                            _Original_WebView.this.mIsHandlingMultiTouch = false;
                        }
                        if (msg.arg2 == 0) {
                            _Original_WebView.this.mPreventDefault = 0;
                            _Original_WebView.this.handleMultiTouchInWebView(ted.mMotionEvent);
                            break;
                        }
                        _Original_WebView.this.mPreventDefault = 3;
                        break;
                    }
                    if (msg.arg2 == 0) {
                        switch (ted.mAction) {
                            case 0: {
                                _Original_WebView.this.mLastDeferTouchX = _Original_WebView.this.contentToViewX(ted.mPoints[0].x) - _Original_WebView.this.mScrollX;
                                _Original_WebView.this.mLastDeferTouchY = _Original_WebView.this.contentToViewY(ted.mPoints[0].y) - _Original_WebView.this.mScrollY;
                                _Original_WebView.this.mDeferTouchMode = 1;
                                break;
                            }
                            case 2: {
                                int x = _Original_WebView.this.contentToViewX(ted.mPoints[0].x) - _Original_WebView.this.mScrollX;
                                int y = _Original_WebView.this.contentToViewY(ted.mPoints[0].y) - _Original_WebView.this.mScrollY;
                                if (_Original_WebView.this.mDeferTouchMode != 3) {
                                    _Original_WebView.this.mDeferTouchMode = 3;
                                    _Original_WebView.this.mLastDeferTouchX = x;
                                    _Original_WebView.this.mLastDeferTouchY = y;
                                    _Original_WebView.this.startScrollingLayer(x, y);
                                    _Original_WebView.this.startDrag();
                                }
                                int deltaX = _Original_WebView.this.pinLocX((int)((float)_Original_WebView.this.mScrollX + _Original_WebView.this.mLastDeferTouchX - (float)x)) - _Original_WebView.this.mScrollX;
                                int deltaY = _Original_WebView.this.pinLocY((int)((float)_Original_WebView.this.mScrollY + _Original_WebView.this.mLastDeferTouchY - (float)y)) - _Original_WebView.this.mScrollY;
                                _Original_WebView.this.doDrag(deltaX, deltaY);
                                if (deltaX != 0) {
                                    _Original_WebView.this.mLastDeferTouchX = x;
                                }
                                if (deltaY == 0) break;
                                _Original_WebView.this.mLastDeferTouchY = y;
                                break;
                            }
                            case 1: 
                            case 3: {
                                if (_Original_WebView.this.mDeferTouchMode == 3) {
                                    _Original_WebView.this.mScroller.springBack(_Original_WebView.this.mScrollX, _Original_WebView.this.mScrollY, 0, _Original_WebView.this.computeMaxScrollX(), 0, _Original_WebView.this.computeMaxScrollY());
                                    _Original_WebView.this.invalidate();
                                    WebViewCore.resumePriority();
                                    WebViewCore.resumeUpdatePicture(_Original_WebView.this.mWebViewCore);
                                }
                                _Original_WebView.this.mDeferTouchMode = 7;
                                break;
                            }
                            case 512: {
                                _Original_WebView.this.mLastTouchX = _Original_WebView.this.contentToViewX(ted.mPoints[0].x) - _Original_WebView.this.mScrollX;
                                _Original_WebView.this.mLastTouchY = _Original_WebView.this.contentToViewY(ted.mPoints[0].y) - _Original_WebView.this.mScrollY;
                                _Original_WebView.this.mZoomManager.handleDoubleTap(_Original_WebView.this.mLastTouchX, _Original_WebView.this.mLastTouchY);
                                _Original_WebView.this.mDeferTouchMode = 7;
                                break;
                            }
                            case 256: {
                                HitTestResult hitTest = _Original_WebView.this.getHitTestResult();
                                if (hitTest != null && hitTest.mType != 0) {
                                    _Original_WebView.this.performLongClick();
                                }
                                _Original_WebView.this.mDeferTouchMode = 7;
                            }
                        }
                    }
                    break;
                }
                case 118: {
                    if (msg.arg1 == 0) {
                        _Original_WebView.this.hideSoftKeyboard();
                        break;
                    }
                    _Original_WebView.this.displaySoftKeyboard(false);
                    break;
                }
                case 126: {
                    if (!_Original_WebView.this.mFindIsUp || _Original_WebView.this.mFindCallback == null) break;
                    _Original_WebView.this.mFindCallback.findAll();
                    break;
                }
                case 8: {
                    _Original_WebView.this.mHeldMotionless = 2;
                    _Original_WebView.this.invalidate();
                }
                case 9: {
                    if (_Original_WebView.this.mTouchMode != 3 || _Original_WebView.this.mHeldMotionless != 2) break;
                    _Original_WebView.this.awakenScrollBars(ViewConfiguration.getScrollDefaultDelay(), false);
                    _Original_WebView.this.mPrivateHandler.sendMessageDelayed(_Original_WebView.this.mPrivateHandler.obtainMessage(9), ViewConfiguration.getScrollDefaultDelay());
                    break;
                }
                case 119: {
                    _Original_WebView.this.doMotionUp(msg.arg1, msg.arg2);
                    break;
                }
                case 136: {
                    _Original_WebView.this.setKeepScreenOn(msg.arg1 == 1);
                    break;
                }
                case 120: {
                    View view = (View)msg.obj;
                    int npp = msg.arg1;
                    if (_Original_WebView.this.inFullScreenMode()) {
                        Log.w(_Original_WebView.LOGTAG, "Should not have another full screen.");
                        _Original_WebView.this.dismissFullScreenMode();
                    }
                    _Original_WebView.this.mFullScreenHolder = new PluginFullScreenHolder(_Original_WebView.this, npp);
                    _Original_WebView.this.mFullScreenHolder.setContentView(view);
                    _Original_WebView.this.mFullScreenHolder.setCancelable(false);
                    _Original_WebView.this.mFullScreenHolder.setCanceledOnTouchOutside(false);
                    _Original_WebView.this.mFullScreenHolder.show();
                    break;
                }
                case 121: {
                    _Original_WebView.this.dismissFullScreenMode();
                    break;
                }
                case 122: {
                    if (!_Original_WebView.this.inEditingMode()) break;
                    _Original_WebView.this.nativeClearCursor();
                    _Original_WebView.this.rebuildWebTextView();
                    break;
                }
                case 113: {
                    WebViewCore.ShowRectData data = (WebViewCore.ShowRectData)msg.obj;
                    int x = _Original_WebView.this.mScrollX;
                    int left = _Original_WebView.this.contentToViewX(data.mLeft);
                    int width = _Original_WebView.this.contentToViewDimension(data.mWidth);
                    int maxWidth = _Original_WebView.this.contentToViewDimension(data.mContentWidth);
                    int viewWidth = _Original_WebView.this.getViewWidth();
                    x = width < viewWidth ? (x += left + width / 2 - _Original_WebView.this.mScrollX - viewWidth / 2) : (x += (int)((float)left + data.mXPercentInDoc * (float)width - (float)_Original_WebView.this.mScrollX - data.mXPercentInView * (float)viewWidth));
                    x = Math.max(0, Math.min(maxWidth, x + viewWidth) - viewWidth);
                    int top = _Original_WebView.this.contentToViewY(data.mTop);
                    int height = _Original_WebView.this.contentToViewDimension(data.mHeight);
                    int maxHeight = _Original_WebView.this.contentToViewDimension(data.mContentHeight);
                    int viewHeight = _Original_WebView.this.getViewHeight();
                    int y = (int)((float)top + data.mYPercentInDoc * (float)height - data.mYPercentInView * (float)viewHeight);
                    y = Math.max(0, Math.min(maxHeight, y + viewHeight) - viewHeight);
                    y = Math.max(0, y - _Original_WebView.this.getVisibleTitleHeight());
                    _Original_WebView.this.scrollTo(x, y);
                    break;
                }
                case 127: {
                    _Original_WebView.this.centerFitRect((Rect)msg.obj);
                    break;
                }
                case 129: {
                    _Original_WebView.this.mHorizontalScrollBarMode = msg.arg1;
                    _Original_WebView.this.mVerticalScrollBarMode = msg.arg2;
                    break;
                }
                case 130: {
                    if (_Original_WebView.this.mAccessibilityInjector == null) break;
                    String selectionString = (String)msg.obj;
                    _Original_WebView.this.mAccessibilityInjector.onSelectionStringChange(selectionString);
                    break;
                }
                case 131: {
                    _Original_WebView.this.invalidate(_Original_WebView.this.mTouchHighlightRegion.getBounds());
                    _Original_WebView.this.mTouchHighlightRegion.setEmpty();
                    if (msg.obj == null) break;
                    ArrayList rects = (ArrayList)msg.obj;
                    for (Rect rect : rects) {
                        Rect viewRect = _Original_WebView.this.contentToViewRect(rect);
                        if (viewRect.width() < _Original_WebView.this.getWidth() >> 1 || viewRect.height() < _Original_WebView.this.getHeight() >> 1) {
                            _Original_WebView.this.mTouchHighlightRegion.union(viewRect);
                            _Original_WebView.this.invalidate(viewRect);
                            continue;
                        }
                        Log.w(_Original_WebView.LOGTAG, "Skip the huge selection rect:" + viewRect);
                    }
                    break;
                }
                case 132: {
                    SaveWebArchiveMessage saveMessage = (SaveWebArchiveMessage)msg.obj;
                    if (saveMessage.mCallback == null) break;
                    saveMessage.mCallback.onReceiveValue(saveMessage.mResultFile);
                    break;
                }
                case 133: {
                    _Original_WebView.this.mAutoFillData = (WebViewCore.AutoFillData)msg.obj;
                    if (_Original_WebView.this.mWebTextView == null) break;
                    _Original_WebView.this.mWebTextView.setAutoFillable(_Original_WebView.this.mAutoFillData.getQueryId());
                    _Original_WebView.this.rebuildWebTextView();
                    break;
                }
                case 134: {
                    if (_Original_WebView.this.mWebTextView == null) break;
                    _Original_WebView.this.mWebTextView.setAdapterCustom(null);
                    break;
                }
                case 135: {
                    _Original_WebView.this.nativeSelectAt(msg.arg1, msg.arg2);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    public class RequestFormData
    implements Runnable {
        public String mName;
        public String mUrl;
        public Message mUpdateMessage;
        public boolean mAutoFillable;
        public boolean mAutoComplete;

        public RequestFormData(String name, String url, Message msg, boolean autoFillable, boolean autoComplete) {
            this.mName = name;
            this.mUrl = url;
            this.mUpdateMessage = msg;
            this.mAutoFillable = autoFillable;
            this.mAutoComplete = autoComplete;
        }

        public void run() {
            ArrayList<String> pastEntries = new ArrayList<String>();
            if (this.mAutoFillable) {
                WebSettings settings = _Original_WebView.this.getSettings();
                if (settings != null && settings.getAutoFillProfile() != null) {
                    pastEntries.add(((Object)_Original_WebView.this.getResources().getText(17040091)).toString() + " " + _Original_WebView.this.mAutoFillData.getPreviewString());
                    _Original_WebView.this.mWebTextView.setAutoFillProfileIsSet(true);
                } else {
                    pastEntries.add(((Object)_Original_WebView.this.getResources().getText(17040092)).toString());
                    _Original_WebView.this.mWebTextView.setAutoFillProfileIsSet(false);
                }
            }
            if (this.mAutoComplete) {
                pastEntries.addAll(_Original_WebView.this.mDatabase.getFormData(this.mUrl, this.mName));
            }
            if (pastEntries.size() > 0) {
                WebTextView.AutoCompleteAdapter adapter = new WebTextView.AutoCompleteAdapter(_Original_WebView.this.mContext, pastEntries);
                this.mUpdateMessage.obj = adapter;
                this.mUpdateMessage.sendToTarget();
            }
        }
    }

    public static class ViewSizeData {
        public int mWidth;
        public int mHeight;
        public int mTextWrapWidth;
        public int mAnchorX;
        public int mAnchorY;
        public float mScale;
        public boolean mIgnoreHeight;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveWebArchiveMessage {
        public final String mBasename;
        public final boolean mAutoname;
        public final ValueCallback<String> mCallback;
        public String mResultFile;

        public SaveWebArchiveMessage(String basename, boolean autoname, ValueCallback<String> callback) {
            this.mBasename = basename;
            this.mAutoname = autoname;
            this.mCallback = callback;
        }
    }

    public static class PackageListener
    extends BroadcastReceiver {
        public PackageListener() {
        }

        public void onReceive(Context context, Intent intent) {
            PluginManager pm;
            String action = intent.getAction();
            String packageName = intent.getData().getSchemeSpecificPart();
            boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
            if ("android.intent.action.PACKAGE_REMOVED".equals(action) && replacing) {
                return;
            }
            if (sGoogleApps.contains(packageName)) {
                if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                    WebViewCore.sendStaticMessage(185, packageName);
                } else {
                    WebViewCore.sendStaticMessage(186, packageName);
                }
            }
            if ((pm = PluginManager.getInstance(context)).containsPluginPermissionAndSignatures(packageName)) {
                pm.refreshPlugins("android.intent.action.PACKAGE_ADDED".equals(action));
            }
        }

        public /* synthetic */ PackageListener(_Original_WebView$1 x0) {
            this();
        }
    }

    public static class ProxyReceiver
    extends BroadcastReceiver {
        public ProxyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
                _Original_WebView.handleProxyBroadcast(intent);
            }
        }

        public /* synthetic */ ProxyReceiver(_Original_WebView$1 x0) {
            this();
        }
    }

    public class HitTestResult {
        public static final int UNKNOWN_TYPE = 0;
        public static final int ANCHOR_TYPE = 1;
        public static final int PHONE_TYPE = 2;
        public static final int GEO_TYPE = 3;
        public static final int EMAIL_TYPE = 4;
        public static final int IMAGE_TYPE = 5;
        public static final int IMAGE_ANCHOR_TYPE = 6;
        public static final int SRC_ANCHOR_TYPE = 7;
        public static final int SRC_IMAGE_ANCHOR_TYPE = 8;
        public static final int EDIT_TEXT_TYPE = 9;
        public int mType = 0;
        public String mExtra;

        public void setType(int type) {
            this.mType = type;
        }

        public void setExtra(String extra) {
            this.mExtra = extra;
        }

        public int getType() {
            return this.mType;
        }

        public String getExtra() {
            return this.mExtra;
        }
    }

    public static interface PictureListener {
        public void onNewPicture(_Original_WebView var1, Picture var2);
    }

    public class WebViewTransport {
        public _Original_WebView mWebview;

        public synchronized void setWebView(_Original_WebView webview) {
            this.mWebview = webview;
        }

        public synchronized _Original_WebView getWebView() {
            return this.mWebview;
        }
    }

    public class InnerScrollChangedListener
    implements ViewTreeObserver.OnScrollChangedListener {
        public InnerScrollChangedListener() {
        }

        public void onScrollChanged() {
            if (_Original_WebView.this.isShown()) {
                _Original_WebView.this.setGLRectViewport();
            }
        }

        public /* synthetic */ InnerScrollChangedListener(_Original_WebView$1 x1) {
            this();
        }
    }

    public class InnerGlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        public InnerGlobalLayoutListener() {
        }

        public void onGlobalLayout() {
            if (_Original_WebView.this.isShown()) {
                _Original_WebView.this.setGLRectViewport();
            }
        }

        public /* synthetic */ InnerGlobalLayoutListener(_Original_WebView$1 x1) {
            this();
        }
    }
}

