/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseBooleanArray;
import android.util.StateSet;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EdgeGlow;
import android.widget.EditText;
import android.widget.FastScroller;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.OverScroller;
import android.widget.PopupWindow;
import android.widget.RemoteViewsAdapter;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsListView
extends AdapterView<ListAdapter>
implements TextWatcher,
ViewTreeObserver.OnGlobalLayoutListener,
Filter.FilterListener,
ViewTreeObserver.OnTouchModeChangeListener,
RemoteViewsAdapter.RemoteAdapterConnectionCallback {
    public static final int TRANSCRIPT_MODE_DISABLED = 0;
    public static final int TRANSCRIPT_MODE_NORMAL = 1;
    public static final int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    public static final int TOUCH_MODE_REST = -1;
    public static final int TOUCH_MODE_DOWN = 0;
    public static final int TOUCH_MODE_TAP = 1;
    public static final int TOUCH_MODE_DONE_WAITING = 2;
    public static final int TOUCH_MODE_SCROLL = 3;
    public static final int TOUCH_MODE_FLING = 4;
    public static final int TOUCH_MODE_OVERSCROLL = 5;
    public static final int TOUCH_MODE_OVERFLING = 6;
    public static final int LAYOUT_NORMAL = 0;
    public static final int LAYOUT_FORCE_TOP = 1;
    public static final int LAYOUT_SET_SELECTION = 2;
    public static final int LAYOUT_FORCE_BOTTOM = 3;
    public static final int LAYOUT_SPECIFIC = 4;
    public static final int LAYOUT_SYNC = 5;
    public static final int LAYOUT_MOVE_SELECTION = 6;
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    public static final int CHOICE_MODE_MULTIPLE = 2;
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    public int mChoiceMode = 0;
    public ActionMode mChoiceActionMode;
    public MultiChoiceModeWrapper mMultiChoiceModeCallback;
    public int mCheckedItemCount;
    public SparseBooleanArray mCheckStates;
    public LongSparseArray<Boolean> mCheckedIdStates;
    public int mLayoutMode = 0;
    public AdapterDataSetObserver mDataSetObserver;
    public ListAdapter mAdapter;
    public RemoteViewsAdapter mRemoteAdapter;
    public boolean mDrawSelectorOnTop = false;
    public Drawable mSelector;
    public boolean mSelectorShowing;
    public int mSelectorPosition = -1;
    public Rect mSelectorRect = new Rect();
    public final RecycleBin mRecycler = new RecycleBin();
    public int mSelectionLeftPadding = 0;
    public int mSelectionTopPadding = 0;
    public int mSelectionRightPadding = 0;
    public int mSelectionBottomPadding = 0;
    public Rect mListPadding = new Rect();
    public int mWidthMeasureSpec = 0;
    public View mScrollUp;
    public View mScrollDown;
    public boolean mCachingStarted;
    public int mMotionPosition;
    public int mMotionViewOriginalTop;
    public int mMotionViewNewTop;
    public int mMotionX;
    public int mMotionY;
    public int mTouchMode = -1;
    public int mLastY;
    public int mMotionCorrection;
    public VelocityTracker mVelocityTracker;
    public FlingRunnable mFlingRunnable;
    public PositionScroller mPositionScroller;
    public int mSelectedTop = 0;
    public boolean mStackFromBottom;
    public boolean mScrollingCacheEnabled;
    public boolean mFastScrollEnabled;
    public OnScrollListener mOnScrollListener;
    public PopupWindow mPopup;
    public EditText mTextFilter;
    public boolean mSmoothScrollbarEnabled = true;
    public boolean mTextFilterEnabled;
    public boolean mFiltered;
    public Rect mTouchFrame;
    public int mResurrectToPosition = -1;
    public ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    public int mOverscrollMax;
    public static final int OVERSCROLL_LIMIT_DIVISOR = 3;
    public static final int TOUCH_MODE_UNKNOWN = -1;
    public static final int TOUCH_MODE_ON = 0;
    public static final int TOUCH_MODE_OFF = 1;
    public int mLastTouchMode = -1;
    public static final boolean PROFILE_SCROLLING = false;
    public boolean mScrollProfilingStarted = false;
    public static final boolean PROFILE_FLINGING = false;
    public boolean mFlingProfilingStarted = false;
    public StrictMode.Span mScrollStrictSpan = null;
    public StrictMode.Span mFlingStrictSpan = null;
    public CheckForLongPress mPendingCheckForLongPress;
    public Runnable mPendingCheckForTap;
    public CheckForKeyLongPress mPendingCheckForKeyLongPress;
    public PerformClick mPerformClick;
    public Runnable mTouchModeReset;
    public int mTranscriptMode;
    public int mCacheColorHint;
    public boolean mIsChildViewEnabled;
    public int mLastScrollState = 0;
    public FastScroller mFastScroller;
    public boolean mGlobalLayoutListenerAddedFilter;
    public int mTouchSlop;
    public float mDensityScale;
    public InputConnection mDefInputConnection;
    public InputConnectionWrapper mPublicInputConnection;
    public Runnable mClearScrollingCache;
    public int mMinimumVelocity;
    public int mMaximumVelocity;
    public float mVelocityScale = 1.0f;
    public final boolean[] mIsScrap = new boolean[1];
    public boolean mPopupHidden;
    public int mActivePointerId = -1;
    public static final int INVALID_POINTER = -1;
    public int mOverscrollDistance;
    public int mOverflingDistance;
    public EdgeGlow mEdgeGlowTop;
    public EdgeGlow mEdgeGlowBottom;
    public int mFirstPositionDistanceGuess;
    public int mLastPositionDistanceGuess;
    public int mDirection = 0;
    public boolean mForceTranscriptScroll;

    public AbsListView(Context context) {
        super(context);
        this.initAbsListView();
        this.setVerticalScrollBarEnabled(true);
        TypedArray a = context.obtainStyledAttributes(R.styleable.View);
        this.initializeScrollbars(a);
        a.recycle();
    }

    public AbsListView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842858);
    }

    public AbsListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAbsListView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AbsListView, defStyle, 0);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.setSelector(d);
        }
        this.mDrawSelectorOnTop = a.getBoolean(1, false);
        boolean stackFromBottom = a.getBoolean(2, false);
        this.setStackFromBottom(stackFromBottom);
        boolean scrollingCacheEnabled = a.getBoolean(3, true);
        this.setScrollingCacheEnabled(scrollingCacheEnabled);
        boolean useTextFilter = a.getBoolean(4, false);
        this.setTextFilterEnabled(useTextFilter);
        int transcriptMode = a.getInt(5, 0);
        this.setTranscriptMode(transcriptMode);
        int color2 = a.getColor(6, 0);
        this.setCacheColorHint(color2);
        boolean enableFastScroll = a.getBoolean(8, false);
        this.setFastScrollEnabled(enableFastScroll);
        boolean smoothScrollbar = a.getBoolean(9, true);
        this.setSmoothScrollbarEnabled(smoothScrollbar);
        this.setChoiceMode(a.getInt(7, 0));
        this.setFastScrollAlwaysVisible(a.getBoolean(10, false));
        a.recycle();
    }

    public void initAbsListView() {
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setScrollingCacheEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.mDensityScale = this.getContext().getResources().getDisplayMetrics().density;
    }

    @Override
    public void setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                Resources res = context.getResources();
                Drawable edge = res.getDrawable(17302481);
                Drawable glow = res.getDrawable(17302482);
                this.mEdgeGlowTop = new EdgeGlow(context, edge, glow);
                this.mEdgeGlowBottom = new EdgeGlow(context, edge, glow);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
        super.setOverScrollMode(mode);
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (adapter != null && this.mChoiceMode != 0 && this.mAdapter.hasStableIds() && this.mCheckedIdStates == null) {
            this.mCheckedIdStates = new LongSparseArray();
        }
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
    }

    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    public boolean isItemChecked(int position) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return this.mCheckStates.get(position);
        }
        return false;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == 0 || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Boolean> idStates = this.mCheckedIdStates;
        int count = idStates.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = idStates.keyAt(i);
        }
        return ids;
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    public void setItemChecked(int position, boolean value) {
        if (this.mChoiceMode == 0) {
            return;
        }
        if (value && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
            boolean oldValue = this.mCheckStates.get(position);
            this.mCheckStates.put(position, value);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (value) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), Boolean.TRUE);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                }
            }
            if (oldValue != value) {
                this.mCheckedItemCount = value ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
            if (this.mChoiceActionMode != null) {
                long id2 = this.mAdapter.getItemId(position);
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, value);
            }
        } else {
            boolean updateIds;
            boolean bl = updateIds = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            if (value || this.isItemChecked(position)) {
                this.mCheckStates.clear();
                if (updateIds) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (value) {
                this.mCheckStates.put(position, true);
                if (updateIds) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), Boolean.TRUE);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
        }
        if (!this.mInLayout && !this.mBlockLayoutRequests) {
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
    }

    @Override
    public boolean performItemClick(View view, int position, long id2) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean newValue = !this.mCheckStates.get(position, false);
                this.mCheckStates.put(position, newValue);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (newValue) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), Boolean.TRUE);
                    } else {
                        this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                    }
                }
                this.mCheckedItemCount = newValue ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, newValue);
                    dispatchItemClick = false;
                }
            } else if (this.mChoiceMode == 1) {
                boolean newValue;
                boolean bl = newValue = !this.mCheckStates.get(position, false);
                if (newValue) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(position, true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), Boolean.TRUE);
                    }
                    this.mCheckedItemCount = 1;
                } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                    this.mCheckedItemCount = 0;
                }
            }
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, position, id2);
        }
        return handled;
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray();
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray();
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener listener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper();
        }
        this.mMultiChoiceModeCallback.setWrapped(listener);
    }

    public boolean contentFits() {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        if (childCount != this.mItemCount) {
            return false;
        }
        return this.getChildAt(0).getTop() >= this.mListPadding.top && this.getChildAt(childCount - 1).getBottom() <= this.getHeight() - this.mListPadding.bottom;
    }

    public void setFastScrollEnabled(boolean enabled) {
        this.mFastScrollEnabled = enabled;
        if (enabled) {
            if (this.mFastScroller == null) {
                this.mFastScroller = new FastScroller(this.getContext(), this);
            }
        } else if (this.mFastScroller != null) {
            this.mFastScroller.stop();
            this.mFastScroller = null;
        }
    }

    public void setFastScrollAlwaysVisible(boolean alwaysShow) {
        if (alwaysShow && !this.mFastScrollEnabled) {
            this.setFastScrollEnabled(true);
        }
        if (this.mFastScroller != null) {
            this.mFastScroller.setAlwaysShow(alwaysShow);
        }
        this.computeOpaqueFlags();
        this.recomputePadding();
    }

    public boolean isFastScrollAlwaysVisible() {
        return this.mFastScrollEnabled && this.mFastScroller.isAlwaysShowEnabled();
    }

    @Override
    public int getVerticalScrollbarWidth() {
        if (this.isFastScrollAlwaysVisible()) {
            return Math.max(super.getVerticalScrollbarWidth(), this.mFastScroller.getWidth());
        }
        return super.getVerticalScrollbarWidth();
    }

    @ViewDebug.ExportedProperty
    public boolean isFastScrollEnabled() {
        return this.mFastScrollEnabled;
    }

    @Override
    public void setVerticalScrollbarPosition(int position) {
        super.setVerticalScrollbarPosition(position);
        if (this.mFastScroller != null) {
            this.mFastScroller.setScrollbarPosition(position);
        }
    }

    @Override
    public boolean isVerticalScrollBarHidden() {
        return this.mFastScroller != null && this.mFastScroller.isVisible();
    }

    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.mSmoothScrollbarEnabled = enabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public void setOnScrollListener(OnScrollListener l) {
        this.mOnScrollListener = l;
        this.invokeOnItemScrollListener();
    }

    public void invokeOnItemScrollListener() {
        if (this.mFastScroller != null) {
            this.mFastScroller.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
    }

    @ViewDebug.ExportedProperty
    public boolean isScrollingCacheEnabled() {
        return this.mScrollingCacheEnabled;
    }

    public void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled && !enabled) {
            this.clearScrollingCache();
        }
        this.mScrollingCacheEnabled = enabled;
    }

    public void setTextFilterEnabled(boolean textFilterEnabled) {
        this.mTextFilterEnabled = textFilterEnabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isTextFilterEnabled() {
        return this.mTextFilterEnabled;
    }

    @Override
    public void getFocusedRect(Rect r) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(r);
            this.offsetDescendantRectToMyCoords(view, r);
        } else {
            super.getFocusedRect(r);
        }
    }

    public void useDefaultSelector() {
        this.setSelector(this.getResources().getDrawable(17301602));
    }

    @ViewDebug.ExportedProperty
    public boolean isStackFromBottom() {
        return this.mStackFromBottom;
    }

    public void setStackFromBottom(boolean stackFromBottom) {
        if (this.mStackFromBottom != stackFromBottom) {
            this.mStackFromBottom = stackFromBottom;
            this.requestLayoutIfNecessary();
        }
    }

    public void requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Editable filterText;
        EditText textFilter;
        long selectedId;
        this.dismissPopup();
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        boolean haveChildren = this.getChildCount() > 0 && this.mItemCount > 0;
        ss.selectedId = selectedId = this.getSelectedItemId();
        ss.height = this.getHeight();
        if (selectedId >= 0L) {
            ss.viewTop = this.mSelectedTop;
            ss.position = this.getSelectedItemPosition();
            ss.firstId = -1L;
        } else if (haveChildren && this.mFirstPosition > 0) {
            View v = this.getChildAt(0);
            ss.viewTop = v.getTop();
            int firstPos = this.mFirstPosition;
            if (firstPos >= this.mItemCount) {
                firstPos = this.mItemCount - 1;
            }
            ss.position = firstPos;
            ss.firstId = this.mAdapter.getItemId(firstPos);
        } else {
            ss.viewTop = 0;
            ss.firstId = -1L;
            ss.position = 0;
        }
        ss.filter = null;
        if (this.mFiltered && (textFilter = this.mTextFilter) != null && (filterText = textFilter.getText()) != null) {
            ss.filter = filterText.toString();
        }
        ss.inActionMode = this.mChoiceMode == 3 && this.mChoiceActionMode != null;
        ss.checkState = this.mCheckStates;
        ss.checkIdState = this.mCheckedIdStates;
        ss.checkedItemCount = this.mCheckedItemCount;
        return ss;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDataChanged = true;
        this.mSyncHeight = ss.height;
        if (ss.selectedId >= 0L) {
            this.mNeedSync = true;
            this.mSyncRowId = ss.selectedId;
            this.mSyncPosition = ss.position;
            this.mSpecificTop = ss.viewTop;
            this.mSyncMode = 0;
        } else if (ss.firstId >= 0L) {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectorPosition = -1;
            this.mNeedSync = true;
            this.mSyncRowId = ss.firstId;
            this.mSyncPosition = ss.position;
            this.mSpecificTop = ss.viewTop;
            this.mSyncMode = 1;
        }
        this.setFilterText(ss.filter);
        if (ss.checkState != null) {
            this.mCheckStates = ss.checkState;
        }
        if (ss.checkIdState != null) {
            this.mCheckedIdStates = ss.checkIdState;
        }
        this.mCheckedItemCount = ss.checkedItemCount;
        if (ss.inActionMode && this.mChoiceMode == 3 && this.mMultiChoiceModeCallback != null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        this.requestLayout();
    }

    public boolean acceptFilter() {
        return this.mTextFilterEnabled && this.getAdapter() instanceof Filterable && ((Filterable)this.getAdapter()).getFilter() != null;
    }

    public void setFilterText(String filterText) {
        if (this.mTextFilterEnabled && !TextUtils.isEmpty(filterText)) {
            this.createTextFilter(false);
            this.mTextFilter.setText(filterText);
            this.mTextFilter.setSelection(filterText.length());
            if (this.mAdapter instanceof Filterable) {
                if (this.mPopup == null) {
                    Filter f = ((Filterable)((Object)this.mAdapter)).getFilter();
                    f.filter(filterText);
                }
                this.mFiltered = true;
                this.mDataSetObserver.clearSavedState();
            }
        }
    }

    public CharSequence getTextFilter() {
        if (this.mTextFilterEnabled && this.mTextFilter != null) {
            return this.mTextFilter.getText();
        }
        return null;
    }

    @Override
    public void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedPosition < 0 && !this.isInTouchMode()) {
            this.resurrectSelection();
        }
    }

    @Override
    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    public void resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.mSelectedTop = 0;
        this.mSelectorShowing = false;
        this.mSelectorPosition = -1;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    @Override
    public int computeVerticalScrollExtent() {
        int count = this.getChildCount();
        if (count > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int extent = count * 100;
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    extent += top * 100 / height;
                }
                view = this.getChildAt(count - 1);
                int bottom = view.getBottom();
                height = view.getHeight();
                if (height > 0) {
                    extent -= (bottom - this.getHeight()) * 100 / height;
                }
                return extent;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int computeVerticalScrollOffset() {
        int firstPosition = this.mFirstPosition;
        int childCount = this.getChildCount();
        if (firstPosition >= 0 && childCount > 0) {
            if (this.mSmoothScrollbarEnabled) {
                View view = this.getChildAt(0);
                int top = view.getTop();
                int height = view.getHeight();
                if (height > 0) {
                    return Math.max(firstPosition * 100 - top * 100 / height + (int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f), 0);
                }
            } else {
                int count = this.mItemCount;
                int index = firstPosition == 0 ? 0 : (firstPosition + childCount == count ? count : firstPosition + childCount / 2);
                return (int)((float)firstPosition + (float)childCount * ((float)index / (float)count));
            }
        }
        return 0;
    }

    @Override
    public int computeVerticalScrollRange() {
        int result;
        if (this.mSmoothScrollbarEnabled) {
            result = Math.max(this.mItemCount * 100, 0);
            if (this.mScrollY != 0) {
                result += Math.abs((int)((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount * 100.0f));
            }
        } else {
            result = this.mItemCount;
        }
        return result;
    }

    @Override
    public float getTopFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getTopFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition > 0) {
            return 1.0f;
        }
        int top = this.getChildAt(0).getTop();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return top < this.mPaddingTop ? (float)(-(top - this.mPaddingTop)) / fadeLength : fadeEdge;
    }

    @Override
    public float getBottomFadingEdgeStrength() {
        int count = this.getChildCount();
        float fadeEdge = super.getBottomFadingEdgeStrength();
        if (count == 0) {
            return fadeEdge;
        }
        if (this.mFirstPosition + count - 1 < this.mItemCount - 1) {
            return 1.0f;
        }
        int bottom = this.getChildAt(count - 1).getBottom();
        int height = this.getHeight();
        float fadeLength = this.getVerticalFadingEdgeLength();
        return bottom > height - this.mPaddingBottom ? (float)(bottom - height + this.mPaddingBottom) / fadeLength : fadeEdge;
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect listPadding = this.mListPadding;
        listPadding.left = this.mSelectionLeftPadding + this.mPaddingLeft;
        listPadding.top = this.mSelectionTopPadding + this.mPaddingTop;
        listPadding.right = this.mSelectionRightPadding + this.mPaddingRight;
        listPadding.bottom = this.mSelectionBottomPadding + this.mPaddingBottom;
        if (this.mTranscriptMode == 1) {
            int childCount = this.getChildCount();
            int listBottom = this.getBottom() - this.getPaddingBottom();
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
            this.mForceTranscriptScroll = this.mFirstPosition + childCount >= this.mOldItemCount && lastBottom <= listBottom;
        }
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        if (changed) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        if (this.mFastScroller != null && this.mItemCount != this.mOldItemCount) {
            this.mFastScroller.onItemCountChanged(this.mOldItemCount, this.mItemCount);
        }
        this.layoutChildren();
        this.mInLayout = false;
        this.mOverscrollMax = (b - t) / 3;
    }

    @Override
    public boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = super.setFrame(left, top, right, bottom);
        if (changed) {
            boolean visible;
            boolean bl = visible = this.getWindowVisibility() == 0;
            if (this.mFiltered && visible && this.mPopup != null && this.mPopup.isShowing()) {
                this.positionPopup();
            }
        }
        return changed;
    }

    public void layoutChildren() {
    }

    public void updateScrollIndicators() {
        if (this.mScrollUp != null) {
            boolean canScrollUp;
            boolean bl = canScrollUp = this.mFirstPosition > 0;
            if (!canScrollUp && this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                canScrollUp = child.getTop() < this.mListPadding.top;
            }
            this.mScrollUp.setVisibility(canScrollUp ? 0 : 4);
        }
        if (this.mScrollDown != null) {
            boolean canScrollDown;
            int count = this.getChildCount();
            boolean bl = canScrollDown = this.mFirstPosition + count < this.mItemCount;
            if (!canScrollDown && count > 0) {
                View child = this.getChildAt(count - 1);
                canScrollDown = child.getBottom() > this.mBottom - this.mListPadding.bottom;
            }
            this.mScrollDown.setVisibility(canScrollDown ? 0 : 4);
        }
    }

    @Override
    @ViewDebug.ExportedProperty
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    public int getListPaddingTop() {
        return this.mListPadding.top;
    }

    public int getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    public int getListPaddingLeft() {
        return this.mListPadding.left;
    }

    public int getListPaddingRight() {
        return this.mListPadding.right;
    }

    public View obtainView(int position, boolean[] isScrap) {
        View child;
        isScrap[0] = false;
        View scrapView = this.mRecycler.getScrapView(position);
        if (scrapView != null) {
            child = this.mAdapter.getView(position, scrapView, this);
            if (child != scrapView) {
                this.mRecycler.addScrapView(scrapView, position);
                if (this.mCacheColorHint != 0) {
                    child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
                }
            } else {
                isScrap[0] = true;
                child.dispatchFinishTemporaryDetach();
            }
        } else {
            child = this.mAdapter.getView(position, null, this);
            if (this.mCacheColorHint != 0) {
                child.setDrawingCacheBackgroundColor(this.mCacheColorHint);
            }
        }
        return child;
    }

    public void positionSelector(int position, View sel) {
        if (position != -1) {
            this.mSelectorPosition = position;
        }
        Rect selectorRect = this.mSelectorRect;
        selectorRect.set(sel.getLeft(), sel.getTop(), sel.getRight(), sel.getBottom());
        if (sel instanceof SelectionBoundsAdjuster) {
            ((SelectionBoundsAdjuster)((Object)sel)).adjustListItemSelectionBounds(selectorRect);
        }
        this.positionSelector(selectorRect.left, selectorRect.top, selectorRect.right, selectorRect.bottom);
        boolean isChildViewEnabled = this.mIsChildViewEnabled;
        if (sel.isEnabled() != isChildViewEnabled) {
            boolean bl = this.mIsChildViewEnabled = !isChildViewEnabled;
            if (this.mSelectorShowing) {
                this.refreshDrawableState();
            }
        }
    }

    public void positionSelector(int l, int t, int r, int b) {
        this.mSelectorRect.set(l - this.mSelectionLeftPadding, t - this.mSelectionTopPadding, r + this.mSelectionRightPadding, b + this.mSelectionBottomPadding);
    }

    @Override
    public void dispatchDraw(Canvas canvas) {
        boolean drawSelectorOnTop;
        boolean clipToPadding;
        int saveCount = 0;
        boolean bl = clipToPadding = (this.mGroupFlags & 0x22) == 34;
        if (clipToPadding) {
            saveCount = canvas.save();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
            this.mGroupFlags &= 0xFFFFFFDD;
        }
        if (!(drawSelectorOnTop = this.mDrawSelectorOnTop)) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (drawSelectorOnTop) {
            this.drawSelector(canvas);
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
            this.mGroupFlags |= 0x22;
        }
    }

    @Override
    public boolean isPaddingOffsetRequired() {
        return (this.mGroupFlags & 0x22) != 34;
    }

    @Override
    public int getLeftPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : -this.mPaddingLeft;
    }

    @Override
    public int getTopPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : -this.mPaddingTop;
    }

    @Override
    public int getRightPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : this.mPaddingRight;
    }

    @Override
    public int getBottomPaddingOffset() {
        return (this.mGroupFlags & 0x22) == 34 ? 0 : this.mPaddingBottom;
    }

    @Override
    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.getChildCount() > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
        }
        if (this.mFastScroller != null) {
            this.mFastScroller.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public boolean touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldShowSelector() {
        return this.hasFocus() && !this.isInTouchMode() || this.touchModeDrawsInPressedState();
    }

    public void drawSelector(Canvas canvas) {
        if (!this.mSelectorRect.isEmpty()) {
            Drawable selector = this.mSelector;
            selector.setBounds(this.mSelectorRect);
            selector.draw(canvas);
        }
    }

    public void setDrawSelectorOnTop(boolean onTop) {
        this.mDrawSelectorOnTop = onTop;
    }

    public void setSelector(int resID) {
        this.setSelector(this.getResources().getDrawable(resID));
    }

    public void setSelector(Drawable sel) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = sel;
        Rect padding = new Rect();
        sel.getPadding(padding);
        this.mSelectionLeftPadding = padding.left;
        this.mSelectionTopPadding = padding.top;
        this.mSelectionRightPadding = padding.right;
        this.mSelectionBottomPadding = padding.bottom;
        sel.setCallback(this);
        this.updateSelectorState();
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    public void keyPressed() {
        if (!this.isEnabled() || !this.isClickable()) {
            return;
        }
        Drawable selector = this.mSelector;
        Rect selectorRect = this.mSelectorRect;
        if (selector != null && (this.isFocused() || this.touchModeDrawsInPressedState()) && !selectorRect.isEmpty()) {
            View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
            if (v != null) {
                if (v.hasFocusable()) {
                    return;
                }
                v.setPressed(true);
            }
            this.setPressed(true);
            boolean longClickable = this.isLongClickable();
            Drawable d = selector.getCurrent();
            if (d != null && d instanceof TransitionDrawable) {
                if (longClickable) {
                    ((TransitionDrawable)d).startTransition(ViewConfiguration.getLongPressTimeout());
                } else {
                    ((TransitionDrawable)d).resetTransition();
                }
            }
            if (longClickable && !this.mDataChanged) {
                if (this.mPendingCheckForKeyLongPress == null) {
                    this.mPendingCheckForKeyLongPress = new CheckForKeyLongPress(null);
                }
                this.mPendingCheckForKeyLongPress.rememberWindowAttachCount();
                this.postDelayed(this.mPendingCheckForKeyLongPress, ViewConfiguration.getLongPressTimeout());
            }
        }
    }

    public void setScrollIndicators(View up, View down) {
        this.mScrollUp = up;
        this.mScrollDown = down;
    }

    public void updateSelectorState() {
        if (this.mSelector != null) {
            if (this.shouldShowSelector()) {
                this.mSelector.setState(this.getDrawableState());
            } else {
                this.mSelector.setState(StateSet.NOTHING);
            }
        }
    }

    @Override
    public void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateSelectorState();
    }

    @Override
    public int[] onCreateDrawableState(int extraSpace) {
        if (this.mIsChildViewEnabled) {
            return super.onCreateDrawableState(extraSpace);
        }
        int enabledState = ENABLED_STATE_SET[0];
        int[] state = super.onCreateDrawableState(extraSpace + 1);
        int enabledPos = -1;
        for (int i = state.length - 1; i >= 0; --i) {
            if (state[i] != enabledState) continue;
            enabledPos = i;
            break;
        }
        if (enabledPos >= 0) {
            System.arraycopy(state, enabledPos + 1, state, enabledPos, state.length - enabledPos - 1);
        }
        return state;
    }

    @Override
    public boolean verifyDrawable(Drawable dr) {
        return this.mSelector == dr || super.verifyDrawable(dr);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mSelector != null) {
            this.mSelector.jumpToCurrentState();
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        if (treeObserver != null) {
            treeObserver.addOnTouchModeChangeListener(this);
            if (this.mTextFilterEnabled && this.mPopup != null && !this.mGlobalLayoutListenerAddedFilter) {
                treeObserver.addOnGlobalLayoutListener(this);
            }
        }
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismissPopup();
        this.mRecycler.clear();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        if (treeObserver != null) {
            treeObserver.removeOnTouchModeChangeListener(this);
            if (this.mTextFilterEnabled && this.mPopup != null) {
                treeObserver.removeGlobalOnLayoutListener(this);
                this.mGlobalLayoutListenerAddedFilter = false;
            }
        }
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
        if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
        if (this.mFlingRunnable != null) {
            this.removeCallbacks(this.mFlingRunnable);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mClearScrollingCache != null) {
            this.removeCallbacks(this.mClearScrollingCache);
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset = null;
        }
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        int touchMode;
        super.onWindowFocusChanged(hasWindowFocus);
        int n = touchMode = this.isInTouchMode() ? 0 : 1;
        if (!hasWindowFocus) {
            this.setChildrenDrawingCacheEnabled(false);
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.endFling();
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentCaches();
                    this.finishGlows();
                    this.invalidate();
                }
            }
            this.dismissPopup();
            if (touchMode == 1) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
        } else {
            if (this.mFiltered && !this.mPopupHidden) {
                this.showPopup();
            }
            if (touchMode != this.mLastTouchMode && this.mLastTouchMode != -1) {
                if (touchMode == 1) {
                    this.resurrectSelection();
                } else {
                    this.hideSelector();
                    this.mLayoutMode = 0;
                    this.layoutChildren();
                }
            }
        }
        this.mLastTouchMode = touchMode;
    }

    public ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    public boolean performLongPress(View child, int longPressPosition, long longPressId) {
        if (this.mChoiceMode == 3) {
            if (this.mChoiceActionMode == null) {
                this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
                this.setItemChecked(longPressPosition, true);
            }
            this.performHapticFeedback(0);
            return true;
        }
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, child, longPressPosition, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = super.showContextMenuForChild(this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    @Override
    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition >= 0) {
            long longPressId = this.mAdapter.getItemId(longPressPosition);
            boolean handled = false;
            if (this.mOnItemLongClickListener != null) {
                handled = this.mOnItemLongClickListener.onItemLongClick(this, originalView, longPressPosition, longPressId);
            }
            if (!handled) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(longPressPosition - this.mFirstPosition), longPressPosition, longPressId);
                handled = super.showContextMenuForChild(originalView);
            }
            return handled;
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.isEnabled()) {
                    return true;
                }
                if (!this.isClickable() || !this.isPressed() || this.mSelectedPosition < 0 || this.mAdapter == null || this.mSelectedPosition >= this.mAdapter.getCount()) break;
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                if (view != null) {
                    this.performItemClick(view, this.mSelectedPosition, this.mSelectedRowId);
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void dispatchSetPressed(boolean pressed) {
    }

    public int pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    public long pointToRowId(int x, int y) {
        int position = this.pointToPosition(x, y);
        if (position >= 0) {
            return this.mAdapter.getItemId(position);
        }
        return Long.MIN_VALUE;
    }

    public boolean startScrollIfNeeded(int deltaY) {
        boolean overscroll;
        int distance = Math.abs(deltaY);
        boolean bl = overscroll = this.mScrollY != 0;
        if (overscroll || distance > this.mTouchSlop) {
            this.createScrollingCache();
            this.mTouchMode = overscroll ? 5 : 3;
            this.mMotionCorrection = deltaY;
            Handler handler = this.getHandler();
            if (handler != null) {
                handler.removeCallbacks(this.mPendingCheckForLongPress);
            }
            this.setPressed(false);
            View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (motionView != null) {
                motionView.setPressed(false);
            }
            this.reportScrollStateChange(1);
            this.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        return false;
    }

    @Override
    public void onTouchModeChanged(boolean isInTouchMode) {
        if (isInTouchMode) {
            this.hideSelector();
            if (this.getHeight() > 0 && this.getChildCount() > 0) {
                this.layoutChildren();
            }
        } else {
            int touchMode = this.mTouchMode;
            if (touchMode == 5 || touchMode == 6) {
                if (this.mFlingRunnable != null) {
                    this.mFlingRunnable.endFling();
                }
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentCaches();
                    this.finishGlows();
                    this.invalidate();
                }
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        boolean intercepted;
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        if (this.mFastScroller != null && (intercepted = this.mFastScroller.onTouchEvent(ev))) {
            return true;
        }
        int action = ev.getAction();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        block0 : switch (action & 0xFF) {
            case 0: {
                switch (this.mTouchMode) {
                    case 6: {
                        this.mFlingRunnable.endFling();
                        if (this.mPositionScroller != null) {
                            this.mPositionScroller.stop();
                        }
                        this.mTouchMode = 5;
                        this.mMotionY = this.mLastY = (int)ev.getY();
                        this.mMotionCorrection = 0;
                        this.mActivePointerId = ev.getPointerId(0);
                        break block0;
                    }
                }
                this.mActivePointerId = ev.getPointerId(0);
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                int motionPosition = this.pointToPosition(x, y);
                if (!this.mDataChanged) {
                    if (this.mTouchMode != 4 && motionPosition >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(motionPosition)) {
                        this.mTouchMode = 0;
                        if (this.mPendingCheckForTap == null) {
                            this.mPendingCheckForTap = new CheckForTap();
                        }
                        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    } else {
                        if (ev.getEdgeFlags() != 0 && motionPosition < 0) {
                            return false;
                        }
                        if (this.mTouchMode == 4) {
                            this.createScrollingCache();
                            this.mTouchMode = 3;
                            this.mMotionCorrection = 0;
                            motionPosition = this.findMotionRow(y);
                            this.mFlingRunnable.flywheelTouch();
                        }
                    }
                }
                if (motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                }
                this.mMotionX = x;
                this.mMotionY = y;
                this.mMotionPosition = motionPosition;
                this.mLastY = Integer.MIN_VALUE;
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                int y = (int)ev.getY(pointerIndex);
                int deltaY = y - this.mMotionY;
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.startScrollIfNeeded(deltaY);
                        break;
                    }
                    case 3: {
                        if (this.mScrollStrictSpan == null) {
                            this.mScrollStrictSpan = StrictMode.enterCriticalSpan("AbsListView-scroll");
                        }
                        if (y == this.mLastY) break;
                        if ((this.mGroupFlags & 0x80000) == 0 && Math.abs(deltaY) > this.mTouchSlop) {
                            this.requestDisallowInterceptTouchEvent(true);
                        }
                        int rawDeltaY = deltaY;
                        int incrementalDeltaY = this.mLastY != Integer.MIN_VALUE ? y - this.mLastY : (deltaY -= this.mMotionCorrection);
                        int motionIndex = this.mMotionPosition >= 0 ? this.mMotionPosition - this.mFirstPosition : this.getChildCount() / 2;
                        int motionViewPrevTop = 0;
                        View motionView = this.getChildAt(motionIndex);
                        if (motionView != null) {
                            motionViewPrevTop = motionView.getTop();
                        }
                        boolean atEdge = false;
                        if (incrementalDeltaY != 0) {
                            atEdge = this.trackMotionScroll(deltaY, incrementalDeltaY);
                        }
                        if ((motionView = this.getChildAt(motionIndex)) != null) {
                            int motionViewRealTop = motionView.getTop();
                            if (atEdge) {
                                int overscrollMode;
                                int overscroll = -incrementalDeltaY - (motionViewRealTop - motionViewPrevTop);
                                this.overScrollBy(0, overscroll, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                                if (Math.abs(this.mOverscrollDistance) == Math.abs(this.mScrollY)) {
                                    this.mVelocityTracker.clear();
                                }
                                if ((overscrollMode = this.getOverScrollMode()) == 0 || overscrollMode == 1 && !this.contentFits()) {
                                    this.mDirection = 0;
                                    this.mTouchMode = 5;
                                    if (rawDeltaY > 0) {
                                        this.mEdgeGlowTop.onPull((float)overscroll / (float)this.getHeight());
                                        if (!this.mEdgeGlowBottom.isFinished()) {
                                            this.mEdgeGlowBottom.onRelease();
                                        }
                                    } else if (rawDeltaY < 0) {
                                        this.mEdgeGlowBottom.onPull((float)overscroll / (float)this.getHeight());
                                        if (!this.mEdgeGlowTop.isFinished()) {
                                            this.mEdgeGlowTop.onRelease();
                                        }
                                    }
                                }
                            }
                            this.mMotionY = y;
                            this.invalidate();
                        }
                        this.mLastY = y;
                        break;
                    }
                    case 5: {
                        int newDirection;
                        if (y == this.mLastY) break;
                        int rawDeltaY = deltaY;
                        int incrementalDeltaY = this.mLastY != Integer.MIN_VALUE ? y - this.mLastY : (deltaY -= this.mMotionCorrection);
                        int oldScroll = this.mScrollY;
                        int newScroll = oldScroll - incrementalDeltaY;
                        int n = newDirection = y > this.mLastY ? 1 : -1;
                        if (this.mDirection == 0) {
                            this.mDirection = newDirection;
                        }
                        if (this.mDirection != newDirection) {
                            View motionView;
                            incrementalDeltaY = -newScroll;
                            this.mScrollY = 0;
                            this.invalidateParentIfNeeded();
                            if (incrementalDeltaY != 0) {
                                this.trackMotionScroll(incrementalDeltaY, incrementalDeltaY);
                            }
                            if ((motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition)) != null) {
                                this.mTouchMode = 3;
                                int motionPosition = this.findClosestMotionRow(y);
                                this.mMotionCorrection = 0;
                                motionView = this.getChildAt(motionPosition - this.mFirstPosition);
                                this.mMotionViewOriginalTop = motionView.getTop();
                                this.mMotionY = y;
                                this.mMotionPosition = motionPosition;
                            }
                        } else {
                            this.overScrollBy(0, -incrementalDeltaY, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                            int overscrollMode = this.getOverScrollMode();
                            if (overscrollMode == 0 || overscrollMode == 1 && !this.contentFits()) {
                                if (rawDeltaY > 0) {
                                    this.mEdgeGlowTop.onPull((float)(-incrementalDeltaY) / (float)this.getHeight());
                                    if (!this.mEdgeGlowBottom.isFinished()) {
                                        this.mEdgeGlowBottom.onRelease();
                                    }
                                } else if (rawDeltaY < 0) {
                                    this.mEdgeGlowBottom.onPull((float)(-incrementalDeltaY) / (float)this.getHeight());
                                    if (!this.mEdgeGlowTop.isFinished()) {
                                        this.mEdgeGlowTop.onRelease();
                                    }
                                }
                                this.invalidate();
                            }
                            if (Math.abs(this.mOverscrollDistance) == Math.abs(this.mScrollY)) {
                                this.mVelocityTracker.clear();
                            }
                        }
                        this.mLastY = y;
                        this.mDirection = newDirection;
                    }
                }
                break;
            }
            case 1: {
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        int motionPosition = this.mMotionPosition;
                        final View child = this.getChildAt(motionPosition - this.mFirstPosition);
                        if (child != null && !child.hasFocusable()) {
                            if (this.mTouchMode != 0) {
                                child.setPressed(false);
                            }
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick(null);
                            }
                            final PerformClick performClick = this.mPerformClick;
                            performClick.mClickMotionPosition = motionPosition;
                            performClick.rememberWindowAttachCount();
                            this.mResurrectToPosition = motionPosition;
                            if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                                Handler handler = this.getHandler();
                                if (handler != null) {
                                    handler.removeCallbacks(this.mTouchMode == 0 ? this.mPendingCheckForTap : this.mPendingCheckForLongPress);
                                }
                                this.mLayoutMode = 0;
                                if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                    Drawable d;
                                    this.mTouchMode = 1;
                                    this.setSelectedPositionInt(this.mMotionPosition);
                                    this.layoutChildren();
                                    child.setPressed(true);
                                    this.positionSelector(this.mMotionPosition, child);
                                    this.setPressed(true);
                                    if (this.mSelector != null && (d = this.mSelector.getCurrent()) != null && d instanceof TransitionDrawable) {
                                        ((TransitionDrawable)d).resetTransition();
                                    }
                                    if (this.mTouchModeReset != null) {
                                        this.removeCallbacks(this.mTouchModeReset);
                                    }
                                    this.mTouchModeReset = new Runnable(){

                                        public void run() {
                                            AbsListView.this.mTouchMode = -1;
                                            child.setPressed(false);
                                            AbsListView.this.setPressed(false);
                                            if (!AbsListView.this.mDataChanged) {
                                                performClick.run();
                                            }
                                        }
                                    };
                                    this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                                } else {
                                    this.mTouchMode = -1;
                                    this.updateSelectorState();
                                }
                                return true;
                            }
                            if (!this.mDataChanged && this.mAdapter.isEnabled(motionPosition)) {
                                performClick.run();
                            }
                        }
                        this.mTouchMode = -1;
                        this.updateSelectorState();
                        break;
                    }
                    case 3: {
                        int childCount = this.getChildCount();
                        if (childCount > 0) {
                            int firstChildTop = this.getChildAt(0).getTop();
                            int lastChildBottom = this.getChildAt(childCount - 1).getBottom();
                            int contentTop = this.mListPadding.top;
                            int contentBottom = this.getHeight() - this.mListPadding.bottom;
                            if (this.mFirstPosition == 0 && firstChildTop >= contentTop && this.mFirstPosition + childCount < this.mItemCount && lastChildBottom <= this.getHeight() - contentBottom) {
                                this.mTouchMode = -1;
                                this.reportScrollStateChange(0);
                                break;
                            }
                            VelocityTracker velocityTracker = this.mVelocityTracker;
                            velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                            int initialVelocity = (int)(velocityTracker.getYVelocity(this.mActivePointerId) * this.mVelocityScale);
                            if (!(Math.abs(initialVelocity) <= this.mMinimumVelocity || this.mFirstPosition == 0 && firstChildTop == contentTop - this.mOverscrollDistance || this.mFirstPosition + childCount == this.mItemCount && lastChildBottom == contentBottom + this.mOverscrollDistance)) {
                                if (this.mFlingRunnable == null) {
                                    this.mFlingRunnable = new FlingRunnable();
                                }
                                this.reportScrollStateChange(2);
                                this.mFlingRunnable.start(-initialVelocity);
                                break;
                            }
                            this.mTouchMode = -1;
                            this.reportScrollStateChange(0);
                            if (this.mFlingRunnable != null) {
                                this.mFlingRunnable.endFling();
                            }
                            if (this.mPositionScroller == null) break;
                            this.mPositionScroller.stop();
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    case 5: {
                        if (this.mFlingRunnable == null) {
                            this.mFlingRunnable = new FlingRunnable();
                        }
                        VelocityTracker velocityTracker = this.mVelocityTracker;
                        velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                        int initialVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                        this.reportScrollStateChange(2);
                        if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                            this.mFlingRunnable.startOverfling(-initialVelocity);
                            break;
                        }
                        this.mFlingRunnable.startSpringback();
                    }
                }
                this.setPressed(false);
                if (this.mEdgeGlowTop != null) {
                    this.mEdgeGlowTop.onRelease();
                    this.mEdgeGlowBottom.onRelease();
                }
                this.invalidate();
                Handler handler = this.getHandler();
                if (handler != null) {
                    handler.removeCallbacks(this.mPendingCheckForLongPress);
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mActivePointerId = -1;
                if (this.mScrollStrictSpan == null) break;
                this.mScrollStrictSpan.finish();
                this.mScrollStrictSpan = null;
                break;
            }
            case 3: {
                switch (this.mTouchMode) {
                    case 5: {
                        if (this.mFlingRunnable == null) {
                            this.mFlingRunnable = new FlingRunnable();
                        }
                        this.mFlingRunnable.startSpringback();
                        break;
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        this.mTouchMode = -1;
                        this.setPressed(false);
                        View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                        if (motionView != null) {
                            motionView.setPressed(false);
                        }
                        this.clearScrollingCache();
                        Handler handler = this.getHandler();
                        if (handler != null) {
                            handler.removeCallbacks(this.mPendingCheckForLongPress);
                        }
                        if (this.mVelocityTracker == null) break;
                        this.mVelocityTracker.recycle();
                        this.mVelocityTracker = null;
                    }
                }
                if (this.mEdgeGlowTop != null) {
                    this.mEdgeGlowTop.onRelease();
                    this.mEdgeGlowBottom.onRelease();
                }
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                int x = this.mMotionX;
                int y = this.mMotionY;
                int motionPosition = this.pointToPosition(x, y);
                if (motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                    this.mMotionPosition = motionPosition;
                }
                this.mLastY = y;
                break;
            }
        }
        return true;
    }

    @Override
    public void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        this.mScrollY = scrollY;
        this.invalidateParentIfNeeded();
        if (clampedY && this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
        }
        this.awakenScrollBars();
    }

    @Override
    public void draw(Canvas canvas) {
        int restoreCount;
        int scrollY;
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            int width;
            scrollY = this.mScrollY;
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                canvas.translate(0.0f, Math.min(0, scrollY + this.mFirstPositionDistanceGuess));
                this.mEdgeGlowTop.setSize(width, this.getHeight());
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.invalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                int height = this.getHeight();
                canvas.translate(-width, Math.max(height, scrollY + this.mLastPositionDistanceGuess));
                canvas.rotate(180.0f, width, 0.0f);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.invalidate();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
        if (this.mFastScroller != null) {
            scrollY = this.mScrollY;
            if (scrollY != 0) {
                restoreCount = canvas.save();
                canvas.translate(0.0f, scrollY);
                this.mFastScroller.draw(canvas);
                canvas.restoreToCount(restoreCount);
            } else {
                this.mFastScroller.draw(canvas);
            }
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercepted;
        int action = ev.getAction();
        if (this.mFastScroller != null && (intercepted = this.mFastScroller.onInterceptTouchEvent(ev))) {
            return true;
        }
        switch (action & 0xFF) {
            case 0: {
                int touchMode = this.mTouchMode;
                if (touchMode == 6 || touchMode == 5) {
                    this.mMotionCorrection = 0;
                    return true;
                }
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                int motionPosition = this.findMotionRow(y);
                if (touchMode != 4 && motionPosition >= 0) {
                    View v = this.getChildAt(motionPosition - this.mFirstPosition);
                    this.mMotionViewOriginalTop = v.getTop();
                    this.mMotionX = x;
                    this.mMotionY = y;
                    this.mMotionPosition = motionPosition;
                    this.mTouchMode = 0;
                    this.clearScrollingCache();
                }
                this.mLastY = Integer.MIN_VALUE;
                if (touchMode != 4) break;
                return true;
            }
            case 2: {
                switch (this.mTouchMode) {
                    case 0: {
                        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                        int y = (int)ev.getY(pointerIndex);
                        if (!this.startScrollIfNeeded(y - this.mMotionY)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: {
                this.mTouchMode = -1;
                this.mActivePointerId = -1;
                this.reportScrollStateChange(0);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return false;
    }

    public void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mMotionX = (int)ev.getX(newPointerIndex);
            this.mMotionY = (int)ev.getY(newPointerIndex);
            this.mMotionCorrection = 0;
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    @Override
    public void addTouchables(ArrayList<View> views) {
        int count = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (adapter.isEnabled(firstPosition + i)) {
                views.add(child);
            }
            child.addTouchables(views);
        }
    }

    public void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged(this, newState);
        }
    }

    public void setFriction(float friction) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.mFlingRunnable.mScroller.setFriction(friction);
    }

    public void setVelocityScale(float scale) {
        this.mVelocityScale = scale;
    }

    public void smoothScrollToPosition(int position) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(position);
    }

    public void smoothScrollToPositionFromTop(int position, int offset, int duration) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset, duration);
    }

    public void smoothScrollToPositionFromTop(int position, int offset) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.startWithOffset(position, offset);
    }

    public void smoothScrollToPosition(int position, int boundPosition) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = new PositionScroller();
        }
        this.mPositionScroller.start(position, boundPosition);
    }

    public void smoothScrollBy(int distance, int duration) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        int firstPos = this.mFirstPosition;
        int childCount = this.getChildCount();
        int lastPos = firstPos + childCount;
        int topLimit = this.getPaddingTop();
        int bottomLimit = this.getHeight() - this.getPaddingBottom();
        if (distance == 0 || this.mItemCount == 0 || childCount == 0 || firstPos == 0 && this.getChildAt(0).getTop() == topLimit && distance < 0 || lastPos == this.mItemCount - 1 && this.getChildAt(childCount - 1).getBottom() == bottomLimit && distance > 0) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
        } else {
            this.reportScrollStateChange(2);
            this.mFlingRunnable.startScroll(distance, duration);
        }
    }

    public void smoothScrollByOffset(int position) {
        View child;
        int index = -1;
        if (position < 0) {
            index = this.getFirstVisiblePosition();
        } else if (position > 0) {
            index = this.getLastVisiblePosition();
        }
        if (index > -1 && (child = this.getChildAt(index - this.getFirstVisiblePosition())) != null) {
            Rect visibleRect = new Rect();
            if (child.getGlobalVisibleRect(visibleRect)) {
                int childRectArea = child.getWidth() * child.getHeight();
                int visibleRectArea = visibleRect.width() * visibleRect.height();
                float visibleArea = (float)visibleRectArea / (float)childRectArea;
                float visibleThreshold = 0.75f;
                if (position < 0 && visibleArea < 0.75f) {
                    ++index;
                } else if (position > 0 && visibleArea < 0.75f) {
                    --index;
                }
            }
            this.smoothScrollToPosition(Math.max(0, Math.min(this.getCount(), index + position)));
        }
    }

    public void createScrollingCache() {
        if (this.mScrollingCacheEnabled && !this.mCachingStarted) {
            this.setChildrenDrawnWithCacheEnabled(true);
            this.setChildrenDrawingCacheEnabled(true);
            this.mCachingStarted = true;
        }
    }

    public void clearScrollingCache() {
        if (this.mClearScrollingCache == null) {
            this.mClearScrollingCache = new Runnable(){

                public void run() {
                    if (AbsListView.this.mCachingStarted) {
                        AbsListView.this.mCachingStarted = false;
                        AbsListView.this.setChildrenDrawnWithCacheEnabled(false);
                        if ((AbsListView.this.mPersistentDrawingCache & 2) == 0) {
                            AbsListView.this.setChildrenDrawingCacheEnabled(false);
                        }
                        if (!AbsListView.this.isAlwaysDrawnWithCacheEnabled()) {
                            AbsListView.this.invalidate();
                        }
                    }
                }
            };
        }
        this.post(this.mClearScrollingCache);
    }

    public boolean trackMotionScroll(int deltaY, int incrementalDeltaY) {
        int childIndex;
        int i;
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        int firstTop = this.getChildAt(0).getTop();
        int lastBottom = this.getChildAt(childCount - 1).getBottom();
        Rect listPadding = this.mListPadding;
        int effectivePaddingTop = 0;
        int effectivePaddingBottom = 0;
        if ((this.mGroupFlags & 0x22) == 34) {
            effectivePaddingTop = listPadding.top;
            effectivePaddingBottom = listPadding.bottom;
        }
        int spaceAbove = effectivePaddingTop - firstTop;
        int end = this.getHeight() - effectivePaddingBottom;
        int spaceBelow = lastBottom - end;
        int height = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        deltaY = deltaY < 0 ? Math.max(-(height - 1), deltaY) : Math.min(height - 1, deltaY);
        incrementalDeltaY = incrementalDeltaY < 0 ? Math.max(-(height - 1), incrementalDeltaY) : Math.min(height - 1, incrementalDeltaY);
        int firstPosition = this.mFirstPosition;
        this.mFirstPositionDistanceGuess = firstPosition == 0 ? firstTop - listPadding.top : (this.mFirstPositionDistanceGuess += incrementalDeltaY);
        this.mLastPositionDistanceGuess = firstPosition + childCount == this.mItemCount ? lastBottom + listPadding.bottom : (this.mLastPositionDistanceGuess += incrementalDeltaY);
        if (firstPosition == 0 && firstTop >= listPadding.top && incrementalDeltaY >= 0) {
            return incrementalDeltaY != 0;
        }
        if (firstPosition + childCount == this.mItemCount && lastBottom <= this.getHeight() - listPadding.bottom && incrementalDeltaY <= 0) {
            return incrementalDeltaY != 0;
        }
        boolean down = incrementalDeltaY < 0;
        boolean inTouchMode = this.isInTouchMode();
        if (inTouchMode) {
            this.hideSelector();
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int footerViewsStart = this.mItemCount - this.getFooterViewsCount();
        int start = 0;
        int count = 0;
        if (down) {
            View child;
            int top = -incrementalDeltaY;
            if ((this.mGroupFlags & 0x22) == 34) {
                top += listPadding.top;
            }
            for (i = 0; i < childCount && (child = this.getChildAt(i)).getBottom() < top; ++i) {
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                this.mRecycler.addScrapView(child, position);
            }
        } else {
            View child;
            int bottom = this.getHeight() - incrementalDeltaY;
            if ((this.mGroupFlags & 0x22) == 34) {
                bottom -= listPadding.bottom;
            }
            for (i = childCount - 1; i >= 0 && (child = this.getChildAt(i)).getTop() > bottom; --i) {
                start = i;
                ++count;
                int position = firstPosition + i;
                if (position < headerViewsCount || position >= footerViewsStart) continue;
                this.mRecycler.addScrapView(child, position);
            }
        }
        this.mMotionViewNewTop = this.mMotionViewOriginalTop + deltaY;
        this.mBlockLayoutRequests = true;
        if (count > 0) {
            this.detachViewsFromParent(start, count);
        }
        this.offsetChildrenTopAndBottom(incrementalDeltaY);
        if (down) {
            this.mFirstPosition += count;
        }
        this.invalidate();
        int absIncrementalDeltaY = Math.abs(incrementalDeltaY);
        if (spaceAbove < absIncrementalDeltaY || spaceBelow < absIncrementalDeltaY) {
            this.fillGap(down);
        }
        if (!inTouchMode && this.mSelectedPosition != -1) {
            childIndex = this.mSelectedPosition - this.mFirstPosition;
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                this.positionSelector(this.mSelectedPosition, this.getChildAt(childIndex));
            }
        } else if (this.mSelectorPosition != -1) {
            childIndex = this.mSelectorPosition - this.mFirstPosition;
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                this.positionSelector(-1, this.getChildAt(childIndex));
            }
        } else {
            this.mSelectorRect.setEmpty();
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        this.awakenScrollBars();
        return false;
    }

    public int getHeaderViewsCount() {
        return 0;
    }

    public int getFooterViewsCount() {
        return 0;
    }

    public abstract void fillGap(boolean var1);

    public void hideSelector() {
        if (this.mSelectedPosition != -1) {
            if (this.mLayoutMode != 4) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
            if (this.mNextSelectedPosition >= 0 && this.mNextSelectedPosition != this.mSelectedPosition) {
                this.mResurrectToPosition = this.mNextSelectedPosition;
            }
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectedTop = 0;
            this.mSelectorShowing = false;
        }
    }

    public int reconcileSelectedPosition() {
        int position = this.mSelectedPosition;
        if (position < 0) {
            position = this.mResurrectToPosition;
        }
        position = Math.max(0, position);
        position = Math.min(position, this.mItemCount - 1);
        return position;
    }

    public abstract int findMotionRow(int var1);

    public int findClosestMotionRow(int y) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return -1;
        }
        int motionRow = this.findMotionRow(y);
        return motionRow != -1 ? motionRow : this.mFirstPosition + childCount - 1;
    }

    public void invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    public boolean resurrectSelectionIfNeeded() {
        if (this.mSelectedPosition < 0) {
            return this.resurrectSelection();
        }
        return false;
    }

    public abstract void setSelectionInt(int var1);

    public boolean resurrectSelection() {
        int selectedPos;
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return false;
        }
        int selectedTop = 0;
        int childrenTop = this.mListPadding.top;
        int childrenBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
        int firstPosition = this.mFirstPosition;
        int toPosition = this.mResurrectToPosition;
        boolean down = true;
        if (toPosition >= firstPosition && toPosition < firstPosition + childCount) {
            selectedPos = toPosition;
            View selected = this.getChildAt(selectedPos - this.mFirstPosition);
            selectedTop = selected.getTop();
            int selectedBottom = selected.getBottom();
            if (selectedTop < childrenTop) {
                selectedTop = childrenTop + this.getVerticalFadingEdgeLength();
            } else if (selectedBottom > childrenBottom) {
                selectedTop = childrenBottom - selected.getMeasuredHeight() - this.getVerticalFadingEdgeLength();
            }
        } else if (toPosition < firstPosition) {
            selectedPos = firstPosition;
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                if (i == 0) {
                    selectedTop = top;
                    if (firstPosition > 0 || top < childrenTop) {
                        childrenTop += this.getVerticalFadingEdgeLength();
                    }
                }
                if (top < childrenTop) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        } else {
            int itemCount = this.mItemCount;
            down = false;
            selectedPos = firstPosition + childCount - 1;
            for (int i = childCount - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                int top = v.getTop();
                int bottom = v.getBottom();
                if (i == childCount - 1) {
                    selectedTop = top;
                    if (firstPosition + childCount < itemCount || bottom > childrenBottom) {
                        childrenBottom -= this.getVerticalFadingEdgeLength();
                    }
                }
                if (bottom > childrenBottom) continue;
                selectedPos = firstPosition + i;
                selectedTop = top;
                break;
            }
        }
        this.mResurrectToPosition = -1;
        this.removeCallbacks(this.mFlingRunnable);
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.mTouchMode = -1;
        this.clearScrollingCache();
        this.mSpecificTop = selectedTop;
        selectedPos = this.lookForSelectablePosition(selectedPos, down);
        if (selectedPos >= firstPosition && selectedPos <= this.getLastVisiblePosition()) {
            this.mLayoutMode = 4;
            this.setSelectionInt(selectedPos);
            this.invokeOnItemScrollListener();
        } else {
            selectedPos = -1;
        }
        this.reportScrollStateChange(0);
        return selectedPos >= 0;
    }

    @Override
    public void handleDataChanged() {
        int count = this.mItemCount;
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                if (this.mTranscriptMode == 2) {
                    this.mLayoutMode = 3;
                    return;
                }
                if (this.mTranscriptMode == 1) {
                    int lastBottom;
                    if (this.mForceTranscriptScroll) {
                        this.mForceTranscriptScroll = false;
                        this.mLayoutMode = 3;
                        return;
                    }
                    int childCount = this.getChildCount();
                    int listBottom = this.getBottom() - this.getPaddingBottom();
                    View lastChild = this.getChildAt(childCount - 1);
                    int n = lastBottom = lastChild != null ? lastChild.getBottom() : listBottom;
                    if (this.mFirstPosition + childCount >= this.mOldItemCount && lastBottom <= listBottom) {
                        this.mLayoutMode = 3;
                        return;
                    }
                    this.awakenScrollBars();
                }
                switch (this.mSyncMode) {
                    case 0: {
                        if (this.isInTouchMode()) {
                            this.mLayoutMode = 5;
                            this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                            return;
                        }
                        newPos = this.findSyncPosition();
                        if (newPos < 0 || (selectablePos = this.lookForSelectablePosition(newPos, true)) != newPos) break;
                        this.mSyncPosition = newPos;
                        this.mLayoutMode = this.mSyncHeight == (long)this.getHeight() ? 5 : 2;
                        this.setNextSelectedPositionInt(newPos);
                        return;
                    }
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), count - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
                selectablePos = this.lookForSelectablePosition(newPos, false);
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = this.mStackFromBottom ? 3 : 1;
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.mSelectorPosition = -1;
        this.checkSelectionChanged();
    }

    @Override
    public void onDisplayHint(int hint) {
        super.onDisplayHint(hint);
        switch (hint) {
            case 4: {
                if (this.mPopup == null || !this.mPopup.isShowing()) break;
                this.dismissPopup();
                break;
            }
            case 0: {
                if (!this.mFiltered || this.mPopup == null || this.mPopup.isShowing()) break;
                this.showPopup();
            }
        }
        this.mPopupHidden = hint == 4;
    }

    public void dismissPopup() {
        if (this.mPopup != null) {
            this.mPopup.dismiss();
        }
    }

    public void showPopup() {
        if (this.getWindowVisibility() == 0) {
            this.createTextFilter(true);
            this.positionPopup();
            this.checkFocus();
        }
    }

    public void positionPopup() {
        int screenHeight = this.getResources().getDisplayMetrics().heightPixels;
        int[] xy = new int[2];
        this.getLocationOnScreen(xy);
        int bottomGap = screenHeight - xy[1] - this.getHeight() + (int)(this.mDensityScale * 20.0f);
        if (!this.mPopup.isShowing()) {
            this.mPopup.showAtLocation(this, 81, xy[0], bottomGap);
        } else {
            this.mPopup.update(xy[0], bottomGap, -1, -1);
        }
    }

    public static int getDistance(Rect source, Rect dest, int direction) {
        int dY;
        int dX;
        int sY;
        int sX;
        switch (direction) {
            case 66: {
                sX = source.right;
                sY = source.top + source.height() / 2;
                dX = dest.left;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 130: {
                sX = source.left + source.width() / 2;
                sY = source.bottom;
                dX = dest.left + dest.width() / 2;
                dY = dest.top;
                break;
            }
            case 17: {
                sX = source.left;
                sY = source.top + source.height() / 2;
                dX = dest.right;
                dY = dest.top + dest.height() / 2;
                break;
            }
            case 33: {
                sX = source.left + source.width() / 2;
                sY = source.top;
                dX = dest.left + dest.width() / 2;
                dY = dest.bottom;
                break;
            }
            case 1: 
            case 2: {
                sX = source.right + source.width() / 2;
                sY = source.top + source.height() / 2;
                dX = dest.left + dest.width() / 2;
                dY = dest.top + dest.height() / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
            }
        }
        int deltaX = dX - sX;
        int deltaY = dY - sY;
        return deltaY * deltaY + deltaX * deltaX;
    }

    @Override
    public boolean isInFilterMode() {
        return this.mFiltered;
    }

    public boolean sendToTextFilter(int keyCode, int count, KeyEvent event) {
        if (!this.acceptFilter()) {
            return false;
        }
        boolean handled = false;
        boolean okToSend = true;
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: {
                okToSend = false;
                break;
            }
            case 4: {
                if (this.mFiltered && this.mPopup != null && this.mPopup.isShowing()) {
                    if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                        KeyEvent.DispatcherState state = this.getKeyDispatcherState();
                        if (state != null) {
                            state.startTracking(event, this);
                        }
                        handled = true;
                    } else if (event.getAction() == 1 && event.isTracking() && !event.isCanceled()) {
                        handled = true;
                        this.mTextFilter.setText("");
                    }
                }
                okToSend = false;
                break;
            }
            case 62: {
                okToSend = this.mFiltered;
            }
        }
        if (okToSend) {
            this.createTextFilter(true);
            KeyEvent forwardEvent = event;
            if (forwardEvent.getRepeatCount() > 0) {
                forwardEvent = KeyEvent.changeTimeRepeat(event, event.getEventTime(), 0);
            }
            int action = event.getAction();
            switch (action) {
                case 0: {
                    handled = this.mTextFilter.onKeyDown(keyCode, forwardEvent);
                    break;
                }
                case 1: {
                    handled = this.mTextFilter.onKeyUp(keyCode, forwardEvent);
                    break;
                }
                case 2: {
                    handled = this.mTextFilter.onKeyMultiple(keyCode, count, event);
                }
            }
        }
        return handled;
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (this.isTextFilterEnabled()) {
            this.createTextFilter(false);
            if (this.mPublicInputConnection == null) {
                this.mDefInputConnection = new BaseInputConnection(this, false);
                this.mPublicInputConnection = new InputConnectionWrapper(this.mTextFilter.onCreateInputConnection(outAttrs), true){

                    public boolean reportFullscreenMode(boolean enabled) {
                        return AbsListView.this.mDefInputConnection.reportFullscreenMode(enabled);
                    }

                    public boolean performEditorAction(int editorAction) {
                        if (editorAction == 6) {
                            InputMethodManager imm = (InputMethodManager)AbsListView.this.getContext().getSystemService("input_method");
                            if (imm != null) {
                                imm.hideSoftInputFromWindow(AbsListView.this.getWindowToken(), 0);
                            }
                            return true;
                        }
                        return false;
                    }

                    public boolean sendKeyEvent(KeyEvent event) {
                        return AbsListView.this.mDefInputConnection.sendKeyEvent(event);
                    }
                };
            }
            outAttrs.inputType = 177;
            outAttrs.imeOptions = 6;
            return this.mPublicInputConnection;
        }
        return null;
    }

    @Override
    public boolean checkInputConnectionProxy(View view) {
        return view == this.mTextFilter;
    }

    public void createTextFilter(boolean animateEntrance) {
        if (this.mPopup == null) {
            Context c = this.getContext();
            PopupWindow p = new PopupWindow(c);
            LayoutInflater layoutInflater = (LayoutInflater)c.getSystemService("layout_inflater");
            this.mTextFilter = (EditText)layoutInflater.inflate(17367192, null);
            this.mTextFilter.setRawInputType(177);
            this.mTextFilter.setImeOptions(0x10000000);
            this.mTextFilter.addTextChangedListener(this);
            p.setFocusable(false);
            p.setTouchable(false);
            p.setInputMethodMode(2);
            p.setContentView(this.mTextFilter);
            p.setWidth(-2);
            p.setHeight(-2);
            p.setBackgroundDrawable(null);
            this.mPopup = p;
            this.getViewTreeObserver().addOnGlobalLayoutListener(this);
            this.mGlobalLayoutListenerAddedFilter = true;
        }
        if (animateEntrance) {
            this.mPopup.setAnimationStyle(16974074);
        } else {
            this.mPopup.setAnimationStyle(16974075);
        }
    }

    public void clearTextFilter() {
        if (this.mFiltered) {
            this.mTextFilter.setText("");
            this.mFiltered = false;
            if (this.mPopup != null && this.mPopup.isShowing()) {
                this.dismissPopup();
            }
        }
    }

    public boolean hasTextFilter() {
        return this.mFiltered;
    }

    @Override
    public void onGlobalLayout() {
        if (this.isShown()) {
            if (this.mFiltered && this.mPopup != null && !this.mPopup.isShowing() && !this.mPopupHidden) {
                this.showPopup();
            }
        } else if (this.mPopup != null && this.mPopup.isShowing()) {
            this.dismissPopup();
        }
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mPopup != null && this.isTextFilterEnabled()) {
            int length = s.length();
            boolean showing = this.mPopup.isShowing();
            if (!showing && length > 0) {
                this.showPopup();
                this.mFiltered = true;
            } else if (showing && length == 0) {
                this.dismissPopup();
                this.mFiltered = false;
            }
            if (this.mAdapter instanceof Filterable) {
                Filter f = ((Filterable)((Object)this.mAdapter)).getFilter();
                if (f != null) {
                    f.filter(s, this);
                } else {
                    throw new IllegalStateException("You cannot call onTextChanged with a non filterable adapter");
                }
            }
        }
    }

    @Override
    public void afterTextChanged(Editable s) {
    }

    @Override
    public void onFilterComplete(int count) {
        if (this.mSelectedPosition < 0 && count > 0) {
            this.mResurrectToPosition = -1;
            this.resurrectSelection();
        }
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    public boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void setTranscriptMode(int mode) {
        this.mTranscriptMode = mode;
    }

    public int getTranscriptMode() {
        return this.mTranscriptMode;
    }

    @Override
    public int getSolidColor() {
        return this.mCacheColorHint;
    }

    public void setCacheColorHint(int color2) {
        if (color2 != this.mCacheColorHint) {
            this.mCacheColorHint = color2;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(color2);
            }
            this.mRecycler.setCacheColorHint(color2);
        }
    }

    public int getCacheColorHint() {
        return this.mCacheColorHint;
    }

    public void reclaimViews(List<View> views) {
        int childCount = this.getChildCount();
        RecyclerListener listener = this.mRecycler.mRecyclerListener;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp == null || !this.mRecycler.shouldRecycleViewType(lp.viewType)) continue;
            views.add(child);
            if (listener == null) continue;
            listener.onMovedToScrapHeap(child);
        }
        this.mRecycler.reclaimScrapViews(views);
        this.removeAllViewsInLayout();
    }

    @Override
    public boolean onConsistencyCheck(int consistency) {
        boolean checkLayout;
        boolean result = super.onConsistencyCheck(consistency);
        boolean bl = checkLayout = (consistency & 1) != 0;
        if (checkLayout) {
            View[] activeViews = this.mRecycler.mActiveViews;
            int count = activeViews.length;
            for (int i = 0; i < count; ++i) {
                if (activeViews[i] == null) continue;
                result = false;
                Log.d("ViewConsistency", "AbsListView " + this + " has a view in its active recycler: " + activeViews[i]);
            }
            ArrayList scrap = this.mRecycler.mCurrentScrap;
            if (!this.checkScrap(scrap)) {
                result = false;
            }
            ArrayList[] scraps = this.mRecycler.mScrapViews;
            count = scraps.length;
            for (int i = 0; i < count; ++i) {
                if (this.checkScrap(scraps[i])) continue;
                result = false;
            }
        }
        return result;
    }

    public boolean checkScrap(ArrayList<View> scrap) {
        if (scrap == null) {
            return true;
        }
        boolean result = true;
        int count = scrap.size();
        for (int i = 0; i < count; ++i) {
            View view = scrap.get(i);
            if (view.getParent() != null) {
                result = false;
                Log.d("ViewConsistency", "AbsListView " + this + " has a view in its scrap heap still attached to a parent: " + view);
            }
            if (this.indexOfChild(view) < 0) continue;
            result = false;
            Log.d("ViewConsistency", "AbsListView " + this + " has a view in its scrap heap that is also a direct child: " + view);
        }
        return result;
    }

    public void finishGlows() {
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.finish();
            this.mEdgeGlowBottom.finish();
        }
    }

    public void setRemoteViewsAdapter(Intent intent) {
        Intent.FilterComparison fcOld;
        Intent.FilterComparison fcNew;
        if (this.mRemoteAdapter != null && (fcNew = new Intent.FilterComparison(intent)).equals(fcOld = new Intent.FilterComparison(this.mRemoteAdapter.getRemoteViewsServiceIntent()))) {
            return;
        }
        this.mRemoteAdapter = new RemoteViewsAdapter(this.getContext(), intent, this);
    }

    @Override
    public boolean onRemoteAdapterConnected() {
        if (this.mRemoteAdapter != this.mAdapter) {
            this.setAdapter(this.mRemoteAdapter);
            return false;
        }
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.superNotifyDataSetChanged();
            return true;
        }
        return false;
    }

    @Override
    public void onRemoteAdapterDisconnected() {
    }

    public void setRecyclerListener(RecyclerListener listener) {
        this.mRecycler.mRecyclerListener = listener;
    }

    public static View retrieveFromScrap(ArrayList<View> scrapViews, int position) {
        int size = scrapViews.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                View view = scrapViews.get(i);
                if (((LayoutParams)view.getLayoutParams()).scrappedFromPosition != position) continue;
                scrapViews.remove(i);
                return view;
            }
            return scrapViews.remove(size - 1);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RecycleBin {
        public RecyclerListener mRecyclerListener;
        public int mFirstActivePosition;
        public View[] mActiveViews = new View[0];
        public ArrayList<View>[] mScrapViews;
        public int mViewTypeCount;
        public ArrayList<View> mCurrentScrap;

        public void setViewTypeCount(int viewTypeCount) {
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] scrapViews = new ArrayList[viewTypeCount];
            for (int i = 0; i < viewTypeCount; ++i) {
                scrapViews[i] = new ArrayList();
            }
            this.mViewTypeCount = viewTypeCount;
            this.mCurrentScrap = scrapViews[0];
            this.mScrapViews = scrapViews;
        }

        public void markChildrenDirty() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i = 0; i < scrapCount; ++i) {
                    scrap.get(i).forceLayout();
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).forceLayout();
                    }
                }
            }
        }

        public boolean shouldRecycleViewType(int viewType) {
            return viewType >= 0;
        }

        public void clear() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i = 0; i < scrapCount; ++i) {
                    AbsListView.this.removeDetachedView(scrap.remove(scrapCount - 1 - i), false);
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        AbsListView.this.removeDetachedView(scrap.remove(scrapCount - 1 - j), false);
                    }
                }
            }
        }

        public void fillActiveViews(int childCount, int firstActivePosition) {
            if (this.mActiveViews.length < childCount) {
                this.mActiveViews = new View[childCount];
            }
            this.mFirstActivePosition = firstActivePosition;
            View[] activeViews = this.mActiveViews;
            for (int i = 0; i < childCount; ++i) {
                View child = AbsListView.this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp == null || lp.viewType == -2) continue;
                activeViews[i] = child;
            }
        }

        public View getActiveView(int position) {
            int index = position - this.mFirstActivePosition;
            View[] activeViews = this.mActiveViews;
            if (index >= 0 && index < activeViews.length) {
                View match = activeViews[index];
                activeViews[index] = null;
                return match;
            }
            return null;
        }

        public View getScrapView(int position) {
            if (this.mViewTypeCount == 1) {
                return AbsListView.retrieveFromScrap(this.mCurrentScrap, position);
            }
            int whichScrap = AbsListView.this.mAdapter.getItemViewType(position);
            if (whichScrap >= 0 && whichScrap < this.mScrapViews.length) {
                return AbsListView.retrieveFromScrap(this.mScrapViews[whichScrap], position);
            }
            return null;
        }

        public void addScrapView(View scrap, int position) {
            LayoutParams lp = (LayoutParams)scrap.getLayoutParams();
            if (lp == null) {
                return;
            }
            int viewType = lp.viewType;
            if (!this.shouldRecycleViewType(viewType)) {
                if (viewType != -2) {
                    AbsListView.this.removeDetachedView(scrap, false);
                }
                return;
            }
            lp.scrappedFromPosition = position;
            if (this.mViewTypeCount == 1) {
                scrap.dispatchStartTemporaryDetach();
                this.mCurrentScrap.add(scrap);
            } else {
                scrap.dispatchStartTemporaryDetach();
                this.mScrapViews[viewType].add(scrap);
            }
            if (this.mRecyclerListener != null) {
                this.mRecyclerListener.onMovedToScrapHeap(scrap);
            }
        }

        public void scrapActiveViews() {
            View[] activeViews = this.mActiveViews;
            boolean hasListener = this.mRecyclerListener != null;
            boolean multipleScraps = this.mViewTypeCount > 1;
            ArrayList<View> scrapViews = this.mCurrentScrap;
            int count = activeViews.length;
            for (int i = count - 1; i >= 0; --i) {
                View victim = activeViews[i];
                if (victim == null) continue;
                LayoutParams lp = (LayoutParams)victim.getLayoutParams();
                int whichScrap = lp.viewType;
                activeViews[i] = null;
                if (!this.shouldRecycleViewType(whichScrap)) {
                    if (whichScrap == -2) continue;
                    AbsListView.this.removeDetachedView(victim, false);
                    continue;
                }
                if (multipleScraps) {
                    scrapViews = this.mScrapViews[whichScrap];
                }
                victim.dispatchStartTemporaryDetach();
                lp.scrappedFromPosition = this.mFirstActivePosition + i;
                scrapViews.add(victim);
                if (!hasListener) continue;
                this.mRecyclerListener.onMovedToScrapHeap(victim);
            }
            this.pruneScrapViews();
        }

        public void pruneScrapViews() {
            int maxViews = this.mActiveViews.length;
            int viewTypeCount = this.mViewTypeCount;
            ArrayList<View>[] scrapViews = this.mScrapViews;
            for (int i = 0; i < viewTypeCount; ++i) {
                ArrayList<View> scrapPile = scrapViews[i];
                int size = scrapPile.size();
                int extras = size - maxViews;
                --size;
                for (int j = 0; j < extras; ++j) {
                    AbsListView.this.removeDetachedView(scrapPile.remove(size--), false);
                }
            }
        }

        public void reclaimScrapViews(List<View> views) {
            if (this.mViewTypeCount == 1) {
                views.addAll(this.mCurrentScrap);
            } else {
                int viewTypeCount = this.mViewTypeCount;
                ArrayList<View>[] scrapViews = this.mScrapViews;
                for (int i = 0; i < viewTypeCount; ++i) {
                    ArrayList<View> scrapPile = scrapViews[i];
                    views.addAll(scrapPile);
                }
            }
        }

        public void setCacheColorHint(int color2) {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> scrap = this.mCurrentScrap;
                int scrapCount = scrap.size();
                for (int i = 0; i < scrapCount; ++i) {
                    scrap.get(i).setDrawingCacheBackgroundColor(color2);
                }
            } else {
                int typeCount = this.mViewTypeCount;
                for (int i = 0; i < typeCount; ++i) {
                    ArrayList<View> scrap = this.mScrapViews[i];
                    int scrapCount = scrap.size();
                    for (int j = 0; j < scrapCount; ++j) {
                        scrap.get(j).setDrawingCacheBackgroundColor(color2);
                    }
                }
            }
            for (View victim : this.mActiveViews) {
                if (victim == null) continue;
                victim.setDrawingCacheBackgroundColor(color2);
            }
        }
    }

    public static interface RecyclerListener {
        public void onMovedToScrapHeap(View var1);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        @ViewDebug.ExportedProperty(category="list", mapping={@ViewDebug.IntToString(from=-1, to="ITEM_VIEW_TYPE_IGNORE"), @ViewDebug.IntToString(from=-2, to="ITEM_VIEW_TYPE_HEADER_OR_FOOTER")})
        public int viewType;
        @ViewDebug.ExportedProperty(category="list")
        public boolean recycledHeaderFooter;
        @ViewDebug.ExportedProperty(category="list")
        public boolean forceAdd;
        public int scrappedFromPosition;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, int viewType) {
            super(w, h);
            this.viewType = viewType;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public class MultiChoiceModeWrapper
    implements MultiChoiceModeListener {
        public MultiChoiceModeListener mWrapped;

        public void setWrapped(MultiChoiceModeListener wrapped) {
            this.mWrapped = wrapped;
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            if (this.mWrapped.onCreateActionMode(mode, menu2)) {
                AbsListView.this.setLongClickable(false);
                return true;
            }
            return false;
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            return this.mWrapped.onPrepareActionMode(mode, menu2);
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            AbsListView.this.mChoiceActionMode = null;
            AbsListView.this.clearChoices();
            AbsListView.this.mDataChanged = true;
            AbsListView.this.rememberSyncState();
            AbsListView.this.requestLayout();
            AbsListView.this.setLongClickable(true);
        }

        public void onItemCheckedStateChanged(ActionMode mode, int position, long id2, boolean checked) {
            this.mWrapped.onItemCheckedStateChanged(mode, position, id2, checked);
            if (AbsListView.this.getCheckedItemCount() == 0) {
                mode.finish();
            }
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback {
        public void onItemCheckedStateChanged(ActionMode var1, int var2, long var3, boolean var5);
    }

    public class AdapterDataSetObserver
    extends AdapterView.AdapterDataSetObserver {
        public void onChanged() {
            super.onChanged();
            if (AbsListView.this.mFastScroller != null) {
                AbsListView.this.mFastScroller.onSectionsChanged();
            }
        }

        public void onInvalidated() {
            super.onInvalidated();
            if (AbsListView.this.mFastScroller != null) {
                AbsListView.this.mFastScroller.onSectionsChanged();
            }
        }
    }

    public class PositionScroller
    implements Runnable {
        public static final int SCROLL_DURATION = 400;
        public static final int MOVE_DOWN_POS = 1;
        public static final int MOVE_UP_POS = 2;
        public static final int MOVE_DOWN_BOUND = 3;
        public static final int MOVE_UP_BOUND = 4;
        public static final int MOVE_OFFSET = 5;
        public int mMode;
        public int mTargetPos;
        public int mBoundPos;
        public int mLastSeenPos;
        public int mScrollDuration;
        public final int mExtraScroll;
        public int mOffsetFromTop;

        public PositionScroller() {
            this.mExtraScroll = ViewConfiguration.get(AbsListView.this.mContext).getScaledFadingEdgeLength();
        }

        public void start(int position) {
            int viewTravelCount;
            this.stop();
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + AbsListView.this.getChildCount() - 1;
            if (position <= firstPos) {
                viewTravelCount = firstPos - position + 1;
                this.mMode = 2;
            } else if (position >= lastPos) {
                viewTravelCount = position - lastPos + 1;
                this.mMode = 1;
            } else {
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 400 / viewTravelCount : 400;
            this.mTargetPos = position;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            AbsListView.this.post(this);
        }

        public void start(int position, int boundPosition) {
            int viewTravelCount;
            this.stop();
            if (boundPosition == -1) {
                this.start(position);
                return;
            }
            int firstPos = AbsListView.this.mFirstPosition;
            int lastPos = firstPos + AbsListView.this.getChildCount() - 1;
            if (position <= firstPos) {
                int boundPosFromLast = lastPos - boundPosition;
                if (boundPosFromLast < 1) {
                    return;
                }
                int boundTravel = boundPosFromLast - 1;
                int posTravel = firstPos - position + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 4;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 2;
                }
            } else if (position >= lastPos) {
                int boundPosFromFirst = boundPosition - firstPos;
                if (boundPosFromFirst < 1) {
                    return;
                }
                int boundTravel = boundPosFromFirst - 1;
                int posTravel = position - lastPos + 1;
                if (boundTravel < posTravel) {
                    viewTravelCount = boundTravel;
                    this.mMode = 3;
                } else {
                    viewTravelCount = posTravel;
                    this.mMode = 1;
                }
            } else {
                return;
            }
            this.mScrollDuration = viewTravelCount > 0 ? 400 / viewTravelCount : 400;
            this.mTargetPos = position;
            this.mBoundPos = boundPosition;
            this.mLastSeenPos = -1;
            AbsListView.this.post(this);
        }

        public void startWithOffset(int position, int offset) {
            this.startWithOffset(position, offset, 400);
        }

        public void startWithOffset(int position, int offset, int duration) {
            int viewTravelCount;
            this.stop();
            this.mTargetPos = position;
            this.mOffsetFromTop = offset;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            this.mMode = 5;
            int firstPos = AbsListView.this.mFirstPosition;
            int childCount = AbsListView.this.getChildCount();
            int lastPos = firstPos + childCount - 1;
            if (position < firstPos) {
                viewTravelCount = firstPos - position;
            } else if (position > lastPos) {
                viewTravelCount = position - lastPos;
            } else {
                int targetTop = AbsListView.this.getChildAt(position - firstPos).getTop();
                AbsListView.this.smoothScrollBy(targetTop - offset, duration);
                return;
            }
            float screenTravelCount = (float)viewTravelCount / (float)childCount;
            this.mScrollDuration = screenTravelCount < 1.0f ? (int)(screenTravelCount * (float)duration) : (int)((float)duration / screenTravelCount);
            this.mLastSeenPos = -1;
            AbsListView.this.post(this);
        }

        public void stop() {
            AbsListView.this.removeCallbacks(this);
        }

        public void run() {
            if (AbsListView.this.mTouchMode != 4 && this.mLastSeenPos != -1) {
                return;
            }
            int listHeight = AbsListView.this.getHeight();
            int firstPos = AbsListView.this.mFirstPosition;
            switch (this.mMode) {
                case 1: {
                    int lastViewIndex = AbsListView.this.getChildCount() - 1;
                    int lastPos = firstPos + lastViewIndex;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    if (lastPos == this.mLastSeenPos) {
                        AbsListView.this.post(this);
                        return;
                    }
                    View lastView = AbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    int extraScroll = lastPos < AbsListView.this.mItemCount - 1 ? this.mExtraScroll : AbsListView.this.mListPadding.bottom;
                    AbsListView.this.smoothScrollBy(lastViewHeight - lastViewPixelsShowing + extraScroll, this.mScrollDuration);
                    this.mLastSeenPos = lastPos;
                    if (lastPos >= this.mTargetPos) break;
                    AbsListView.this.post(this);
                    break;
                }
                case 3: {
                    boolean nextViewIndex = true;
                    int childCount = AbsListView.this.getChildCount();
                    if (firstPos == this.mBoundPos || childCount <= 1 || firstPos + childCount >= AbsListView.this.mItemCount) {
                        return;
                    }
                    int nextPos = firstPos + 1;
                    if (nextPos == this.mLastSeenPos) {
                        AbsListView.this.post(this);
                        return;
                    }
                    View nextView = AbsListView.this.getChildAt(1);
                    int nextViewHeight = nextView.getHeight();
                    int nextViewTop = nextView.getTop();
                    int extraScroll = this.mExtraScroll;
                    if (nextPos < this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(Math.max(0, nextViewHeight + nextViewTop - extraScroll), this.mScrollDuration);
                        this.mLastSeenPos = nextPos;
                        AbsListView.this.post(this);
                        break;
                    }
                    if (nextViewTop <= extraScroll) break;
                    AbsListView.this.smoothScrollBy(nextViewTop - extraScroll, this.mScrollDuration);
                    break;
                }
                case 2: {
                    if (firstPos == this.mLastSeenPos) {
                        AbsListView.this.post(this);
                        return;
                    }
                    View firstView = AbsListView.this.getChildAt(0);
                    if (firstView == null) {
                        return;
                    }
                    int firstViewTop = firstView.getTop();
                    int extraScroll = firstPos > 0 ? this.mExtraScroll : AbsListView.this.mListPadding.top;
                    AbsListView.this.smoothScrollBy(firstViewTop - extraScroll, this.mScrollDuration);
                    this.mLastSeenPos = firstPos;
                    if (firstPos <= this.mTargetPos) break;
                    AbsListView.this.post(this);
                    break;
                }
                case 4: {
                    int lastViewIndex = AbsListView.this.getChildCount() - 2;
                    if (lastViewIndex < 0) {
                        return;
                    }
                    int lastPos = firstPos + lastViewIndex;
                    if (lastPos == this.mLastSeenPos) {
                        AbsListView.this.post(this);
                        return;
                    }
                    View lastView = AbsListView.this.getChildAt(lastViewIndex);
                    int lastViewHeight = lastView.getHeight();
                    int lastViewTop = lastView.getTop();
                    int lastViewPixelsShowing = listHeight - lastViewTop;
                    this.mLastSeenPos = lastPos;
                    if (lastPos > this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(-(lastViewPixelsShowing - this.mExtraScroll), this.mScrollDuration);
                        AbsListView.this.post(this);
                        break;
                    }
                    int bottom = listHeight - this.mExtraScroll;
                    int lastViewBottom = lastViewTop + lastViewHeight;
                    if (bottom <= lastViewBottom) break;
                    AbsListView.this.smoothScrollBy(-(bottom - lastViewBottom), this.mScrollDuration);
                    break;
                }
                case 5: {
                    if (this.mLastSeenPos == firstPos) {
                        AbsListView.this.post(this);
                        return;
                    }
                    this.mLastSeenPos = firstPos;
                    int childCount = AbsListView.this.getChildCount();
                    int position = this.mTargetPos;
                    int lastPos = firstPos + childCount - 1;
                    int viewTravelCount = 0;
                    if (position < firstPos) {
                        viewTravelCount = firstPos - position + 1;
                    } else if (position > lastPos) {
                        viewTravelCount = position - lastPos;
                    }
                    float screenTravelCount = (float)viewTravelCount / (float)childCount;
                    float modifier = Math.min(Math.abs(screenTravelCount), 1.0f);
                    if (position < firstPos) {
                        AbsListView.this.smoothScrollBy((int)((float)(-AbsListView.this.getHeight()) * modifier), this.mScrollDuration);
                        AbsListView.this.post(this);
                        break;
                    }
                    if (position > lastPos) {
                        AbsListView.this.smoothScrollBy((int)((float)AbsListView.this.getHeight() * modifier), this.mScrollDuration);
                        AbsListView.this.post(this);
                        break;
                    }
                    int targetTop = AbsListView.this.getChildAt(position - firstPos).getTop();
                    int distance = targetTop - this.mOffsetFromTop;
                    AbsListView.this.smoothScrollBy(distance, (int)((float)this.mScrollDuration * ((float)distance / (float)AbsListView.this.getHeight())));
                    break;
                }
            }
        }
    }

    public class FlingRunnable
    implements Runnable {
        public final OverScroller mScroller;
        public int mLastFlingY;
        public final Runnable mCheckFlywheel = new Runnable(){

            public void run() {
                int activeId = AbsListView.this.mActivePointerId;
                VelocityTracker vt = AbsListView.this.mVelocityTracker;
                OverScroller scroller = FlingRunnable.this.mScroller;
                if (vt == null || activeId == -1) {
                    return;
                }
                vt.computeCurrentVelocity(1000, AbsListView.this.mMaximumVelocity);
                float yvel = -vt.getYVelocity(activeId);
                if (scroller.isScrollingInDirection(0.0f, yvel)) {
                    AbsListView.this.postDelayed(this, 40L);
                } else {
                    FlingRunnable.this.endFling();
                    AbsListView.this.mTouchMode = 3;
                    AbsListView.this.reportScrollStateChange(1);
                }
            }
        };
        public static final int FLYWHEEL_TIMEOUT = 40;

        public FlingRunnable() {
            this.mScroller = new OverScroller(AbsListView.this.getContext());
        }

        public void start(int initialVelocity) {
            int initialY;
            this.mLastFlingY = initialY = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.fling(0, initialY, 0, initialVelocity, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            AbsListView.this.mTouchMode = 4;
            AbsListView.this.post(this);
            if (AbsListView.this.mFlingStrictSpan == null) {
                AbsListView.this.mFlingStrictSpan = StrictMode.enterCriticalSpan("AbsListView-fling");
            }
        }

        public void startSpringback() {
            if (this.mScroller.springBack(0, AbsListView.this.mScrollY, 0, 0, 0, 0)) {
                AbsListView.this.mTouchMode = 6;
                AbsListView.this.invalidate();
                AbsListView.this.post(this);
            } else {
                AbsListView.this.mTouchMode = -1;
            }
        }

        public void startOverfling(int initialVelocity) {
            int min = AbsListView.this.mScrollY > 0 ? Integer.MIN_VALUE : 0;
            int max = AbsListView.this.mScrollY > 0 ? 0 : Integer.MAX_VALUE;
            this.mScroller.fling(0, AbsListView.this.mScrollY, 0, initialVelocity, 0, 0, min, max, 0, AbsListView.this.getHeight());
            AbsListView.this.mTouchMode = 6;
            AbsListView.this.invalidate();
            AbsListView.this.post(this);
        }

        public void edgeReached(int delta) {
            this.mScroller.notifyVerticalEdgeReached(AbsListView.this.mScrollY, 0, AbsListView.this.mOverflingDistance);
            int overscrollMode = AbsListView.this.getOverScrollMode();
            if (overscrollMode == 0 || overscrollMode == 1 && !AbsListView.this.contentFits()) {
                AbsListView.this.mTouchMode = 6;
                int vel = (int)this.mScroller.getCurrVelocity();
                if (delta > 0) {
                    AbsListView.this.mEdgeGlowTop.onAbsorb(vel);
                } else {
                    AbsListView.this.mEdgeGlowBottom.onAbsorb(vel);
                }
            } else {
                AbsListView.this.mTouchMode = -1;
                if (AbsListView.this.mPositionScroller != null) {
                    AbsListView.this.mPositionScroller.stop();
                }
            }
            AbsListView.this.invalidate();
            AbsListView.this.post(this);
        }

        public void startScroll(int distance, int duration) {
            int initialY;
            this.mLastFlingY = initialY = distance < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.startScroll(0, initialY, 0, distance, duration);
            AbsListView.this.mTouchMode = 4;
            AbsListView.this.post(this);
        }

        public void endFling() {
            AbsListView.this.mTouchMode = -1;
            AbsListView.this.removeCallbacks(this);
            AbsListView.this.removeCallbacks(this.mCheckFlywheel);
            AbsListView.this.reportScrollStateChange(0);
            AbsListView.this.clearScrollingCache();
            this.mScroller.abortAnimation();
            if (AbsListView.this.mFlingStrictSpan != null) {
                AbsListView.this.mFlingStrictSpan.finish();
                AbsListView.this.mFlingStrictSpan = null;
            }
        }

        public void flywheelTouch() {
            AbsListView.this.postDelayed(this.mCheckFlywheel, 40L);
        }

        public void run() {
            switch (AbsListView.this.mTouchMode) {
                default: {
                    this.endFling();
                    return;
                }
                case 3: {
                    if (this.mScroller.isFinished()) {
                        return;
                    }
                }
                case 4: {
                    boolean atEnd;
                    if (AbsListView.this.mItemCount == 0 || AbsListView.this.getChildCount() == 0) {
                        this.endFling();
                        return;
                    }
                    OverScroller scroller = this.mScroller;
                    boolean more = scroller.computeScrollOffset();
                    int y = scroller.getCurrY();
                    int delta = this.mLastFlingY - y;
                    if (delta > 0) {
                        AbsListView.this.mMotionPosition = AbsListView.this.mFirstPosition;
                        View firstView = AbsListView.this.getChildAt(0);
                        AbsListView.this.mMotionViewOriginalTop = firstView.getTop();
                        delta = Math.min(AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop - 1, delta);
                    } else {
                        int offsetToLast = AbsListView.this.getChildCount() - 1;
                        AbsListView.this.mMotionPosition = AbsListView.this.mFirstPosition + offsetToLast;
                        View lastView = AbsListView.this.getChildAt(offsetToLast);
                        AbsListView.this.mMotionViewOriginalTop = lastView.getTop();
                        delta = Math.max(-(AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop - 1), delta);
                    }
                    View motionView = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                    int oldTop = 0;
                    if (motionView != null) {
                        oldTop = motionView.getTop();
                    }
                    boolean bl = atEnd = AbsListView.this.trackMotionScroll(delta, delta) && delta != 0;
                    if (atEnd) {
                        if (motionView != null) {
                            int overshoot = -(delta - (motionView.getTop() - oldTop));
                            AbsListView.this.overScrollBy(0, overshoot, 0, AbsListView.this.mScrollY, 0, 0, 0, AbsListView.this.mOverflingDistance, false);
                        }
                        if (!more) break;
                        this.edgeReached(delta);
                        break;
                    }
                    if (more && !atEnd) {
                        AbsListView.this.invalidate();
                        this.mLastFlingY = y;
                        AbsListView.this.post(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
                case 6: {
                    OverScroller scroller = this.mScroller;
                    if (scroller.computeScrollOffset()) {
                        int scrollY = AbsListView.this.mScrollY;
                        int deltaY = scroller.getCurrY() - scrollY;
                        if (AbsListView.this.overScrollBy(0, deltaY, 0, scrollY, 0, 0, 0, AbsListView.this.mOverflingDistance, false)) {
                            this.startSpringback();
                            break;
                        }
                        AbsListView.this.invalidate();
                        AbsListView.this.post(this);
                        break;
                    }
                    this.endFling();
                    break;
                }
            }
        }
    }

    public class CheckForTap
    implements Runnable {
        public void run() {
            if (AbsListView.this.mTouchMode == 0) {
                AbsListView.this.mTouchMode = 1;
                View child = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                if (child != null && !child.hasFocusable()) {
                    AbsListView.this.mLayoutMode = 0;
                    if (!AbsListView.this.mDataChanged) {
                        Drawable d;
                        child.setPressed(true);
                        AbsListView.this.setPressed(true);
                        AbsListView.this.layoutChildren();
                        AbsListView.this.positionSelector(AbsListView.this.mMotionPosition, child);
                        AbsListView.this.refreshDrawableState();
                        int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                        boolean longClickable = AbsListView.this.isLongClickable();
                        if (AbsListView.this.mSelector != null && (d = AbsListView.this.mSelector.getCurrent()) != null && d instanceof TransitionDrawable) {
                            if (longClickable) {
                                ((TransitionDrawable)d).startTransition(longPressTimeout);
                            } else {
                                ((TransitionDrawable)d).resetTransition();
                            }
                        }
                        if (longClickable) {
                            if (AbsListView.this.mPendingCheckForLongPress == null) {
                                AbsListView.this.mPendingCheckForLongPress = new CheckForLongPress(null);
                            }
                            AbsListView.this.mPendingCheckForLongPress.rememberWindowAttachCount();
                            AbsListView.this.postDelayed(AbsListView.this.mPendingCheckForLongPress, longPressTimeout);
                        } else {
                            AbsListView.this.mTouchMode = 2;
                        }
                    } else {
                        AbsListView.this.mTouchMode = 2;
                    }
                }
            }
        }
    }

    public class CheckForKeyLongPress
    extends WindowRunnnable
    implements Runnable {
        public CheckForKeyLongPress() {
            super(null);
        }

        public void run() {
            if (AbsListView.this.isPressed() && AbsListView.this.mSelectedPosition >= 0) {
                int index = AbsListView.this.mSelectedPosition - AbsListView.this.mFirstPosition;
                View v = AbsListView.this.getChildAt(index);
                if (!AbsListView.this.mDataChanged) {
                    boolean handled = false;
                    if (this.sameWindow()) {
                        handled = AbsListView.this.performLongPress(v, AbsListView.this.mSelectedPosition, AbsListView.this.mSelectedRowId);
                    }
                    if (handled) {
                        AbsListView.this.setPressed(false);
                        v.setPressed(false);
                    }
                } else {
                    AbsListView.this.setPressed(false);
                    if (v != null) {
                        v.setPressed(false);
                    }
                }
            }
        }

        public /* synthetic */ CheckForKeyLongPress(1 x1) {
            this();
        }
    }

    public class CheckForLongPress
    extends WindowRunnnable
    implements Runnable {
        public CheckForLongPress() {
            super(null);
        }

        public void run() {
            int motionPosition = AbsListView.this.mMotionPosition;
            View child = AbsListView.this.getChildAt(motionPosition - AbsListView.this.mFirstPosition);
            if (child != null) {
                int longPressPosition = AbsListView.this.mMotionPosition;
                long longPressId = AbsListView.this.mAdapter.getItemId(AbsListView.this.mMotionPosition);
                boolean handled = false;
                if (this.sameWindow() && !AbsListView.this.mDataChanged) {
                    handled = AbsListView.this.performLongPress(child, longPressPosition, longPressId);
                }
                if (handled) {
                    AbsListView.this.mTouchMode = -1;
                    AbsListView.this.setPressed(false);
                    child.setPressed(false);
                } else {
                    AbsListView.this.mTouchMode = 2;
                }
            }
        }

        public /* synthetic */ CheckForLongPress(1 x1) {
            this();
        }
    }

    public class PerformClick
    extends WindowRunnnable
    implements Runnable {
        public int mClickMotionPosition;

        public PerformClick() {
            super(null);
        }

        public void run() {
            View view;
            if (AbsListView.this.mDataChanged) {
                return;
            }
            ListAdapter adapter = AbsListView.this.mAdapter;
            int motionPosition = this.mClickMotionPosition;
            if (adapter != null && AbsListView.this.mItemCount > 0 && motionPosition != -1 && motionPosition < adapter.getCount() && this.sameWindow() && (view = AbsListView.this.getChildAt(motionPosition - AbsListView.this.mFirstPosition)) != null) {
                AbsListView.this.performItemClick(view, motionPosition, adapter.getItemId(motionPosition));
            }
        }

        public /* synthetic */ PerformClick(1 x1) {
            this();
        }
    }

    public class WindowRunnnable {
        public int mOriginalAttachCount;

        public WindowRunnnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = AbsListView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return AbsListView.this.hasWindowFocus() && AbsListView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }

        public /* synthetic */ WindowRunnnable(1 x1) {
            this();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public long selectedId;
        public long firstId;
        public int viewTop;
        public int position;
        public int height;
        public String filter;
        public boolean inActionMode;
        public int checkedItemCount;
        public SparseBooleanArray checkState;
        public LongSparseArray<Boolean> checkIdState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel in) {
            super(in);
            this.selectedId = in.readLong();
            this.firstId = in.readLong();
            this.viewTop = in.readInt();
            this.position = in.readInt();
            this.height = in.readInt();
            this.filter = in.readString();
            this.inActionMode = in.readByte() != 0;
            this.checkedItemCount = in.readInt();
            this.checkState = in.readSparseBooleanArray();
            long[] idState = in.createLongArray();
            if (idState.length > 0) {
                this.checkIdState = new LongSparseArray();
                this.checkIdState.setValues(idState, Boolean.TRUE);
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeLong(this.selectedId);
            out.writeLong(this.firstId);
            out.writeInt(this.viewTop);
            out.writeInt(this.position);
            out.writeInt(this.height);
            out.writeString(this.filter);
            out.writeByte((byte)(this.inActionMode ? 1 : 0));
            out.writeInt(this.checkedItemCount);
            out.writeSparseBooleanArray(this.checkState);
            out.writeLongArray(this.checkIdState != null ? this.checkIdState.getKeys() : new long[]{});
        }

        public String toString() {
            return "AbsListView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " selectedId=" + this.selectedId + " firstId=" + this.firstId + " viewTop=" + this.viewTop + " position=" + this.position + " height=" + this.height + " filter=" + this.filter + " checkState=" + this.checkState + "}";
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }
    }

    public static interface SelectionBoundsAdjuster {
        public void adjustListItemSelectionBounds(Rect var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(AbsListView var1, int var2);

        public void onScroll(AbsListView var1, int var2, int var3, int var4);
    }
}

