/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class EdgeGlow {
    public static final String TAG = "EdgeGlow";
    public static final int RECEDE_TIME = 1000;
    public static final int PULL_TIME = 167;
    public static final int PULL_DECAY_TIME = 1000;
    public static final float MAX_ALPHA = 0.8f;
    public static final float HELD_EDGE_ALPHA = 0.7f;
    public static final float HELD_EDGE_SCALE_Y = 0.5f;
    public static final float HELD_GLOW_ALPHA = 0.5f;
    public static final float HELD_GLOW_SCALE_Y = 0.5f;
    public static final float MAX_GLOW_HEIGHT = 4.0f;
    public static final float PULL_GLOW_BEGIN = 1.0f;
    public static final float PULL_EDGE_BEGIN = 0.6f;
    public static final int MIN_VELOCITY = 100;
    public static final float EPSILON = 0.001f;
    public final Drawable mEdge;
    public final Drawable mGlow;
    public int mWidth;
    public int mHeight;
    public final int MIN_WIDTH = 300;
    public final int mMinWidth;
    public float mEdgeAlpha;
    public float mEdgeScaleY;
    public float mGlowAlpha;
    public float mGlowScaleY;
    public float mEdgeAlphaStart;
    public float mEdgeAlphaFinish;
    public float mEdgeScaleYStart;
    public float mEdgeScaleYFinish;
    public float mGlowAlphaStart;
    public float mGlowAlphaFinish;
    public float mGlowScaleYStart;
    public float mGlowScaleYFinish;
    public long mStartTime;
    public float mDuration;
    public final Interpolator mInterpolator;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PULL = 1;
    public static final int STATE_ABSORB = 2;
    public static final int STATE_RECEDE = 3;
    public static final int STATE_PULL_DECAY = 4;
    public static final int PULL_DISTANCE_EDGE_FACTOR = 7;
    public static final int PULL_DISTANCE_GLOW_FACTOR = 7;
    public static final float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 1.1f;
    public static final int VELOCITY_EDGE_FACTOR = 8;
    public static final int VELOCITY_GLOW_FACTOR = 16;
    public int mState = 0;
    public float mPullDistance;

    public EdgeGlow(Context context, Drawable edge, Drawable glow) {
        this.mEdge = edge;
        this.mGlow = glow;
        this.mMinWidth = (int)(context.getResources().getDisplayMetrics().density * 300.0f + 0.5f);
        this.mInterpolator = new DecelerateInterpolator();
    }

    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public void finish() {
        this.mState = 0;
    }

    public void onPull(float deltaDistance) {
        long now = AnimationUtils.currentAnimationTimeMillis();
        if (this.mState == 4 && (float)(now - this.mStartTime) < this.mDuration) {
            return;
        }
        if (this.mState != 1) {
            this.mGlowScaleY = 1.0f;
        }
        this.mState = 1;
        this.mStartTime = now;
        this.mDuration = 167.0f;
        this.mPullDistance += deltaDistance;
        float distance = Math.abs(this.mPullDistance);
        this.mEdgeAlpha = this.mEdgeAlphaStart = Math.max(0.6f, Math.min(distance, 0.8f));
        this.mEdgeScaleY = this.mEdgeScaleYStart = Math.max(0.5f, Math.min(distance * 7.0f, 1.0f));
        this.mGlowAlpha = this.mGlowAlphaStart = Math.min(0.8f, this.mGlowAlpha + Math.abs(deltaDistance) * 1.1f);
        float glowChange = Math.abs(deltaDistance);
        if (deltaDistance > 0.0f && this.mPullDistance < 0.0f) {
            glowChange = -glowChange;
        }
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleY = 0.0f;
        }
        this.mGlowScaleY = this.mGlowScaleYStart = Math.min(4.0f, Math.max(0.0f, this.mGlowScaleY + glowChange * 7.0f));
        this.mEdgeAlphaFinish = this.mEdgeAlpha;
        this.mEdgeScaleYFinish = this.mEdgeScaleY;
        this.mGlowAlphaFinish = this.mGlowAlpha;
        this.mGlowScaleYFinish = this.mGlowScaleY;
    }

    public void onRelease() {
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mEdgeAlphaStart = this.mEdgeAlpha;
        this.mEdgeScaleYStart = this.mEdgeScaleY;
        this.mGlowAlphaStart = this.mGlowAlpha;
        this.mGlowScaleYStart = this.mGlowScaleY;
        this.mEdgeAlphaFinish = 0.0f;
        this.mEdgeScaleYFinish = 0.0f;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 1000.0f;
    }

    public void onAbsorb(int velocity) {
        this.mState = 2;
        velocity = Math.max(100, Math.abs(velocity));
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 0.1f + (float)velocity * 0.03f;
        this.mEdgeAlphaStart = 0.0f;
        this.mEdgeScaleYStart = 0.0f;
        this.mEdgeScaleY = 0.0f;
        this.mGlowAlphaStart = 0.5f;
        this.mGlowScaleYStart = 0.0f;
        this.mEdgeAlphaFinish = Math.max(0, Math.min(velocity * 8, 1));
        this.mEdgeScaleYFinish = Math.max(0.5f, Math.min((float)(velocity * 8), 1.0f));
        this.mGlowScaleYFinish = Math.min(0.025f + (float)(velocity * (velocity / 100)) * 1.5E-4f, 1.75f);
        this.mGlowAlphaFinish = Math.max(this.mGlowAlphaStart, Math.min((float)(velocity * 16) * 1.0E-5f, 0.8f));
    }

    public boolean draw(Canvas canvas) {
        this.update();
        int edgeHeight = this.mEdge.getIntrinsicHeight();
        int edgeWidth = this.mEdge.getIntrinsicWidth();
        int glowHeight = this.mGlow.getIntrinsicHeight();
        int glowWidth = this.mGlow.getIntrinsicWidth();
        this.mGlow.setAlpha((int)(Math.max(0.0f, Math.min(this.mGlowAlpha, 1.0f)) * 255.0f));
        int glowBottom = (int)Math.min((float)glowHeight * this.mGlowScaleY * (float)glowHeight / (float)glowWidth * 0.6f, (float)glowHeight * 4.0f);
        if (this.mWidth < this.mMinWidth) {
            int glowLeft = (this.mWidth - glowWidth) / 2;
            this.mGlow.setBounds(glowLeft, 0, this.mWidth - glowLeft, glowBottom);
        } else {
            this.mGlow.setBounds(0, 0, this.mWidth, glowBottom);
        }
        this.mGlow.draw(canvas);
        this.mEdge.setAlpha((int)(Math.max(0.0f, Math.min(this.mEdgeAlpha, 1.0f)) * 255.0f));
        int edgeBottom = (int)((float)edgeHeight * this.mEdgeScaleY);
        if (this.mWidth < this.mMinWidth) {
            int edgeLeft = (this.mWidth - edgeWidth) / 2;
            this.mEdge.setBounds(edgeLeft, 0, this.mWidth - edgeLeft, edgeBottom);
        } else {
            this.mEdge.setBounds(0, 0, this.mWidth, edgeBottom);
        }
        this.mEdge.draw(canvas);
        return this.mState != 0;
    }

    public void update() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        float t = Math.min((float)(time - this.mStartTime) / this.mDuration, 1.0f);
        float interp = this.mInterpolator.getInterpolation(t);
        this.mEdgeAlpha = this.mEdgeAlphaStart + (this.mEdgeAlphaFinish - this.mEdgeAlphaStart) * interp;
        this.mEdgeScaleY = this.mEdgeScaleYStart + (this.mEdgeScaleYFinish - this.mEdgeScaleYStart) * interp;
        this.mGlowAlpha = this.mGlowAlphaStart + (this.mGlowAlphaFinish - this.mGlowAlphaStart) * interp;
        this.mGlowScaleY = this.mGlowScaleYStart + (this.mGlowScaleYFinish - this.mGlowScaleYStart) * interp;
        if (t >= 0.999f) {
            switch (this.mState) {
                case 2: {
                    this.mState = 3;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 1000.0f;
                    this.mEdgeAlphaStart = this.mEdgeAlpha;
                    this.mEdgeScaleYStart = this.mEdgeScaleY;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mEdgeAlphaFinish = 0.0f;
                    this.mEdgeScaleYFinish = 0.0f;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 1: {
                    this.mState = 4;
                    this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                    this.mDuration = 1000.0f;
                    this.mEdgeAlphaStart = this.mEdgeAlpha;
                    this.mEdgeScaleYStart = this.mEdgeScaleY;
                    this.mGlowAlphaStart = this.mGlowAlpha;
                    this.mGlowScaleYStart = this.mGlowScaleY;
                    this.mEdgeAlphaFinish = 0.0f;
                    this.mEdgeScaleYFinish = 0.0f;
                    this.mGlowAlphaFinish = 0.0f;
                    this.mGlowScaleYFinish = 0.0f;
                    break;
                }
                case 4: {
                    float factor = this.mGlowScaleYFinish != 0.0f ? 1.0f / (this.mGlowScaleYFinish * this.mGlowScaleYFinish) : Float.MAX_VALUE;
                    this.mEdgeScaleY = this.mEdgeScaleYStart + (this.mEdgeScaleYFinish - this.mEdgeScaleYStart) * interp * factor;
                    break;
                }
                case 3: {
                    this.mState = 0;
                }
            }
        }
    }
}

