/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.IRemoteViewsAdapterConnection;
import com.android.internal.widget.IRemoteViewsFactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class RemoteViewsAdapter
extends BaseAdapter
implements Handler.Callback {
    public static final String TAG = "RemoteViewsAdapter";
    public static final int sDefaultCacheSize = 40;
    public static final int sUnbindServiceDelay = 5000;
    public static final int sDefaultMessageType = 0;
    public static final int sUnbindServiceMessageType = 1;
    public final Context mContext;
    public final Intent mIntent;
    public final int mAppWidgetId;
    public LayoutInflater mLayoutInflater;
    public RemoteViewsAdapterServiceConnection mServiceConnection;
    public WeakReference<RemoteAdapterConnectionCallback> mCallback;
    public FixedSizeRemoteViewsCache mCache;
    public boolean mNotifyDataSetChangedAfterOnServiceConnected = false;
    public RemoteViewsFrameLayoutRefSet mRequestedViews;
    public HandlerThread mWorkerThread;
    public Handler mWorkerQueue;
    public Handler mMainQueue;

    public RemoteViewsAdapter(Context context, Intent intent, RemoteAdapterConnectionCallback callback) {
        this.mContext = context;
        this.mIntent = intent;
        this.mAppWidgetId = intent.getIntExtra("remoteAdapterAppWidgetId", -1);
        this.mLayoutInflater = LayoutInflater.from(context);
        if (this.mIntent == null) {
            throw new IllegalArgumentException("Non-null Intent must be specified.");
        }
        this.mRequestedViews = new RemoteViewsFrameLayoutRefSet();
        if (intent.hasExtra("remoteAdapterAppWidgetId")) {
            intent.removeExtra("remoteAdapterAppWidgetId");
        }
        this.mWorkerThread = new HandlerThread("RemoteViewsCache-loader");
        this.mWorkerThread.start();
        this.mWorkerQueue = new Handler(this.mWorkerThread.getLooper());
        this.mMainQueue = new Handler(Looper.myLooper(), this);
        this.mCache = new FixedSizeRemoteViewsCache(40);
        this.mCallback = new WeakReference<RemoteAdapterConnectionCallback>(callback);
        this.mServiceConnection = new RemoteViewsAdapterServiceConnection(this);
        this.requestBindService();
    }

    public void loadNextIndexInBackground() {
        this.mWorkerQueue.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (RemoteViewsAdapter.this.mServiceConnection.isConnected()) {
                    int position = -1;
                    boolean isRequested = false;
                    FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                    synchronized (fixedSizeRemoteViewsCache) {
                        int[] res = RemoteViewsAdapter.this.mCache.getNextIndexToLoad();
                        position = res[0];
                        isRequested = res[1] > 0;
                    }
                    if (position > -1) {
                        RemoteViewsAdapter.this.updateRemoteViews(position, isRequested);
                        RemoteViewsAdapter.this.loadNextIndexInBackground();
                    } else {
                        RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processException(String method, Exception e) {
        Log.e(TAG, "Error in " + method + ": " + e.getMessage());
        RemoteViewsMetaData metaData = this.mCache.getMetaData();
        Object object = metaData;
        synchronized (object) {
            metaData.reset();
        }
        object = this.mCache;
        synchronized (object) {
            this.mCache.reset();
        }
        this.mMainQueue.post(new Runnable(){

            public void run() {
                RemoteViewsAdapter.this.superNotifyDataSetChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTemporaryMetaData() {
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            RemoteViewsMetaData tmpMetaData;
            boolean hasStableIds = factory.hasStableIds();
            int viewTypeCount = factory.getViewTypeCount();
            int count = factory.getCount();
            RemoteViews loadingView = factory.getLoadingView();
            RemoteViews firstView = null;
            if (count > 0 && loadingView == null) {
                firstView = factory.getViewAt(0);
            }
            RemoteViewsMetaData remoteViewsMetaData = tmpMetaData = this.mCache.getTemporaryMetaData();
            synchronized (remoteViewsMetaData) {
                tmpMetaData.hasStableIds = hasStableIds;
                tmpMetaData.viewTypeCount = viewTypeCount + 1;
                tmpMetaData.count = count;
                tmpMetaData.setLoadingViewTemplates(loadingView, firstView);
            }
        }
        catch (Exception e) {
            this.processException("updateMetaData", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteViews(final int position, boolean isRequested) {
        if (!this.mServiceConnection.isConnected()) {
            return;
        }
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        RemoteViews remoteViews = null;
        long itemId = 0L;
        try {
            remoteViews = factory.getViewAt(position);
            itemId = factory.getItemId(position);
        }
        catch (Exception e) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + e.getMessage());
            return;
        }
        if (remoteViews == null) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + " null RemoteViews " + "returned from RemoteViewsFactory.");
            return;
        }
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            this.mCache.insert(position, remoteViews, itemId, isRequested);
            final RemoteViews rv = remoteViews;
            final int typeId = this.mCache.getMetaDataAt((int)position).typeId;
            this.mMainQueue.post(new Runnable(){

                public void run() {
                    RemoteViewsAdapter.this.mRequestedViews.notifyOnRemoteViewsLoaded(position, rv, typeId);
                }
            });
        }
    }

    public Intent getRemoteViewsServiceIntent() {
        return this.mIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.count;
        }
    }

    public Object getItem(int position) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getItemId(int position) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (this.mCache.containsMetaDataAt(position)) {
                return this.mCache.getMetaDataAt((int)position).itemId;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemViewType(int position) {
        RemoteViewsMetaData metaData;
        int typeId = 0;
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (!this.mCache.containsMetaDataAt(position)) {
                return 0;
            }
            typeId = this.mCache.getMetaDataAt((int)position).typeId;
        }
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.getMappedViewType(typeId);
        }
    }

    public int getConvertViewTypeId(View convertView) {
        Object tag;
        int typeId = -1;
        if (convertView != null && (tag = convertView.getTag(16908779)) != null) {
            typeId = (Integer)tag;
        }
        return typeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getView(int position, View convertView, ViewGroup parent) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            RemoteViewsMetaData metaData;
            boolean isInCache = this.mCache.containsRemoteViewAt(position);
            boolean isConnected = this.mServiceConnection.isConnected();
            boolean hasNewItems = false;
            if (!isConnected) {
                this.requestBindService();
            } else {
                hasNewItems = this.mCache.queuePositionsToBePreloadedFromRequestedPosition(position);
            }
            if (isInCache) {
                View convertViewChild = null;
                int convertViewTypeId = 0;
                RemoteViewsFrameLayout layout2 = null;
                if (convertView instanceof RemoteViewsFrameLayout) {
                    layout2 = (RemoteViewsFrameLayout)convertView;
                    convertViewChild = layout2.getChildAt(0);
                    convertViewTypeId = this.getConvertViewTypeId(convertViewChild);
                }
                Context context = parent.getContext();
                RemoteViews rv = this.mCache.getRemoteViewsAt(position);
                int typeId = this.mCache.getMetaDataAt((int)position).typeId;
                if (layout2 != null) {
                    if (convertViewTypeId == typeId) {
                        rv.reapply(context, convertViewChild);
                        return layout2;
                    }
                    layout2.removeAllViews();
                } else {
                    layout2 = new RemoteViewsFrameLayout(context);
                }
                View newView = rv.apply(context, parent);
                newView.setTagInternal(16908779, new Integer(typeId));
                layout2.addView(newView);
                if (hasNewItems) {
                    this.loadNextIndexInBackground();
                }
                return layout2;
            }
            RemoteViewsFrameLayout loadingView = null;
            RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
            synchronized (remoteViewsMetaData) {
                loadingView = metaData.createLoadingView(position, convertView, parent);
            }
            this.mRequestedViews.add(position, loadingView);
            this.mCache.queueRequestedPositionToLoad(position);
            this.loadNextIndexInBackground();
            return loadingView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getViewTypeCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.viewTypeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStableIds() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.hasStableIds;
        }
    }

    public boolean isEmpty() {
        return this.getCount() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotifyDataSetChanged() {
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            factory.onDataSetChanged();
        }
        catch (Exception e) {
            Log.e(TAG, "Error in updateNotifyDataSetChanged(): " + e.getMessage());
            return;
        }
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            this.mCache.reset();
        }
        this.updateTemporaryMetaData();
        this.mMainQueue.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                synchronized (fixedSizeRemoteViewsCache) {
                    RemoteViewsAdapter.this.mCache.commitTemporaryMetaData();
                }
                RemoteViewsAdapter.this.superNotifyDataSetChanged();
                RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
            }
        });
        this.mNotifyDataSetChangedAfterOnServiceConnected = false;
    }

    public void notifyDataSetChanged() {
        this.mMainQueue.removeMessages(1);
        if (!this.mServiceConnection.isConnected()) {
            if (this.mNotifyDataSetChangedAfterOnServiceConnected) {
                return;
            }
            this.mNotifyDataSetChangedAfterOnServiceConnected = true;
            this.requestBindService();
            return;
        }
        this.mWorkerQueue.post(new Runnable(){

            public void run() {
                RemoteViewsAdapter.this.onNotifyDataSetChanged();
            }
        });
    }

    public void superNotifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    public boolean handleMessage(Message msg) {
        boolean result = false;
        switch (msg.what) {
            case 1: {
                if (this.mServiceConnection.isConnected()) {
                    this.mServiceConnection.unbind(this.mContext, this.mAppWidgetId, this.mIntent);
                }
                result = true;
                break;
            }
        }
        return result;
    }

    public void enqueueDeferredUnbindServiceMessage() {
        this.mMainQueue.removeMessages(1);
        this.mMainQueue.sendEmptyMessageDelayed(1, 5000L);
    }

    public boolean requestBindService() {
        if (!this.mServiceConnection.isConnected()) {
            this.mServiceConnection.bind(this.mContext, this.mAppWidgetId, this.mIntent);
        }
        this.mMainQueue.removeMessages(1);
        return this.mServiceConnection.isConnected();
    }

    public class FixedSizeRemoteViewsCache {
        public static final String TAG = "FixedSizeRemoteViewsCache";
        public RemoteViewsMetaData mMetaData;
        public RemoteViewsMetaData mTemporaryMetaData;
        public HashMap<Integer, RemoteViewsIndexMetaData> mIndexMetaData;
        public HashMap<Integer, RemoteViews> mIndexRemoteViews;
        public HashSet<Integer> mRequestedIndices;
        public int mLastRequestedIndex;
        public HashSet<Integer> mLoadIndices;
        public int mPreloadLowerBound;
        public int mPreloadUpperBound;
        public int mMaxCount;
        public int mMaxCountSlack;
        public static final float sMaxCountSlackPercent = 0.75f;
        public static final int sMaxMemoryLimitInBytes = 0x200000;

        public FixedSizeRemoteViewsCache(int maxCacheSize) {
            this.mMaxCount = maxCacheSize;
            this.mMaxCountSlack = Math.round(0.75f * (float)(this.mMaxCount / 2));
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mMetaData = new RemoteViewsMetaData();
            this.mTemporaryMetaData = new RemoteViewsMetaData();
            this.mIndexMetaData = new HashMap();
            this.mIndexRemoteViews = new HashMap();
            this.mRequestedIndices = new HashSet();
            this.mLastRequestedIndex = -1;
            this.mLoadIndices = new HashSet();
        }

        public void insert(int position, RemoteViews v, long itemId, boolean isRequested) {
            int pruneFromPosition;
            if (this.mIndexRemoteViews.size() >= this.mMaxCount) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(position));
            }
            int n = pruneFromPosition = this.mLastRequestedIndex > -1 ? this.mLastRequestedIndex : position;
            while (this.getRemoteViewsBitmapMemoryUsage() >= 0x200000) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(pruneFromPosition));
            }
            if (this.mIndexMetaData.containsKey(position)) {
                RemoteViewsIndexMetaData metaData = this.mIndexMetaData.get(position);
                metaData.set(v, itemId, isRequested);
            } else {
                this.mIndexMetaData.put(position, new RemoteViewsIndexMetaData(v, itemId, isRequested));
            }
            this.mIndexRemoteViews.put(position, v);
        }

        public RemoteViewsMetaData getMetaData() {
            return this.mMetaData;
        }

        public RemoteViewsMetaData getTemporaryMetaData() {
            return this.mTemporaryMetaData;
        }

        public RemoteViews getRemoteViewsAt(int position) {
            if (this.mIndexRemoteViews.containsKey(position)) {
                return this.mIndexRemoteViews.get(position);
            }
            return null;
        }

        public RemoteViewsIndexMetaData getMetaDataAt(int position) {
            if (this.mIndexMetaData.containsKey(position)) {
                return this.mIndexMetaData.get(position);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitTemporaryMetaData() {
            RemoteViewsMetaData remoteViewsMetaData = this.mTemporaryMetaData;
            synchronized (remoteViewsMetaData) {
                RemoteViewsMetaData remoteViewsMetaData2 = this.mMetaData;
                synchronized (remoteViewsMetaData2) {
                    this.mMetaData.set(this.mTemporaryMetaData);
                }
            }
        }

        public int getRemoteViewsBitmapMemoryUsage() {
            int mem = 0;
            for (Integer i : this.mIndexRemoteViews.keySet()) {
                RemoteViews v = this.mIndexRemoteViews.get(i);
                if (v == null) continue;
                mem += v.estimateBitmapMemoryUsage();
            }
            return mem;
        }

        public int getFarthestPositionFrom(int pos) {
            int maxDist = 0;
            int maxDistIndex = -1;
            int maxDistNonRequested = 0;
            int maxDistIndexNonRequested = -1;
            for (int i : this.mIndexRemoteViews.keySet()) {
                int dist = Math.abs(i - pos);
                if (dist > maxDistNonRequested && !this.mIndexMetaData.get((Object)Integer.valueOf((int)i)).isRequested) {
                    maxDistIndexNonRequested = i;
                    maxDistNonRequested = dist;
                }
                if (dist <= maxDist) continue;
                maxDistIndex = i;
                maxDist = dist;
            }
            if (maxDistIndexNonRequested > -1) {
                return maxDistIndexNonRequested;
            }
            return maxDistIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueRequestedPositionToLoad(int position) {
            this.mLastRequestedIndex = position;
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                this.mRequestedIndices.add(position);
                this.mLoadIndices.add(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queuePositionsToBePreloadedFromRequestedPosition(int position) {
            int center;
            if (this.mPreloadLowerBound <= position && position <= this.mPreloadUpperBound && Math.abs(position - (center = (this.mPreloadUpperBound + this.mPreloadLowerBound) / 2)) < this.mMaxCountSlack) {
                return false;
            }
            int count = 0;
            Object object = this.mMetaData;
            synchronized (object) {
                count = this.mMetaData.count;
            }
            object = this.mLoadIndices;
            synchronized (object) {
                this.mLoadIndices.clear();
                this.mLoadIndices.addAll(this.mRequestedIndices);
                int halfMaxCount = this.mMaxCount / 2;
                this.mPreloadLowerBound = position - halfMaxCount;
                this.mPreloadUpperBound = position + halfMaxCount;
                int effectiveLowerBound = Math.max(0, this.mPreloadLowerBound);
                int effectiveUpperBound = Math.min(this.mPreloadUpperBound, count - 1);
                for (int i = effectiveLowerBound; i <= effectiveUpperBound; ++i) {
                    this.mLoadIndices.add(i);
                }
                this.mLoadIndices.removeAll(this.mIndexRemoteViews.keySet());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getNextIndexToLoad() {
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                if (!this.mRequestedIndices.isEmpty()) {
                    Integer i = this.mRequestedIndices.iterator().next();
                    this.mRequestedIndices.remove(i);
                    this.mLoadIndices.remove(i);
                    return new int[]{i, 1};
                }
                if (!this.mLoadIndices.isEmpty()) {
                    Integer i = this.mLoadIndices.iterator().next();
                    this.mLoadIndices.remove(i);
                    return new int[]{i, 0};
                }
                return new int[]{-1, 0};
            }
        }

        public boolean containsRemoteViewAt(int position) {
            return this.mIndexRemoteViews.containsKey(position);
        }

        public boolean containsMetaDataAt(int position) {
            return this.mIndexMetaData.containsKey(position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
            this.mIndexRemoteViews.clear();
            this.mIndexMetaData.clear();
            HashSet<Integer> hashSet = this.mLoadIndices;
            synchronized (hashSet) {
                this.mRequestedIndices.clear();
                this.mLoadIndices.clear();
            }
        }
    }

    public class RemoteViewsIndexMetaData {
        public int typeId;
        public long itemId;
        public boolean isRequested;

        public RemoteViewsIndexMetaData(RemoteViews v, long itemId, boolean requested) {
            this.set(v, itemId, requested);
        }

        public void set(RemoteViews v, long id2, boolean requested) {
            this.itemId = id2;
            this.typeId = v != null ? v.getLayoutId() : 0;
            this.isRequested = requested;
        }
    }

    public class RemoteViewsMetaData {
        public int count;
        public int viewTypeCount;
        public boolean hasStableIds;
        public RemoteViews mUserLoadingView;
        public RemoteViews mFirstView;
        public int mFirstViewHeight;
        public final HashMap<Integer, Integer> mTypeIdIndexMap = new HashMap();

        public RemoteViewsMetaData() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(RemoteViewsMetaData d) {
            RemoteViewsMetaData remoteViewsMetaData = d;
            synchronized (remoteViewsMetaData) {
                this.count = d.count;
                this.viewTypeCount = d.viewTypeCount;
                this.hasStableIds = d.hasStableIds;
                this.setLoadingViewTemplates(d.mUserLoadingView, d.mFirstView);
            }
        }

        public void reset() {
            this.count = 0;
            this.viewTypeCount = 1;
            this.hasStableIds = true;
            this.mUserLoadingView = null;
            this.mFirstView = null;
            this.mFirstViewHeight = 0;
            this.mTypeIdIndexMap.clear();
        }

        public void setLoadingViewTemplates(RemoteViews loadingView, RemoteViews firstView) {
            this.mUserLoadingView = loadingView;
            if (firstView != null) {
                this.mFirstView = firstView;
                this.mFirstViewHeight = -1;
            }
        }

        public int getMappedViewType(int typeId) {
            if (this.mTypeIdIndexMap.containsKey(typeId)) {
                return this.mTypeIdIndexMap.get(typeId);
            }
            int incrementalTypeId = this.mTypeIdIndexMap.size() + 1;
            this.mTypeIdIndexMap.put(typeId, incrementalTypeId);
            return incrementalTypeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteViewsFrameLayout createLoadingView(int position, View convertView, ViewGroup parent) {
            Context context = parent.getContext();
            RemoteViewsFrameLayout layout2 = new RemoteViewsFrameLayout(context);
            FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
            synchronized (fixedSizeRemoteViewsCache) {
                if (this.mUserLoadingView != null) {
                    View loadingView = this.mUserLoadingView.apply(parent.getContext(), parent);
                    loadingView.setTagInternal(16908779, new Integer(0));
                    layout2.addView(loadingView);
                } else {
                    if (this.mFirstViewHeight < 0) {
                        View firstView = this.mFirstView.apply(parent.getContext(), parent);
                        firstView.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
                        this.mFirstViewHeight = firstView.getMeasuredHeight();
                        this.mFirstView = null;
                    }
                    TextView loadingTextView = (TextView)RemoteViewsAdapter.this.mLayoutInflater.inflate(17367151, (ViewGroup)layout2, false);
                    loadingTextView.setHeight(this.mFirstViewHeight);
                    loadingTextView.setTag(new Integer(0));
                    layout2.addView(loadingTextView);
                }
            }
            return layout2;
        }
    }

    public class RemoteViewsFrameLayoutRefSet {
        public HashMap<Integer, LinkedList<RemoteViewsFrameLayout>> mReferences = new HashMap();

        public void add(int position, RemoteViewsFrameLayout layout2) {
            LinkedList<Object> refs;
            Integer pos = position;
            if (this.mReferences.containsKey(pos)) {
                refs = this.mReferences.get(pos);
            } else {
                refs = new LinkedList();
                this.mReferences.put(pos, refs);
            }
            refs.add(layout2);
        }

        public void notifyOnRemoteViewsLoaded(int position, RemoteViews view, int typeId) {
            if (view == null) {
                return;
            }
            Integer pos = position;
            if (this.mReferences.containsKey(pos)) {
                LinkedList<RemoteViewsFrameLayout> refs = this.mReferences.get(pos);
                for (RemoteViewsFrameLayout ref : refs) {
                    ref.onRemoteViewsLoaded(view);
                }
                refs.clear();
                this.mReferences.remove(pos);
            }
        }

        public void clear() {
            this.mReferences.clear();
        }
    }

    public class RemoteViewsFrameLayout
    extends FrameLayout {
        public RemoteViewsFrameLayout(Context context) {
            super(context);
        }

        public void onRemoteViewsLoaded(RemoteViews view) {
            try {
                this.removeAllViews();
                this.addView(view.apply(this.getContext(), this));
            }
            catch (Exception e) {
                Log.e(RemoteViewsAdapter.TAG, "Failed to apply RemoteViews.");
            }
        }
    }

    public static class RemoteViewsAdapterServiceConnection
    extends IRemoteViewsAdapterConnection.Stub {
        public boolean mIsConnected;
        public boolean mIsConnecting;
        public WeakReference<RemoteViewsAdapter> mAdapter;
        public IRemoteViewsFactory mRemoteViewsFactory;

        public RemoteViewsAdapterServiceConnection(RemoteViewsAdapter adapter) {
            this.mAdapter = new WeakReference<RemoteViewsAdapter>(adapter);
        }

        public synchronized void bind(Context context, int appWidgetId, Intent intent) {
            if (!this.mIsConnecting) {
                try {
                    AppWidgetManager mgr = AppWidgetManager.getInstance(context);
                    mgr.bindRemoteViewsService(appWidgetId, intent, this.asBinder());
                    this.mIsConnecting = true;
                }
                catch (Exception e) {
                    Log.e("RemoteViewsAdapterServiceConnection", "bind(): " + e.getMessage());
                    this.mIsConnecting = false;
                    this.mIsConnected = false;
                }
            }
        }

        public synchronized void unbind(Context context, int appWidgetId, Intent intent) {
            try {
                AppWidgetManager mgr = AppWidgetManager.getInstance(context);
                mgr.unbindRemoteViewsService(appWidgetId, intent);
                this.mIsConnecting = false;
            }
            catch (Exception e) {
                Log.e("RemoteViewsAdapterServiceConnection", "unbind(): " + e.getMessage());
                this.mIsConnecting = false;
                this.mIsConnected = false;
            }
        }

        public synchronized void onServiceConnected(IBinder service) {
            this.mRemoteViewsFactory = IRemoteViewsFactory.Stub.asInterface(service);
            final RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            adapter.mWorkerQueue.post(new Runnable(){

                public void run() {
                    if (adapter.mNotifyDataSetChangedAfterOnServiceConnected) {
                        adapter.onNotifyDataSetChanged();
                    } else {
                        IRemoteViewsFactory factory = adapter.mServiceConnection.getRemoteViewsFactory();
                        try {
                            if (!factory.isCreated()) {
                                factory.onDataSetChanged();
                            }
                        }
                        catch (Exception e) {
                            Log.e(RemoteViewsAdapter.TAG, "Error notifying factory of data set changed in onServiceConnected(): " + e.getMessage());
                            return;
                        }
                        adapter.updateTemporaryMetaData();
                        adapter.mMainQueue.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = adapter.mCache;
                                synchronized (fixedSizeRemoteViewsCache) {
                                    adapter.mCache.commitTemporaryMetaData();
                                }
                                RemoteAdapterConnectionCallback callback = (RemoteAdapterConnectionCallback)adapter.mCallback.get();
                                if (callback != null) {
                                    callback.onRemoteAdapterConnected();
                                }
                            }
                        });
                    }
                    adapter.enqueueDeferredUnbindServiceMessage();
                    RemoteViewsAdapterServiceConnection.this.mIsConnected = true;
                    RemoteViewsAdapterServiceConnection.this.mIsConnecting = false;
                }
            });
        }

        public synchronized void onServiceDisconnected() {
            this.mIsConnected = false;
            this.mIsConnecting = false;
            this.mRemoteViewsFactory = null;
            final RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            adapter.mMainQueue.post(new Runnable(){

                public void run() {
                    adapter.mMainQueue.removeMessages(1);
                    RemoteAdapterConnectionCallback callback = (RemoteAdapterConnectionCallback)adapter.mCallback.get();
                    if (callback != null) {
                        callback.onRemoteAdapterDisconnected();
                    }
                }
            });
        }

        public synchronized IRemoteViewsFactory getRemoteViewsFactory() {
            return this.mRemoteViewsFactory;
        }

        public synchronized boolean isConnected() {
            return this.mIsConnected;
        }
    }

    public static interface RemoteAdapterConnectionCallback {
        public boolean onRemoteAdapterConnected();

        public void onRemoteAdapterDisconnected();
    }
}

