/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.SpinnerAdapter;
import com.android.internal.R;

public class Spinner
extends AbsSpinner
implements DialogInterface.OnClickListener {
    public static final String TAG = "Spinner";
    public static final int MAX_ITEMS_MEASURED = 15;
    public static final int MODE_DIALOG = 0;
    public static final int MODE_DROPDOWN = 1;
    public static final int MODE_THEME = -1;
    public SpinnerPopup mPopup;
    public DropDownAdapter mTempAdapter;
    public int mGravity;

    public Spinner(Context context) {
        this(context, null);
    }

    public Spinner(Context context, int mode) {
        this(context, null, 0x1010081, mode);
    }

    public Spinner(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010081);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, -1);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyle, int mode) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Spinner, defStyle, 0);
        if (mode == -1) {
            mode = a.getInt(7, 0);
        }
        switch (mode) {
            case 0: {
                this.mPopup = new DialogPopup(null);
                break;
            }
            case 1: {
                DropdownPopup popup = new DropdownPopup(context, attrs, defStyle);
                popup.setWidth(a.getLayoutDimension(4, -2));
                popup.setBackgroundDrawable(a.getDrawable(2));
                popup.setVerticalOffset(a.getDimensionPixelOffset(6, 0));
                popup.setHorizontalOffset(a.getDimensionPixelOffset(5, 0));
                this.mPopup = popup;
                break;
            }
        }
        this.mGravity = a.getInt(0, 17);
        this.mPopup.setPromptText(a.getString(3));
        a.recycle();
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 3;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public void setAdapter(SpinnerAdapter adapter) {
        super.setAdapter(adapter);
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(adapter));
        } else {
            this.mTempAdapter = new DropDownAdapter(adapter);
        }
    }

    public int getBaseline() {
        View child = null;
        if (this.getChildCount() > 0) {
            child = this.getChildAt(0);
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            child = this.makeAndAddView(0);
            this.mRecycler.put(0, child);
            this.removeAllViewsInLayout();
        }
        if (child != null) {
            return child.getTop() + child.getBaseline();
        }
        return -1;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPopup != null && View.MeasureSpec.getMode(widthMeasureSpec) == Integer.MIN_VALUE) {
            int measuredWidth = this.getMeasuredWidth();
            this.setMeasuredDimension(Math.min(Math.max(measuredWidth, this.mPopup.measureContentWidth()), View.MeasureSpec.getSize(widthMeasureSpec)), this.getMeasuredHeight());
        }
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    public void layout(int delta, boolean animate) {
        int childrenLeft = this.mSpinnerPadding.left;
        int childrenWidth = this.mRight - this.mLeft - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        View sel = this.makeAndAddView(this.mSelectedPosition);
        int width = sel.getMeasuredWidth();
        int selectedOffset = childrenLeft;
        switch (this.mGravity & 7) {
            case 1: {
                selectedOffset = childrenLeft + childrenWidth / 2 - width / 2;
                break;
            }
            case 5: {
                selectedOffset = childrenLeft + childrenWidth - width;
            }
        }
        sel.offsetLeftAndRight(selectedOffset);
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    public View makeAndAddView(int position) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            this.setUpChild(child);
            return child;
        }
        child = this.mAdapter.getView(position, null, this);
        this.setUpChild(child);
        return child;
    }

    public void setUpChild(View child) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, 0, lp);
        child.setSelected(this.hasFocus());
        int childHeightSpec = ViewGroup.getChildMeasureSpec(this.mHeightMeasureSpec, this.mSpinnerPadding.top + this.mSpinnerPadding.bottom, lp.height);
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mSpinnerPadding.left + this.mSpinnerPadding.right, lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childTop = this.mSpinnerPadding.top + (this.getMeasuredHeight() - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - child.getMeasuredHeight()) / 2;
        int childBottom = childTop + child.getMeasuredHeight();
        int width = child.getMeasuredWidth();
        int childLeft = 0;
        int childRight = childLeft + width;
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    public boolean performClick() {
        boolean handled = super.performClick();
        if (!handled) {
            handled = true;
            if (!this.mPopup.isShowing()) {
                this.mPopup.show();
            }
        }
        return handled;
    }

    public void onClick(DialogInterface dialog, int which) {
        this.setSelection(which);
        dialog.dismiss();
    }

    public void setPrompt(CharSequence prompt) {
        this.mPopup.setPromptText(prompt);
    }

    public void setPromptId(int promptId) {
        this.setPrompt(this.getContext().getText(promptId));
    }

    public CharSequence getPrompt() {
        return this.mPopup.getHintText();
    }

    public static class 1 {
    }

    public class DropdownPopup
    extends ListPopupWindow
    implements SpinnerPopup {
        public CharSequence mHintText;
        public int mPopupMaxWidth;
        public Rect mTempRect;

        public DropdownPopup(Context context, AttributeSet attrs, int defStyleRes) {
            super(context, attrs, 0, defStyleRes);
            this.mTempRect = new Rect();
            DisplayMetrics metrics = context.getResources().getDisplayMetrics();
            this.mPopupMaxWidth = metrics.widthPixels / 2;
            this.setAnchorView(Spinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView parent, View v, int position, long id2) {
                    Spinner.this.setSelection(position);
                    DropdownPopup.this.dismiss();
                }
            });
        }

        public CharSequence getHintText() {
            return this.mHintText;
        }

        public void setPromptText(CharSequence hintText) {
            this.mHintText = hintText;
        }

        public void show() {
            this.setWidth(Spinner.this.getWidth());
            this.setInputMethodMode(2);
            super.show();
            this.getListView().setChoiceMode(1);
            this.setSelection(Spinner.this.getSelectedItemPosition());
        }

        public int measureContentWidth() {
            SpinnerAdapter adapter = Spinner.this.getAdapter();
            if (adapter == null) {
                return 0;
            }
            int width = 0;
            View itemView = null;
            int itemType = 0;
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
            int start = Math.max(0, this.getSelectedItemPosition());
            int count = Math.min(adapter.getCount(), start + 15);
            for (int i = start; i < count; ++i) {
                int positionType = adapter.getItemViewType(i);
                if (positionType != itemType) {
                    itemType = positionType;
                    itemView = null;
                }
                if ((itemView = adapter.getDropDownView(i, itemView, Spinner.this)).getLayoutParams() == null) {
                    itemView.setLayoutParams(this.generateDefaultLayoutParams());
                }
                itemView.measure(widthMeasureSpec, heightMeasureSpec);
                width = Math.max(width, itemView.getMeasuredWidth());
            }
            Drawable popupBackground = this.getBackground();
            if (popupBackground != null) {
                popupBackground.getPadding(this.mTempRect);
                width += this.mTempRect.left + this.mTempRect.right;
            }
            return width;
        }

        public ViewGroup.LayoutParams generateDefaultLayoutParams() {
            return new ViewGroup.LayoutParams(-2, -2);
        }
    }

    public class DialogPopup
    implements SpinnerPopup,
    DialogInterface.OnClickListener {
        public AlertDialog mPopup;
        public ListAdapter mListAdapter;
        public CharSequence mPrompt;

        public DialogPopup() {
        }

        public void dismiss() {
            this.mPopup.dismiss();
            this.mPopup = null;
        }

        public boolean isShowing() {
            return this.mPopup != null ? this.mPopup.isShowing() : false;
        }

        public void setAdapter(ListAdapter adapter) {
            this.mListAdapter = adapter;
        }

        public void setPromptText(CharSequence hintText) {
            this.mPrompt = hintText;
        }

        public CharSequence getHintText() {
            return this.mPrompt;
        }

        public void show() {
            AlertDialog.Builder builder = new AlertDialog.Builder(Spinner.this.getContext());
            if (this.mPrompt != null) {
                builder.setTitle(this.mPrompt);
            }
            this.mPopup = builder.setSingleChoiceItems(this.mListAdapter, Spinner.this.getSelectedItemPosition(), (DialogInterface.OnClickListener)this).show();
        }

        public void onClick(DialogInterface dialog, int which) {
            Spinner.this.setSelection(which);
            this.dismiss();
        }

        public int measureContentWidth() {
            return 0;
        }

        public /* synthetic */ DialogPopup(1 x1) {
            this();
        }
    }

    public static interface SpinnerPopup {
        public void setAdapter(ListAdapter var1);

        public void show();

        public void dismiss();

        public boolean isShowing();

        public void setPromptText(CharSequence var1);

        public CharSequence getHintText();

        public int measureContentWidth();
    }

    public static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        public SpinnerAdapter mAdapter;
        public ListAdapter mListAdapter;

        public DropDownAdapter(SpinnerAdapter adapter) {
            this.mAdapter = adapter;
            if (adapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)((Object)adapter);
            }
        }

        public int getCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getCount();
        }

        public Object getItem(int position) {
            return this.mAdapter == null ? null : this.mAdapter.getItem(position);
        }

        public long getItemId(int position) {
            return this.mAdapter == null ? -1L : this.mAdapter.getItemId(position);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getDropDownView(position, convertView, parent);
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.mAdapter == null ? null : this.mAdapter.getDropDownView(position, convertView, parent);
        }

        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }

        public boolean areAllItemsEnabled() {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.areAllItemsEnabled();
            }
            return true;
        }

        public boolean isEnabled(int position) {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.isEnabled(position);
            }
            return true;
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }

        public boolean isEmpty() {
            return this.getCount() == 0;
        }
    }
}

