/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TableMaskFilter;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterViewAnimator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;
import java.lang.ref.WeakReference;

@RemoteViews.RemoteView
public class StackView
extends AdapterViewAnimator {
    public final String TAG = "StackView";
    public static final int DEFAULT_ANIMATION_DURATION = 400;
    public static final int FADE_IN_ANIMATION_DURATION = 800;
    public static final int MINIMUM_ANIMATION_DURATION = 50;
    public static final int STACK_RELAYOUT_DURATION = 100;
    public static final float PERSPECTIVE_SHIFT_FACTOR_Y = 0.1f;
    public static final float PERSPECTIVE_SHIFT_FACTOR_X = 0.1f;
    public float mPerspectiveShiftX;
    public float mPerspectiveShiftY;
    public float mNewPerspectiveShiftX;
    public float mNewPerspectiveShiftY;
    public static final float PERSPECTIVE_SCALE_FACTOR = 0.0f;
    public static final int ITEMS_SLIDE_UP = 0;
    public static final int ITEMS_SLIDE_DOWN = 1;
    public static final int GESTURE_NONE = 0;
    public static final int GESTURE_SLIDE_UP = 1;
    public static final int GESTURE_SLIDE_DOWN = 2;
    public static final float SWIPE_THRESHOLD_RATIO = 0.2f;
    public static final float SLIDE_UP_RATIO = 0.7f;
    public static final int INVALID_POINTER = -1;
    public static final int NUM_ACTIVE_VIEWS = 5;
    public static final int FRAME_PADDING = 4;
    public final Rect mTouchRect = new Rect();
    public static final int MIN_TIME_BETWEEN_INTERACTION_AND_AUTOADVANCE = 5000;
    public float mInitialY;
    public float mInitialX;
    public int mActivePointerId;
    public int mYVelocity = 0;
    public int mSwipeGestureType = 0;
    public int mSlideAmount;
    public int mSwipeThreshold;
    public int mTouchSlop;
    public int mMaximumVelocity;
    public VelocityTracker mVelocityTracker;
    public boolean mTransitionIsSetup = false;
    public static HolographicHelper sHolographicHelper;
    public ImageView mHighlight;
    public ImageView mClickFeedback;
    public boolean mClickFeedbackIsValid = false;
    public StackSlider mStackSlider;
    public boolean mFirstLayoutHappened = false;
    public long mLastInteractionTime = 0L;
    public int mStackMode;
    public int mFramePadding;
    public final Rect stackInvalidateRect = new Rect();

    public StackView(Context context) {
        super(context);
        this.initStackView();
    }

    public StackView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initStackView();
    }

    public void initStackView() {
        this.configureViewAnimator(5, 1);
        this.setStaticTransformationsEnabled(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mActivePointerId = -1;
        this.mHighlight = new ImageView(this.getContext());
        this.mHighlight.setLayoutParams(new LayoutParams(this.mHighlight));
        this.addViewInLayout(this.mHighlight, -1, new LayoutParams(this.mHighlight));
        this.mClickFeedback = new ImageView(this.getContext());
        this.mClickFeedback.setLayoutParams(new LayoutParams(this.mClickFeedback));
        this.addViewInLayout(this.mClickFeedback, -1, new LayoutParams(this.mClickFeedback));
        this.mClickFeedback.setVisibility(4);
        this.mStackSlider = new StackSlider();
        if (sHolographicHelper == null) {
            sHolographicHelper = new HolographicHelper(this.mContext);
        }
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mStackMode = 1;
        this.mWhichChild = -1;
        float density = this.mContext.getResources().getDisplayMetrics().density;
        this.mFramePadding = (int)Math.ceil(density * 4.0f);
    }

    public void transformViewForTransition(int fromIndex, int toIndex, View view, boolean animate) {
        LayoutParams lp;
        ObjectAnimator alphaOa = null;
        Object oldAlphaOa = null;
        if (!animate) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setRotationX(0.0f);
            lp = (LayoutParams)view.getLayoutParams();
            lp.setVerticalOffset(0);
            lp.setHorizontalOffset(0);
        }
        if (fromIndex == -1 && toIndex == this.getNumActiveViews() - 1) {
            if (view.getAlpha() == 1.0f) {
                view.setAlpha(0.0f);
            }
            this.transformViewAtIndex(toIndex, view, false);
            view.setVisibility(0);
            ((StackFrame)view).cancelAlphaAnimator();
            if (animate) {
                alphaOa = ObjectAnimator.ofFloat(view, "alpha", view.getAlpha(), 1.0f);
                alphaOa.setDuration(800L);
                ((StackFrame)view).setAlphaAnimator(alphaOa);
                alphaOa.start();
            } else {
                view.setAlpha(1.0f);
            }
        } else if (fromIndex == 0 && toIndex == 1) {
            ((StackFrame)view).cancelSliderAnimator();
            view.setVisibility(0);
            int duration = Math.round(this.mStackSlider.getDurationForNeutralPosition(this.mYVelocity));
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            animationSlider.setView(view);
            if (animate) {
                PropertyValuesHolder slideInY = PropertyValuesHolder.ofFloat("YProgress", 0.0f);
                PropertyValuesHolder slideInX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
                ObjectAnimator slideIn = ObjectAnimator.ofPropertyValuesHolder(animationSlider, slideInX, slideInY);
                slideIn.setDuration(duration);
                slideIn.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(slideIn);
                slideIn.start();
            } else {
                animationSlider.setYProgress(0.0f);
                animationSlider.setXProgress(0.0f);
            }
        } else if (fromIndex == 1 && toIndex == 0) {
            ((StackFrame)view).cancelSliderAnimator();
            int duration = Math.round(this.mStackSlider.getDurationForOffscreenPosition(this.mYVelocity));
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            animationSlider.setView(view);
            if (animate) {
                PropertyValuesHolder slideOutY = PropertyValuesHolder.ofFloat("YProgress", 1.0f);
                PropertyValuesHolder slideOutX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
                ObjectAnimator slideOut = ObjectAnimator.ofPropertyValuesHolder(animationSlider, slideOutX, slideOutY);
                slideOut.setDuration(duration);
                slideOut.setInterpolator(new LinearInterpolator());
                ((StackFrame)view).setSliderAnimator(slideOut);
                slideOut.start();
            } else {
                animationSlider.setYProgress(1.0f);
                animationSlider.setXProgress(0.0f);
            }
        } else if (toIndex == 0) {
            view.setAlpha(0.0f);
            view.setVisibility(4);
        } else if ((fromIndex == 0 || fromIndex == 1) && toIndex > 1) {
            view.setVisibility(0);
            view.setAlpha(1.0f);
            view.setRotationX(0.0f);
            lp = (LayoutParams)view.getLayoutParams();
            lp.setVerticalOffset(0);
            lp.setHorizontalOffset(0);
        } else if (fromIndex == -1) {
            view.setAlpha(1.0f);
            view.setVisibility(0);
        } else if (toIndex == -1) {
            ((StackFrame)view).cancelAlphaAnimator();
            if (animate) {
                alphaOa = ObjectAnimator.ofFloat(view, "alpha", view.getAlpha(), 0.0f);
                alphaOa.setDuration(100L);
                ((StackFrame)view).setAlphaAnimator(alphaOa);
                alphaOa.start();
            } else {
                view.setAlpha(0.0f);
            }
        }
        if (toIndex != -1) {
            this.transformViewAtIndex(toIndex, view, animate);
        }
    }

    public void transformViewAtIndex(int index, View view, boolean animate) {
        float maxPerspectiveShiftY = this.mPerspectiveShiftY;
        float maxPerspectiveShiftX = this.mPerspectiveShiftX;
        if (this.mStackMode == 1) {
            if ((index = this.mMaxNumActiveViews - index - 1) == this.mMaxNumActiveViews - 1) {
                --index;
            }
        } else if (--index < 0) {
            ++index;
        }
        float r = (float)index * 1.0f / (float)(this.mMaxNumActiveViews - 2);
        float scale = 1.0f - 0.0f * (1.0f - r);
        float perspectiveTranslationY = r * maxPerspectiveShiftY;
        float scaleShiftCorrectionY = (scale - 1.0f) * ((float)this.getMeasuredHeight() * 0.9f / 2.0f);
        float transY = perspectiveTranslationY + scaleShiftCorrectionY;
        float perspectiveTranslationX = (1.0f - r) * maxPerspectiveShiftX;
        float scaleShiftCorrectionX = (1.0f - scale) * ((float)this.getMeasuredWidth() * 0.9f / 2.0f);
        float transX = perspectiveTranslationX + scaleShiftCorrectionX;
        if (view instanceof StackFrame) {
            ((StackFrame)view).cancelTransformAnimator();
        }
        if (animate) {
            PropertyValuesHolder translationX = PropertyValuesHolder.ofFloat("translationX", transX);
            PropertyValuesHolder translationY = PropertyValuesHolder.ofFloat("translationY", transY);
            PropertyValuesHolder scalePropX = PropertyValuesHolder.ofFloat("scaleX", scale);
            PropertyValuesHolder scalePropY = PropertyValuesHolder.ofFloat("scaleY", scale);
            ObjectAnimator oa = ObjectAnimator.ofPropertyValuesHolder(view, scalePropX, scalePropY, translationY, translationX);
            oa.setDuration(100L);
            if (view instanceof StackFrame) {
                ((StackFrame)view).setTransformAnimator(oa);
            }
            oa.start();
        } else {
            view.setTranslationX(transX);
            view.setTranslationY(transY);
            view.setScaleX(scale);
            view.setScaleY(scale);
        }
    }

    public void setupStackSlider(View v, int mode) {
        this.mStackSlider.setMode(mode);
        if (v != null) {
            this.mHighlight.setImageBitmap(sHolographicHelper.createOutline(v));
            this.mHighlight.setRotation(v.getRotation());
            this.mHighlight.setTranslationY(v.getTranslationY());
            this.mHighlight.setTranslationX(v.getTranslationX());
            this.mHighlight.bringToFront();
            v.bringToFront();
            this.mStackSlider.setView(v);
            v.setVisibility(0);
        }
    }

    @RemotableViewMethod
    public void showNext() {
        View v;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (v = this.getViewAtRelativeIndex(1)) != null) {
            this.setupStackSlider(v, 0);
            this.mStackSlider.setYProgress(0.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showNext();
    }

    @RemotableViewMethod
    public void showPrevious() {
        View v;
        if (this.mSwipeGestureType != 0) {
            return;
        }
        if (!this.mTransitionIsSetup && (v = this.getViewAtRelativeIndex(0)) != null) {
            this.setupStackSlider(v, 0);
            this.mStackSlider.setYProgress(1.0f);
            this.mStackSlider.setXProgress(0.0f);
        }
        super.showPrevious();
    }

    public void showOnly(int childIndex, boolean animate) {
        super.showOnly(childIndex, animate);
        for (int i = this.mCurrentWindowEnd; i >= this.mCurrentWindowStart; --i) {
            View v;
            int index = this.modulo(i, this.getWindowSize());
            AdapterViewAnimator.ViewAndIndex vi = (AdapterViewAnimator.ViewAndIndex)this.mViewsMap.get(index);
            if (vi == null || (v = ((AdapterViewAnimator.ViewAndIndex)this.mViewsMap.get((Object)Integer.valueOf((int)index))).view) == null) continue;
            v.bringToFront();
        }
        if (this.mHighlight != null) {
            this.mHighlight.bringToFront();
        }
        this.mTransitionIsSetup = false;
        this.mClickFeedbackIsValid = false;
    }

    public void updateClickFeedback() {
        if (!this.mClickFeedbackIsValid) {
            View v = this.getViewAtRelativeIndex(1);
            if (v != null) {
                this.mClickFeedback.setImageBitmap(sHolographicHelper.createOutline(v, 1));
                this.mClickFeedback.setTranslationX(v.getTranslationX());
                this.mClickFeedback.setTranslationY(v.getTranslationY());
            }
            this.mClickFeedbackIsValid = true;
        }
    }

    public void showTapFeedback(View v) {
        this.updateClickFeedback();
        this.mClickFeedback.setVisibility(0);
        this.mClickFeedback.bringToFront();
        this.invalidate();
    }

    public void hideTapFeedback(View v) {
        this.mClickFeedback.setVisibility(4);
        this.invalidate();
    }

    public void updateChildTransforms() {
        for (int i = 0; i < this.getNumActiveViews(); ++i) {
            View v = this.getViewAtRelativeIndex(i);
            if (v == null) continue;
            this.transformViewAtIndex(i, v, false);
        }
    }

    public FrameLayout getFrameForChild() {
        StackFrame fl = new StackFrame(this.mContext);
        fl.setPadding(this.mFramePadding, this.mFramePadding, this.mFramePadding, this.mFramePadding);
        return fl;
    }

    public void applyTransformForChildAtIndex(View child, int relativeIndex) {
    }

    public void dispatchDraw(Canvas canvas) {
        canvas.getClipBounds(this.stackInvalidateRect);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.horizontalOffset == 0 && lp.verticalOffset == 0 || child.getAlpha() == 0.0f || child.getVisibility() != 0) {
                lp.resetInvalidateRect();
            }
            this.stackInvalidateRect.union(lp.getInvalidateRect());
        }
        canvas.save(2);
        canvas.clipRect(this.stackInvalidateRect, Region.Op.UNION);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    public void onLayout() {
        int newSlideAmount;
        if (!this.mFirstLayoutHappened) {
            this.mFirstLayoutHappened = true;
            this.updateChildTransforms();
        }
        if (this.mSlideAmount != (newSlideAmount = Math.round(0.7f * (float)this.getMeasuredHeight()))) {
            this.mSlideAmount = newSlideAmount;
            this.mSwipeThreshold = Math.round(0.2f * (float)newSlideAmount);
        }
        if (Float.compare(this.mPerspectiveShiftY, this.mNewPerspectiveShiftY) != 0 || Float.compare(this.mPerspectiveShiftX, this.mNewPerspectiveShiftX) != 0) {
            this.mPerspectiveShiftY = this.mNewPerspectiveShiftY;
            this.mPerspectiveShiftX = this.mNewPerspectiveShiftX;
            this.updateChildTransforms();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                if (this.mActivePointerId != -1) break;
                this.mInitialX = ev.getX();
                this.mInitialY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex == -1) {
                    Log.d("StackView", "Error: No data for our primary pointer.");
                    return false;
                }
                float newY = ev.getY(pointerIndex);
                float deltaY = newY - this.mInitialY;
                this.beginGestureIfNeeded(deltaY);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
            }
        }
        return this.mSwipeGestureType != 0;
    }

    public void beginGestureIfNeeded(float deltaY) {
        if ((int)Math.abs(deltaY) > this.mTouchSlop && this.mSwipeGestureType == 0) {
            int stackMode;
            boolean beginningOfStack;
            int swipeGestureType = deltaY < 0.0f ? 1 : 2;
            this.cancelLongPress();
            this.requestDisallowInterceptTouchEvent(true);
            if (this.mAdapter == null) {
                return;
            }
            int adapterCount = this.getCount();
            int activeIndex = this.mStackMode == 0 ? (swipeGestureType == 2 ? 0 : 1) : (swipeGestureType == 2 ? 1 : 0);
            boolean endOfStack = this.mLoopViews && adapterCount == 1 && (this.mStackMode == 0 && swipeGestureType == 1 || this.mStackMode == 1 && swipeGestureType == 2);
            boolean bl = beginningOfStack = this.mLoopViews && adapterCount == 1 && (this.mStackMode == 1 && swipeGestureType == 1 || this.mStackMode == 0 && swipeGestureType == 2);
            if (this.mLoopViews && !beginningOfStack && !endOfStack) {
                stackMode = 0;
            } else if (this.mCurrentWindowStartUnbounded + activeIndex == -1 || beginningOfStack) {
                ++activeIndex;
                stackMode = 1;
            } else {
                stackMode = this.mCurrentWindowStartUnbounded + activeIndex == adapterCount - 1 || endOfStack ? 2 : 0;
            }
            this.mTransitionIsSetup = stackMode == 0;
            View v = this.getViewAtRelativeIndex(activeIndex);
            if (v == null) {
                return;
            }
            this.setupStackSlider(v, stackMode);
            this.mSwipeGestureType = swipeGestureType;
            this.cancelHandleClick();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        int action = ev.getAction();
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex == -1) {
            Log.d("StackView", "Error: No data for our primary pointer.");
            return false;
        }
        float newY = ev.getY(pointerIndex);
        float newX = ev.getX(pointerIndex);
        float deltaY = newY - this.mInitialY;
        float deltaX = newX - this.mInitialX;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action & 0xFF) {
            case 2: {
                this.beginGestureIfNeeded(deltaY);
                float rx = deltaX / ((float)this.mSlideAmount * 1.0f);
                if (this.mSwipeGestureType == 2) {
                    float r = (deltaY - (float)this.mTouchSlop * 1.0f) / (float)this.mSlideAmount * 1.0f;
                    if (this.mStackMode == 1) {
                        r = 1.0f - r;
                    }
                    this.mStackSlider.setYProgress(1.0f - r);
                    this.mStackSlider.setXProgress(rx);
                    return true;
                }
                if (this.mSwipeGestureType != 1) break;
                float r = -(deltaY + (float)this.mTouchSlop * 1.0f) / (float)this.mSlideAmount * 1.0f;
                if (this.mStackMode == 1) {
                    r = 1.0f - r;
                }
                this.mStackSlider.setYProgress(r);
                this.mStackSlider.setXProgress(rx);
                return true;
            }
            case 1: {
                this.handlePointerUp(ev);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                this.mSwipeGestureType = 0;
            }
        }
        return true;
    }

    public void onSecondaryPointerUp(MotionEvent ev) {
        int activePointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(activePointerIndex);
        if (pointerId == this.mActivePointerId) {
            int activeViewIndex = this.mSwipeGestureType == 2 ? 0 : 1;
            View v = this.getViewAtRelativeIndex(activeViewIndex);
            if (v == null) {
                return;
            }
            for (int index = 0; index < ev.getPointerCount(); ++index) {
                if (index == activePointerIndex) continue;
                float x = ev.getX(index);
                float y = ev.getY(index);
                this.mTouchRect.set(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
                if (!this.mTouchRect.contains(Math.round(x), Math.round(y))) continue;
                float oldX = ev.getX(activePointerIndex);
                float oldY = ev.getY(activePointerIndex);
                this.mInitialY += y - oldY;
                this.mInitialX += x - oldX;
                this.mActivePointerId = ev.getPointerId(index);
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.clear();
                }
                return;
            }
            this.handlePointerUp(ev);
        }
    }

    public void handlePointerUp(MotionEvent ev) {
        int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        float newY = ev.getY(pointerIndex);
        int deltaY = (int)(newY - this.mInitialY);
        this.mLastInteractionTime = System.currentTimeMillis();
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
            this.mYVelocity = (int)this.mVelocityTracker.getYVelocity(this.mActivePointerId);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (deltaY > this.mSwipeThreshold && this.mSwipeGestureType == 2 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showPrevious();
            } else {
                this.showNext();
            }
            this.mHighlight.bringToFront();
        } else if (deltaY < -this.mSwipeThreshold && this.mSwipeGestureType == 1 && this.mStackSlider.mMode == 0) {
            this.mSwipeGestureType = 0;
            if (this.mStackMode == 0) {
                this.showNext();
            } else {
                this.showPrevious();
            }
            this.mHighlight.bringToFront();
        } else if (this.mSwipeGestureType == 1) {
            float finalYProgress = this.mStackMode == 1 ? 1.0f : 0.0f;
            int duration = this.mStackMode == 0 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            PropertyValuesHolder snapBackY = PropertyValuesHolder.ofFloat("YProgress", finalYProgress);
            PropertyValuesHolder snapBackX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
            ObjectAnimator pa = ObjectAnimator.ofPropertyValuesHolder(animationSlider, snapBackX, snapBackY);
            pa.setDuration(duration);
            pa.setInterpolator(new LinearInterpolator());
            pa.start();
        } else if (this.mSwipeGestureType == 2) {
            float finalYProgress = this.mStackMode == 1 ? 0.0f : 1.0f;
            int duration = this.mStackMode == 1 || this.mStackSlider.mMode != 0 ? Math.round(this.mStackSlider.getDurationForNeutralPosition()) : Math.round(this.mStackSlider.getDurationForOffscreenPosition());
            StackSlider animationSlider = new StackSlider(this.mStackSlider);
            PropertyValuesHolder snapBackY = PropertyValuesHolder.ofFloat("YProgress", finalYProgress);
            PropertyValuesHolder snapBackX = PropertyValuesHolder.ofFloat("XProgress", 0.0f);
            ObjectAnimator pa = ObjectAnimator.ofPropertyValuesHolder(animationSlider, snapBackX, snapBackY);
            pa.setDuration(duration);
            pa.start();
        }
        this.mActivePointerId = -1;
        this.mSwipeGestureType = 0;
    }

    public LayoutParams createOrReuseLayoutParams(View v) {
        ViewGroup.LayoutParams currentLp = v.getLayoutParams();
        if (currentLp instanceof LayoutParams) {
            LayoutParams lp = (LayoutParams)currentLp;
            lp.setHorizontalOffset(0);
            lp.setVerticalOffset(0);
            lp.width = 0;
            lp.width = 0;
            return lp;
        }
        return new LayoutParams(v);
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.checkForAndHandleDataChanged();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childRight = this.mPaddingLeft + child.getMeasuredWidth();
            int childBottom = this.mPaddingTop + child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(this.mPaddingLeft + lp.horizontalOffset, this.mPaddingTop + lp.verticalOffset, childRight + lp.horizontalOffset, childBottom + lp.verticalOffset);
        }
        this.onLayout();
    }

    public void advance() {
        long timeSinceLastInteraction = System.currentTimeMillis() - this.mLastInteractionTime;
        if (this.mAdapter == null) {
            return;
        }
        int adapterCount = this.getCount();
        if (adapterCount == 1 && this.mLoopViews) {
            return;
        }
        if (this.mSwipeGestureType == 0 && timeSinceLastInteraction > 5000L) {
            this.showNext();
        }
    }

    public void measureChildren() {
        int count = this.getChildCount();
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        int childWidth = Math.round((float)measuredWidth * 0.9f) - this.mPaddingLeft - this.mPaddingRight;
        int childHeight = Math.round((float)measuredHeight * 0.9f) - this.mPaddingTop - this.mPaddingBottom;
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.measure(View.MeasureSpec.makeMeasureSpec(childWidth, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(childHeight, Integer.MIN_VALUE));
            if (child == this.mHighlight || child == this.mClickFeedback) continue;
            int childMeasuredWidth = child.getMeasuredWidth();
            int childMeasuredHeight = child.getMeasuredHeight();
            if (childMeasuredWidth > maxWidth) {
                maxWidth = childMeasuredWidth;
            }
            if (childMeasuredHeight <= maxHeight) continue;
            maxHeight = childMeasuredHeight;
        }
        this.mNewPerspectiveShiftX = 0.1f * (float)measuredWidth;
        this.mNewPerspectiveShiftY = 0.1f * (float)measuredHeight;
        if (maxWidth > 0 && count > 0 && maxWidth < childWidth) {
            this.mNewPerspectiveShiftX = measuredWidth - maxWidth;
        }
        if (maxHeight > 0 && count > 0 && maxHeight < childHeight) {
            this.mNewPerspectiveShiftY = measuredHeight - maxHeight;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean haveChildRefSize = this.mReferenceChildWidth != -1 && this.mReferenceChildHeight != -1;
        float factorY = 1.1111112f;
        if (heightSpecMode == 0) {
            heightSpecSize = haveChildRefSize ? Math.round((float)this.mReferenceChildHeight * (1.0f + factorY)) + this.mPaddingTop + this.mPaddingBottom : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE) {
            int height;
            heightSpecSize = haveChildRefSize ? ((height = Math.round((float)this.mReferenceChildHeight * (1.0f + factorY)) + this.mPaddingTop + this.mPaddingBottom) <= heightSpecSize ? height : (heightSpecSize |= 0x1000000)) : 0;
        }
        float factorX = 1.1111112f;
        if (widthSpecMode == 0) {
            widthSpecSize = haveChildRefSize ? Math.round((float)this.mReferenceChildWidth * (1.0f + factorX)) + this.mPaddingLeft + this.mPaddingRight : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE) {
            int width;
            widthSpecSize = haveChildRefSize ? ((width = this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight) <= widthSpecSize ? width : (widthSpecSize |= 0x1000000)) : 0;
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        this.measureChildren();
    }

    public static class HolographicHelper {
        public final Paint mHolographicPaint = new Paint();
        public final Paint mErasePaint = new Paint();
        public final Paint mBlurPaint = new Paint();
        public static final int RES_OUT = 0;
        public static final int CLICK_FEEDBACK = 1;
        public float mDensity;
        public BlurMaskFilter mSmallBlurMaskFilter;
        public BlurMaskFilter mLargeBlurMaskFilter;
        public final Canvas mCanvas = new Canvas();
        public final Canvas mMaskCanvas = new Canvas();
        public final int[] mTmpXY = new int[2];
        public final Matrix mIdentityMatrix = new Matrix();

        public HolographicHelper(Context context) {
            this.mDensity = context.getResources().getDisplayMetrics().density;
            this.mHolographicPaint.setFilterBitmap(true);
            this.mHolographicPaint.setMaskFilter(TableMaskFilter.CreateClipTable(0, 30));
            this.mErasePaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            this.mErasePaint.setFilterBitmap(true);
            this.mSmallBlurMaskFilter = new BlurMaskFilter(2.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
            this.mLargeBlurMaskFilter = new BlurMaskFilter(4.0f * this.mDensity, BlurMaskFilter.Blur.NORMAL);
        }

        public Bitmap createOutline(View v) {
            return this.createOutline(v, 0);
        }

        public Bitmap createOutline(View v, int type) {
            if (type == 0) {
                this.mHolographicPaint.setColor(-10053121);
                this.mBlurPaint.setMaskFilter(this.mSmallBlurMaskFilter);
            } else if (type == 1) {
                this.mHolographicPaint.setColor(-2006541825);
                this.mBlurPaint.setMaskFilter(this.mLargeBlurMaskFilter);
            }
            if (v.getMeasuredWidth() == 0 || v.getMeasuredHeight() == 0) {
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap(v.getMeasuredWidth(), v.getMeasuredHeight(), Bitmap.Config.ARGB_8888);
            this.mCanvas.setBitmap(bitmap);
            float rotationX = v.getRotationX();
            float rotation = v.getRotation();
            float translationY = v.getTranslationY();
            float translationX = v.getTranslationX();
            v.setRotationX(0.0f);
            v.setRotation(0.0f);
            v.setTranslationY(0.0f);
            v.setTranslationX(0.0f);
            v.draw(this.mCanvas);
            v.setRotationX(rotationX);
            v.setRotation(rotation);
            v.setTranslationY(translationY);
            v.setTranslationX(translationX);
            this.drawOutline(this.mCanvas, bitmap);
            return bitmap;
        }

        public void drawOutline(Canvas dest, Bitmap src) {
            int[] xy = this.mTmpXY;
            Bitmap mask = src.extractAlpha(this.mBlurPaint, xy);
            this.mMaskCanvas.setBitmap(mask);
            this.mMaskCanvas.drawBitmap(src, -xy[0], -xy[1], this.mErasePaint);
            dest.drawColor(0, PorterDuff.Mode.CLEAR);
            dest.setMatrix(this.mIdentityMatrix);
            dest.drawBitmap(mask, xy[0], xy[1], this.mHolographicPaint);
            mask.recycle();
        }
    }

    public class LayoutParams
    extends ViewGroup.LayoutParams {
        public int horizontalOffset;
        public int verticalOffset;
        public View mView;
        public final Rect parentRect;
        public final Rect invalidateRect;
        public final RectF invalidateRectf;
        public final Rect globalInvalidateRect;

        public LayoutParams(View view) {
            super(0, 0);
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.width = 0;
            this.height = 0;
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.mView = view;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.parentRect = new Rect();
            this.invalidateRect = new Rect();
            this.invalidateRectf = new RectF();
            this.globalInvalidateRect = new Rect();
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.width = 0;
            this.height = 0;
        }

        public void invalidateGlobalRegion(View v, Rect r) {
            this.globalInvalidateRect.set(r);
            View p = v;
            if (v.getParent() == null || !(v.getParent() instanceof View)) {
                return;
            }
            boolean firstPass = true;
            this.parentRect.set(0, 0, 0, 0);
            int depth = 0;
            while (p.getParent() != null && p.getParent() instanceof View && !this.parentRect.contains(this.globalInvalidateRect)) {
                if (!firstPass) {
                    this.globalInvalidateRect.offset(p.getLeft() - p.getScrollX(), p.getTop() - p.getScrollY());
                    ++depth;
                }
                firstPass = false;
                p = (View)((Object)p.getParent());
                this.parentRect.set(p.getScrollX(), p.getScrollY(), p.getWidth() + p.getScrollX(), p.getHeight() + p.getScrollY());
            }
            p.invalidate(this.globalInvalidateRect.left, this.globalInvalidateRect.top, this.globalInvalidateRect.right, this.globalInvalidateRect.bottom);
        }

        public Rect getInvalidateRect() {
            return this.invalidateRect;
        }

        public void resetInvalidateRect() {
            this.invalidateRect.set(0, 0, 0, 0);
        }

        public void setVerticalOffset(int newVerticalOffset) {
            this.setOffsets(this.horizontalOffset, newVerticalOffset);
        }

        public void setHorizontalOffset(int newHorizontalOffset) {
            this.setOffsets(newHorizontalOffset, this.verticalOffset);
        }

        public void setOffsets(int newHorizontalOffset, int newVerticalOffset) {
            int horizontalOffsetDelta = newHorizontalOffset - this.horizontalOffset;
            this.horizontalOffset = newHorizontalOffset;
            int verticalOffsetDelta = newVerticalOffset - this.verticalOffset;
            this.verticalOffset = newVerticalOffset;
            if (this.mView != null) {
                this.mView.requestLayout();
                int left = Math.min(this.mView.getLeft() + horizontalOffsetDelta, this.mView.getLeft());
                int right = Math.max(this.mView.getRight() + horizontalOffsetDelta, this.mView.getRight());
                int top = Math.min(this.mView.getTop() + verticalOffsetDelta, this.mView.getTop());
                int bottom = Math.max(this.mView.getBottom() + verticalOffsetDelta, this.mView.getBottom());
                this.invalidateRectf.set(left, top, right, bottom);
                float xoffset = -this.invalidateRectf.left;
                float yoffset = -this.invalidateRectf.top;
                this.invalidateRectf.offset(xoffset, yoffset);
                this.mView.getMatrix().mapRect(this.invalidateRectf);
                this.invalidateRectf.offset(-xoffset, -yoffset);
                this.invalidateRect.set((int)Math.floor(this.invalidateRectf.left), (int)Math.floor(this.invalidateRectf.top), (int)Math.ceil(this.invalidateRectf.right), (int)Math.ceil(this.invalidateRectf.bottom));
                this.invalidateGlobalRegion(this.mView, this.invalidateRect);
            }
        }
    }

    public class StackSlider {
        public View mView;
        public float mYProgress;
        public float mXProgress;
        public static final int NORMAL_MODE = 0;
        public static final int BEGINNING_OF_STACK_MODE = 1;
        public static final int END_OF_STACK_MODE = 2;
        public int mMode = 0;

        public StackSlider() {
        }

        public StackSlider(StackSlider copy) {
            this.mView = copy.mView;
            this.mYProgress = copy.mYProgress;
            this.mXProgress = copy.mXProgress;
            this.mMode = copy.mMode;
        }

        public float cubic(float r) {
            return (float)(Math.pow(2.0f * r - 1.0f, 3.0) + 1.0) / 2.0f;
        }

        public float highlightAlphaInterpolator(float r) {
            float pivot = 0.4f;
            if (r < pivot) {
                return 0.85f * this.cubic(r / pivot);
            }
            return 0.85f * this.cubic(1.0f - (r - pivot) / (1.0f - pivot));
        }

        public float viewAlphaInterpolator(float r) {
            float pivot = 0.3f;
            if (r > pivot) {
                return (r - pivot) / (1.0f - pivot);
            }
            return 0.0f;
        }

        public float rotationInterpolator(float r) {
            float pivot = 0.2f;
            if (r < pivot) {
                return 0.0f;
            }
            return (r - pivot) / (1.0f - pivot);
        }

        public void setView(View v) {
            this.mView = v;
        }

        public void setYProgress(float r) {
            int stackDirection;
            r = Math.min(1.0f, r);
            this.mYProgress = r = Math.max(0.0f, r);
            if (this.mView == null) {
                return;
            }
            LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams highlightLp = (LayoutParams)StackView.this.mHighlight.getLayoutParams();
            int n = stackDirection = StackView.this.mStackMode == 0 ? 1 : -1;
            if (Float.compare(0.0f, this.mYProgress) != 0 && Float.compare(1.0f, this.mYProgress) != 0) {
                if (this.mView.getLayerType() == 0) {
                    this.mView.setLayerType(2, null);
                }
            } else if (this.mView.getLayerType() != 0) {
                this.mView.setLayerType(0, null);
            }
            switch (this.mMode) {
                case 0: {
                    viewLp.setVerticalOffset(Math.round(-r * (float)stackDirection * (float)StackView.this.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round(-r * (float)stackDirection * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                    float alpha = this.viewAlphaInterpolator(1.0f - r);
                    if (this.mView.getAlpha() == 0.0f && alpha != 0.0f && this.mView.getVisibility() != 0) {
                        this.mView.setVisibility(0);
                    } else if (alpha == 0.0f && this.mView.getAlpha() != 0.0f && this.mView.getVisibility() == 0) {
                        this.mView.setVisibility(4);
                    }
                    this.mView.setAlpha(alpha);
                    this.mView.setRotationX((float)stackDirection * 90.0f * this.rotationInterpolator(r));
                    StackView.this.mHighlight.setRotationX((float)stackDirection * 90.0f * this.rotationInterpolator(r));
                    break;
                }
                case 2: {
                    viewLp.setVerticalOffset(Math.round((float)(-stackDirection) * (r *= 0.2f) * (float)StackView.this.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round((float)(-stackDirection) * r * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                    break;
                }
                case 1: {
                    r = (1.0f - r) * 0.2f;
                    viewLp.setVerticalOffset(Math.round((float)stackDirection * r * (float)StackView.this.mSlideAmount));
                    highlightLp.setVerticalOffset(Math.round((float)stackDirection * r * (float)StackView.this.mSlideAmount));
                    StackView.this.mHighlight.setAlpha(this.highlightAlphaInterpolator(r));
                }
            }
        }

        public void setXProgress(float r) {
            r = Math.min(2.0f, r);
            this.mXProgress = r = Math.max(-2.0f, r);
            if (this.mView == null) {
                return;
            }
            LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
            LayoutParams highlightLp = (LayoutParams)StackView.this.mHighlight.getLayoutParams();
            viewLp.setHorizontalOffset(Math.round((r *= 0.2f) * (float)StackView.this.mSlideAmount));
            highlightLp.setHorizontalOffset(Math.round(r * (float)StackView.this.mSlideAmount));
        }

        public void setMode(int mode) {
            this.mMode = mode;
        }

        public float getDurationForNeutralPosition() {
            return this.getDuration(false, 0.0f);
        }

        public float getDurationForOffscreenPosition() {
            return this.getDuration(true, 0.0f);
        }

        public float getDurationForNeutralPosition(float velocity) {
            return this.getDuration(false, velocity);
        }

        public float getDurationForOffscreenPosition(float velocity) {
            return this.getDuration(true, velocity);
        }

        public float getDuration(boolean invert, float velocity) {
            if (this.mView != null) {
                float duration;
                LayoutParams viewLp = (LayoutParams)this.mView.getLayoutParams();
                float d = (float)Math.sqrt(Math.pow(viewLp.horizontalOffset, 2.0) + Math.pow(viewLp.verticalOffset, 2.0));
                float maxd = (float)Math.sqrt(Math.pow(StackView.this.mSlideAmount, 2.0) + Math.pow(0.4f * (float)StackView.this.mSlideAmount, 2.0));
                if (velocity == 0.0f) {
                    return (invert ? 1.0f - d / maxd : d / maxd) * 400.0f;
                }
                float f = duration = invert ? d / Math.abs(velocity) : (maxd - d) / Math.abs(velocity);
                if (duration < 50.0f || duration > 400.0f) {
                    return this.getDuration(invert, 0.0f);
                }
                return duration;
            }
            return 0.0f;
        }

        public float getYProgress() {
            return this.mYProgress;
        }

        public float getXProgress() {
            return this.mXProgress;
        }
    }

    public static class StackFrame
    extends FrameLayout {
        public WeakReference<ObjectAnimator> alphaAnimator;
        public WeakReference<ObjectAnimator> transformAnimator;
        public WeakReference<ObjectAnimator> sliderAnimator;

        public StackFrame(Context context) {
            super(context);
        }

        public void setAlphaAnimator(ObjectAnimator oa) {
            this.alphaAnimator = new WeakReference<ObjectAnimator>(oa);
        }

        public void setTransformAnimator(ObjectAnimator oa) {
            this.transformAnimator = new WeakReference<ObjectAnimator>(oa);
        }

        public void setSliderAnimator(ObjectAnimator oa) {
            this.sliderAnimator = new WeakReference<ObjectAnimator>(oa);
        }

        public boolean cancelAlphaAnimator() {
            ObjectAnimator oa;
            if (this.alphaAnimator != null && (oa = (ObjectAnimator)this.alphaAnimator.get()) != null) {
                oa.cancel();
                return true;
            }
            return false;
        }

        public boolean cancelTransformAnimator() {
            ObjectAnimator oa;
            if (this.transformAnimator != null && (oa = (ObjectAnimator)this.transformAnimator.get()) != null) {
                oa.cancel();
                return true;
            }
            return false;
        }

        public boolean cancelSliderAnimator() {
            ObjectAnimator oa;
            if (this.sliderAnimator != null && (oa = (ObjectAnimator)this.sliderAnimator.get()) != null) {
                oa.cancel();
                return true;
            }
            return false;
        }
    }
}

