/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.android.internal.R;

public class TabWidget
extends LinearLayout
implements View.OnFocusChangeListener {
    public OnTabSelectionChanged mSelectionChangedListener;
    public int mSelectedTab = -1;
    public Drawable mLeftStrip;
    public Drawable mRightStrip;
    public boolean mDrawBottomStrips = true;
    public boolean mStripMoved;
    public Drawable mDividerDrawable;
    public final Rect mBounds = new Rect();
    public int mImposedTabsHeight = -1;
    public int[] mImposedTabWidths;

    public TabWidget(Context context) {
        this(context, null);
    }

    public TabWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 16842883);
    }

    public TabWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabWidget, defStyle, 0);
        this.mDrawBottomStrips = a.getBoolean(3, true);
        this.mDividerDrawable = a.getDrawable(0);
        this.mLeftStrip = a.getDrawable(1);
        this.mRightStrip = a.getDrawable(2);
        a.recycle();
        this.initTabWidget();
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mStripMoved = true;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public int getChildDrawingOrder(int childCount, int i) {
        if (this.mSelectedTab == -1) {
            return i;
        }
        if (i == childCount - 1) {
            return this.mSelectedTab;
        }
        if (i >= this.mSelectedTab) {
            return i + 1;
        }
        return i;
    }

    public void initTabWidget() {
        this.mGroupFlags |= 0x400;
        Context context = this.mContext;
        Resources resources = context.getResources();
        if (context.getApplicationInfo().targetSdkVersion <= 4) {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = resources.getDrawable(17302806);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = resources.getDrawable(17302808);
            }
        } else {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = resources.getDrawable(17302805);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = resources.getDrawable(17302807);
            }
        }
        this.setFocusable(true);
        this.setOnFocusChangeListener(this);
    }

    public void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (this.mImposedTabsHeight >= 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(totalWidth + this.mImposedTabWidths[childIndex], 0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mImposedTabsHeight, 0x40000000);
        }
        super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    public void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int unspecifiedWidth = View.MeasureSpec.makeMeasureSpec(0, 0);
        this.mImposedTabsHeight = -1;
        super.measureHorizontal(unspecifiedWidth, heightMeasureSpec);
        int extraWidth = this.getMeasuredWidth() - View.MeasureSpec.getSize(widthMeasureSpec);
        if (extraWidth > 0) {
            View child;
            int i;
            int count = this.getChildCount();
            int childCount = 0;
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                ++childCount;
            }
            if (childCount > 0) {
                if (this.mImposedTabWidths == null || this.mImposedTabWidths.length != count) {
                    this.mImposedTabWidths = new int[count];
                }
                for (i = 0; i < count; ++i) {
                    int newWidth;
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    int childWidth = child.getMeasuredWidth();
                    int delta = extraWidth / childCount;
                    this.mImposedTabWidths[i] = newWidth = Math.max(0, childWidth - delta);
                    extraWidth -= childWidth - newWidth;
                    --childCount;
                    this.mImposedTabsHeight = Math.max(this.mImposedTabsHeight, child.getMeasuredHeight());
                }
            }
        }
        if (this.mImposedTabsHeight >= 0 || unspecifiedWidth != widthMeasureSpec) {
            super.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public View getChildTabViewAt(int index) {
        if (this.mDividerDrawable != null) {
            index *= 2;
        }
        return this.getChildAt(index);
    }

    public int getTabCount() {
        int children = this.getChildCount();
        if (this.mDividerDrawable != null) {
            children = (children + 1) / 2;
        }
        return children;
    }

    public void setDividerDrawable(Drawable drawable2) {
        this.mDividerDrawable = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setDividerDrawable(int resId) {
        this.mDividerDrawable = this.mContext.getResources().getDrawable(resId);
        this.requestLayout();
        this.invalidate();
    }

    public void setLeftStripDrawable(Drawable drawable2) {
        this.mLeftStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setLeftStripDrawable(int resId) {
        this.mLeftStrip = this.mContext.getResources().getDrawable(resId);
        this.requestLayout();
        this.invalidate();
    }

    public void setRightStripDrawable(Drawable drawable2) {
        this.mRightStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setRightStripDrawable(int resId) {
        this.mRightStrip = this.mContext.getResources().getDrawable(resId);
        this.requestLayout();
        this.invalidate();
    }

    public void setStripEnabled(boolean stripEnabled) {
        this.mDrawBottomStrips = stripEnabled;
        this.invalidate();
    }

    public boolean isStripEnabled() {
        return this.mDrawBottomStrips;
    }

    public void childDrawableStateChanged(View child) {
        if (this.getTabCount() > 0 && child == this.getChildTabViewAt(this.mSelectedTab)) {
            this.invalidate();
        }
        super.childDrawableStateChanged(child);
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getTabCount() == 0) {
            return;
        }
        if (!this.mDrawBottomStrips) {
            return;
        }
        View selectedChild = this.getChildTabViewAt(this.mSelectedTab);
        Drawable leftStrip = this.mLeftStrip;
        Drawable rightStrip = this.mRightStrip;
        leftStrip.setState(selectedChild.getDrawableState());
        rightStrip.setState(selectedChild.getDrawableState());
        if (this.mStripMoved) {
            Rect bounds = this.mBounds;
            bounds.left = selectedChild.getLeft();
            bounds.right = selectedChild.getRight();
            int myHeight = this.getHeight();
            leftStrip.setBounds(Math.min(0, bounds.left - leftStrip.getIntrinsicWidth()), myHeight - leftStrip.getIntrinsicHeight(), bounds.left, myHeight);
            rightStrip.setBounds(bounds.right, myHeight - rightStrip.getIntrinsicHeight(), Math.max(this.getWidth(), bounds.right + rightStrip.getIntrinsicWidth()), myHeight);
            this.mStripMoved = false;
        }
        leftStrip.draw(canvas);
        rightStrip.draw(canvas);
    }

    public void setCurrentTab(int index) {
        if (index < 0 || index >= this.getTabCount() || index == this.mSelectedTab) {
            return;
        }
        if (this.mSelectedTab != -1) {
            this.getChildTabViewAt(this.mSelectedTab).setSelected(false);
        }
        this.mSelectedTab = index;
        this.getChildTabViewAt(this.mSelectedTab).setSelected(true);
        this.mStripMoved = true;
        if (this.isShown()) {
            this.sendAccessibilityEvent(4);
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.setItemCount(this.getTabCount());
        event.setCurrentItemIndex(this.mSelectedTab);
        if (this.mSelectedTab != -1) {
            this.getChildTabViewAt(this.mSelectedTab).dispatchPopulateAccessibilityEvent(event);
        }
        return true;
    }

    public void focusCurrentTab(int index) {
        int oldTab = this.mSelectedTab;
        this.setCurrentTab(index);
        if (oldTab != index) {
            this.getChildTabViewAt(index).requestFocus();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildTabViewAt(i);
            child.setEnabled(enabled);
        }
    }

    public void addView(View child) {
        if (child.getLayoutParams() == null) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1, 1.0f);
            lp.setMargins(0, 0, 0, 0);
            child.setLayoutParams(lp);
        }
        child.setFocusable(true);
        child.setClickable(true);
        if (this.mDividerDrawable != null && this.getTabCount() > 0) {
            ImageView divider = new ImageView(this.mContext);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(this.mDividerDrawable.getIntrinsicWidth(), -1);
            lp.setMargins(0, 0, 0, 0);
            divider.setLayoutParams(lp);
            divider.setBackgroundDrawable(this.mDividerDrawable);
            super.addView(divider);
        }
        super.addView(child);
        child.setOnClickListener(new TabClickListener(this.getTabCount() - 1, null));
        child.setOnFocusChangeListener(this);
    }

    public void sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (event.getEventType() == 8 && this.isFocused()) {
            return;
        }
        super.sendAccessibilityEventUnchecked(event);
    }

    public void setTabSelectionListener(OnTabSelectionChanged listener) {
        this.mSelectionChangedListener = listener;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v == this && hasFocus && this.getTabCount() > 0) {
            this.getChildTabViewAt(this.mSelectedTab).requestFocus();
            return;
        }
        if (hasFocus) {
            int numTabs = this.getTabCount();
            for (int i = 0; i < numTabs; ++i) {
                if (this.getChildTabViewAt(i) != v) continue;
                this.setCurrentTab(i);
                this.mSelectionChangedListener.onTabSelectionChanged(i, false);
                if (!this.isShown()) break;
                this.sendAccessibilityEvent(8);
                break;
            }
        }
    }

    public static class 1 {
    }

    public static interface OnTabSelectionChanged {
        public void onTabSelectionChanged(int var1, boolean var2);
    }

    public class TabClickListener
    implements View.OnClickListener {
        public final int mTabIndex;

        public TabClickListener(int tabIndex) {
            this.mTabIndex = tabIndex;
        }

        public void onClick(View v) {
            TabWidget.this.mSelectionChangedListener.onTabSelectionChanged(this.mTabIndex, true);
        }

        public /* synthetic */ TabClickListener(int x1, 1 x2) {
            this(x1);
        }
    }
}

