/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.WspTypeDecoder;

public class WapPushOverSms {
    public static final String LOG_TAG = "WAP PUSH";
    public final Context mContext;
    public WspTypeDecoder pduDecoder;
    public SMSDispatcher mSmsDispatcher;
    public final int WAKE_LOCK_TIMEOUT = 5000;

    public WapPushOverSms(Phone phone, SMSDispatcher smsDispatcher) {
        this.mSmsDispatcher = smsDispatcher;
        this.mContext = phone.getContext();
    }

    public int dispatchWapPdu(byte[] pdu) {
        byte[] intentData;
        int index = 0;
        int transactionId = pdu[index++] & 0xFF;
        int pduType = pdu[index++] & 0xFF;
        int headerLength = 0;
        if (pduType != 6 && pduType != 7) {
            return 1;
        }
        this.pduDecoder = new WspTypeDecoder(pdu);
        if (!this.pduDecoder.decodeUintvarInteger(index)) {
            return 2;
        }
        headerLength = (int)this.pduDecoder.getValue32();
        int headerStartIndex = index += this.pduDecoder.getDecodedDataLength();
        if (!this.pduDecoder.decodeContentType(index)) {
            return 2;
        }
        String mimeType = this.pduDecoder.getValueString();
        index += this.pduDecoder.getDecodedDataLength();
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        if (mimeType.equals("application/vnd.wap.coc")) {
            intentData = pdu;
        } else {
            int dataIndex = headerStartIndex + headerLength;
            intentData = new byte[pdu.length - dataIndex];
            System.arraycopy(pdu, dataIndex, intentData, 0, intentData.length);
        }
        String permission2 = mimeType.equals("application/vnd.wap.mms-message") ? "android.permission.RECEIVE_MMS" : "android.permission.RECEIVE_WAP_PUSH";
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_RECEIVED");
        intent.setType(mimeType);
        intent.putExtra("transactionId", transactionId);
        intent.putExtra("pduType", pduType);
        intent.putExtra("header", header);
        intent.putExtra("data", intentData);
        intent.putExtra("contentTypeParameters", this.pduDecoder.getContentParameters());
        this.mSmsDispatcher.dispatch(intent, permission2);
        return -1;
    }
}

