/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.RestrictedState;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class GsmServiceStateTracker
extends ServiceStateTracker {
    public static final String LOG_TAG = "GSM";
    public static final boolean DBG = true;
    public GSMPhone phone;
    public GsmCellLocation cellLoc;
    public GsmCellLocation newCellLoc;
    public int mPreferredNetworkType;
    public RestrictedState rs;
    public int gprsState = 1;
    public int newGPRSState = 1;
    public int networkType = 0;
    public int newNetworkType = 0;
    public boolean mGsmRoaming = false;
    public boolean mDataRoaming = false;
    public boolean mEmergencyOnly = false;
    public RegistrantList gprsAttachedRegistrants = new RegistrantList();
    public RegistrantList gprsDetachedRegistrants = new RegistrantList();
    public RegistrantList psRestrictEnabledRegistrants = new RegistrantList();
    public RegistrantList psRestrictDisabledRegistrants = new RegistrantList();
    public boolean mNeedFixZone = false;
    public int mZoneOffset;
    public boolean mZoneDst;
    public long mZoneTime;
    public boolean mGotCountryCode = false;
    public ContentResolver cr;
    public String mSavedTimeZone;
    public long mSavedTime;
    public long mSavedAtTime;
    public boolean mNeedToRegForSimLoaded;
    public boolean mStartedGprsRegCheck = false;
    public boolean mReportedGprsNoReg = false;
    public Notification mNotification;
    public PowerManager.WakeLock mWakeLock;
    public static final String WAKELOCK_TAG = "ServiceStateTracker";
    public String curSpn = null;
    public String curPlmn = null;
    public int curSpnRule = 0;
    public static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    public static final int PS_ENABLED = 1001;
    public static final int PS_DISABLED = 1002;
    public static final int CS_ENABLED = 1003;
    public static final int CS_DISABLED = 1004;
    public static final int CS_NORMAL_ENABLED = 1005;
    public static final int CS_EMERGENCY_ENABLED = 1006;
    public static final int PS_NOTIFICATION = 888;
    public static final int CS_NOTIFICATION = 999;
    public static final int MAX_NUM_DATA_STATE_READS = 15;
    public BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.LOCALE_CHANGED")) {
                GsmServiceStateTracker.this.updateSpnDisplay();
            }
        }
    };
    public ContentObserver mAutoTimeObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            Log.i("GsmServiceStateTracker", "Auto time state changed");
            GsmServiceStateTracker.this.revertToNitzTime();
        }
    };
    public ContentObserver mAutoTimeZoneObserver = new ContentObserver(new Handler()){

        public void onChange(boolean selfChange) {
            Log.i("GsmServiceStateTracker", "Auto time zone state changed");
            GsmServiceStateTracker.this.revertToNitzTimeZone();
        }
    };

    public GsmServiceStateTracker(GSMPhone phone) {
        this.phone = phone;
        this.cm = phone.mCM;
        this.ss = new ServiceState();
        this.newSS = new ServiceState();
        this.cellLoc = new GsmCellLocation();
        this.newCellLoc = new GsmCellLocation();
        this.rs = new RestrictedState();
        this.mSignalStrength = new SignalStrength();
        PowerManager powerManager = (PowerManager)phone.getContext().getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.cm.registerForAvailable(this, 13, null);
        this.cm.registerForRadioStateChanged(this, 1, null);
        this.cm.registerForNetworkStateChanged(this, 2, null);
        this.cm.setOnNITZTime(this, 11, null);
        this.cm.setOnSignalStrengthUpdate(this, 12, null);
        this.cm.setOnRestrictedStateChanged(this, 23, null);
        this.cm.registerForSIMReady(this, 17, null);
        int airplaneMode = Settings.System.getInt(phone.getContext().getContentResolver(), "airplane_mode_on", 0);
        this.mDesiredPowerState = airplaneMode <= 0;
        this.cr = phone.getContext().getContentResolver();
        this.cr.registerContentObserver(Settings.System.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.cr.registerContentObserver(Settings.System.getUriFor("auto_time_zone"), true, this.mAutoTimeZoneObserver);
        this.setSignalStrengthDefaultValues();
        this.mNeedToRegForSimLoaded = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.LOCALE_CHANGED");
        phone.getContext().registerReceiver(this.mIntentReceiver, filter);
        phone.notifyOtaspChanged(3);
    }

    public void dispose() {
        this.cm.unregisterForAvailable(this);
        this.cm.unregisterForRadioStateChanged(this);
        this.cm.unregisterForNetworkStateChanged(this);
        this.cm.unregisterForSIMReady(this);
        this.phone.mSIMRecords.unregisterForRecordsLoaded(this);
        this.cm.unSetOnSignalStrengthUpdate(this);
        this.cm.unSetOnRestrictedStateChanged(this);
        this.cm.unSetOnNITZTime(this);
        this.cr.unregisterContentObserver(this.mAutoTimeObserver);
        this.cr.unregisterContentObserver(this.mAutoTimeZoneObserver);
    }

    public void finalize() {
        Log.d(LOG_TAG, "GsmServiceStateTracker finalized");
    }

    public Phone getPhone() {
        return this.phone;
    }

    public void registerForGprsAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.gprsAttachedRegistrants.add(r);
        if (this.gprsState == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForGprsAttached(Handler h) {
        this.gprsAttachedRegistrants.remove(h);
    }

    public void registerForNetworkAttach(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.networkAttachedRegistrants.add(r);
        if (this.ss.getState() == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkAttach(Handler h) {
        this.networkAttachedRegistrants.remove(h);
    }

    public void registerForGprsDetached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.gprsDetachedRegistrants.add(r);
        if (this.gprsState == 1) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForGprsDetached(Handler h) {
        this.gprsDetachedRegistrants.remove(h);
    }

    public void registerForPsRestrictedEnabled(Handler h, int what, Object obj) {
        Log.d(LOG_TAG, "[DSAC DEB] registerForPsRestrictedEnabled ");
        Registrant r = new Registrant(h, what, obj);
        this.psRestrictEnabledRegistrants.add(r);
        if (this.rs.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedEnabled(Handler h) {
        this.psRestrictEnabledRegistrants.remove(h);
    }

    public void registerForPsRestrictedDisabled(Handler h, int what, Object obj) {
        Log.d(LOG_TAG, "[DSAC DEB] registerForPsRestrictedDisabled ");
        Registrant r = new Registrant(h, what, obj);
        this.psRestrictDisabledRegistrants.add(r);
        if (this.rs.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedDisabled(Handler h) {
        this.psRestrictDisabledRegistrants.remove(h);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 13: {
                break;
            }
            case 17: {
                boolean skipRestoringSelection;
                if (this.mNeedToRegForSimLoaded) {
                    this.phone.mSIMRecords.registerForRecordsLoaded(this, 16, null);
                    this.mNeedToRegForSimLoaded = false;
                }
                if (!(skipRestoringSelection = this.phone.getContext().getResources().getBoolean(0x1110021))) {
                    this.phone.restoreSavedNetworkSelection(null);
                }
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 1: {
                this.setPowerStateToDesired();
                this.pollState();
                break;
            }
            case 2: {
                this.pollState();
                break;
            }
            case 3: {
                if (!this.cm.getRadioState().isOn() || this.cm.getRadioState().isCdma()) {
                    return;
                }
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSignalStrengthResult(ar);
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 15: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    String[] states = (String[])ar.result;
                    int lac = -1;
                    int cid = -1;
                    if (states.length >= 3) {
                        try {
                            if (states[1] != null && states[1].length() > 0) {
                                lac = Integer.parseInt(states[1], 16);
                            }
                            if (states[2] != null && states[2].length() > 0) {
                                cid = Integer.parseInt(states[2], 16);
                            }
                        }
                        catch (NumberFormatException ex) {
                            Log.w(LOG_TAG, "error parsing location: " + ex);
                        }
                    }
                    this.cellLoc.setLacAndCid(lac, cid);
                    this.phone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 10: {
                this.cm.getSignalStrength(this.obtainMessage(3));
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String nitzString = (String)((Object[])ar.result)[0];
                long nitzReceiveTime = (Long)((Object[])ar.result)[1];
                this.setTimeFromNITZString(nitzString, nitzReceiveTime);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.dontPollSignalStrength = true;
                this.onSignalStrengthResult(ar);
                break;
            }
            case 16: {
                this.updateSpnDisplay();
                break;
            }
            case 18: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.cm.getRegistrationState(this.obtainMessage(15, null));
                break;
            }
            case 20: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Message message = this.obtainMessage(21, ar.userObj);
                this.cm.setPreferredNetworkType(this.mPreferredNetworkType, message);
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj == null) break;
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 19: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mPreferredNetworkType = ar.exception == null ? ((int[])ar.result)[0] : 7;
                Message message = this.obtainMessage(20, ar.userObj);
                int toggledNetworkType = 7;
                this.cm.setPreferredNetworkType(toggledNetworkType, message);
                break;
            }
            case 22: {
                if (this.ss != null && !this.isGprsConsistent(this.gprsState, this.ss.getState())) {
                    GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
                    EventLog.writeEvent(50107, this.ss.getOperatorNumeric(), loc != null ? loc.getCid() : -1);
                    this.mReportedGprsNoReg = true;
                }
                this.mStartedGprsRegCheck = false;
                break;
            }
            case 23: {
                Log.d(LOG_TAG, "[DSAC DEB] EVENT_RESTRICTED_STATE_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onRestrictedStateChanged(ar);
                break;
            }
            default: {
                Log.e(LOG_TAG, "Unhandled message with number: " + msg.what);
            }
        }
    }

    public void setPowerStateToDesired() {
        if (this.mDesiredPowerState && this.cm.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.cm.setRadioPower(true, null);
        } else if (!this.mDesiredPowerState && this.cm.getRadioState().isOn()) {
            DataConnectionTracker dcTracker = this.phone.mDataConnection;
            if (!dcTracker.isDataConnectionAsDesired()) {
                EventLog.writeEvent(50108, dcTracker.getStateInString(), dcTracker.getAnyDataEnabled() ? 1 : 0);
            }
            this.powerOffRadioSafely();
        }
    }

    public void powerOffRadioSafely() {
        DataConnectionTracker dcTracker = this.phone.mDataConnection;
        Message msg = dcTracker.obtainMessage(34);
        msg.arg1 = 1;
        msg.obj = "radioTurnedOff";
        dcTracker.sendMessage(msg);
        for (int i = 0; i < 15; ++i) {
            if (dcTracker.getState() != DataConnectionTracker.State.CONNECTED && dcTracker.getState() != DataConnectionTracker.State.DISCONNECTING) {
                Log.d(LOG_TAG, "Data shutdown complete.");
                break;
            }
            SystemClock.sleep(100L);
        }
        if (this.phone.isInCall()) {
            this.phone.mCT.ringingCall.hangupIfAlive();
            this.phone.mCT.backgroundCall.hangupIfAlive();
            this.phone.mCT.foregroundCall.hangupIfAlive();
        }
        this.cm.setRadioPower(false, null);
    }

    public void updateSpnDisplay() {
        int rule = this.phone.mSIMRecords.getDisplayRule(this.ss.getOperatorNumeric());
        String spn = this.phone.mSIMRecords.getServiceProviderName();
        String plmn = this.ss.getOperatorAlphaLong();
        if (this.mEmergencyOnly && this.cm.getRadioState().isOn()) {
            plmn = ((Object)Resources.getSystem().getText(17040051)).toString();
            Log.d(LOG_TAG, "updateSpnDisplay: emergency only and radio is on plmn='" + plmn + "'");
        }
        if (rule != this.curSpnRule || !TextUtils.equals(spn, this.curSpn) || !TextUtils.equals(plmn, this.curPlmn)) {
            boolean showSpn = !this.mEmergencyOnly && !TextUtils.isEmpty(spn) && (rule & 1) == 1;
            boolean showPlmn = !TextUtils.isEmpty(plmn) && (rule & 2) == 2;
            Log.d(LOG_TAG, String.format("updateSpnDisplay: changed sending intent rule=" + rule + " showPlmn='%b' plmn='%s' showSpn='%b' spn='%s'", showPlmn, plmn, showSpn, spn));
            Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
            intent.addFlags(0x20000000);
            intent.putExtra("showSpn", showSpn);
            intent.putExtra("spn", spn);
            intent.putExtra("showPlmn", showPlmn);
            intent.putExtra("plmn", plmn);
            this.phone.getContext().sendStickyBroadcast(intent);
        }
        this.curSpnRule = rule;
        this.curSpn = spn;
        this.curPlmn = plmn;
    }

    public void handlePollStateResult(int what, AsyncResult ar) {
        if (ar.userObj != this.pollingContext) {
            return;
        }
        if (ar.exception != null) {
            CommandException.Error err = null;
            if (ar.exception instanceof CommandException) {
                err = ((CommandException)ar.exception).getCommandError();
            }
            if (err == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.cancelPollState();
                return;
            }
            if (!this.cm.getRadioState().isOn()) {
                this.cancelPollState();
                return;
            }
            if (err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW && err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) {
                Log.e(LOG_TAG, "RIL implementation has returned an error where it must succeed" + ar.exception);
            }
        } else {
            try {
                switch (what) {
                    case 4: {
                        String[] states = (String[])ar.result;
                        int lac = -1;
                        int cid = -1;
                        int regState = -1;
                        int psc = -1;
                        if (states.length > 0) {
                            try {
                                regState = Integer.parseInt(states[0]);
                                if (states.length >= 3) {
                                    if (states[1] != null && states[1].length() > 0) {
                                        lac = Integer.parseInt(states[1], 16);
                                    }
                                    if (states[2] != null && states[2].length() > 0) {
                                        cid = Integer.parseInt(states[2], 16);
                                    }
                                }
                                if (states.length > 14 && states[14] != null && states[14].length() > 0) {
                                    psc = Integer.parseInt(states[14], 16);
                                }
                            }
                            catch (NumberFormatException ex) {
                                Log.w(LOG_TAG, "error parsing RegistrationState: " + ex);
                            }
                        }
                        this.mGsmRoaming = this.regCodeIsRoaming(regState);
                        this.newSS.setState(this.regCodeToServiceState(regState));
                        this.mEmergencyOnly = regState == 10 || regState == 12 || regState == 13 || regState == 14;
                        this.newCellLoc.setLacAndCid(lac, cid);
                        this.newCellLoc.setPsc(psc);
                        break;
                    }
                    case 5: {
                        String[] states = (String[])ar.result;
                        int type = 0;
                        int regState = -1;
                        if (states.length > 0) {
                            try {
                                regState = Integer.parseInt(states[0]);
                                if (states.length >= 4 && states[3] != null) {
                                    type = Integer.parseInt(states[3]);
                                }
                            }
                            catch (NumberFormatException ex) {
                                Log.w(LOG_TAG, "error parsing GprsRegistrationState: " + ex);
                            }
                        }
                        this.newGPRSState = this.regCodeToServiceState(regState);
                        this.mDataRoaming = this.regCodeIsRoaming(regState);
                        this.newNetworkType = type;
                        this.newSS.setRadioTechnology(type);
                        break;
                    }
                    case 6: {
                        String[] opNames = (String[])ar.result;
                        if (opNames == null || opNames.length < 3) break;
                        this.newSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                        break;
                    }
                    case 14: {
                        int[] ints = (int[])ar.result;
                        this.newSS.setIsManualSelection(ints[0] == 1);
                    }
                }
            }
            catch (RuntimeException ex) {
                Log.e(LOG_TAG, "Exception while polling service state. Probably malformed RIL response.", ex);
            }
        }
        this.pollingContext[0] = this.pollingContext[0] - 1;
        if (this.pollingContext[0] == 0) {
            boolean roaming;
            boolean bl = roaming = this.mGsmRoaming || this.mDataRoaming;
            if (this.mGsmRoaming && !this.isRoamingBetweenOperators(this.mGsmRoaming, this.newSS)) {
                roaming = false;
            }
            this.newSS.setRoaming(roaming);
            this.newSS.setEmergencyOnly(this.mEmergencyOnly);
            this.pollStateDone();
        }
    }

    public void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(99, -1, -1, -1, -1, -1, -1, true);
    }

    public void pollState() {
        this.pollingContext = new int[1];
        this.pollingContext[0] = 0;
        switch (this.cm.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case RUIM_NOT_READY: 
            case RUIM_READY: 
            case RUIM_LOCKED_OR_ABSENT: 
            case NV_NOT_READY: 
            case NV_READY: {
                Log.d(LOG_TAG, "Radio Technology Change ongoing, setting SS to off");
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                break;
            }
            default: {
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getOperator(this.obtainMessage(6, this.pollingContext));
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getGPRSRegistrationState(this.obtainMessage(5, this.pollingContext));
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getRegistrationState(this.obtainMessage(4, this.pollingContext));
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getNetworkSelectionMode(this.obtainMessage(14, this.pollingContext));
            }
        }
    }

    public static String networkTypeToString(int type) {
        String ret = "unknown";
        switch (type) {
            case 1: {
                ret = "GPRS";
                break;
            }
            case 2: {
                ret = "EDGE";
                break;
            }
            case 3: {
                ret = "UMTS";
                break;
            }
            case 9: {
                ret = "HSDPA";
                break;
            }
            case 10: {
                ret = "HSUPA";
                break;
            }
            case 11: {
                ret = "HSPA";
                break;
            }
            default: {
                Log.e(LOG_TAG, "Wrong network type: " + Integer.toString(type));
            }
        }
        return ret;
    }

    public void pollStateDone() {
        boolean hasLocationChanged;
        Log.d(LOG_TAG, "Poll ServiceState done:  oldSS=[" + this.ss + "] newSS=[" + this.newSS + "] oldGprs=" + this.gprsState + " newGprs=" + this.newGPRSState + " oldType=" + GsmServiceStateTracker.networkTypeToString(this.networkType) + " newType=" + GsmServiceStateTracker.networkTypeToString(this.newNetworkType));
        boolean hasRegistered = this.ss.getState() != 0 && this.newSS.getState() == 0;
        boolean hasDeregistered = this.ss.getState() == 0 && this.newSS.getState() != 0;
        boolean hasGprsAttached = this.gprsState != 0 && this.newGPRSState == 0;
        boolean hasGprsDetached = this.gprsState == 0 && this.newGPRSState != 0;
        boolean hasNetworkTypeChanged = this.networkType != this.newNetworkType;
        boolean hasChanged = !this.newSS.equals(this.ss);
        boolean hasRoamingOn = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean hasRoamingOff = this.ss.getRoaming() && !this.newSS.getRoaming();
        boolean bl = hasLocationChanged = !this.newCellLoc.equals(this.cellLoc);
        if (this.ss.getState() != this.newSS.getState() || this.gprsState != this.newGPRSState) {
            EventLog.writeEvent(50114, this.ss.getState(), this.gprsState, this.newSS.getState(), this.newGPRSState);
        }
        ServiceState tss = this.ss;
        this.ss = this.newSS;
        this.newSS = tss;
        this.newSS.setStateOutOfService();
        GsmCellLocation tcl = this.cellLoc;
        this.cellLoc = this.newCellLoc;
        this.newCellLoc = tcl;
        if (hasNetworkTypeChanged) {
            int cid = -1;
            GsmCellLocation loc = (GsmCellLocation)this.phone.getCellLocation();
            if (loc != null) {
                cid = loc.getCid();
            }
            EventLog.writeEvent(50112, cid, this.networkType, this.newNetworkType);
            Log.d(LOG_TAG, "RAT switched " + GsmServiceStateTracker.networkTypeToString(this.networkType) + " -> " + GsmServiceStateTracker.networkTypeToString(this.newNetworkType) + " at cell " + cid);
        }
        this.gprsState = this.newGPRSState;
        this.networkType = this.newNetworkType;
        this.newNetworkType = 0;
        this.newSS.setStateOutOfService();
        if (hasNetworkTypeChanged) {
            this.phone.setSystemProperty("gsm.network.type", GsmServiceStateTracker.networkTypeToString(this.networkType));
        }
        if (hasRegistered) {
            this.networkAttachedRegistrants.notifyRegistrants();
        }
        if (hasChanged) {
            this.updateSpnDisplay();
            this.phone.setSystemProperty("gsm.operator.alpha", this.ss.getOperatorAlphaLong());
            String operatorNumeric = this.ss.getOperatorNumeric();
            this.phone.setSystemProperty("gsm.operator.numeric", operatorNumeric);
            if (operatorNumeric == null) {
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
            } else {
                String iso = "";
                try {
                    iso = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
                }
                catch (NumberFormatException ex) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    Log.w(LOG_TAG, "countryCodeForMcc error" + ex);
                }
                this.phone.setSystemProperty("gsm.operator.iso-country", iso);
                this.mGotCountryCode = true;
                if (this.mNeedFixZone) {
                    TimeZone zone = null;
                    String zoneName = SystemProperties.get("persist.sys.timezone");
                    if (this.mZoneOffset == 0 && !this.mZoneDst && zoneName != null && zoneName.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, iso) < 0) {
                        zone = TimeZone.getDefault();
                        long tzOffset = zone.getOffset(System.currentTimeMillis());
                        if (this.getAutoTime()) {
                            this.setAndBroadcastNetworkSetTime(System.currentTimeMillis() - tzOffset);
                        } else {
                            this.mSavedTime -= tzOffset;
                        }
                    } else {
                        zone = iso.equals("") ? this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime) : TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, iso);
                    }
                    this.mNeedFixZone = false;
                    if (zone != null) {
                        if (this.getAutoTimeZone()) {
                            this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                        }
                        this.saveNitzTimeZone(zone.getID());
                    }
                }
            }
            this.phone.setSystemProperty("gsm.operator.isroaming", this.ss.getRoaming() ? "true" : "false");
            this.phone.notifyServiceStateChanged(this.ss);
        }
        if (hasGprsAttached) {
            this.gprsAttachedRegistrants.notifyRegistrants();
        }
        if (hasGprsDetached) {
            this.gprsDetachedRegistrants.notifyRegistrants();
        }
        if (hasNetworkTypeChanged) {
            this.phone.notifyDataConnection();
        }
        if (hasRoamingOn) {
            this.roamingOnRegistrants.notifyRegistrants();
        }
        if (hasRoamingOff) {
            this.roamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.phone.notifyLocationChanged();
        }
        if (!this.isGprsConsistent(this.gprsState, this.ss.getState())) {
            if (!this.mStartedGprsRegCheck && !this.mReportedGprsNoReg) {
                this.mStartedGprsRegCheck = true;
                int check_period = Settings.Secure.getInt(this.phone.getContext().getContentResolver(), "gprs_register_check_period_ms", 60000);
                this.sendMessageDelayed(this.obtainMessage(22), check_period);
            }
        } else {
            this.mReportedGprsNoReg = false;
        }
    }

    public boolean isGprsConsistent(int gprsState, int serviceState) {
        return serviceState != 0 || gprsState == 0;
    }

    public TimeZone getNitzTimeZone(int offset, boolean dst, long when) {
        TimeZone guess = this.findTimeZone(offset, dst, when);
        if (guess == null) {
            guess = this.findTimeZone(offset, !dst, when);
        }
        Log.d(LOG_TAG, "getNitzTimeZone returning " + (guess == null ? guess : guess.getID()));
        return guess;
    }

    public TimeZone findTimeZone(int offset, boolean dst, long when) {
        int rawOffset = offset;
        if (dst) {
            rawOffset -= 3600000;
        }
        String[] zones = TimeZone.getAvailableIDs(rawOffset);
        TimeZone guess = null;
        Date d = new Date(when);
        for (String zone : zones) {
            TimeZone tz = TimeZone.getTimeZone(zone);
            if (tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            guess = tz;
            break;
        }
        return guess;
    }

    public void queueNextSignalStrengthPoll() {
        if (this.dontPollSignalStrength || this.cm.getRadioState().isCdma()) {
            return;
        }
        Message msg = this.obtainMessage();
        msg.what = 10;
        this.sendMessageDelayed(msg, 20000L);
    }

    public void onSignalStrengthResult(AsyncResult ar) {
        SignalStrength oldSignalStrength = this.mSignalStrength;
        int rssi = 99;
        if (ar.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                rssi = ints[0];
            } else {
                Log.e(LOG_TAG, "Bogus signal strength response");
                rssi = 99;
            }
        }
        this.mSignalStrength = new SignalStrength(rssi, -1, -1, -1, -1, -1, -1, true);
        if (!this.mSignalStrength.equals(oldSignalStrength)) {
            try {
                this.phone.notifySignalStrength();
            }
            catch (NullPointerException ex) {
                this.log("onSignalStrengthResult() Phone already destroyed: " + ex + "SignalStrength not notified");
            }
        }
    }

    public void onRestrictedStateChanged(AsyncResult ar) {
        Log.d(LOG_TAG, "[DSAC DEB] onRestrictedStateChanged");
        RestrictedState newRs = new RestrictedState();
        Log.d(LOG_TAG, "[DSAC DEB] current rs at enter " + this.rs);
        if (ar.exception == null) {
            int[] ints = (int[])ar.result;
            int state = ints[0];
            newRs.setCsEmergencyRestricted((state & 1) != 0 || (state & 4) != 0);
            if (this.phone.getIccCard().getState() == IccCard.State.READY) {
                newRs.setCsNormalRestricted((state & 2) != 0 || (state & 4) != 0);
                newRs.setPsRestricted((state & 0x10) != 0);
            }
            Log.d(LOG_TAG, "[DSAC DEB] new rs " + newRs);
            if (!this.rs.isPsRestricted() && newRs.isPsRestricted()) {
                this.psRestrictEnabledRegistrants.notifyRegistrants();
                this.setNotification(1001);
            } else if (this.rs.isPsRestricted() && !newRs.isPsRestricted()) {
                this.psRestrictDisabledRegistrants.notifyRegistrants();
                this.setNotification(1002);
            }
            if (this.rs.isCsRestricted()) {
                if (!newRs.isCsRestricted()) {
                    this.setNotification(1004);
                } else if (!newRs.isCsNormalRestricted()) {
                    this.setNotification(1006);
                } else if (!newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1005);
                }
            } else if (this.rs.isCsEmergencyRestricted() && !this.rs.isCsNormalRestricted()) {
                if (!newRs.isCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsNormalRestricted()) {
                    this.setNotification(1005);
                }
            } else if (!this.rs.isCsEmergencyRestricted() && this.rs.isCsNormalRestricted()) {
                if (!newRs.isCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1006);
                }
            } else if (newRs.isCsRestricted()) {
                this.setNotification(1003);
            } else if (newRs.isCsEmergencyRestricted()) {
                this.setNotification(1006);
            } else if (newRs.isCsNormalRestricted()) {
                this.setNotification(1005);
            }
            this.rs = newRs;
        }
        Log.d(LOG_TAG, "[DSAC DEB] current rs at return " + this.rs);
    }

    public int regCodeToServiceState(int code) {
        switch (code) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        Log.w(LOG_TAG, "unexpected service state " + code);
        return 1;
    }

    public boolean regCodeIsRoaming(int code) {
        return 5 == code;
    }

    public boolean isRoamingBetweenOperators(boolean gsmRoaming, ServiceState s) {
        String spn = SystemProperties.get("gsm.sim.operator.alpha", "empty");
        String onsl = s.getOperatorAlphaLong();
        String onss = s.getOperatorAlphaShort();
        boolean equalsOnsl = onsl != null && spn.equals(onsl);
        boolean equalsOnss = onss != null && spn.equals(onss);
        String simNumeric = SystemProperties.get("gsm.sim.operator.numeric", "");
        String operatorNumeric = s.getOperatorNumeric();
        boolean equalsMcc = true;
        try {
            equalsMcc = simNumeric.substring(0, 3).equals(operatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            // empty catch block
        }
        return gsmRoaming && (!equalsMcc || !equalsOnsl && !equalsOnss);
    }

    public static int twoDigitsAt(String s, int offset) {
        int a = Character.digit(s.charAt(offset), 10);
        int b = Character.digit(s.charAt(offset + 1), 10);
        if (a < 0 || b < 0) {
            throw new RuntimeException("invalid format");
        }
        return a * 10 + b;
    }

    public int getCurrentGprsState() {
        return this.gprsState;
    }

    public boolean isConcurrentVoiceAndData() {
        return this.networkType >= 3;
    }

    public static String displayNameFor(int off) {
        off = off / 1000 / 60;
        char[] buf = new char[9];
        buf[0] = 71;
        buf[1] = 77;
        buf[2] = 84;
        if (off < 0) {
            buf[3] = 45;
            off = -off;
        } else {
            buf[3] = 43;
        }
        int hours = off / 60;
        int minutes = off % 60;
        buf[4] = (char)(48 + hours / 10);
        buf[5] = (char)(48 + hours % 10);
        buf[6] = 58;
        buf[7] = (char)(48 + minutes / 10);
        buf[8] = (char)(48 + minutes % 10);
        return new String(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTimeFromNITZString(String nitz, long nitzReceiveTime) {
        long start = SystemClock.elapsedRealtime();
        Log.i(LOG_TAG, "NITZ: " + nitz + "," + nitzReceiveTime + " start=" + start + " delay=" + (start - nitzReceiveTime));
        try {
            block14: {
                block13: {
                    String ignore;
                    Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    c.clear();
                    c.set(16, 0);
                    String[] nitzSubs = nitz.split("[/:,+-]");
                    int year = 2000 + Integer.parseInt(nitzSubs[0]);
                    c.set(1, year);
                    int month = Integer.parseInt(nitzSubs[1]) - 1;
                    c.set(2, month);
                    int date = Integer.parseInt(nitzSubs[2]);
                    c.set(5, date);
                    int hour = Integer.parseInt(nitzSubs[3]);
                    c.set(10, hour);
                    int minute = Integer.parseInt(nitzSubs[4]);
                    c.set(12, minute);
                    int second = Integer.parseInt(nitzSubs[5]);
                    c.set(13, second);
                    boolean sign = nitz.indexOf(45) == -1;
                    int tzOffset = Integer.parseInt(nitzSubs[6]);
                    int dst = nitzSubs.length >= 8 ? Integer.parseInt(nitzSubs[7]) : 0;
                    tzOffset = (sign ? 1 : -1) * tzOffset * 15 * 60 * 1000;
                    TimeZone zone = null;
                    if (nitzSubs.length >= 9) {
                        String tzname = nitzSubs[8].replace('!', '/');
                        zone = TimeZone.getTimeZone(tzname);
                    }
                    String iso = SystemProperties.get("gsm.operator.iso-country");
                    if (zone == null && this.mGotCountryCode) {
                        zone = iso != null && iso.length() > 0 ? TimeUtils.getTimeZone(tzOffset, dst != 0, c.getTimeInMillis(), iso) : this.getNitzTimeZone(tzOffset, dst != 0, c.getTimeInMillis());
                    }
                    if (zone == null) {
                        this.mNeedFixZone = true;
                        this.mZoneOffset = tzOffset;
                        this.mZoneDst = dst != 0;
                        this.mZoneTime = c.getTimeInMillis();
                    }
                    if (zone != null) {
                        if (this.getAutoTimeZone()) {
                            this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                        }
                        this.saveNitzTimeZone(zone.getID());
                    }
                    if ((ignore = SystemProperties.get("gsm.ignore-nitz")) != null && ignore.equals("yes")) {
                        Log.i(LOG_TAG, "NITZ: Not setting clock because gsm.ignore-nitz is set");
                        return;
                    }
                    try {
                        this.mWakeLock.acquire();
                        if (this.getAutoTime()) {
                            long millisSinceNitzReceived = SystemClock.elapsedRealtime() - nitzReceiveTime;
                            if (millisSinceNitzReceived < 0L) {
                                Log.i(LOG_TAG, "NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + nitz);
                                Object var23_20 = null;
                                this.mWakeLock.release();
                                return;
                            }
                            if (millisSinceNitzReceived > Integer.MAX_VALUE) {
                                Log.i(LOG_TAG, "NITZ: not setting time, processing has taken " + millisSinceNitzReceived / 86400000L + " days");
                                break block13;
                            }
                            c.add(14, (int)millisSinceNitzReceived);
                            Log.i(LOG_TAG, "NITZ: Setting time of day to " + c.getTime() + " NITZ receive delay(ms): " + millisSinceNitzReceived + " gained(ms): " + (c.getTimeInMillis() - System.currentTimeMillis()) + " from " + nitz);
                            this.setAndBroadcastNetworkSetTime(c.getTimeInMillis());
                            Log.i(LOG_TAG, "NITZ: after Setting time of day");
                        }
                        SystemProperties.set("gsm.nitz.time", String.valueOf(c.getTimeInMillis()));
                        this.saveNitzTime(c.getTimeInMillis());
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var23_23 = null;
                        this.mWakeLock.release();
                        throw throwable;
                    }
                }
                Object var23_21 = null;
                this.mWakeLock.release();
                return;
            }
            Object var23_22 = null;
            this.mWakeLock.release();
            return;
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "NITZ: Parsing NITZ time " + nitz, ex);
        }
    }

    public boolean getAutoTime() {
        try {
            return Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    public boolean getAutoTimeZone() {
        try {
            return Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time_zone") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    public void saveNitzTimeZone(String zoneId) {
        this.mSavedTimeZone = zoneId;
    }

    public void saveNitzTime(long time) {
        this.mSavedTime = time;
        this.mSavedAtTime = SystemClock.elapsedRealtime();
    }

    public void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        AlarmManager alarm = (AlarmManager)this.phone.getContext().getSystemService("alarm");
        alarm.setTimeZone(zoneId);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.addFlags(0x20000000);
        intent.putExtra("time-zone", zoneId);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    public void setAndBroadcastNetworkSetTime(long time) {
        SystemClock.setCurrentTimeMillis(time);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.addFlags(0x20000000);
        intent.putExtra("time", time);
        this.phone.getContext().sendStickyBroadcast(intent);
    }

    public void revertToNitzTime() {
        if (Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time", 0) == 0) {
            return;
        }
        Log.d(LOG_TAG, "Reverting to NITZ Time: mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
        if (this.mSavedTime != 0L && this.mSavedAtTime != 0L) {
            this.setAndBroadcastNetworkSetTime(this.mSavedTime + (SystemClock.elapsedRealtime() - this.mSavedAtTime));
        }
    }

    public void revertToNitzTimeZone() {
        if (Settings.System.getInt(this.phone.getContext().getContentResolver(), "auto_time_zone", 0) == 0) {
            return;
        }
        Log.d(LOG_TAG, "Reverting to NITZ TimeZone: tz='" + this.mSavedTimeZone);
        if (this.mSavedTimeZone != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
        }
    }

    public void setNotification(int notifyType) {
        Log.d(LOG_TAG, "[DSAC DEB] create notification " + notifyType);
        Context context = this.phone.getContext();
        this.mNotification = new Notification();
        this.mNotification.when = System.currentTimeMillis();
        this.mNotification.flags = 16;
        this.mNotification.icon = 17301642;
        Intent intent = new Intent();
        this.mNotification.contentIntent = PendingIntent.getActivity(context, 0, intent, 0x10000000);
        CharSequence details = "";
        CharSequence title = context.getText(17039576);
        int notificationId = 999;
        switch (notifyType) {
            case 1001: {
                notificationId = 888;
                details = context.getText(17039577);
                break;
            }
            case 1002: {
                notificationId = 888;
                break;
            }
            case 1003: {
                details = context.getText(17039580);
                break;
            }
            case 1005: {
                details = context.getText(17039579);
                break;
            }
            case 1006: {
                details = context.getText(17039578);
                break;
            }
        }
        Log.d(LOG_TAG, "[DSAC DEB] put notification " + title + " / " + details);
        this.mNotification.tickerText = title;
        this.mNotification.setLatestEventInfo(context, title, details, this.mNotification.contentIntent);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notifyType == 1002 || notifyType == 1004) {
            notificationManager.cancel(notificationId);
        } else {
            notificationManager.notify(notificationId, this.mNotification);
        }
    }

    public void log(String s) {
        Log.d(LOG_TAG, "[GsmServiceStateTracker] " + s);
    }
}

