/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.AsyncService;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncChannel {
    public static final String TAG = "AsyncChannel";
    public static final boolean DBG = false;
    public static final int CMD_CHANNEL_HALF_CONNECTED = -1;
    public static final int CMD_CHANNEL_FULL_CONNECTION = -2;
    public static final int CMD_CHANNEL_FULLY_CONNECTED = -3;
    public static final int CMD_CHANNEL_DISCONNECT = -4;
    public static final int CMD_CHANNEL_DISCONNECTED = -5;
    public static final int STATUS_SUCCESSFUL = 0;
    public static final int STATUS_BINDING_UNSUCCESSFUL = 1;
    public AsyncChannelConnection mConnection;
    public Context mSrcContext;
    public Handler mSrcHandler;
    public Messenger mSrcMessenger;
    public Messenger mDstMessenger;

    public void connectSrcHandlerToPackage(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
        this.mConnection = new AsyncChannelConnection();
        this.mSrcContext = srcContext;
        this.mSrcHandler = srcHandler;
        this.mSrcMessenger = new Messenger(srcHandler);
        this.mDstMessenger = null;
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setClassName(dstPackageName, dstClassName);
        boolean result = srcContext.bindService(intent, this.mConnection, 1);
        if (!result) {
            this.replyHalfConnected(1);
        }
    }

    public void connect(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
        public class ConnectAsync
        implements Runnable {
            public Context mSrcCtx;
            public Handler mSrcHdlr;
            public String mDstPackageName;
            public String mDstClassName;

            public ConnectAsync(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
                this.mSrcCtx = srcContext;
                this.mSrcHdlr = srcHandler;
                this.mDstPackageName = dstPackageName;
                this.mDstClassName = dstClassName;
            }

            public void run() {
                AsyncChannel.this.connectSrcHandlerToPackage(this.mSrcCtx, this.mSrcHdlr, this.mDstPackageName, this.mDstClassName);
            }
        }
        ConnectAsync ca = new ConnectAsync(srcContext, srcHandler, dstPackageName, dstClassName);
        new Thread(ca).start();
    }

    public void connect(Context srcContext, Handler srcHandler, Class<?> klass) {
        this.connect(srcContext, srcHandler, klass.getPackage().getName(), klass.getName());
    }

    public void connect(Context srcContext, Handler srcHandler, Messenger dstMessenger) {
        this.mSrcContext = srcContext;
        this.mSrcHandler = srcHandler;
        this.mSrcMessenger = new Messenger(this.mSrcHandler);
        this.mDstMessenger = dstMessenger;
        this.replyHalfConnected(0);
    }

    public void connect(Context srcContext, Handler srcHandler, Handler dstHandler) {
        this.connect(srcContext, srcHandler, new Messenger(dstHandler));
    }

    public void connect(AsyncService srcAsyncService, Messenger dstMessenger) {
        this.connect((Context)srcAsyncService, srcAsyncService.getHandler(), dstMessenger);
    }

    public void disconnected() {
        this.mSrcHandler = null;
        this.mSrcMessenger = null;
        this.mDstMessenger = null;
        this.mConnection = null;
    }

    public void disconnect() {
        if (this.mConnection != null) {
            this.mSrcContext.unbindService(this.mConnection);
        }
        if (this.mSrcHandler != null) {
            Message msg = this.mSrcHandler.obtainMessage(-5);
            msg.arg1 = 0;
            msg.obj = this;
            msg.replyTo = this.mDstMessenger;
            this.mSrcHandler.sendMessage(msg);
        }
    }

    public void sendMessage(Message msg) {
        msg.replyTo = this.mSrcMessenger;
        try {
            this.mDstMessenger.send(msg);
        }
        catch (RemoteException e) {
            AsyncChannel.log("TODO: handle sendMessage RemoteException" + e);
        }
    }

    public void sendMessage(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        this.sendMessage(msg);
    }

    public void replyToMessage(Message srcMsg, Message dstMsg) {
        try {
            srcMsg.replyTo.send(dstMsg);
        }
        catch (RemoteException e) {
            AsyncChannel.log("TODO: handle replyToMessage RemoteException" + e);
            e.printStackTrace();
        }
    }

    public void replyToMessage(Message srcMsg, int what) {
        Message msg = Message.obtain();
        msg.what = what;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        this.replyToMessage(srcMsg, msg);
    }

    public Message sendMessageSynchronously(Message msg) {
        Message resultMsg = SyncMessenger.sendMessageSynchronously(this.mDstMessenger, msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public void replyHalfConnected(int status) {
        Message msg = this.mSrcHandler.obtainMessage(-1);
        msg.arg1 = status;
        msg.obj = this;
        msg.replyTo = this.mDstMessenger;
        this.mSrcHandler.sendMessage(msg);
    }

    public static void log(String s) {
        Slog.d(TAG, s);
    }

    public static class 1 {
    }

    public class AsyncChannelConnection
    implements ServiceConnection {
        public void onServiceConnected(ComponentName className, IBinder service) {
            AsyncChannel.this.mDstMessenger = new Messenger(service);
            AsyncChannel.this.replyHalfConnected(0);
        }

        public void onServiceDisconnected(ComponentName className) {
            Message msg = AsyncChannel.this.mSrcHandler.obtainMessage(-5);
            msg.arg1 = 0;
            msg.obj = AsyncChannel.this;
            msg.replyTo = AsyncChannel.this.mDstMessenger;
            AsyncChannel.this.mSrcHandler.sendMessage(msg);
        }
    }

    public static class SyncMessenger {
        public static Stack<SyncMessenger> sStack = new Stack();
        public static int sCount = 0;
        public HandlerThread mHandlerThread;
        public SyncHandler mHandler;
        public Messenger mMessenger;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SyncMessenger obtain() {
            SyncMessenger sm;
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                if (sStack.isEmpty()) {
                    sm = new SyncMessenger();
                    sm.mHandlerThread = new HandlerThread("SyncHandler-" + sCount++);
                    sm.mHandlerThread.start();
                    SyncMessenger syncMessenger = sm;
                    syncMessenger.getClass();
                    sm.mHandler = syncMessenger.new SyncHandler(sm.mHandlerThread.getLooper(), null);
                    sm.mMessenger = new Messenger(sm.mHandler);
                } else {
                    sm = sStack.pop();
                }
            }
            return sm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                sStack.push(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Message sendMessageSynchronously(Messenger dstMessenger, Message msg) {
            SyncMessenger sm = SyncMessenger.obtain();
            try {
                msg.replyTo = sm.mMessenger;
                dstMessenger.send(msg);
                Object object = sm.mHandler.mLockObject;
                synchronized (object) {
                    sm.mHandler.mLockObject.wait();
                }
            }
            catch (InterruptedException e) {
                sm.mHandler.mResultMsg = null;
            }
            catch (RemoteException e) {
                sm.mHandler.mResultMsg = null;
            }
            Message resultMsg = sm.mHandler.mResultMsg;
            sm.recycle();
            return resultMsg;
        }

        public class SyncHandler
        extends Handler {
            public Object mLockObject;
            public Message mResultMsg;

            public SyncHandler(Looper looper) {
                super(looper);
                this.mLockObject = new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                this.mResultMsg = Message.obtain();
                this.mResultMsg.copyFrom(msg);
                Object object = this.mLockObject;
                synchronized (object) {
                    this.mLockObject.notify();
                }
            }

            public /* synthetic */ SyncHandler(Looper x1, 1 x2) {
                this(x1);
            }
        }
    }
}

