/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlUtils {
    public static void skipCurrentTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
        }
    }

    public static int convertValueToList(CharSequence value, String[] options, int defaultValue) {
        if (null != value) {
            for (int i = 0; i < options.length; ++i) {
                if (!value.equals(options[i])) continue;
                return i;
            }
        }
        return defaultValue;
    }

    public static boolean convertValueToBoolean(CharSequence value, boolean defaultValue) {
        boolean result = false;
        if (null == value) {
            return defaultValue;
        }
        if (value.equals("1") || value.equals("true") || value.equals("TRUE")) {
            result = true;
        }
        return result;
    }

    @LayoutlibDelegate
    public static int convertValueToInt(CharSequence charSequence, int n) {
        return XmlUtils_Delegate.convertValueToInt(charSequence, n);
    }

    public static int convertValueToUnsignedInt(String value, int defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        return XmlUtils.parseUnsignedIntAttribute(value);
    }

    public static int parseUnsignedIntAttribute(CharSequence charSeq) {
        String value = ((Object)charSeq).toString();
        int index = 0;
        int len = value.length();
        int base = 10;
        if ('0' == value.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = value.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == value.charAt(index)) {
            ++index;
            base = 16;
        }
        return (int)Long.parseLong(value.substring(index), base);
    }

    public static void writeMapXml(Map val, OutputStream out) throws XmlPullParserException, IOException {
        FastXmlSerializer serializer = new FastXmlSerializer();
        serializer.setOutput(out, "utf-8");
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeMapXml(val, null, serializer);
        serializer.endDocument();
    }

    public static void writeListXml(List val, OutputStream out) throws XmlPullParserException, IOException {
        XmlSerializer serializer = Xml.newSerializer();
        serializer.setOutput(out, "utf-8");
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        XmlUtils.writeListXml(val, null, serializer);
        serializer.endDocument();
    }

    public static void writeMapXml(Map val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        Set s = val.entrySet();
        Iterator i = s.iterator();
        out.startTag(null, "map");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        while (i.hasNext()) {
            Map.Entry e = i.next();
            XmlUtils.writeValueXml(e.getValue(), (String)e.getKey(), out);
        }
        out.endTag(null, "map");
    }

    public static void writeListXml(List val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "list");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.size();
        for (int i = 0; i < N; ++i) {
            XmlUtils.writeValueXml(val.get(i), null, out);
        }
        out.endTag(null, "list");
    }

    public static void writeSetXml(Set val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "set");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        for (Object v : val) {
            XmlUtils.writeValueXml(v, null, out);
        }
        out.endTag(null, "set");
    }

    public static void writeByteArrayXml(byte[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "byte-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        StringBuilder sb = new StringBuilder(val.length * 2);
        for (int i = 0; i < N; ++i) {
            byte b = val[i];
            int h = b >> 4;
            sb.append(h >= 10 ? 97 + h - 10 : 48 + h);
            h = b & 0xFF;
            sb.append(h >= 10 ? 97 + h - 10 : 48 + h);
        }
        out.text(sb.toString());
        out.endTag(null, "byte-array");
    }

    public static void writeIntArrayXml(int[] val, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        if (val == null) {
            out.startTag(null, "null");
            out.endTag(null, "null");
            return;
        }
        out.startTag(null, "int-array");
        if (name != null) {
            out.attribute(null, "name", name);
        }
        int N = val.length;
        out.attribute(null, "num", Integer.toString(N));
        for (int i = 0; i < N; ++i) {
            out.startTag(null, "item");
            out.attribute(null, "value", Integer.toString(val[i]));
            out.endTag(null, "item");
        }
        out.endTag(null, "int-array");
    }

    public static void writeValueXml(Object v, String name, XmlSerializer out) throws XmlPullParserException, IOException {
        String typeStr;
        if (v == null) {
            out.startTag(null, "null");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.endTag(null, "null");
            return;
        }
        if (v instanceof String) {
            out.startTag(null, "string");
            if (name != null) {
                out.attribute(null, "name", name);
            }
            out.text(v.toString());
            out.endTag(null, "string");
            return;
        }
        if (v instanceof Integer) {
            typeStr = "int";
        } else if (v instanceof Long) {
            typeStr = "long";
        } else if (v instanceof Float) {
            typeStr = "float";
        } else if (v instanceof Double) {
            typeStr = "double";
        } else if (v instanceof Boolean) {
            typeStr = "boolean";
        } else {
            if (v instanceof byte[]) {
                XmlUtils.writeByteArrayXml((byte[])v, name, out);
                return;
            }
            if (v instanceof int[]) {
                XmlUtils.writeIntArrayXml((int[])v, name, out);
                return;
            }
            if (v instanceof Map) {
                XmlUtils.writeMapXml((Map)v, name, out);
                return;
            }
            if (v instanceof List) {
                XmlUtils.writeListXml((List)v, name, out);
                return;
            }
            if (v instanceof Set) {
                XmlUtils.writeSetXml((Set)v, name, out);
                return;
            }
            if (v instanceof CharSequence) {
                out.startTag(null, "string");
                if (name != null) {
                    out.attribute(null, "name", name);
                }
                out.text(v.toString());
                out.endTag(null, "string");
                return;
            }
            throw new RuntimeException("writeValueXml: unable to write value " + v);
        }
        out.startTag(null, typeStr);
        if (name != null) {
            out.attribute(null, "name", name);
        }
        out.attribute(null, "value", v.toString());
        out.endTag(null, typeStr);
    }

    public static HashMap readMapXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (HashMap)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static ArrayList readListXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (ArrayList)XmlUtils.readValueXml(parser, new String[1]);
    }

    public static HashSet readSetXml(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        return (HashSet)XmlUtils.readValueXml(parser, new String[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashMap readThisMapXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name);
                if (name[0] == null) throw new XmlPullParserException("Map value without name attribute: " + parser.getName());
                map.put(name[0], val);
            } else if (eventType == 3) {
                if (!parser.getName().equals(endTag)) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                return map;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static ArrayList readThisListXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name);
                list.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return list;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static HashSet readThisSetXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        HashSet<Object> set = new HashSet<Object>();
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                Object val = XmlUtils.readThisValueXml(parser, name);
                set.add(val);
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return set;
                }
                throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] readThisIntArrayXml(XmlPullParser parser, String endTag, String[] name) throws XmlPullParserException, IOException {
        int num;
        try {
            num = Integer.parseInt(parser.getAttributeValue(null, "num"));
        }
        catch (NullPointerException e) {
            throw new XmlPullParserException("Need num attribute in byte-array");
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Not a number in num attribute in byte-array");
        }
        int[] array2 = new int[num];
        int i = 0;
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected item tag at: " + parser.getName());
                try {
                    array2[i] = Integer.parseInt(parser.getAttributeValue(null, "value"));
                }
                catch (NullPointerException e) {
                    throw new XmlPullParserException("Need value attribute in item");
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException("Not a number in value attribute in item");
                }
            } else if (eventType == 3) {
                if (parser.getName().equals(endTag)) {
                    return array2;
                }
                if (!parser.getName().equals("item")) throw new XmlPullParserException("Expected " + endTag + " end tag at: " + parser.getName());
                ++i;
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Document ended before " + endTag + " end tag");
    }

    public static Object readValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2) {
                return XmlUtils.readThisValueXml(parser, name);
            }
            if (eventType == 3) {
                throw new XmlPullParserException("Unexpected end tag at: " + parser.getName());
            }
            if (eventType == 4) {
                throw new XmlPullParserException("Unexpected text: " + parser.getText());
            }
            eventType = parser.next();
        } while (eventType != 1);
        throw new XmlPullParserException("Unexpected end of document");
    }

    public static Object readThisValueXml(XmlPullParser parser, String[] name) throws XmlPullParserException, IOException {
        String tagName;
        block26: {
            int eventType;
            Constable res;
            String valueName = parser.getAttributeValue(null, "name");
            tagName = parser.getName();
            if (tagName.equals("null")) {
                res = null;
            } else {
                if (tagName.equals("string")) {
                    block25: {
                        String value = "";
                        while (true) {
                            int eventType2 = parser.next();
                            if (eventType2 == 1) break block25;
                            if (eventType2 == 3) {
                                if (parser.getName().equals("string")) {
                                    name[0] = valueName;
                                    return value;
                                }
                                throw new XmlPullParserException("Unexpected end tag in <string>: " + parser.getName());
                            }
                            if (eventType2 == 4) {
                                value = value + parser.getText();
                                continue;
                            }
                            if (eventType2 == 2) break;
                        }
                        throw new XmlPullParserException("Unexpected start tag in <string>: " + parser.getName());
                    }
                    throw new XmlPullParserException("Unexpected end of document in <string>");
                }
                if (tagName.equals("int")) {
                    res = Integer.parseInt(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("long")) {
                    res = Long.valueOf(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("float")) {
                    res = new Float(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("double")) {
                    res = new Double(parser.getAttributeValue(null, "value"));
                } else if (tagName.equals("boolean")) {
                    res = Boolean.valueOf(parser.getAttributeValue(null, "value"));
                } else {
                    if (tagName.equals("int-array")) {
                        parser.next();
                        int[] res2 = XmlUtils.readThisIntArrayXml(parser, "int-array", name);
                        name[0] = valueName;
                        return res2;
                    }
                    if (tagName.equals("map")) {
                        parser.next();
                        HashMap res3 = XmlUtils.readThisMapXml(parser, "map", name);
                        name[0] = valueName;
                        return res3;
                    }
                    if (tagName.equals("list")) {
                        parser.next();
                        ArrayList res4 = XmlUtils.readThisListXml(parser, "list", name);
                        name[0] = valueName;
                        return res4;
                    }
                    if (tagName.equals("set")) {
                        parser.next();
                        HashSet res5 = XmlUtils.readThisSetXml(parser, "set", name);
                        name[0] = valueName;
                        return res5;
                    }
                    throw new XmlPullParserException("Unknown tag: " + tagName);
                }
            }
            do {
                eventType = parser.next();
                if (eventType == 1) break block26;
                if (eventType == 3) {
                    if (parser.getName().equals(tagName)) {
                        name[0] = valueName;
                        return res;
                    }
                    throw new XmlPullParserException("Unexpected end tag in <" + tagName + ">: " + parser.getName());
                }
                if (eventType == 4) {
                    throw new XmlPullParserException("Unexpected text in <" + tagName + ">: " + parser.getName());
                }
            } while (eventType != 2);
            throw new XmlPullParserException("Unexpected start tag in <" + tagName + ">: " + parser.getName());
        }
        throw new XmlPullParserException("Unexpected end of document in <" + tagName + ">");
    }

    public static void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    public static void nextElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
    }
}

