/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;
import java.lang.ref.WeakReference;

public class IInputConnectionWrapper
extends IInputContext.Stub {
    public static final String TAG = "IInputConnectionWrapper";
    public static final int DO_GET_TEXT_AFTER_CURSOR = 10;
    public static final int DO_GET_TEXT_BEFORE_CURSOR = 20;
    public static final int DO_GET_SELECTED_TEXT = 25;
    public static final int DO_GET_CURSOR_CAPS_MODE = 30;
    public static final int DO_GET_EXTRACTED_TEXT = 40;
    public static final int DO_COMMIT_TEXT = 50;
    public static final int DO_COMMIT_COMPLETION = 55;
    public static final int DO_COMMIT_CORRECTION = 56;
    public static final int DO_SET_SELECTION = 57;
    public static final int DO_PERFORM_EDITOR_ACTION = 58;
    public static final int DO_PERFORM_CONTEXT_MENU_ACTION = 59;
    public static final int DO_SET_COMPOSING_TEXT = 60;
    public static final int DO_SET_COMPOSING_REGION = 63;
    public static final int DO_FINISH_COMPOSING_TEXT = 65;
    public static final int DO_SEND_KEY_EVENT = 70;
    public static final int DO_DELETE_SURROUNDING_TEXT = 80;
    public static final int DO_BEGIN_BATCH_EDIT = 90;
    public static final int DO_END_BATCH_EDIT = 95;
    public static final int DO_REPORT_FULLSCREEN_MODE = 100;
    public static final int DO_PERFORM_PRIVATE_COMMAND = 120;
    public static final int DO_CLEAR_META_KEY_STATES = 130;
    public WeakReference<InputConnection> mInputConnection;
    public Looper mMainLooper;
    public Handler mH;

    public IInputConnectionWrapper(Looper mainLooper, InputConnection conn) {
        this.mInputConnection = new WeakReference<InputConnection>(conn);
        this.mMainLooper = mainLooper;
        this.mH = new MyHandler(this.mMainLooper);
    }

    public boolean isActive() {
        return true;
    }

    public void getTextAfterCursor(int length, int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageIISC(10, length, flags, seq, callback));
    }

    public void getTextBeforeCursor(int length, int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageIISC(20, length, flags, seq, callback));
    }

    public void getSelectedText(int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageISC(25, flags, seq, callback));
    }

    public void getCursorCapsMode(int reqModes, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageISC(30, reqModes, seq, callback));
    }

    public void getExtractedText(ExtractedTextRequest request, int flags, int seq, IInputContextCallback callback) {
        this.dispatchMessage(this.obtainMessageIOSC(40, flags, request, seq, callback));
    }

    public void commitText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(50, newCursorPosition, text));
    }

    public void commitCompletion(CompletionInfo text) {
        this.dispatchMessage(this.obtainMessageO(55, text));
    }

    public void commitCorrection(CorrectionInfo info) {
        this.dispatchMessage(this.obtainMessageO(56, info));
    }

    public void setSelection(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(57, start, end));
    }

    public void performEditorAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(58, id2, 0));
    }

    public void performContextMenuAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(59, id2, 0));
    }

    public void setComposingRegion(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(63, start, end));
    }

    public void setComposingText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(60, newCursorPosition, text));
    }

    public void finishComposingText() {
        this.dispatchMessage(this.obtainMessage(65));
    }

    public void sendKeyEvent(KeyEvent event) {
        this.dispatchMessage(this.obtainMessageO(70, event));
    }

    public void clearMetaKeyStates(int states) {
        this.dispatchMessage(this.obtainMessageII(130, states, 0));
    }

    public void deleteSurroundingText(int leftLength, int rightLength) {
        this.dispatchMessage(this.obtainMessageII(80, leftLength, rightLength));
    }

    public void beginBatchEdit() {
        this.dispatchMessage(this.obtainMessage(90));
    }

    public void endBatchEdit() {
        this.dispatchMessage(this.obtainMessage(95));
    }

    public void reportFullscreenMode(boolean enabled) {
        this.dispatchMessage(this.obtainMessageII(100, enabled ? 1 : 0, 0));
    }

    public void performPrivateCommand(String action, Bundle data) {
        this.dispatchMessage(this.obtainMessageOO(120, action, data));
    }

    public void dispatchMessage(Message msg) {
        if (Looper.myLooper() == this.mMainLooper) {
            this.executeMessage(msg);
            msg.recycle();
            return;
        }
        this.mH.sendMessage(msg);
    }

    public void executeMessage(Message msg) {
        switch (msg.what) {
            case 10: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getTextAfterCursor on inactive InputConnection");
                        args.callback.setTextAfterCursor(null, args.seq);
                        return;
                    }
                    args.callback.setTextAfterCursor(ic.getTextAfterCursor(msg.arg1, msg.arg2), args.seq);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Got RemoteException calling setTextAfterCursor", e);
                }
                return;
            }
            case 20: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getTextBeforeCursor on inactive InputConnection");
                        args.callback.setTextBeforeCursor(null, args.seq);
                        return;
                    }
                    args.callback.setTextBeforeCursor(ic.getTextBeforeCursor(msg.arg1, msg.arg2), args.seq);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Got RemoteException calling setTextBeforeCursor", e);
                }
                return;
            }
            case 25: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getSelectedText on inactive InputConnection");
                        args.callback.setSelectedText(null, args.seq);
                        return;
                    }
                    args.callback.setSelectedText(ic.getSelectedText(msg.arg1), args.seq);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Got RemoteException calling setSelectedText", e);
                }
                return;
            }
            case 30: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getCursorCapsMode on inactive InputConnection");
                        args.callback.setCursorCapsMode(0, args.seq);
                        return;
                    }
                    args.callback.setCursorCapsMode(ic.getCursorCapsMode(msg.arg1), args.seq);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Got RemoteException calling setCursorCapsMode", e);
                }
                return;
            }
            case 40: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    InputConnection ic = (InputConnection)this.mInputConnection.get();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getExtractedText on inactive InputConnection");
                        args.callback.setExtractedText(null, args.seq);
                        return;
                    }
                    args.callback.setExtractedText(ic.getExtractedText((ExtractedTextRequest)args.arg1, msg.arg1), args.seq);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Got RemoteException calling setExtractedText", e);
                }
                return;
            }
            case 50: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "commitText on inactive InputConnection");
                    return;
                }
                ic.commitText((CharSequence)msg.obj, msg.arg1);
                return;
            }
            case 57: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "setSelection on inactive InputConnection");
                    return;
                }
                ic.setSelection(msg.arg1, msg.arg2);
                return;
            }
            case 58: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "performEditorAction on inactive InputConnection");
                    return;
                }
                ic.performEditorAction(msg.arg1);
                return;
            }
            case 59: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "performContextMenuAction on inactive InputConnection");
                    return;
                }
                ic.performContextMenuAction(msg.arg1);
                return;
            }
            case 55: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "commitCompletion on inactive InputConnection");
                    return;
                }
                ic.commitCompletion((CompletionInfo)msg.obj);
                return;
            }
            case 56: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "commitCorrection on inactive InputConnection");
                    return;
                }
                ic.commitCorrection((CorrectionInfo)msg.obj);
                return;
            }
            case 60: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "setComposingText on inactive InputConnection");
                    return;
                }
                ic.setComposingText((CharSequence)msg.obj, msg.arg1);
                return;
            }
            case 63: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "setComposingRegion on inactive InputConnection");
                    return;
                }
                ic.setComposingRegion(msg.arg1, msg.arg2);
                return;
            }
            case 65: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null) {
                    Log.w(TAG, "finishComposingText on inactive InputConnection");
                    return;
                }
                ic.finishComposingText();
                return;
            }
            case 70: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "sendKeyEvent on inactive InputConnection");
                    return;
                }
                ic.sendKeyEvent((KeyEvent)msg.obj);
                return;
            }
            case 130: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "clearMetaKeyStates on inactive InputConnection");
                    return;
                }
                ic.clearMetaKeyStates(msg.arg1);
                return;
            }
            case 80: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "deleteSurroundingText on inactive InputConnection");
                    return;
                }
                ic.deleteSurroundingText(msg.arg1, msg.arg2);
                return;
            }
            case 90: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "beginBatchEdit on inactive InputConnection");
                    return;
                }
                ic.beginBatchEdit();
                return;
            }
            case 95: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "endBatchEdit on inactive InputConnection");
                    return;
                }
                ic.endBatchEdit();
                return;
            }
            case 100: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "showStatusIcon on inactive InputConnection");
                    return;
                }
                ic.reportFullscreenMode(msg.arg1 == 1);
                return;
            }
            case 120: {
                InputConnection ic = (InputConnection)this.mInputConnection.get();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "performPrivateCommand on inactive InputConnection");
                    return;
                }
                SomeArgs args = (SomeArgs)msg.obj;
                ic.performPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                return;
            }
        }
        Log.w(TAG, "Unhandled message code: " + msg.what);
    }

    public Message obtainMessage(int what) {
        return this.mH.obtainMessage(what);
    }

    public Message obtainMessageII(int what, int arg1, int arg2) {
        return this.mH.obtainMessage(what, arg1, arg2);
    }

    public Message obtainMessageO(int what, Object arg1) {
        return this.mH.obtainMessage(what, 0, 0, arg1);
    }

    public Message obtainMessageISC(int what, int arg1, int seq, IInputContextCallback callback) {
        SomeArgs args = new SomeArgs();
        args.callback = callback;
        args.seq = seq;
        return this.mH.obtainMessage(what, arg1, 0, args);
    }

    public Message obtainMessageIISC(int what, int arg1, int arg2, int seq, IInputContextCallback callback) {
        SomeArgs args = new SomeArgs();
        args.callback = callback;
        args.seq = seq;
        return this.mH.obtainMessage(what, arg1, arg2, args);
    }

    public Message obtainMessageIOSC(int what, int arg1, Object arg2, int seq, IInputContextCallback callback) {
        SomeArgs args = new SomeArgs();
        args.arg1 = arg2;
        args.callback = callback;
        args.seq = seq;
        return this.mH.obtainMessage(what, arg1, 0, args);
    }

    public Message obtainMessageIO(int what, int arg1, Object arg2) {
        return this.mH.obtainMessage(what, arg1, 0, arg2);
    }

    public Message obtainMessageOO(int what, Object arg1, Object arg2) {
        SomeArgs args = new SomeArgs();
        args.arg1 = arg1;
        args.arg2 = arg2;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    public class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            IInputConnectionWrapper.this.executeMessage(msg);
        }
    }

    public static class SomeArgs {
        public Object arg1;
        public Object arg2;
        public IInputContextCallback callback;
        public int seq;
    }
}

