/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.R;

public class RotarySelector
extends View {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String LOG_TAG = "RotarySelector";
    public static final boolean DBG = false;
    public static final boolean VISUAL_DEBUG = false;
    public OnDialTriggerListener mOnDialTriggerListener;
    public float mDensity;
    public Bitmap mBackground;
    public Bitmap mDimple;
    public Bitmap mDimpleDim;
    public Bitmap mLeftHandleIcon;
    public Bitmap mRightHandleIcon;
    public Bitmap mArrowShortLeftAndRight;
    public Bitmap mArrowLongLeft;
    public Bitmap mArrowLongRight;
    public int mLeftHandleX;
    public int mRightHandleX;
    public int mRotaryOffsetX = 0;
    public boolean mAnimating = false;
    public long mAnimationStartTime;
    public long mAnimationDuration;
    public int mAnimatingDeltaXStart;
    public int mAnimatingDeltaXEnd;
    public DecelerateInterpolator mInterpolator;
    public Paint mPaint = new Paint();
    public final Matrix mBgMatrix = new Matrix();
    public final Matrix mArrowMatrix = new Matrix();
    public int mGrabbedState = 0;
    public static final int NOTHING_GRABBED = 0;
    public static final int LEFT_HANDLE_GRABBED = 1;
    public static final int RIGHT_HANDLE_GRABBED = 2;
    public boolean mTriggered = false;
    public Vibrator mVibrator;
    public static final long VIBRATE_SHORT = 20L;
    public static final long VIBRATE_LONG = 20L;
    public static final int ARROW_SCRUNCH_DIP = 6;
    public static final int EDGE_PADDING_DIP = 9;
    public static final int EDGE_TRIGGER_DIP = 100;
    public static final int OUTER_ROTARY_RADIUS_DIP = 390;
    public static final int ROTARY_STROKE_WIDTH_DIP = 83;
    public static final int SNAP_BACK_ANIMATION_DURATION_MILLIS = 300;
    public static final int SPIN_ANIMATION_DURATION_MILLIS = 800;
    public int mEdgeTriggerThresh;
    public int mDimpleWidth;
    public int mBackgroundWidth;
    public int mBackgroundHeight;
    public final int mOuterRadius;
    public final int mInnerRadius;
    public int mDimpleSpacing;
    public VelocityTracker mVelocityTracker;
    public int mMinimumVelocity;
    public int mMaximumVelocity;
    public int mDimplesOfFling = 0;
    public int mOrientation;

    public RotarySelector(Context context) {
        this(context, null);
    }

    public RotarySelector(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RotarySelector);
        this.mOrientation = a.getInt(0, 0);
        a.recycle();
        Resources r = this.getResources();
        this.mDensity = r.getDisplayMetrics().density;
        this.mBackground = this.getBitmapFor(17302301);
        this.mDimple = this.getBitmapFor(17302302);
        this.mDimpleDim = this.getBitmapFor(17302303);
        this.mArrowLongLeft = this.getBitmapFor(17302293);
        this.mArrowLongRight = this.getBitmapFor(17302296);
        this.mArrowShortLeftAndRight = this.getBitmapFor(17302299);
        this.mInterpolator = new DecelerateInterpolator(1.0f);
        this.mEdgeTriggerThresh = (int)(this.mDensity * 100.0f);
        this.mDimpleWidth = this.mDimple.getWidth();
        this.mBackgroundWidth = this.mBackground.getWidth();
        this.mBackgroundHeight = this.mBackground.getHeight();
        this.mOuterRadius = (int)(this.mDensity * 390.0f);
        this.mInnerRadius = (int)(307.0f * this.mDensity);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity() * 2;
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public Bitmap getBitmapFor(int resId) {
        return BitmapFactory.decodeResource(this.getContext().getResources(), resId);
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int edgePadding = (int)(9.0f * this.mDensity);
        this.mLeftHandleX = edgePadding + this.mDimpleWidth / 2;
        int length = this.isHoriz() ? w : h;
        this.mRightHandleX = length - edgePadding - this.mDimpleWidth / 2;
        this.mDimpleSpacing = length / 2 - this.mLeftHandleX;
        this.mBgMatrix.setTranslate(0.0f, 0.0f);
        if (!this.isHoriz()) {
            int left = w - this.mBackgroundHeight;
            this.mBgMatrix.preRotate(-90.0f, 0.0f, 0.0f);
            this.mBgMatrix.postTranslate(left, h);
        } else {
            this.mBgMatrix.postTranslate(0.0f, h - this.mBackgroundHeight);
        }
    }

    public boolean isHoriz() {
        return this.mOrientation == 0;
    }

    public void setLeftHandleResource(int resId) {
        if (resId != 0) {
            this.mLeftHandleIcon = this.getBitmapFor(resId);
        }
        this.invalidate();
    }

    public void setRightHandleResource(int resId) {
        if (resId != 0) {
            this.mRightHandleIcon = this.getBitmapFor(resId);
        }
        this.invalidate();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int length = this.isHoriz() ? View.MeasureSpec.getSize(widthMeasureSpec) : View.MeasureSpec.getSize(heightMeasureSpec);
        int arrowScrunch = (int)(6.0f * this.mDensity);
        int arrowH = this.mArrowShortLeftAndRight.getHeight();
        int height = this.mBackgroundHeight + arrowH - arrowScrunch;
        if (this.isHoriz()) {
            this.setMeasuredDimension(length, height);
        } else {
            this.setMeasuredDimension(height, length);
        }
    }

    public void onDraw(Canvas canvas) {
        int y;
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mAnimating) {
            this.updateAnimation();
        }
        canvas.drawBitmap(this.mBackground, this.mBgMatrix, this.mPaint);
        this.mArrowMatrix.reset();
        switch (this.mGrabbedState) {
            case 0: {
                break;
            }
            case 1: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    this.mArrowMatrix.postTranslate(0.0f, height);
                }
                canvas.drawBitmap(this.mArrowLongLeft, this.mArrowMatrix, this.mPaint);
                break;
            }
            case 2: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    this.mArrowMatrix.postTranslate(0.0f, height + (this.mBackgroundWidth - height));
                }
                canvas.drawBitmap(this.mArrowLongRight, this.mArrowMatrix, this.mPaint);
                break;
            }
            default: {
                throw new IllegalStateException("invalid mGrabbedState: " + this.mGrabbedState);
            }
        }
        int bgHeight = this.mBackgroundHeight;
        int bgTop = this.isHoriz() ? height - bgHeight : width - bgHeight;
        int xOffset = this.mLeftHandleX + this.mRotaryOffsetX;
        int drawableY = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, xOffset);
        int x = this.isHoriz() ? xOffset : drawableY + bgTop;
        int n = y = this.isHoriz() ? drawableY + bgTop : height - xOffset;
        if (this.mGrabbedState != 2) {
            this.drawCentered(this.mDimple, canvas, x, y);
            this.drawCentered(this.mLeftHandleIcon, canvas, x, y);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, x, y);
        }
        xOffset = this.isHoriz() ? width / 2 + this.mRotaryOffsetX : height / 2 + this.mRotaryOffsetX;
        drawableY = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, xOffset);
        if (this.isHoriz()) {
            this.drawCentered(this.mDimpleDim, canvas, xOffset, drawableY + bgTop);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, drawableY + bgTop, height - xOffset);
        }
        xOffset = this.mRightHandleX + this.mRotaryOffsetX;
        drawableY = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, xOffset);
        x = this.isHoriz() ? xOffset : drawableY + bgTop;
        int n2 = y = this.isHoriz() ? drawableY + bgTop : height - xOffset;
        if (this.mGrabbedState != 1) {
            this.drawCentered(this.mDimple, canvas, x, y);
            this.drawCentered(this.mRightHandleIcon, canvas, x, y);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, x, y);
        }
        int halfdimple = this.mDimpleWidth / 2;
        for (int dimpleLeft = this.mRotaryOffsetX + this.mLeftHandleX - this.mDimpleSpacing; dimpleLeft > -halfdimple; dimpleLeft -= this.mDimpleSpacing) {
            int drawableY2 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, dimpleLeft);
            if (this.isHoriz()) {
                this.drawCentered(this.mDimpleDim, canvas, dimpleLeft, drawableY2 + bgTop);
                continue;
            }
            this.drawCentered(this.mDimpleDim, canvas, drawableY2 + bgTop, height - dimpleLeft);
        }
        int rightThresh = this.mRight + halfdimple;
        for (int dimpleRight = this.mRotaryOffsetX + this.mRightHandleX + this.mDimpleSpacing; dimpleRight < rightThresh; dimpleRight += this.mDimpleSpacing) {
            int drawableY3 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, dimpleRight);
            if (this.isHoriz()) {
                this.drawCentered(this.mDimpleDim, canvas, dimpleRight, drawableY3 + bgTop);
                continue;
            }
            this.drawCentered(this.mDimpleDim, canvas, drawableY3 + bgTop, height - dimpleRight);
        }
    }

    public int getYOnArc(int backgroundWidth, int innerRadius, int outerRadius, int x) {
        int halfWidth = (outerRadius - innerRadius) / 2;
        int middleRadius = innerRadius + halfWidth;
        int triangleBottom = backgroundWidth / 2 - x;
        int triangleY = (int)Math.sqrt(middleRadius * middleRadius - triangleBottom * triangleBottom);
        return middleRadius - triangleY + halfWidth;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mAnimating) {
            return true;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int height = this.getHeight();
        int eventX = this.isHoriz() ? (int)event.getX() : height - (int)event.getY();
        int hitWindow = this.mDimpleWidth;
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.mTriggered = false;
                if (this.mGrabbedState != 0) {
                    this.reset();
                    this.invalidate();
                }
                if (eventX < this.mLeftHandleX + hitWindow) {
                    this.mRotaryOffsetX = eventX - this.mLeftHandleX;
                    this.setGrabbedState(1);
                    this.invalidate();
                    this.vibrate(20L);
                    break;
                }
                if (eventX <= this.mRightHandleX - hitWindow) break;
                this.mRotaryOffsetX = eventX - this.mRightHandleX;
                this.setGrabbedState(2);
                this.invalidate();
                this.vibrate(20L);
                break;
            }
            case 2: {
                if (this.mGrabbedState == 1) {
                    int rightThresh;
                    this.mRotaryOffsetX = eventX - this.mLeftHandleX;
                    this.invalidate();
                    int n = rightThresh = this.isHoriz() ? this.getRight() : height;
                    if (eventX < rightThresh - this.mEdgeTriggerThresh || this.mTriggered) break;
                    this.mTriggered = true;
                    this.dispatchTriggerEvent(1);
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                    int rawVelocity = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                    int velocity = Math.max(this.mMinimumVelocity, rawVelocity);
                    this.mDimplesOfFling = Math.max(8, Math.abs(velocity / this.mDimpleSpacing));
                    this.startAnimationWithVelocity(eventX - this.mLeftHandleX, this.mDimplesOfFling * this.mDimpleSpacing, velocity);
                    break;
                }
                if (this.mGrabbedState != 2) break;
                this.mRotaryOffsetX = eventX - this.mRightHandleX;
                this.invalidate();
                if (eventX > this.mEdgeTriggerThresh || this.mTriggered) break;
                this.mTriggered = true;
                this.dispatchTriggerEvent(2);
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int rawVelocity = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                int velocity = Math.min(-this.mMinimumVelocity, rawVelocity);
                this.mDimplesOfFling = Math.max(8, Math.abs(velocity / this.mDimpleSpacing));
                this.startAnimationWithVelocity(eventX - this.mRightHandleX, -(this.mDimplesOfFling * this.mDimpleSpacing), velocity);
                break;
            }
            case 1: {
                if (this.mGrabbedState == 1 && Math.abs(eventX - this.mLeftHandleX) > 5) {
                    this.startAnimation(eventX - this.mLeftHandleX, 0, 300);
                } else if (this.mGrabbedState == 2 && Math.abs(eventX - this.mRightHandleX) > 5) {
                    this.startAnimation(eventX - this.mRightHandleX, 0, 300);
                }
                this.mRotaryOffsetX = 0;
                this.setGrabbedState(0);
                this.invalidate();
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 3: {
                this.reset();
                this.invalidate();
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    public void startAnimation(int startX, int endX, int duration) {
        this.mAnimating = true;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = duration;
        this.mAnimatingDeltaXStart = startX;
        this.mAnimatingDeltaXEnd = endX;
        this.setGrabbedState(0);
        this.mDimplesOfFling = 0;
        this.invalidate();
    }

    public void startAnimationWithVelocity(int startX, int endX, int pixelsPerSecond) {
        this.mAnimating = true;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = 1000 * (endX - startX) / pixelsPerSecond;
        this.mAnimatingDeltaXStart = startX;
        this.mAnimatingDeltaXEnd = endX;
        this.setGrabbedState(0);
        this.invalidate();
    }

    public void updateAnimation() {
        boolean goingRight;
        long millisSoFar = AnimationUtils.currentAnimationTimeMillis() - this.mAnimationStartTime;
        long millisLeft = this.mAnimationDuration - millisSoFar;
        int totalDeltaX = this.mAnimatingDeltaXStart - this.mAnimatingDeltaXEnd;
        boolean bl = goingRight = totalDeltaX < 0;
        if (millisLeft <= 0L) {
            this.reset();
            return;
        }
        float interpolation = this.mInterpolator.getInterpolation((float)millisSoFar / (float)this.mAnimationDuration);
        int dx = (int)((float)totalDeltaX * (1.0f - interpolation));
        this.mRotaryOffsetX = this.mAnimatingDeltaXEnd + dx;
        if (this.mDimplesOfFling > 0) {
            if (!goingRight && this.mRotaryOffsetX < -3 * this.mDimpleSpacing) {
                this.mRotaryOffsetX += this.mDimplesOfFling * this.mDimpleSpacing;
            } else if (goingRight && this.mRotaryOffsetX > 3 * this.mDimpleSpacing) {
                this.mRotaryOffsetX -= this.mDimplesOfFling * this.mDimpleSpacing;
            }
        }
        this.invalidate();
    }

    public void reset() {
        this.mAnimating = false;
        this.mRotaryOffsetX = 0;
        this.mDimplesOfFling = 0;
        this.setGrabbedState(0);
        this.mTriggered = false;
    }

    public synchronized void vibrate(long duration) {
        if (this.mVibrator == null) {
            this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        }
        this.mVibrator.vibrate(duration);
    }

    public void drawCentered(Bitmap d, Canvas c, int x, int y) {
        int w = d.getWidth();
        int h = d.getHeight();
        c.drawBitmap(d, x - w / 2, y - h / 2, this.mPaint);
    }

    public void setOnDialTriggerListener(OnDialTriggerListener l) {
        this.mOnDialTriggerListener = l;
    }

    public void dispatchTriggerEvent(int whichHandle) {
        this.vibrate(20L);
        if (this.mOnDialTriggerListener != null) {
            this.mOnDialTriggerListener.onDialTrigger(this, whichHandle);
        }
    }

    public void setGrabbedState(int newState) {
        if (newState != this.mGrabbedState) {
            this.mGrabbedState = newState;
            if (this.mOnDialTriggerListener != null) {
                this.mOnDialTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    public void log(String msg) {
        Log.d(LOG_TAG, msg);
    }

    public static interface OnDialTriggerListener {
        public static final int LEFT_HANDLE = 1;
        public static final int RIGHT_HANDLE = 2;

        public void onDialTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);
    }
}

