/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.LinearLayout;
import com.android.internal.R;

public class WeightedLinearLayout
extends LinearLayout {
    public float mMajorWeightMin;
    public float mMinorWeightMin;
    public float mMajorWeightMax;
    public float mMinorWeightMax;

    public WeightedLinearLayout(Context context) {
        super(context);
    }

    public WeightedLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WeightedLinearLayout);
        this.mMajorWeightMin = a.getFloat(0, 0.0f);
        this.mMinorWeightMin = a.getFloat(1, 0.0f);
        this.mMajorWeightMax = a.getFloat(2, 0.0f);
        this.mMinorWeightMax = a.getFloat(3, 0.0f);
        a.recycle();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float widthWeightMax;
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        int screenWidth = metrics.widthPixels;
        boolean isPortrait = screenWidth < metrics.heightPixels;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        boolean measure = false;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        float widthWeightMin = isPortrait ? this.mMinorWeightMin : this.mMajorWeightMin;
        float f = widthWeightMax = isPortrait ? this.mMinorWeightMax : this.mMajorWeightMax;
        if (widthMode == Integer.MIN_VALUE) {
            int weightedMin = (int)((float)screenWidth * widthWeightMin);
            int weightedMax = (int)((float)screenWidth * widthWeightMin);
            if (widthWeightMin > 0.0f && width < weightedMin) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(weightedMin, 0x40000000);
                measure = true;
            } else if (widthWeightMax > 0.0f && width > weightedMax) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(weightedMax, 0x40000000);
                measure = true;
            }
        }
        if (measure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

