/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.net;

import java.nio.ByteOrder;
import java.nio.charset.Charsets;
import org.apache.harmony.luni.platform.OSMemory;

public class Socks4Message {
    public static final int COMMAND_CONNECT = 1;
    public static final int COMMAND_BIND = 2;
    public static final int RETURN_SUCCESS = 90;
    public static final int RETURN_FAILURE = 91;
    public static final int RETURN_CANNOT_CONNECT_TO_IDENTD = 92;
    public static final int RETURN_DIFFERENT_USER_IDS = 93;
    public static final int REPLY_LENGTH = 8;
    public static final int INDEX_VERSION = 0;
    public static final int SOCKS_VERSION = 4;
    public static final int INDEX_COMMAND = 1;
    public static final int INDEX_PORT = 2;
    public static final int INDEX_IP = 4;
    public static final int INDEX_USER_ID = 8;
    public static final int BUFFER_LENGTH = 256;
    public static final int MAX_USER_ID_LENGTH = 248;
    public byte[] buffer = new byte[256];

    public Socks4Message() {
        this.setVersionNumber(4);
    }

    public int getCommandOrResult() {
        return this.buffer[1];
    }

    public void setCommandOrResult(int command) {
        this.buffer[1] = (byte)command;
    }

    public int getPort() {
        return OSMemory.peekShort(this.buffer, 2, ByteOrder.BIG_ENDIAN);
    }

    public void setPort(int port) {
        OSMemory.pokeShort(this.buffer, 2, (short)port, ByteOrder.BIG_ENDIAN);
    }

    public int getIP() {
        return OSMemory.peekInt(this.buffer, 4, ByteOrder.BIG_ENDIAN);
    }

    public void setIP(byte[] ip) {
        this.buffer[4] = ip[0];
        this.buffer[5] = ip[1];
        this.buffer[6] = ip[2];
        this.buffer[7] = ip[3];
    }

    public String getUserId() {
        return this.getString(8, 248);
    }

    public void setUserId(String id2) {
        this.setString(8, 248, id2);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        buf.append("Version: ");
        buf.append(Integer.toHexString(this.getVersionNumber()));
        buf.append(" Command: ");
        buf.append(Integer.toHexString(this.getCommandOrResult()));
        buf.append(" Port: ");
        buf.append(this.getPort());
        buf.append(" IP: ");
        buf.append(Integer.toHexString(this.getIP()));
        buf.append(" User ID: ");
        buf.append(this.getUserId());
        return buf.toString();
    }

    public int getLength() {
        int index = 0;
        index = 8;
        while (this.buffer[index] != 0) {
            ++index;
        }
        return ++index;
    }

    public String getErrorString(int error) {
        switch (error) {
            case 91: {
                return "Failure to connect to SOCKS server";
            }
            case 92: {
                return "Unable to connect to identd to verify user";
            }
            case 93: {
                return "Failure - user ids do not match";
            }
        }
        return "Success";
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public String getString(int offset, int maxLength) {
        int index;
        int lastIndex = index + maxLength;
        for (index = offset; index < lastIndex && this.buffer[index] != 0; ++index) {
        }
        return new String(this.buffer, offset, index - offset, Charsets.ISO_8859_1);
    }

    public int getVersionNumber() {
        return this.buffer[0];
    }

    public void setString(int offset, int maxLength, String theString) {
        byte[] stringBytes = theString.getBytes(Charsets.ISO_8859_1);
        int length = Math.min(stringBytes.length, maxLength);
        System.arraycopy(stringBytes, 0, this.buffer, offset, length);
        this.buffer[offset + length] = 0;
    }

    public void setVersionNumber(int number) {
        this.buffer[0] = (byte)number;
    }
}

