/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.platform;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class OSMemory {
    public static void unsafeBulkGet(Object object, int n, int n2, byte[] byArray, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#unsafeBulkGet(Ljava/lang/Object;II[BIIZ)V", true, null);
    }

    public static void unsafeBulkPut(byte[] byArray, int n, int n2, Object object, int n3, int n4, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#unsafeBulkPut([BIILjava/lang/Object;IIZ)V", true, null);
    }

    public static int peekInt(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
        }
        return (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 0;
            int l = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 24;
        int h = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static short peekShort(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset] << 8 | src[offset + 1] & 0xFF);
        }
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static void pokeInt(byte[] dst, int offset, int value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 24 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset] = (byte)(value >> 24 & 0xFF);
        }
    }

    public static void pokeLong(byte[] dst, int offset, long value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            i = (int)value;
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset] = (byte)(i >> 0 & 0xFF);
        } else {
            int i = (int)value;
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset] = (byte)(i >> 24 & 0xFF);
        }
    }

    public static void pokeShort(byte[] dst, int offset, short value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset] = (byte)(value >> 8 & 0xFF);
        }
    }

    public static void memmove(int n, int n2, long l) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#memmove(IIJ)V", true, null);
    }

    public static byte peekByte(int n) {
        return (byte)OverrideMethod.invokeI("org.apache.harmony.luni.platform.OSMemory#peekByte(I)B", true, null);
    }

    public static int peekInt(int n, boolean bl) {
        return OverrideMethod.invokeI("org.apache.harmony.luni.platform.OSMemory#peekInt(IZ)I", true, null);
    }

    public static long peekLong(int n, boolean bl) {
        return OverrideMethod.invokeL("org.apache.harmony.luni.platform.OSMemory#peekLong(IZ)J", true, null);
    }

    public static short peekShort(int n, boolean bl) {
        return (short)OverrideMethod.invokeI("org.apache.harmony.luni.platform.OSMemory#peekShort(IZ)S", true, null);
    }

    public static void peekByteArray(int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#peekByteArray(I[BII)V", true, null);
    }

    public static void peekCharArray(int n, char[] cArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#peekCharArray(I[CIIZ)V", true, null);
    }

    public static void peekDoubleArray(int n, double[] dArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#peekDoubleArray(I[DIIZ)V", true, null);
    }

    public static void peekFloatArray(int n, float[] fArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#peekFloatArray(I[FIIZ)V", true, null);
    }

    public static void peekIntArray(int n, int[] nArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#peekIntArray(I[IIIZ)V", true, null);
    }

    public static void peekLongArray(int n, long[] lArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#peekLongArray(I[JIIZ)V", true, null);
    }

    public static void peekShortArray(int n, short[] sArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#peekShortArray(I[SIIZ)V", true, null);
    }

    public static void pokeByte(int n, byte by) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeByte(IB)V", true, null);
    }

    public static void pokeInt(int n, int n2, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeInt(IIZ)V", true, null);
    }

    public static void pokeLong(int n, long l, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeLong(IJZ)V", true, null);
    }

    public static void pokeShort(int n, short s, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeShort(ISZ)V", true, null);
    }

    public static void pokeByteArray(int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeByteArray(I[BII)V", true, null);
    }

    public static void pokeCharArray(int n, char[] cArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeCharArray(I[CIIZ)V", true, null);
    }

    public static void pokeDoubleArray(int n, double[] dArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeDoubleArray(I[DIIZ)V", true, null);
    }

    public static void pokeFloatArray(int n, float[] fArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeFloatArray(I[FIIZ)V", true, null);
    }

    public static void pokeIntArray(int n, int[] nArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeIntArray(I[IIIZ)V", true, null);
    }

    public static void pokeLongArray(int n, long[] lArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeLongArray(I[JIIZ)V", true, null);
    }

    public static void pokeShortArray(int n, short[] sArray, int n2, int n3, boolean bl) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#pokeShortArray(I[SIIZ)V", true, null);
    }

    public static int mmap(int fd, long offset, long size, FileChannel.MapMode mapMode) throws IOException {
        if (offset < 0L || size < 0L || offset > Integer.MAX_VALUE || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("offset=" + offset + " size=" + size);
        }
        int intMode = 0;
        if (mapMode == FileChannel.MapMode.READ_ONLY) {
            intMode = 1;
        } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
            intMode = 2;
        }
        return OSMemory.mmapImpl(fd, offset, size, intMode);
    }

    public static int mmapImpl(int n, long l, long l2, int n2) {
        return OverrideMethod.invokeI("org.apache.harmony.luni.platform.OSMemory#mmapImpl(IJJI)I", true, null);
    }

    public static void munmap(int n, long l) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#munmap(IJ)V", true, null);
    }

    public static void load(int n, long l) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#load(IJ)V", true, null);
    }

    public static boolean isLoaded(int n, long l) {
        return OverrideMethod.invokeI("org.apache.harmony.luni.platform.OSMemory#isLoaded(IJ)Z", true, null) != 0;
    }

    public static void msync(int n, long l) {
        OverrideMethod.invokeV("org.apache.harmony.luni.platform.OSMemory#msync(IJ)V", true, null);
    }
}

