/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import javax.net.ssl.SSLSocketFactory;
import libcore.base.EmptyArray;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;
import org.apache.harmony.xnet.provider.jsse.SSLSocketImpl;
import org.apache.harmony.xnet.provider.jsse.SSLSocketWrapper;

public class SSLSocketFactoryImpl
extends SSLSocketFactory {
    public final SSLParametersImpl sslParameters;
    public final IOException instantiationException;

    public SSLSocketFactoryImpl() {
        SSLParametersImpl sslParametersLocal = null;
        IOException instantiationExceptionLocal = null;
        try {
            sslParametersLocal = SSLParametersImpl.getDefault();
        }
        catch (KeyManagementException e) {
            instantiationExceptionLocal = new IOException("Delayed instantiation exception:");
            instantiationExceptionLocal.initCause(e);
        }
        this.sslParameters = sslParametersLocal;
        this.instantiationException = instantiationExceptionLocal;
    }

    public SSLSocketFactoryImpl(SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
        this.instantiationException = null;
    }

    public String[] getDefaultCipherSuites() {
        if (this.instantiationException != null) {
            return EmptyArray.STRING;
        }
        return this.sslParameters.getEnabledCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (this.instantiationException != null) {
            return EmptyArray.STRING;
        }
        return CipherSuite.getSupportedCipherSuiteNames();
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketWrapper(s, autoClose, (SSLParametersImpl)this.sslParameters.clone());
    }

    public Socket createSocket() throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl((SSLParametersImpl)this.sslParameters.clone());
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(host, port, (SSLParametersImpl)this.sslParameters.clone());
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(host, port, localHost, localPort, (SSLParametersImpl)this.sslParameters.clone());
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(host, port, (SSLParametersImpl)this.sslParameters.clone());
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new SSLSocketImpl(address, port, localAddress, localPort, (SSLParametersImpl)this.sslParameters.clone());
    }
}

