/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.res.Resources;
import android.database.CharArrayBuffer;
import android.database.CursorWindowAllocationException;
import android.database.sqlite.SQLiteClosable;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;

public class CursorWindow
extends SQLiteClosable
implements Parcelable {
    private static final String STATS_TAG = "CursorWindowStats";
    private static final int sCursorWindowSize = Resources.getSystem().getInteger(17694761) * 1024;
    public int mWindowPtr;
    private int mStartPos;
    private final String mName;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final Parcelable.Creator<CursorWindow> CREATOR = new Parcelable.Creator<CursorWindow>(){

        @Override
        public CursorWindow createFromParcel(Parcel source) {
            return new CursorWindow(source);
        }

        public CursorWindow[] newArray(int size) {
            return new CursorWindow[size];
        }
    };
    private static final SparseIntArray sWindowToPidMap = new SparseIntArray();

    private static int nativeCreate(String string2, int n, boolean bl) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeCreate(Ljava/lang/String;IZ)I", true, null);
    }

    private static int nativeCreateFromParcel(Parcel parcel) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeCreateFromParcel(Landroid/os/Parcel;)I", true, null);
    }

    private static void nativeDispose(int n) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeDispose(I)V", true, null);
    }

    private static void nativeWriteToParcel(int n, Parcel parcel) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeWriteToParcel(ILandroid/os/Parcel;)V", true, null);
    }

    private static void nativeClear(int n) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeClear(I)V", true, null);
    }

    private static int nativeGetNumRows(int n) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeGetNumRows(I)I", true, null);
    }

    private static boolean nativeSetNumColumns(int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeSetNumColumns(II)Z", true, null) != 0;
    }

    private static boolean nativeAllocRow(int n) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeAllocRow(I)Z", true, null) != 0;
    }

    private static void nativeFreeLastRow(int n) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeFreeLastRow(I)V", true, null);
    }

    private static int nativeGetType(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativeGetType(III)I", true, null);
    }

    private static byte[] nativeGetBlob(int n, int n2, int n3) {
        return (byte[])OverrideMethod.invokeA("android.database.CursorWindow#nativeGetBlob(III)[B", true, null);
    }

    private static String nativeGetString(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("android.database.CursorWindow#nativeGetString(III)Ljava/lang/String;", true, null);
    }

    private static long nativeGetLong(int n, int n2, int n3) {
        return OverrideMethod.invokeL("android.database.CursorWindow#nativeGetLong(III)J", true, null);
    }

    private static double nativeGetDouble(int n, int n2, int n3) {
        return OverrideMethod.invokeD("android.database.CursorWindow#nativeGetDouble(III)D", true, null);
    }

    private static void nativeCopyStringToBuffer(int n, int n2, int n3, CharArrayBuffer charArrayBuffer) {
        OverrideMethod.invokeV("android.database.CursorWindow#nativeCopyStringToBuffer(IIILandroid/database/CharArrayBuffer;)V", true, null);
    }

    private static boolean nativePutBlob(int n, byte[] byArray, int n2, int n3) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutBlob(I[BII)Z", true, null) != 0;
    }

    private static boolean nativePutString(int n, String string2, int n2, int n3) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutString(ILjava/lang/String;II)Z", true, null) != 0;
    }

    private static boolean nativePutLong(int n, long l, int n2, int n3) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutLong(IJII)Z", true, null) != 0;
    }

    private static boolean nativePutDouble(int n, double d, int n2, int n3) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutDouble(IDII)Z", true, null) != 0;
    }

    private static boolean nativePutNull(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.database.CursorWindow#nativePutNull(III)Z", true, null) != 0;
    }

    private static String nativeGetName(int n) {
        return (String)OverrideMethod.invokeA("android.database.CursorWindow#nativeGetName(I)Ljava/lang/String;", true, null);
    }

    public CursorWindow(String name, boolean localWindow) {
        this.mStartPos = 0;
        this.mName = name;
        this.mWindowPtr = CursorWindow.nativeCreate(name, sCursorWindowSize, localWindow);
        if (this.mWindowPtr == 0) {
            throw new CursorWindowAllocationException("Cursor window allocation of " + sCursorWindowSize / 1024 + " kb failed. " + this.printStats());
        }
        this.mCloseGuard.open("close");
        this.recordNewWindow(Binder.getCallingPid(), this.mWindowPtr);
    }

    public CursorWindow(boolean localWindow) {
        this(null, localWindow);
    }

    private CursorWindow(Parcel source) {
        this.mStartPos = source.readInt();
        this.mWindowPtr = CursorWindow.nativeCreateFromParcel(source);
        if (this.mWindowPtr == 0) {
            throw new CursorWindowAllocationException("Cursor window could not be created from binder.");
        }
        this.mName = CursorWindow.nativeGetName(this.mWindowPtr);
        this.mCloseGuard.open("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
        if (this.mWindowPtr != 0) {
            this.recordClosingOfWindow(this.mWindowPtr);
            CursorWindow.nativeDispose(this.mWindowPtr);
            this.mWindowPtr = 0;
        }
    }

    public String getName() {
        return this.mName;
    }

    public void close() {
        this.releaseReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            CursorWindow.nativeClear(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetNumRows(this.mWindowPtr);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNumColumns(int columnNum) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeSetNumColumns(this.mWindowPtr, columnNum);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocRow() {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeAllocRow(this.mWindowPtr);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeLastRow() {
        this.acquireReference();
        try {
            CursorWindow.nativeFreeLastRow(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isNull(int row, int column) {
        return this.getType(row, column) == 0;
    }

    @Deprecated
    public boolean isBlob(int row, int column) {
        int type = this.getType(row, column);
        return type == 4 || type == 0;
    }

    @Deprecated
    public boolean isLong(int row, int column) {
        return this.getType(row, column) == 1;
    }

    @Deprecated
    public boolean isFloat(int row, int column) {
        return this.getType(row, column) == 2;
    }

    @Deprecated
    public boolean isString(int row, int column) {
        int type = this.getType(row, column);
        return type == 3 || type == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(int row, int column) {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetType(this.mWindowPtr, row - this.mStartPos, column);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(int row, int column) {
        this.acquireReference();
        try {
            byte[] byArray = CursorWindow.nativeGetBlob(this.mWindowPtr, row - this.mStartPos, column);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int row, int column) {
        this.acquireReference();
        try {
            String string2 = CursorWindow.nativeGetString(this.mWindowPtr, row - this.mStartPos, column);
            return string2;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStringToBuffer(int row, int column, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        this.acquireReference();
        try {
            CursorWindow.nativeCopyStringToBuffer(this.mWindowPtr, row - this.mStartPos, column, buffer);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int row, int column) {
        this.acquireReference();
        try {
            long l = CursorWindow.nativeGetLong(this.mWindowPtr, row - this.mStartPos, column);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int row, int column) {
        this.acquireReference();
        try {
            double d = CursorWindow.nativeGetDouble(this.mWindowPtr, row - this.mStartPos, column);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    public short getShort(int row, int column) {
        return (short)this.getLong(row, column);
    }

    public int getInt(int row, int column) {
        return (int)this.getLong(row, column);
    }

    public float getFloat(int row, int column) {
        return (float)this.getDouble(row, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putBlob(byte[] value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutBlob(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putString(String value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutString(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putLong(long value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutLong(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putDouble(double value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutDouble(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putNull(int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutNull(this.mWindowPtr, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public static CursorWindow newFromParcel(Parcel p) {
        return CREATOR.createFromParcel(p);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStartPos);
        CursorWindow.nativeWriteToParcel(this.mWindowPtr, dest);
        if ((flags & 1) != 0) {
            this.releaseReference();
        }
    }

    protected void onAllReferencesReleased() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordNewWindow(int pid, int window) {
        SparseIntArray sparseIntArray = sWindowToPidMap;
        synchronized (sparseIntArray) {
            sWindowToPidMap.put(window, pid);
            if (Log.isLoggable(STATS_TAG, 2)) {
                Log.i(STATS_TAG, "Created a new Cursor. " + this.printStats());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordClosingOfWindow(int window) {
        SparseIntArray sparseIntArray = sWindowToPidMap;
        synchronized (sparseIntArray) {
            if (sWindowToPidMap.size() == 0) {
                return;
            }
            sWindowToPidMap.delete(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printStats() {
        StringBuilder buff = new StringBuilder();
        int myPid = Process.myPid();
        int total = 0;
        SparseIntArray pidCounts = new SparseIntArray();
        SparseIntArray sparseIntArray = sWindowToPidMap;
        synchronized (sparseIntArray) {
            int size = sWindowToPidMap.size();
            if (size == 0) {
                return "";
            }
            for (int indx = 0; indx < size; ++indx) {
                int pid = sWindowToPidMap.valueAt(indx);
                int value = pidCounts.get(pid);
                pidCounts.put(pid, ++value);
            }
        }
        int numPids = pidCounts.size();
        for (int i = 0; i < numPids; ++i) {
            buff.append(" (# cursors opened by ");
            int pid = pidCounts.keyAt(i);
            if (pid == myPid) {
                buff.append("this proc=");
            } else {
                buff.append("pid " + pid + "=");
            }
            int num = pidCounts.get(pid);
            buff.append(num + ")");
            total += num;
        }
        String s = buff.length() > 980 ? buff.substring(0, 980) : buff.toString();
        return "# Open Cursors=" + total + s;
    }

    public String toString() {
        return this.getName() + " {" + Integer.toHexString(this.mWindowPtr) + "}";
    }
}

