/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.INetworkStatsService;
import android.net.NetworkStats;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.server.NetworkManagementSocketTagger;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.SocketTagger;
import java.net.Socket;
import java.net.SocketException;

public class TrafficStats {
    public static final int UNSUPPORTED = -1;
    public static final int UID_REMOVED = -4;
    public static final int UID_TETHERING = -5;
    public static final int TAG_SYSTEM_DOWNLOAD = -255;
    public static final int TAG_SYSTEM_MEDIA = -254;
    public static final int TAG_SYSTEM_BACKUP = -253;
    private static NetworkStats sActiveProfilingStart;
    private static Object sProfilingLock;

    public static void setThreadStatsTag(int tag) {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(tag);
    }

    public static int getThreadStatsTag() {
        return NetworkManagementSocketTagger.getThreadSocketStatsTag();
    }

    public static void clearThreadStatsTag() {
        NetworkManagementSocketTagger.setThreadSocketStatsTag(-1);
    }

    public static void setThreadStatsUid(int uid) {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(uid);
    }

    public static void clearThreadStatsUid() {
        NetworkManagementSocketTagger.setThreadSocketStatsUid(-1);
    }

    public static void tagSocket(Socket socket) throws SocketException {
        SocketTagger.get().tag(socket);
    }

    public static void untagSocket(Socket socket) throws SocketException {
        SocketTagger.get().untag(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart != null) {
                throw new IllegalStateException("already profiling data");
            }
            sActiveProfilingStart = TrafficStats.getDataLayerSnapshotForUid(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkStats stopDataProfiling(Context context) {
        Object object = sProfilingLock;
        synchronized (object) {
            if (sActiveProfilingStart == null) {
                throw new IllegalStateException("not profiling data");
            }
            NetworkStats profilingStop = TrafficStats.getDataLayerSnapshotForUid(context);
            NetworkStats profilingDelta = profilingStop.subtractClamped(sActiveProfilingStart);
            sActiveProfilingStart = null;
            return profilingDelta;
        }
    }

    public static void incrementOperationCount(int operationCount) {
        int tag = TrafficStats.getThreadStatsTag();
        TrafficStats.incrementOperationCount(tag, operationCount);
    }

    public static void incrementOperationCount(int tag, int operationCount) {
        INetworkStatsService statsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        int uid = Process.myUid();
        try {
            statsService.incrementOperationCount(uid, tag, operationCount);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getMobileTxPackets() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getMobileTxPackets()J", true, null);
    }

    public static long getMobileRxPackets() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getMobileRxPackets()J", true, null);
    }

    public static long getMobileTxBytes() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getMobileTxBytes()J", true, null);
    }

    public static long getMobileRxBytes() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getMobileRxBytes()J", true, null);
    }

    public static long getTxPackets(String string2) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getTxPackets(Ljava/lang/String;)J", true, null);
    }

    public static long getRxPackets(String string2) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getRxPackets(Ljava/lang/String;)J", true, null);
    }

    public static long getTxBytes(String string2) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getTxBytes(Ljava/lang/String;)J", true, null);
    }

    public static long getRxBytes(String string2) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getRxBytes(Ljava/lang/String;)J", true, null);
    }

    public static long getTotalTxPackets() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getTotalTxPackets()J", true, null);
    }

    public static long getTotalRxPackets() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getTotalRxPackets()J", true, null);
    }

    public static long getTotalTxBytes() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getTotalTxBytes()J", true, null);
    }

    public static long getTotalRxBytes() {
        return OverrideMethod.invokeL("android.net.TrafficStats#getTotalRxBytes()J", true, null);
    }

    public static long getUidTxBytes(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidTxBytes(I)J", true, null);
    }

    public static long getUidRxBytes(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidRxBytes(I)J", true, null);
    }

    public static long getUidTxPackets(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidTxPackets(I)J", true, null);
    }

    public static long getUidRxPackets(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidRxPackets(I)J", true, null);
    }

    public static long getUidTcpTxBytes(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidTcpTxBytes(I)J", true, null);
    }

    public static long getUidTcpRxBytes(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidTcpRxBytes(I)J", true, null);
    }

    public static long getUidUdpTxBytes(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidUdpTxBytes(I)J", true, null);
    }

    public static long getUidUdpRxBytes(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidUdpRxBytes(I)J", true, null);
    }

    public static long getUidTcpTxSegments(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidTcpTxSegments(I)J", true, null);
    }

    public static long getUidTcpRxSegments(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidTcpRxSegments(I)J", true, null);
    }

    public static long getUidUdpTxPackets(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidUdpTxPackets(I)J", true, null);
    }

    public static long getUidUdpRxPackets(int n) {
        return OverrideMethod.invokeL("android.net.TrafficStats#getUidUdpRxPackets(I)J", true, null);
    }

    private static NetworkStats getDataLayerSnapshotForUid(Context context) {
        INetworkStatsService statsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        int uid = Process.myUid();
        try {
            return statsService.getDataLayerSnapshotForUid(uid);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        sProfilingLock = new Object();
    }
}

